local shadowsightSpawnTime = 90; -- The time in seconds it takes for shadow sight to spawn
local secondsToHoldStoppedTimer = 5; -- Number of seconds to keep the timer frame visible after the time has run out

SST_DB = {
	["warningsEnabled"] = true,
	["x"] = 0,
	["y"] = 0,
	["relPoint"] = "CENTER",
}
local SST_DB_Default = SST_DB;

local f = CreateFrame("frame",nil,UIParent);
local fs = f:CreateFontString(nil,"OVERLAY","GameFontNormal");

local updateInterval = 1.0;
local TimeSinceLastUpdate = -1;
local seconds = shadowsightSpawnTime;

local function formatFontstring(seconds)
	-- Turns a seconds into into a mm:ss string, does not work well with anything that isn't lower than 120 sec (2min)
	local minutesString,secondsString = "","";
	local temp = 0;
	
	if seconds >= 60 then
		minutesString = "1";
		temp = 60;
	else
		minutesString = "0";
	end
	
	if (seconds - temp) < 10 then
		secondsString = "0";
	end
	
	secondsString = secondsString .. (seconds - temp);
	return minutesString .. ":" .. secondsString
end

local function stopAndResetTimer()
	-- Stops the timer completely
	f:Hide();
	fs:SetVertexColor(1,1,1,1); -- resets color
	f:SetScript("OnUpdate",nil); -- stops the timer
	seconds = shadowsightSpawnTime; -- resets seconds so its ready for a new timer
	fs:SetText(formatFontstring(shadowsightSpawnTime)); -- reset text
end

local function sendWarningMessage(secLeft)
	-- Sends a warning message in chat
	local S = SendChatMessage;
	
	if secLeft == 15 then
		S("Shadowsight in 15 sec!","PARTY");
	elseif secLeft == 10 then
		S("Shadowsight in 10 sec!","PARTY");
	elseif secLeft == 5 then
		S("Shadowsight in 5 sec!","PARTY");
	elseif secLeft == 0 then
		S("Shadowsight spawned!!!","PARTY");
	elseif secLeft < 5 then
		S("Shadowsight in " .. secLeft .. " sec!","PARTY");
	end
end

local function SST_Cmd(cmd)
	local wmsg;
	local D = DEFAULT_CHAT_FRAME;
	local YLW,RED,GRN = "|cFFFFFF66","|cFFFF0000","|cFF00FF00";
	cmd = strlower(cmd);
	
	if cmd == "show" then
		f:Show();
	elseif cmd == "hide" then
		f:Hide();
	elseif cmd == "reset" then
		f:ClearAllPoints();
		f:SetPoint("CENTER",UIParent,"CENTER",0,0)
		SST_DB["relPoint"] = "CENTER";
		SST_DB["x"] = 0;
		SST_DB["y"] = 0;
	elseif cmd == "warningmsg" then
		if SST_DB["warningsEnabled"] then 
			SST_DB["warningsEnabled"] = false; 
			D:AddMessage(YLW.."ShadowsightTimer: warningmsg|r set to ["..RED.."Off|r]");
		else 
			SST_DB["warningsEnabled"] = true; 
			D:AddMessage(YLW.."ShadowsightTimer: warningmsg|r set to ["..GRN.."On|r]");
		end
	else
		D:AddMessage(YLW.."ShadowsightTimer:|r a simple arena Shadow Sight buff countdown.");
		D:AddMessage(YLW.."Usage:|r /sst { show | hide | reset | warningmsg }");
		D:AddMessage("- "..YLW.."show:|r Shows the timer frame even outside an arena game.");
		D:AddMessage("- "..YLW.."hide:|r Hides the timer frame.");
		D:AddMessage("- "..YLW.."reset:|r Resets the timer frame's position to the center of the screen.");
		if SST_DB["warningsEnabled"] then wmsg = GRN.."On"; else wmsg = RED.."Off"; end
		D:AddMessage("- "..YLW.."warningmsg: ["..wmsg..YLW.."] |r toggles party chat warning messages on and off.");
	end
end

local function SST_OnUpdate(self,elapsed)
	TimeSinceLastUpdate = TimeSinceLastUpdate + elapsed; 	
	
	if TimeSinceLastUpdate > updateInterval then
		seconds = seconds - 1;
		
		if seconds >= 0 then
			fs:SetText(formatFontstring(seconds)); -- Updates the fontstring
			if SST_DB["warningsEnabled"] and GetNumPartyMembers() > 0 then -- If are warnings are enabled and the player is in a group
				sendWarningMessage(seconds);
			end
		end
		
		if seconds <= 0-secondsToHoldStoppedTimer then
			stopAndResetTimer();
		elseif seconds == 10 then
			fs:SetVertexColor(1,0,0,1); -- colors the text red
		end
		
		TimeSinceLastUpdate = 0;
	end
end

local function SST_OnEvent()
	if event == "ADDON_LOADED" and arg1 == "ShadowsightTimer" then
		-- Makes sure all config values are set
		if not SST_DB["relPoint"] then SST_DB["relPoint"] = SST_DB_Default["relPoint"]; end
		if not SST_DB["x"] then SST_DB["x"] = SST_DB_Default["x"]; end
		if not SST_DB["y"] then SST_DB["y"] = SST_DB_Default["y"]; end
		if not SST_DB["warningsEnabled"] then SST_DB["warningsEnabled"] = SST_DB_Default["warningsEnabled"]; end
		
		-- Set the frame to it's saved position
		f:SetPoint("CENTER",UIParent,SST_DB["relPoint"],SST_DB["x"],SST_DB["y"]);
		
		-- Setup slash commands
		SLASH_ShadowsightTimer1 = "/sst";
		SlashCmdList["ShadowsightTimer"] = SST_Cmd;
		
		-- Unregister this event so we dont get notifications about other addons being loaded
		f:UnregisterEvent("ADDON_LOADED");
		
	elseif event == "CHAT_MSG_BG_SYSTEM_NEUTRAL" then
		if string.find(arg1, "until the Arena battle begins!") then
			f:Show();
		elseif arg1 == "The Arena battle has begun!" then
			-- Starts the timer
			f:Show();
			f:SetScript("OnUpdate",SST_OnUpdate);
			
			-- Used to track when the players leaves the arena instance, so we can stop the timer if the arena battle ends before the timer has finished
			f:RegisterEvent("PLAYER_ENTERING_WORLD");
		end
	elseif event == "PLAYER_ENTERING_WORLD" then
		-- The player has left the arena and therefore the timer should stop and hide
		stopAndResetTimer();
		f:UnregisterEvent("PLAYER_ENTERING_WORLD");
	end
end

local backdrop = {
	bgFile = "Interface/Tooltips/UI-Tooltip-Background", 
	edgeFile = "", 
	tile = true, tileSize = 16, edgeSize = 16, 
	insets = { left = 0, right = 0, top = 0, bottom = 0 }
};

f:SetBackdrop(backdrop);
f:SetBackdropColor(0,0,0,0.8); -- Black with 20% transparency
f:SetWidth(37); f:SetHeight(17); 
f:SetMovable(true);
f:EnableMouse(true);
f:Hide();

f:SetScript("OnEvent",SST_OnEvent);
f:SetScript("OnMouseDown",
function() 
	f:StartMoving();
end);
f:SetScript("OnMouseUp",function() 
	f:StopMovingOrSizing();
	local _,_,relPoint,x,y = f:GetPoint();
	SST_DB["relPoint"] = relPoint;
	SST_DB["x"] = x;
	SST_DB["y"] = y;
end);
f:RegisterEvent("ADDON_LOADED");
f:RegisterEvent("CHAT_MSG_BG_SYSTEM_NEUTRAL");

local t = f:CreateTexture(nil,"OVERLAY");
t:SetWidth(16);t:SetHeight(16);
t:SetTexture("Interface\\Icons\\Spell_Shadow_EvilEye");
t:SetTexCoord(0.125,0.875,0.125,0.875);
t:SetPoint("RIGHT",f,"LEFT",5,0);

fs:SetPoint("CENTER");
fs:SetVertexColor(1,1,1,1); -- White
fs:SetText(formatFontstring(shadowsightSpawnTime));