SOM = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceEvent-2.0", "AceDB-2.0")
abacus = AceLibrary("Abacus-2.0");

SOM:RegisterChatCommand({ "/som" }, {
	type = 'group',
	args = {
		useList = {
			name = "Use List",
			desc = "Toggles the use of sell list ON/OFF.",
			type = 'toggle',
			get = "IsList",
			set = "ToggleList",
		},
		sellItem = {
			name = "Sell",
			desc = "Sells the items on the sell list.",
			type = 'execute',
			func = "Sell",
		},
		addItem = {
			name = "Add",
			desc = "Adds item to the sell list.",
			usage = "#itemText",
			type = 'text',
			get = "GetSOMTable",
			set = "SOMTableAdd",
		},
		delItem = {
			name = "Remove",
			desc = "Removes item from the sell list.",
			usage = "#itemNumber",
			type = 'text',
			get = "GetSOMTable",
			set = "SOMTableRemove",
		},
		showList = {
			name = "Show",
			desc = "Shows the sell list.",
			type = 'execute',
			func = "ShowSOMTable",
		},
		autoSell = {
			name = "Auto",
			desc = "Toggles automated mode.",
			type = 'toggle',
			get = "IsAuto",
			set = "ToggleAuto",
		},
		resetList = {
			name = "Reset",
			desc = "Resets sell list items.",
			type = 'execute',
			func = "ClearSOMTable",
		},
		showDetail = {
			name = "Detail",
			desc = "Toggles item profit detail.",
			type = 'toggle',
			get = "IsDetail",
			set = "ToggleDetail",
		},
	},
})


SOM:RegisterDB("SellOMaticDB")
SOM:RegisterDefaults("profile", {
	sellItems = {},
	auto = false,
	detail = false,
	list = false,
})

function SOM:OnInitialize()
	self:RegisterEvent("MERCHANT_SHOW");
	self:RegisterEvent("MERCHANT_CLOSED");
	SellButton:Hide();
	if self.db.profile.sellItems[1] == "ff9d9d9d" then
		table.remove(self.db.profile.sellItems[1]);
	end;
	self:SetSold(true);
	self:LoadEventBox();
end

function SOM:OnEnable()
	profit = 0;
	profit_item = 0;
end

function SOM:MERCHANT_SHOW()
	SellButton:Show();
	--AddButton:Show();
	if self.db.profile.auto and self:CheckSold() then 
		DEFAULT_CHAT_FRAME:AddMessage("Autoselling items:");
		self:Sell();
		if self:CheckSold() then self:SetSold(false) end;		
	end
end

function SOM:ShowAddBox()
	StaticPopup_Show("SOM");
end

function SOM:MERCHANT_CLOSED()
	SellButton:Hide();
	self:SetSold(true);
end

function SOM:Sell()
	local num = 0;
	local detail = "";
	for bag = 0,4,1 do
		for slot = 1, GetContainerNumSlots(bag), 1 do
			local name = GetContainerItemLink(bag,slot);
			if self.db.profile.list then
				for i,v in ipairs(self.db.profile.sellItems) do
					if name and string.find(name,self.db.profile.sellItems[i]) or name == v then
						SellOMatic_Tooltip:SetBagItem(bag, slot);
						if self.db.profile.detail then detail = ": "..abacus:FormatMoneyFull(profit_item); end;
						DEFAULT_CHAT_FRAME:AddMessage("Selling "..name..detail);
						UseContainerItem(bag,slot);
						num = num + 1;
					end
				end
			end
			if name and string.find(name,"ff9d9d9d") then
				SellOMatic_Tooltip:SetBagItem(bag, slot);
				if self.db.profile.detail then detail = ": "..abacus:FormatMoneyFull(profit_item); end;
				DEFAULT_CHAT_FRAME:AddMessage("Selling "..name..detail);
				UseContainerItem(bag,slot);
				num = num + 1;
			end
		end
	end
	if num > 0 then
		DEFAULT_CHAT_FRAME:AddMessage(num.." item(s) sold");
		self:ShowProfit();
		profit = 0;
	end
end

function SOM:ShowProfit()
	DEFAULT_CHAT_FRAME:AddMessage("You've earned "..abacus:FormatMoneyExtended(profit));
end

function SellOMatic_SetProfit()
	if (arg1) then
		profit = profit + arg1;
		profit_item = arg1;
	end
end

function SOM:CheckSold()
	return self.db.profile.sold;
end

function SOM:SetSold(value)
	self.db.profile.sold = value;
end

function SOM:GetSOMTable()
	return self.db.profile.sellItems;
end

function SOM:ClearSOMTable()
	self.db.profile.sellItems = {};
	DEFAULT_CHAT_FRAME:AddMessage("Sell list has been reset");
end

function SOM:SOMTableAdd(value)
	local name = GetItemInfo("\""..value.."\"");
	local itemName;
	local isInList = 0;
	if name ~= nil then
		itemName = name;
	else
		itemName = value;
	end;
	for i,v in ipairs(self.db.profile.sellItems) do
		if itemName and string.find(itemName,self.db.profile.sellItems[i]) or itemName == v then
			isInList = 1;
			DEFAULT_CHAT_FRAME:AddMessage(itemName.." already in sell list.");
		end;
	end;
	if isInList == 0 then
		table.insert(self.db.profile.sellItems, itemName);
		DEFAULT_CHAT_FRAME:AddMessage(itemName.." added to sell list.");
	end;
end

function SOM:SOMTableRemove(name)
	local num = 0;
	for i,v in ipairs(self.db.profile.sellItems) do
		if name and string.find(name,self.db.profile.sellItems[i]) or name == v then
			num = num + 1;
			table.remove(self.db.profile.sellItems, i);
		end;
	end;
	if num > 0 then
		DEFAULT_CHAT_FRAME:AddMessage(name.." removed from list.");
	else
		DEFAULT_CHAT_FRAME:AddMessage(name.." not found on list!");
	end;
end

function SOM:ShowSOMTable()
	if self.db.profile.sellItems[1] ~= nil then
		for i,v in ipairs(self.db.profile.sellItems) do
			DEFAULT_CHAT_FRAME:AddMessage("\["..i.."\] => "..v);
		end;
	else
		DEFAULT_CHAT_FRAME:AddMessage("Sell list is empty!");
	end;
end

function SOM:IsAuto()
	return self.db.profile.auto;
end

function SOM:ToggleAuto()
	self.db.profile.auto = not self.db.profile.auto;
end	

function SOM:IsDetail()
	return self.db.profile.detail;
end

function SOM:ToggleDetail()
	self.db.profile.detail = not self.db.profile.detail;
end	

function SOM:IsList()
	return self.db.profile.list;
end

function SOM:ToggleList()
	self.db.profile.list = not self.db.profile.list;
end

function SOM:SetCash(value)
	self.db.profile.cash = value;
end

function SOM:GetCash()
	return self.db.profile.cash;
end 

function SOM:LoadEventBox()
	StaticPopupDialogs["SOM"] = {
	text = "Type the item/part of the item text.",
	button1 = TEXT(ACCEPT),
	button2 = TEXT(CANCEL),
	OnAccept = function()
		self:SOMTableAdd(getglobal(this:GetParent():GetName().."EditBox"):GetText());
	end,
	hasEditBox = 1,
	timeout = 0,
	whileDead = 1,
	hideOnEscape = 1
	};
end

-- For Titan Sell-O-Matic
function SOM:UpdateTitanSOM()
	if TitanSOMExists then
		TitanPanelSellOMaticButton_ForceUpdate()
	end;
end
