

local o = Segui_Config;


local l_SetCurrent; -- (actionTable, rrIndex)

local l_CreateAndLoad; -- (categoryTable, actionIndex, rankIndex, actionTable)
	-- local l_RollRangeComparison; -- elem1First = (elem1, elem2)
local l_Sort; -- rrIndex = (actionTable, currRRTable)
	-- local l_RollRangeComparison; -- elem1First = (elem1, elem2)
local l_Delete; -- (actionTable, rrIndex)

local l_LoadConfig; -- (rrTable)
local l_SaveConfig; -- (rrTable)

local l_RollRangeDD_Init; -- ()
	-- local l_RollRangeDD_CreateNewButton_OnClick; -- ()

local l_TriggerTimesDD_Init; -- ()
	-- local l_TriggerTimesDD_Button_OnClick; -- (triggerBits, doRemove)
local l_TriggerTimesDD_SetupText; -- (triggerBits)

local l_DeleteButton_OnClick; -- ()
local l_t_OnGUILoaded; -- (configFrame)


local l_CONFIG_FRAME;
local l_MIN_ROLL = 1;
local l_MAX_ROLL = 1000;
local l_TRIGGER_TIMES_LIST = {
	{ text = o.Localization.TRIGGERTIME_CAST_START, bits = 0x1 };
	{ text = o.Localization.TRIGGERTIME_CAST_STOP, bits = 0x2 };
	{ text = o.Localization.TRIGGERTIME_CHANNEL_START, bits = 0x8 };
	{ text = o.Localization.TRIGGERTIME_CHANNEL_STOP, bits = 0x10 };
	{ text = o.Localization.TRIGGERTIME_INTERRUPT, bits = 0x4 };
};


local l_currTriggerBits;



function l_SetCurrent(actionTable, rrIndex)
	local rrTable;
	if (rrIndex ~= nil and actionTable ~= nil) then
		local rollRanges = actionTable.rollRanges;
		if (rollRanges ~= nil) then
			rrTable = rollRanges[rrIndex];
		end
	end
	
	if (rrTable == nil or rrTable ~= o.currRRTable) then
		if (o.currRRTable ~= nil) then
			l_SaveConfig(o.currRRTable);
		end
		
		if (rrTable == nil) then
			rrIndex = nil;
		end
		l_LoadConfig(rrTable);
		o.Entries_SetCurrent(rrTable, 1);
		o.currRRIndex = rrIndex;
		o.currRRTable = rrTable;
	end
end

o.RollRanges_SetCurrent = l_SetCurrent;




function l_CreateAndLoad(categoryTable, actionIndex, rankIndex, actionTable)
	if (actionTable == nil) then
		local actionName = categoryTable.actionNames[actionIndex];
		if (rankIndex ~= nil) then
			actionName = (actionName .. "(" .. categoryTable.rankNamesByActions[actionName][rankIndex] .. ")");
		end
		actionTable = o.Actions_CreateTable_UsingToggleFuncs(categoryTable, actionName);
		o.currActionTable = actionTable;
	end
	
	local rrTable = o.Segui.Config_CreateRollRangeTable(actionTable);
	rrTable.minRoll = l_MIN_ROLL;
	rrTable.maxRoll = l_MAX_ROLL;
	
	local rrIndex = l_Sort(actionTable, rrTable);
	
	l_SetCurrent(actionTable, rrIndex);
end



do
	local l_RollRangeComparison;
	local tablesort = table.sort;
	
	function l_Sort(actionTable, currRRTable)
		local rollRanges = actionTable.rollRanges;
		tablesort(rollRanges, l_RollRangeComparison);
		local rrIndex = 1;
		while (rollRanges[rrIndex] ~= currRRTable) do
			rrIndex = (rrIndex + 1);
		end
		return rrIndex;
	end
	
	
	do
		function l_RollRangeComparison(rr1, rr2)
			local min1, min2 = rr1.minRoll, rr2.minRoll;
			if (min1 == min2) then
				return (rr1.maxRoll < rr2.maxRoll);
			else
				return (min1 < min2);
			end
		end
	end
end



do
	local tableremove = table.remove;
	
	function l_Delete(actionTable, rrIndex)
		if (actionTable == nil or actionTable.rollRanges == nil) then
			return;
		end
		
		tableremove(actionTable.rollRanges, rrIndex);
		
		o.currRRIndex = nil;
		o.currRRTable = nil;
		o.currEntryIndex = nil;
		o.currEntryTable = nil;
		l_SetCurrent(actionTable, nil);
	end
end




function l_LoadConfig(rrTable)
	local configBox = l_CONFIG_FRAME.ROLLRANGE_CONFIG_BOX;
	
	if (rrTable == nil) then
		configBox:SetBackdropColor(0.7, 0.7, 0.7);
		configBox.MIN_ROLL_EB:EnableMouse(false);
		configBox.MAX_ROLL_EB:EnableMouse(false);
		configBox.REPEAT_DELAY_EB:EnableMouse(false);
		configBox.TRIGGER_TIMES_DD.BUTTON:Disable();
		configBox.DELETE_BUTTON:Disable();
		
		l_CONFIG_FRAME.ROLLRANGE_DD.TEXT:SetText("");
		
		configBox.MIN_ROLL_EB:SetText("");
		configBox.MAX_ROLL_EB:SetText("");
		configBox.REPEAT_DELAY_EB:SetText("");
		configBox.TRIGGER_TIMES_DD.TEXT:SetText("");
		l_currTriggerBits = nil;
		return;
	end
	
	configBox:SetBackdropColor(0.4, 0.4, 0.4);
	configBox.MIN_ROLL_EB:EnableMouse(true);
	configBox.MAX_ROLL_EB:EnableMouse(true);
	configBox.REPEAT_DELAY_EB:EnableMouse(true);
	local triggerTimesDD = configBox.TRIGGER_TIMES_DD;
	if (triggerTimesDD.enabled == true) then
		triggerTimesDD.BUTTON:Enable();
	else
		triggerTimesDD.BUTTON:Disable();
	end
	configBox.DELETE_BUTTON:Enable();
	
	l_CONFIG_FRAME.ROLLRANGE_DD.TEXT:SetText(rrTable.minRoll .. " - " .. rrTable.maxRoll);
	
	configBox.MIN_ROLL_EB:SetNumber(rrTable.minRoll);
	configBox.MAX_ROLL_EB:SetNumber(rrTable.maxRoll);
	configBox.REPEAT_DELAY_EB:SetNumber(rrTable.repeatDelay or 0);
	local triggerBits = rrTable.triggerBits;
	l_currTriggerBits = triggerBits;
	l_TriggerTimesDD_SetupText(triggerBits);
end



function l_SaveConfig(rrTable)
	local configBox = l_CONFIG_FRAME.ROLLRANGE_CONFIG_BOX;
	local minRoll = configBox.MIN_ROLL_EB:GetNumber();
	if (minRoll < l_MIN_ROLL or minRoll > l_MAX_ROLL) then
		minRoll = l_MIN_ROLL;
	end
	local maxRoll = configBox.MAX_ROLL_EB:GetNumber();
	if (maxRoll < l_MIN_ROLL or (minRoll ~= nil and maxRoll < minRoll) or maxRoll > l_MAX_ROLL) then
		maxRoll = l_MAX_ROLL;
	end
	local triggerBits = l_currTriggerBits;
	if (triggerBits == 0x0) then
		triggerBits = nil;
	end
	local repeatDelay = configBox.REPEAT_DELAY_EB:GetNumber();
	if (repeatDelay < 1) then
		repeatDelay = nil;
	end
	
	local needsSorting = (rrTable.minRoll ~= minRoll or rrTable.maxRoll ~= maxRoll);
	rrTable.minRoll = minRoll;
	rrTable.maxRoll = maxRoll;
	rrTable.triggerBits = triggerBits;
	rrTable.repeatDelay = repeatDelay;
	rrTable.timeLastSent = nil;
	
	if (needsSorting == true) then
		o.currRRIndex = l_Sort(actionTable, rrTable);
	end
	l_LoadConfig(rrTable);
end

o.RollRanges_SaveConfig = l_SaveConfig;




do
	local l_RollRangeDD_CreateNewButton_OnClick;
	local loc_CREATE_NEW_ROLLRANGE = o.Localization.CREATE_NEW_ROLLRANGE;
	
	function l_RollRangeDD_Init()
		if (o.currCategoryTable == nil or o.currActionIndex == nil) then
			return;
		end
		
		local AddButton = UIDropDownMenu_AddButton;
		local buttonInfo = {};
		
		local actionTable = o.currActionTable;
		if (actionTable ~= nil) then
			buttonInfo.func = l_SetCurrent;
			buttonInfo.arg1 = actionTable;
			local rollRanges = actionTable.rollRanges;
			if (rollRanges ~= nil) then
				for rrIndex, rrTable in ipairs(rollRanges) do
					buttonInfo.text = (rrTable.minRoll .. " - " .. rrTable.maxRoll);
					buttonInfo.arg2 = rrIndex;
					buttonInfo.checked = (rrTable.entries ~= nil);
					AddButton(buttonInfo, 1);
				end
			end
		end
		
		buttonInfo.func = l_RollRangeDD_CreateNewButton_OnClick;
		buttonInfo.text = loc_CREATE_NEW_ROLLRANGE;
		buttonInfo.arg1 = nil;
		buttonInfo.arg2 = nil;
		buttonInfo.checked = nil;
		buttonInfo.notCheckable = true;
		AddButton(buttonInfo, 1);
	end
	
	
	do
		function l_RollRangeDD_CreateNewButton_OnClick()
			l_CreateAndLoad(o.currCategoryTable, o.currActionIndex, o.currActionRankIndex, o.currActionTable);
		end
	end
end




do
	local l_TriggerTimesDD_Button_OnClick;
	local bitband = bit.band;
	
	function l_TriggerTimesDD_Init()
		local AddButton = UIDropDownMenu_AddButton;
		local buttonInfo = {};
		buttonInfo.func = l_TriggerTimesDD_Button_OnClick;
		buttonInfo.keepShownOnClick = true;
		
		local bits;
		for index, triggerTimeData in ipairs(l_TRIGGER_TIMES_LIST) do
			buttonInfo.text = triggerTimeData.text;
			bits = triggerTimeData.bits;
			buttonInfo.arg1 = bits;
			buttonInfo.checked = (l_currTriggerBits ~= nil and bitband(l_currTriggerBits, bits) == bits);
			AddButton(buttonInfo, 1);
		end
	end
	
	
	do
		local bitband = bit.band;
		local bitbor = bit.bor;
		local bitbxor = bit.bxor;
		
		function l_TriggerTimesDD_Button_OnClick(triggerBits)
			if (l_currTriggerBits == nil) then
				l_currTriggerBits = 0x0;
			end
			if (bitband(l_currTriggerBits, triggerBits) == triggerBits) then
				l_currTriggerBits = bitbxor(l_currTriggerBits, triggerBits);
			else
				l_currTriggerBits = bitbor(l_currTriggerBits, triggerBits);
			end
			l_TriggerTimesDD_SetupText(l_currTriggerBits);
		end
	end
end


do
	local bitband = bit.band;
	
	function l_TriggerTimesDD_SetupText(triggerBits)
		local text, bits;
		for index, triggerTimeData in ipairs(l_TRIGGER_TIMES_LIST) do
			bits = triggerTimeData.bits;
			if (triggerBits ~= nil and bitband(triggerBits, bits) == bits) then
				text = (((text ~= nil and (text .. " | ")) or "") .. triggerTimeData.text);
			end
		end
		l_CONFIG_FRAME.ROLLRANGE_CONFIG_BOX.TRIGGER_TIMES_DD.TEXT:SetText(text or "");
	end
end




function l_DeleteButton_OnClick()
	l_Delete(o.currActionTable, o.currRRIndex);
end



function l_t_OnGUILoaded(configFrame)
	l_t_OnGUILoaded = nil;
	o.RollRanges_t_OnGUILoaded = nil;
	
	l_CONFIG_FRAME = configFrame;
	configFrame.ROLLRANGE_DD.initialize = l_RollRangeDD_Init;
	configFrame.ROLLRANGE_CONFIG_BOX.TRIGGER_TIMES_DD.initialize = l_TriggerTimesDD_Init;
	configFrame.ROLLRANGE_CONFIG_BOX.DELETE_BUTTON:SetScript("OnClick", l_DeleteButton_OnClick);
end

o.RollRanges_t_OnGUILoaded = l_t_OnGUILoaded;

