

local f = Segui_Config.Localization;

if (f.NOT_LOADED == nil) then return; end
-- This localization file is the fallback in case no others load, so the following line should remain commented out.
--if (GetLocale() ~= "enUS") then return; end
f.NOT_LOADED = nil;



f.TRIGGERTIME_CAST_START = ("Cast Start");
f.TRIGGERTIME_CAST_STOP = ("Cast Stop");
f.TRIGGERTIME_CHANNEL_START = ("Channel Start");
f.TRIGGERTIME_CHANNEL_STOP = ("Channel Stop");
f.TRIGGERTIME_INTERRUPT = ("Interrupt");

f.ERROR_INVALID_BASIC_EMOTE = ("Segui: Error: The text in the message editbox does not correspond to any known basic emote. Try typing a number from 1 to 171 into the editbox instead, and then clicking \"Save Changes\" to see which basic emote corresponds to that number.");

f.MESSAGETYPE_CHANNEL = ("Channel");
f.MESSAGETYPE_EMOTE_BASIC = ("Emote (Basic)");
f.MESSAGETYPE_EMOTE_CUSTOM = ("Emote (Custom)");
f.MESSAGETYPE_RAID_OR_PARTY = ("Raid or Party");



f.CATEGORY_GLOBAL_HOTKEYS = ("Global Hotkeys");
f.GLOBAL_HOTKEY_ACTION_FORMAT = ("Hotkey Action #%s");
f.CATEGORY_GLOBAL_HOTKEYS_ADDITIONAL_TOOLTIP_TEXT = ("This particular Category has the special property of being shared between all characters instead of being local to this character like the others.\n\nIn addition to binding hotkeys to activate Actions within this Category, you can also activate them from macros by using the line \"/script Segui(#)\" where # is the number of the Action, from 1 to 30.");

f.CATEGORY_MESSAGE_CHAT_EVENTS = ("Messages: Chat");
f.CATEGORY_MESSAGE_CHAT_EVENTS_CREATION_POPUP_TEXT = ("Enter custom text that will match one or more of the patterns for this sub-Category:");
f.CATEGORY_MESSAGE_CHAT_EVENTS_ADDITIONAL_TOOLTIP_TEXT = ("This particular Category consists of sub-Categories which represent various patterns of incoming messages which relate to chat. When one of these texts is received, it is checked against every Action (which you create) within the given sub-Category to find matches.\n\nTo check arguments other than just the text, such as the author, place tokens of the format \"<# expected>\", where \"#\" is the argument number and \"expected\" is the string matching pattern you want to use on the argument value, at the beginning of the custom Action text and delimit the rest of it by formatting it like this: \"argumentChecks && textToMatch\".\n\nSub-Categories prefixed as \"Player\" are player-generated messages, while sub-Categories prefixed as \"System\" are client- or server-generated messages.\n\nAdvanced Note: Event arguments and substring captures from the custom Action texts will be passed to all Entries within the Action, replacing tokens of the format \"<arg:#>\" and \"<capture:#>\" within the Entry's message text.");
f.MESSAGE_CHAT_EVENTS_LIST = {
	CHAT_MSG_AFK = ("Player: AFK auto-response");
	CHAT_MSG_BATTLEGROUND = ("Player: Battleground chat");
	CHAT_MSG_BATTLEGROUND_LEADER = ("Player: Battleground Leader chat");
	CHAT_MSG_BG_SYSTEM_ALLIANCE = ("System: Battleground announcement, Alliance-specific");
	CHAT_MSG_BG_SYSTEM_HORDE = ("System: Battleground announcement, Horde-specific");
	CHAT_MSG_BG_SYSTEM_NEUTRAL = ("System: Battleground announcement, neutral");
	CHAT_MSG_CHANNEL = ("Player: Numbered chat channel chat");
	CHAT_MSG_CHANNEL_JOIN = ("System: Numbered chat channel: someone joins");
	CHAT_MSG_CHANNEL_LEAVE = ("System: Numbered chat channel: someone leaves");
	CHAT_MSG_CHANNEL_NOTICE = ("System: Numbered chat channel: you join or leave");
	CHAT_MSG_CHANNEL_NOTICE_USER = ("System: Numbered chat channel: a property of the channel changed");
	CHAT_MSG_DND = ("Player: DND auto-response");
	CHAT_MSG_EMOTE = ("Player: Emote (Custom) chat");
	CHAT_MSG_GUILD = ("Player: Guild chat");
	CHAT_MSG_IGNORED = ("System: Ignored auto-response");
	CHAT_MSG_MONSTER_EMOTE = ("System: Creature emote");
	CHAT_MSG_MONSTER_SAY = ("System: Creature say");
	CHAT_MSG_MONSTER_WHISPER = ("System: Creature whisper");
	CHAT_MSG_MONSTER_YELL = ("System: Creature yell");
	CHAT_MSG_OFFICER = ("Player: Officer chat");
	CHAT_MSG_PARTY = ("Player: Party chat");
	CHAT_MSG_RAID = ("Player: Raid chat");
	CHAT_MSG_RAID_BOSS_EMOTE = ("System: Raid boss emote");
	CHAT_MSG_RAID_LEADER = ("Player: Raid Leader chat");
	CHAT_MSG_RAID_WARNING = ("Player: Raid Warning chat");
	CHAT_MSG_SAY = ("Player: Say chat");
	CHAT_MSG_SYSTEM = ("System: Generic announcement");
	CHAT_MSG_TEXT_EMOTE = ("Player: Emote (Basic) chat");
	CHAT_MSG_WHISPER = ("Player: Whisper chat");
	CHAT_MSG_YELL = ("Player: Yell chat");
};
do
	local tooltipTexts = {};
	f.CATEGORY_MESSAGE_CHAT_EVENTS_ADDITIONAL_TOOLTIP_TEXTS = tooltipTexts;
	for eventName in pairs(f.MESSAGE_CHAT_EVENTS_LIST) do
		tooltipTexts[eventName] = ("This sub-Category's message event is called \"%s\". Visit http://www.wowwiki.com/Patterns_fired_from_each_CHAT_MSG_events for examples of each pattern for this event."):format(eventName);
	end
end

f.CATEGORY_MESSAGE_OTHER_EVENTS = ("Messages: Other");
f.CATEGORY_MESSAGE_OTHER_EVENTS_CREATION_POPUP_TEXT = ("Enter custom text that will match one or more of the patterns for this sub-Category:");
f.CATEGORY_MESSAGE_OTHER_EVENTS_ADDITIONAL_TOOLTIP_TEXT = ("This particular Category consists of sub-Categories which represent various patterns of incoming messages which do not relate directly to player-created chat. When one of these texts is received, it is checked against every Action (which you create) within the given sub-Category to find matches.\n\nTo check arguments other than just the text, such as the author, place tokens of the format \"<# expected>\", where \"#\" is the argument number and \"expected\" is the string matching pattern you want to use on the argument value, at the beginning of the custom Action text and delimit the rest of it by formatting it like this: \"argumentChecks && textToMatch\".\n\nAdvanced Note: Event arguments and substring captures from the custom Action texts will be passed to all Entries within the Action, replacing tokens of the format \"<arg:#>\" and \"<capture:#>\" within the custom Action text.");
f.MESSAGE_OTHER_EVENTS_LIST = {
	CHAT_MSG_COMBAT_FACTION_CHANGE = ("Reputation changes");
	CHAT_MSG_COMBAT_HONOR_GAIN = ("Honor is gained");
	CHAT_MSG_COMBAT_XP_GAIN = ("Experience is gained");
	CHAT_MSG_LOOT = ("Loot is received, created, or rolled upon");
	CHAT_MSG_MONEY = ("Money is received");
	CHAT_MSG_SKILL = ("Skill is learned or improved");
};
do
	local tooltipTexts = {};
	f.CATEGORY_MESSAGE_OTHER_EVENTS_ADDITIONAL_TOOLTIP_TEXTS = tooltipTexts;
	for eventName in pairs(f.MESSAGE_OTHER_EVENTS_LIST) do
		tooltipTexts[eventName] = ("This sub-Category's message event is called \"%s\". Visit http://www.wowwiki.com/Patterns_fired_from_each_CHAT_MSG_events for examples of each pattern for this event."):format(eventName);
	end
end

f.CATEGORY_COMBAT_EVENTS = ("Combat Events");
f.CATEGORY_COMBAT_EVENTS_CREATION_POPUP_TEXT = ("Enter a series of argument checks that will match one or more combat events:");
f.CATEGORY_COMBAT_EVENTS_ADDITIONAL_TOOLTIP_TEXT = ("This particular Category pertains to all combat events. Each time one of these events is received, every Action in this Category will be checked to determine whether it is a match.\n\nEach Action specifies which arguments of the event must be matches for the Action to trigger. The format used for this specification should be \"<# expected><# expected> ...\", where \"#\" is the argument index and \"expected\" is the string matching pattern or hexadecimal value you want to check against the argument.\n\nThe argument indexes are normalized, as such:\n1 - combat event name\n2-4 - source unit GUID, name, and flags\n5-7 - destination unit GUID, name, and flags\n8-10 - event prefix information\n11-18 - event suffix information\nFor extensive details on all of the possible event prefix/suffix combinations and their respective arguments, see http://www.wowwiki.com/COMBAT_LOG_EVENT_Details.\n\nAdvanced Note: Event arguments will be passed to all Entries within the Action, replacing tokens of the format \"<arg:#>\" within each Entry's message text. For example, \"<arg:1>\" would be replaced with argument 1, the combat event name.");

f.CATEGORY_MISC_EVENTS = ("Misc. Events");
f.MISC_EVENTS_LIST = {
	TRADE_OPENED = ("Trade window is opened");
	PLAYER_RESURRECTION = ("You resurrect");
	PLAYER_BELOW_TWENTY_HEALTH = ("Your health goes below 20%");
	PLAYER_BELOW_TWENTY_MANA = ("Your mana goes below 20%");
	RELOAD_UI = ("UI is reloaded");
	ENTER_COMBAT = ("Combat entered");
	LEAVE_COMBAT = ("Combat left");
};

f.CATEGORY_MISC_ACTIONS = ("Misc. Actions");
f.CATEGORY_MISC_ACTIONS_ADDITIONAL_TOOLTIP_TEXT = ("This Category is comprised entirely of Actions which do not come from the spellbook, but still count as spellcasts or ability uses by the game. This includes things such as drinking, opening a chest, or summoning a non-combat pet. It may also include Actions you once had in the spellbook but no longer have (such as from talents).\n\nTo find the exact name of such an Action so that you can add it to the list, type \"/segui detective\" to toggle the Action Detective, then perform the Action.");
f.CATEGORY_MISC_ACTIONS_CREATION_POPUP_TEXT = ("Enter the name of a miscellaneous Action, as it appears in the Action Detective (\"/segui detective\"):");


f.CATEGORY_DD_TITLE = ("Category...");
f.CATEGORY_DD_TOOLTIP_TITLE = ("Category");
f.CATEGORY_DD_TOOLTIP_TEXT = ("The speech Category from which to select an Action.\n\nIf a Category name has a checkmark next to it, then there exists data for that Category.");
f.CATEGORY_DD_ADDITIONAL_TOOLTIP_TEXT = ("Some Categories have special properties. Check this tooltip again after selecting a Category to see if it has any additional notes.");
f.ACTION_DD_TITLE = ("Action...");
f.ACTION_DD_TOOLTIP_TITLE = ("Action");
f.ACTION_DD_TOOLTIP_TEXT = ("The Action (spell, ability, event, etcetera) from which to select a Roll Range.\n\nIf an Action name has a checkmark next to it, then there exists data for that Action.\n\nWhen an Action is triggered, a 1 - 1000 roll takes place, and any Roll Ranges that encompass the random number will be triggered.");
f.CREATE_NEW_ACTION = ("Create new Action");
f.RENAME_ACTION_POPUP_TEXT = ("Enter a new name for the Action\n\"%s\":");
f.ROLLRANGE_DD_TITLE = ("Roll Range...");
f.ROLLRANGE_DD_TOOLTIP_TITLE = ("Roll Range");
f.ROLLRANGE_DD_TOOLTIP_TEXT = ("The Roll Range (a low-to-high range of numbers which, maximum of 1 to 1000) from which to select an Entry.\n\nIf a range has a checkmark next to it, then there exists data for that Roll Range.\n\nWhen a Roll Range is triggered, all Entries belonging to it are triggered in sequential order.");
f.CREATE_NEW_ROLLRANGE = ("Create new Roll Range");
f.ENTRY_DD_TITLE = ("Entry...");
f.ENTRY_DD_TOOLTIP_TITLE = ("Entry");
f.ENTRY_DD_TOOLTIP_TEXT = ("The Entry (configuration of message, chat type, language, etcetera) to be sent.\n\nWhen an Entry is triggered, the configured speech is actually sent.");
f.CREATE_NEW_ENTRY = ("Create new Entry");

f.ACTION_CONFIG_BOX_TITLE = ("Action Config...");
f.ACTION_CONFIG_BOX_REPEAT_DELAY_EB_TITLE = ("Minimum repeat delay:");
f.ACTION_CONFIG_BOX_REPEAT_DELAY_EB_TOOLTIP_TITLE = ("Minimum Repeat Delay");
f.ACTION_CONFIG_BOX_REPEAT_DELAY_EB_TOOLTIP_TEXT = ("The time, in seconds, up to 9999 seconds, to delay before allowing this Action to be triggered again after it has been triggered once. Leave blank or enter 0 to have no delay.");
f.ACTION_CONFIG_BOX_ALWAYS_TRY_SEND_CB_TEXT = ("Always try to activate a Roll Range");
f.ACTION_CONFIG_BOX_ALWAYS_TRY_SEND_CB_TOOLTIP_TITLE = ("Always Try to Activate a Roll Range");
f.ACTION_CONFIG_BOX_ALWAYS_TRY_SEND_CB_TOOLTIP_TEXT = ("If this is enabled, then when this Action is triggered, if no Roll Ranges are activated as a result of the standard 1-1000 roll, a single random Roll Range which is not on cooldown will be chosen to trigger instead, if any such are available.");
f.ACTION_CONFIG_BOX_RENAME_ACTION_BUTTON_TEXT = ("Rename");
f.ACTION_CONFIG_BOX_RENAME_ACTION_BUTTON_TOOLTIP_TITLE = ("Rename");
f.ACTION_CONFIG_BOX_RENAME_ACTION_BUTTON_TOOLTIP_TEXT = ("Click to rename this Action.");
f.ACTION_CONFIG_BOX_DELETE_ACTION_BUTTON_TOOLTIP_TEXT = ("Click to completely delete this Action and any Roll Ranges and Entries it contains.");

f.ROLLRANGE_CONFIG_BOX_TITLE = ("Roll Range Config...");
f.ROLLRANGE_CONFIG_BOX_MIN_ROLL_EB_TITLE = ("Min roll:");
f.ROLLRANGE_CONFIG_BOX_MIN_ROLL_EB_TOOLTIP_TITLE = ("Minimum Roll");
f.ROLLRANGE_CONFIG_BOX_MIN_ROLL_EB_TOOLTIP_TEXT = ("If a random 1 - 1000 roll lands at or above this number and at or below the maximum roll number, Entries in this Roll Range will be triggered.");
f.ROLLRANGE_CONFIG_BOX_MAX_ROLL_EB_TITLE = ("Max roll:");
f.ROLLRANGE_CONFIG_BOX_MAX_ROLL_EB_TOOLTIP_TITLE = ("Maximum Roll");
f.ROLLRANGE_CONFIG_BOX_MAX_ROLL_EB_TOOLTIP_TEXT = ("If a random 1 - 1000 roll lands at or below this number and at or above the minimum roll number, Entries in this Roll Range will be triggered.");
f.ROLLRANGE_CONFIG_BOX_TRIGGER_TIMES_DD_TITLE = ("Trigger Times...");
f.ROLLRANGE_CONFIG_BOX_TRIGGER_TIMES_DD_TOOLTIP_TITLE = ("Trigger Times");
f.ROLLRANGE_CONFIG_BOX_TRIGGER_TIMES_DD_TOOLTIP_TEXT = ("Select which times this Roll Range should be allowed to trigger.\n\nNotes and Idiosyncrasies:\n1: Instant abilities do not have a \"Cast Start\" or \"Interrupt\", only a \"Cast Stop\".\n\n2: Channeled abilities actually trigger both \"Cast\" and \"Channel\" mechanics, the former triggering from whatever starts the channel, and the latter triggering from the channel itself.\n\n3: Cancelling a channel will trigger \"Channel Stop\"; cancelling a cast will not trigger anything.\n\n4: Each of these times initiates a separate 1 - 1000 roll.");
f.ROLLRANGE_CONFIG_BOX_REPEAT_DELAY_EB_TITLE = ("Minimum repeat delay:");
f.ROLLRANGE_CONFIG_BOX_REPEAT_DELAY_EB_TOOLTIP_TITLE = ("Minimum Repeat Delay");
f.ROLLRANGE_CONFIG_BOX_REPEAT_DELAY_EB_TOOLTIP_TEXT = ("The time, in seconds, up to 9999 seconds, to delay before allowing this Roll Range to be triggered again after it has been triggered once. Leave blank or enter 0 to have no delay.");
f.ROLLRANGE_CONFIG_BOX_DELETE_ROLLRANGE_BUTTON_TOOLTIP_TEXT = ("Click to completely delete this Roll Range and any Entries it contains.");

f.ENTRY_CONFIG_BOX_TITLE = ("Entry Config...");
f.ENTRY_CONFIG_BOX_MESSAGE_EB_TITLE = ("Message:");
f.ENTRY_CONFIG_BOX_MESSAGE_EB_TOOLTIP_TITLE = ("Message");
f.ENTRY_CONFIG_BOX_MESSAGE_EB_TOOLTIP_TEXT = ("Enter here the text of the message you wish to send for this Entry. In the case of the Basic Emote chat type, this is the name of the emote to send.\n\nYou can specify a unit's name to be substituted in dynamically when this Entry is triggered by inserting macrotext that evaluates to a unit token. A unit token is something like \"target\", \"focus\", or \"raid1\". Macrotext is the evaluation language used for macro conditionals, such as for the \"/cast\" command, but in this case it determines the unit token to be used.\n\nExamples:\n\n<unit mouseover>\nThis will be substituted for the name of the current mouseover unit.\n\n<unit [target=mouseover, exists] mouseover; target]>\nThis will evaluate to \"mouseover\" if the mouseover unit exists, or \"target\" otherwise, and then the name of that unit will be substituted in.\n\nMessages cannot be longer than 255 characters, after all unit token substitution has taken place.");
f.ENTRY_CONFIG_BOX_REPEAT_DELAY_EB_TITLE = ("Minimum repeat delay:");
f.ENTRY_CONFIG_BOX_REPEAT_DELAY_EB_TOOLTIP_TITLE = ("Minimum Repeat Delay");
f.ENTRY_CONFIG_BOX_REPEAT_DELAY_EB_TOOLTIP_TEXT = ("The time, in seconds, up to 9999 seconds, to delay before allowing this Entry to be triggered again after it has been triggered once. Leave blank or enter 0 to have no delay.");
f.ENTRY_CONFIG_BOX_ACTIVATION_DELAY_EB_TITLE = ("Activation delay:");
f.ENTRY_CONFIG_BOX_ACTIVATION_DELAY_EB_TOOLTIP_TITLE = ("Activation Delay");
f.ENTRY_CONFIG_BOX_ACTIVATION_DELAY_EB_TOOLTIP_TEXT = ("The time, in seconds, up to 30 seconds, to delay before actually sending this Entry after it has been triggered. Leave blank or enter 0 to have no delay.");
f.ENTRY_CONFIG_BOX_MESSAGE_TYPE_DD_TITLE = ("Message Type...");
f.ENTRY_CONFIG_BOX_MESSAGE_TYPE_DD_TOOLTIP_TITLE = ("Message Type");
f.ENTRY_CONFIG_BOX_MESSAGE_TYPE_DD_TOOLTIP_TEXT = ("The message type to use for this Entry.\n\nThe \"Raid or Party\" type will send the message to raid chat if you're in a raid, or else party chat if you're not in a raid but are in a party.\n\nIf \"Channel\" is selected, a valid channel name must be supplied in the Channel / Target editbox.\n\nIf \"Whisper\" is selected, a valid player name (or macrotext that evaluates to a unit token, like \"<unit [target=mouseover, exists] mouseover; target]>\" which evaluates to \"mouseover\" if the mouseover unit exists, or \"target\" otherwise) must be supplied in the Channel / Target editbox.\n\nIf \"Emote (Basic)\" is selected, a valid player name (or macrotext like the previous example) may optionally be supplied in the Channel / Target editbox to direct the emote toward that player if they are nearby.");
f.ENTRY_CONFIG_BOX_CHANNEL_OR_TARGET_EB_TITLE = ("Channel / Target...");
f.ENTRY_CONFIG_BOX_CHANNEL_OR_TARGET_EB_TOOLTIP_TITLE = ("Channel / Target");
f.ENTRY_CONFIG_BOX_CHANNEL_OR_TARGET_EB_TOOLTIP_TEXT = ("If the \"Channel\" chat type is selected, a valid channel name must be supplied in this editbox.\n\nIf the \"Whisper\" chat type is selected, a valid player name (or macrotext that evaluates to a unit token, like \"<unit [target=mouseover, exists] mouseover; target]>\" which evaluates to \"mouseover\" if the mouseover unit exists, or \"target\" otherwise) must be supplied in this editbox.\n\nIf the \"Emote (Basic)\" chat type is selected, a valid player name (or macrotext like the previous example) may optionally be supplied in this editbox to direct the emote toward that player if they are nearby.");
f.ENTRY_CONFIG_BOX_LANGUAGE_DD_TITLE = ("Language...");
f.ENTRY_CONFIG_BOX_LANGUAGE_DD_TOOLTIP_TITLE = ("Language");
f.ENTRY_CONFIG_BOX_LANGUAGE_DD_TOOLTIP_TEXT = ("The language in which this Entry should be sent.\n\nYou can only choose languages that appear on your Skills tab.");
f.ENTRY_CONFIG_BOX_DELETE_ENTRY_BUTTON_TOOLTIP_TEXT = ("Click to completely delete this Entry.");

f.SAVE_CHANGES_BUTTON_TEXT = ("Save Changes");

