

local o = Segui_Config;


local l_SetCurrent; -- (rrTable, entryIndex)

local l_CreateAndLoad; -- (rrTable)
local l_Delete; -- (rrTable, entryIndex)

local l_LoadConfig; -- (entryIndex, entryTable)
local l_SaveConfig; -- (entryIndex, entryTable)

local l_EntryDD_Init; -- ()

local l_MessageTypeDD_Init; -- ()
	-- local l_MessageTypeDD_Button_OnClick; -- (messageTypeData)
local l_LanguageDD_Init; -- ()
	-- local l_LanguageDD_Button_OnClick; -- (languageIndex, language)

local l_DeleteButton_OnClick; -- ()
local l_t_OnGUILoaded; -- (configFrame)


local type = type; -- SetCurrent, CreateAndLoad, Delete, EntryDD_Init
local GetLanguageByIndex = GetLanguageByIndex; -- LoadConfig, LanguageDD_Init


local l_CONFIG_FRAME;
local l_MESSAGE_TYPE_LIST = {
	{ text = CHAT_MSG_SAY, messageType = 8 },
	{ text = CHAT_MSG_YELL, messageType = 10 },
	{ text = o.Localization.MESSAGETYPE_EMOTE_BASIC, messageType = 2 },
	{ text = o.Localization.MESSAGETYPE_EMOTE_CUSTOM, messageType = 3 },
	{ text = WHISPER, messageType = 9 },
	{ text = CHAT_MSG_GUILD, messageType = 4 },
	{ text = CHAT_MSG_OFFICER, messageType = 5 },
	{ text = CHAT_MSG_PARTY, messageType = 6 },
	{ text = CHAT_MSG_RAID, messageType = 7 },
	{ text = o.Localization.MESSAGETYPE_RAID_OR_PARTY, messageType = 13 },
	{ text = CHAT_MSG_RAID_WARNING, messageType = 11 },
	{ text = CHAT_MSG_BATTLEGROUND, messageType = 12 },
	{ text = o.Localization.MESSAGETYPE_CHANNEL, messageType = 1 },
};


local l_currMessageTypeIndex;
local l_currLanguageIndex;




function l_SetCurrent(rrTable, entryIndex)
	local entryTable;
	if (entryIndex ~= nil and rrTable ~= nil) then
		local entries = rrTable.entries;
		if (entries ~= nil) then
			if (type(entries[1]) == "string") then
				if (entryIndex == 1) then
					entryTable = entries;
				end
			else
				entryTable = entries[entryIndex];
			end
		end
	end
	
	if (entryTable == nil or entryTable ~= o.currEntryTable) then
		if (o.currEntryTable ~= nil) then
			l_SaveConfig(o.currEntryIndex, o.currEntryTable);
		end
		
		if (entryTable == nil) then
			entryIndex = nil;
		end
		l_LoadConfig(entryIndex, entryTable);
		o.currEntryIndex = entryIndex;
		o.currEntryTable = entryTable;
	end
end

o.Entries_SetCurrent = l_SetCurrent;




function l_CreateAndLoad(rrTable)
	local entryTable = o.Segui.Config_CreateEntryTable(rrTable);
	entryTable.message = ("");
	entryTable.messageType = 8; -- Say
	
	local entryIndex;
	local entries = rrTable.entries;
	if (type(entries[1]) == "string") then
		entryIndex = 1;
	else
		entryIndex = #entries;
	end
	
	l_SetCurrent(rrTable, entryIndex);
end



do
	local tableremove = table.remove;
	
	function l_Delete(rrTable, entryIndex)
		if (rrTable == nil or rrTable.entries == nil) then
			return;
		end
		
		local entries = rrTable.entries;
		if (type(entries[1]) == "string") then
			rrTable.entries = nil;
		else
			tableremove(entries, entryIndex);
			if (#entries == 1) then
				rrTable.entries = entries[1];
			end
		end
		
		o.currEntryIndex = nil;
		o.currEntryTable = nil;
		l_SetCurrent(rrTable, nil);
	end
end




function l_LoadConfig(entryIndex, entryTable)
	local configBox = l_CONFIG_FRAME.ENTRY_CONFIG_BOX;
	
	if (entryTable == nil) then
		configBox:SetBackdropColor(0.7, 0.7, 0.7);
		configBox.MESSAGE_EB:EnableMouse(false);
		configBox.MESSAGE_TYPE_DD.BUTTON:Disable();
		configBox.CHANNEL_OR_TARGET_EB:EnableMouse(false);
		configBox.LANGUAGE_DD.BUTTON:Disable();
		configBox.ACTIVATION_DELAY_EB:EnableMouse(false);
		configBox.REPEAT_DELAY_EB:EnableMouse(false);
		configBox.DELETE_BUTTON:Disable();
		
		l_CONFIG_FRAME.ENTRY_DD.TEXT:SetText("");
		
		configBox.MESSAGE_EB:SetText("");
		configBox.CHANNEL_OR_TARGET_EB:SetText("");
		configBox.MESSAGE_TYPE_DD.TEXT:SetText("");
		l_currMessageTypeIndex = nil;
		configBox.LANGUAGE_DD.TEXT:SetText("");
		l_currLanguageIndex = nil;
		configBox.ACTIVATION_DELAY_EB:SetText("");
		configBox.REPEAT_DELAY_EB:SetText("");
		return;
	end
	
	configBox:SetBackdropColor(0.4, 0.4, 0.4);
	configBox.MESSAGE_EB:EnableMouse(true);
	configBox.MESSAGE_TYPE_DD.BUTTON:Enable();
	configBox.CHANNEL_OR_TARGET_EB:EnableMouse(true);
	configBox.LANGUAGE_DD.BUTTON:Enable();
	configBox.ACTIVATION_DELAY_EB:EnableMouse(true);
	configBox.REPEAT_DELAY_EB:EnableMouse(true);
	configBox.DELETE_BUTTON:Enable();
	
	l_CONFIG_FRAME.ENTRY_DD.TEXT:SetText(entryIndex);
	
	configBox.MESSAGE_EB:SetText(entryTable.message or "");
	local messageType = entryTable.messageType;
	if (messageType ~= nil) then
		local messageTypeText;
		local index = 1;
		while (messageTypeText == nil and index < #l_MESSAGE_TYPE_LIST) do
			if (l_MESSAGE_TYPE_LIST[index].messageType == messageType) then
				messageTypeText = l_MESSAGE_TYPE_LIST[index].text;
			else
				index = (index + 1);
			end
		end
		configBox.MESSAGE_TYPE_DD.TEXT:SetText(messageTypeText or l_MESSAGE_TYPE_LIST[1].text);
	else
		configBox.MESSAGE_TYPE_DD.TEXT:SetText("");
	end
	l_currMessageTypeIndex = messageType;
	configBox.CHANNEL_OR_TARGET_EB:SetText(entryTable.channelOrTarget or "");
	local language = entryTable.language;
	configBox.LANGUAGE_DD.TEXT:SetText(GetLanguageByIndex(language or 1));
	l_currLanguageIndex = language;
	configBox.ACTIVATION_DELAY_EB:SetNumber(entryTable.activationDelay or 0);
	configBox.REPEAT_DELAY_EB:SetNumber(entryTable.repeatDelay or 0);
end



do
	local loc_ERROR_INVALID_BASIC_EMOTE = o.Localization.ERROR_INVALID_BASIC_EMOTE;
	
	function l_SaveConfig(entryIndex, entryTable)
		local configBox = l_CONFIG_FRAME.ENTRY_CONFIG_BOX;
		local message = configBox.MESSAGE_EB:GetText();
		local messageType = l_currMessageTypeIndex;
		if (messageType == 2) then
			-- Extra check for Basic Emotes.
			local _G = _G;
			local emote = _G["EMOTE" .. message .. "_TOKEN"];
			if (emote ~= nil) then
				message = emote;
			else
				message = message:upper();
				local found = false;
				local index = 1;
				local emote = _G["EMOTE" .. index .. "_TOKEN"];
				while (emote ~= nil and found == false) do
					if (message == emote) then
						found = true;
					else
						index = (index + 1);
						emote = _G["EMOTE" .. index .. "_TOKEN"];
					end
				end
				if (found ~= true) then
					DEFAULT_CHAT_FRAME:AddMessage(loc_ERROR_INVALID_BASIC_EMOTE);
					return;
				end
			end
		end
		local channelOrTarget = configBox.CHANNEL_OR_TARGET_EB:GetText();
		if (channelOrTarget == "" or channelOrTarget:gsub(" ", "") == "") then
			channelOrTarget = nil;
		end
		local language = l_currLanguageIndex;
		if (language == 1) then
			language = nil;
		end
		local activationDelay = configBox.ACTIVATION_DELAY_EB:GetNumber();
		if (activationDelay < 1) then
			activationDelay = nil;
		end
		local repeatDelay = configBox.REPEAT_DELAY_EB:GetNumber();
		if (repeatDelay < 1) then
			repeatDelay = nil;
		end
		
		entryTable.message = message;
		entryTable.messageType = messageType;
		entryTable.activationDelay = activationDelay;
		entryTable.language = language;
		entryTable.channelOrTarget = channelOrTarget;
		entryTable.repeatDelay = repeatDelay;
		entryTable.timeLastSent = nil;
		
		l_LoadConfig(entryIndex, entryTable);
	end
	
	o.Entries_SaveConfig = l_SaveConfig;
end




do
	local loc_CREATE_NEW_ENTRY = o.Localization.CREATE_NEW_ENTRY;
	
	function l_EntryDD_Init()
		local rrTable = o.currRRTable;
		if (rrTable == nil) then
			return;
		end
		
		local AddButton = UIDropDownMenu_AddButton;
		local buttonInfo = {};
		buttonInfo.notCheckable = true;
		
		if (rrTable.entries ~= nil) then
			buttonInfo.func = l_SetCurrent;
			buttonInfo.arg1 = rrTable;
			if (type(rrTable.entries[1]) == "string") then
				buttonInfo.text = 1;
				buttonInfo.arg2 = 1;
				AddButton(buttonInfo, 1);
			else
				for entryIndex = 1, #rrTable.entries, 1 do
					buttonInfo.text = entryIndex;
					buttonInfo.arg2 = entryIndex;
					AddButton(buttonInfo, 1);
				end
			end
		end
		
		buttonInfo.func = l_CreateAndLoad;
		buttonInfo.text = loc_CREATE_NEW_ENTRY;
		buttonInfo.arg1 = rrTable;
		buttonInfo.arg2 = nil;
		AddButton(buttonInfo, 1);
	end
end




do
	local l_MessageTypeDD_Button_OnClick;
	
	function l_MessageTypeDD_Init()
		local AddButton = UIDropDownMenu_AddButton;
		local buttonInfo = {};
		buttonInfo.notCheckable = true;
		buttonInfo.func = l_MessageTypeDD_Button_OnClick;
		
		for index, messageTypeData in ipairs(l_MESSAGE_TYPE_LIST) do
			buttonInfo.text = messageTypeData.text;
			buttonInfo.arg1 = messageTypeData;
			AddButton(buttonInfo, 1);
		end
	end
	
	
	do
		function l_MessageTypeDD_Button_OnClick(messageTypeData)
			l_currMessageTypeIndex = messageTypeData.messageType;
			l_CONFIG_FRAME.ENTRY_CONFIG_BOX.MESSAGE_TYPE_DD.TEXT:SetText(messageTypeData.text);
		end
	end
end



do
	local l_LanguageDD_Button_OnClick;
	
	function l_LanguageDD_Init()
		local AddButton = UIDropDownMenu_AddButton;
		local buttonInfo = {};
		buttonInfo.notCheckable = true;
		buttonInfo.func = l_LanguageDD_Button_OnClick;
		
		local index = 1;
		local language = GetLanguageByIndex(1);
		while (language ~= nil) do
			buttonInfo.text = language;
			buttonInfo.arg1 = index;
			buttonInfo.arg2 = language;
			AddButton(buttonInfo, 1);
			index = (index + 1);
			language = GetLanguageByIndex(index);
		end
	end
	
	
	do
		function l_LanguageDD_Button_OnClick(languageIndex, language)
			l_currLanguageIndex = languageIndex;
			l_CONFIG_FRAME.ENTRY_CONFIG_BOX.LANGUAGE_DD.TEXT:SetText(language);
		end
	end
end




function l_DeleteButton_OnClick()
	l_Delete(o.currRRTable, o.currEntryIndex);
end



function l_t_OnGUILoaded(configFrame)
	l_t_OnGUILoaded = nil;
	o.Entries_t_OnGUILoaded = nil;
	
	l_CONFIG_FRAME = configFrame;
	configFrame.ENTRY_DD.initialize = l_EntryDD_Init;
	configFrame.ENTRY_CONFIG_BOX.MESSAGE_TYPE_DD.initialize = l_MessageTypeDD_Init;
	configFrame.ENTRY_CONFIG_BOX.LANGUAGE_DD.initialize = l_LanguageDD_Init;
	configFrame.ENTRY_CONFIG_BOX.DELETE_BUTTON:SetScript("OnClick", l_DeleteButton_OnClick);
end

o.Entries_t_OnGUILoaded = l_t_OnGUILoaded;

