

local o = Segui_Config;


local l_t_CreateGUI; -- ()

local l_LocalizeTextAndRemoveUnlocal; -- (textUnlocal)

local l_Element_OnEnter; -- (self)
local l_Element_OnLeave; -- ()

local l_InitConfigBox; -- (box, width, height, titleText)

local l_InitElement; -- (element, tooltipTitle, tooltipText)
local l_InitDD; -- (dd, width, titleText, tooltipTitle, tooltipText)
local l_InitEB; -- (eb, titlePoint, width, numeric, maxLetters, titleText, tooltipTitle, tooltipText)
local l_InitButton; -- (button, width, text, tooltipTitle, tooltipText)




do
	local CreateFrame = CreateFrame;
	
	function l_t_CreateGUI()
		l_t_CreateGUI = nil;
		o.ConfigGUI_t_CreateGUI = nil;
		
		
		local configFrame = CreateFrame("Frame", "Segui_ConfigFrame", UIParent, nil);
		configFrame:Hide();
		configFrame:SetToplevel(true);
		configFrame:SetWidth(650);
		configFrame:SetHeight(430);
		configFrame:SetPoint("CENTER", UIParent, "CENTER", 0, 100);
		configFrame:SetBackdrop(
		  {
		    bgFile = ("Interface\\DialogFrame\\UI-DialogBox-Background"),
			edgeFile = ("Interface\\DialogFrame\\UI-DialogBox-Border"),
			tile = true, tileSize = 32, edgeSize = 32,
		    insets = { left = 11, right = 12, top = 12, bottom = 11 };
		  }
		);
		
		configFrame:SetMovable(true);
		configFrame:EnableMouse(true);
		configFrame:RegisterForDrag("LeftButton", "RightButton");
		
		local titleBox = configFrame:CreateTexture("Segui_ConfigFrameTitleBoxTexture", "ARTWORK", nil);
		titleBox:SetTexture("Interface\\DialogFrame\\UI-DialogBox-Header");
		titleBox:SetWidth(300);
		titleBox:SetHeight(64);
		titleBox:SetPoint("TOP", configFrame, "TOP", 0, 12);
		local titleText = configFrame:CreateFontString("Segui_ConfigFrameTitleBoxText", "OVERLAY", "GameFontNormal");
		titleText:SetPoint("TOP", configFrame, "TOP", 0, -2);
		titleText:SetFormattedText("Segui %s Config", GetAddOnMetadata("Segui", "Version"));
		
		local emailText = configFrame:CreateFontString("Segui_ConfigFrameEmailText", "OVERLAY", "GameFontNormalSmall");
		emailText:SetJustifyH("LEFT");
		emailText:SetText("saeris.sanoora@gmail.com");
		emailText:SetPoint("TOPLEFT", configFrame, "TOPLEFT", 20, -20);
		local websiteText = configFrame:CreateFontString("Segui_ConfigFrameWebsiteText", "OVERLAY", "GameFontNormalSmall");
		websiteText:SetJustifyH("RIGHT");
		websiteText:SetText("http://tinyurl.com/o7ef4");
		websiteText:SetPoint("TOPRIGHT", configFrame, "TOPRIGHT", -20, -20);
		
		
		local categoryDD = CreateFrame("Frame", "Segui_ConfigFrame_CategoryDD", configFrame, "UIDropDownMenuTemplate");
		configFrame.CATEGORY_DD = categoryDD;
		categoryDD:SetPoint("TOPLEFT", configFrame, "TOPLEFT", 5, -60);
		l_InitDD(categoryDD, 125, "CATEGORY_DD_TITLE", "CATEGORY_DD_TOOLTIP_TITLE", "CATEGORY_DD_TOOLTIP_TEXT");
		categoryDD.BUTTON.ADDITIONAL_TOOLTIP_TEXT = o.Localization.CATEGORY_DD_ADDITIONAL_TOOLTIP_TEXT;
		
		local actionDD = CreateFrame("Frame", "Segui_ConfigFrame_ActionDD", configFrame, "UIDropDownMenuTemplate");
		configFrame.ACTION_DD = actionDD;
		actionDD:SetPoint("LEFT", categoryDD, "RIGHT", -10, 0);
		l_InitDD(actionDD, 200, "ACTION_DD_TITLE", "ACTION_DD_TOOLTIP_TITLE", "ACTION_DD_TOOLTIP_TEXT");
		
		local rrDD = CreateFrame("Frame", "Segui_ConfigFrame_RollRangeDD", configFrame, "UIDropDownMenuTemplate");
		configFrame.ROLLRANGE_DD = rrDD;
		rrDD:SetPoint("LEFT", actionDD, "RIGHT", -10, 0);
		l_InitDD(rrDD, 90, "ROLLRANGE_DD_TITLE", "ROLLRANGE_DD_TOOLTIP_TITLE", "ROLLRANGE_DD_TOOLTIP_TEXT");
		
		local entryDD = CreateFrame("Frame", "Segui_ConfigFrame_EntryDD", configFrame, "UIDropDownMenuTemplate");
		configFrame.ENTRY_DD = entryDD;
		entryDD:SetPoint("LEFT", rrDD, "RIGHT", -10, 0);
		l_InitDD(entryDD, 50, "ENTRY_DD_TITLE", "ENTRY_DD_TOOLTIP_TITLE", "ENTRY_DD_TOOLTIP_TEXT");
		
		
		local actionConfigBox = CreateFrame("Frame", "Segui_ConfigFrame_ActionConfigBox", configFrame, "OptionFrameBoxTemplate");
		configFrame.ACTION_CONFIG_BOX = actionConfigBox;
		actionConfigBox:SetPoint("TOPLEFT", categoryDD, "BOTTOMLEFT", 15, -22);
		l_InitConfigBox(actionConfigBox, 290, 105, "ACTION_CONFIG_BOX_TITLE");
		
		local actionRepeatDelayEB = CreateFrame("EditBox", "Segui_ConfigFrame_ActionConfigBox_RepeatDelayEB", actionConfigBox, "InputBoxTemplate");
		actionConfigBox.REPEAT_DELAY_EB = actionRepeatDelayEB;
		l_InitEB(actionRepeatDelayEB, "LEFT", 64, true, 4, "ACTION_CONFIG_BOX_REPEAT_DELAY_EB_TITLE", "ACTION_CONFIG_BOX_REPEAT_DELAY_EB_TOOLTIP_TITLE", "ACTION_CONFIG_BOX_REPEAT_DELAY_EB_TOOLTIP_TEXT");
		actionRepeatDelayEB:SetPoint("TOPLEFT", actionConfigBox, "TOPLEFT", 175, -15);
		
		local alwaysTrySendCB = CreateFrame("CheckButton", "Segui_ConfigFrame_ActionConfigBox_AlwaysTrySendCB", actionConfigBox, "OptionsCheckButtonTemplate");
		actionConfigBox.ALWAYS_TRY_SEND_CB = alwaysTrySendCB;
		alwaysTrySendCB:SetWidth(32);
		alwaysTrySendCB:SetHeight(32);
		alwaysTrySendCB:SetPoint("TOPRIGHT", actionRepeatDelayEB, "BOTTOMLEFT", -110, -5);
		Segui_ConfigFrame_ActionConfigBox_AlwaysTrySendCBText:SetText(o.Localization.ACTION_CONFIG_BOX_ALWAYS_TRY_SEND_CB_TEXT);
		o.Localization.ACTION_CONFIG_BOX_ALWAYS_TRY_SEND_CB_TEXT = nil;
		l_InitElement(alwaysTrySendCB, "ACTION_CONFIG_BOX_ALWAYS_TRY_SEND_CB_TOOLTIP_TITLE", "ACTION_CONFIG_BOX_ALWAYS_TRY_SEND_CB_TOOLTIP_TEXT");
		
		local renameActionButton = CreateFrame("Button", "Segui_ConfigFrame_ActionConfigBox_RenameActionButton", actionConfigBox, "UIPanelButtonTemplate");
		actionConfigBox.RENAME_BUTTON = renameActionButton;
		renameActionButton:SetPoint("TOPLEFT", alwaysTrySendCB, "BOTTOMLEFT", 35, -2);
		l_InitButton(renameActionButton, 70, "ACTION_CONFIG_BOX_RENAME_ACTION_BUTTON_TEXT", "ACTION_CONFIG_BOX_RENAME_ACTION_BUTTON_TOOLTIP_TITLE", "ACTION_CONFIG_BOX_RENAME_ACTION_BUTTON_TOOLTIP_TEXT");
		
		local deleteActionButton = CreateFrame("Button", "Segui_ConfigFrame_ActionConfigBox_DeleteActionButton", actionConfigBox, "UIPanelButtonTemplate");
		actionConfigBox.DELETE_BUTTON = deleteActionButton;
		deleteActionButton:SetPoint("LEFT", renameActionButton, "RIGHT", 10, 0);
		l_InitButton(deleteActionButton, 70, DELETE, DELETE, "ACTION_CONFIG_BOX_DELETE_ACTION_BUTTON_TOOLTIP_TEXT");
		
		
		local rrConfigBox = CreateFrame("Frame", "Segui_ConfigFrame_RollRangeConfigBox", configFrame, "OptionFrameBoxTemplate");
		configFrame.ROLLRANGE_CONFIG_BOX = rrConfigBox;
		rrConfigBox:SetPoint("LEFT", actionConfigBox, "RIGHT", 30, -5);
		l_InitConfigBox(rrConfigBox, 290, 120, "ROLLRANGE_CONFIG_BOX_TITLE");
		
		local minRollEB = CreateFrame("EditBox", "Segui_ConfigFrame_RollRangeConfigBox_MinRollEB", rrConfigBox, "InputBoxTemplate");
		rrConfigBox.MIN_ROLL_EB = minRollEB;
		minRollEB:SetPoint("TOPLEFT", rrConfigBox, "TOPLEFT", 70, -15);
		l_InitEB(minRollEB, "LEFT", 64, true, 4, "ROLLRANGE_CONFIG_BOX_MIN_ROLL_EB_TITLE", "ROLLRANGE_CONFIG_BOX_MIN_ROLL_EB_TOOLTIP_TITLE", "ROLLRANGE_CONFIG_BOX_MIN_ROLL_EB_TOOLTIP_TEXT");
		
		local maxRollEB = CreateFrame("EditBox", "Segui_ConfigFrame_RollRangeConfigBox_MaxRollEB", rrConfigBox, "InputBoxTemplate");
		rrConfigBox.MAX_ROLL_EB = maxRollEB;
		maxRollEB:SetPoint("LEFT", minRollEB, "RIGHT", 80, 0);
		l_InitEB(maxRollEB, "LEFT", 64, true, 4, "ROLLRANGE_CONFIG_BOX_MAX_ROLL_EB_TITLE", "ROLLRANGE_CONFIG_BOX_MAX_ROLL_EB_TOOLTIP_TITLE", "ROLLRANGE_CONFIG_BOX_MAX_ROLL_EB_TOOLTIP_TEXT");
		
		local rrRepeatDelayEB = CreateFrame("EditBox", "Segui_ConfigFrame_RollRangeConfigBox_RepeatDelayEB", rrConfigBox, "InputBoxTemplate");
		rrConfigBox.REPEAT_DELAY_EB = rrRepeatDelayEB;
		rrRepeatDelayEB:SetPoint("TOPLEFT", minRollEB, "BOTTOMLEFT", 110, -12);
		l_InitEB(rrRepeatDelayEB, "LEFT", 64, true, 4, "ROLLRANGE_CONFIG_BOX_REPEAT_DELAY_EB_TITLE", "ROLLRANGE_CONFIG_BOX_REPEAT_DELAY_EB_TOOLTIP_TITLE", "ROLLRANGE_CONFIG_BOX_REPEAT_DELAY_EB_TOOLTIP_TEXT");
		
		local triggerTimesDD = CreateFrame("Frame", "Segui_ConfigFrame_RollRangeConfigBox_TriggerTimesDD", rrConfigBox, "UIDropDownMenuTemplate");
		rrConfigBox.TRIGGER_TIMES_DD = triggerTimesDD;
		triggerTimesDD:SetPoint("TOPLEFT", rrRepeatDelayEB, "TOPLEFT", -180, -40);
		l_InitDD(triggerTimesDD, 160, "ROLLRANGE_CONFIG_BOX_TRIGGER_TIMES_DD_TITLE", "ROLLRANGE_CONFIG_BOX_TRIGGER_TIMES_DD_TOOLTIP_TITLE", "ROLLRANGE_CONFIG_BOX_TRIGGER_TIMES_DD_TOOLTIP_TEXT");
		
		local deleteRRButton = CreateFrame("Button", "Segui_ConfigFrame_RollRangeConfigBox_DeleteRollRangeButton", rrConfigBox, "UIPanelButtonTemplate");
		rrConfigBox.DELETE_BUTTON = deleteRRButton;
		deleteRRButton:SetPoint("LEFT", triggerTimesDD, "RIGHT", 0, 5);
		l_InitButton(deleteRRButton, 70, DELETE, DELETE, "ROLLRANGE_CONFIG_BOX_DELETE_ROLLRANGE_BUTTON_TOOLTIP_TEXT");
		
		
		local entryConfigBox = CreateFrame("Frame", "Segui_ConfigFrame_EntryConfigBox", configFrame, "OptionFrameBoxTemplate");
		configFrame.ENTRY_CONFIG_BOX = entryConfigBox;
		entryConfigBox:SetPoint("TOPLEFT", actionConfigBox, "BOTTOMLEFT", 0, -25);
		l_InitConfigBox(entryConfigBox, 610, 140, "ENTRY_CONFIG_BOX_TITLE");
		
		local messageEB = CreateFrame("EditBox", "Segui_ConfigFrame_EntryConfigBox_MessageEB", entryConfigBox, "InputBoxTemplate");
		entryConfigBox.MESSAGE_EB = messageEB;
		messageEB:SetPoint("TOPLEFT", entryConfigBox, "TOPLEFT", 90, -15);
		l_InitEB(messageEB, "LEFT", 490, false, 1024, "ENTRY_CONFIG_BOX_MESSAGE_EB_TITLE", "ENTRY_CONFIG_BOX_MESSAGE_EB_TOOLTIP_TITLE", "ENTRY_CONFIG_BOX_MESSAGE_EB_TOOLTIP_TEXT");
		
		local entryRepeatDelayEB = CreateFrame("EditBox", "Segui_ConfigFrame_EntryConfigBox_RepeatDelayEB", entryConfigBox, "InputBoxTemplate");
		entryConfigBox.REPEAT_DELAY_EB = entryRepeatDelayEB;
		l_InitEB(entryRepeatDelayEB, "LEFT", 64, true, 4, "ENTRY_CONFIG_BOX_REPEAT_DELAY_EB_TITLE", "ENTRY_CONFIG_BOX_REPEAT_DELAY_EB_TOOLTIP_TITLE", "ENTRY_CONFIG_BOX_REPEAT_DELAY_EB_TOOLTIP_TEXT");
		entryRepeatDelayEB:SetPoint("TOPLEFT", messageEB, "BOTTOMLEFT", 90, -20);
		
		local activationDelayEB = CreateFrame("EditBox", "Segui_ConfigFrame_EntryConfigBox_ActivationDelayEB", entryConfigBox, "InputBoxTemplate");
		entryConfigBox.ACTIVATION_DELAY_EB = activationDelayEB;
		l_InitEB(activationDelayEB, "LEFT", 64, true, 4, "ENTRY_CONFIG_BOX_ACTIVATION_DELAY_EB_TITLE", "ENTRY_CONFIG_BOX_ACTIVATION_DELAY_EB_TOOLTIP_TITLE", "ENTRY_CONFIG_BOX_ACTIVATION_DELAY_EB_TOOLTIP_TEXT");
		activationDelayEB:SetPoint("LEFT", entryRepeatDelayEB, "RIGHT", 200, 0);
		
		local messageTypeDD = CreateFrame("Frame", "Segui_ConfigFrame_EntryConfigBox_MessageTypeDD", entryConfigBox, "UIDropDownMenuTemplate");
		entryConfigBox.MESSAGE_TYPE_DD = messageTypeDD;
		messageTypeDD:SetPoint("TOPLEFT", entryRepeatDelayEB, "BOTTOMLEFT", -170, -30);
		l_InitDD(messageTypeDD, 120, "ENTRY_CONFIG_BOX_MESSAGE_TYPE_DD_TITLE", "ENTRY_CONFIG_BOX_MESSAGE_TYPE_DD_TOOLTIP_TITLE", "ENTRY_CONFIG_BOX_MESSAGE_TYPE_DD_TOOLTIP_TEXT");
		
		local channelOrTargetEB = CreateFrame("EditBox", "Segui_ConfigFrame_EntryConfigBox_ChannelOrTargetEB", entryConfigBox, "InputBoxTemplate");
		entryConfigBox.CHANNEL_OR_TARGET_EB = channelOrTargetEB;
		channelOrTargetEB:SetPoint("LEFT", messageTypeDD, "RIGHT", 10, 1);
		l_InitEB(channelOrTargetEB, "TOP", 160, false, 512, "ENTRY_CONFIG_BOX_CHANNEL_OR_TARGET_EB_TITLE", "ENTRY_CONFIG_BOX_CHANNEL_OR_TARGET_EB_TOOLTIP_TITLE", "ENTRY_CONFIG_BOX_CHANNEL_OR_TARGET_EB_TOOLTIP_TEXT");
		
		local languageDD = CreateFrame("Frame", "Segui_ConfigFrame_EntryConfigBox_LanguageDD", entryConfigBox, "UIDropDownMenuTemplate");
		entryConfigBox.LANGUAGE_DD = languageDD;
		languageDD:SetPoint("LEFT", channelOrTargetEB, "RIGHT", 10, -1);
		l_InitDD(languageDD, 100, "ENTRY_CONFIG_BOX_LANGUAGE_DD_TITLE", "ENTRY_CONFIG_BOX_LANGUAGE_DD_TOOLTIP_TITLE", "ENTRY_CONFIG_BOX_LANGUAGE_DD_TOOLTIP_TEXT");
		
		local deleteEntryButton = CreateFrame("Button", "Segui_ConfigFrame_EntryConfigBox_DeleteEntryButton", entryConfigBox, "UIPanelButtonTemplate");
		entryConfigBox.DELETE_BUTTON = deleteEntryButton;
		deleteEntryButton:SetPoint("LEFT", languageDD, "RIGHT", 10, 1);
		l_InitButton(deleteEntryButton, 70, DELETE, DELETE, "ENTRY_CONFIG_BOX_DELETE_ENTRY_BUTTON_TOOLTIP_TEXT");
		
		
		local saveChangesButton = CreateFrame("Button", "Segui_ConfigFrame_SaveChangesButton", configFrame, "UIPanelButtonTemplate");
		configFrame.SAVE_CHANGES_BUTTON = saveChangesButton;
		saveChangesButton:SetPoint("BOTTOM", configFrame, "BOTTOM", -100, 15);
		l_InitButton(saveChangesButton, 140, "SAVE_CHANGES_BUTTON_TEXT");
		
		local closeButton = CreateFrame("Button", "Segui_ConfigFrame_CloseButton", configFrame, "UIPanelButtonTemplate");
		closeButton:SetPoint("BOTTOM", configFrame, "BOTTOM", 100, 15);
		l_InitButton(closeButton, 140, CLOSE);
		closeButton:SetScript("OnClick", (function() configFrame:Hide(); end));
		
		
		return configFrame;
	end
	
	o.ConfigGUI_t_CreateGUI = l_t_CreateGUI;
end




do
	local Localization = o.Localization;
	
	function l_LocalizeTextAndRemoveUnlocal(textUnlocal)
		local text = Localization[textUnlocal];
		if (text ~= nil) then
			Localization[textUnlocal] = nil;
		else
			text = textUnlocal;
		end
		return text;
	end
end




do
	local GameTooltip = GameTooltip;
	
	function l_Element_OnEnter(self)
		GameTooltip:SetOwner(self, "ANCHOR_RIGHT");
		GameTooltip:SetText(self.TOOLTIP_TITLE, 1.0, 0.82, 0.0);
		GameTooltip:AddLine(self.TOOLTIP_TEXT, 1.0, 0.82, 0.0, true);
		if (self.ADDITIONAL_TOOLTIP_TEXT ~= nil) then
			GameTooltip:SetMinimumWidth(300);
			GameTooltip:AddLine(("\n" .. self.ADDITIONAL_TOOLTIP_TEXT), 1.0, 0.82, 0.0, true);
		end
		GameTooltip:Show();
		
		if (GameTooltip:GetWidth() > 600) then
			GameTooltip:SetMinimumWidth(300);
			GameTooltip:Show();
		end
	end
end


do
	l_Element_OnLeave = HIDE_GAMETOOLTIP_FUNCTION;
	if (l_Element_OnLeave == nil) then
		local func;
		do
			local GameTooltip = GameTooltip;
			func = (function() GameTooltip:Hide(); end);
		end
		HIDE_GAMETOOLTIP_FUNCTION = func;
		l_Element_OnLeave = func;
	end
end




function l_InitConfigBox(box, width, height, titleText)
	box:SetWidth(width);
	box:SetHeight(height);
	box:SetBackdropColor(0.4, 0.4, 0.4);
	box:SetBackdropBorderColor(0.8, 0.8, 0.8);
	
	titleText = l_LocalizeTextAndRemoveUnlocal(titleText);
	local title = _G[box:GetName() .. "Title"];
	title:SetTextColor(1.0, 0.82, 0.0);
	title:SetText(titleText);
end




function l_InitElement(element, tooltipTitle, tooltipText)
	tooltipTitle = l_LocalizeTextAndRemoveUnlocal(tooltipTitle);
	tooltipText = l_LocalizeTextAndRemoveUnlocal(tooltipText);
	if (tooltipTitle ~= nil and tooltipText ~= nil) then
		element.TOOLTIP_TITLE = tooltipTitle;
		element.TOOLTIP_TEXT = tooltipText;
		element:EnableMouse(true);
		element:SetScript("OnEnter", l_Element_OnEnter);
		element:SetScript("OnLeave", l_Element_OnLeave);
	end
end



function l_InitDD(dd, width, titleText, tooltipTitle, tooltipText)
	local name = dd:GetName();
	dd.TEXT = _G[name .. "Text"];
	dd.TEXT:SetJustifyH("CENTER");
	dd.BUTTON = _G[name .. "Button"];
	
	UIDropDownMenu_SetWidth(width, dd);
	
	titleText = l_LocalizeTextAndRemoveUnlocal(titleText);
	local title = dd:CreateFontString((name .. "Title"), "OVERLAY", "GameFontNormalSmall");
	title:SetJustifyH("CENTER");
	title:SetPoint("TOP", dd, "TOP", 0, 12);
	title:SetText(titleText);
	
	l_InitElement(dd.BUTTON, tooltipTitle, tooltipText);
end



function l_InitEB(eb, titlePoint, width, numeric, maxLetters, titleText, tooltipTitle, tooltipText)
	eb:SetAutoFocus(false);
	eb:SetWidth(width);
	eb:SetHeight(16);
	eb:SetNumeric(numeric);
	eb:SetMaxLetters(maxLetters);
	
	titleText = l_LocalizeTextAndRemoveUnlocal(titleText);
	local title = eb:CreateFontString((eb:GetName() .. "Title"), "OVERLAY", "GameFontNormalSmall");
	title:SetText(titleText);
	if (titlePoint == "TOP") then
		title:SetJustifyH("CENTER");
		title:SetPoint("BOTTOM", eb, "TOP", 0, 5);
	elseif (titlePoint == "LEFT") then
		title:SetJustifyH("RIGHT");
		title:SetPoint("RIGHT", eb, "LEFT", -15, 1);
	end
	
	l_InitElement(eb, tooltipTitle, tooltipText);
end



function l_InitButton(button, width, text, tooltipTitle, tooltipText)
	button:SetWidth(width);
	button:SetHeight(25);
	
	text = l_LocalizeTextAndRemoveUnlocal(text);
	button:SetText(text);
	
	l_InitElement(button, tooltipTitle, tooltipText);
end

