

local o = Segui_Config;


local l_t_Init; -- ()

local l_SaveAllChanges; -- ()

local l_ConfigFrame_OnDragStart; -- (self)
local l_ConfigFrame_OnDragStop; -- (self)
local l_t_LoadGUI; -- frame = ()




function l_t_Init()
	l_t_Init = nil;
	o.Config_t_Init = nil;
	
	l_t_LoadGUI();
	o.Categories_SetCurrent(nil, nil);
end

o.Config_t_Init = l_t_Init;




function l_SaveAllChanges()
	if (o.currEntryIndex ~= nil) then
		o.Entries_SaveConfig(o.currEntryIndex, o.currEntryTable);
	end
	if (o.currRRIndex ~= nil) then
		o.RollRanges_SaveConfig(o.currRRTable);
	end
	if (o.currActionIndex ~= nil) then
		o.Actions_SaveConfig(o.currCategoryTable, o.currActionIndex, o.currActionRankIndex, o.currActionTable);
	end
end




do
	l_ConfigFrame_OnDragStart = GENERIC_FRAME_START_MOVING;
	if (l_ConfigFrame_OnDragStart == nil) then
		local func = function(self)
			self:StartMoving();
		end
		GENERIC_FRAME_START_MOVING = func;
		l_ConfigFrame_OnDragStart = func;
	end
end


do
	l_ConfigFrame_OnDragStop = GENERIC_FRAME_STOP_MOVING_OR_SIZING;
	if (l_ConfigFrame_OnDragStop == nil) then
		local func = function(self)
			self:StopMovingOrSizing();
		end
		GENERIC_FRAME_STOP_MOVING_OR_SIZING = func;
		l_ConfigFrame_OnDragStop = func;
	end
end



function l_t_LoadGUI()
	l_t_LoadGUI = nil;
	
	local frame = o.ConfigGUI_t_CreateGUI();
	frame:SetScript("OnDragStart", l_ConfigFrame_OnDragStart);
	frame:SetScript("OnDragStop", l_ConfigFrame_OnDragStop);
	frame:SetScript("OnHide", l_SaveAllChanges);
	frame.SAVE_CHANGES_BUTTON:SetScript("OnClick", l_SaveAllChanges);
	
	o.Categories_t_OnGUILoaded(frame);
	o.Actions_t_OnGUILoaded(frame);
	o.RollRanges_t_OnGUILoaded(frame);
	o.Entries_t_OnGUILoaded(frame);
	
	return frame;
end

