

local o = Segui_Config;


local l_t_Init; -- ()
local l_OnEvent_LEARNED_SPELL_IN_TAB;

local l_SetCurrent; -- (categoryIndex, subcategoryIndex)

local l_CategoryDD_Init; -- (level)
	-- local l_CategoryDD_InitSubcategoriesList; -- (categoryTable[, ddLevel][, start][, stop])
local l_DoesCategoryHaveActionConfigs; -- hasAny = (categoryTable)

local l_t_OnGUILoaded; -- (configFrame)

local l_UpdatePlayerCategory; -- (categoriesTable, tabNum)
local l_t_InitBaseCategories; -- (categoriesTable)


local l_CONFIG_FRAME;
local l_NUM_BASE_CATEGORIES;


local l_categories = {};
o.categories = l_categories;




function l_t_Init()
	l_t_Init = nil;
	o.Categories_t_Init = nil;
	
	l_NUM_BASE_CATEGORIES = l_t_InitBaseCategories(l_categories);
	o.Segui.EventsManager1.RegisterForEvent(l_OnEvent_LEARNED_SPELL_IN_TAB, nil, "LEARNED_SPELL_IN_TAB", false, false);
	for index = 1, GetNumSpellTabs(), 1 do
		l_UpdatePlayerCategory(l_categories, index);
	end
end

o.Categories_t_Init = l_t_Init;



function l_OnEvent_LEARNED_SPELL_IN_TAB(tab)
	l_UpdatePlayerCategory(l_categories, tab);
end




function l_SetCurrent(categoryIndex, subcategoryIndex)
	local categoryTable = l_categories[categoryIndex];
	
	if (categoryTable ~= nil) then
		local tooltipText = categoryTable.additionalTooltipText;
		if (subcategoryIndex ~= nil and categoryTable.subcategories ~= nil) then
			local subcategoryTable = categoryTable.subcategories[subcategoryIndex];
			tooltipText = (
			  ((tooltipText and (tooltipText .. "\n\n")) or "")
			  .. ("\n|cffffd100--==-- " .. subcategoryTable.name .. " --==--|r")
			  .. ((subcategoryTable.additionalTooltipText and ("\n" .. subcategoryTable.additionalTooltipText)) or "")
			);
			categoryTable = subcategoryTable;
		end
		l_CONFIG_FRAME.CATEGORY_DD.BUTTON.ADDITIONAL_TOOLTIP_TEXT = tooltipText;
		l_CONFIG_FRAME.CATEGORY_DD.TEXT:SetText(categoryTable.name);
		l_CONFIG_FRAME.ROLLRANGE_CONFIG_BOX.TRIGGER_TIMES_DD.enabled = categoryTable.hasTriggers;
		l_CONFIG_FRAME.SAVE_CHANGES_BUTTON:Enable();
	else
		l_CONFIG_FRAME.CATEGORY_DD.BUTTON.ADDITIONAL_TOOLTIP_TEXT = nil;
		l_CONFIG_FRAME.CATEGORY_DD.TEXT:SetText("");
		l_CONFIG_FRAME.ROLLRANGE_CONFIG_BOX.TRIGGER_TIMES_DD.enabled = nil;
		l_CONFIG_FRAME.SAVE_CHANGES_BUTTON:Disable();
	end
	
	o.Actions_SetCurrent(categoryTable, 1, nil);
	o.currCategoryTable = categoryTable;
end

o.Categories_SetCurrent = l_SetCurrent;




do
	local l_CategoryDD_InitSubcategoriesList;
	
	function l_CategoryDD_Init(level)
		if (level == 1) then
			-- Categories.
			local AddButton = UIDropDownMenu_AddButton;
			local buttonInfo = {
				func = l_SetCurrent;
			};
			
			local shouldShowChecked, subcategories, subcategoryIndex, subcategoryTable;
			for index, categoryTable in ipairs(l_categories) do
				buttonInfo.text = categoryTable.name;
				buttonInfo.arg1 = index;
				
				subcategories = categoryTable.subcategories;
				if (subcategories ~= nil) then
					shouldShowChecked = false;
					subcategoryIndex = 1;
					subcategoryTable = subcategories[1];
					while (shouldShowChecked == false and subcategoryTable ~= nil) do
						shouldShowChecked = l_DoesCategoryHaveActionConfigs(subcategoryTable);
						if (shouldShowChecked == false) then
							subcategoryIndex = (subcategoryIndex + 1);
							subcategoryTable = subcategories[subcategoryIndex];
						end
					end
					buttonInfo.value = categoryTable;
					buttonInfo.hasArrow = true;
					buttonInfo.notClickable = true;
				else
					shouldShowChecked = l_DoesCategoryHaveActionConfigs(categoryTable);
					buttonInfo.value = nil;
					buttonInfo.hasArrow = nil;
					buttonInfo.notClickable = nil;
					buttonInfo.disabled = nil;
				end
				buttonInfo.checked = shouldShowChecked;
				
				AddButton(buttonInfo, 1);
			end
			
		elseif (level == 2) then
			-- Subcategories.
			-- "this" is currently the arrow from dropdown 1.
			local level1Button = this:GetParent();
			local categoryTable = level1Button.value;
			
			local subcategories = categoryTable.subcategories;
			local numSubcategories = #subcategories;
			if (numSubcategories > 30) then
				local AddButton = UIDropDownMenu_AddButton;
				local buttonInfo = {
					notCheckable = true;
					notClickable = true;
					hasArrow = true;
					value = level1Button.arg1;
				};
				local lastIndex = 1;
				for index = 30, numSubcategories, 30 do
					buttonInfo.text = ("%d - %d"):format(lastIndex, index);
					buttonInfo.arg1 = lastIndex;
					buttonInfo.arg2 = index;
					AddButton(buttonInfo, 2);
					lastIndex = (index + 1);
				end
				if (numSubcategories % 30 ~= 0) then
					buttonInfo.text = ("%d - %d"):format(lastIndex, numSubcategories);
					buttonInfo.arg1 = lastIndex;
					buttonInfo.arg2 = numSubcategories;
					AddButton(buttonInfo, 2);
				end
			else
				l_CategoryDD_InitSubcategoriesList(level1Button.arg1, categoryTable, 2);
			end
			
		elseif (level == 3) then
			-- Subdivided subcategories.
			-- "this" is currently the arrow from dropdown 2.
			local level2Button = this:GetParent();
			l_CategoryDD_InitSubcategoriesList(level2Button.value, l_categories[level2Button.value], 3, level2Button.arg1, level2Button.arg2);
		end
	end
	
	
	do
		function l_CategoryDD_InitSubcategoriesList(categoryIndex, categoryTable, ddLevel, start, stop)
			local AddButton = UIDropDownMenu_AddButton;
			local buttonInfo = {};
			buttonInfo.func = l_SetCurrent;
			buttonInfo.arg1 = categoryIndex;
			
			local subcategories = categoryTable.subcategories;
			local subcategoryTable;
			for index = (start or 1), (stop or #subcategories), 1 do
				subcategoryTable = subcategories[index];
				buttonInfo.text = subcategoryTable.name;
				buttonInfo.arg2 = index;
				buttonInfo.checked = l_DoesCategoryHaveActionConfigs(subcategoryTable);
				AddButton(buttonInfo, (ddLevel or 2));
			end
		end
	end
end


function l_DoesCategoryHaveActionConfigs(categoryTable)
	local found = false;
	
	local storage = categoryTable.storage;
	if (storage ~= nil) then
		local actionNames = categoryTable.actionNames;
		local rankNamesByActions = categoryTable.rankNamesByActions;
		local actionNameIndex = 1;
		local actionName = actionNames[1];
		local ranks, rankFormat, rankIndex, rank;
		while (found == false and actionName ~= nil) do
			if (storage[actionName] ~= nil) then
				found = true;
			else
				ranks = ((rankNamesByActions ~= nil and rankNamesByActions[actionName]) or nil);
				if (ranks ~= nil) then
					rankFormat = (actionName .. "(%s)");
					rankIndex = 1;
					rank = ranks[1];
					while (found == false and rank ~= nil) do
						if (storage[rankFormat:format(rank)] ~= nil) then
							found = true;
						else
							rankIndex = (rankIndex + 1);
							rank = ranks[rankIndex];
						end
					end
				end
			end
			if (found == false) then
				actionNameIndex = (actionNameIndex + 1);
				actionName = actionNames[actionNameIndex];
			end
		end
	end
	
	return found;
end




function l_t_OnGUILoaded(configFrame)
	l_t_OnGUILoaded = nil;
	o.Categories_t_OnGUILoaded = nil;
	
	l_CONFIG_FRAME = configFrame;
	configFrame.CATEGORY_DD.initialize = l_CategoryDD_Init;
end

o.Categories_t_OnGUILoaded = l_t_OnGUILoaded;




do
	local GetSpellTabInfo = GetSpellTabInfo;
	local IsPassiveSpell = IsPassiveSpell;
	local GetSpellName = GetSpellName;
	
	function l_UpdatePlayerCategory(categories, tabNum)
		local tabName, _, offset, numSpells = GetSpellTabInfo(tabNum);
		
		local categoryTable = categories[tabNum + l_NUM_BASE_CATEGORIES];
		if (categoryTable == nil) then
			categoryTable = {
				name = tabName;
				storage = o.Segui.speechMemory.generalActions;
				hasTriggers = true;
			};
			categories[tabNum + l_NUM_BASE_CATEGORIES] = categoryTable;
		end
		
		local actionIndex = 0;
		local actionNames = {};
		local rankNamesByActions = {};
		categoryTable.actionNames = actionNames;
		categoryTable.rankNamesByActions = rankNamesByActions;
		
		local spellName, spellRank, prevName, ranksArray, ranksArrayIndex;
		for spellNum = (offset + 1), (offset + numSpells), 1 do
			if (IsPassiveSpell(spellNum, "spell") == nil) then
				spellName, spellRank = GetSpellName(spellNum, "spell");
				if (spellName ~= prevName) then
					if (ranksArray ~= nil and #ranksArray == 1) then
						rankNamesByActions[prevName] = nil;
					end
					actionIndex = (actionIndex + 1);
					actionNames[actionIndex] = spellName;
					prevName = spellName;
					ranksArray = nil;
				end
				if (spellRank ~= "") then
					if (ranksArray == nil) then
						ranksArray = {};
						ranksArrayIndex = 0;
						rankNamesByActions[spellName] = ranksArray;
					end
					ranksArrayIndex = (ranksArrayIndex + 1);
					ranksArray[ranksArrayIndex] = spellRank;
				end
			end
		end
		if (ranksArray ~= nil and #ranksArray == 1) then
			rankNamesByActions[spellName] = nil;
		end
	end
end



function l_t_InitBaseCategories(categories)
	l_t_InitBaseCategories = nil;
	
	
	local function l_SortByKey_name(elem1, elem2)
		return (elem1.name < elem2.name);
	end
	
	local localizedNames;
	local function l_SortByLocalizedName(actionName1, actionName2)
		return (localizedNames[actionName1] < localizedNames[actionName2]);
	end
	
	local tablesort = table.sort;
	local localSpeech = Segui.speechMemory;
	local loc = o.Localization;
	local categoryIndex = 0;
	local category, subcategoryMeta;
	local actionNames, actionIndex, subcategories, subcategoryIndex;
	
	
	actionNames = {};
	for index = 1, 30, 1 do
		actionNames[index] = index;
	end
	categoryIndex = (categoryIndex + 1);
	categories[categoryIndex] = {
		name = loc.CATEGORY_GLOBAL_HOTKEYS;
		additionalTooltipText = loc.CATEGORY_GLOBAL_HOTKEYS_ADDITIONAL_TOOLTIP_TEXT;
		storage = Segui.globalSpeechMemory.hotkeys;
		actionNames = actionNames;
		localizedActionNames = loc.GLOBAL_HOTKEY_ACTION_FORMAT;
	};
	loc.CATEGORY_GLOBAL_HOTKEYS = nil;
	loc.CATEGORY_GLOBAL_HOTKEYS_ADDITIONAL_TOOLTIP_TEXT = nil;
	
	
	subcategoryIndex = 0;
	subcategories = {};
	category = {
		name = loc.CATEGORY_MESSAGE_CHAT_EVENTS;
		storageParent = localSpeech.messageEvents;
		actionToggleFunc = Segui.Config_OnMessageEventCategoryActionToggled;
		actionCreationPopupText = loc.CATEGORY_MESSAGE_CHAT_EVENTS_CREATION_POPUP_TEXT;
		additionalTooltipText = loc.CATEGORY_MESSAGE_CHAT_EVENTS_ADDITIONAL_TOOLTIP_TEXT;
		subcategories = subcategories;
	};
	subcategoryMeta = { __index = category };
	for eventName, subcategoryName in pairs(loc.MESSAGE_CHAT_EVENTS_LIST) do
		actionNames = {};
		if (localSpeech.messageEvents[eventName] ~= nil) then
			actionIndex = 0;
			for actionName in pairs(localSpeech.messageEvents[eventName]) do
				actionIndex = (actionIndex + 1);
				actionNames[actionIndex] = actionName;
			end
			tablesort(actionNames);
		end
		subcategoryIndex = (subcategoryIndex + 1);
		subcategories[subcategoryIndex] = setmetatable(
		  {
			name = subcategoryName;
			storage = localSpeech.messageEvents[eventName];
			storageKey = eventName;
			actionNames = actionNames;
			additionalTooltipText = loc.CATEGORY_MESSAGE_CHAT_EVENTS_ADDITIONAL_TOOLTIP_TEXTS[eventName];
		  },
		  subcategoryMeta
		);
	end
	tablesort(subcategories, l_SortByKey_name);
	categoryIndex = (categoryIndex + 1);
	categories[categoryIndex] = category;
	loc.MESSAGE_CHAT_EVENTS_LIST = nil;
	loc.CATEGORY_MESSAGE_CHAT_EVENTS = nil;
	loc.CATEGORY_MESSAGE_CHAT_EVENTS_ADDITIONAL_TOOLTIP_TEXT = nil;
	loc.CATEGORY_MESSAGE_CHAT_EVENTS_ADDITIONAL_TOOLTIP_TEXTS = nil;
	
	
	subcategoryIndex = 0;
	subcategories = {};
	category = {
		name = loc.CATEGORY_MESSAGE_OTHER_EVENTS;
		storageParent = localSpeech.messageEvents;
		actionToggleFunc = Segui.Config_OnMessageEventCategoryActionToggled;
		actionCreationPopupText = loc.CATEGORY_MESSAGE_OTHER_EVENTS_CREATION_POPUP_TEXT;
		additionalTooltipText = loc.CATEGORY_MESSAGE_OTHER_EVENTS_ADDITIONAL_TOOLTIP_TEXT;
		subcategories = subcategories;
	};
	subcategoryMeta = { __index = category };
	for eventName, subcategoryName in pairs(loc.MESSAGE_OTHER_EVENTS_LIST) do
		actionNames = {};
		if (localSpeech.messageEvents[eventName] ~= nil) then
			actionIndex = 0;
			for actionName in pairs(localSpeech.messageEvents[eventName]) do
				actionIndex = (actionIndex + 1);
				actionNames[actionIndex] = actionName;
			end
			tablesort(actionNames);
		end
		subcategoryIndex = (subcategoryIndex + 1);
		subcategories[subcategoryIndex] = setmetatable(
		  {
			name = subcategoryName;
			storage = localSpeech.messageEvents[eventName];
			storageKey = eventName;
			actionNames = actionNames;
			additionalTooltipText = loc.CATEGORY_MESSAGE_OTHER_EVENTS_ADDITIONAL_TOOLTIP_TEXTS[eventName];
		  },
		  subcategoryMeta
		);
	end
	tablesort(subcategories, l_SortByKey_name);
	categoryIndex = (categoryIndex + 1);
	categories[categoryIndex] = category;
	loc.MESSAGE_OTHER_EVENTS_LIST = nil;
	loc.CATEGORY_MESSAGE_OTHER_EVENTS = nil;
	loc.CATEGORY_MESSAGE_OTHER_EVENTS_ADDITIONAL_TOOLTIP_TEXT = nil;
	loc.CATEGORY_MESSAGE_OTHER_EVENTS_ADDITIONAL_TOOLTIP_TEXTS = nil;
	
	
	actionNames = {};
	actionIndex = 0;
	for actionName in pairs(localSpeech.combatEvents) do
		actionIndex = (actionIndex + 1);
		actionNames[actionIndex] = actionName;
	end
	tablesort(actionNames);
	categoryIndex = (categoryIndex + 1);
	categories[categoryIndex] = {
		name = loc.CATEGORY_COMBAT_EVENTS;
		additionalTooltipText = loc.CATEGORY_COMBAT_EVENTS_ADDITIONAL_TOOLTIP_TEXT;
		actionCreationPopupText = loc.CATEGORY_COMBAT_EVENTS_CREATION_POPUP_TEXT;
		storage = localSpeech.combatEvents;
		categoryToggleFunc = Segui.Config_OnCombatEventCategoryEmptiedOrUnemptied;
		actionNames = actionNames;
	};
	loc.CATEGORY_COMBAT_EVENTS = nil;
	loc.CATEGORY_COMBAT_EVENTS_ADDITIONAL_TOOLTIP_TEXT = nil;
	loc.CATEGORY_COMBAT_EVENTS_CREATION_POPUP_TEXT = nil;
	
	
	localizedNames = loc.MISC_EVENTS_LIST;
	actionNames = {};
	actionIndex = 0;
	for actionName in pairs(localizedNames) do
		actionIndex = (actionIndex + 1);
		actionNames[actionIndex] = actionName;
	end
	tablesort(actionNames, l_SortByLocalizedName);
	categoryIndex = (categoryIndex + 1);
	categories[categoryIndex] = {
		name = loc.CATEGORY_MISC_EVENTS;
		storage = localSpeech.miscEvents;
		localizedActionNames = localizedNames;
		actionToggleFunc = Segui.Config_OnMiscEventCategoryActionToggled;
		actionNames = actionNames;
	};
	loc.MISC_EVENTS_LIST = nil;
	loc.CATEGORY_MISC_EVENTS = nil;
	
	
	local GetSpellTexture = GetSpellTexture;
	actionNames = {};
	actionIndex = 0;
	for actionName in pairs(localSpeech.generalActions) do
		-- Hack: Only Actions which the player does not know will return nil from this function.
		if (GetSpellTexture(actionName) == nil) then
			actionIndex = (actionIndex + 1);
			actionNames[actionIndex] = actionName;
		end
	end
	tablesort(actionNames);
	categoryIndex = (categoryIndex + 1);
	categories[categoryIndex] = {
		name = loc.CATEGORY_MISC_ACTIONS;
		additionalTooltipText = loc.CATEGORY_MISC_ACTIONS_ADDITIONAL_TOOLTIP_TEXT;
		actionCreationPopupText = loc.CATEGORY_MISC_ACTIONS_CREATION_POPUP_TEXT;
		storage = localSpeech.generalActions;
		hasTriggers = true;
		actionNames = actionNames;
	};
	loc.CATEGORY_MISC_ACTIONS = nil;
	loc.CATEGORY_MISC_ACTIONS_ADDITIONAL_TOOLTIP_TEXT = nil;
	loc.CATEGORY_MISC_ACTIONS_CREATION_POPUP_TEXT = nil;
	
	
	return categoryIndex;
end

