

local o = Segui_Config;


local l_SetCurrent; -- (categoryTable, actionIndex, rankIndex)

local l_CreateAndLoad; -- (categoryTable, actionName)
local l_CreateTable_UsingToggleFuncs; -- actionTable = (categoryTable, actionName)
local l_Rename; -- (categoryTable, actionIndex, newName)
local l_Delete; -- (categoryTable, actionIndex, rankIndex)

local l_LoadConfig; -- (categoryTable, actionIndex, rankIndex, actionTable)
local l_SaveConfig; -- (categoryTable, actionIndex, rankIndex, actionTable)

local l_ActionDD_Init; -- (level)
	-- local l_ActionDD_InitActionsList; -- (categoryTable, list[, ddLevel][, start][, stop])
	-- local l_ActionDD_Button_OnClick; -- (actionIndex, rankIndex)

local l_RenameButton_OnClick; -- ()
local l_DeleteButton_OnClick; -- ()
local l_t_OnGUILoaded; -- (configFrame)


local type = type; -- LoadConfig, ActionDD_Init
local tablesort = table.sort; -- CreateAndLoad, Rename


local l_CONFIG_FRAME;
StaticPopupDialogs["Segui_CreateNewAction"] = {
	text = ("%s");
	button1 = ACCEPT;
	button2 = CANCEL;
	whileDead = true;
	hideOnEscape = true;
	timeout = 0;
	hasEditBox = true;
	hasWideEditBox = true;
	OnAccept = (function()
		local eb = _G[this:GetParent():GetName() .. "WideEditBox"];
		l_CreateAndLoad(o.currCategoryTable, eb:GetText());
	end);
	EditBoxOnEnterPressed = (function()
		l_CreateAndLoad(o.currCategoryTable, this:GetText());
		this:GetParent():Hide();
	end);
	OnHide = (function()
		_G[this:GetName() .. "WideEditBox"]:SetText("");
	end);
	EditBoxOnEscapePressed = (function()
		this:GetParent():Hide();
	end);
};
StaticPopupDialogs["Segui_RenameAction"] = {
	text = o.Localization.RENAME_ACTION_POPUP_TEXT;
	button1 = ACCEPT;
	button2 = CANCEL;
	whileDead = true;
	hideOnEscape = true;
	timeout = 0;
	hasEditBox = true;
	hasWideEditBox = true;
	OnAccept = (function()
		local eb = _G[this:GetParent():GetName() .. "WideEditBox"];
		l_Rename(o.currCategoryTable, o.currActionIndex, eb:GetText());
	end);
	EditBoxOnEnterPressed = (function()
		l_Rename(o.currCategoryTable, o.currActionIndex, this:GetText());
		this:GetParent():Hide();
	end);
	OnHide = (function()
		_G[this:GetName() .. "WideEditBox"]:SetText("");
	end);
	EditBoxOnEscapePressed = (function()
		this:GetParent():Hide();
	end);
};




function l_SetCurrent(categoryTable, actionIndex, rankIndex)
	local actionTable;
	if (actionIndex ~= nil and categoryTable ~= nil and categoryTable.storage ~= nil) then
		local actionName = categoryTable.actionNames[actionIndex];
		if (rankIndex ~= nil) then
			actionName = (actionName .. "(" .. categoryTable.rankNamesByActions[actionName][rankIndex] .. ")");
		end
		actionTable = categoryTable.storage[actionName];
	end
	
	if (actionTable == nil or actionTable ~= o.currActionTable) then
		if (o.currActionTable ~= nil) then
			l_SaveConfig(o.currCategoryTable, o.currActionIndex, o.currActionRankIndex, o.currActionTable);
		end
		
		l_LoadConfig(categoryTable, actionIndex, rankIndex, actionTable);
		o.RollRanges_SetCurrent(actionTable, 1);
		o.currActionIndex = actionIndex;
		o.currActionRankIndex = rankIndex;
		o.currActionTable = actionTable;
	end
end

o.Actions_SetCurrent = l_SetCurrent;




function l_CreateAndLoad(categoryTable, actionName)
	if (actionName:gsub(" ", "") == "") then
		return;
	end
	if (categoryTable.storage ~= nil and categoryTable.storage[actionName] ~= nil) then
		return;
	end
	
	l_CreateTable_UsingToggleFuncs(categoryTable, actionName);
	
	local namesArray = categoryTable.actionNames;
	namesArray[#namesArray + 1] = actionName;
	tablesort(namesArray);
	local actionIndex = 1;
	while (namesArray[actionIndex] ~= actionName) do
		actionIndex = (actionIndex + 1);
	end
	
	l_SetCurrent(categoryTable, actionIndex, nil);
end


function l_CreateTable_UsingToggleFuncs(categoryTable, actionName)
	local actionTable = o.Segui.Config_CreateActionTable(categoryTable.storage, actionName, categoryTable.storageParent, categoryTable.storageKey);
	
	local actionToggleFunc = categoryTable.actionToggleFunc;
	if (actionToggleFunc ~= nil) then
		actionToggleFunc(true, actionName);
	end
	
	if (#categoryTable.actionNames == 1) then
		local categoryToggleFunc = categoryTable.categoryToggleFunc;
		if (categoryToggleFunc ~= nil) then
			categoryToggleFunc(true);
		end
	end
	
	return actionTable;
end

o.Actions_CreateTable_UsingToggleFuncs = l_CreateTable_UsingToggleFuncs;



function l_Rename(categoryTable, actionIndex, newName)
	local namesArray = categoryTable.actionNames;
	local oldName = namesArray[actionIndex];
	if (oldName == newName) then
		return;
	end
	
	local storage = categoryTable.storage;
	local actionTable = storage[oldName];
	storage[newName] = actionTable;
	storage[oldName] = nil;
	
	namesArray[actionIndex] = newName;
	tablesort(namesArray);
	local newActionIndex = 1;
	while (namesArray[newActionIndex] ~= newName) do
		newActionIndex = (newActionIndex + 1);
	end
	o.currActionIndex = newActionIndex;
	
	l_LoadConfig(categoryTable, actionIndex, nil, actionTable);
end



do
	local tableremove = table.remove;
	
	function l_Delete(categoryTable, actionIndex, rankIndex)
		if (categoryTable == nil) then
			return;
		end
		local namesArray = categoryTable.actionNames;
		local actionName = namesArray[actionIndex];
		if (actionName == nil) then
			return;
		end
		if (rankIndex ~= nil) then
			actionName = (actionName .. "(" .. categoryTable.rankNamesByActions[actionName][rankIndex] .. ")");
		end
		
		local storage = categoryTable.storage;
		if (storage ~= nil) then
			storage[actionName] = nil;
			if (next(storage) == nil) then
				if (categoryTable.storageParent ~= nil) then
					categoryTable.storage = nil;
					categoryTable.storageParent[categoryTable.storageKey] = nil;
				end
			end
		end
		local actionToggleFunc = categoryTable.actionToggleFunc;
		if (actionToggleFunc ~= nil) then
			actionToggleFunc(false, actionName);
		end
		
		if (rankIndex == nil and categoryTable.actionCreationPopupText ~= nil) then
			tableremove(namesArray, actionIndex);
			if (#namesArray == 0) then
				local categoryToggleFunc = categoryTable.categoryToggleFunc;
				if (categoryToggleFunc ~= nil) then
					categoryToggleFunc(false);
				end
			end
		end
		
		o.currActionIndex = nil;
		o.currActionRankIndex = nil;
		o.currActionTable = nil;
		o.currRRIndex = nil;
		o.currRRTable = nil;
		o.currEntryIndex = nil;
		o.currEntryTable = nil;
		l_SetCurrent(categoryTable, nil, nil);
	end
end




function l_LoadConfig(categoryTable, actionIndex, rankIndex, actionTable)
	local configBox = l_CONFIG_FRAME.ACTION_CONFIG_BOX;
	
	if (categoryTable ~= nil) then
		local actionName = categoryTable.actionNames[actionIndex];
		local rank;
		if (rankIndex ~= nil) then
			rank = categoryTable.rankNamesByActions[actionName][rankIndex];
		end
		local localizedActionNames = categoryTable.localizedActionNames;
		if (localizedActionNames ~= nil) then
			if (type(localizedActionNames) == "table") then
				actionName = (localizedActionNames[actionName] or actionName);
			else
				actionName = localizedActionNames:format(actionName);
			end
		end
		if (rank ~= nil) then
			actionName = (actionName .. " (" .. rank .. ")");
		end
		l_CONFIG_FRAME.ACTION_DD.TEXT:SetText(actionName);
	end
	
	if (categoryTable == nil or (categoryTable.actionCreationPopupText ~= nil and actionTable == nil)) then
		l_CONFIG_FRAME.ACTION_DD.TEXT:SetText("");
		configBox:SetBackdropColor(0.7, 0.7, 0.7);
		configBox.REPEAT_DELAY_EB:EnableMouse(false);
		configBox.REPEAT_DELAY_EB:SetText("");
		configBox.ALWAYS_TRY_SEND_CB:EnableMouse(false);
		configBox.ALWAYS_TRY_SEND_CB:SetChecked(false);
		configBox.RENAME_BUTTON:Disable();
		configBox.DELETE_BUTTON:Disable();
		return;
	end
	
	configBox:SetBackdropColor(0.4, 0.4, 0.4);
	configBox.REPEAT_DELAY_EB:EnableMouse(true);
	configBox.ALWAYS_TRY_SEND_CB:EnableMouse(true);
	if (categoryTable.actionCreationPopupText == nil) then
		configBox.RENAME_BUTTON:Disable();
	else
		configBox.RENAME_BUTTON:Enable();
	end
	configBox.DELETE_BUTTON:Enable();
	
	if (actionTable == nil) then
		configBox.REPEAT_DELAY_EB:SetNumber("0");
		configBox.ALWAYS_TRY_SEND_CB:SetChecked(false);
		return;
	end
	
	configBox.REPEAT_DELAY_EB:SetNumber(actionTable.repeatDelay or "0");
	configBox.ALWAYS_TRY_SEND_CB:SetChecked(actionTable.alwaysTrySend);
end



function l_SaveConfig(categoryTable, actionIndex, rankIndex, actionTable)
	local configBox = l_CONFIG_FRAME.ACTION_CONFIG_BOX;
	local repeatDelay = configBox.REPEAT_DELAY_EB:GetNumber();
	if (repeatDelay < 1) then
		repeatDelay = nil;
	end
	local alwaysTrySend = ((configBox.ALWAYS_TRY_SEND_CB:GetChecked() and true) or nil);
	
	if (actionTable ~= nil) then
		actionTable.repeatDelay = repeatDelay;
		actionTable.timeLastSent = nil;
		actionTable.alwaysTrySend = alwaysTrySend;
		l_LoadConfig(categoryTable, actionIndex, rankIndex, actionTable);
	end
end

o.Actions_SaveConfig = l_SaveConfig;




do
	local l_ActionDD_InitActionsList;
	local l_ActionDD_Button_OnClick;
	local loc_CREATE_NEW_ACTION = o.Localization.CREATE_NEW_ACTION;
	
	function l_ActionDD_Init(level)
		local categoryTable = o.currCategoryTable;
		if (categoryTable == nil) then
			return;
		end
		
		if (level == 1) then
			local AddButton;
			local buttonInfo;
			
			local list = categoryTable.actionNames;
			local numInList = #list;
			if (numInList > 30) then
				AddButton = UIDropDownMenu_AddButton;
				buttonInfo = {
					notCheckable = true;
					notClickable = true;
					hasArrow = true;
					value = list;
				};
				local lastIndex = 1;
				for index = 30, numInList, 30 do
					buttonInfo.text = ("%d - %d"):format(lastIndex, index);
					buttonInfo.arg1 = lastIndex;
					buttonInfo.arg2 = index;
					AddButton(buttonInfo, 1);
					lastIndex = (index + 1);
				end
				if (numInList % 30 ~= 0) then
					buttonInfo.text = ("%d - %d"):format(lastIndex, numInList);
					buttonInfo.arg1 = lastIndex;
					buttonInfo.arg2 = numInList;
					AddButton(buttonInfo, 1);
				end
			else
				l_ActionDD_InitActionsList(categoryTable, list, 1, nil, nil);
			end
			
			if (categoryTable.actionCreationPopupText ~= nil) then
				if (AddButton == nil) then
					AddButton = UIDropDownMenu_AddButton;
					buttonInfo = {
						func = StaticPopup_Show;
						text = loc_CREATE_NEW_ACTION;
						arg1 = ("Segui_CreateNewAction");
						arg2 = categoryTable.actionCreationPopupText;
						notCheckable = true;
					};
				else
					buttonInfo.func = StaticPopup_Show;
					buttonInfo.text = loc_CREATE_NEW_ACTION;
					buttonInfo.arg1 = ("Segui_CreateNewAction");
					buttonInfo.arg2 = categoryTable.actionCreationPopupText;
					buttonInfo.value = nil;
					buttonInfo.hasArrow = nil;
					buttonInfo.disabled = nil;
					buttonInfo.checked = nil;
					buttonInfo.notCheckable = true;
				end
				AddButton(buttonInfo, 1);
			end
		else
			-- "this" is currently the arrow from dropdown 1 or 2, or the dropdown itself. Try the dropdown first.
			local upperButton = this;
			if (upperButton.arg1 == nil) then
				-- Has to be the arrow.
				upperButton = upperButton:GetParent();
			end
			
			if (upperButton.arg2 == nil) then
				-- This is from ActionDD_InitActionsList. Since this isn't level 1, this has to be from a button that has ranks.
				local AddButton = UIDropDownMenu_AddButton;
				local buttonInfo = {
					value = categoryTable;
					func = l_ActionDD_Button_OnClick;
					arg1 = upperButton.arg1;
				};
				
				local storage = categoryTable.storage;
				local ranks = upperButton.value;
				local rankFormat = (categoryTable.actionNames[upperButton.arg1] .. "(%s)");
				local rank;
				for index = 1, #ranks, 1 do
					rank = ranks[index];
					buttonInfo.text = rank;
					buttonInfo.arg2 = index;
					buttonInfo.checked = (storage ~= nil and storage[rankFormat:format(rank)] ~= nil);
					AddButton(buttonInfo, level);
				end
			else
				-- This is a "1 - 30" type button.
				l_ActionDD_InitActionsList(categoryTable, upperButton.value, level, upperButton.arg1, upperButton.arg2);
			end
		end
	end
	
	
	do
		function l_ActionDD_InitActionsList(categoryTable, list, ddLevel, start, stop)
			local AddButton = UIDropDownMenu_AddButton;
			local buttonInfo = {};
			
			local storage = categoryTable.storage;
			local rankNamesByActions = categoryTable.rankNamesByActions;
			local localizedActionNames = categoryTable.localizedActionNames;
			local localizationIsTable = (type(localizedActionNames) == "table");
			buttonInfo.func = l_ActionDD_Button_OnClick;
			
			local actionName, ranks, shouldShowChecked, rankFormat, rankIndex, rank;
			for index = (start or 1), (stop or #list), 1 do
				actionName = list[index];
				ranks = ((rankNamesByActions ~= nil and rankNamesByActions[actionName]) or nil);
				
				if (ranks ~= nil) then
					buttonInfo.hasArrow = true;
					buttonInfo.value = ranks;
					shouldShowChecked = false;
					if (storage ~= nil) then
						if (storage[actionName] ~= nil) then
							shouldShowChecked = true;
						else
							rankFormat = (actionName .. "(%s)");
							rankIndex = 1;
							rank = ranks[1];
							while (shouldShowChecked == false and rank ~= nil) do
								if (storage[rankFormat:format(rank)] ~= nil) then
									shouldShowChecked = true;
								else
									rankIndex = (rankIndex + 1);
									rank = ranks[rankIndex];
								end
							end
						end
					end
					buttonInfo.checked = shouldShowChecked;
				else
					buttonInfo.hasArrow = nil;
					buttonInfo.value = nil;
					buttonInfo.checked = (storage ~= nil and storage[actionName] ~= nil);
				end
				
				buttonInfo.arg1 = index;
				if (localizedActionNames ~= nil) then
					if (localizationIsTable == true) then
						buttonInfo.text = (localizedActionNames[actionName] or actionName);
					else
						buttonInfo.text = localizedActionNames:format(actionName);
					end
				else
					buttonInfo.text = actionName;
				end
				AddButton(buttonInfo, ddLevel);
			end
		end
	end
	
	
	do
		function l_ActionDD_Button_OnClick(actionIndex, rankIndex)
			CloseDropDownMenus(1);
			l_SetCurrent(o.currCategoryTable, actionIndex, rankIndex);
		end
	end
end




function l_RenameButton_OnClick()
	local categoryTable = o.currCategoryTable;
	local actionName = categoryTable.actionNames[o.currActionIndex];
	local localizedActionNames = categoryTable.localizedActionNames;
	if (localizedActionNames ~= nil) then
		if (type(localizedActionNames) == "table") then
			actionName = (localizedActionNames[actionName] or actionName);
		else
			actionName = localizedActionNames:format(actionName);
		end
	end
	
	if (actionName ~= nil) then
		local dialog = StaticPopup_Show("Segui_RenameAction", actionName);
		_G[dialog:GetName() .. "WideEditBox"]:SetText(actionName);
	end
end


function l_DeleteButton_OnClick()
	l_Delete(o.currCategoryTable, o.currActionIndex, o.currActionRankIndex);
end



function l_t_OnGUILoaded(configFrame)
	l_t_OnGUILoaded = nil;
	o.Actions_t_OnGUILoaded = nil;
	
	l_CONFIG_FRAME = configFrame;
	configFrame.ACTION_DD.initialize = l_ActionDD_Init;
	configFrame.ACTION_CONFIG_BOX.RENAME_BUTTON:SetScript("OnClick", l_RenameButton_OnClick);
	configFrame.ACTION_CONFIG_BOX.DELETE_BUTTON:SetScript("OnClick", l_DeleteButton_OnClick);
end

o.Actions_t_OnGUILoaded = l_t_OnGUILoaded;

