

if (LoadLibrary2 ~= nil) then
	return;
end


do
	local select = select;
	local stringsub = string.sub;
	local _G = _G;
	local LibStub = LibStub;

	function LoadLibrary2(name, version, ...)
		name = (name .. stringsub(version, 1, 1));
		
		local curr_o, currVersion = LibStub:GetLibrary(name, true);
		local isPreLibStub = false;
		if (curr_o == nil) then
			curr_o = _G[name];
			if (curr_o ~= nil) then
				-- Pre-LibStub version of a library.
				isPreLibStub = true;
				currVersion = curr_o.VERSION;
			end
		end
		if (curr_o ~= nil) then
			if (currVersion >= version) then
				curr_o.SHOULD_LOAD = nil;
				return false, curr_o, currVersion;
			end
		end
		
		local depName;
		for index = 1, select("#", ...), 1 do
			depName = (select(index, ...));
			if (LibStub:GetLibrary(depName, true) == nil and _G[depName] == nil) then
				if (curr_o ~= nil) then
					curr_o.SHOULD_LOAD = nil;
				end
				error(("%s requires %s to be loaded."):format(name, depName), 2);
			end
		end
		
		if (isPreLibStub == true) then
			-- Pre-LibStub version of a library. Register with LibStub.
			-- LibStub doesn't provide the option of specifying an existing table to use for :NewLibrary(), so this has to be set manually.
			LibStub.libs[name] = curr_o;
			LibStub.minors[name] = currVersion;
		end
		local o = LibStub:NewLibrary(name, version);
		if (curr_o == nil) then
			-- First load. Set the global.
			_G[name] = o;
		end
		-- These next two need to be maintained for backwards compatibility.
		o.VERSION = version;
		o.OLD_VERSION = currVersion;
		o.SHOULD_LOAD = true;
		return true, o, currVersion;
	end
end

