

local o = SimpleSlash1; if (o.SHOULD_LOAD == nil) then return; end


local l_BuildCommandHandler; -- handlerFunc = (name)

local l_HandleFullSlashCommand; -- (owner, fullCommand)
local l_SplitFullCommand; -- subcommand, argsString, modifier = (fullCommand)

local l_CallHandlerFunction; -- success, statusOrErrorText = (config, funcType, argsArray, skipLastArg, handlerObj, sendHandler, invertedStatus)
local l_AddExtraArgs; -- arrayIndex = (array, arrayIndex, config, isStart, funcType)

local l_HandleNonToggleSubcommand; -- statusText = (config, argsArray, handlerObj, sendHandler)
local l_HandleToggleSubcommand; -- statusText = (config, argsArray, handlerObj, sendHandler, statusOnly)


local tostring = tostring; -- HandleFullSlashCommand, HandleToggleSubcommand
local type = type; -- HandleFullSlashCommand, CallHandlerFunction, AddExtraArgs




function l_BuildCommandHandler(owner)
	return (function(fullCommand) l_HandleFullSlashCommand(owner, fullCommand); end);
end

o.BuildCommandHandler = l_BuildCommandHandler;




do
	local DEFAULT_CHAT_FRAME = DEFAULT_CHAT_FRAME;
	local loc_SLASH_USAGE = o.Localization.SLASH_USAGE;
	local loc_SLASH_STATUS = o.Localization.SLASH_STATUS;
	local loc_NO_USAGE_INFO = o.Localization.NO_USAGE_INFO;
	local loc_UNKNOWN_SUBCOMMAND = o.Localization.UNKNOWN_SUBCOMMAND;
	local loc_HELP_TRAILER_STATUS = o.Localization.HELP_TRAILER_STATUS;
	local loc_USAGE_HEADER = o.Localization.USAGE_HEADER;
	local loc_NON_TOGGLE_SUBCOMMAND = o.Localization.NON_TOGGLE_SUBCOMMAND;
	local loc_ALREADY_FIRED_ONCE_ONLY = o.Localization.ALREADY_FIRED_ONCE_ONLY;
	local loc_GENERIC_ERROR = o.Localization.GENERIC_ERROR;
	
	function l_HandleFullSlashCommand(owner, fullCommand)
		local client = o.GetClient(owner);
		if (client == nil) then
			return;
		end
		local r, g, b = client._r, client._g, client._b;
		
		local subcommand, argsString, modifier = l_SplitFullCommand(fullCommand);
		local subcommandConfig = client[subcommand];
		if (subcommandConfig == nil) then
			local list;
			for subcommand in pairs(client) do
				if (subcommand:sub(1, 1) ~= "_") then
					subcommand = ("\"" .. subcommand .. "\"");
					list = ((list ~= nil and (list .. ", " .. subcommand)) or subcommand);
				end
			end
			DEFAULT_CHAT_FRAME:AddMessage(loc_UNKNOWN_SUBCOMMAND:format(owner, tostring(subcommand), list), r, g, b);
			return;
		end
		
		if (modifier == loc_SLASH_USAGE) then
			DEFAULT_CHAT_FRAME:AddMessage(loc_USAGE_HEADER:format(owner, subcommand), r, g, b);
			DEFAULT_CHAT_FRAME:AddMessage((subcommandConfig.usageText or loc_NO_USAGE_INFO), r, g, b);
			if (subcommandConfig.isNotToggle ~= true) then
				DEFAULT_CHAT_FRAME:AddMessage(loc_HELP_TRAILER_STATUS, r, g, b);
			end
			return;
		end
		
		local feedback;
		
		local argsArray;
		if (argsString ~= nil) then
			local splitter = subcommandConfig.argSplitter;
			local splitterType = type(splitter);
			if (splitterType == "string") then
				argsArray = { argsString:match(splitter) };
			elseif (splitterType == "function") then
				argsArray = { splitter(argsString) };
			else
				argsArray = { argsString };
			end
		else
			argsArray = {};
		end
		
		local success, statusText;
		if (subcommandConfig.onceOnly == true and subcommandConfig.alreadyFired == true) then
			success = true;
			statusText = loc_ALREADY_FIRED_ONCE_ONLY;
		else
			local handlerObj = (subcommandConfig.handlerObj or client._handlerObj);
			local sendHandler;
			if (subcommandConfig.sendHandler ~= nil) then
				sendHandler = subcommandConfig.sendHandler;
			else
				sendHandler = client._sendHandler;
			end
			local statusOnly = (modifier == loc_SLASH_STATUS);
			if (subcommandConfig.isNotToggle == true) then
				if (statusOnly == true) then
					success = true;
					feedback = loc_NON_TOGGLE_SUBCOMMAND:format(subcommand);
				else
					success, statusText = l_HandleNonToggleSubcommand(subcommandConfig, argsArray, handlerObj, sendHandler);
				end
			else
				success, statusText = l_HandleToggleSubcommand(subcommandConfig, argsArray, handlerObj, sendHandler, statusOnly);
			end
		end
		if (success == false) then
			feedback = (loc_GENERIC_ERROR:format(tostring(argsString), subcommand));
			if (statusText ~= nil) then
				feedback = (feedback .. " " .. statusText);
			end
		else
			if (statusText ~= nil) then
				statusText = statusText:gsub("#c", subcommand);
				for index = 1, #argsArray, 1 do
					statusText = statusText:gsub(("#i" .. index), tostring(argsArray[index]));
				end
				statusText = statusText:gsub("#i", tostring(argsString));
				feedback = statusText;
			end
			if (subcommandConfig.onceOnly == true) then
				subcommandConfig.alreadyFired = true;
			end
		end
		
		if (feedback ~= nil) then
			DEFAULT_CHAT_FRAME:AddMessage((owner .. ": " .. feedback), r, g, b);
		end
	end
end


do
	l_SplitFullCommand = assert(loadstring([[
		return (
			function(fullCommand)
				local subcommand, argsString = fullCommand:match("^(%S+) (.+)$");
				subcommand = (subcommand or fullCommand):lower();
				
				local modifier;
				if (subcommand == "]] .. o.Localization.SLASH_STATUS .. [[" or subcommand == "]] .. o.Localization.SLASH_USAGE .. [[") then
					modifier = subcommand;
					if (argsString ~= nil) then
						local newArgsString;
						subcommand, newArgsString = argsString:match("^(%S+) (.+)$");
						if (subcommand == nil) then
							subcommand = argsString;
							argsString = nil;
						else
							argsString = newArgsString;
						end
					end
				end
				
				return subcommand, argsString, modifier;
			end
		);
	]]))();
end




do
	local pcall = pcall;
	local unpack = unpack;
	local l_callingArray = {};
	
	function l_CallHandlerFunction(config, funcType, argsArray, skipLastArg, handlerObj, sendHandler, invertedStatus)
		local func = config[funcType:lower()];
		func = ((type(func) == "function" and func) or handlerObj[func]);
		
		local argIndex = 1;
		
		if (sendHandler == true) then
			l_callingArray[argIndex] = handlerObj;
			argIndex = (argIndex + 1);
		end
		
		argIndex = l_AddExtraArgs(l_callingArray, argIndex, config, true, funcType);
		if (funcType ~= "Func") then
			argIndex = l_AddExtraArgs(l_callingArray, argIndex, config, true, "");
		end
		
		local oldNumArgsString, newNumArgsString;
		if (funcType == "Func") then
			oldNumArgsString = ("noArg");
			newNumArgsString = ("numArgs");
		else
			oldNumArgsString = ("noArgFor" .. funcType);
			newNumArgsString = ("num" .. funcType .. "Args");
		end
		local numArgs;
		if (config[oldNumArgsString] == true) then
			numArgs = 0;
			config[newNumArgsString] = 0;
			config[oldNumArgsString] = nil;
		else
			numArgs = config[newNumArgsString];
		end
		if (numArgs ~= 0) then
			if (numArgs == nil) then
				numArgs = #argsArray;
				if (skipLastArg == true) then
					numArgs = (numArgs - 1);
				end
			end
			for index = 1, numArgs, 1 do
				l_callingArray[argIndex] = argsArray[index];
				argIndex = (argIndex + 1);
			end
		end
		
		if (invertedStatus ~= nil) then
			l_callingArray[argIndex] = invertedStatus;
			argIndex = (argIndex + 1);
		end
		
		argIndex = l_AddExtraArgs(l_callingArray, argIndex, config, false, funcType);
		if (funcType ~= "Func") then
			argIndex = l_AddExtraArgs(l_callingArray, argIndex, config, false, "");
		end
		
		for index = argIndex, #l_callingArray, 1 do
			l_callingArray[index] = nil;
		end
		
		local success, statusOrErrorText = pcall(func, unpack(l_callingArray, 1, (argIndex - 1)));
		return success, statusOrErrorText;
	end
end



function l_AddExtraArgs(array, arrayIndex, config, isStart, funcType)
	local identifier = ("extra" .. funcType .. ((isStart and "Start") or "End") .. "Arg");
	
	local extraArg = config[identifier];
	if (extraArg ~= nil) then
		array[arrayIndex] = extraArg;
		arrayIndex = (arrayIndex + 1);
	end
	
	local extraArgs = config[identifier .. "s"];
	if (extraArgs ~= nil) then
		for index = 1, #extraArgs, 1 do
			array[arrayIndex] = extraArgs[index];
			arrayIndex = (arrayIndex + 1);
		end
	end
	
	return arrayIndex;
end




do
	local loc_GENERIC_STATUS = o.Localization.GENERIC_STATUS;
	
	function l_HandleNonToggleSubcommand(config, argsArray, handlerObj, sendHandler)
		local success, errorText = l_CallHandlerFunction(config, "Func", argsArray, false, handlerObj, sendHandler, nil);
		if (success == false) then
			return false, (config.errorText or errorText);
		end
		
		local statusText;
		if (config.noStatusFeedback ~= true) then
			statusText = config.statusText;
		end
		return true, statusText;
	end
end




do
	local loc_GENERIC_STATUS = o.Localization.GENERIC_STATUS;
	local loc_CURRENTLY = o.Localization.CURRENTLY;
	local loc_NOW = o.Localization.NOW;
	
	function l_HandleToggleSubcommand(config, argsArray, handlerObj, sendHandler, statusOnly)
		local status;
		
		if (statusOnly == true or config.noStatusInversion ~= true) then
			-- If we're only showing the status, or the "set" requires a status inversion, then get the current status.
			local success, statusOrErrorText = l_CallHandlerFunction(config, "Get", argsArray, (statusOnly == true), handlerObj, sendHandler, nil);
			if (success == true) then
				status = statusOrErrorText;
			else
				return false, (config.getFuncErrorText or config.errorText or statusOrErrorText);
			end
		end
		
		if (statusOnly == false) then
			local invertedStatus = nil;
			if (config.noStatusInversion ~= true) then
				invertedStatus = (not status);
			end
			if (config.noArgForSet == true) then
				config.numSetArgs = 0;
				config.noArgForSet = nil;
			end
			local success, statusOrErrorText = l_CallHandlerFunction(config, "Set", argsArray, false, handlerObj, sendHandler, invertedStatus);
			if (success == true) then
				if (statusOrErrorText == nil) then
					-- Get the new status explicitly from the getFunc. Even though it may actually be nil, it must be verified.
					local success, statusOrErrorText = l_CallHandlerFunction(config, "Get", argsArray, true, handlerObj, sendHandler, nil);
					if (success == true) then
						status = statusOrErrorText;
					else
						return false, (config.getFuncErrorText or config.errorText or statusOrErrorText);
					end
				else
					status = statusOrErrorText;
				end
			else
				return false, (config.setFuncErrorText or config.errorText or statusOrErrorText);
			end
		end
		
		local statusText;
		if (config.noStatusFeedback ~= true) then
			if (config.plainStatus == true) then
				status = tostring(status);
			else
				status = tostring(config[status] or status);
			end
			if (config.resultFormat ~= nil) then
				config.statusFormat = config.resultFormat;
				config.resultFormat = nil;
			end
			if (config.statusFormat ~= nil) then
				status = config.statusFormat:format(status);
			end
			statusText = (config.statusText or loc_GENERIC_STATUS);
			statusText = statusText:gsub("#s", ((statusOnly == true and loc_CURRENTLY) or loc_NOW));
			statusText = statusText:gsub("#r", status);
		end
		return true, statusText;
	end
end




o.Localization = nil;

