

local o = EventsManager1; if (o.SHOULD_LOAD == nil) then return; end


local l_t_GetLocals; -- scriptsFrame, oneTimeEvents, customEvents, handlersByEvent = ()

local l_DispatchEvent; -- (event, ...)
local l_DispatchCustomEvent; -- (event, ...)
local l_OnEvent; -- (scriptsFrame, event, ...)

local l_IsCustomEventAvailable; -- isAvailable, oneTimeOnly = (event)
local l_AddCustomEvent; -- (event, oneTimeOnly)
local l_RemoveCustomEvent; -- (event)

local l_RegisterForEvent; -- handlerData = (handlerObj, keyName, event, sendHandler, sendEvent, ...)
local l_CreateHandlerData; -- handlerData = (handlerObj, keyName, event, sendHandler, sendEvent, ...)
local l_GetHandlerData; -- handlerData = (handlerObj)
local l_UnregisterForEvent; -- (handlerObj, event)
local l_UnregisterForAllEvents; -- (handlerObj)

local l_IsDefaultEvent; -- isDefaultEvent = (event)


local type = type; -- Damn near everything.
local pairs = pairs; -- DispatchEvent, RemoveCustomEvent, UnregisterForAllEvents


local l_SCRIPTS_FRAME;


local l_oneTimeEvents;
local l_customEvents;
local l_handlersByEvent;


do
	if (o.t_GetLocals ~= nil) then
		l_SCRIPTS_FRAME, l_oneTimeEvents, l_customEvents, l_handlersByEvent = o.t_GetLocals();
	else
		l_SCRIPTS_FRAME = o.SCRIPTS_FRAME;
		o.SCRIPTS_FRAME = nil;
		if (l_SCRIPTS_FRAME == nil) then
			l_SCRIPTS_FRAME = CreateFrame("Frame", "EventsManager1_ScriptsFrame", WorldFrame, nil);
			l_SCRIPTS_FRAME:Hide();
		end
		l_oneTimeEvents = (
		  o.oneTimeEvents
		  or {
			["VARIABLES_LOADED"] = true;
			["PLAYER_LOGIN"] = true;
		  }
		);
		o.oneTimeEvents = nil;
		l_customEvents = (
		  o.customEvents
		  or {
		    ["EventsManager1_CUSTOM_EVENT_ADDED"] = false;
			["EventsManager1_CUSTOM_EVENT_REMOVED"] = false;
		  }
		);
		o.customEvents = nil;
		l_handlersByEvent = (o.handlersByEvent or {});
		o.handlersByEvent = nil;
	end
	
	if (o.OLD_VERSION ~= nil and o.OLD_VERSION < 130) then
		-- Needs upgrading; string and table handlerData are no longer used.
		local sendHandler, sendEvent, keyName;
		for event, handlers in pairs(l_handlersByEvent) do
			for handlerObj, handlerData in pairs(handlers) do
				if (type(handlerData) == "string") then
					sendHandler, sendEvent, keyName = handlerData:match("^(.?)(.?)%-?(.*)$");
					handlers[handlerObj] = l_CreateHandlerData(handlerObj, keyName, event, (sendHandler == "1"), (sendEvent == "1"));
				elseif (type(handlerData) == "table") then
					keyName, sendHandler, sendEvent = handlerData[1], handlerData[2], handlerData[3];
					handlers[handlerObj] = l_CreateHandlerData(handlerObj, keyName, event, sendHandler, sendEvent, unpack(handlerData, 4, #handlerData));
				end
			end
		end
	end
end




function l_t_GetLocals()
	l_t_GetLocals = nil;
	o.t_GetLocals = nil;
	
	return l_SCRIPTS_FRAME, l_oneTimeEvents, l_customEvents, l_handlersByEvent;
end

o.t_GetLocals = l_t_GetLocals;




do
	local pcall = pcall;
	local geterrorhandler = geterrorhandler;
	
	function l_DispatchEvent(event, ...)
		local handlers = l_handlersByEvent[event];
		if (handlers == nil) then
			if (l_oneTimeEvents[event] == true) then
				l_oneTimeEvents[event] = nil;
				if (l_customEvents[event] ~= nil) then
					l_RemoveCustomEvent(event);
				end
			end
			return;
		end
		
		local defaultKeyName = ("OnEvent_" .. event);
		local success, errorText;
		for handlerObj, handlerData in pairs(handlers) do
			if (handlerData == true) then
				-- func(...)
				success, errorText = pcall(handlerObj, ...);
			elseif (handlerData == false) then
				-- table[key](...)
				success, errorText = pcall(handlerObj[defaultKeyName], ...);
			elseif (handlerData == 4) then
				-- func(event, ...)
				success, errorText = pcall(handlerObj, event, ...);
			elseif (handlerData == 3) then
				-- table[key](event, ...)
				success, errorText = pcall(handlerObj[defaultKeyName], event, ...);
			elseif (handlerData == 2) then
				-- table[key](table, ...)
				success, errorText = pcall(handlerObj[defaultKeyName], handlerObj, ...);
			elseif (handlerData == 1) then
				-- table[key](table, event, ...)
				success, errorText = pcall(handlerObj[defaultKeyName], handlerObj, event, ...);
			else
				-- Wrapper.
				success, errorText = pcall(handlerData, ...);
			end
			if (success == false) then
				geterrorhandler()(errorText);
			end
		end
		
		if (l_oneTimeEvents[event] == true) then
			l_oneTimeEvents[event] = nil;
			for handlerObj in pairs(handlers) do
				l_UnregisterForEvent(handlerObj, event);
			end
			if (l_customEvents[event] ~= nil) then
				l_RemoveCustomEvent(event);
			end
		end
	end
end


function l_DispatchCustomEvent(event, ...)
	if (l_customEvents[event] ~= nil) then
		l_DispatchEvent(event, ...);
	else
		error(("EventsManager1.DispatchCustomEvent: Unknown custom event name, \"%s\""):format(event), 2);
	end
end

o.DispatchEvent = l_DispatchCustomEvent;



do
	function l_OnEvent(scriptsFrame, event, ...)
		l_DispatchEvent(event, ...);
	end

	l_SCRIPTS_FRAME:SetScript("OnEvent", l_OnEvent);
end




function l_IsCustomEventAvailable(event)
	if (type(event) ~= "string") then
		error(("EventsManager1.IsCustomEventAvailable: Bad argument #1; expected string, received %s."):format(type(event)), 2);
	end
	if (l_IsDefaultEvent(event) == true) then
		error(("EventsManager1.IsCustomEventAvailable: %s is a default event."):format(event), 2);
	end
	
	local onceOnly = l_customEvents[event];
	return (onceOnly ~= nil), onceOnly;
end

o.IsCustomEventAvailable = l_IsCustomEventAvailable;



function l_AddCustomEvent(event, isOnceOnly)
	if (type(event) ~= "string") then
		error(("EventsManager1.AddCustomEvent: Bad argument #1; expected string, received %s."):format(type(event)), 2);
	end
	if (l_IsDefaultEvent(event) == true) then
		error(("EventsManager1.AddCustomEvent: Cannot add a default event, %s, as a custom event."):format(event), 2);
	end
	isOnceOnly = ((isOnceOnly and true) or false);
	
	local existing = l_customEvents[event];
	if (existing ~= nil) then
		if (existing ~= isOnceOnly) then
			error(("EventsManager1.AddCustomEvent: Custom event named %s already exists."):format(event), 2);
		end
	else
		l_customEvents[event] = isOnceOnly;
		l_oneTimeEvents[event] = (isOnceOnly or nil);
		l_DispatchCustomEvent("EventsManager1_CUSTOM_EVENT_ADDED", event, isOnceOnly);
	end
end

o.AddCustomEvent = l_AddCustomEvent;



function l_RemoveCustomEvent(event)
	if (type(event) ~= "string") then
		error(("EventsManager1.RemoveCustomEvent: Bad argument #1; expected string, received %s."):format(type(event)), 2);
	end
	if (event == "EventsManager1_CUSTOM_EVENT_ADDED" or event == "EventsManager1_CUSTOM_EVENT_REMOVED") then
		error(("EventsManager1.RemoveCustomEvent: Custom event \"%s\" cannot be removed."):format(event), 2);
	end
	
	local isOnceOnly = l_customEvents[event];
	if (isOnceOnly ~= nil) then
		l_customEvents[event] = nil;
		l_oneTimeEvents[event] = nil;
		if (l_handlersByEvent[event] ~= nil) then
			for handlerObj in pairs(l_handlersByEvent[event]) do
				l_UnregisterForEvent(handlerObj, event);
			end
			l_handlersByEvent[event] = nil;
		end
		l_DispatchCustomEvent("EventsManager1_CUSTOM_EVENT_REMOVED", event, isOnceOnly);
	end
end

-- Remove these two from earlier versions.
l_RemoveCustomEvent("EventsManager1_EVENT_REGISTERED");
l_RemoveCustomEvent("EventsManager1_EVENT_UNREGISTERED");
o.RemoveCustomEvent = l_RemoveCustomEvent;




function l_RegisterForEvent(handlerObj, keyName, event, sendHandler, sendEvent, ...)
	if (type(handlerObj) ~= "table" and type(handlerObj) ~= "function") then
		error(("EventsManager1.RegisterForEvent: Bad argument #1; expected table or function, received %s."):format(type(handlerObj)), 2);
	end
	if (type(event) ~= "string") then
		error(("EventsManager1.RegisterForEvent: Bad argument #3; expected string, received %s."):format(type(event)), 2);
	end
	
	local isDefaultEvent = l_IsDefaultEvent(event);
	if (isDefaultEvent == false and l_customEvents[event] == nil) then
		error(("EventsManager1.RegisterForEvent: Unknown event name: %s."):format(tostring(event)), 2);
	end
	
	local handlersForEvent = l_handlersByEvent[event];
	if (handlersForEvent == nil) then
		handlersForEvent = {};
		l_handlersByEvent[event] = handlersForEvent;
		if (isDefaultEvent == true) then
			l_SCRIPTS_FRAME:RegisterEvent(event);
		end
	end
	
	local handlerData;
	if (keyName ~= nil and type(keyName) ~= "string") then
		handlerData = keyName;
	else
		handlerData = l_CreateHandlerData(handlerObj, keyName, event, sendHandler, sendEvent, ...);
	end
	handlersForEvent[handlerObj] = handlerData;
	return handlerData;
end

o.RegisterForEvent = l_RegisterForEvent;


do
	local assert = assert;
	local loadstring = loadstring;
	local select = select;
	
	function l_CreateHandlerData(handlerObj, keyName, event, sendHandler, sendEvent, ...)
		local numExtraArgs = select("#", ...);
		local defaultKeyName = ("OnEvent_" .. event);
		if (keyName == nil) then
			keyName = defaultKeyName;
		end
		
		if (numExtraArgs ~= 0 or keyName ~= defaultKeyName) then
			-- Need to use a wrapper function to accomodate the extra args or the different key name.
			local loader = [=[
				local handlerObj = ...;
				STATIC_ARGS_ASSIGNMENT
				return (function(...) FUNC_STRING end);
			]=]
			local funcString;
			
			if (type(handlerObj) == "function") then
				funcString = ("handlerObj(");
			else
				local accessor;
				if (keyName:find("[^%w_]") ~= nil) then
					-- Can't use the . or : operators for keyNames containing non-alphanumeric (+underscore) characters.
					if (sendHandler) then
						accessor = ("[\"" .. keyName .. "\"](handlerObj, ");
					else
						accessor = ("[\"" .. keyName .. "\"](");
					end
				else
					if (sendHandler) then
						accessor = (":" .. keyName .. "(");
					else
						accessor =("." .. keyName .. "(");
					end
				end
				funcString = ("handlerObj" .. accessor);
			end
			
			local staticArgsString;
			for index = 1, numExtraArgs, 1 do
				staticArgsString = (((staticArgsString ~= nil and (staticArgsString .. ", ")) or "") .. "staticArg" .. index);
			end
			if (staticArgsString ~= nil) then
				funcString = (funcString .. staticArgsString .. ", ");
				loader = loader:gsub("STATIC_ARGS_ASSIGNMENT", (staticArgsString .. " = select(2, ...);"), 1);
			else
				loader = loader:gsub("STATIC_ARGS_ASSIGNMENT", "", 1);
			end
			
			if (sendEvent) then
				--[[
				The event itself can be placed into the string here. This removes the ability to share handlerDatas between
				multiple handlers which use all of the same properties except the event, but that is a very rare case, and is
				therefore probably not worth accounting for.
				--]]
				funcString = (funcString .. "\"" .. event .. "\", ");
			end
			
			funcString = (funcString .. "...);");
			
			loader = loader:gsub("FUNC_STRING", funcString, 1);
			handlerData = assert(loadstring(loader))(handlerObj, ...);
			
		else
			-- Can just use a number or boolean to remember which properties to obey.
			if (type(handlerObj) == "table") then
				if (sendHandler) then
					if (sendEvent) then
						handlerData = 1;
					else
						handlerData = 2;
					end
				else
					if (sendEvent == true) then
						handlerData = 3;
					else
						-- Common case: table[key](...)
						-- Use false to conserve memory.
						handlerData = false;
					end
				end
			else
				if (sendEvent) then
					handlerData = 4;
				else
					-- Common case: func(...)
					-- Use true to conserve memory.
					handlerData = true;
				end
			end
		end
		
		return handlerData;
	end
	
	o.CreateHandlerData = l_CreateHandlerData;
end


function l_GetHandlerData(handlerObj, event)
	local handlerData;
	local handlers = l_handlersByEvent[event];
	if (handlers ~= nil) then
		handlerData = handlers[handlerObj];
	end
	return handlerData;
end

o.GetHandlerData = l_GetHandlerData;



function l_UnregisterForEvent(handlerObj, event)
	if (type(handlerObj) ~= "table" and type(handlerObj) ~= "function") then
		error(("EventsManager1.UnregisterForEvent: Bad argument #1; expected table or function, received %s."):format(type(handlerObj)), 2);
	end
	if (type(event) ~= "string") then
		error(("EventsManager1.UnregisterForEvent: Bad argument #2; expected string, received %s."):format(type(event)), 2);
	end
	
	local isDefaultEvent = l_IsDefaultEvent(event);
	if (isDefaultEvent == false and l_customEvents[event] == nil) then
		error(("EventsManager1.UnregisterForEvent: Unknown event name: %s."):format(tostring(event)), 2);
	end
	
	local handlersForEvent = l_handlersByEvent[event];
	if (handlersForEvent ~= nil) then
		local handler = handlersForEvent[handlerObj];
		if (handler ~= nil) then
			handlersForEvent[handlerObj] = nil;
			if (next(handlersForEvent) == nil) then
				l_handlersByEvent[event] = nil;
				if (isDefaultEvent == true) then
					l_SCRIPTS_FRAME:UnregisterEvent(event);
				end
			end
		end
	end
end

o.UnregisterForEvent = l_UnregisterForEvent;


function l_UnregisterForAllEvents(handlerObj)
	if (type(handlerObj) ~= "table" and type(handlerObj) ~= "function") then
		error(("EventsManager1.UnregisterForAllEvents: Bad argument #1; expected table or function, received %s."):format(type(handlerObj)), 2);
	end
	
	for eventName, handlers in pairs(l_handlersByEvent) do
		if (handlers[handlerObj] ~= nil) then
			l_UnregisterForEvent(handlerObj, eventName);
		end
	end
end

o.UnregisterForAllEvents = l_UnregisterForAllEvents;




function l_IsDefaultEvent(event)
	local isDefaultEvent = false;
	if (l_SCRIPTS_FRAME:IsEventRegistered(event) ~= nil) then
		isDefaultEvent = true;
	else
		-- Hack: Try to register the event with the scripts frame. If it takes, then the event has to be a default event, because only those will stick.
		l_SCRIPTS_FRAME:RegisterEvent(event);
		if (l_SCRIPTS_FRAME:IsEventRegistered(event) ~= nil) then
			isDefaultEvent = true;
			l_SCRIPTS_FRAME:UnregisterEvent(event);
		end
	end
	return isDefaultEvent;
end

