

local o = DelaysManager2; if (o.SHOULD_LOAD == nil) then return; end
local c = {};
local c_metatable;


local l_t_GetLocals; -- classMeta, scriptsFrame, handlers, tempRegistry (dep), handlersToStart (dep), dispatching, needsSort, needsCleanup = ()

local l_CreateDelayHandler; -- delayHandler = (funcObj, funcKey, delay, repeating, sendFuncObj, ...)

local l_OnUpdate; -- (scriptsFrame, elapsed)
local l_SortByKey_triggerTime; -- elem2First = (elem1, elem2)

-- local l_c_Start; -- (self)
-- local l_c_Stop; -- (self, pauseOnly)
-- local l_c_GetTimeLeft; -- timeLeft = (self)
-- local l_c_SetTimeLeft; -- (self, newTime)
-- local l_c_GetFunc; -- funcObj, funcKey = (self)
-- local l_c_SetFunc; -- (self, funcObj, funcKey)
-- local l_c_GetRepeating; -- isRepeating = (self)
-- local l_c_SetRepeating; -- (self, isRepeating)
-- local l_c_GetSendHandler; -- sendHandler = (self)
-- local l_c_SetSendHandler; -- (self, sendHandler)
-- local l_c_GetSendFuncObj; -- sendFuncObj = (self)
-- local l_c_SetSendFuncObj; -- (self, sendFuncObj)


local pairs = pairs; -- OnUpdate, c:Stop
local tablesort = table.sort; -- OnUpdate, c:Start, c:SetTimeLeft
local tableremove = table.remove; -- OnUpdate, c:Stop
local GetTime = GetTime; -- c:Start, c:GetTimeLeft, c:SetTimeLeft


local l_SCRIPTS_FRAME;


local l_timer = GetTime();
local l_handlers;
local l_earliestHandler;
local l_dispatching = false;
local l_needsSort = false;
local l_needsCleanup = false;


do
	if (o.t_GetLocals ~= nil) then
		local tempRegistry, handlersToStart;
		c_metatable, l_SCRIPTS_FRAME, l_handlers, tempRegistry, handlersToStart, l_dispatching, l_needsSort, l_needsCleanup = o.t_GetLocals();
		if (tempRegistry ~= nil) then
			if (next(tempRegistry) ~= nil) then
				l_dispatching = true;
			end
		end
	else
		c_metatable = (o.c_DelayHandler_metatable or {});
		o.c_DelayHandler_metatable = nil;
		l_SCRIPTS_FRAME = o.SCRIPTS_FRAME;
		o.SCRIPTS_FRAME = nil;
		if (l_SCRIPTS_FRAME == nil) then
			l_SCRIPTS_FRAME = CreateFrame("Frame", "DelaysManager2_ScriptsFrame", WorldFrame, nil);
			l_SCRIPTS_FRAME:Hide();
		end
		l_handlers = (o.registry or {});
		o.registry = nil;
		o.tempRegistry = nil;
	end
	
	if (o.OLD_VERSION ~= nil and o.OLD_VERSION < 210) then
		-- Convert from "[handler] = true" to "[index] = handler"...
		local handlers = {};
		local index = 0;
		for handler in pairs(l_handlers) do
			index = (index + 1);
			handlers[index] = handler;
			handler.triggerTime = (l_timer + handler.countdown);
			handler.countdown = nil;
		end
		l_handlers = handlers;
	end
	c_metatable.__index = c;
end




function l_t_GetLocals()
	l_t_GetLocals = nil;
	o.t_GetLocals = nil;
	
	return c_metatable, l_SCRIPTS_FRAME, l_handlers, nil, l_handlersToStart, l_dispatching, l_needsSort, l_needsCleanup;
end

o.t_GetLocals = l_t_GetLocals;




do
	local setmetatable = setmetatable;
	
	function l_CreateDelayHandler(funcObj, funcKey, delay, repeating, sendFuncObj, ...)
		local delayHandler = { ... };
		setmetatable(delayHandler, c_metatable);
		delayHandler:SetFunc(funcObj, funcKey);
		delayHandler:SetDelay(delay);
		delayHandler:SetRepeating(repeating);
		delayHandler:SetSendFuncObj(sendFuncObj);
		return delayHandler;
	end
	
	o.CreateDelayHandler = l_CreateDelayHandler;
end




do
	local pcall = pcall;
	local unpack = unpack;
	local geterrorhandler = geterrorhandler;
	
	function l_OnUpdate(self, elapsed)
		l_timer = (l_timer + elapsed);
		if (l_timer > l_earliestHandler.triggerTime) then
			
			l_dispatching = true;
			local index = #l_handlers;
			local handler = l_handlers[index];
			local func, success, errorText;
			while (handler ~= nil and l_timer > handler.triggerTime) do
				if (handler.inactive ~= true) then
					func = ((handler.funcKey ~= nil and handler.funcObj[handler.funcKey]) or handler.funcObj);
					if (handler.sendHandler == true) then
						if (handler.sendFuncObj == true) then
							success, errorText = pcall(func, handler.funcObj, handler, unpack(handler, 1, #handler));
						else
							success, errorText = pcall(func, handler, unpack(handler, 1, #handler));
						end
					else
						if (handler.sendFuncObj == true) then
							success, errorText = pcall(func, handler.funcObj, unpack(handler, 1, #handler));
						else
							success, errorText = pcall(func, unpack(handler, 1, #handler));
						end
					end
					if (success == false) then
						geterrorhandler()(errorText);
					end
					if (handler.repeating == true) then
						l_needsSort = true;
						handler.triggerTime = (l_timer + handler.delay);
					else
						handler.running = nil;
						l_handlers[index] = nil;
					end
				else
					handler.running = nil;
					l_handlers[index] = nil;
				end
				index = (index - 1);
				handler = l_handlers[index];
			end
			l_dispatching = false;
			
			if (l_needsSort == true) then
				l_needsSort = false;
				tablesort(l_handlers, l_SortByKey_triggerTime);
			end
			
			if (l_needsCleanup == true) then
				l_needsCleanup = false;
				for index, handler in pairs(l_handlers) do
					if (handler.inactive == true) then
						handler.inactive = nil;
						tableremove(l_handlers, index);
					end
				end
			end
			
			l_earliestHandler = l_handlers[#l_handlers];
			if (l_earliestHandler == nil) then
				self:Hide();
			end
		end
	end
	
	l_SCRIPTS_FRAME:SetScript("OnUpdate", l_OnUpdate);
end



function l_SortByKey_triggerTime(elem1, elem2)
	-- Handlers that will trigger sooner need to be at the end of the array.
	return (elem1.triggerTime > elem2.triggerTime);
end




function c:Start()
	if (self.running == true) then
		return;
	end
	self.running = true;
	
	self.inactive = nil;
	l_handlers[#l_handlers + 1] = self;
	if (#l_handlers == 1) then
		l_timer = GetTime();
		l_SCRIPTS_FRAME:Show();
	end
	
	if (self.paused ~= nil) then
		-- The value held by "paused" is the amount of time that was remaining until this handler was to trigger, at the time it was paused.
		if (self.paused == true) then
			self.triggerTime = (l_timer + self.delay);
		else
			self.triggerTime = (l_timer + self.paused);
		end
		self.paused = nil;
	else
		self.triggerTime = (l_timer + self.delay);
	end
	
	if (l_dispatching == true) then
		l_needsSort = true;
	else
		l_needsSort = false;
		tablesort(l_handlers, l_SortByKey_triggerTime);
		l_earliestHandler = l_handlers[#l_handlers];
	end
end



function c:Stop(pauseOnly)
	if (self.running == nil) then
		if (pauseOnly ~= true) then
			self.paused = nil;
		end
		return;
	end
	self.running = nil;
	
	if (pauseOnly == true) then
		-- Store the time that was remaining until trigger time.
		self.paused = self:GetTimeLeft();
	end
	
	for index, handler in pairs(l_handlers) do
		if (handler == self) then
			if (l_dispatching == true) then
				l_needsCleanup = true;
				self.inactive = true;
			else
				tableremove(l_handlers, index);
				l_earliestHandler = l_handlers[#l_handlers];
				if (l_earliestHandler == nil) then
					l_SCRIPTS_FRAME:Hide();
				end
			end
			return;
		end
	end
end



function c:GetTimeLeft()
	return (self.triggerTime - GetTime());
end


function c:SetTimeLeft(timeLeft)
	self.triggerTime = (GetTime() + timeLeft);
	if (self.running == true) then
		if (l_dispatching == true) then
			l_needsSort = true;
		else
			l_needsSort = false;
			tablesort(l_handlers, l_SortByKey_triggerTime);
			l_earliestHandler = l_handlers[#l_handlers];
		end
	end
end



function c:GetFunc()
	return self.funcObj, self.funcKey;
end


function c:SetFunc(funcObj, funcKey)
	self.funcObj, self.funcKey = funcObj, funcKey;
end



function c:GetDelay()
	return self.delay;
end


function c:SetDelay(delay)
	self.delay = delay;
end



function c:GetRepeating()
	return (self.repeating == true);
end


function c:SetRepeating(repeating)
	self.repeating = ((repeating and true) or nil);
end



function c:GetSendHandler()
	return (self.sendHandler == true);
end


function c:SetSendHandler(send)
	self.sendHandler = ((send and true) or nil);
end



function c:GetSendFuncObj()
	return (self.sendFuncObj == true);
end


function c:SetSendFuncObj(send)
	self.sendFuncObj = ((send and true) or nil);
end

