

local o = Segui;


local l_t_Init; -- ()
local l_t_OnConfigLoaded; -- ()

local l_ToggleSilence; -- (enabled)
local l_ToggleDetective; -- (enabled)

local l_PrepareEntry; -- message, messageType, language, channelOrTarget = (entryTable, argsArray, capturesArray)
	-- local l_SubstituteSpecialText; -- substitution = (prefix, text)
		-- local l_SubstituteUnitNameByMacroText; -- unitName = (macroText)

local l_CheckAction; -- didSendFromAction = (actionTable, triggerBits, argsArray, capturesArray)
local l_CheckRollRange; -- didSendFromRollRange = (rrTable, roll, triggerBits, currTime, argsArray, capturesArray)
local l_CheckEntry; -- didSendEntry = (entryTable, currTime, argsArray, capturesArray)

local l_OnEvent_ActionStartedOrStopped; -- (event, unit, actionName, actionRank)
	-- local l_PrintActionDetectiveFeedback; -- (name, rank, event)

local l_SpeakByGlobalHotkeyNumber; -- (number)

local l_OnEvent_CHAT_MSG; -- (event, msg, ...)
	-- local l_CaptureMatches; -- doesMatch = (capturesArray, start, stop, ...)
local l_OnEvent_COMBAT_LOG_EVENT_UNFILTERED; -- (timestamp, event, ...)
	-- local l_SetupArgsArray; -- (argsArray, event, sourceGUID, sourceName, sourceFlags, destGUID, destName, destFlags, ...)

local l_OnEvent_PLAYER_REGEN_DISABLED; -- ()
local l_OnEvent_PLAYER_REGEN_ENABLED; -- ()
local l_OnEvent_UNIT_HEALTH; -- (unit)
local l_OnEvent_UNIT_MANA; -- (unit)
local l_OnEvent_TRADE_SHOW; -- ()
local l_OnEvent_PLAYER_UNGHOST; -- ()

local l_OnReloadUI; -- ()


local pairs = pairs; -- OnEvent_CHAT_MSG, OnEvent_COMBAT_LOG_EVENT_UNFILTERED
local ipairs = ipairs; -- CheckAction, CheckRollRange
local select = select; -- OnEvent_CHAT_MSG, CaptureMatches, SetupArgsArray
local tonumber = tonumber; -- SpeakByGlobalHotkeyNumber, OnEvent_CHAT_MSG, OnEvent_COMBAT_LOG_EVENT_UNFILTERED, SubstituteSpecialText
local tostring = tostring; -- SpeakByGlobalHotkeyNumber, OnEvent_CHAT_MSG, OnEvent_COMBAT_LOG_EVENT_UNFILTERED, SubstituteSpecialText
local stringmatch = string.match; -- OnEvent_ActionStartedOrStopped, OnEvent_CHAT_MSG, OnEvent_COMBAT_LOG_EVENT_UNFILTERED


local l_MESSAGE_TYPE_LIST = {
	[1] = ("CHANNEL");
	[2] = ("BASIC_EMOTE"); -- Not valid for SendChatMessage(); handled by DoEmote() instead.
	[3] = ("EMOTE");
	[4] = ("GUILD");
	[5] = ("OFFICER");
	[6] = ("PARTY");
	[7] = ("RAID");
	[8] = ("SAY");
	[9] = ("WHISPER");
	[10] = ("YELL");
	[11] = ("RAID_WARNING");
	[12] = ("BATTLEGROUND");
	[13] = ("RAID_OR_PARTY"); -- Custom type that means "send to raid chat if in a raid, or otherwise party".
};

local l_TRIGGER_BITS_BY_EVENT = {
	UNIT_SPELLCAST_START = 0x1;
	UNIT_SPELLCAST_SUCCEEDED = 0x2;
	UNIT_SPELLCAST_CHANNEL_START = 0x8;
	UNIT_SPELLCAST_CHANNEL_STOP = 0x10;
	UNIT_SPELLCAST_INTERRUPTED = 0x4;
};


local l_silenced = nil;
local l_detectiveEnabled = nil;

local l_hotkeyActions = nil;
local l_messageEvents = nil;
local l_combatEvents = nil;
local l_miscEvents = nil;
local l_generalActions = nil;




function l_t_OnConfigLoaded()
	l_t_OnConfigLoaded = nil;
	o.Speech_t_OnConfigLoaded = nil;
	
	l_hotkeyActions = o.globalSpeechMemory.hotkeys;
	
	local speechMemory = o.speechMemory;
	l_messageEvents = speechMemory.messageEvents;
	l_combatEvents = speechMemory.combatEvents;
	l_miscEvents = speechMemory.miscEvents;
	l_generalActions = speechMemory.generalActions;
	
	local RFE = o.EventsManager1.RegisterForEvent;
	RFE(l_OnEvent_ActionStartedOrStopped, nil, "UNIT_SPELLCAST_START", false, true);
	RFE(l_OnEvent_ActionStartedOrStopped, nil, "UNIT_SPELLCAST_SUCCEEDED", false, true);
	RFE(l_OnEvent_ActionStartedOrStopped, nil, "UNIT_SPELLCAST_CHANNEL_START", false, true);
	RFE(l_OnEvent_ActionStartedOrStopped, nil, "UNIT_SPELLCAST_CHANNEL_STOP", false, true);
	RFE(l_OnEvent_ActionStartedOrStopped, nil, "UNIT_SPELLCAST_INTERRUPTED", false, true);
end

o.Speech_t_OnConfigLoaded = l_t_OnConfigLoaded;




function l_ToggleSilence(enabled)
	if (enabled ~= nil) then
		l_silenced = ((enabled and true) or nil);
	else
		l_silenced = ((l_silenced == nil and true) or nil);
	end
end

o.Speech_ToggleSilence = l_ToggleSilence;



function l_ToggleDetective(enabled)
	if (enabled ~= nil) then
		l_detectiveEnabled = ((enabled and true) or nil);
	else
		l_detectiveEnabled = ((l_detectiveEnabled == nil and true) or nil);
	end
end

o.Speech_ToggleDetective = l_ToggleDetective;




do
	local l_SubstituteSpecialText;
	local UnitName = UnitName;
	local UnitExists = UnitExists;
	local UnitIsFriend = UnitIsFriend;
	local GetNumPartyMembers = GetNumPartyMembers;
	local GetNumRaidMembers = GetNumRaidMembers;
	local GetChannelName = GetChannelName;
	local GetLanguageByIndex = GetLanguageByIndex;
	local IsRaidOfficer = IsRaidOfficer;
	local IsRaidLeader = IsRaidLeader;
	local l_argsArray, l_capturesArray;
	
	function l_PrepareEntry(entryTable, argsArray, capturesArray)
		if (l_silenced == true) then
			return nil, nil, nil, nil;
		end
		
		l_argsArray = argsArray;
		l_capturesArray = capturesArray;
		local message = entryTable.message:gsub("<(%a+)[%s:]([^>]+)>", l_SubstituteSpecialText);
		if (message:len() > 255) then
			l_argsArray = nil;
			l_capturesArray = nil;
			return nil, nil, nil, nil;
		end
		local channelOrTarget = entryTable.channelOrTarget;
		if (channelOrTarget ~= nil) then
			local prefix, text = channelOrTarget:match("^<(%a+)[%s:]([^>]+)>$");
			if (prefix ~= nil) then
				channelOrTarget = l_SubstituteSpecialText(prefix, text);
			end
		end
		l_argsArray = nil;
		l_capturesArray = nil;
		
		local messageType = l_MESSAGE_TYPE_LIST[entryTable.messageType];
		
		if (messageType == "BASIC_EMOTE") then
			DoEmote(message, channelOrTarget);
			return nil, nil, nil, nil;
			
		elseif (messageType == "CHANNEL") then
			local chanNum = GetChannelName(channelOrTarget);
			if (chanNum ~= nil and chanNum ~= 0) then
				channelOrTarget = chanNum;
			else
				return nil, nil, nil, nil;
			end
			
		elseif (messageType == "WHISPER") then
			local unit;
			if (channelOrTarget == "%t") then
				unit = ("target");
			elseif (channelOrTarget == "%f") then
				unit = ("focus");
			else
				unit = channelOrTarget;
			end
			if (unit ~= nil and UnitExists(unit) ~= nil and UnitIsFriend("player", unit) ~= nil) then
				local whisperName, realmName = UnitName(unit);
				if (realmName ~= nil) then
					channelOrTarget = (whisperName .. "-" .. realmName);
				else
					channelOrTarget = whisperName;
				end
			else
				return nil, nil, nil, nil;
			end
			
		elseif (messageType == "PARTY") then
			if (GetNumPartyMembers() == 0) then
				return nil, nil, nil, nil;
			end
			
		elseif (messageType == "RAID" or messageType == "BATTLEGROUND") then
			if (GetNumRaidMembers() == 0) then
				return nil, nil, nil, nil;
			end
			
		elseif (messageType == "RAID_OR_PARTY") then
			if (GetNumRaidMembers() ~= 0) then
				messageType = ("RAID");
			else
				if (GetNumPartyMembers() ~= 0) then
					messageType = ("PARTY");
				else
					return nil, nil, nil, nil;
				end
			end
			
		elseif (messageType == "RAID_WARNING") then
			if (GetNumRaidMembers() == 0 or (IsRaidOfficer() == nil and IsRaidLeader() == nil)) then
				return nil, nil, nil, nil;
			end
		end
		
		local language = entryTable.language;
		if (language ~= nil) then
			language = GetLanguageByIndex(language);
		end
		
		return message, messageType, language, channelOrTarget;
	end
	
	
	do
		local SecureCmdOptionParse = SecureCmdOptionParse;
		local loc_MISSING_UNIT_FORMAT = ("<" .. NO:lower() .. " %s>");
		
		function l_SubstituteSpecialText(prefix, text)
			local newText;
			if (prefix == "unit") then
				local unit = SecureCmdOptionParse(text);
				newText = ((UnitExists(unit) and UnitName(unit)) or loc_MISSING_UNIT_FORMAT:format(unit));
			elseif (prefix == "arg") then
				if (l_argsArray ~= nil) then
					newText = tostring(l_argsArray[tonumber(text)]);
				else
					newText = ("<no args array>");
				end
			elseif (prefix == "capture") then
				if (l_capturesArray ~= nil) then
					newText = l_capturesArray[tonumber(text)];
				else
					newText = ("<no captures array>");
				end
			end
			return newText;
		end
	end
end




do
	local time = time;
	local mathrandom = math.random;
	
	function l_CheckAction(actionTable, triggerBits, argsArray, capturesArray)
		if (l_silenced == true) then
			return false;
		end
		
		local currTime = time();
		
		if (
		  actionTable.timeLastSent ~= nil
		  and actionTable.repeatDelay ~= nil
		  and (actionTable.timeLastSent + actionTable.repeatDelay) > currTime
		) then
			return false;
		end
		
		local didSendFromActionTable = false;
		
		local rollRanges = actionTable.rollRanges;
		if (rollRanges ~= nil) then
			local roll = mathrandom(1, 1000);
			local didSend;
			for rrIndex, rrTable in ipairs(rollRanges) do
				didSend = l_CheckRollRange(rrTable, roll, triggerBits, currTime, argsArray, capturesArray);
				if (didSend == true) then
					didSendFromActionTable = true;
				end
			end
			
			if (didSendFromActionTable == false and actionTable.alwaysTrySend == true) then
				-- If nothing was sent from a normal iteration through the roll ranges, try again using no roll check until a single roll range activates.
				local index = 1;
				local rrTable = rollRanges[1];
				while (didSendFromActionTable == false and rrTable ~= nil) do
					didSendFromActionTable = l_CheckRollRange(rrTable, 0, triggerBits, currTime, argsArray, capturesArray);
					if (didSendFromActionTable == false) then
						index = (index + 1);
						rrTable = rollRanges[index];
					end
				end
			end
		end
		
		if (actionTable.repeatDelay ~= nil) then
			if (didSendFromActionTable == true) then
				actionTable.timeLastSent = currTime;
			end
		else
			actionTable.timeLastSent = nil;
		end
		
		return didSendFromActionTable;
	end
end



do
	local type = type;
	local bitband = bit.band;
	
	function l_CheckRollRange(rrTable, roll, triggerBits, currTime, argsArray, capturesArray)
		if (
		  rrTable.timeLastSent ~= nil
		  and rrTable.repeatDelay ~= nil
		  and (rrTable.timeLastSent + rrTable.repeatDelay) > currTime
		) then
			return false;
		end
		
		if (roll ~= 0 and (roll < rrTable.minRoll or roll > rrTable.maxRoll)) then
			return false;
		end
		
		if (triggerBits ~= nil) then
			local rrTableTriggerBits = (rrTable.triggerBits or 0x0);
			if (rrTableTriggerBits == 0x0 or bitband(rrTableTriggerBits, triggerBits) ~= triggerBits) then
				return false;
			end
		end
		
		local didSendFromRollRangeTable = false;
		
		local entries = rrTable.entries;
		if (entries ~= nil) then
			if (type(entries[1]) == "string") then
				didSendFromRollRangeTable = l_CheckEntry(entries, currTime, argsArray, capturesArray);
			else
				local didSend;
				for entryIndex, entryTable in ipairs(entries) do
					didSend = l_CheckEntry(entryTable, currTime, argsArray, capturesArray);
					if (didSend == true) then
						didSendFromRollRangeTable = true;
					end
				end
			end
		end
		
		if (rrTable.repeatDelay ~= nil) then
			if (didSendFromRollRangeTable == true) then
				rrTable.timeLastSent = currTime;
			end
		else
			rrTable.timeLastSent = nil;
		end
		
		return didSendFromRollRangeTable;
	end
end



function l_CheckEntry(entryTable, currTime, argsArray, capturesArray)
	if (
	  entryTable.timeLastSent ~= nil
	  and entryTable.repeatDelay ~= nil
	  and (entryTable.timeLastSent + entryTable.repeatDelay) > currTime
	) then
		return false;
	end
	
	local message, messageType, language, channelOrTarget = l_PrepareEntry(entryTable, argsArray, capturesArray);
	if (message == nil) then
		return false;
	end
	
	local delay = entryTable.activationDelay;
	if (delay ~= nil) then
		local handler = o.DelaysManager2.CreateDelayHandler(SendChatMessage, nil, delay, false, false, message, messageType, language, channelOrTarget);
		handler:Start();
	else
		SendChatMessage(message, messageType, language, channelOrTarget);
	end
	
	if (entryTable.repeatDelay ~= nil) then
		entryTable.timeLastSent = currTime;
	else
		entryTable.timeLastSent = nil;
	end
	
	return true;
end




do
	local loc_GLOBAL_HOTKEY_BLANK_ACTION = o.Localization.GLOBAL_HOTKEY_BLANK_ACTION;
	local loc_GLOBAL_HOTKEY_INVALID_ARGUMENT = o.Localization.GLOBAL_HOTKEY_INVALID_ARGUMENT;
	
	function l_SpeakByGlobalHotkeyNumber(number)
		-- Some additional validity checks and feedback are placed in this function, because the user would obviously want to know if their macro or keybinding won't work because of a silent error.
		number = tonumber(number);
		if (number ~= nil and number > 0 and number < 31) then
			local action = l_hotkeyActions[number];
			if (action ~= nil) then
				l_CheckAction(action, nil, nil, nil);
			else
				DEFAULT_CHAT_FRAME:AddMessage(loc_GLOBAL_HOTKEY_BLANK_ACTION:format(number));
			end
		else
			DEFAULT_CHAT_FRAME:AddMessage(loc_GLOBAL_HOTKEY_INVALID_ARGUMENT:format(type(number), tostring(number)));
		end
	end
	
	o.Speech_SpeakByGlobalHotkeyNumber = l_SpeakByGlobalHotkeyNumber;
	-- This is for use in macros, to allow the user to conserve space in the limited 255 characters.
	setmetatable(o, { __call = (function(o, number) l_SpeakByGlobalHotkeyNumber(number); end) });
end




do
	local DEFAULT_CHAT_FRAME = DEFAULT_CHAT_FRAME;
	local loc_ACTION_DETECTIVE_TENSES = o.Localization.ACTION_DETECTIVE_TENSES;
	local loc_ACTION_DETECTIVE_FEEDBACK = o.Localization.ACTION_DETECTIVE_FEEDBACK;
	
	function l_OnEvent_ActionStartedOrStopped(event, unit, actionName, actionRank)
		if (unit ~= "player") then
			return;
		end
		
		if (l_detectiveEnabled == true) then
			local printedRank = actionRank;
			if (printedRank ~= "") then
				printedRank = (" (" .. printedRank .. ")");
			end
			DEFAULT_CHAT_FRAME:AddMessage(loc_ACTION_DETECTIVE_FEEDBACK:format(loc_ACTION_DETECTIVE_TENSES[event], actionName, printedRank));
		end
		
		local actionTable;
		if (actionRank == "") then
			actionTable = l_generalActions[actionName];
		else
			actionTable = (l_generalActions[actionName .. " (" .. actionRank .. ")"] or l_generalActions[actionName]);
		end
		if (actionTable ~= nil) then
			l_CheckAction(actionTable, l_TRIGGER_BITS_BY_EVENT[event], nil, nil);
		end
	end
end




do
	local l_CaptureMatches;
	local stringfind = string.find;
	local l_argsArray = {};
	local l_capturesArray = {};
	
	function l_OnEvent_CHAT_MSG(event, msg, ...)
		local actionsList = l_messageEvents[event];
		if (actionsList == nil) then
			return;
		end
		
		local numArgs = select("#", ...);
		for index = 1, numArgs, 1 do
			l_argsArray[index] = (select(index, ...));
		end
		for index = (numArgs + 1), #l_argsArray, 1 do
			l_argsArray[index] = nil;
		end
		
		local argsMatchText, chatText;
		local argNum, expected, stringPos;
		local didMatch;
		for text, action in pairs(actionsList) do
			argsMatchText, chatText = stringmatch(text, "^(.+) && (.*)$");
			if (argsMatchText ~= nil) then
				argNum, expected, stringPos = stringmatch(argsMatchText, "<([^%s]+) ([^>]*)>()", 1);
				while (argNum ~= nil and chatText ~= nil) do
					if (stringmatch(tostring(l_argsArray[tonumber(argNum)]), expected) ~= nil) then
						argNum, expected, stringPos = stringmatch(argsMatchText, "<([^%s]+) ([^>]*)>()", stringPos);
					else
						chatText = nil;
					end
				end
			else
				chatText = text;
			end
			
			if (chatText ~= nil) then
				didMatch = l_CaptureMatches(l_capturesArray, stringfind(msg, chatText));
				if (didMatch == true) then
					l_CheckAction(action, nil, l_argsArray, l_capturesArray);
				end
			end
		end
	end
	
	o.Speech_OnEvent_CHAT_MSG = l_OnEvent_CHAT_MSG;
	
	
	do
		function l_CaptureMatches(capturesArray, start, stop, ...)
			if (start == nil) then
				return false;
			end
			local numArgs = select("#", ...);
			for index = 1, numArgs, 1 do
				capturesArray[index] = (select(index, ...));
			end
			for index = (numArgs + 1), #capturesArray, 1 do
				capturesArray[index] = nil;
			end
			return true;
		end
	end
end




do
	local l_SetupArgsArray;
	local bitband = bit.band;
	local l_argsArray = {};
	
	function l_OnEvent_COMBAT_LOG_EVENT_UNFILTERED(timestamp, event, ...)
		-- Don't set up the args array before we know this event is needed.
		local argsArrayReady = false;
		local eventsCheckText;
		local allMatch;
		local argNum, expected, stringPos;
		local argVal;
		
		for argsCheckText, action in pairs(l_combatEvents) do
			if (argsArrayReady == false) then
				eventCheckText = stringmatch(argsCheckText, "<1 ([^>]*)>");
				if (eventCheckText == nil or stringmatch(event, eventCheckText) ~= nil) then
					l_SetupArgsArray(l_argsArray, event, ...);
					argsArrayReady = true;
				end
			end
			
			-- Only proceed with the rest of the checks if the array is ready, and the array will only be ready after the first matching event is found.
			if (argsArrayReady == true) then
				allMatch = nil;
				
				argNum, expected, stringPos = stringmatch(argsCheckText, "<([^%s]+) ([^>]*)>()", 1);
				argNum = tonumber(argNum);
				while (allMatch ~= false and argNum ~= nil) do
					argVal = l_argsArray[argNum];
					if (argVal ~= nil) then
						-- See if this is a UnitFlag argument.
						if (argNum == 4 or argNum == 7) then
							-- Need to use bit operations for matching.
							expected = tonumber(expected);
							if (bitband(argVal, expected) == expected) then
								allMatch = true;
							else
								allMatch = false;
							end
						else
							if (stringmatch(tostring(argVal), expected) ~= nil) then
								allMatch = true;
							else
								allMatch = false;
							end
						end
					else
						allMatch = false;
					end
					if (allMatch == true) then
						argNum, expected, stringPos = stringmatch(argsCheckText, "<([^%s]+) ([^>]*)>()", stringPos);
						argNum = tonumber(argNum);
					end
				end
				
				if (allMatch == true) then
					l_CheckAction(action, nil, l_argsArray, nil);
				end
			end
		end
	end
	
	o.Speech_OnEvent_COMBAT_LOG_EVENT_UNFILTERED = l_OnEvent_COMBAT_LOG_EVENT_UNFILTERED;
	
	
	do
		--[[
			The argument indexes need to be normalized across all event prefixes:
			[1] = event;
			[2-7] = sourceAndDest;
			[8-10] = prefixArgs;
			[11-18] = suffixArgs;
		--]]
		function l_SetupArgsArray(argsArray, event, sourceGUID, sourceName, sourceFlags, destGUID, destName, destFlags, ...)
			-- Basic source/dest args...
			argsArray[1] = event;
			argsArray[2], argsArray[3], argsArray[4] = sourceGUID, sourceName, sourceFlags;
			argsArray[5], argsArray[6], argsArray[7] = destGUID, destName, destFlags;
			
			-- Number of prefix args...
			local numPrefixArgs;
			if (
			  stringmatch(event, "^SWING") ~= nil
			  or event == "PARTY_KILL" or event == "UNIT_DIED" or event == "UNIT_DESTROYED"
			) then
				numPrefixArgs = 0;
			elseif (stringmatch(event, "^ENVIRONMENTAL") ~= nil) then
				numPrefixArgs = 1;
			else
				numPrefixArgs = 3;
			end
			
			-- Prefix args...
			local argIndex = 8;
			for index = 1, numPrefixArgs, 1 do
				argsArray[argIndex] = (select(index, ...));
				argIndex = (argIndex + 1);
			end
			for index = argIndex, 10, 1 do
				argsArray[index] = nil;
			end
			
			-- Suffix args...
			argIndex = 11;
			local numArgs = select("#", ...);
			for index = (numPrefixArgs + 1), numArgs, 1 do
				argsArray[argIndex] = (select(index, ...));
				argIndex = (argIndex + 1);
			end
			
			-- 18 is the maximum number of arguments possible.
			for index = argIndex, 18, 1 do
				argsArray[index] = nil;
			end
		end
	end
end




function l_OnEvent_PLAYER_REGEN_DISABLED()
	local action = l_miscEvents.ENTER_COMBAT;
	if (action ~= nil) then
		l_CheckAction(action, nil, nil, nil);
	end
end

o.Speech_OnEvent_PLAYER_REGEN_DISABLED = l_OnEvent_PLAYER_REGEN_DISABLED;



function l_OnEvent_PLAYER_REGEN_ENABLED()
	local action = l_miscEvents.LEAVE_COMBAT;
	if (action ~= nil) then
		l_CheckAction(action, nil, nil, nil);
	end
end

o.Speech_OnEvent_PLAYER_REGEN_ENABLED = l_OnEvent_PLAYER_REGEN_ENABLED;



do
	local UnitHealth = UnitHealth;
	local UnitHealthMax = UnitHealthMax;
	local l_healthBelow20;
	
	function l_OnEvent_UNIT_HEALTH(unit)
		if (unit ~= "player") then
			return;
		end
		
		if (UnitHealth("player") / UnitHealthMax("player") < 0.20) then
			if (l_healthBelow20 == nil) then
				l_healthBelow20 = true;
				local action = l_miscEvents.PLAYER_BELOW_TWENTY_HEALTH;
				if (action ~= nil) then
					l_CheckAction(action, nil, nil, nil);
				end
			end
		else
			l_healthBelow20 = nil;
		end
	end
	
	o.Speech_OnEvent_UNIT_HEALTH = l_OnEvent_UNIT_HEALTH;
end



do
	local UnitMana = UnitMana;
	local UnitManaMax = UnitManaMax;
	local l_manaBelow20;
	
	function l_OnEvent_UNIT_MANA(unit)
		if (unit ~= "player") then
			return;
		end
		
		if (UnitMana("player") / UnitManaMax("player") < 0.20) then
			if (l_manaBelow20 == nil) then
				l_manaBelow20 = true;
				local action = l_miscEvents.PLAYER_BELOW_TWENTY_MANA;
				if (action ~= nil) then
					l_CheckAction(action, nil, nil, nil);
				end
			end
		else
			l_manaBelow20 = nil;
		end
	end
	
	o.Speech_OnEvent_UNIT_MANA = l_OnEvent_UNIT_MANA;
end



function l_OnEvent_TRADE_SHOW()
	local action = l_miscEvents.TRADE_OPENED;
	if (action ~= nil) then
		l_CheckAction(action, nil, nil, nil);
	end
end

o.Speech_OnEvent_TRADE_SHOW = l_OnEvent_TRADE_SHOW;



do
	local GetPlayerBuffName = GetPlayerBuffName;
	
	function l_OnEvent_PLAYER_UNGHOST()
		-- Check for the "Honorless Target" buff, which, if present, indicates that the player didn't really just resurrect.
		if (GetPlayerBuffName("Honorless Target") == nil) then
			local action = l_miscEvents.PLAYER_RESURRECTION;
			if (action ~= nil) then
				l_CheckAction(action, nil, nil, nil);
			end
		end
	end
	
	o.Speech_OnEvent_PLAYER_UNGHOST = l_OnEvent_PLAYER_UNGHOST;
end



function l_OnReloadUI()
	local action = l_miscEvents["RELOAD_UI"];
	if (action ~= nil) then
		l_CheckAction(action, nil, nil, nil);
	end
end

o.Speech_OnReloadUI = l_OnReloadUI;

