

local o = Segui;


local l_t_Init; -- ()

local l_ToggleGenericEventMonitor; -- (enabled, event, key, sendEvent)
local l_OnCombatEventCategoryEmptiedOrUnemptied; -- (notEmpty)
local l_OnMessageEventCategoryActionToggled; -- (enabled, actionName)
local l_OnMiscEventCategoryActionToggled; -- (enabled, actionName)

local l_ToggleConfigFrame; -- ()
local l_GetSilenceStatus; -- enabled = ()
local l_SetSilenceStatus; -- enabled = (enabled)
local l_GetDetectiveStatus; -- enabled = ()
local l_SetDetectiveStatus; -- enabled = (enabled)

local l_CreateActionTable; -- (storage, actionName, storageParent, storageKey)
local l_CreateRollRangeTable; -- (actionTable)
local l_CreateEntryTable; -- (rrTable)

local l_OnEvent_VARIABLES_LOADED; -- ()
local l_t_InitMetatables; -- ()
local l_t_UpdateSavedData; -- (globalSpeech, localSpeech)
local l_t_ImportFromSpeakEasyGUI; -- ()


local type = type; -- OnMiscEventCategoryActionToggled, CreateEntryTable
local setmetatable = setmetatable; -- CreateActionTable, CreateRollRangeTable, CreateEntryTable, t_InitMetatables


local l_ACTION_METATABLE;
local l_ROLLRANGE_METATABLE;
local l_ENTRY_METATABLE;
do
	local rawget = rawget;
	local rawset = rawset;
	local function l_BuildArrayMetatable(translations)
		return {
			__index = (function(self, key)
				return rawget(self, translations[key]);
			end);
			__newindex = (function(self, key, value)
				local realKey = translations[key];
				if (realKey ~= nil) then
					rawset(self, realKey, value);
				end
			end);
		};
	end
	l_ACTION_METATABLE = l_BuildArrayMetatable({ rollRanges = 1, repeatDelay = 2, timeLastSent = 3, alwaysTrySend = 4 });
	l_ROLLRANGE_METATABLE = l_BuildArrayMetatable({ entries = 1, minRoll = 2, maxRoll = 3, triggerBits = 4, repeatDelay = 5, timeLastSent = 6 });
	l_ENTRY_METATABLE = l_BuildArrayMetatable(
	  { message = 1, messageType = 2, activationDelay = 3, language = 4, channelOrTarget = 5, repeatDelay = 6, timeLastSent = 7 }
	);
	-- "alwaysTrySend" added to ACTION_METATABLE in 1.5.0.
	--[[
		Pre-1.4.0:
		l_ROLLRANGE_METATABLE = l_BuildArrayMetatable({ entries = 1, minRoll = 2, maxRoll = 3, multiEntry = 4, repeatDelay = 5, timeLastSent = 6 });
		l_ENTRY_METATABLE = l_BuildArrayMetatable(
		  { message = 1, messageType = 2, sendAtStart = 3, activationDelay = 4, language = 5, channelOrTarget = 6, repeatDelay = 7, timeLastSent = 9 }
		);
	--]]
end

local l_MISC_EVENT_FUNCS_AND_EVENTS = {
	TRADE_OPENED = ("TRADE_SHOW");
	PLAYER_RESURRECTION = ("PLAYER_UNGHOST");
	PLAYER_BELOW_TWENTY_HEALTH = ("UNIT_HEALTH");
	PLAYER_BELOW_TWENTY_MANA = ("UNIT_MANA");
	RELOAD_UI = nil;
	ENTER_COMBAT = ("PLAYER_REGEN_DISABLED");
	LEAVE_COMBAT = ("PLAYER_REGEN_ENABLED");
};

local l_CONFIG_FRAME;

BINDING_HEADER_Segui = ("Segui");
do
	local pattern = o.Localization.GLOBAL_HOTKEY_ACTION_FORMAT;
	local stringformat = string.format;
	local _G = _G;
	for index = 1, 30, 1 do
		_G["BINDING_NAME_Segui_Hotkey" .. index] = stringformat(pattern, index);
	end
end


local l_globalSpeechMemory;
local l_speechMemory;

local l_silenced = nil;
local l_detectiveEnabled = nil;




function l_t_Init()
	l_t_Init = nil;
	o.Config_t_Init = nil;
	
	o.EventsManager1.RegisterForEvent(l_OnEvent_VARIABLES_LOADED, nil, "VARIABLES_LOADED", false, false);
	
	local sCmds = o.Localization.SLASH_COMMANDS;
	SimpleSlash1.RegisterClient(
	  "Segui",
	  {
		[sCmds.CONFIG] = {
			func = l_ToggleConfigFrame;
			isNotToggle = true;
			usageText = sCmds.CONFIG_USAGE;
			noStatusFeedback = true;
		};
		[sCmds.IMPORT] = {
			func = l_t_ImportFromSpeakEasyGUI;
			isNotToggle = true;
			onceOnly = true;
			usageText = sCmds.IMPORT_USAGE;
			statusText = sCmds.IMPORT_STATUS;
		};
		[sCmds.SILENCE] = {
			get = l_GetSilenceStatus;
			set = l_SetSilenceStatus;
			noArgForSet = true;
			usageText = sCmds.SILENCE_USAGE;
			statusText = sCmds.SILENCE_STATUS;
			[true] = sCmds.SILENCE_STATUS_ENABLED;
			[false] = sCmds.SILENCE_STATUS_DISABLED;
		};
		[sCmds.DETECTIVE] = {
			get = l_GetDetectiveStatus;
			set = l_SetDetectiveStatus;
			noArgForSet = true;
			usageText = sCmds.DETECTIVE_USAGE;
			statusText = sCmds.DETECTIVE_STATUS;
			[true] = sCmds.DETECTIVE_STATUS_ENABLED;
			[false] = sCmds.DETECTIVE_STATUS_DISABLED;
		};
	  }
	);
	SimpleSlash1.RegisterPrefix("Segui", sCmds.PREFIX_1);
end

o.Config_t_Init = l_t_Init;




function l_ToggleGenericEventMonitor(enabled, event, func, sendEvent)
	if (enabled == true) then
		o.EventsManager1.RegisterForEvent(func, nil, event, false, sendEvent);
	else
		o.EventsManager1.UnregisterForEvent(func, event);
	end
end



function l_OnCombatEventCategoryEmptiedOrUnemptied(notEmpty)
	l_ToggleGenericEventMonitor(notEmpty, "COMBAT_LOG_EVENT_UNFILTERED", o.Speech_OnEvent_COMBAT_LOG_EVENT_UNFILTERED, false);
end

o.Config_OnCombatEventCategoryEmptiedOrUnemptied = l_OnCombatEventCategoryEmptiedOrUnemptied;



function l_OnMessageEventCategoryActionToggled(enabled, actionName)
	l_ToggleGenericEventMonitor(enabled, actionName, o.Speech_OnEvent_CHAT_MSG, true);
end

o.Config_OnMessageEventCategoryActionToggled = l_OnMessageEventCategoryActionToggled;



function l_OnMiscEventCategoryActionToggled(enabled, actionName)
	local funcOrEvent = l_MISC_EVENT_FUNCS_AND_EVENTS[actionName];
	if (funcOrEvent ~= nil) then
		if (type(funcOrEvent) == "function") then
			funcOrEvent(enabled);
		else
			l_ToggleGenericEventMonitor(enabled, funcOrEvent, o["Speech_OnEvent_" .. funcOrEvent], false);
		end
	end
end

o.Config_OnMiscEventCategoryActionToggled = l_OnMiscEventCategoryActionToggled;


function l_MISC_EVENT_FUNCS_AND_EVENTS.RELOAD_UI(enabled)
	if (enabled == true) then
		hooksecurefunc("ReloadUI", o.Speech_OnReloadUI);
		o.Speech_OnReloadUI = nil;
		l_MISC_EVENT_FUNCS_AND_EVENTS.RELOAD_UI = nil;
	end
end




function l_ToggleConfigFrame()
	local frame = l_CONFIG_FRAME;
	if (frame == nil) then
		LoadAddOn("Segui_Config");
		frame = Segui_ConfigFrame;
		l_CONFIG_FRAME = frame;
	end
	
	if (frame:IsShown() ~= nil) then
		frame:Hide();
	else
		frame:Show();
	end
end



function l_GetSilenceStatus()
	return ((l_silenced and true) or false);
end


function l_SetSilenceStatus(enabled)
	l_silenced = ((enabled and true) or nil);
	o.Speech_ToggleSilence(l_silenced);
	return l_GetSilenceStatus();
end



function l_GetDetectiveStatus()
	return ((l_detectiveEnabled and true) or false);
end


function l_SetDetectiveStatus(enabled)
	l_detectiveEnabled = ((enabled and true) or nil);
	o.Speech_ToggleDetective(l_detectiveEnabled);
	return l_GetDetectiveStatus();
end




function l_CreateActionTable(storage, actionName, storageParent, storageKey)
	local actionTable = {};
	setmetatable(actionTable, l_ACTION_METATABLE);
	actionTable.rollRanges = {};
	
	if (storage == nil) then
		storage = {};
		storageParent[storageKey] = storage;
	end
	storage[actionName] = actionTable;
	
	return actionTable;
end

o.Config_CreateActionTable = l_CreateActionTable;



function l_CreateRollRangeTable(actionTable)
	local rrTable = {};
	setmetatable(rrTable, l_ROLLRANGE_METATABLE);
	
	local rollRanges = actionTable.rollRanges;
	rollRanges[#rollRanges + 1] = rrTable;
	
	return rrTable;
end

o.Config_CreateRollRangeTable = l_CreateRollRangeTable;



function l_CreateEntryTable(rrTable)
	local entryTable = {};
	setmetatable(entryTable, l_ENTRY_METATABLE);
	
	local entries = rrTable.entries;
	if (entries == nil) then
		rrTable.entries = entryTable;
	else
		if (type(entries[1]) == "string") then
			rrTable.entries = { entries, entryTable };
		else
			entries[#entries + 1] = entryTable;
		end
	end
	
	return entryTable;
end

o.Config_CreateEntryTable = l_CreateEntryTable;




do
	local loc_SLASH_IMPORT = o.Localization.SLASH_COMMANDS.IMPORT;
	local loc_RENAMED_SLASH_COMMAND = o.Localization.RENAMED_SLASH_COMMAND;
	local loc_SUGGEST_IMPORT = o.Localization.SUGGEST_IMPORT;
	local loc_FAILED_TO_UPDATE = o.Localization.FAILED_TO_UPDATE;
	
	function l_OnEvent_VARIABLES_LOADED()
		l_OnEvent_VARIABLES_LOADED = nil;
		
		local currVersion = tonumber((GetAddOnMetadata("Segui", "Version"):gsub("%.", "")));
		
		local globalSpeech = Segui_GlobalSpeechMemory;
		if (globalSpeech == nil) then
			globalSpeech = {
				version = currVersion;
				hotkeys = {};
			};
			Segui_GlobalSpeechMemory = globalSpeech;
		end
		l_globalSpeechMemory = globalSpeech;
		o.globalSpeechMemory = globalSpeech;
		
		local localSpeech = Segui_SpeechMemory;
		if (localSpeech == nil) then
			localSpeech = {
				version = currVersion;
				messageEvents = {};
				combatEvents = {};
				miscEvents = {};
				generalActions = {};
			};
			Segui_SpeechMemory = localSpeech;
		end
		l_speechMemory = localSpeech;
		o.speechMemory = localSpeech;
		
		if (globalSpeech.version < currVersion or localSpeech.version < currVersion) then
			local success, errorText = pcall(l_t_UpdateSavedData, globalSpeech, localSpeech);
			if (success == false) then
				DEFAULT_CHAT_FRAME:AddMessage(
				  loc_FAILED_TO_UPDATE:format(globalSpeech.version, localSpeech.version, currVersion, (errorText or NONE))
				);
				return;
			end
		end
		l_t_InitMetatables();
		
		globalSpeech.version = currVersion;
		localSpeech.version = currVersion;
		
		for eventName in pairs(localSpeech.messageEvents) do
			l_OnMessageEventCategoryActionToggled(true, eventName);
		end
		l_OnCombatEventCategoryEmptiedOrUnemptied(next(localSpeech.combatEvents) ~= nil);
		for eventName in pairs(localSpeech.miscEvents) do
			l_OnMiscEventCategoryActionToggled(true, eventName);
		end
		
		o.Speech_t_OnConfigLoaded();
		
		if (IsAddOnLoaded("SpeakEasyGUI") ~= nil) then
			SLASH_SPEAKEASYGUI1 = ("/speakeasygui");
			DEFAULT_CHAT_FRAME:AddMessage(loc_RENAMED_SLASH_COMMAND);
			DEFAULT_CHAT_FRAME:AddMessage(loc_SUGGEST_IMPORT);
		else
			l_t_ImportFromSpeakEasyGUI = nil;
			local client = SimpleSlash1.GetClient("Segui");
			client[loc_SLASH_IMPORT] = nil;
		end
	end
end



function l_t_InitMetatables()
	l_t_InitMetatables = nil;
	
	local pairs = pairs;
	
	local actionsLists = {
		l_globalSpeechMemory.hotkeys,
		l_speechMemory.combatEvents,
		l_speechMemory.miscEvents,
		l_speechMemory.generalActions
	};
	
	for eventName, actionsList in pairs(l_speechMemory.messageEvents) do
		actionsLists[#actionsLists + 1] = actionsList;
	end
	
	local rollRanges, entries;
	for index, actionsList in pairs(actionsLists) do
		for actionName, actionTable in pairs(actionsList) do
			setmetatable(actionTable, l_ACTION_METATABLE);
			
			rollRanges = actionTable.rollRanges;
			if (rollRanges ~= nil) then
				for index, rrTable in pairs(rollRanges) do
					setmetatable(rrTable, l_ROLLRANGE_METATABLE);
					
					entries = rrTable.entries;
					if (entries ~= nil) then
						if (type(entries[1]) == "string") then
							setmetatable(entries, l_ENTRY_METATABLE);
						else
							for index, entryTable in pairs(entries) do
								setmetatable(entryTable, l_ENTRY_METATABLE);
							end
						end
					end
				end
			end
		end
	end
end



function l_t_ImportFromSpeakEasyGUI()
	l_t_ImportFromSpeakEasyGUI = nil;
	
	local globalConfig = SpeakEasyGUI_GlobalConfig;
	local localConfig = SpeakEasyGUI_Config;
	if (globalConfig == nil and localConfig == nil) then
		return;
	end
	DisableAddOn("SpeakEasyGUI");
	
	local pairs = pairs;
	local ipairs = ipairs;
	
	local isHorde = (GetDefaultLanguage() == "Orcish");
	local function l_ImportAction(storage, actionName, oldAction)
		if (oldAction == nil) then
			return;
		end
		
		local newAction = (storage[actionName] or l_CreateActionTable(storage, actionName, nil, nil));
		local newRR, newEntry;
		local minRoll, maxRoll;
		for index, oldEntry in pairs(oldAction) do
			minRoll, maxRoll = oldEntry[2], oldEntry[3];
			newRR = nil;
			if (newAction.rollRanges ~= nil) then
				for index, rollRange in ipairs(newAction.rollRanges) do
					if (rollRange.minRoll == minRoll and rollRange.maxRoll == maxRoll) then
						newRR = rollRange;
					end
				end
			end
			if (newRR == nil) then
				newRR = l_CreateRollRangeTable(newAction);
				newRR.minRoll = minRoll;
				newRR.maxRoll = maxRoll;
			end
			newEntry = l_CreateEntryTable(newRR);
			newEntry.message = oldEntry[1];
			newEntry.messageType = oldEntry[4];
			-- 7 is Orcish and 1 is Common in the old config.
			if ((isHorde == true and oldEntry[5] ~= 7) or (isHorde == false and oldEntry[5] ~= 1)) then
				newEntry.language = 2;
			end
			newEntry.channelOrTarget = ((oldEntry[6] ~= "" and oldEntry[6]) or nil);
			newEntry.activationDelay = ((oldEntry[10] ~= 0 and oldEntry[10]) or nil);
		end
	end
	
	if (globalConfig ~= nil) then
		local hotkeyStorage = l_globalSpeechMemory.hotkeys;
		for actionName, oldAction in pairs(globalConfig) do
			if (actionName ~= "Version" and actionName ~= "SpellErrata") then
				if (type(actionName) == "string" and type(oldAction) == "table") then
					l_ImportAction(hotkeyStorage, actionName, oldAction);
				end
			end
		end
	end
	
	if (localConfig ~= nil) then
		local localSpeech = l_speechMemory;
		-- Create these tables temporarily for backwards compatibility support.
		localSpeech.selfBuffs = {};
		localSpeech.selfDebuffs = {};
		
		local generalStorage = l_speechMemory.generalActions;
		local storage;
		local entry;
		for key, value in pairs(localConfig) do
			if (key == "CombatEvents" or key == "MiscEvents" or key == "SelfBuffs" or key == "SelfDebuffs") then
				if (type(value) == "table") then
					storage = localSpeech[key:sub(1, 1):lower() .. key:sub(2, -1)];
					for actionName, oldAction in pairs(value) do
						if (type(actionName) == "string" and type(oldAction) == "table") then
							l_ImportAction(storage, actionName, oldAction);
						end
					end
				end
			elseif (key ~= "Version") then
				if (type(key) == "string" and type(value) == "table") then
					l_ImportAction(generalStorage, key, value);
				end
			end
		end
		
		local combat = localSpeech.combatEvents;
		if (combat.KILLING_BLOW ~= nil) then
			combat["<1 ^PARTY_KILL$><4 0x411>"] = combat.KILLING_BLOW;
			combat.KILLING_BLOW = nil;
		end
		if (combat.YOU_HIT ~= nil) then
			combat["<1 _DAMAGE$><4 0x411>"] = combat.YOU_HIT;
			combat.YOU_HIT = nil;
		end
		if (combat.YOU_MISS ~= nil) then
			combat["<1 _MISSED$><4 0x411>"] = combat.YOU_MISS;
			combat.YOU_MISS = nil;
		end
		if (combat.HEAL_HEALS ~= nil) then
			combat["<1 _HEAL$><4 0x411>"] = combat.HEAL_HEALS;
			combat.HEAL_HEALS = nil;
		end
		if (combat.ENEMY_HIT ~= nil) then
			combat["<1 _DAMAGE$><7 0x411>"] = combat.ENEMY_HIT;
			combat.ENEMY_HIT = nil;
		end
		if (combat.ENEMY_MISS ~= nil) then
			combat["<1 _MISSED$><7 0x411>"] = combat.ENEMY_MISS;
			combat.ENEMY_MISS = nil;
		end
		l_ImportAction(localSpeech.miscEvents, "ENTER_COMBAT", localSpeech.combatEvents.ENTER_COMBAT);
		localSpeech.combatEvents.ENTER_COMBAT = nil;
		l_ImportAction(localSpeech.miscEvents, "LEAVE_COMBAT", localSpeech.combatEvents.LEAVE_COMBAT);
		localSpeech.combatEvents.LEAVE_COMBAT = nil;
		
		for actionName, actionTable in pairs(localSpeech.selfBuffs) do
			combat["<1 _AURA_APPLIED$><4 0x411><11 ^BUFF$><9 ^" .. actionName .. "$>"] = actionTable;
		end
		for actionName, actionTable in pairs(localSpeech.selfDebuffs) do
			combat["<1 _AURA_APPLIED$><4 0x411><11 ^DEBUFF$><9 ^" .. actionName .. "$>"] = actionTable;
		end
		
		localSpeech.selfBuffs = nil;
		localSpeech.selfDebuffs = nil;
	end
	
	
	local localSpeech = l_speechMemory;
	for eventName in pairs(localSpeech.messageEvents) do
		l_OnMessageEventCategoryActionToggled(true, eventName);
	end
	l_OnCombatEventCategoryEmptiedOrUnemptied(next(localSpeech.combatEvents) ~= nil);
	for eventName in pairs(localSpeech.miscEvents) do
		l_OnMiscEventCategoryActionToggled(true, eventName);
	end
end



function l_t_UpdateSavedData(globalSpeech, localSpeech)
	l_t_UpdateSavedData = nil;
	
	
	--[[
		Manual indexes:
		
		Pre-1.4.0:
			Action:
				1 = rollRanges
				2 = repeatDelay
				3 = timeLastSent
			RollRange:
				1 = entries
				2 = minRoll
				3 = maxRoll
				4 = multiEntry
				5 = repeatDelay
				6 = timeLastSent
			Entry:
				1 = message
				2 = messageType
				3 = sendAtStart
				4 = activationDelay
				5 = language
				6 = channelOrTarget
				7 = repeatDelay
				8 = BLANK
				9 = timeLastSent
		
		Post-1.4.0
			Action:
				1 = rollRanges
				2 = repeatDelay
				3 = timeLastSent
			RollRange:
				1 = entries
				2 = minRoll
				3 = maxRoll
				4 = triggerBits
				5 = repeatDelay
				6 = timeLastSent
			Entry:
				1 = message
				2 = messageType
				3 = activationDelay
				4 = language
				5 = channelOrTarget
				6 = repeatDelay
				7 = timeLastSent
	--]]
	
	
	-- Prior to 1.0.2, the time function was GetTime() instead of time(). The former actually returns system uptime, not current time.
	-- Erase any table.timeLastSent values.
	if (globalSpeech.version < 102 or localSpeech.version < 102) then
		local memoryList;
		if (localSpeech.version < 102) then
			memoryList = {
				localSpeech.combatEvents, localSpeech.miscEvents,
				localSpeech.selfBuffs, localSpeech.selfDebuffs,
				localSpeech.generalActions
			};
		else
			memoryList = {};
		end
		if (globalSpeech.version < 102) then
			memoryList[#memoryList + 1] = globalSpeech.hotkeys;
		end
		
		for index, actionsList in ipairs(memoryList) do
			for actionName, actionTable in pairs(actionsList) do
				actionTable[3] = nil;
				if (actionTable[1] ~= nil) then
					for index, rrTable in ipairs(actionTable[1]) do
						rrTable[6] = nil;
						if (rrTable[1] ~= nil) then
							if (rrTable[4] == true) then
								for index, entryTable in ipairs(rrTable[1]) do
									entryTable[9] = nil;
								end
							else
								rrTable[1][9] = nil;
							end
						end
					end
				end
			end
		end
	end
	
	
	if (localSpeech.version < 110) then
		localSpeech.messageEvents = {};
		if (localSpeech.combatEvents.KILLING_BLOW ~= nil) then
			localSpeech.messageEvents.CHAT_MSG_COMBAT_HOSTILE_DEATH = {
				["^" .. SELFKILLOTHER:gsub("%.", "%%."):gsub("%%s", "(.+)") .. "$"] = localSpeech.combatEvents.KILLING_BLOW;
			};
			local action = localSpeech.combatEvents.KILLING_BLOW;
			if (action[1] ~= nil) then
				for index, rrTable in ipairs(action[1]) do
					if (rrTable[1] ~= nil) then
						if (rrTable[4] == true) then
							for index, entryTable in ipairs(rrTable[1]) do
								entryTable[1] = entryTable[1]:gsub("<special>", "<capture:1>");
							end
						else
							rrTable[1][1] = rrTable[1][1]:gsub("<special>", "<capture:1>");
						end
					end
				end
			end
		end
		
		if (localSpeech.combatEvents.YOU_HIT ~= nil) then
			localSpeech.messageEvents.CHAT_MSG_COMBAT_SELF_HITS = {
				["."] = localSpeech.combatEvents.YOU_HIT;
			};
		end
		if (localSpeech.combatEvents.YOU_MISS ~= nil) then
			localSpeech.messageEvents.CHAT_MSG_COMBAT_SELF_MISSES = {
				["."] = localSpeech.combatEvents.YOU_MISS;
			};
		end
		if (localSpeech.combatEvents.HEAL_HEALS ~= nil) then
			localSpeech.messageEvents.CHAT_MSG_SPELL_SELF_BUFF = {
				["."] = localSpeech.combatEvents.HEAL_HEALS;
			};
		end
		if (localSpeech.combatEvents.ENEMY_HIT ~= nil) then
			localSpeech.messageEvents.CHAT_MSG_COMBAT_CREATURE_VS_SELF_HITS = {
				["."] = localSpeech.combatEvents.ENEMY_HIT;
			};
		end
		if (localSpeech.combatEvents.ENEMY_MISS ~= nil) then
			localSpeech.messageEvents.CHAT_MSG_COMBAT_CREATURE_VS_SELF_MISSES = {
				["."] = localSpeech.combatEvents.ENEMY_MISS;
			};
		end
		localSpeech.miscEvents.ENTER_COMBAT = localSpeech.combatEvents.ENTER_COMBAT;
		localSpeech.miscEvents.LEAVE_COMBAT = localSpeech.combatEvents.LEAVE_COMBAT;
		
		local selfBuffsFormat = AURAADDEDSELFHELPFUL:gsub("%.", "%%.");
		local selfBuffsTable = localSpeech.messageEvents.CHAT_MSG_SPELL_PERIODIC_SELF_BUFFS;
		for actionName, actionTable in pairs(localSpeech.selfBuffs) do
			if (selfBuffsTable == nil) then
				selfBuffsTable = {};
				localSpeech.messageEvents.CHAT_MSG_SPELL_PERIODIC_SELF_BUFFS = selfBuffsTable;
			end
			selfBuffsTable["^" .. selfBuffsFormat:format(actionName) .. "$"] = actionTable;
		end
		
		local selfDebuffsFormat = AURAADDEDSELFHARMFUL:gsub("%.", "%%.");
		local selfDebuffsTable = localSpeech.messageEvents.CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE;
		for actionName, actionTable in pairs(localSpeech.selfDebuffs) do
			if (selfDebuffsTable == nil) then
				selfDebuffsTable = {};
				localSpeech.messageEvents.CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE = selfDebuffsTable;
			end
			selfDebuffsTable["^" .. selfDebuffsFormat:format(actionName) .. "$"] = actionTable;
		end
		
		localSpeech.combatEvents = nil;
		localSpeech.selfBuffs = nil;
		localSpeech.selfDebuffs = nil;
		localSpeech.miscActions = nil;
	end
	
	
	if (localSpeech.version < 120) then
		local messageEvents = localSpeech.messageEvents;
		local combatEvents = {};
		localSpeech.combatEvents = combatEvents;
		
		for event, parseTextLists in pairs(messageEvents) do
			if (
			  (event:match("^CHAT_MSG_SPELL") ~= nil or event:match("^CHAT_MSG_COMBAT") ~= nil)
			  and (
			    event ~= "CHAT_MSG_COMBAT_FACTION_CHANGE"
				and event ~= "CHAT_MSG_COMBAT_HONOR_GAIN"
				and event ~= "CHAT_MSG_COMBAT_XP_GAIN"
			  )
			) then
				messageEvents[event] = nil;
				for parseText, actionTable in pairs(parseTextLists) do
					combatEvents["<deprecated> " .. event .. " " .. parseText] = actionTable;
				end
			end
		end
	end
	
	
	if (localSpeech.version < 140 or globalSpeech.version < 140) then
		-- Rearrange into new array format.
		local actionsLists;
		if (localSpeech.version < 140) then
			actionsLists = {
				[localSpeech.combatEvents] = false;
				[localSpeech.miscEvents] = false;
				[localSpeech.generalActions] = true;
			};
			for eventName, actionsList in pairs(localSpeech.messageEvents) do
				actionsLists[actionsList] = false;
			end
		end
		if (globalSpeech.version < 140) then
			if (actionsLists ~= nil) then
				actionsLists[globalSpeech.hotkeys] = false;
			else
				actionsLists = { [globalSpeech.hotkeys] = false; };
			end
		end
		
		local foundSendAtStart, foundNotSendAtStart, entryTable;
		for list, allowTriggerBits in pairs(actionsLists) do
			for actionName, actionTable in pairs(list) do
				if (actionTable[1] ~= nil) then
					for rrIndex, rrTable in pairs(actionTable[1]) do
						foundSendAtStart = false;
						foundNotSendAtStart = false;
						if (rrTable[1] ~= nil) then
							if (rrTable[4] == true) then
								for entryIndex, entryTable in pairs(rrTable[1]) do
									-- Shift index 9 into the blank 8.
									entryTable[8] = entryTable[9];
									entryTable[9] = nil;
									-- Remove index 3.
									if (entryTable[3] == true) then
										foundSendAtStart = true;
									else
										foundNotSendAtStart = true;
									end
									for index = 3, 7, 1 do
										entryTable[index] = entryTable[index + 1];
									end
									entryTable[8] = nil;
								end
							else
								entryTable = rrTable[1];
								-- Shift index 9 into the blank 8.
								entryTable[8] = entryTable[9];
								entryTable[9] = nil;
								-- Remove index 3.
								if (entryTable[3] == true) then
									foundSendAtStart = true;
								else
									foundNotSendAtStart = true;
								end
								for index = 3, 7, 1 do
									entryTable[index] = entryTable[index + 1];
								end
								entryTable[8] = nil;
							end
						end
						
						-- Replace multiEntry, which is now determined dynamically, with the triggerBits.
						if (allowTriggerBits == true) then
							if (foundSendAtStart == true) then
								if (foundNotSendAtStart == true) then
									rrTable[4] = 0x3;
								else
									rrTable[4] = 0x1;
								end
							else
								if (foundNotSendAtStart == true) then
									rrTable[4] = 0x2;
								else
									rrTable[4] = nil;
								end
							end
						else
							rrTable[4] = nil;
						end
					end
				end
			end
		end
	end
	
	
	if (globalSpeech.version < 150) then
		-- Prior to 1.5.0, values were erroneously stored directly in the table instead of one level deeper, under "hotkeys".
		local hotkeys = globalSpeech.hotkeys;
		for key, value in pairs(globalSpeech) do
			if (key ~= "hotkeys" and key ~= "version") then
				if (hotkeys[key] == nil) then
					hotkeys[key] = value;
				end
				globalSpeech[key] = nil;
			end
		end
		-- Prior to 1.5.0, hotkey actions are now stored with a simply integer.
		local tonumber = tonumber;
		local newHotkeys = {};
		for actionName, actionConfig in pairs(hotkeys) do
			newHotkeys[tonumber(actionName:match("%d+"))] = actionConfig;
		end
		globalSpeech.hotkeys = newHotkeys;
	end
end

