local version = "3.0";

SealCountdown = {};

SealCountdown.seals = { -- seal spellIDs, are replaced with local seal names at OnLoad
	20287, -- Seal of Righteousness (rank 2)
	31892, -- Seal of Blood (rank 1)
	31801, -- Seal of Vengeance (rank 1)
	20375, -- Seal of Command (rank 1)
	20162, -- Seal of the Crusader (rank 2)
	20164, -- Seal of Justice (rank 1)
	20165, -- Seal of Light (rank 1)
	20166, -- Seal of Wisdom (rank 1)
}

SealCountdown.SealTime = nil;
SealCountdown.SealName = "";
SealCountdown.FrameMovable = false;


function SealCountdown:OnLoad(self)
	self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
	SLASH_SEALCOUNTDOWN1 = "/seal";
	SLASH_SEALCOUNTDOWN2 = "/sealcountdown";
	SlashCmdList["SEALCOUNTDOWN"] = SealCountdown_SlashCmd;
	-- replace seal spellIDs with local seal names
	for i=1, #SealCountdown.seals do
		local seal_name = GetSpellInfo(SealCountdown.seals[i]);
		SealCountdown.seals[i] = seal_name;
	end
	if not SealCountdownData then -- write settings data if not existing already
		SealCountdownData = {
			["point"] = "CENTER", 
			["relative_point"] = "CENTER", 
			["x_offset"] = 0, 
			["y_offset"] = 75,
			["showtime"] = 7,
		}
	end
	SealCountdownFrame:EnableMouse(false);
	DEFAULT_CHAT_FRAME:AddMessage("|cffffff00SealCountdown "..version.." loaded. Use|cffffffff /seal|cffffff00 to configure");
end

function SealCountdown_SlashCmd(arg)
	if arg and string.match(arg, "text") then -- make the text-frame movable
		SealCountdown:RefreshFrameLocation();
		SealCountdown.FrameMovable = true;
		SealCountdownFrame:SetMovable(true);
		SealCountdownFrame:EnableMouse(true);
		SealCountdownFrameText:SetText("SealCountdown Drag & Drop");
	elseif arg and string.match(arg, "%d+") then -- change showtime
		local new_time = tonumber(string.match(arg, "%d+"));
		SealCountdownData.showtime = new_time;
		DEFAULT_CHAT_FRAME:AddMessage("|cffffff00SealCountdown showtime : "..new_time.." s");
	else -- present info
		DEFAULT_CHAT_FRAME:AddMessage("|cffffffff/seal|cffff9900 N|cffffff00 sets showtime (|cffff9900 N|cffffff00 = 0 ... 30 )");
		DEFAULT_CHAT_FRAME:AddMessage("|cffffffff/seal text|cffffff00 makes countdown text movable");
	end
end

function SealCountdown:RefreshFrameLocation()
	SealCountdownFrame:ClearAllPoints();
	SealCountdownFrame:SetPoint(SealCountdownData.point, "UIParent", SealCountdownData.relative_point, SealCountdownData.x_offset, SealCountdownData.y_offset);
	SealCountdownFrame:EnableMouse(false);
end

function SealCountdown:mouseHandler(frame, mouse_down)
	if mouse_down then
		if SealCountdown.FrameMovable and arg1 == "LeftButton" then
			frame:StartMoving();
			frame.isMoving = true;
		end
	else
		if frame.isMoving then
			SealCountdown.FrameMovable = false;
			frame:StopMovingOrSizing();
			frame.isMoving = false;
			frame:SetMovable(false);
			frame:EnableMouse(false);
			SealCountdownFrameText:SetText("");
			local point, relativeTo, relativePoint, xOfs, yOfs = frame:GetPoint();
			SealCountdownData.point = point;
			SealCountdownData.relative_point = relativePoint;
			SealCountdownData.x_offset = xOfs;
			SealCountdownData.y_offset = yOfs;
		end
	end
end

function SealCountdown:OnEvent()
	if arg2 == "SPELL_AURA_APPLIED" and arg7 == UnitName("player") then -- if you are buffed
		for i=1, #SealCountdown.seals do -- check if it is a seal
			if arg10 == SealCountdown.seals[i] then
				SealCountdown.SealName = SealCountdown.seals[i];
				SealCountdown.SealTime = 666; -- anything high
				SealCountdown:RefreshFrameLocation();
				break;
			end
		end
	end
end

function SealCountdown:timerHandler()
	if SealCountdown.SealTime then
		local secs_left = nil; -- remaining time of seal
		for buff_index = 1 , 16 do
			local buff_name = GetPlayerBuffName(buff_index);
			if buff_name and buff_name == SealCountdown.SealName then
				secs_left = GetPlayerBuffTimeLeft(buff_index);
				break;
			end
		end
		if secs_left and secs_left < SealCountdownData.showtime+1 then -- show (and update)
			secs_left = math.floor(secs_left);
			if secs_left < SealCountdown.SealTime then -- tick and update if time has changed
				PlaySoundFile("Interface\\AddOns\\SealCountdown\\tick.wav");
				SealCountdownFrameText:SetText(SealCountdown.SealName.." : "..secs_left.." s");
				SealCountdown.SealTime = secs_left;
			end
		else -- hide (and end)
			SealCountdownFrameText:SetText("");
			if not secs_left then -- turn off
				SealCountdown.SealName = "";
				SealCountdown.SealTime = nil;
			end
		end
	end
end
