-- 
-- Totem timer functions
-- 
SBF.totems = {}

local totemTextures = {
  "Interface\\Icons\\Spell_Nature_StoneSkinTotem",
  "Interface\\Icons\\Spell_Nature_StoneClawTotem",
  "Interface\\Icons\\Spell_Nature_StrengthOfEarthTotem02",
  "Interface\\Icons\\Spell_FireResistanceTotem_01",
  "Interface\\Icons\\Spell_FrostResistanceTotem_01",
  "Interface\\Icons\\Spell_Nature_GroundingTotem",
  "Interface\\Icons\\Spell_Nature_InvisibilityTotem",
  "Interface\\Icons\\Spell_Nature_StrengthOfEarthTotem02",
  "Interface\\Icons\\Spell_Fire_SearingTotem",
  "Interface\\Icons\\Spell_Nature_EarthBindTotem",
  "Interface\\Icons\\Spell_Fire_SealOfFire",
  "Interface\\Icons\\Spell_Nature_TremorTotem",
  "Interface\\Icons\\INV_Spear_04",
  "Interface\\Icons\\Spell_Nature_PoisonCleansingTotem",
  "Interface\\Icons\\Spell_Fire_SelfDestruct",
  "Interface\\Icons\\Spell_Nature_ManaRegenTotem",
  "Interface\\Icons\\Spell_Nature_GuardianWard",
  "Interface\\Icons\\Spell_Nature_NatureResistanceTotem",
  "Interface\\Icons\\Spell_Nature_Windfury",
  "Interface\\Icons\\Spell_Nature_RemoveCurse",
  "Interface\\Icons\\Spell_Nature_EarthBind",
  "Interface\\Icons\\Spell_Nature_DiseaseCleansingTotem",
  "Interface\\Icons\\Spell_Frost_SummonWaterElemental",
  "Interface\\Icons\\Spell_Fire_TotemOfWrath",
  "Interface\\Icons\\Spell_Nature_Brilliance",
  "Interface\\Icons\\Spell_Nature_SlowingTotem",
  "Interface\\Icons\\Spell_Nature_EarthElemental_Totem",
  "Interface\\Icons\\Spell_Fire_Elemental_Totem",
}

SBF.IsTotemIcon = function(self, buff)
  for k,v in ipairs(self.totemTextures) do
    if (buff.icon == v) then
      if (buff.name == self.strings.SPELL_COMBUSTION) or (buff.name == self.strings.SPELL_FR_AURA) then
        return false
      end
      return true
    end
  end
end

-- Totems that give you a buff
--{ "BuffName"] = "GetTotemInfoName" }
local buffTotems = {
  ["Totem of Wrath"] = "Totem of Wrath",
  ["Fire Resistance"] = "Fire Resistance Totem",
  ["Flametongue Totem"] = "Flametongue Totem",
  ["Frost Resistance"] = "Frost Resistance Totem",
  ["Grace of Air"] = "Grace of Air Totem",
  ["Grounding Totem Effect"] = "Grounding Totem",
  ["Nature Resistance"] = "Nature Resistance Totem",
  ["Sentry Totem"] = "Sentry Totem",
  ["Stoneskin"] = "Stoneskin Totem",
  ["Strength of Earth"] = "Strength of Earth Totem",
  ["Windwall"] = "Windwall Totem",
  ["Wrath of Air Totem"] = "Wrath of Air Totem",
  ["Healing Stream"] = "Healing Stream Totem",
  ["Mana Spring"] = "Mana Spring Totem",
  ["Tranquil Air"] = "Tranquil Air Totem",
}

if ( GetLocale() == "zhCN" ) then
local buffTotems = {
  ["Totem of Wrath"] = "天怒图腾",
  ["Fire Resistance"] = "抗火图腾",
  ["Flametongue Totem"] = "火舌图腾",
  ["Frost Resistance"] = "抗寒图腾",
  ["Grace of Air"] = "风之优雅图腾",
  ["Grounding Totem Effect"] = "地缚图腾",
  ["Nature Resistance"] = "自然抗性图腾",
  ["Sentry Totem"] = "岗哨图腾",
  ["Stoneskin"] = "石肤图腾",
  ["Strength of Earth"] = "大地之力图腾",
  ["Windwall"] = "风墙图腾",
  ["Wrath of Air Totem"] = "空气之怒图腾",
  ["Healing Stream"] = "治疗之泉图腾",
  ["Mana Spring"] = "法力之泉图腾",
  ["Tranquil Air"] = "宁静之风图腾",
}
end

if ( GetLocale() == "zhTW" ) then
local buffTotems = {
  ["Totem of Wrath"] = "憤怒圖騰",
  ["Fire Resistance"] = "抗火圖騰",
  ["Flametongue Totem"] = "火舌圖騰",
  ["Frost Resistance"] = "抗寒圖騰",
  ["Grace of Air"] = "風之優雅圖騰",
  ["Grounding Totem Effect"] = "地縛圖騰",
  ["Nature Resistance"] = "自然抗性圖騰",
  ["Sentry Totem"] = "崗哨圖騰",
  ["Stoneskin"] = "石甲圖騰",
  ["Strength of Earth"] = "大地之力圖騰",
  ["Windwall"] = "風牆圖騰",
  ["Wrath of Air Totem"] = "風懲圖騰",
  ["Healing Stream"] = "治療之泉圖騰",
  ["Mana Spring"] = "法力之泉圖騰",
  ["Tranquil Air"] = "寧靜之風圖騰",
}
end

SBF.FindBuffTotem = function(self, name)
  local n
  for k,v in ipairs(self.buffs) do
    n = buffTotems[v.name]
    if n and string.find(name, n) then
      return v
    end
  end
  return nil
end

SBF.AddTotems = function(self)
  if not self.hasTotems or self.db.profile.noTotemTimers then
    return false
  end
  
  local name, start, duration, icon, buff
  
  for i=1,4 do
    if self.totems[i] then
      self.totems[i].cleanup = 1
    end
  end
  
  for i=1,4 do
    _, name, start, duration, icon = GetTotemInfo(i)
    if (start > 0) then
      buff = self:FindBuffTotem(name)
      if not buff then
        if not self.totems[i] then
          self.totems[i] = self:GetTable()
        end
        buff = self.totems[i]
        buff.icon = icon
        buff.name = name
        buff.createdTotem = true
        table.insert(self.buffs, buff)
      end
      buff.duration = duration
      buff.buffType = self.TOTEM
      buff.type = "HELPFUL"
      buff.untilCancelled = false
      buff.totemName = name
      buff.timeLeft = GetTotemTimeLeft(i)
      buff.expFloor = floor(buff.timeLeft)
      buff.last = buff.expFloor
      buff.totemSlot = i
      buff.cleanup = nil
    end
  end
  
  for i=1,4 do
    if self.totems[i] and self.totems[i].cleanup then
      self:PutTable(self.totems[i])
      self.totems[i] = nil
    end
  end
  
end

SBF.RemoveTotems = function(self)
  if not self.hasTotems or self.db.profile.noTotemTimers then
    return false
  end

  local removed
  while true do
    removed = false
    for k,v in ipairs(self.buffs) do
      if v.createdTotem then
        v._slot = nil
        table.remove(self.buffs, k)
        removed = true
      end
    end
    if not removed then
      return
    end
  end
end

SBF.TotemUpdate = function(self)
  self:ForceGet()
end