-- ButtonFacade support
-- $Revision: 78120 $
-- $Date: 2008-07-08 21:07:00 -0400 (Tue, 08 Jul 2008) $

if IsAddOnLoaded("ButtonFacade") then

  local bf = LibStub("AceAddon-3.0"):GetAddon("ButtonFacade")
  local lbf = LibStub("LibButtonFacade")

  local defaults = {
    profile = {
      ["*"] = {
        skin = "Blizzard",
        gloss = 0,
        backdrop = false,
        ColorLayer = {
          Normal = {1, 1, 1, 1},
          Gloss = {1, 1, 1, 1},
          Border = {1, 1, 1, 1},
          Backdrop = {1, 1, 1, 1},
          Disabled = {1, 1, 1, 1},
          Highlight = {1, 1, 1, 1},
        },
      },
    },
  }

  local SBFBF = bf:NewModule("SBF")

  SBFBF.Load = function(self)
    self:SetupGroups()
    lbf:RegisterSkinCallback("SBF", self.SkinCallback, self)
  end

  SBFBF.SetupGroups = function(self)
    for k,v in ipairs(SBF.frames) do
      self:SetupGroup("SBF", v:GetName())
    end
  end
  
  SBFBF.OnInitialize = function(self)
    self.db = self:RegisterNamespace("SBF", defaults)
  end

  SBFBF.SkinCallback = function(self, skin, gloss, backdrop, frame, button, colors)
    if not frame then 
      return 
    end
    self.db.profile[frame].skin = skin
    self.db.profile[frame].gloss = gloss
    self.db.profile[frame].backdrop = backdrop
    self:FixCounts(frame)
  end

  SBFBF.SetupGroup = function(self, addon, frame)
    local f = _G[frame]
    local bargroup = lbf:Group("SBF", frame)
    for index,slot in ipairs(f.slots) do
      if slot and slot.button then
        bargroup:AddButton(slot.button)
      end
    end
    bargroup:Skin(self.db.profile[frame].skin, self.db.profile[frame].gloss, self.db.profile[frame].backdrop, self.db.profile[frame].ColorLayer)
    self:FixCounts(frame)
  end
  
  -- ButtonFacade does not respect your anchors when it skins
  -- We'll fix that back up here
  SBFBF.FixCounts = function(self, frame)
    local f = _G[frame]
    for index,slot in ipairs(f.slots) do
      if slot and slot.button then
        slot.button.count:ClearAllPoints()
        slot.button.count:SetPoint("BOTTOMRIGHT", slot.button, "BOTTOMRIGHT", -1, 3)
      end
    end
  end
  
end