-- $Date: 2008-07-08 21:07:42 -0400 (Tue, 08 Jul 2008) $

SBFOptions = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0")
SBFOptions._beta = false
SBFOptions.minor = 8
SBFOptions.revision = tonumber(("$Revision: 78121 $"):match("%d+"))

SBFOptions.optionsElapsed = 0
SBFOptions.curFrame = SBF.frames[1]
SBFOptions.curTab = 1
SBFOptions.dirty = false

local _var
local SML = LibStub and LibStub:GetLibrary('LibSharedMedia-3.0')
local ColourFrame = LibStub and LibStub:GetLibrary('LibColourFrame-1.0')
local ScrollingDropDown = LibStub and LibStub:GetLibrary('LibScrollingDropDown-1.0')

local SBFOButtons = {}
local SBFOFilterButtons = {}
local SBFOSpellListButtons = {}

local ENCHANT = 0
local HELPFUL = 10
local HARMFUL = 20

local self = SBFOptions

SBFOptions.OnInitialize = function(self)
  if self._beta then
    SBFOptions.versionStr = self.version.." beta "..self.minor
  else
    self.versionStr = self.version.."."..self.minor
  end

	UIPanelWindows["SatrinaBuffFrameOptions"] =		{ area = "center",	pushable = 0,	whileDead = 1 }
	SBFOCloseButton:SetFormattedText(CLOSE)
	SBFONewFrameButton:SetFormattedText(self.strings.NEWFRAME)
	SBFORemoveFrameButton:SetFormattedText(self.strings.REMOVE)
	SBFOFilterUpButton:SetFormattedText(self.strings.UP)
	SBFOFilterDownButton:SetFormattedText(self.strings.DOWN)
	SBFOFilterEditButton:SetFormattedText(self.strings.EDIT)
	SBFOFilterRemoveButton:SetFormattedText(self.strings.REMOVE)
	SBFOClearSpellsButton:SetFormattedText(self.strings.CLEARSPELLS)
	SBFOResetButton:SetFormattedText(self.strings.RESET)
	SBFOVersionString:SetFormattedText(self.strings.VERSION2, SBF.versionStr)
	SBFOHint:SetFormattedText(self.strings.HINT)
	SBFOGlobalConfigButton.text:SetFormattedText(self.strings.GLOBALCONFIG)
	SBFOFilterConfigButton.text:SetFormattedText(self.strings.FILTERCONFIG)
	SBFOSpellsConfigButton.text:SetFormattedText(self.strings.SPELLCONFIG)
	SBFOFilterEditButton:Disable()

	self.tabs = { SBFOLayoutTab, SBFOBarsTab, SBFOTimersTab, SBFOExpiryTab, SBFOFilterTab, SBFOSpellsTab, SBFOGlobalTab }
	
  self.hasSCT = MikSBT or SCT or Parrot or (getglobal("SHOW_COMBAT_TEXT") == "1")
  if MikSBT then
    self.scrollingAddOn = "MikSBT"
  elseif SCT then
    self.scrollingAddOn = "SCT"
  elseif Parrot then
    self.scrollingAddOn = Parrot.title:match("%a+")
  else
    self.scrollingAddOn = NONE
  end
  
	SBFOSpacingXSliderLow:SetFormattedText(-15)
	SBFOSpacingXSliderHigh:SetFormattedText(15)
	SBFOSpacingXSlider:SetMinMaxValues(-15, 15)
	SBFOSpacingYSliderLow:SetFormattedText(-15)
	SBFOSpacingYSliderHigh:SetFormattedText(15)
	SBFOSpacingYSlider:SetMinMaxValues(-15, 15)
	SBFOSpacingYSlider:SetValueStep(1)
	SBFOSpacingXSlider:SetValueStep(1)
	SBFOIconScaleSliderLow:SetFormattedText(0.5)
	SBFOIconScaleSliderHigh:SetFormattedText(2.0)
	SBFOIconScaleSlider:SetMinMaxValues(0.5, 2.0)
	SBFOIconScaleSlider:SetValueStep(0.1)
	SBFOTimerFontSizeSliderLow:SetFormattedText(6)
	SBFOTimerFontSizeSliderHigh:SetFormattedText(24)
	SBFOTimerFontSizeSlider:SetMinMaxValues(6, 24)
	SBFOTimerFontSizeSlider:SetValueStep(1)
	SBFOTimerYPositionSliderLow:SetFormattedText(-20)
	SBFOTimerYPositionSliderHigh:SetFormattedText(75)
	SBFOTimerYPositionSlider:SetMinMaxValues(-20, 75)
	SBFOTimerYPositionSlider:SetValueStep(1)
	SBFOTimerXPositionSliderLow:SetFormattedText(-75)
	SBFOTimerXPositionSliderHigh:SetFormattedText(75)
	SBFOTimerXPositionSlider:SetMinMaxValues(-75, 75)
	SBFOTimerXPositionSlider:SetValueStep(1)
	SBFOOpacitySliderLow:SetFormattedText(0.1)
	SBFOOpacitySliderHigh:SetFormattedText(1.0)
	SBFOOpacitySlider:SetMinMaxValues(0.1, 1.0)
	SBFOOpacitySlider:SetValueStep(0.1)
	SBFOBarOffsetSlider:SetMinMaxValues(0,10)
	SBFOBarOffsetSlider:SetValueStep(1)
	SBFOBarOffsetSliderLow:SetFormattedText(0)
	SBFOBarOffsetSliderHigh:SetFormattedText(10)
	SBFOBarWidthSlider:SetMinMaxValues(50,300)
	SBFOBarWidthSlider:SetValueStep(5)
	SBFOBarWidthSliderLow:SetFormattedText(50)
	SBFOBarWidthSliderHigh:SetFormattedText(300)
	SBFOBarNameFontSlider:SetMinMaxValues(6,24)
	SBFOBarNameFontSlider:SetValueStep(1)
	SBFOBarNameFontSliderLow:SetFormattedText(6)
	SBFOBarNameFontSliderHigh:SetFormattedText(24)
  
  if IsAddOnLoaded("cyCircled") then
    SBFOcyCircledSliderLow:SetFormattedText(15)
    SBFOcyCircledSliderHigh:SetFormattedText(50)
    SBFOcyCircledSlider:SetMinMaxValues(15,50)
    SBFOcyCircledSlider:SetValueStep(1)
    self:EnableCheckbox(SBFOcyCircledCheckButton)
  else
    SBFOcyCircledSlider:Hide()
    self:DisableCheckbox(SBFOcyCircledCheckButton)
  end

	SBFOCopyFromDropDown:Init(self.DropDownCallback, self.strings.COPYFROM)
	SBFOBuffFilterEdit.label:SetFormattedText(self.strings.FILTER)
  SBFOSpellFilterEdit.label:SetFormattedText(self.strings.SPELLFILTER)
	SBFOAddFilterButton:SetFormattedText(self.strings.ADDFILTER)
	SBFOFilterHelpButton:SetFormattedText(self.strings.FILTERHELP)
	SBFODisableBuffRightClickButtonText:SetFormattedText(self.strings.BUFFRIGHTCLICK)
	SBFONoTooltipButtonText:SetFormattedText(self.strings.NOTOOLTIPS)
	SBFORowsCheckButtonText:SetFormattedText(self.strings.BUFFHORIZONTAL)
	SBFOReverseCheckButtonText:SetFormattedText(self.strings.REVERSEBUFF)
	SBFOBottomCheckButtonText:SetFormattedText(self.strings.BOTTOM)
	SBFOSoundWarningDropDownLabel:SetFormattedText(self.strings.WARNSOUND)
	SBFOCountColourLabel:SetFormattedText(self.strings.STACKCOLOUR)
	SBFOSCTColourLabel:SetFormattedText(self.strings.SCTCOLOUR)
	SBFOTextWarningCheckButtonText:SetFormattedText(self.strings.EXPIREWARN)
	SBFOTextNoticeCheckButtonText:SetFormattedText(self.strings.EXPIRENOTICE)
	SBFOSoundWarningCheckButtonText:SetFormattedText(self.strings.EXPIRESOUND)
	SBFOSCTWarnCheckButtonText:SetFormattedText(self.strings.SCTWARN, self.scrollingAddOn)
	SBFOFlashBuffCheckButtonText:SetFormattedText(self.strings.FLASHBUFF)
	SBFORegularTimerColourLabel:SetFormattedText(self.strings.TIMERCOLOUR)
	SBFOExpireTimerColourLabel:SetFormattedText(self.strings.EXPIRECOLOUR)
	SBFOEnableFiltersCheckButtonText:SetFormattedText(self.strings.ENABLEFILTERS)
	SBFOEnableRFiltersCheckButtonText:SetFormattedText(self.strings.ENABLERFILTERS)
	SBFOMirrorFrameBuffsCheckButtonText:SetFormattedText(self.strings.MIRRORBUFFS)
	SBFODebuffTimerCheckButtonText:SetFormattedText(self.strings.DEBUFFTIMER)
	SBFOTimerOutlineCheckButtonText:SetFormattedText(self.strings.OUTLINEFONT)
	SBFOSCTCritCheckButtonText:SetFormattedText(self.strings.SCTCRIT)
	SBFOAlwaysWarnCheckButtonText:SetFormattedText(self.strings.ALWAYSWARN)
	SBFOSpellExcludeCheckButtonText:SetFormattedText(self.strings.EXCLUDE)
	SBFOShowBuffsCheckButtonText:SetFormattedText(self.strings.SHOWBUFFS)
	SBFOShowDebuffsCheckButtonText:SetFormattedText(self.strings.SHOWDEBUFFS)
	SBFOEnableBarsCheckButtonText:SetFormattedText(self.strings.SHOWBARS)
	SBFOBarBuffColourLabel:SetFormattedText(self.strings.BARBUFFCOLOUR)
	SBFOBarDebuffColourLabel:SetFormattedText(self.strings.BARDEBUFFCOLOUR)
	SBFOBarBackdropColourLabel:SetFormattedText(self.strings.BARBACKDROP)
	SBFOFastBarCheckButtonText:SetFormattedText(self.strings.FASTBAR)
	SBFOLeftBarsCheckButtonText:SetFormattedText(self.strings.LEFTBARS)
	SBFOCountInNameCheckButtonText:SetFormattedText(self.strings.COUNTINNAME)
	SBFOBarNameColourLabel:SetFormattedText(self.strings.NAMECOLOUR)
	SBFOShortNameCheckButtonText:SetFormattedText(self.strings.SHORTNAMES)
	SBFODebuffBarColourCheckButtonText:SetFormattedText(self.strings.DEBUFFBARCOLOUR)
	SBFOAuraMaxTimeCheckButtonText:SetFormattedText(self.strings.AURAMAXTIME)
	SBFOEnchantsFirstCheckButtonText:SetFormattedText(self.strings.ENCHANTSFIRST)
	SBFOTrackingCheckButtonText:SetFormattedText(self.strings.TRACKING)
  SBFOcyCircledCheckButtonText:SetFormattedText(self.strings.USECYCIRCLED)
  SBFOTotemTimersButtonText:SetFormattedText(self.strings.TOTEMTIMERS)
  
	SBFOShowBuffsCheckButton:SetChecked(true)
	SBFOShowDebuffsCheckButton:SetChecked(false)

	for i=1,10 do
		SBFOFilterButtons[i] = getglobal("SBFOFilterList"..i)
		SBFOSpellListButtons[i] = getglobal("SBFOSpellList"..i)
	end
	
	for k,v in pairs(SBF.db.profile.frames) do
		ColourFrame:AddCopy(nil, v.regularTimerColour.r, v.regularTimerColour.g, v.regularTimerColour.b)
		ColourFrame:AddCopy(nil, v.expireTimerColour.r, v.expireTimerColour.g, v.expireTimerColour.b)
		ColourFrame:AddCopy(nil, v.countColour.r, v.countColour.g, v.countColour.b)
		ColourFrame:AddCopy(nil, v.barBuffColour.r, v.barBuffColour.g, v.barBuffColour.b)
		ColourFrame:AddCopy(nil, v.barDebuffColour.r, v.barDebuffColour.g, v.barDebuffColour.b)
		ColourFrame:AddCopy(nil, v.barBackdropColour.r, v.barBackdropColour.g, v.barBackdropColour.b)
		ColourFrame:AddCopy(nil, v.barNameColour.r, v.barNameColour.g, v.barNameColour.b)
		ColourFrame:AddCopy(nil, v.sctColour.r, v.sctColour.g, v.sctColour.b)
	end
	
  self:InitScrollingDropDowns()
  SBFOCopyFromDropDown:Init(self.DropDownCallback, self.strings.COPYFROM)
 
  self.cacheSize = 0
end

SBFOptions.DropDownCallback = function()
  ScrollingDropDown:Open(this:GetParent())
end

SBFOptions.Reset = function(self)
  self:CloseOptions()
	SBF:ResetFrames(true)
end

SBFOptions.SelectTab = function(self, tab)
	if tab then
		SBFOptions.curTab = tab
	end

	for k,v in ipairs(SBFOptions.tabs) do
		if (k == SBFOptions.curTab) then
			v:Show()
		else
			v:Hide()
		end
	end
end

SBFOptions.SelectFrame = function(self, f)
	if f then
    if type(f) == "number" then
      self.curFrame = SBF.frames[f]
    else
      self.curFrame = f
    end
	end
	
  local var = self.curFrame._var
  
	for k,frame in pairs(SBF.frames) do
		if (frame == self.curFrame) then
			frame.tab1.label:SetTextColor(0,1,0)
			frame.tab2.label:SetTextColor(0,1,0)
      if IsAddOnLoaded("cyCircled") then
        SBFOcyCircledCheckButton:SetChecked(cyCircled_SatrinaBuffFrames.db.profile[frame:GetName()])
      end
		else
			frame.tab1.label:SetTextColor(NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b)
			frame.tab2.label:SetTextColor(NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b)
		end
	end
	
	self.curFrame.extent = nil
	SBFOptions:BarTab(var)
	SBFOptions:ExpiryTab(var)
	SBFOptions:LayoutTab(var)
	SBFOptions:TimersTab(var)
	SBFOptions:SpellsTab(var)
  SBFOptions:InitialiseGlobalDropDowns()
  
	SBFOLayoutConfigButton.text:SetFormattedText(self.strings.LAYOUTCONFIG, string.format(self.strings.FRAME, self.curFrame.id))
	SBFOExpiryConfigButton.text:SetFormattedText(self.strings.WARNCONFIG, string.format(self.strings.FRAME, self.curFrame.id))
	SBFOTimersConfigButton.text:SetFormattedText(self.strings.TIMERCONFIG, string.format(self.strings.FRAME, self.curFrame.id))
	SBFOBarsConfigButton.text:SetFormattedText(self.strings.BARCONFIG, string.format(self.strings.FRAME, self.curFrame.id))

	SBFOptions:SetSliderText()
	
	SBFODisableBuffRightClickButton:SetChecked(var.disableRightClick)
	SBFONoTooltipButton:SetChecked(var.noTooltips)
	SBFORowsCheckButton:SetChecked(var.rows)
	SBFOReverseCheckButton:SetChecked(var.reverse)
	SBFOBottomCheckButton:SetChecked(var.bottom)
	SBFOEnableBarsCheckButton:SetChecked(var.showBars)
	
	SBFOIconScaleSlider:SetValue(var.iconScale)
	SBFOTimerFontSizeSlider:SetValue(var.timerFontSize)
	SBFOTimerYPositionSlider:SetValue(var.timerPositionY)
	SBFOTimerXPositionSlider:SetValue(var.timerPositionX)
	SBFOSpacingXSlider:SetValue(var.spacingX)
	SBFOSpacingYSlider:SetValue(var.spacingY or 0)
	SBFOOpacitySlider:SetValue(var.opacity)
	SBFOBarOffsetSlider:SetValue(var.barOffset)
	SBFOBarWidthSlider:SetValue(var.barWidth)
	SBFOBarNameFontSlider:SetValue(var.barNameFontSize)

	-- UIDropDownMenu_SetText(self.strings.timerFormats[var.timerFormat], SBFOTimerFormatDropDown)

	SBFOTextWarningCheckButton:SetChecked(var.textWarning)
	SBFOTextNoticeCheckButton:SetChecked(var.textNotice)
	SBFOSoundWarningCheckButton:SetChecked(var.soundWarning)
	SBFOFlashBuffCheckButton:SetChecked(var.flashBuff)
	SBFOCountInNameCheckButton:SetChecked(var.countInName)
	SBFOLeftBarsCheckButton:SetChecked(var.leftBars)
	SBFOShortNameCheckButton:SetChecked(var.shortNames)
	SBFODebuffBarColourCheckButton:SetChecked(var.debuffBarColour)
  
	SBFOptions:EnableCheckbox(SBFODebuffTimerCheckButton, var.debuffTimerColour)

	SBFOCountSliderLow:SetFormattedText(1)
	SBFOCountSliderHigh:SetFormattedText(var.count)
	SBFOCountSlider:SetMinMaxValues(1, var.count)
	SBFOCountSlider:SetValueStep(1)
	SBFOCountSlider:SetValue(var.rowCount)
	
	SBFOTimerOutlineCheckButton:SetChecked(var.timerOutline)
	SBFORegularTimerColour.texture:SetVertexColor(var.regularTimerColour.r, var.regularTimerColour.g, var.regularTimerColour.b)
	SBFOExpireTimerColour.texture:SetVertexColor(var.expireTimerColour.r, var.expireTimerColour.g, var.expireTimerColour.b)
	SBFOCountColour.texture:SetVertexColor(var.countColour.r, var.countColour.g, var.countColour.b)
	SBFOBarBuffColour.texture:SetVertexColor(var.barBuffColour.r, var.barBuffColour.g, var.barBuffColour.b)
	SBFOBarDebuffColour.texture:SetVertexColor(var.barDebuffColour.r, var.barDebuffColour.g, var.barDebuffColour.b)
	SBFOBarBackdropColour.texture:SetVertexColor(var.barBackdropColour.r, var.barBackdropColour.g, var.barBackdropColour.b)
	SBFOBarNameColour.texture:SetVertexColor(var.barNameColour.r, var.barNameColour.g, var.barNameColour.b)

  ScrollingDropDown:SetSelected(SBFOBarTextureDropDown, var.barTexture, ScrollingDropDown.TEXT)
	ScrollingDropDown:SetSelected(SBFOBuffFrameDropDown, SBFOptions.curFrame.id, ScrollingDropDown.VALUE)
	ScrollingDropDown:SetSelected(SBFOBuffCountDropDown, var.count, ScrollingDropDown.TEXT)
	ScrollingDropDown:SetSelected(SBFOFrameVisibilityDropDown, var.frameVisibility, ScrollingDropDown.VALUE)
	ScrollingDropDown:SetSelected(SBFOBuffSortDropDown, var.sortType, ScrollingDropDown.VALUE)
  ScrollingDropDown:SetSelected(SBFOBarNameJustifyDropDown, var.barNameJustify, ScrollingDropDown.TEXT)
	ScrollingDropDown:SetSelected(SBFOBarTimerPositionDropDown, var.barTimerPosition)
	ScrollingDropDown:SetSelected(SBFOBarNameFontDropDown, var.barNameFont, ScrollingDropDown.TEXT)
	ScrollingDropDown:SetSelected(SBFOExpireTimeDropDown, var.expireTime, ScrollingDropDown.VALUE)
	ScrollingDropDown:SetSelected(SBFOExpireFrameDropDown, var.expireFrame, ScrollingDropDown.TEXT)
	ScrollingDropDown:SetSelected(SBFOSoundWarningDropDown, var.sound, ScrollingDropDown.TEXT)
	ScrollingDropDown:SetSelected(SBFOMinTimeDropDown, var.warnTime, ScrollingDropDown.VALUE)
	ScrollingDropDown:SetSelected(SBFOTimerFontDropDown, var.timerFont, ScrollingDropDown.TEXT)
	ScrollingDropDown:SetSelected(SBFOTimerFormatDropDown, var.timerFormat, ScrollingDropDown.VALUE)
	ScrollingDropDown:SetSelected(SBFOTimerJustifyDropDown, var.timerJustify, ScrollingDropDown.TEXT)
end

SBFOptions.SetSliderText = function(self)
	SBFOIconScaleSliderText:SetFormattedText("%s (%.1f)", SBFOptions.strings.BUFF_SCALE, SBFOptions.curFrame._var.iconScale)
	SBFOTimerFontSizeSliderText:SetFormattedText("%s (%d)", SBFOptions.strings.TEXT_FONTSIZE, SBFOptions.curFrame._var.timerFontSize)
	SBFOTimerYPositionSliderText:SetFormattedText("%s (%d)", SBFOptions.strings.TEXT_POSITIONY, SBFOptions.curFrame._var.timerPositionY)
	SBFOTimerXPositionSliderText:SetFormattedText("%s (%d)", SBFOptions.strings.TEXT_POSITIONX, SBFOptions.curFrame._var.timerPositionX)
	SBFOSpacingXSliderText:SetFormattedText("%s (%d)", SBFOptions.strings.XSPACING, SBFOptions.curFrame._var.spacingX)
	SBFOSpacingYSliderText:SetFormattedText("%s (%d)", SBFOptions.strings.YSPACING, SBFOptions.curFrame._var.spacingY)
	SBFOOpacitySliderText:SetFormattedText("%s (%.1f)", SBFOptions.strings.OPACITY, SBFOptions.curFrame._var.opacity)
	SBFOBarOffsetSliderText:SetFormattedText("%s (%d)", SBFOptions.strings.BAROFFSET, SBFOptions.curFrame._var.barOffset)
	SBFOBarWidthSliderText:SetFormattedText("%s (%d)", SBFOptions.strings.BARWIDTH, SBFOptions.curFrame._var.barWidth)
	SBFOBarNameFontSliderText:SetFormattedText("%s (%d)", SBFOptions.strings.BARNAMEFONTSIZE, SBFOptions.curFrame._var.barNameFontSize)
	if SBFOptions.curFrame._var.rows then
		SBFOCountSliderText:SetFormattedText("%s (%d)", SBFOptions.strings.COLCOUNT, SBFOptions.curFrame._var.rowCount)
	else
		SBFOCountSliderText:SetFormattedText("%s (%d)", SBFOptions.strings.ROWCOUNT, SBFOptions.curFrame._var.rowCount)
	end
end

SBFOptions.LayoutTab = function(self, var)
	if (self.curFrame.id > 2) then
		SBFOptions:EnableCheckbox(SBFOMirrorFrameBuffsCheckButton, self.curFrame._var.mirrorBuffs)
		SBFORemoveFrameButton:Enable()
	else
		SBFOptions:DisableCheckbox(SBFOMirrorFrameBuffsCheckButton)
		SBFORemoveFrameButton:Disable()
	end
end

SBFOptions.ExpiryTab = function(self, var)
	if self.hasSCT then
    SBFOptions:EnableCheckbox(SBFOSCTCritCheckButton)
    SBFOptions:EnableCheckbox(SBFOSCTWarnCheckButton)
    SBFOptions:EnableColourButton(SBFOSCTColour)
    if SCT and (SCT:Get("SHOWFADE", SCT.FRAMES_TABLE) == SCT.MSG) then
      SBFOSCTCritCheckButton:SetChecked(false)
    else
      SBFOSCTCritCheckButton:SetChecked(var.sctCrit)
    end
    SBFOSCTWarnCheckButton:SetChecked(var.sctWarn)
    SBFOSCTColour.texture:SetVertexColor(var.sctColour.r, var.sctColour.g, var.sctColour.b)
  else
    SBFOptions:DisableCheckbox(SBFOSCTCritCheckButton)
    SBFOptions:DisableCheckbox(SBFOSCTWarnCheckButton)
    SBFOptions:DisableColourButton(SBFOSCTColour)
  end
	
  if var.soundWarning then
		SBFOSoundWarningDropDown:Enable()
	else
		SBFOSoundWarningDropDown:Disable()
	end
	if self.curFrame._var.showBars then
		SBFOptions:EnableCheckbox(SBFOFastBarCheckButton)
		SBFOFastBarCheckButton:SetChecked(self.curFrame._var.fastBar)
	else
		SBFOptions:DisableCheckbox(SBFOFastBarCheckButton)
	end
	if self.curFrame._var.textWarning or self.curFrame._var.textNotice then
		SBFOExpireFrameDropDown:Enable()
	else
		SBFOExpireFrameDropDown:Disable()
	end
end

SBFOptions.BarTab = function(self, var)
	if self.curFrame._var.showBars then
		SBFOptions:EnableCheckbox(SBFOCountInNameCheckButton)
		SBFOptions:EnableCheckbox(SBFOShortNameCheckButton)
		SBFOptions:EnableCheckbox(SBFODebuffBarColourCheckButton)
		SBFOptions:EnableCheckbox(SBFOLeftBarsCheckButton)
		SBFOBarTimerPositionDropDown:Enable()
		SBFOBarNameFontDropDown:Enable()
		SBFOBarNameJustifyDropDown:Enable()
    SBFOBarTextureDropDown:Enable()
		OptionsFrame_EnableSlider(SBFOBarOffsetSlider)
		OptionsFrame_EnableSlider(SBFOBarWidthSlider)
		OptionsFrame_EnableSlider(SBFOBarNameFontSlider)
		SBFOptions:EnableColourButton(SBFOBarBuffColour)
		SBFOptions:EnableColourButton(SBFOBarBackdropColour)
		SBFOptions:EnableColourButton(SBFOBarNameColour)
		if self.curFrame._var.debuffBarColour then
			SBFOptions:DisableColourButton(SBFOBarDebuffColour)
		else
			SBFOptions:EnableColourButton(SBFOBarDebuffColour)
		end
	else
		SBFOptions:DisableCheckbox(SBFOCountInNameCheckButton)
		SBFOptions:DisableCheckbox(SBFOShortNameCheckButton)
		SBFOptions:DisableCheckbox(SBFODebuffBarColourCheckButton)
		SBFOptions:DisableCheckbox(SBFOLeftBarsCheckButton)
		SBFOBarTimerPositionDropDown:Disable()
		SBFOBarNameFontDropDown:Disable()
		SBFOBarNameJustifyDropDown:Disable()
    SBFOBarTextureDropDown:Disable()
		OptionsFrame_DisableSlider(SBFOBarOffsetSlider)
		OptionsFrame_DisableSlider(SBFOBarWidthSlider)
		OptionsFrame_DisableSlider(SBFOBarNameFontSlider)
		SBFOptions:DisableColourButton(SBFOBarBuffColour)
		SBFOptions:DisableColourButton(SBFOBarDebuffColour)
		SBFOptions:DisableColourButton(SBFOBarBackdropColour)
		SBFOptions:DisableColourButton(SBFOBarNameColour)
	end
end

SBFOptions.TimersTab = function(self, var)
end

SBFOptions.SpellsTab = function(self, var)
end

SBFOptions.GlobalsTab = function(self, var)
	SBFOEnableFiltersCheckButton:SetChecked(_var.enableFilters)
	SBFOAuraMaxTimeCheckButton:SetChecked(_var.auraMaxTime)
	SBFOEnchantsFirstCheckButton:SetChecked(_var.enchantsFirst)
	SBFOTrackingCheckButton:SetChecked(_var.showTracking)
  SBFOTotemTimersButton:SetChecked(_var.noTotemTimers)
	if _var.enableFilters then
		SBFOptions:EnableCheckbox(SBFOEnableRFiltersCheckButton, _var.enableRFilters)
	else
		_var.enableRFilters = nil
		SBFOptions:DisableCheckbox(SBFOEnableRFiltersCheckButton)
	end
  if IsAddOnLoaded("cyCircled") then
    SBFOcyCircledSlider:SetValue(cyCircled_SatrinaBuffFrames.db.profile.adjust)
  end
end

SBFOptions.InitialiseGlobalDropDowns = function(self)
  self:CopyFromDropDown_Initialise()
	self:BuffFrameDropDown_Initialise()
end

SBFOptions.InitScrollingDropDowns = function(self)
	self:BarTextureDropDown_Initialise()
	self:BuffSortDropDown_Initialise()
	self:BuffCountDropDown_Initialise()
	self:FrameVisibilityDropDown_Initialise()
	self:SoundWarningDropDown_Initialise()
	self:MinTimeDropDown_Initialise()
	self:ExpireTimeDropDown_Initialise()
	self:ExpireFrameDropDown_Initialise()
	self:BarNameJustifyDropDown_Initialise()
	self:BarTimerPositionDropDown_Initialise()
	self:BarNameFontDropDown_Initialise()
	self:TimerDropDown_Initialise()
	self:TimerJustifyDropDown_Initialise()
	self:TimerFontDropDown_Initialise()
	self:CopyProfileDropDown_Initialise()
	self:ShowInFrameDropDown_Initialise()
	self:SpellDurationDropDown_Initialise()
end


SBFOptions.ShowOptions = function(self)
	_var = SBF.db.profile
	self:CancelScheduledEvent("SBFRefresh")
	SBF.showingOptions = 1
	SBF:ClearBuffFrames()
	self:SetupFrames()
	self:GlobalsTab()
	self:SelectFrame(1)
	self:SelectTab(1)
	SBF:FrameVisibility()
	self:ScheduleRepeatingEvent("SBFOptions", self.UpdateOptions, 0.1, self)
  self:FillSpellList()
	ShowUIPanel(SatrinaBuffFrameOptions)
end

SBFOptions.CloseOptions = function(self)
	self:CancelScheduledEvent("SBFOptions")
	HideUIPanel(SatrinaBuffFrameOptions)
  self:HideTabs()
  SBF:CloseOptions()
end

SBFOptions.SetupFrames = function(self)
	for index,frame in ipairs(SBF.frames) do
		self:SetupFrame(frame)
	end
end

SBFOptions.SetupFrame = function(self, frame)
	if not frame then
		frame = self.curFrame
	end
	self:MakeBuffs(frame)
  SBF:SetupFrameSlots(frame)
	self:ShowTabs(frame)
end

SBFOptions.MakeBuffs = function(self, frame)
	if not frame then
		frame = self.curFrame
	end

	local buff, button
	local var = frame._var

  if (#frame.slots ~= var.count) then
    SBF:SetupFrame(frame)
  end
  SBF:ClearBuffFrames(frame)

  for i,slot in ipairs(frame.slots) do
    buff = SBF:GetTable()
    buff.index = i
    buff.frame = frame
    buff.name = "Buff "..i
    buff.icon = SBFOptions:GetIcon((i == 1))
    buff.opacity = var.opacity
    buff.duration = (var.count * 60)
    if (i > var.count - 2) then
      buff.timeLeft = 15
    elseif (i > 2) then
      buff.timeLeft = (var.count - i + 2) * 60
    else
      buff.timeLeft = (var.count * 60)
    end
    buff.expFloor = buff.timeLeft
    buff.last = buff.duration + 1
    buff.count = i
    buff.hadCount = true
    if (mod(i,2) == 0) then
      buff.buffType = HARMFUL
      buff.type = "HARMFUL"
      buff.dispelType = self:GetDebuffType(i)
    else
      buff.buffType = HELPFUL
      buff.type = "HELPFUL"
    end
    table.insert(frame.buffs, buff)
  end
end

SBFOptions.ShowTabs = function(self, frame)
	local var = frame._var
	frame.tab1:Show()
	frame.tab2:Show()
	frame.tab1:ClearAllPoints()
	frame.tab2:ClearAllPoints()
  if var.bottom then
    frame.tab1:SetPoint("TOP", frame.slots[1].button, "BOTTOM", 0, (var.showBars and 0) or -13)
		frame.tab2:SetPoint("BOTTOM", frame.slots[var.count].button, "TOP", 0, 0)
	else
		frame.tab1:SetPoint("BOTTOM", frame.slots[1].button, "TOP", 0, 0)
		frame.tab2:SetPoint("TOP", frame.slots[var.count].button, "BOTTOM", 0, (var.showBars and 0) or -13)
	end
end

SBFOptions.HideTabs = function(self)
	for i,frame in ipairs(SBF.frames) do
		frame.tab1:Hide()
		frame.tab2:Hide()
  end
end

--
-- Layout
--

SBFOptions.InRows = function(self)
	SBFOptions.curFrame._var.rows = this:GetChecked()
	SBFOptions.SetSliderText()
	SBF:SetupFrame(self.curFrame, SBFOptions.curFrame._var)
end

SBFOptions.Reverse = function(self)
	SBFOptions.curFrame._var.reverse = this:GetChecked()
	SBF:SetupFrame(self.curFrame)
end

SBFOptions.Bottom = function(self)
	self.curFrame._var.bottom = this:GetChecked()
	SBF:SetupFrame(self.curFrame)
end

SBFOptions.BuffRightClick = function(self)
	SBFOptions.curFrame._var.disableRightClick = this:GetChecked()
end

SBFOptions.NoTooltips = function(self)
	SBFOptions.curFrame._var.noTooltips = this:GetChecked()
end

SBFOptions.MirrorBuffs = function(self)
	SBFOptions.curFrame._var.mirrorBuffs = this:GetChecked()
end

SBFOptions.cyCircled = function(self)
  local frameName = self.curFrame:GetName()
  cyCircled_SatrinaBuffFrames.db.profile[frameName] = (this:GetChecked() == 1)
  cyCircled_SatrinaBuffFrames:ApplySkin()
  cyCircled_SatrinaBuffFrames:ApplyColors()
  cyCircled_SatrinaBuffFrames:ApplyCustom()
  SBF:SetupFrameSlots(self.curFrame)
end

SBFOptions.AuraMaxTime = function(self)
  _var.auraMaxTime = this:GetChecked()
  SBF:UpdateTracking()
end

SBFOptions.EnchantsFirst = function(self)
  _var.enchantsFirst = this:GetChecked()
end

SBFOptions.ShowTracking = function(self)
  _var.showTracking = this:GetChecked()
  if _var.showTracking then
    MiniMapTracking:Hide()
  else
    MiniMapTracking:Show()
  end
  SBF:UpdateTracking()
end

SBFOptions.TotemTimers = function(self)
  _var.noTotemTimers = this:GetChecked()
end

SBFOptions.buffCounts = {1,2,4,6,8,10,16,20,24,28,32}
SBFOptions.BuffCountDropDown_Initialise = function(self)
	SBFOBuffCountDropDown:Init(self.DropDownCallback, self.strings.BUFFCOUNT)
  local info = SBF:GetTable()
	for v,i in ipairs(SBFOptions.buffCounts) do
		info.text = i
		info.value = i
		info.callback = SBFOptions.BuffCountDropDown_OnClick
		ScrollingDropDown:AddItem(SBFOBuffCountDropDown, info)
	end
	SBF:PutTable(info)
end

SBFOptions.BuffCountDropDown_OnClick = function(item)
	ScrollingDropDown:SetSelected(SBFOBuffCountDropDown, item.value)
	SBFOptions.curFrame._var.count = item.value
	SBFOCountSliderHigh:SetFormattedText(item.value)
	SBFOCountSlider:SetMinMaxValues(1, item.value)
	SBF:SetupFrame(self.curFrame)
  SBFOptions:SetupFrame(SBFOptions.curFrame)
  SBFOBuffCountDropDown:SetFormattedText(item.text)
  if IsAddOnLoaded("ButtonFacade") then
    local bf = LibStub("AceAddon-3.0"):GetAddon("ButtonFacade")
    bf:GetModule("SBF"):SetupGroups()
  end
end

SBFOptions.FrameVisibilityDropDown_Initialise = function(self)
	SBFOFrameVisibilityDropDown:Init(self.DropDownCallback, self.strings.VISIBILITY)
	local info = SBF:GetTable()
	for i,v in ipairs(SBFOptions.strings.frameVisibility) do
		info.text	= v
		info.value	= i
		info.callback	= SBFOptions.FrameVisibilityDropDown_OnClick
		ScrollingDropDown:AddItem(SBFOFrameVisibilityDropDown, info)
	end
	SBF:PutTable(info)
end

SBFOptions.FrameVisibilityDropDown_OnClick = function(item)
	SBFOptions.curFrame._var.frameVisibility = item.value
	ScrollingDropDown:SetSelected(SBFOFrameVisibilityDropDown, item.value)
  SBFOFrameVisibilityDropDown:SetFormattedText(item.text)
end

SBFOptions.BuffSortDropDown_Initialise = function(self)
	SBFOBuffSortDropDown:Init(self.DropDownCallback, self.strings.BUFFSORT)
	local info = SBF:GetTable()
	for i,v in pairs(SBF.sortOptions) do
		info.text = SBF.strings.sort[i]
		info.value = i
		info.callback = SBFOptions.BuffSortDropDown_OnClick
		ScrollingDropDown:AddItem(SBFOBuffSortDropDown, info)
	end
	SBF:PutTable(info)
end

SBFOptions.BuffSortDropDown_OnClick = function(item)
	ScrollingDropDown:SetSelected(SBFOBuffSortDropDown, item.value)
	SBFOptions.curFrame._var.sortType = item.value
	SBF.sortFunc = SBF.sortOptions[item.value]
	SBF:GetBuffs()
  SBFOBuffSortDropDown:SetFormattedText(item.text)
end

SBFOptions.SetCountColour = function(r,g,b)
	SBFOptions.curFrame._var.countColour = {r = r, g = g, b = b}
	SBFOCountColour.texture:SetVertexColor(r, g, b)
	SBF:SetupFrame(self.curFrame, SBFOptions.curFrame._var)
end
SBFOptions.CancelCountColour = function(r,g,b)
	SBFOptions.curFrame._var.countColour = {r = r, g = g, b = b}
	SBFOCountColour.texture:SetVertexColor(r, g, b)
	SBF:SetupFrame(self.curFrame, SBFOptions.curFrame._var)
end

--
-- Bars
--
SBFOptions.EnableBars = function(self)
	self.curFrame._var.showBars = this:GetChecked()
	if this:GetChecked() then
		self.curFrame._var.spacingY = -12
		self.curFrame._var.timerPositionX = -3
		self.curFrame._var.timerPositionY = 0
		self.curFrame._var.barOffset = 0
		self.curFrame._var.timerJustify = "RIGHT"
		ScrollingDropDown:SetSelected(SBFOTimerJustifyDropDown, "RIGHT")
	else
		self.curFrame._var.spacingY = 0
		self.curFrame._var.timerPositionX = 0
		self.curFrame._var.timerPositionY = 7
		self.curFrame._var.timerJustify = "CENTER"
		ScrollingDropDown:SetSelected(SBFOTimerJustifyDropDown, "CENTER")
	end
	SBF:SetupFrame(self.curFrame)
  SBFOptions:SetupFrame(self.curFrame)
	SBFOptions:SelectFrame()
end

SBFOptions.LeftBars = function(self)
	self.curFrame._var.leftBars = this:GetChecked()
	SBF:SetupFrame(self.curFrame)
end

SBFOptions.CountInName = function(self)
	self.curFrame._var.countInName = this:GetChecked()
  SBF:SetupFrameSlots(self.curFrame)
end

SBFOptions.ShortNames = function(self)
	self.curFrame._var.shortNames = this:GetChecked()
  SBF:SetupFrameSlots(self.curFrame)
end

SBFOptions.DebuffBarColour = function(self)
	self.curFrame._var.debuffBarColour = this:GetChecked()
  SBF:SetupFrameSlots(self.curFrame)
end

SBFOptions.BarTextureDropDown_Initialise = function(self)
  SBFOBarTextureDropDown:Init(self.DropDownCallback, self.strings.BARTEXTURE)
	local info = SBF:GetTable()
	local bars = SML:List("statusbar")
  for k,v in pairs(bars) do
		info.text = v
		info.value = v
		info.callback = SBFOptions.BarTextureDropDown_OnClick
		ScrollingDropDown:AddItem(SBFOBarTextureDropDown, info)
	end
	SBF:PutTable(info)
end

SBFOptions.BarTextureDropDown_OnClick = function(item)
	self.curFrame._var.barTexture = item.value
	SBF:SetupFrame(self.curFrame)
  SBFOBarTextureDropDown:SetFormattedText(item.text)
end

SBFOptions.BarNameJustifyDropDown_Initialise = function(self)
	SBFOBarNameJustifyDropDown:Init(self.DropDownCallback, self.strings.BARNAMEJUSTIFY)
	SBFOBarNameJustifyDropDown.dropDownOptions = SBF:GetTable()
  SBFOBarNameJustifyDropDown.dropDownOptions.noSort = true

	local info = SBF:GetTable()
	for i,v in ipairs(SBFOptions.justify) do
		info.text	= v
		info.value	= v
		info.callback	= SBFOptions.BarNameJustifyDropDown_OnClick
		ScrollingDropDown:AddItem(SBFOBarNameJustifyDropDown, info)
	end
	SBF:PutTable(info)
end

SBFOptions.BarNameJustifyDropDown_OnClick = function(item)
	ScrollingDropDown:SetSelected(SBFOBarNameJustifyDropDown, item.value)
	SBFOptions.curFrame._var.barNameJustify = item.value
	SBF:SetupFrame(self.curFrame)
  SBFOBarNameJustifyDropDown:SetFormattedText(item.text)
end

SBFOptions.BarTimerPositionDropDown_Initialise = function(self)
	SBFOBarTimerPositionDropDown:Init(self.DropDownCallback, self.strings.BARTIMERPOSITION)
	SBFOBarTimerPositionDropDown.dropDownOptions = SBF:GetTable()
  SBFOBarTimerPositionDropDown.dropDownOptions.noSort = true

	local info = SBF:GetTable()
	for i,v in ipairs(SBFOptions.justify) do
		info.text	= v
		info.value	= v
		info.callback	= SBFOptions.BarTimerPositionDropDown_OnClick
		ScrollingDropDown:AddItem(SBFOBarTimerPositionDropDown, info)
	end
	SBF:PutTable(info)
end

SBFOptions.BarTimerPositionDropDown_OnClick = function(item)
	ScrollingDropDown:SetSelected(SBFOBarTimerPositionDropDown, item.value)
	SBFOptions.curFrame._var.barTimerPosition = item.value
	SBF:SetupFrame(self.curFrame)
  SBFOBarTimerPositionDropDown:SetFormattedText(item.text)
end

SBFOptions.BarNameFontDropDown_Initialise = function(self)
SBFOBarNameFontDropDown:Init(self.DropDownCallback, self.strings.BARNAMEFONT)
local info = SBF:GetTable()
	local fonts = SML:List("font")
	for k,v in pairs(fonts) do
		info.text = v
		info.value = v
		info.callback = SBFOptions.BarNameFontDropDown_OnClick
		ScrollingDropDown:AddItem(SBFOBarNameFontDropDown, info)
	end
	SBF:PutTable(info)
end

SBFOptions.BarNameFontDropDown_OnClick = function(item)
	ScrollingDropDown:SetSelected(SBFOBarNameFontDropDown, item.value)
	SBFOptions.curFrame._var.barNameFont = item.value
	SBF:SetupFrame(self.curFrame)
  SBFOBarNameFontDropDown:SetFormattedText(item.text)
end

--
-- Expiry
--

SBFOptions.TextWarning = function(self)
	self.curFrame._var.textWarning = this:GetChecked()
	self:SelectFrame()
end

SBFOptions.TextNotice = function(self)
	self.curFrame._var.textNotice = this:GetChecked()
	self:SelectFrame()
end

SBFOptions.SoundWarning = function(self)
	self.curFrame._var.soundWarning = this:GetChecked()
	self:SelectFrame()
end

SBFOptions.SCTWarn = function(self)
	self.curFrame._var.sctWarn = this:GetChecked()
	self:SelectFrame()
end

SBFOptions.FlashBuff = function(self)
	self.curFrame._var.flashBuff = this:GetChecked()
end

SBFOptions.SCTCrit = function(self)
	if SCT and (SCT:Get("SHOWFADE", SCT.FRAMES_TABLE) == SCT.MSG) then
    ChatFrame1:AddMessage(self.strings.SCTCRITTTM1)
    ChatFrame1:AddMessage(self.strings.SCTCRITTTM2)
    self.curFrame._var.sctCrit = false
    this:SetChecked(false)
  else
    self.curFrame._var.sctCrit = this:GetChecked()
  end
end

SBFOptions.FastBar = function(self)
	self.curFrame._var.fastBar = this:GetChecked()
end

SBFOptions.expireTimes = {5,10,15,20,30,45,60,90,120}
SBFOptions.ExpireTimeDropDown_Initialise = function(self)
	SBFOExpireTimeDropDown:Init(self.DropDownCallback, self.strings.EXPIRETIME)
	SBFOExpireTimeDropDown.dropDownOptions = SBF:GetTable()
  SBFOExpireTimeDropDown.dropDownOptions.noSort = true
  SBFOExpireTimeDropDown.dropDownOptions.tooltip = self.strings.WARNTIMETT

	local info = SBF:GetTable()
	for v,i in pairs(SBFOptions.expireTimes) do
		info.text = i.." sec"
		info.value = i
		info.callback = SBFOptions.ExpireTimeDropDown_OnClick
		ScrollingDropDown:AddItem(SBFOExpireTimeDropDown, info)
	end
	SBF:PutTable(info)
end

SBFOptions.ExpireTimeDropDown_OnClick = function(item)
	ScrollingDropDown:SetSelected(SBFOExpireTimeDropDown, item.value)
	SBFOptions.curFrame._var.expireTime = item.value
  SBFOExpireTimeDropDown:SetFormattedText(item.text)
end

SBFOptions.chatFrames = {"ChatFrame1", "ChatFrame2", "ChatFrame3", "ChatFrame4", "ChatFrame5", "ChatFrame6", "ChatFrame7"}
SBFOptions.ExpireFrameDropDown_Initialise = function(self)
	SBFOExpireFrameDropDown:Init(self.DropDownCallback, self.strings.EXPIREFRAME)
	local info = SBF:GetTable()
	for v,i in pairs(SBFOptions.chatFrames) do
		info.text = i
		info.value = i
		info.callback = SBFOptions.ExpireFrameDropDown_OnClick
		ScrollingDropDown:AddItem(SBFOExpireFrameDropDown, info)
	end
	SBF:PutTable(info)
end

SBFOptions.ExpireFrameDropDown_OnClick = function(item)
	ScrollingDropDown:SetSelected(SBFOExpireFrameDropDown, item.value)
	SBFOptions.curFrame._var.expireFrame = item.value
  getglobal(item.value):AddMessage(string.format(SBFOptions.strings.EXPIREFRAMETEST, SBFOptions.curFrame.id))
  SBFOExpireFrameDropDown:SetFormattedText(item.text)
end

SBFOptions.SoundWarningDropDown_Initialise = function(self)
	SBFOSoundWarningDropDown:Init(self.DropDownCallback, self.strings.WARNSOUND)
	SBFOSoundWarningDropDown.dropDownOptions = SBF:GetTable()
  SBFOSoundWarningDropDown.dropDownOptions.noSort = true

	local info = SBF:GetTable()
	local sounds = SML:List("sound")
	for k,v in pairs(sounds) do
		info.text = v
		info.value = v
		info.callback = SBFOptions.SoundWarningDropDown_OnClick
		ScrollingDropDown:AddItem(SBFOSoundWarningDropDown, info)
	end
	SBF:PutTable(info)
end

SBFOptions.SoundWarningDropDown_OnClick = function(item)
	ScrollingDropDown:SetSelected(SBFOSoundWarningDropDown, item.value)
	SBFOptions.curFrame._var.sound = item.value
	PlaySoundFile(SML:Fetch("sound", item.value))
  SBFOSoundWarningDropDown:SetFormattedText(item.text)
end

SBFOptions.minTimes = {1000,0,1,2,3,5,10,20,30}
SBFOptions.MinTimeDropDown_Initialise = function(self)
	SBFOMinTimeDropDown:Init(self.DropDownCallback, self.strings.MINTIME)
	SBFOMinTimeDropDown.dropDownOptions = SBF:GetTable()
  SBFOMinTimeDropDown.dropDownOptions.noSort = true
  SBFOMinTimeDropDown.dropDownOptions.tooltip = self.strings.MINTIMETT
  local info
	for i,t in pairs(SBFOptions.minTimes) do
		local info = SBF:GetTable()
		if (t == 1000) then
			info.text = SBFOptions.strings.USERWARN
		elseif (t == 0) then
			info.text = SBFOptions.strings.ALLWARN
		else
			info.text = t.." min"
		end
		info.value = t * 60
		info.callback = SBFOptions.MinTimeDropDown_OnClick
		ScrollingDropDown:AddItem(SBFOMinTimeDropDown, info)
		SBF:PutTable(info)
	end
end

SBFOptions.MinTimeDropDown_OnClick = function(item)
	ScrollingDropDown:SetSelected(SBFOMinTimeDropDown, item.value, ScrollingDropDown.VALUE)
	SBFOptions.curFrame._var.warnTime = item.value
  SBFOMinTimeDropDown:SetFormattedText(item.text)
end

--
-- Timers
--
SBFOptions.DebuffTimer = function(self)
	self.curFrame._var.debuffTimerColour = this:GetChecked()
  SBF:SetupFrameSlots(self.curFrame)
end

SBFOptions.TimerOutline = function(self)
	self.curFrame._var.timerOutline = this:GetChecked()
	SBF:SetupFrame(self.curFrame)
end

SBFOptions.TimerFontDropDown_Initialise = function(self)
	SBFOTimerFontDropDown:Init(self.DropDownCallback, self.strings.TIMERFONT)
	local info = SBF:GetTable()
	local fonts = SML:List("font")
	for k,v in pairs(fonts) do
		info.text = v
		info.value = v
		info.callback = SBFOptions.TimerFontDropDown_OnClick
		ScrollingDropDown:AddItem(SBFOTimerFontDropDown, info)
	end
	SBF:PutTable(info)
end

SBFOptions.TimerFontDropDown_OnClick = function(item)
	ScrollingDropDown:SetSelected(SBFOTimerFontDropDown, item.value)
	SBFOptions.curFrame._var.timerFont = item.value
	SBF:SetupFrame(self.curFrame)
  SBFOTimerFontDropDown:SetFormattedText(item.text)
end

SBFOptions.TimerDropDown_Initialise = function(self)
	SBFOTimerFormatDropDown:Init(self.DropDownCallback, self.strings.TEXT_FORMAT)
	local info = SBF:GetTable()
	for i,v in ipairs(SBFOptions.strings.timerFormats) do
		info.text	= v
		info.value	= i
		info.callback	= SBFOptions.TimerDropDown_OnClick
		ScrollingDropDown:AddItem(SBFOTimerFormatDropDown, info)
	end
	SBF:PutTable(info)
end

SBFOptions.TimerDropDown_OnClick = function(item)
	ScrollingDropDown:SetSelected(SBFOTimerFormatDropDown, item.value)
	SBFOptions.curFrame._var.timerFormat = item.value
  SBF:SetupFrameSlots(self.curFrame)
  SBFOTimerFormatDropDown:SetFormattedText(item.text)
end

SBFOptions.justify = {"LEFT", "CENTER", "RIGHT"}
SBFOptions.TimerJustifyDropDown_Initialise = function(self)
	SBFOTimerJustifyDropDown:Init(self.DropDownCallback, self.strings.TEXT_JUSTIFY)
	SBFOTimerJustifyDropDown.dropDownOptions = SBF:GetTable()
  SBFOTimerJustifyDropDown.dropDownOptions.noSort = true

	local info = SBF:GetTable()
	for i,v in ipairs(SBFOptions.justify) do
		info.text	= v
		info.value	= v
		info.callback	= SBFOptions.TimerJustifyDropDown_OnClick
		ScrollingDropDown:AddItem(SBFOTimerJustifyDropDown, info)
	end
	SBF:PutTable(info)
end

SBFOptions.TimerJustifyDropDown_OnClick = function(item)
	ScrollingDropDown:SetSelected(SBFOTimerJustifyDropDown, item.value)
	SBFOptions.curFrame._var.timerJustify = item.value
	SBF:SetupFrame(self.curFrame)
  SBFOTimerJustifyDropDown:SetFormattedText(item.text)
end

--
-- Filters
--

SBFOptions.EnableFilters = function(self)
	_var.enableFilters = this:GetChecked()
	if _var.enableFilters then
		SBFOptions:EnableCheckbox(SBFOEnableRFiltersCheckButton, _var.enableRFilters)
	else
		_var.enableRFilters = nil
		SBFOptions:DisableCheckbox(SBFOEnableRFiltersCheckButton)
	end
end

SBFOptions.EnableRFilters = function(self)
	_var.enableRFilters = this:GetChecked()
end

SBFOptions.AddFilter = function(self)
	if SBFOptions.editFilter then
		_var.filters[SBFOptions.editFilter] = SBFOBuffFilterEdit.edit:GetText()
		SBFOAddFilterButton:SetFormattedText(SBFOptions.strings.ADDFILTER)
		SBFOptions.editFilter = nil
	else
		local str = SBFOBuffFilterEdit.edit:GetText()
		if (string.len(str) > 0) then
			table.insert(_var.filters, str)
		end
	end
	SBFOptions:UpdateFilterList()
	SBFOBuffFilterEdit.edit:SetText("")
	SBFOBuffFilterEdit.edit:ClearFocus()
end

SBFOptions.EditFilter = function(self)
	if SBFOptions.currentFilter then
		SBFOptions.editFilter = SBFOptions.currentFilter
		SBFOBuffFilterEdit.edit:SetText(_var.filters[SBFOptions.currentFilter])
		SBFOAddFilterButton:SetFormattedText(SBFOptions.strings.EDITFILTER)
	end
	SBFOptions:UpdateFilterList()
end

SBFOptions.RemoveFilter = function(self)
	if SBFOptions.currentFilter then
		table.remove(_var.filters, SBFOptions.currentFilter)
		SBFOptions.currentFilter = nil
	end
	SBFOptions:EditDone()
	SBFOptions:UpdateFilterList()
end

SBFOptions.FilterUp = function(self)
	local f = table.remove(_var.filters, SBFOptions.currentFilter)
	SBFOptions.currentFilter  = SBFOptions.currentFilter - 1
	table.insert(_var.filters, SBFOptions.currentFilter, f)
	SBFOptions:EditDone()
	SBFOptions:UpdateFilterList()
end

SBFOptions.FilterDown = function(self)
	local f = table.remove(_var.filters, SBFOptions.currentFilter)
	SBFOptions.currentFilter  = SBFOptions.currentFilter + 1
	table.insert(_var.filters, SBFOptions.currentFilter, f)
	SBFOptions:EditDone()
	SBFOptions:UpdateFilterList()
end

SBFOptions.SelectFilter = function(self)
	if _var.filters[this.index] then
		SBFOptions.currentFilter = this.index
		SBFOptions:EditDone()
		SBFOptions:UpdateFilterList()
	end
end

SBFOptions.EditDone = function(self)
	SBFOAddFilterButton:SetFormattedText(SBFOptions.strings.ADDFILTER)
	self.editFilter = nil
	SBFOBuffFilterEdit.edit:SetText("")
	SBFOBuffFilterEdit.edit:ClearFocus()
end

SBFOptions.UpdateFilterList = function(self)
	local offset = FauxScrollFrame_GetOffset(SBFOFilterListScrollFrame)
	local listIndex,str
	if not self then
		self = SBFOptions
	end
	
	for i=1,10 do
		local listIndex = offset + i
		button = SBFOFilterButtons[i]

		if _var.filters[listIndex] then
			button.label:SetFormattedText(_var.filters[listIndex])
			button.index = listIndex
		else	
			button.label:SetFormattedText("")
		end

		-- Highlight the selected filter
		if SBFOptions.currentFilter and (SBFOptions.currentFilter == listIndex) then
			button:LockHighlight()
			button.label:SetTextColor(1, 1, 1)
		else
			button:UnlockHighlight()
			button.label:SetTextColor(1, 0.82, 0)
		end
	end
	FauxScrollFrame_Update(SBFOFilterListScrollFrame, #_var.filters, 10, 14)
	
	if SBFOptions.currentFilter then
		SBFOFilterEditButton:Enable()
		SBFOFilterRemoveButton:Enable()
		if (#_var.filters > 1) and (SBFOptions.currentFilter > 1) then
			SBFOFilterUpButton:Enable()
		else
			SBFOFilterUpButton:Disable()
		end
		if (#_var.filters > 1) and (SBFOptions.currentFilter < #_var.filters) then
			SBFOFilterDownButton:Enable()
		else
			SBFOFilterDownButton:Disable()
		end
	else
		SBFOFilterEditButton:Disable()
		SBFOFilterRemoveButton:Disable()
		SBFOFilterUpButton:Disable()
		SBFOFilterDownButton:Disable()
	end
end

SBFOptions.RemoveFrameFilters = function(self, frame)
	local found
	while true do
		found = false
		for i,f in pairs(_var.filters) do
			if (tonumber(string.match(f, "(%d+):")) == frame) then
				table.remove(_var.filters, i)
				found = true
				break
			end
		end
		if not found then
			SBFOptions:UpdateFilterList()
			return
		end
	end
end

--
-- Spells
--
SBFOptions.Exclude = function(self)
	if this:GetChecked() then
		SBF:AddExclude(self.cache[self.currentSpellIndex])
	else
		SBF:RemoveExclude(self.cache[self.currentSpellIndex])
	end
	self:UpdateSpellList()
end

SBFOptions.AlwaysWarn = function(self)
	if this:GetChecked() then
		SBF:AddAlwaysWarn(self.cache[self.currentSpellIndex])
	else
		SBF:RemoveAlwaysWarn(self.cache[self.currentSpellIndex])
	end
	self:UpdateSpellList()
end

SBFOptions.ClearSpellCache = function(self)
  SBF:PutTable(SBF.db.account.spells)
  SBF.db.account.spells = SBF:GetTable()
  self:FillSpellList()
end

SBFOptions.FillSpellList = function(self, force)
  self.cacheSize = #SBF.db.account.spells
  SBF:PutTable(self.cache)
  self.cache = SBF:GetTable()
  local pattern = strlower(SBFOSpellFilterEdit.edit:GetText())
  for name,data in pairs(SBF.db.account.spells) do 
    if (data.buffType >= 20) and SBFOShowDebuffsCheckButton:GetChecked() then
      if not pattern or string.find(strlower(name), pattern) then
        table.insert(self.cache, name)
      end
    elseif (data.buffType < 20) and SBFOShowBuffsCheckButton:GetChecked() then
      if not pattern or string.find(strlower(name), pattern) then
        table.insert(self.cache, name)
      end
    end
  end
  table.sort(self.cache)
  self.currentSpellIndex = nil
  self:UpdateSpellList()
end

SBFOptions.UpdateSpellList = function(self)
	if not self then
		self = SBFOptions
	end
	
	local listIndex, spell, frame, exclude, alwaysWarn, filterFrame, filter, rFilterFrame, rFilter
	local offset = FauxScrollFrame_GetOffset(SBFOSpellListScrollFrame)
	if not self.fauxBuff then
		self.fauxBuff = {}
	end
	
	for i=1,10 do
		listIndex = offset + i
		button = SBFOSpellListButtons[i]
		spell = self.cache[listIndex]

		if spell then
			button.label:SetFormattedText(spell)
			button.index = listIndex
			
			if _var.enableFilters then
				self.fauxBuff.name = spell
				self.fauxBuff.duration, self.fauxBuff.untilCancelled, self.fauxBuff.buffType = SBF:GetSpell(spell)
				if self.fauxBuff.untilCancelled then
					self.fauxBuff.timeLeft = 0
				else
					self.fauxBuff.timeLeft = self.fauxBuff.duration
				end
				self.fauxBuff.expFloor = self.fauxBuff.timeLeft
				self.fauxBuff.filterName = nil
				filterFrame, filter = SBF:DoFilters(self.fauxBuff)
        if _var.enableRFilters and not self.fauxBuff.untilCancelled then
 					self.fauxBuff.timeLeft = 1
					self.fauxBuff.expFloor = 1
          rFilterFrame, rFilter = SBF:DoFilters(self.fauxBuff)
        end
			end

			frame = SBF:ShowIn(spell)
			exclude = SBF:IsExcluded(spell)
			alwaysWarn = SBF:IsAlwaysWarn(spell)
			if exclude or alwaysWarn or frame then
				button.label:SetTextColor(GREEN_FONT_COLOR.r,GREEN_FONT_COLOR.g,GREEN_FONT_COLOR.b)
			elseif filterFrame or rFilterFrame then
				button.label:SetTextColor(NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b)
			else
				button.label:SetTextColor(GRAY_FONT_COLOR.r,GRAY_FONT_COLOR.g,GRAY_FONT_COLOR.b)
			end
		else	
			button.label:SetFormattedText("")
			button.listIndex = nil
		end

		-- Highlight selected 
		if self.currentSpellIndex and (self.currentSpellIndex == listIndex) then
			self.currentSpell = spell
      button:LockHighlight()
			button.label:SetTextColor(1, 1, 1)

      SBFOSpellDurationDropDown:Enable()
      ScrollingDropDown:SetSelected(SBFOSpellDurationDropDown, ceil(SBF.db.account.spells[spell].duration), ScrollingDropDown.VALUE)

			SBFOShowInFrameDropDown:Enable()
			if frame then
        ScrollingDropDown:SetSelected(SBFOShowInFrameDropDown, frame, ScrollingDropDown.VALUE)
			else
        ScrollingDropDown:SetSelected(SBFOShowInFrameDropDown, self.strings.DEFAULTFRAME)
			end

			self:EnableCheckbox(SBFOAlwaysWarnCheckButton, alwaysWarn)
			self:EnableCheckbox(SBFOSpellExcludeCheckButton, exclude)

      if filterFrame and filter then
				SBFOSpellText1:SetFormattedText(self.strings.SHOWFILTER, filterFrame, filter)
			else
				SBFOSpellText1:SetFormattedText("")
			end
			if rFilterFrame and rFilter  and (rFilter ~= filter) then
				SBFOSpellText2:SetFormattedText(self.strings.SHOWFILTER, rFilterFrame, rFilter)
			else
				SBFOSpellText2:SetFormattedText("")
			end
			if frame and (filterFrame or rFilterFrame) then
				SBFOSpellText3:SetFormattedText(self.strings.FILTERBLOCKED, frame)
			else
				SBFOSpellText3:SetFormattedText("")
			end
		else
			button:UnlockHighlight()
		end
		if not self.currentSpellIndex then
			self:DisableCheckbox(SBFOAlwaysWarnCheckButton)
			self:DisableCheckbox(SBFOSpellExcludeCheckButton)
			SBFOShowInFrameDropDown:Disable()
      SBFOSpellDurationDropDown:Disable()
		end
	end
	FauxScrollFrame_Update(SBFOSpellListScrollFrame, #self.cache, 10, 14)
end

SBFOptions.SelectSpell = function(self, index)
	self.currentSpellIndex = index
	self:UpdateSpellList()
end

SBFOptions.ShowInFrameDropDown_Initialise = function(self)
  SBFOShowInFrameDropDown:Init(self.DropDownCallback, self.strings.SHOWING)
	local info
	info = SBF:GetTable()
	info.callback = SBFOptions.ShowInFrameDropDown_OnClick
	for i,frame in pairs(SBF.frames) do
		info.text = SBF.strings.SHOWATBUFFRAME..i
		info.value = i
		ScrollingDropDown:AddItem(SBFOShowInFrameDropDown, info)
	end
  info.text = SBF.strings.DEFAULTFRAME
  info.value = -1
  ScrollingDropDown:AddItem(SBFOShowInFrameDropDown, info)
	SBF:PutTable(info)
end

SBFOptions.ShowInFrameDropDown_OnClick = function(item)
	if (item.value > 0) then
		_var.buffFrameList[SBFOptions.cache[SBFOptions.currentSpellIndex]] = item.value
	else
		_var.buffFrameList[SBFOptions.cache[SBFOptions.currentSpellIndex]] = nil
	end
	SBFOptions:UpdateSpellList()
  SBFOShowInFrameDropDown:SetFormattedText(item.text)
end

SBFOptions.durations = {1,2,3,4,5,6,7,8,9,10,15,20,25,30,45,60,120,180,300,600,1800,3600,7200}
SBFOptions.SpellDurationDropDown_Initialise = function(self)
  SBFOSpellDurationDropDown:Init(self.DropDownCallback, self.strings.DURATION)
	SBFOSpellDurationDropDown.dropDownOptions = SBF:GetTable()
  SBFOSpellDurationDropDown.dropDownOptions.noSort = true

	local info
	info = SBF:GetTable()
	info.callback = SBFOptions.SpellDurationDropDown_OnClick
	for i,duration in ipairs(SBFOptions.durations) do
    if (duration < 60) then
      info.text = format("%d %s", duration, SECONDS)
    elseif (duration < 3600) then
      info.text = format("%d %s", duration/60, MINUTES)
    else
      info.text = format("%d %s", duration/3600, HOURS)
    end
		info.value = duration
		ScrollingDropDown:AddItem(SBFOSpellDurationDropDown, info)
	end
  info.text = self.strings.AURA
  info.value = 0
  ScrollingDropDown:AddItem(SBFOSpellDurationDropDown, info)
	SBF:PutTable(info)
end

SBFOptions.SpellDurationDropDown_OnClick = function(item)
  SBF.db.account.spells[SBFOptions.currentSpell].duration = item.value
	SBFOptions:UpdateSpellList()
end

--
-- Global
--

SBFOptions.CopyProfileDropDown_Initialise = function(self)
	SBFOCopyProfileDropDown:Init(self.DropDownCallback, self.strings.COPYPROFILE)
	local info = SBF:GetTable()
	info.callback	= SBFOptions.CopyProfileDropDown_OnClick
	for k,v in pairs(SBF['acedb-profile-copylist']) do
		if (v ~= SBF:GetProfile()) then
			info.text	= string.match(v, ".-:(.+)")
			info.value = k
			ScrollingDropDown:AddItem(SBFOCopyProfileDropDown, info)
		end
	end
	SBF:PutTable(info)
end

SBFOptions.CopyProfileDropDown_OnClick = function(item)
	SBF:CopyProfileFrom(item.value)
  SBF:DoSavedVars()
  SBF:CreateFrames()
  SBF:SetupFrames()
  SBFOptions:SetupFrames()
	SBFOptions:SelectFrame(1)
end

SBFOptions.cyCircledChanged = function()
  cyCircled_SatrinaBuffFrames.db.profile.adjust = this:GetValue()
  SBFOcyCircledSliderText:SetFormattedText(SBFOptions.strings.CYCIRCLEDADJUST, cyCircled_SatrinaBuffFrames.db.profile.adjust)
  cyCircled_SatrinaBuffFrames:ApplyCustom()
end

--
-- Frames
--

SBFOptions.RemoveFrame = function(self)
	if (self.curFrame.id < 3) then
		ChatFrame1:AddMessage(self.strings.DELETEERROR)
	else
		local s,f
		for buff,frame in pairs(_var.buffFrameList) do
			if (frame == self.curFrame.id) then
				_var.buffFrameList[buff] = nil
			end
		end
		self:RemoveFrameFilters(self.curFrame.id)

		s = table.remove(_var.frames, self.curFrame.id)
		SBF:PutTable(s)
		SBF:CreateFrames()
    SBF:SetupFrames()
    SBF:FrameVisibility()
    SBFOptions:SetupFrames()
    SBFOptions:InitialiseGlobalDropDowns()
		SBFOptions:SelectFrame(1)
	end
end

SBFOptions.NewFrame = function(self)
	local frame,last
	frame = #_var.frames + 1
	SBF:ValidateFrameVars(#_var.frames + 1)
	SBF:CreateFrames()
  SBF:SetupFrames()
  SBFOptions:SetupFrames()
  if IsAddOnLoaded("cyCircled") then
    local frameName = SBF.frames[frame]:GetName()
    cyCircled_SatrinaBuffFrames.frameList[frameName] = true
    cyCircled_SatrinaBuffFrames.db.profile[frameName] = true
    cyCircled_SatrinaBuffFrames:SetupElements()
    cyCircled_SatrinaBuffFrames:ApplySkin()
    cyCircled_SatrinaBuffFrames:ApplyColors()
    cyCircled_SatrinaBuffFrames:ApplyCustom()
  end
  SBFOptions:InitialiseGlobalDropDowns()
	SBFOptions:SelectFrame(frame)
end

SBFOptions.BuffFrameDropDown_Initialise = function(self)
  ScrollingDropDown:ClearItems(SBFOBuffFrameDropDown)
  SBFOBuffFrameDropDown:Init(self.DropDownCallback, self.strings.BUFFFRAME)
  local info = SBF:GetTable()
	info.callback = SBFOptions.BuffFrameDropDown_OnClick
	for i,frame in pairs(SBF.frames) do
		info.text = string.format(SBF.strings.FRAMETITLE, i)
		info.value = i
		ScrollingDropDown:AddItem(SBFOBuffFrameDropDown, info)
	end
	SBF:PutTable(info)
end

SBFOptions.BuffFrameDropDown_OnClick = function(item)
	CloseDropDownMenus(1)
	SBFOptions:SelectFrame(item.value)
end

SBFOptions.CopyFromDropDown_Initialise = function(self)
  ScrollingDropDown:ClearItems(SBFOCopyFromDropDown)
	local info = SBF:GetTable()
	for i=1,#SBF.frames do
		if (i ~= SBFOptions.curFrame.id) then
			info.text = string.format(SBF.strings.FRAMETITLE, i)
			info.value = i
			info.callback = SBFOptions.CopyFromDropDown_OnClick
			ScrollingDropDown:AddItem(SBFOCopyFromDropDown, info)
		end
	end
	SBF:PutTable(info)
end

SBFOptions.CopyFromDropDown_OnClick = function(item)
	local old = _var.frames[SBFOptions.curFrame.id]
  local new = SBF:CopyTable(_var.frames[item.value])
	for k,v in pairs(old.point) do
		new.point[k] = v
	end
	SBF:PutTable(old)
	_var.frames[SBFOptions.curFrame.id] = new
  SBFOptions.curFrame._var = new
  ScrollingDropDown:SetSelected(SBFOCopyFromDropDown, nil)
	SBF:SetupFrame(SBFOptions.curFrame)
  SBFOptions:SetupFrame(SBFOptions.curFrame)
  if IsAddOnLoaded("cyCircled") then
    local toFrame = SBFOptions.curFrame:GetName()
    local fromFrame = SBF.frames[item.value]:GetName()
    cyCircled_SatrinaBuffFrames.db.profile[toFrame] = cyCircled_SatrinaBuffFrames.db.profile[fromFrame]
    cyCircled_SatrinaBuffFrames:ApplySkin()
    cyCircled_SatrinaBuffFrames:ApplyColors()
    cyCircled_SatrinaBuffFrames:ApplyCustom()
  end
	SBFOptions:SelectFrame(SBFOptions.curFrame)
end


--
-- Support
--

SBFOptions.ColourPicker = function(self, colour)
	self.currentColour = self.curFrame._var[colour]
	self.currentControl = this
  if self.currentColour.a then
    ColourFrame:Open(SBFOptions.ColourCallback, self.currentColour.r, self.currentColour.g, self.currentColour.b, self.currentColour.a)
  else
    ColourFrame:Open(SBFOptions.ColourCallback, self.currentColour.r, self.currentColour.g, self.currentColour.b)
  end
end

SBFOptions.ColourCallback = function(r,g,b,a)
	SBFOptions.currentColour.r = r
	SBFOptions.currentColour.g = g
	SBFOptions.currentColour.b = b
  if a then
    SBFOptions.currentColour.a = a
  end
	SBFOptions.currentControl.texture:SetVertexColor(r, g, b)
	SBF:SetupFrame(SBFOptions.curFrame)
  SBF:SetupFrameSlots(SBFOptions.curFrame)
end

SBFOptions.DisableColourButton = function(self, button)
	button:Disable()
	button.label:SetTextColor(0.5, 0.5, 0.5)
end

SBFOptions.EnableColourButton = function(self, button)
	button:Enable()
	button.label:SetTextColor(NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b)
end

SBFOptions.CopyTable = function(self, srcFrame, dstFrame)
	for k,v in pairs(srcFrame) do
		if (type(v) == "table") then
			dstFrame[k] = {}
			SBFOptions:CopyTable(v, dstFrame[k])
		else
			dstFrame[k] = v
		end
	end
end

SBFOptions.EnableCheckbox = function(self, checkbox, checked)
	OptionsFrame_EnableCheckBox(checkbox, true, checked)
end

SBFOptions.DisableCheckbox = function(self, checkbox)
	checkbox:SetChecked(nil)
	OptionsFrame_DisableCheckBox(checkbox)
end

SBFOptions.GetIcon = function(self, first)
	if first then
		self.iconCount = 1
	else
		self.iconCount = self.iconCount + 1
		if (self.iconCount > #self.icons) then
			self.iconCount = 1
		end
	end
	return self.icons[self.iconCount]
end

SBFOptions.icons = {
	"Interface\\Icons\\INV_Misc_QuestionMark",
	"Interface\\Icons\\Spell_Shadow_RagingScream",
	"Interface\\Icons\\Spell_Nature_Regeneration",
	"Interface\\Icons\\Spell_Holy_WordFortitude",
	"Interface\\Icons\\Spell_Holy_MagicalSentry",
	"Interface\\Icons\\Ability_Warrior_BattleShout",
	"Interface\\Icons\\Ability_DualWield",
	"Interface\\Icons\\Ability_Druid_Maul",
	"Interface\\Icons\\Spell_Frost_FrostArmor02",
	"Interface\\Icons\\Ability_Hunter_Misdirection",
	"Interface\\Icons\\Ability_Mount_Gryphon_01",
	"Interface\\Icons\\Ability_Rogue_SliceDice",
	"Interface\\Icons\\Spell_Holy_FlashHeal",
	"Interface\\Icons\\Spell_Holy_GreaterBlessingofKings",
	"Interface\\Icons\\Spell_Nature_LightningShield",
	"Interface\\Icons\\Spell_Shadow_ManaBurn",
	"Interface\\Icons\\Spell_Shadow_Curse",
	"Interface\\Icons\\Spell_Ice_MagicDamage",
	"Interface\\Icons\\Spell_Holy_Vindication",
	"Interface\\Icons\\Spell_Holy_Renew",
	"Interface\\Icons\\Spell_Fire_Immolation",
	"Interface\\Icons\\Spell_Nature_HealingTouch",
	"Interface\\Icons\\Ability_Druid_TravelForm",
	"Interface\\Icons\\Spell_Fire_Incinerate",
	"Interface\\Icons\\Ability_Hunter_AimedShot",
	"Interface\\Icons\\Spell_Frost_Frostbolt",
	"Interface\\Icons\\Ability_Mage_Invisibility",
	"Interface\\Icons\\Ability_Mount_Kodo_01",
	"Interface\\Icons\\Spell_Arcane_PortalStormWind",
	"Interface\\Icons\\Ability_Warrior_Intervene",
	"Interface\\Icons\\Spell_Nature_RockBiter",
	"Interface\\Icons\\Spell_Arcane_TeleportSilvermoon",
}

SBFOptions.GetDebuffType = function(self, j)
	local i = mod(j,5)
	if i == 0  then 
		return "Curse"
	elseif  i == 1 then
		return "Magic"
	elseif  i == 2 then
		return "Poison"
	elseif  i == 3 then
		return "Disease"
	elseif  i == 4 then
		return "none"
	end
end

--
-- OnUpdate
--

SBFOptions.UpdateOptions = function(self)
	self.dirty = nil

	if (self.curFrame._var.iconScale ~= SBFOIconScaleSlider:GetValue()) then
		self.curFrame._var.iconScale = SBFOIconScaleSlider:GetValue()
		self.dirty = 1		
	end

	if (self.curFrame._var.timerFontSize ~= SBFOTimerFontSizeSlider:GetValue()) then
		self.curFrame._var.timerFontSize = SBFOTimerFontSizeSlider:GetValue()
		self.dirty = 1		
	end

	if (self.curFrame._var.timerPositionY ~= SBFOTimerYPositionSlider:GetValue()) then
		self.curFrame._var.timerPositionY = SBFOTimerYPositionSlider:GetValue()
		self.dirty = 1		
	end

	if (self.curFrame._var.timerPositionX ~= SBFOTimerXPositionSlider:GetValue()) then
		self.curFrame._var.timerPositionX = SBFOTimerXPositionSlider:GetValue()
		self.dirty = 1		
	end

	if (self.curFrame._var.opacity ~= SBFOOpacitySlider:GetValue()) then
		self.curFrame._var.opacity = SBFOOpacitySlider:GetValue()
		self.dirty = 1		
		end

	if (self.curFrame._var.spacingX ~= SBFOSpacingXSlider:GetValue()) then
		self.curFrame._var.spacingX = SBFOSpacingXSlider:GetValue()
		self.dirty = 1		
	end

	if (self.curFrame._var.spacingY ~= SBFOSpacingYSlider:GetValue()) then
		self.curFrame._var.spacingY = SBFOSpacingYSlider:GetValue()
		self.dirty = 1		
	end

	if (self.curFrame._var.rowCount ~= SBFOCountSlider:GetValue()) then
		self.curFrame._var.rowCount = SBFOCountSlider:GetValue()
		self.dirty = 1		
	end

	if (self.curFrame._var.barOffset ~= SBFOBarOffsetSlider:GetValue()) then
		self.curFrame._var.barOffset = SBFOBarOffsetSlider:GetValue()
		self.dirty = 1		
	end

	if (self.curFrame._var.barWidth ~= SBFOBarWidthSlider:GetValue()) then
		self.curFrame._var.barWidth = SBFOBarWidthSlider:GetValue()
		self.dirty = 1		
	end

	if (self.curFrame._var.barNameFontSize ~= SBFOBarNameFontSlider:GetValue()) then
		self.curFrame._var.barNameFontSize = SBFOBarNameFontSlider:GetValue()
		self.dirty = 1		
	end

	if self.dirty then
		self:SetSliderText()
		SBF:SetupFrame(self.curFrame)
	end
end
