-- Original filters:

--  if (type == "name") then 
--    o = item.Name:lower():find(value:lower()) and true or false
--  elseif (type == "tags" or type == "tag") then
--    o = item.Tags:lower():find(value:lower()) and true or false
--  elseif (type == "bag") then 
--    o = item.Bag == tonumber(value)
--  elseif (type == "cat" or type == "category" or type == "type") then 
--    o = item.TypeSort:lower():find(value:lower()) and true or false
--  elseif (type == "quality" or type == "color" or type == "rarity") then 
--    o = QualityStrings[item.Quality+1]:lower() == value:lower()
--  elseif (type == "tooltip" or type == "desc" or type == "description") then 
--    o = item.Tooltip:lower():find(value:lower()) and true or false
--  elseif (type == "soulbound") then
--    value =  value:lower()
--    o = item.Soulbound == ((value == "true" or value == "yes" or value == "1") and 1 or 0)
--  elseif (type == "pt") then        -- Thanks to TheKarn for this!
--    o = AceLibrary("PeriodicTable-3.0"):ItemInSet(item.Link, value) and true or false
--  end

--[[----------------------------------------------------------------------------------
Notes:
	Filters are used by SanityItemCache to categorize items.
	Filter functions must take an item and value as arguments, and
	return a true/false value indicating whether or not the item
	should be included by the filter.
Arguments:
	item - the item which SanityItemCache needs a filter check
	value - the filter argument specified by the user
------------------------------------------------------------------------------------]]

--[[----------------------------------------------------------------------------------
	Filters based on the item name.
------------------------------------------------------------------------------------]]
local function nameFilter(item, value)
	return item.Name:lower():find(value:lower()) and true or false
end
SanityItemCache:RegisterFilter("name", nameFilter)

--[[----------------------------------------------------------------------------------
	Filters according to the SanityItemCache tags that have been
	placed on the item.
------------------------------------------------------------------------------------]]
local function tagFilter(item, value)
    return item.Tags:lower():find(value:lower()) and true or false
end
SanityItemCache:RegisterFilter("tag", tagFilter)
SanityItemCache:RegisterFilter("tags", tagFilter)

--[[----------------------------------------------------------------------------------
	Filters according to which bag the item is located in.
------------------------------------------------------------------------------------]]
local function bagFilter(item, value)
    return item.Bag == tonumber(value)
end
SanityItemCache:RegisterFilter("bag", bagFilter)

--[[----------------------------------------------------------------------------------
	Filters according to a SanityItemCache item category.
------------------------------------------------------------------------------------]]
local function categoryFilter(item, value)
    return item.TypeSort:lower():find(value:lower()) and true or false
end
SanityItemCache:RegisterFilter("cat", categoryFilter)
SanityItemCache:RegisterFilter("category", categoryFilter)
SanityItemCache:RegisterFilter("type", categoryFilter)

--[[----------------------------------------------------------------------------------
	Filters according to item quality.
------------------------------------------------------------------------------------]]
local function qualityFilter(item, value)
	local QualityStrings = {L["Trash"], L["Common"], L["Uncommon"], L["Rare"], L["Epic"], L["Legendary"]}
    return QualityStrings[item.Quality+1]:lower() == value:lower()
end
SanityItemCache:RegisterFilter("quality", qualityFilter)
SanityItemCache:RegisterFilter("color", qualityFilter)
SanityItemCache:RegisterFilter("rarity", qualityFilter)

--[[----------------------------------------------------------------------------------
	Filters according to text located in the item's tooltip.
------------------------------------------------------------------------------------]]
local function tooltipFilter(item, value)
    return item.Tooltip:lower():find(value:lower()) and true or false
end
SanityItemCache:RegisterFilter("tooltip", tooltipFilter)
SanityItemCache:RegisterFilter("desc", tooltipFilter)
SanityItemCache:RegisterFilter("description", tooltipFilter)

--[[----------------------------------------------------------------------------------
	Filters based on whether or not the item is soulbound.
------------------------------------------------------------------------------------]]
local function soulboundFilter(item, value)
    value = value:lower()
    return item.Soulbound == ((value == "true" or value == "yes" or value == "1") and 1 or 0)
end
SanityItemCache:RegisterFilter("soulbound", soulboundFilter)

--[[----------------------------------------------------------------------------------
	Filters against the PeriodicTable addon.
------------------------------------------------------------------------------------]]
local function ptFilter(item, value)  -- Thanks to TheKarn for this!
	local pt = AceLibrary("LibPeriodicTable-3.1")
	if pt == nil then return false end
    return pt:ItemInSet(item.Link, value) and true or false
end
SanityItemCache:RegisterFilter("pt", ptFilter)
