local L = AceLibrary("AceLocale-2.2"):new("SanityItemCache")

SANITY_CATEGORYNAMES = {
	INVTYPE_WEAPONMAINHAND = L["Main Hand"],
	INVTYPE_TRINKET = L["Trinket"],
	INVTYPE_AMMO = L["Ammunition"],
	INVTYPE_ROBE = L["Robe"],
	INVTYPE_NECK = L["Neck"],
	INVTYPE_FINGER = L["Ring"],
	INVTYPE_WRIST = L["Wrist"],
	INVTYPE_WAIST = L["Waist"],
	INVTYPE_SHOULDER = L["Shoulder"],
	INVTYPE_LEGS = L["Legs"],
	INVTYPE_HEAD = L["Head"],
	INVTYPE_FEET = L["Feet"],
	INVTYPE_CLOAK = L["Cloak"],
	INVTYPE_RANGED = L["Ranged"],
	INVTYPE_WEAPON = L["1H Weapon"],
	INVTYPE_CHEST	= L["Chest"],
	INVTYPE_2HWEAPON = L["2H Weapon"],
	INVTYPE_RANGEDRIGHT = L["Ranged"],
	INVTYPE_TABARD = L["Tabard"],
	INVTYPE_BODY = L["Shirt"],
	INVTYPE_BAG = L["Bag"],
	INVTYPE_HAND = L["Gloves"],
	INVTYPE_SHIELD = L["Shield"],
	INVTYPE_HOLDABLE = L["Offhand"],
	INVTYPE_WEAPONOFFHAND = L["Offhand"] 
};

SANITY_INVENTORY_BAG_ID = -99
SANITY_MAILBOX_BAG_ID = -98
SANITY_BANK_SLOTS_ID = -97
-- Patch 2.3 maximum 6 guild bank slots
SANITY_GUILD_BAGS = {-96,-95,-94,-93,-92,-91}
SANITY_PLAYER_BAGS  = {}
for i = 1,NUM_BAG_SLOTS do
	tinsert(SANITY_PLAYER_BAGS,i)
end
tinsert(SANITY_PLAYER_BAGS,0)
SANITY_PLAYER_BAGS_WITH_KEYRING = {unpack(SANITY_PLAYER_BAGS), KEYRING_CONTAINER}
SANITY_BANK_BAGS = {BANK_CONTAINER}
for i = NUM_BAG_SLOTS+1,NUM_BAG_SLOTS+NUM_BANKBAGSLOTS do
	tinsert(SANITY_BANK_BAGS,i)
end
-- bank bag slots are "in the bank" for searching
tinsert(SANITY_BANK_BAGS,SANITY_BANK_SLOTS_ID)
SANITY_ALL_BAGS = {
	SANITY_MAILBOX_BAG_ID, 
	SANITY_INVENTORY_BAG_ID, 
	KEYRING_CONTAINER
}
for _,v in ipairs(SANITY_PLAYER_BAGS) do tinsert(SANITY_ALL_BAGS,v) end
for _,v in ipairs(SANITY_BANK_BAGS) do tinsert(SANITY_ALL_BAGS,v) end
for _,v in ipairs(SANITY_GUILD_BAGS) do tinsert(SANITY_ALL_BAGS,v) end