function SanityItemCache:Search(index,filter,bags)
	-- Check we have information to search...
	if not SanityItemCache.db.realm.chars[UnitName("player")] then return end
	if not SanityItemCache.db.realm.chars[UnitName("player")].Bags then return end
	local list = SanityItemCache.db.realm.chars[UnitName("player")].Bags

	-- Set up our search/filter/bags to use
	filter = filter or "*"
	bags = bags or SANITY_ALL_BAGS

	local count = 1
	for _,bagIndex in ipairs(bags) do
		if list[bagIndex] then
			for idx,item in pairs(list[bagIndex]) do
				if SanityItemCache:MatchExpr(item,filter,search) then
					if count==index then 
						return item
					end
					count = count + 1
				end
			end
		end
	end
end

SanityItemCache.cachedIters = {}
function SanityItemCache:SearchIter(filter)
	filter = strtrim(filter):gsub("%s+"," ")
	local count = 0
	if self.cachedIters[filter] then
		self:Print("using cached iterator")
		local func = self.cachedIters[filter]
		func(true) -- reset the iter
		return func
	end
	self.cachedIters[filter] = function (reset)
		if reset then 
			SanityItemCache:Print("Iterator '"..filter.."' resetting")
			count = 0
			return 
		end
		count = count + 1
		return SanityItemCache:Search(count,filter)
	end
	return self.cachedIters[filter]
end

function SanityItemCache:RegisterFilter(filtername, filter)
	self.filterTypes = self.filterTypes or {}
	self.filterTypes[filtername] = filter;
	self:ScanAll();
end
