function Sanity_Sizing()
	local x,y = GetCursorPosition();
	if x ~= this.last_mouse_x or y ~= this.last_mouse_y then
		Sanity:SetupItems()
		if (Sanity.tabletop) then
			Sanity.tabletop:ResizeTabContainer()
		end
	end
	this.last_mouse_x, this.last_mouse_y = GetCursorPosition();
end

function Sanity:OnUpdate()	
	if self.needMailboxScan then
		SanityItemCache:ScanMailbox()
		self:Refresh()
		self.needMailboxScan = false
	end

	if self.DoCompress then
		if not Sanity_CompressWait:IsVisible() then
			Sanity_CompressWait:Show();
		end
		self:CompressInventory();
	elseif Sanity_CompressWait:IsVisible() then
		Sanity_CompressWait:Hide();
	end
end

function Sanity:BAG_UPDATE()
	self:Refresh()
end

function Sanity:PLAYER_REGEN_DISABLED()
	if Sanity.db.profile.CloseOnCombat then
		if SanityFrame:IsVisible() then
			Sanity:Toggle()
		end
	end
	Sanity.printedWarning = false
	SanityBagButton:Disable()
	SanityBagButton:GetNormalTexture():SetDesaturated(true)
end

function Sanity:PLAYER_REGEN_ENABLED()
	if Sanity.printedWarning then
		Sanity:Refresh()
	end
	Sanity.printedWarning = false
	SanityBagButton:Enable()
	SanityBagButton:GetNormalTexture():SetDesaturated(false)
end

function Sanity:BANKFRAME_OPENED()
	Sanity.BankIsVisible = true
	if self.db.profile.ToggleOnBank and not SanityFrame:IsVisible() then
		Sanity:Toggle()
	end
	Sanity:Refresh()
end

function Sanity:BANKFRAME_CLOSED()
	Sanity.BankIsVisible = false
	if self.db.profile.ToggleOnBank then
		SanityFrame:Hide();
	end
end

function Sanity:MERCHANT_SHOW()
	if self.db.profile.ToggleOnVendor and not SanityFrame:IsVisible() then
		Sanity:Toggle()
		if ContainerFrame1:IsVisible() then
			ToggleBackpack();
		end
	end
	self:Refresh();
end

function Sanity:MERCHANT_CLOSED()
	if self.db.profile.ToggleOnVendor then
		SanityFrame:Hide();
	end
end

function Sanity:MAIL_SHOW()
	self.mailBoxOpen = true;
	if self.db.profile.ToggleOnMail and not SanityFrame:IsVisible() then
		Sanity:Toggle()
	end
	self:Refresh();
end

function Sanity:MAIL_INBOX_UPDATE()
	self.needMailboxScan = true;
end

function Sanity:MAIL_CLOSED()
	self.mailBoxOpen = false;
	if self.db.profile.ToggleOnMail then
		SanityFrame:Hide();
	end
end