﻿local L = AceLibrary("AceLocale-2.2"):new("SacredBuff")
local BS = AceLibrary("Babble-Spell-2.2")
local M = AceLibrary("Metrognome-2.0")
local _G = getfenv(0)

local stateNames = {
	"singletarget",
	"grouptarget",
	"singleplayer",
	"groupplayer"
}

local hearthstone = GetItemInfo(6948)

local TEX_SERENITY = "Interface\\AddOns\\SacredBuff\\UI\\serenity0"
local TEX_SPHERE = "Interface\\AddOns\\SacredBuff\\UI\\Symbol32"

function SacredBuff:CreateTooltip()
	local f = CreateFrame("GameTooltip", "SacredBuffTooltip", UIParent, "GameTooltipTemplate")
	f:SetScript("OnLoad",function() this:SetOwner(WorldFrame, "ANCHOR_NONE") end)
	f:SetFrameStrata("LOW")
	f:SetToplevel(true)
	f:SetMovable(true)
	f:SetClampedToScreen(true)
	self.tooltip = f
end

function SacredBuff:CreateMainFrame()
	self.frame = CreateFrame("Frame", "SacredBuffFrame", UIParent, "SecureStateHeaderTemplate")
	local f = self.frame
	f:Hide()
	f:EnableMouse(true)
	f:SetMovable(true)
	f:SetHeight(128)
	f:SetWidth(128)
	f:SetFrameStrata("LOW")
	f:SetClampedToScreen(true)
	
	f.title = f:CreateFontString(nil, "ARTWORK")
	f.title:ClearAllPoints()
	f.title:SetPoint("BOTTOM", f, "TOP", 0, 0)
	f.title:SetFont("Fonts\\ARIALN.ttf", 11, "OUTLINE")
	f.title:SetText(L["SacredBuff"])
	f.title:SetTextColor(1.00, 1.00, 1.00, 1.00)
	
	f:SetBackdrop({ 
		bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", 
		edgeFile = "", tile = true, tileSize = 16, edgeSize = 16, 
		insets = { left = 0, right = 0, top = 0, bottom = 0 }
	})
	if self.db.profile.movable then
		f:SetBackdropColor(0.00, 0.00, 0.00, 0.60)
	else
		f:SetBackdropColor(0.00, 0.00, 0.00, 0.00)
		f.title:Hide()
	end
	
	f:SetAttribute("statebutton1", "1:singletarget;2:grouptarget")
	f:SetAttribute("statebutton2", "1:singleplayer;2:groupplayer")
	f:SetAttribute("state", self.db.char.groupMode)
	
	f:SetAttribute("unit-singletarget", ATTRIBUTE_NOOP)
	f:SetAttribute("unit-grouptarget", ATTRIBUTE_NOOP)
	f:SetAttribute("unit-singleplayer", "player")
	f:SetAttribute("unit-groupplayer", "player")
	
	f.StateChanged = function()
		self.db.char.groupMode = tonumber( f:GetAttribute("state") )
		self:TriggerEvent('SacredBuff_StateChanged', self.db.char.groupMode)
	end
	
	self:RestorePosition()
	self:ScaleFrame()
	
	f:SetScript("OnMouseDown", function()
		if arg1 == "LeftButton" and self.db.profile.movable == true then
			f:StartMoving()
			f.isMoving = true
		end
	end)
	f:SetScript("OnMouseUp", function()
		if this.isMoving then
			f:StopMovingOrSizing()
			self:SavePosition()
			f.isMoving = false
		end
	end)
	f:SetScript("OnHide", function()
		if this.isMoving then
			f:StopMovingOrSizing()
			f.isMoving = false
		end
	end)
	
	local t = CreateFrame("Button", "SacredBuffFrameMain", f, "SecureActionButtonTemplate")
	t:SetWidth(64)
	t:SetHeight(64)
	t:EnableMouse(true)
	t:SetFrameStrata("LOW")
	
	t:RegisterForClicks("LeftButtonUp", "RightButtonUp")
	
	t:SetFont("Fonts\\ARIALN.ttf", 16, "OUTLINE")
	t:SetHighlightTextColor(1, 1, 0, 1)
	t:SetTextColor(1.00, 1.00, 1.00, 1.00)
	t:ClearAllPoints()
	t:SetPoint("CENTER", f, "CENTER", 0, 0)
	
	t:SetNormalTexture(TEX_SPHERE)
	
	t:SetAttribute("newstate1", "1,2")
	t:SetAttribute("*type2", "item")
	t:SetAttribute("item", hearthstone)
	f.main = t
	f:SetAttribute("addchild", f.main)
	
	t = f:CreateTexture(nil, "OVERLAY")
	t:SetWidth(64)
	t:SetHeight(64)
	t:SetTexture(TEX_SERENITY)
	t:SetPoint("CENTER", f.main, "CENTER", 0, 0)
	f.main.background = t
	
	self.frame = f
end

function SacredBuff:ScaleFrame()
	self:SavePosition()
	_G["SacredBuffFrame"]:SetScale(self.db.profile.scaleSize)
	self:RestorePosition()
end

function SacredBuff:SavePosition()
	local f = _G["SacredBuffFrame"]
	local x, y = f:GetLeft(), f:GetTop()
	local s = f:GetEffectiveScale()
	x, y = ( x * s ), ( y * s )
	self.db.profile.PosX = x
	self.db.profile.PosY = y
end

function SacredBuff:RestorePosition()
	local x = SacredBuff.db.profile.PosX or 0
	local y = SacredBuff.db.profile.PosY or 0
	local f = _G["SacredBuffFrame"]
	local s = f:GetEffectiveScale()
	x, y = ( x / s ), ( y / s )
	f:ClearAllPoints()
	f:SetPoint("TOPLEFT", UIParent, "BOTTOMLEFT", x, y)
end

function SacredBuff:MakeButtonFrame(x, y)
	local f = CreateFrame("Button", nil, self.frame.main, "SecureActionButtonTemplate")
	f:SetWidth(35)
	f:SetHeight(35)
	f:EnableMouse(true)
	f:SetFrameStrata("MEDIUM")
	f:SetToplevel(true)
	f:SetNormalTexture(TEX_SERENITY)
	f:SetHighlightTexture(TEX_SERENITY)
	f:SetPushedTexture("Interface\\Minimap\\UI-Minimap-ZoomButton-Highlight")
	f:RegisterForClicks("AnyUp")
	
	f:ClearAllPoints()
	f:SetPoint("CENTER", self.frame.main, "CENTER", tonumber(x), tonumber(y))
	
	f:SetScript("OnLeave", self.EmptyTooltip)
	
	local t = f:CreateTexture(nil, "BACKGROUND")
	t:SetDrawLayer("BACKGROUND")
	t:SetWidth(26)
	t:SetHeight(26)
	t:ClearAllPoints()
	t:SetPoint("CENTER", f, "CENTER", 0, 0)
	f.icon = t
	
	t = f:CreateTexture(nil, "OVERLAY")
	t:SetWidth(40)
	t:SetHeight(40)
	t:SetTexture(TEX_SERENITY)
	t:SetPoint("CENTER", f, "CENTER", 0, 0)
	f.icon.overlay = t
	
	t = f:GetNormalTexture()
	t:SetWidth(40)
	t:SetHeight(40)
	t:SetDrawLayer("BACKGROUND")
	t:ClearAllPoints()
	t:SetPoint("CENTER", f.icon, "CENTER", 0, 0)
	f:SetNormalTexture(t)
	f.normal = t
	
	t = f:GetHighlightTexture()
	t:SetVertexColor( 75/255, 216/255, 241/255 )
	t:SetWidth(40)
	t:SetHeight(40)
	t:ClearAllPoints()
	t:SetBlendMode("BLEND")
	t:SetPoint("CENTER", f, "CENTER", 0, 0)
	f:SetHighlightTexture(t)
	f.highlight = t
	
	t = f:GetPushedTexture()
	t:SetWidth(35)
	t:SetHeight(35)
	t:ClearAllPoints()
	t:SetPoint("CENTER", f, "CENTER", 0, 0)
	t:SetDrawLayer("HIGHLIGHT")
	t:SetBlendMode("ADD")
	f:SetPushedTexture(t)
	f.pushed = t
	
	return f
end

function SacredBuff:OnButtonEnter()
	local mode, spellID = SacredBuff.db.profile.tooltip
	if mode == 0 then
		return
	end
	
	GameTooltip:SetOwner(self)
	
	if SacredBuff.frame.RACIAL and self == SacredBuff.frame.RACIAL then
		spellID = SacredBuff.spells.RACIAL
--	elseif SacredBuff.frame.TALENT and self == SacredBuff.frame.TALENT then
--		spellID = SacredBuff.frame.TALENT
	else
		if self.states[ SacredBuff.db.char.groupMode ] then
			spellID = SacredBuff.spells[ self.states[ SacredBuff.db.char.groupMode ] ]
		else
			spellID = SacredBuff.spells[ self.states[1] ]
		end
	end
	
	if spellID then
		if mode == 1 then
			GameTooltip:AddLine(SacredBuff.manaCache[spellID])
		elseif mode == 2 then
			GameTooltip:SetSpell(spellID, BOOKTYPE_SPELL)
		end
		GameTooltip:Show()
	end
end

function SacredBuff:EmptyTooltip()
	local f = GameTooltip
	f:ClearLines()
	local text
	for i = 1, 30 do
		text = _G["SacredBuffTooltipTextRight"..i]
		if text then
			text:SetText(nil)
		end
		text = nil
	end
	f:SetOwner(UIParent, "ANCHOR_NONE")
	f:Hide()
end

function SacredBuff:UpdateButtonColors()
	for k in next, self.frame do
		if type(self.frame[k]) == 'table' and self.frame[k].UpdateUsability then
			self.frame[k]:UpdateUsability(self.frame[k])
		end
	end
end

local function UpdateUsability(self)
	if not self.spell then
		return
	end
	
	local isUsable, noMana = IsUsableSpell(self.spell)
	if noMana ~= self.noMana then
		if noMana then
			self.icon:SetVertexColor(0.1, 0.3, 1.0)
		end
		self.noMana = noMana or nil
	end
	
	if self.noMana then
		self.clean = nil
		return
	end
	
	if self.hasRange then
		if not SacredBuff.hasTarget and self.outOfRange then
			self.outOfRange = nil
		elseif SacredBuff.hasTarget then
			local newRange = IsSpellInRange(self.spell, 'target') == 0 and true or nil
			if self.outOfRange ~= newRange then
				if newRange then
					self.icon:SetVertexColor(0.8, 0.1, 0.1)
				end
				self.outOfRange = newRange or nil
			end
		end
		
		if self.outOfRange then
			self.clean = nil
			return
		end
	end
	
	if isUsable ~= not self.notUsable then
		self.notUsable = not isUsable and true or nil
		_G.SetDesaturation(self.icon, self.notUsable)
	end
	
	if self.notUsable then
		return
	end
	
	if not self.clean then
		self.icon:SetVertexColor(1.0, 1.0, 1.0)
		self.clean = true
	end
end

function SacredBuff:NewActionButton(x, y, singleSpell, partySpell)
	local f = self:MakeButtonFrame(x, y)
	
	self.frame:SetAttribute("addchild", f)
	f:SetAttribute("useparent-statebutton", true)
	f:SetAttribute("useparent-unit", true)
	if singleSpell then
		if type(singleSpell) == 'number' then
			singleSpell = (GetSpellName(singleSpell, BOOKTYPE_SPELL))
		end
		f:SetAttribute('*type*', 'spell')
		f:SetAttribute('*spell-singletarget', singleSpell)
		f:SetAttribute('*spell-singleplayer', singleSpell)
		f.states = { singleSpell }
		local spellCheck = partySpell and GetSpellTexture(partySpell) and partySpell or singleSpell
		f:SetAttribute("*spell-grouptarget", spellCheck)
		f:SetAttribute("*spell-groupplayer", spellCheck)
		if spellCheck ~= singleSpell then
			table.insert(f.states, spellCheck)
		end
		spellCheck = f.states[self.db.char.groupMode] or f.states[1]
		local texture = GetSpellTexture(spellCheck)
		if not texture then
			error(("SacredBuff: Attempt to get texture for %s."):format(spellCheck))
		end
		f.icon:SetTexture(texture)
		f.spell = spellCheck
		f.hasRange = SpellHasRange(spellCheck)
		f:SetScript("OnEnter", self.OnButtonEnter)
	end
	
	if not self:IsActive() then
		f:Hide()
	end
	
	f.UpdateUsability = UpdateUsability
	
	return f
end

function SacredBuff:UpdateButtons()
	local f = self.frame
	if self.spells[ BS["Inner Fire"] ] and not f[ BS['Inner Fire'] ] then
		f[ BS["Inner Fire"] ] = self:NewActionButton(32, -32, BS["Inner Fire"])
	end
	
	if self.spells[ BS["Resurrection"] ] and not f[ BS["Resurrection"] ] then
		f[ BS["Resurrection"] ] = self:NewActionButton(0, -45, BS["Resurrection"])
	end
	
	if self.spells[ BS["Divine Spirit"] ] and not f[ BS["Divine Spirit"] ] then
		f[ BS["Divine Spirit"] ] = self:NewActionButton(-32, 32, BS["Divine Spirit"], BS["Prayer of Spirit"])
	end
	
	if self.spells[ BS["Power Word: Fortitude"] ] and not f[ BS["Power Word: Fortitude"] ] then
		f[ BS["Power Word: Fortitude"] ] = self:NewActionButton(0, 45, BS["Power Word: Fortitude"], BS["Prayer of Fortitude"])
	end
	
	if self.spells[ BS["Shadow Protection"] ] and not f[ BS["Shadow Protection"] ] then
		f[ BS["Shadow Protection"] ] = self:NewActionButton(32, 32, BS["Shadow Protection"], BS["Prayer of Shadow Protection"])
	end
	
	if self.hasTalents and #self.hasTalents > 0 and not f.talent then
		self:UpdateTalentButton()
	end
	
	local spellName
	if self.spells.RACIAL and not f.RACIAL then
		spellName = GetSpellName(self.spells.RACIAL, BOOKTYPE_SPELL)
		f.RACIAL = self:NewActionButton(45, 0, spellName)
	end
	
--	if self.spells.TALENT and not f.TALENT then
--		spellName = GetSpellName(self.spells.TALENT, BOOKTYPE_SPELL)
--		f.TALENT = self:NewActionButton(-45, 0, spellName)
--	end
	
	if not select(3, M:Status('SB Update Buttons')) then
		M:Start('SB Update Buttons')
	end
end


function SacredBuff:UpdateTalentButton()
	if not self.frame.talent then
		self.frame.talent = self:CreateTalentButton()
	end
end

local D = AceLibrary('Dewdrop-2.0')
function SacredBuff:CreateTalentButton()
	if not self.db.char.selTalent or not self:FindValue(self.hasTalents, self.db.char.selTalent) then
		self.db.char.selTalent = self.hasTalents[1]
	end
	local f = self:NewActionButton(-45, 0, self.db.char.selTalent)
	
	D:Register(f,
		'dontHook', true,
		'children', function()
			D:FeedAceOptionsTable(f.options)
		end
	)
	
	self.frame:SetAttribute('addchild', f)
	
	f:SetAttribute('alt-type2', 'menu')
	
	f.menu = self.TalentMenuShow
	
	return f
end

function SacredBuff:TalentMenuShow()
	if InCombatLockdown() then
		return
	end
	
	if D:IsOpen(SacredBuff.frame.talent) then
		return D:Close()
	end
	
	SacredBuff:UpdateTalentMenu()
	D:Open(SacredBuff.frame.talent)
end
