﻿--[[---------------------------------------------------------------------------------
 ADDON DECLARATION && SAVED VARIABLES && MENU INITIALIZATION
------------------------------------------------------------------------------------]]
SacredBuff = AceLibrary('AceAddon-2.0'):new('AceEvent-2.0', 'AceDB-2.0', 'AceConsole-2.0')

local new, newHash, del
do
	local cache = setmetatable({}, { __mode = 'k' })
	
	local select = select
	function new(...)
		local t = next(cache)
		if not t then
			return { ... }
		end
		cache[t] = nil
		for i = 1, select('#', ...) do
			t[i] = select(i, ...)
		end
		return t
	end
	
	function newHash(...)
		local t = next(cache)
		if t then
			cache[t] = nil
		else
			t = {}
		end
		for i = 1, select('#', ...), 2 do
			t[select(i, ...)] = select(i + 1, ...)
		end
		return t
	end
	
	local type = type
	function del(t, r)
		if not t then return end
		for k in next, t do
			if type(t[k]) == 'table' then
				del(t[k])
			end
			t[k] = nil
		end
		local mt = getmetatable(t)
		if mt then
			setmetatable(t, del(mt))
		end
		if r then
			return t
		end
		cache[t] = true
		return nil
	end
end

SacredBuff.new = new
SacredBuff.newHash = newHash
SacredBuff.del = del

local L = AceLibrary('AceLocale-2.2'):new('SacredBuff')
local BS = AceLibrary('Babble-Spell-2.2')
local M = AceLibrary('Metrognome-2.0')
local _G = getfenv(0)

local maxSpellID

-- SAVED VARIABLES
-----------------------------------------------------------
SacredBuff:RegisterDB('SBDB', 'SBPCDB')

SacredBuff:RegisterDefaults('profile', {
	movable = true,
	tooltip = 2,
	toggle = true,
	scaleSize = 1
})

SacredBuff:RegisterDefaults('char', {
	groupMode = 1, -- 1 == false; 2 == true
})

SacredBuff.spells = {
	[ BS['Inner Fire'] ] = false,
	[ BS['Resurrection'] ] = false, 
	
	[ BS['Divine Spirit'] ] = false,
	[ BS['Power Word: Fortitude'] ] = false,
	[ BS['Shadow Protection'] ] = false,
	
--	['TALENT'] = false,
	['RACIAL'] = false,
	
	[ BS['Prayer of Spirit'] ] = false,
	[ BS['Prayer of Fortitude'] ] = false,
	[ BS['Prayer of Shadow Protection'] ] = false
}

SacredBuff.talents = {
	BS['Pain Suppression'],
	BS['Circle of Healing'],
	BS['Vampiric Touch'],
	BS['Power Infusion'],
	BS['Lightwell'],
	BS['Shadowform'],
	BS['Inner Focus']
}

SacredBuff.racials = {
	BS['Touch of Weakness'],
	BS['Shadowguard'],
	BS['Fear Ward'],
	BS["Elune's Grace"],
	BS['Feedback']
}

-- MENU INITIALIZATION
-----------------------------------------------------------
local __index = function(t, k)
	t[k] = SacredBuff:GetManaCost(k)
	return t[k]
end

SacredBuff.consoleArgs = {
	type = 'group',
	args = {
		
		[ L['Lock'] ] = {
			name = L['Lock'], type = 'toggle',
			desc = L['(Un)Lock the SacredBuff frame.'],
			map = { [false] = '|cffff0000'..L['On']..'|r', [true] = '|cff00ff00'..L['Off']..'|r' },
			get = function()
				return SacredBuff.db.profile.movable
			end,
			set = function()
				SacredBuff.db.profile.movable = not SacredBuff.db.profile.movable
				if SacredBuff.db.profile.movable then
					SacredBuff.frame.title:Show()
					SacredBuff.frame:SetBackdropColor(0.00, 0.00, 0.00, 0.60)
				else
					SacredBuff.frame.title:Hide()
					SacredBuff.frame:SetBackdropColor(0.00, 0.00, 0.00, 0.00)
				end
			end
		},
		[ L['Scale'] ] = {
			name = L['Scale'], type = 'range',
			desc = L["Set the frame's scale."],
			min = 0.50, max = 2.00, isPercent = true,
			get = function() return SacredBuff.db.profile.scaleSize end,
			set = function(v)
				SacredBuff.db.profile.scaleSize = v
				SacredBuff:ScaleFrame()
			end,
		},
		[ L['Tooltip'] ] = {
			name = L['Tooltip Options'], type = 'group',
			desc = L['Select what information the tooltip provides.'],
			args = {
				[ L['None'] ] = {
					name = L['No Tooltip'], type = 'execute',
					desc = L['No tooltip will be displayed over the spell icons.'],
					func = function()
						if SacredBuff.db.profile.tooltip ~= 0 then
							if SacredBuff.manaCache then
								SacredBuff.manaCache = del(SacredBuff.manaCache)
							end
							SacredBuff.db.profile.tooltip = 0
							SacredBuff:Print(L['Tooltips turned off.'])
						end
					end
				},
				[ MANA ] = {
					name = L['Mana Only'], type = 'execute',
					desc = L['Only the mana cost of the spell will be displayed in its tooltip.'],
					func = function()
						if SacredBuff.db.profile.tooltip ~= 1 then
							if not SacredBuff.manaCache then
								SacredBuff.manaCache = setmetatable(new(), newHash('__mode', 'kv', '__index', __index))
							end
							SacredBuff.db.profile.tooltip = 1
							SacredBuff:Print(L["Tooltips will now display the spell's mana cost."])
						end
					end
				},
				[ L['Full'] ] = {
					name = L['Full Tooltip'], type = 'execute',
					desc = L["The spell's full tooltip will be displayed on mouseover."],
					func = function()
						if SacredBuff.db.profile.tooltip ~= 2 then
							if SacredBuff.manaCache then
								SacredBuff.manaCache = del(SacredBuff.manaCache)
							end
							SacredBuff.db.profile.tooltip = 2
							SacredBuff:Print(L['Full spell tooltips will now be displayed.'])
						end
					end
				}
			}
		}
	}
}
SacredBuff:RegisterChatCommand({"/sacredbuff", "/sb"}, SacredBuff.consoleArgs)

--[[---------------------------------------------------------------------------------
 ADDON INITIALIZATION && ACTIVATION
------------------------------------------------------------------------------------]]
function SacredBuff:OnInitialize()
	if select(2, UnitClass('player')) ~= 'PRIEST' then
		self:Print(L['You are not a Priest.'])
		self:ToggleActive(false)
		self:Print(L['This addon has been disabled.'])
		return
	else
		self:ToggleActive(true)
	end
	
	self.revision = tonumber(('$Revision: 31886 $'):sub(-7, -3))
	self.version = self.version .. ' |cffff8888r' .. self.revision .. '|r'
	self.date = ('$Date: 2007-04-04 20:39:08 -0400 (Wed, 04 Apr 2007) $'):sub(8, 17)
	
	if not self.db.char.revision then
		local charDB = self.db.char
		if charDB.Mounts60 then
			charDB.Mounts60 = del(charDB.Mounts60)
		end
		if charDB.Mounts100 then
			charDB.Mounts100 = del(charDB.Mounts100)
		end
		if charDB['Mounts - AQ100'] then
			charDB['Mounts - AQ100'] = del(charDB['Mounts - AQ100'])
		end
		if charDB.prefMount then
			charDB.prefMount = del(charDB.prefMount)
		end
		if charDB.prefAQMount then
			charDB.prefAQMount = del(charDB.prefAQMount)
		end
		if charDB.sacredCount then
			charDB.sacredCount = nil
		end
		if charDB.ridingSkillIndex then
			charDB.ridingSkillIndex = nil
		end
		charDB.revision = self.revision
	end
	
	self:CreateTooltip()
	self:CreateMainFrame()
	
	M:Register('SB Update Buttons', self.UpdateButtonColors, 0.5, self)
end

function SacredBuff:OnEnable()
	maxSpellID = self:FindMaxID()
	
	if self.db.profile.tooltip == 1 and not self.manaCache then
		self.manaCache = setmetatable(new(), newHash('__mode', 'kv', '__index', __index))
	end
	
	self:PLAYER_TARGET_CHANGED()
	self:LEARNED_SPELL_IN_TAB()
	self.playerLevel = UnitLevel('player')
	
	self:RegisterBucketEvent('BAG_UPDATE', 1)
	self:RegisterEvent('LEARNED_SPELL_IN_TAB')
	self:RegisterEvent('PLAYER_TARGET_CHANGED')
	self:RegisterEvent('PLAYER_LEVEL_UP')
	self:RegisterEvent('SacredBuff_StateChanged')
	
	if self.playerLevel > 39 and not self.cannotLoadSBMounts then
		local loaded, reason = LoadAddOn('SacredBuff_Mounts')
		self.cannotLoadSBMounts = loaded or reason
	end
	
	self:UpdateButtons()
	self.frame:Show()
	
	if SBMounts then
		SBMounts:ToggleActive(true)
	end
end

function SacredBuff:OnDisable()
	if SBMounts then
		SBMounts:ToggleActive(false)
	end
	self.playerLevel = nil
	maxSpellID = nil
	self.frame:Hide()
end


--[[---------------------------------------------------------------------------------
 EVENT HANDLERS
------------------------------------------------------------------------------------]]
function SacredBuff:BAG_UPDATE()
	if self.frame and self.frame.main then
		self.frame.main:SetText(GetItemCount(17029))
	end
end

function SacredBuff:LEARNED_SPELL_IN_TAB()
	for s in next, self.spells do
		self.spells[s] = self:GetSpellInfo(s) or false
	end
	local spellID
	if not self.spells.RACIAL then
		for i in ipairs(self.racials) do
			spellID = self:GetSpellInfo(self.racials[i])
			if spellID then
				self.spells.RACIAL = spellID
				break
			end
		end
	end
	if self.hasTalents then
		self.hasTalents = del(self.hasTalents)
	end
	for i in ipairs(self.talents) do
		spellID = self:GetSpellInfo(self.talents[i])
		if spellID then
			if not self.hasTalents then
				self.hasTalents = new( spellID )
			elseif not self:FindValue(self.hasTalents, spellID) then
				table.insert(self.hasTalents, spellID)
			end
		end
	end
--	self.spells['TALENT'] = false
end

function SacredBuff:PLAYER_TARGET_CHANGED()
	self.hasTarget = UnitExists('target') and true or nil
end

function SacredBuff:PLAYER_LEVEL_UP(newLevel)
	self.playerLevel = newLevel
	if newLevel == 40 and not self.cannotLoadSBMounts then
		local loaded, reason = LoadAddOn('SacredBuff_Mounts')
		self.cannotLoadSBMounts = loaded or reason
	end
end

function SacredBuff:SacredBuff_StateChanged(newState)
	for k in next, self.frame do
		if type(self.frame[k]) == 'table' and self.frame[k].states then
			self.frame[k].spell = self.frame[k].states[newState] or self.frame[k].states[1]
			self.frame[k].hasRange = SpellHasRange(self.frame[k].spell)
			if k == BS['Divine Spirit'] or k == BS['Power Word: Fortitude'] or k == BS['Shadow Protection'] then
				self.frame[k].icon:SetTexture( BS:GetSpellIcon( self.frame[k].spell ) )
			end
		end
	end
end


--[[---------------------------------------------------------------------------------
 OTHER MISCELLANEOUS YET REALLY NEAT-O FUNCTIONS
------------------------------------------------------------------------------------]]
function SacredBuff:UpdateTalentMenu()
	local f = self.frame.talent
	if not f.options then
		f.options = { type = 'group' }
	end
	f.options.args = del(f.options.args, true) or new()
	for i in ipairs(self.hasTalents) do
		f.options.args[i] = self:NewTalentOption(self.hasTalents[i])
	end
end

local D = AceLibrary('Dewdrop-2.0')
function SacredBuff:UpdateTalentAttributes()
	local talent = GetSpellName(self.db.char.selTalent, BOOKTYPE_SPELL)
	
	local f = self.frame.talent
	
	f:SetAttribute('*spell-singletarget', talent)
	f:SetAttribute('*spell-singleplayer', talent)
	f.states = del(f.states)
	f.states = new(talent)
	f.icon:SetTexture(GetSpellTexture(talent))
	f.spell = talent
	f.hasRange = SpellHasRange(talent)
	
end

function SacredBuff:NewTalentOption(k)
	local spellName = GetSpellName(k, BOOKTYPE_SPELL)
	return newHash(
		'name', spellName,
		'type', 'toggle',
		'desc', spellName,
		'isRadio', true,
		'get', function()
			if self.db.char.selTalent and self.db.char.selTalent == k then
				return true
			end
		end,
		'set', function()
			if self.frame.talent and not InCombatLockdown() then
				if self.db.char.selTalent and self.db.char.selTalent == spellName then
					return
				end
				self.db.char.selTalent = k
				self:UpdateTalentAttributes()
				D:Close()
			end
		end
	)
end

function SacredBuff:FindValue(t, v)
	for i in ipairs(t) do
		if t[i] == v then
			return i
		end
	end
end

function SacredBuff:FindMaxID()
	local id = 10
	while GetSpellTexture(id, BOOKTYPE_SPELL) do
		id = id + 1
	end
	return id
end

function SacredBuff:GetSpellInfo(spellName)
	for i = maxSpellID, 1, -1 do
		if (GetSpellName(i, BOOKTYPE_SPELL)) == spellName then
			return i
		end
	end
end

local G = AceLibrary('Gratuity-2.0')
function SacredBuff:GetManaCost(spellID)
	G:SetSpell(spellID, BOOKTYPE_SPELL)
	return tonumber(select(3, G:Find('(%d+)%s'..MANA, 2, 2, false, true))) or 0
end
