------------------------------------------------------------------------------------------------------
-- Sabella Options Dialog
--
-- Maintainer : Isognomy
--
-- Based on Ideas by:
--   Serenity and Cryolysis by Kaeldra of Aegwynn 
--   Necrosis LdC by Lomig and Nyx (http://necrosis.larmes-cenarius.net)
--   Original Necrosis Idea : Infernal (http://www.revolvus.com/games/interface/necrosis/)
------------------------------------------------------------------------------------------------------

SabellaOptions = {};

local L = AceLibrary('AceLocale-2.2'):new('Sabella');


SabellaOptions.tabFrameNames = { 'Sphere', 'PoisonSphere', 'Buttons', 'Messages', 'Inventory', 'Debug' };


-- Initialize the options
function SabellaOptions:Initialize()
    UIPanelWindows["SabellaOptionsFrame"] = { area = "LEFT", pushable = 5, whileDead = 1  };

    SabellaOptionsFrameTitleText:SetText(GetAddOnMetadata('Sabella', 'Title')..' '..GetAddOnMetadata('Sabella', 'Version'));
    
    -- make dragable
    SabellaOptionsFrame:RegisterForDrag('LeftButton');
    
    -- tooltips
    self:InitializeLabel(SabellaOptionsLabel_Tooltips);
    self:InitializeCheckbox(SabellaOptionsCheckButton_Tooltips, Sabella.db.profile.buttonTooltips);
    self:InitializeLabel(SabellaOptionsLabel_DefaultTooltips);
    self:InitializeCheckbox(SabellaOptionsCheckButton_DefaultTooltips, Sabella.db.profile.buttonDefaultTooltips);
    
    -- menu behaviuor
    self:InitializeLabel(SabellaOptionsLabel_MenuKeepOpen);
    self:InitializeCheckbox(SabellaOptionsCheckButton_MenuKeepOpen, Sabella.db.profile.menuKeepOpen);
    
    -- message options
    self:InitializeLabel(SabellaOptionsLabel_OnScreen);
    self:InitializeCheckbox(SabellaOptionsCheckButton_OnScreen, Sabella.db.profile.messagesOnScreen);
    self:InitializeLabel(SabellaOptionsLabel_DebugTexture);
    self:InitializeCheckbox(SabellaOptionsCheckButton_DebugTexture, Sabella.db.profile.messagesMissingTexture);
    self:InitializeLabel(SabellaOptionsLabel_MsgRandom);
    self:InitializeCheckbox(SabellaOptionsCheckButton_MsgRandom, Sabella.db.profile.messagesRandom);
    self:InitializeLabel(SabellaOptionsLabel_MsgRandomSap);
    self:InitializeCheckbox(SabellaOptionsCheckButton_MsgRandomSap, Sabella.db.profile.messagesRandomSap);
    self:InitializeLabel(SabellaOptionsLabel_MsgRandomSprint);
    self:InitializeCheckbox(SabellaOptionsCheckButton_MsgRandomSprint, Sabella.db.profile.messagesRandomSprint);
    self:InitializeLabel(SabellaOptionsLabel_MsgRandomEvis);
    self:InitializeCheckbox(SabellaOptionsCheckButton_MsgRandomEvis, Sabella.db.profile.messagesRandomEvis);
    self:InitializeLabel(SabellaOptionsLabel_MsgRandomEvasionSpeech);
    self:InitializeCheckbox(SabellaOptionsCheckButton_MsgRandomEvasionSpeech, Sabella.db.profile.messagesRandomEvasionSpeech);
    self:InitializeLabel(SabellaOptionsLabel_MsgRandomBackStab);
    self:InitializeCheckbox(SabellaOptionsCheckButton_MsgRandomBackStab, Sabella.db.profile.messagesRandomBackStab);
    self:InitializeLabel(SabellaOptionsLabel_MsgRandomMount);
    self:InitializeCheckbox(SabellaOptionsCheckButton_MsgRandomMount, Sabella.db.profile.messagesRandomMount);
    self:InitializeSlider(SabellaOptionsSlider_MsgRandomLanguage, Sabella.db.profile.messagesLanguage, L['MESSAGES_LANGUAGE']);
    SabellaOptionsSlider_MsgRandomLanguage:SetMinMaxValues(1, Sabella:GetSpeechLanguageCount());
    
    -- Poison Sphere Options
    self:InitializeLabel(SabellaOptionsLabel_ActionPoisons);
    self:InitializeCheckbox(SabellaOptionsCheckButton_ActionPoisons, Sabella.db.profile.buttonActionOneVisible);
    SabellaOptionsSlider_ActionPoisonsLeft:SetMinMaxValues(46, Sabella:ButtonGetActionCount());
    self:InitializeSlider(SabellaOptionsSlider_ActionPoisonsLeft, Sabella.db.profile.buttonActionPoisonsLeft, L['TOOLTIP_LEFTCLICK']);
    SabellaOptionsSlider_ActionPoisonsRight:SetMinMaxValues(46, Sabella:ButtonGetActionCount());
    self:InitializeSlider(SabellaOptionsSlider_ActionPoisonsRight, Sabella.db.profile.buttonActionPoisonsRight, L['TOOLTIP_RIGHTCLICK']);

    -- Sphere Options
    self:InitializeLabel(SabellaOptionsLabel_LockSphere);
    self:InitializeLabel(SabellaOptionsLabel_LockButtons);
    self:InitializeLabel(SabellaOptionsLabel_ButtonOrderCCW);
    self:InitializeCheckbox(SabellaOptionsCheckButton_SphereLocking, Sabella.db.profile.sphereLocking);
    self:InitializeCheckbox(SabellaOptionsCheckButton_ButtonLocking, Sabella.db.profile.buttonLocking);
    self:InitializeCheckbox(SabellaOptionsCheckButton_ButtonOrderCCW, Sabella.db.profile.buttonOrderCCW);
    SabellaOptionsSlider_SphereSkin:SetMinMaxValues(1, Sabella:SphereGetSkinsCount());
    self:InitializeSlider(SabellaOptionsSlider_SphereSkin, Sabella.db.profile.sphereSkin, L['SPHERE_SKIN']);
    self:InitializeSlider(SabellaOptionsSlider_SphereRotation, Sabella.db.profile.sphereRotation, L['SPHERE_ROTATION']);
    self:InitializeSlider(SabellaOptionsSlider_SphereOpacity, Sabella.db.profile.sphereOpacity, L['SPHERE_OPACITY']);
    self:InitializeSlider(SabellaOptionsSlider_ButtonOpacity, Sabella.db.profile.buttonOpacity, L['BUTTON_OPACITY']);
    self:InitializeSlider(SabellaOptionsSlider_SphereScale, Sabella.db.profile.sphereScale, L['SPHERE_SCALE']);
    self:InitializeSlider(SabellaOptionsSlider_ButtonScale, Sabella.db.profile.buttonScale, L['BUTTON_SCALE']);
    local sphereCircleStatusCount, sphereTextStatusCount = Sabella:SphereGetStatusCount();
    SabellaOptionsSlider_SphereCircle:SetMinMaxValues(0, 45);
    self:InitializeSlider(SabellaOptionsSlider_SphereCircle, Sabella.db.profile.sphereStatusCircle, L['SPHERE_CIRCLE']);
    SabellaOptionsSlider_SphereText:SetMinMaxValues(0, 45);
    self:InitializeSlider(SabellaOptionsSlider_SphereText, Sabella.db.profile.sphereStatusText, L['SPHERE_TEXT']);
    SabellaOptionsSlider_SphereActionLeft:SetMinMaxValues(0, 45);
    self:InitializeSlider(SabellaOptionsSlider_SphereActionLeft, Sabella.db.profile.sphereActionLeft, L['TOOLTIP_LEFTCLICK']);
    SabellaOptionsSlider_SphereActionRight:SetMinMaxValues(0, 45);
  
    self:InitializeSlider(SabellaOptionsSlider_SphereActionRight, Sabella.db.profile.sphereActionRight, L['TOOLTIP_RIGHTCLICK']);
    -- button options
    self:InitializeLabel(SabellaOptionsLabel_ShowButtons);
    self:InitializeLabel(SabellaOptionsLabel_Drink);
    self:InitializeCheckbox(SabellaOptionsCheckButton_Drink, Sabella.db.profile.buttonDrinkVisible);
    self:InitializeLabel(SabellaOptionsLabel_DrinkWeakest);
    self:InitializeCheckbox(SabellaOptionsCheckButton_DrinkWeakest, Sabella.db.profile.buttonDrinkWeakest);
    self:InitializeLabel(SabellaOptionsLabel_Potion);
    self:InitializeCheckbox(SabellaOptionsCheckButton_Potion, Sabella.db.profile.buttonPotionVisible);
    self:InitializeLabel(SabellaOptionsLabel_PotionWeakest);
    self:InitializeCheckbox(SabellaOptionsCheckButton_PotionWeakest, Sabella.db.profile.buttonPotionWeakest);
    self:InitializeLabel(SabellaOptionsLabel_Mount);
    self:InitializeCheckbox(SabellaOptionsCheckButton_Mount, Sabella.db.profile.buttonMountVisible);
    self:InitializeLabel(SabellaOptionsLabel_Thistle);
    self:InitializeCheckbox(SabellaOptionsCheckButton_Thistle, Sabella.db.profile.buttonThistleVisible);
    self:InitializeLabel(SabellaOptionsLabel_Bandage);
    self:InitializeCheckbox(SabellaOptionsCheckButton_Bandage, Sabella.db.profile.buttonBandageVisible);
    self:InitializeLabel(SabellaOptionsLabel_StealthMenu);
    self:InitializeCheckbox(SabellaOptionsCheckButton_StealthMenu, Sabella.db.profile.buttonStealthMenuVisible);
    self:InitializeLabel(SabellaOptionsLabel_ReagentsMenu);
    self:InitializeCheckbox(SabellaOptionsCheckButton_ReagentsMenu, Sabella.db.profile.buttonReagentsMenuVisible);

    -- action button options
    self:InitializeLabel(SabellaOptionsLabel_ActionOne);
    self:InitializeCheckbox(SabellaOptionsCheckButton_ActionOne, Sabella.db.profile.buttonActionOneVisible);
    SabellaOptionsSlider_ActionOneLeft:SetMinMaxValues(0, 45);
    self:InitializeSlider(SabellaOptionsSlider_ActionOneLeft, Sabella.db.profile.buttonActionOneLeft, L['TOOLTIP_LEFTCLICK']);
    SabellaOptionsSlider_ActionOneRight:SetMinMaxValues(0, 45);
    self:InitializeSlider(SabellaOptionsSlider_ActionOneRight, Sabella.db.profile.buttonActionOneRight, L['TOOLTIP_RIGHTCLICK']);
    self:InitializeLabel(SabellaOptionsLabel_ActionTwo);
    self:InitializeCheckbox(SabellaOptionsCheckButton_ActionTwo, Sabella.db.profile.buttonActionTwoVisible);
    SabellaOptionsSlider_ActionTwoLeft:SetMinMaxValues(0, 45);
    self:InitializeSlider(SabellaOptionsSlider_ActionTwoLeft, Sabella.db.profile.buttonActionTwoLeft, L['TOOLTIP_LEFTCLICK']);
    SabellaOptionsSlider_ActionTwoRight:SetMinMaxValues(0, 45);
    self:InitializeSlider(SabellaOptionsSlider_ActionTwoRight, Sabella.db.profile.buttonActionTwoRight, L['TOOLTIP_RIGHTCLICK']);
    self:InitializeLabel(SabellaOptionsLabel_ActionThree);
    self:InitializeCheckbox(SabellaOptionsCheckButton_ActionThree, Sabella.db.profile.buttonActionThreeVisible);
    SabellaOptionsSlider_ActionThreeLeft:SetMinMaxValues(0, 45);
    self:InitializeSlider(SabellaOptionsSlider_ActionThreeLeft, Sabella.db.profile.buttonActionThreeLeft, L['TOOLTIP_LEFTCLICK']);
    SabellaOptionsSlider_ActionThreeRight:SetMinMaxValues(0, 45);
    self:InitializeSlider(SabellaOptionsSlider_ActionThreeRight, Sabella.db.profile.buttonActionThreeRight, L['TOOLTIP_RIGHTCLICK']);

    -- debug 
    self:InitializeLabel(SabellaOptionsDebugItemTitle);
    self:InitializeLabel(SabellaOptionsDebugTexture);
    self:ShowTextureMessages();
  
    self:TabButtonClick('Sphere', 'TAB_SPHERE');
end

function SabellaOptions:UpdateData() 
    self:ShowTextureMessages();
end

function SabellaOptions:ShowTextureMessages()
    local textureStr = '';
    if Sabella.missingTextures ~= nil and type(Sabella.missingTextures) == 'table' then
        for texture, _ in pairs(Sabella.missingTextures) do
            textureStr = texture..', '..textureStr;
        end
        SabellaOptionsDebugTextureMsgs:SetText(textureStr);
    end
end

function SabellaOptions:InitializeLabel(element) 
    if element ~= nil then
        local stringIdent = element:GetText();
        if L[stringIdent]  ~= nil then
            element:SetText(L[stringIdent])
        end
    end
end

function SabellaOptions:InitializeCheckbox(element, value) 
    if element ~= nil then
        element:SetChecked(value);
    end
end

function SabellaOptions:InitializeSlider(element, value, topText, leftText, rightText) 
    if element ~= nil then
        element:SetValue(value);
        local elementName = element:GetName();
        if topText ~= nil then
            getglobal(elementName..'Text'):SetText(topText);
        end
        if leftText ~= nil then
            getglobal(elementName..'Low'):SetText(leftText);
        else
            getglobal(elementName..'Low'):SetText('');
        end
        if leftText ~= nil then
            getglobal(elementName..'High'):SetText(rightText);
        else
            getglobal(elementName..'High'):SetText('');
        end        
    end
end

function SabellaOptions:TabButtonClick(tabId, tabTitle)
    local tabFrame, tabButton;
	for i=1, table.getn(self.tabFrameNames), 1 do
		tabFrame = getglobal('SabellaOptionsFrame'..self.tabFrameNames[i]);
		tabButton = getglobal('SabellaOptionsTab'..self.tabFrameNames[i]);
        if tabId == self.tabFrameNames[i] then
            if tabButton ~= nil then
                tabButton:SetChecked(true);
            end
            if tabFrame ~= nil then
                ShowUIPanel(tabFrame);
            end
        else
            if tabButton ~= nil then
                tabButton:SetChecked(false);
            end
            if tabFrame ~= nil then
                HideUIPanel(tabFrame);
            end
        end
        if L[tabTitle] ~= nil then
            SabellaOptionsFrameSubTitleText:SetText(L[tabTitle]);
        end
	end
end

function SabellaOptions:ShowTooltip(element, elementId, anchor)  
    if not self.initialized then
        return;
    end
    
    GameTooltip:SetOwner(element, anchor);
 
    -- show value
    if elementId == 'VALUE' then    
        GameTooltip:AddLine(element:GetValue());
    elseif elementId == 'ACTION_VALUE' then    
        local actionIdx = element:GetValue();
        local actionType, actionName, _, _, _, _, actionSlotName = Sabella:ButtonGetActionInfo(actionIdx);
        if actionType == 'slot' and actionSlotName then
            local actionPrefix = actionSlotName;
            if L['SLOT_'..actionSlotName] ~= nil then
                actionPrefix = L['SLOT_'..actionSlotName];
            end
            if actionName ~= nil then
                GameTooltip:AddLine(actionPrefix..': '..actionName);
            else 
                GameTooltip:AddLine(actionPrefix..': '..L['NONE']);
            end            
        else
            if actionName ~= nil then
                GameTooltip:AddLine(actionName);
            else 
                GameTooltip:AddLine(L['NONE']);
            end
        end
    elseif elementId == 'SKIN' then   
        local skinName = Sabella:SphereGetSkinName(element:GetValue()); 
        if skinName ~= nil then
            GameTooltip:AddLine(skinName);
        else 
            GameTooltip:AddLine('Solid');
        end
    elseif elementId == 'SPHERE_CIRCLE' then   
        local circleStatus = Sabella:SphereGetStatusInfo(element:GetValue(), nil); 
        if circleStatus ~= nil then
            if L['STATUS_'..circleStatus] ~= nil then
                GameTooltip:AddLine(L['STATUS_'..circleStatus]);
            else
                GameTooltip:AddLine(circleStatus);
            end
        else 
            GameTooltip:AddLine(L['NONE']);
        end
    elseif elementId == 'SPHERE_TEXT' then   
        local _, textStatus = Sabella:SphereGetStatusInfo(nil, element:GetValue()); 
        if textStatus ~= nil then
            if L['STATUS_'..textStatus] ~= nil then
                GameTooltip:AddLine(L['STATUS_'..textStatus]);
            else
                GameTooltip:AddLine(textStatus);
            end
        else 
            GameTooltip:AddLine(L['NONE']);
        end        
    -- get directly from localisation
    elseif elementId == 'MSG_LANGUAGE' then
        GameTooltip:AddLine(Sabella:GetSpeechLanguage(element:GetValue()));
    elseif L[elementId] ~= nil then    
        GameTooltip:AddLine(L[elementId]);
    end
  
	-- and done, show it!
	GameTooltip:Show();
end

function SabellaOptions:HideTooltip()
    GameTooltip:Hide();
end

function SabellaOptions:Invalidate(status, positions, dragable)
    if dragable then
        Sabella:ButtonSetDragable();
        Sabella:ButtonSetPositions();
    elseif positions then
        Sabella:ButtonSetPositions();
        Sabella:ButtonUpdateMenus();
    end
    if status then
        Sabella:UpdateActions();
    end
    Sabella:UpdateStatus();
end

function SabellaOptions:SetOptionSlider(element, optionName) 
    local optionValue = element:GetValue();
    Sabella.db.profile[optionName] = optionValue;
end

function SabellaOptions:SetOptionCheckbox(element, optionName) 
    local checked = element:GetChecked();
    if (checked) then
        Sabella.db.profile[optionName] = true;
    else
        Sabella.db.profile[optionName] = false;
    end
end

function SabellaOptions:OnDebugItemDrop() 
    if CursorHasItem() then
        if GetCursorInfo ~= nil then
            local cursorType, itemId = GetCursorInfo();
            if itemId ~= nil then
                local itemName, _, _, _, _, _, _, _, _, itemTexture = GetItemInfo(itemId);
                if itemName ~= nil then
                    SabellaOptionsDebugItemIcon:SetTexture(itemTexture);
                    SabellaOptionsDebugItemEdit:SetText(itemName..' - '..itemId);
                end
            end
        else
            Sabella:ShowMessage('Sorry, but this works only in WoW >= 2.0.3', 'USER');
        end
    end
end
