--[[
	Do NOT Edit this file!
	It is used for MORE then just text
	see localization.DE.lua localization.FR.lua etc files
	if you want to change englisch text add a localization.EN.lua
	You could consider this the "neutral" language
	Point is there are function mappings here that dont have to be touched.
	
]]--

SW_RootSlashes = {"/swstats", "/sws"};

SW_VERSION = "2.2.0";
SW_MEM_WARNING_THRESH = 10000;
SW_TL_AUTO_THRESH = 48; -- if using auto delete the time in hours when to delete

-- the 2 sync channels
-- if i change these between versions i always have a good reason to
-- just update to the next version
SW_CHAN_MAIN = "SWSudX22";
SW_CHAN_HS = "SWSHSX22";
--2.1.2 New channel that will never change and will work with all future versions
-- to do a version check of sw stats to see if people run outdated versions
SW_CHAN_VC = "SWSVC7w7";

-- 2.0 global vars, do NOT localize start
SW_WORLD = "WORLD";

-- 2.0 global vars, do NOT localize END

-- 2.0 New strings LOCALIZE
	-- SW_DS_xx are data segment names some of these aren't used (yet)
	SW_DS_START = "Start"; -- name of the first segment
	SW_DS_RESET = "Reset"; 
	SW_DS_ZONED = "Zoned to %s";
	SW_DS_JOINED_GROUP = "Joined group";
	SW_DS_LEFT_GROUP = "Left group";
	SW_DS_JOINED_RAID = "Joined raid";
	SW_DS_LEFT_RAID = "Left raid";
	SW_DS_MERGED = "Merged"; -- used when merging data segements
	SW_DS_SYNC_INIT = "SyncInit"; -- 2.0.beta.2
	-- not used yet
	-- 2.0.beta.2 note to self:
	-- we would need a synced reset with these.
	SW_DS_ENCOUNTER = "Started fight with %s";
	SW_DS_PHASE_CHANGE = "%s Phase %d";
	SW_DS_TIMER = "%d seconds elapsed";
	
	-- special "school" for environmental damage
	-- falling drowining etc
	SW_STR_ENVIRO = "Environmental";
	
	SW_CL_SHOOT = "Shoot"; -- the Wand "Shoot" ability as found in the combat log
	SW_MAP_SKILL_DMGSHIELD = "Damageshield"; -- "skill" name to map damge shields to (thorns etc.)
	
	-- strings for detail info on mouse over
	SW_TT_SKILL_HEAD = "Details: %s (%s)";
	SW_TT_SKILL_SWINGS = "Hits:%d Ticks:%d Misses:%d Resists:%d OtherZeroDmg:%d";
	SW_TT_SKILL_CRITS = "Crits:%d CritOnHit:%g%% Crit with ZeroDmg:%g%%";
	SW_TT_SKILL_GLCRUSH = "Glancing:%d Crushing:%d";
	SW_TT_SKILL_RMP = "Missed:%g%% Resist:%g%% Penetration rating:%g";
	SW_TT_SKILL_AVGMAX = "Average per hit:%g Max tick:%d";
	
	-- 2.1.3
	SW_TT_UNIT_EXPLAIN1 = "    Format: name = total (%total) #crits/#hits (%crit), avg";
	SW_TT_UNIT_EXPLAIN2 = "    Values in []  = %s - %s";
	SW_TT_UNIT_EXPLAIN3 = "    Rightclick any 'unitbar' to set the comparative target";
	SW_TT_UNIT_SKILL_FORMAT = "    %s = %d%s (%.1f%%) %d%s|cffffffff/|r%d%s (%.1f%s%%)|cffffffff,|r %.1f%s Avg";
	SW_TT_UNIT_DMG_HEAD = "Damage Done = %d (Crit = %.1f%%)";
	SW_TT_UNIT_HEAL_HEAD = "Healing Done = %d (Effective = %d, OH = %.1f%%, Crit = %.1f%%)";
	SW_TT_UNIT_INC_HEAD = "Damage Taken = %d";
	SW_TT_UNIT_INC_EH = "    Incoming: Effective Healing = %d, Raw Healing = %d, OH = %.1f%%";
	SW_TT_UNIT_NODATA = "    No data";
	
	-- old unit stuff
	SW_TT_UNIT_HEAD = "Details: %s";
	SW_TT_UNIT_IN = "Incoming:";
	SW_TT_UNIT_OUT = "Outgoing:";
	SW_TT_UNIT_DMGHEAL = "Damage:%d Effective Heal:%d Raw Heal:%d InFightOH:%g%%";
	SW_TT_UNIT_CRIT = "Damage Critrate:%g%% Heal Critrate:%g%%";
	
	SW_TT_SCHOOL_DONE = "School:%s (Done by %s)";
	SW_TT_SCHOOL_REC = "School:%s (Recieved by %s)";
	SW_TT_SCHOOL_ZERODMG = "Resists/Misses:%d Other zero Damage:%d"; -- other = total absorb immune etc
	SW_TT_SCHOOL_PARTIAL = "Partial resist amount:%d";
	SW_TT_SCHOOL_PERCENT = "Total resists:%g%% Partial:%g%%";
	SW_TT_SCHOOL_AVGAPR = "Average Dmg:%g Aprox. resist:%g%%";
	
	--2.0.beta.2
	SW_REP_ACTIVE_SEGMENT = "ActiveOnly: %s"; -- used for reporting shows if only the active segment is selected
	
	-- 2.0.5 
	SW_ND_AUTO = "SW Stats NarrowData mode is |cff40ff40AUTO - On outside and off in an instance|r (/sws nd)";
	SW_ND_ON = "SW Stats NarrowData mode is |cffFFFF40ON - Only collecting reduced data relevant to the group.|r (/sws nd)";
	SW_ND_OFF = "SW Stats NarrowData mode is |cffff2020OFF - Collecting all data found.|r (/sws nd)";
	
	--2.1.1 Version check string to be printed
	SW_VC_INFO = "|cffffffff%s|r Version:|cffffffff%s|r   Sync is on:|cffffffff%s|r  Sync is compatible:|cffffffff%s|r";
	
-- 2.0 New strigs LOCALIZE END but check GUI and Tooltips
-- 2.0.beta.2 check "reset" and "rv" description and usage


-- 1.3.2 max amount of "quick option buttons"
-- 2.0.5 Increased to 20 if you want more buttons dont forget to add them in SW_BarFrames.xml 
SW_OPT_COUNT = 20;
SW_OPT_SPACER = 3; -- added with 2.0.5 the space in px between the buttons

SW_CONSOLE_NOCMD = "No such command: ";
SW_CONSOLE_HELP ="Help: ";
SW_CONSOLE_NIL_TRAILER = " is not defined."; -- space at beginning
SW_CONSOLE_SORTED = "Sorted";
SW_CONSOLE_NOREGEX = "There is no regex for this event.";
SW_CONSOLE_FALLBACK = "Found a regex - added to map";
SW_FALLBACK_BLOCK_INFO = "This event is blocked from auto updating itself.";
SW_FALLBACK_IGRNORED = "This event has been ignored.";
SW_EMPTY_EVENT = "Listening to non needed event?: ";
SW_INFO_PLAYER_NF = "There is no info for: ";
SW_PRINT_INFO_FROMTO = "|cffffffffFrom:|r%s, |cffffffffTarget:|r%s,";
SW_PRINT_ITEM = "|cffffffff%s:|r%s,";
SW_PRINT_ITEM_DMG = "Dmg";
SW_PRINT_ITEM_HEAL = "Healed";
SW_PRINT_ITEM_THROUGH = "Through";
SW_PRINT_ITEM_TYPE = "Type";
SW_PRINT_ITEM_CRIT = "|cffff2020CRIT|r";
SW_PRINT_ITEM_WORLD = "WORLD";
SW_PRINT_ITEM_NORMAL = "Normal";
SW_PRINT_ITEM_RECIEVED = "Recieved";
SW_PRINT_INFO_RECIEVED = "|cffff2020Dmg:%s|r, |cff20ff20Heal:%s|r";
SW_PRINT_ITEM_TOTAL_DONE = "Total";
SW_PRINT_ITEM_NON_SCHOOL = "Other";
SW_PRINT_ITEM_IGNORED = "Ignored";
SW_PRINT_ITEM_DEATHS = "Deaths";

SW_SYNC_CHAN_JOIN = "|cff20ff20SWSync: You have joined:|r";
SW_SYNC_CHAN_FAIL= "|cffff2020SWSync: Could not join:|r";
SW_SYNC_JOINCHECK_FROM = "Join SWSyncChannel %s from: %s ?"
SW_SYNC_JOINCHECK_INFO = "Old data will be lost!"
SW_SYNC_CURRENT = "Current SyncChannel: %s";
SW_BARS_WIDTHERROR = "The Bar is to wide!"
SW_B_CONSOLE = "C";
SW_B_SETTINGS = "S";
SW_B_SYNC = "Y";
SW_B_REPORT = "R";
-- 2.0
SW_B_TL = "T";

SW_STR_MAX = "Max";
SW_STR_EVENTCOUNT = "#";
SW_STR_AVERAGE = "ø";
SW_STR_PET_PREFIX = "[Pet] "; -- pet prefix for pet info displayed in the bars
SW_STR_VPP_PREFIX = "[All pets] "; -- pet prefix for virtual pet per player info displayed in the bars
SW_STR_VPR = "[Raid Pet]"; -- pet string for virtual pet per raid info displayed in the bars
-- 1.5.beta.1 Reset vote
SW_STR_RV = "|cffff5d5dReset Vote!|r Issued by |cffff5d5d%s|r.  Do you want the SyncChannel to reset?";
SW_STR_RV_PASSED =  "|cffffff00[SW Sync]|r |cff00ff00Reset vote passed!|r";
SW_STR_RV_FAILED = "|cffffff00[SW Sync]|r |cffff5d5dReset vote failed!|r";
SW_STR_VOTE_WARN = "|cffffff00[SW Sync]|r |cffff5d5dDon't spam votes...|r";

--1.5.3
--Raid DPS Strings 2.0.beta.3 not sure if ill bring this back
SW_RDPS_STRS = {
	["CURR"] = "RDPS Current Fight",
	["ALL"] = "RDPS",
	["LAST"] = "RDPS Last Fight",
	["MAX"] = "RDPS Max",
	["TOTAL"] = "RDPS The Ugly truth", -- a timer that keeps running, no matter if in or out of fight
}
--[[
-- devour magic ? (pet fellhunter)
-- add sheep ? 
-- add totems ?
--]]
SW_Spellnames = {
	[1] = "Remove Lesser Curse",
	[2] = "Remove Curse",
	[3] = "Dispel Magic",
	[4] = "Cure Disease",
	[5] = "Abolish Disease",
	[6] = "Purify",
	[7] = "Cleanse",
	[8] = "Cure Poison",
	[9] = "Abolish Poison",
	[10] = "Purge",
}

SW_GUI ={
	["SW_FrameConsole_Title"] = {["s"] = "SW v"..SW_VERSION, ["f"] = SW_TitleSetText },
	["SW_FrameConsole_Tab1"] = {["s"] = "General", ["f"] = SW_TabSetText },
	["SW_FrameConsole_Tab2"] = {["s"] = "Event Info", ["f"] = SW_TabSetText },
	["SW_BarSettingsFrameV2_Tab1"] = {["s"] = "Data", ["f"] = SW_TabSetText },
	["SW_BarSettingsFrameV2_Tab2"] = {["s"] = "Visuals", ["f"] = SW_TabSetText },
	["SW_BarSettingsFrameV2_Tab3"] = {["s"] = "Pets", ["f"] = SW_TabSetText },
	["SW_Chk_ShowEventText"] = "Show Unhandeled Messages",
	["SW_Chk_ShowOrigStrText"] = "Show Log Message",
	["SW_Chk_ShowRegExText"] = "Show Remap Info",
	["SW_Chk_ShowMatchText"] = "Suppress CastMsgs",
	["SW_Chk_ShowSyncInfoText"] = "Show SyncMsgs",
	--["SW_Chk_ShowOnlyFriendsText"] = "Only show 'Friends'",
	["SW_Chk_ShowTLBText"] = "Show TL button",
	["SW_Chk_ShowSyncBText"] = "Show Sync button",
	["SW_Chk_ShowConsoleBText"] = "Show Console button",
	["SW_Chk_ShowDPSText"] = "DPS";
	["SW_RepTo_SayText"] = "Say",
	["SW_RepTo_GroupText"] = "Group",
	["SW_RepTo_RaidText"] = "Raid",
	["SW_RepTo_GuildText"] = "Guild",
	["SW_RepTo_ChannelText"] = "Channel",
	["SW_RepTo_WhisperText"] = "Whisper",
	["SW_RepTo_ClipboardText"] = "Textbox",
	["SW_RepTo_OfficerText"] = "Officer",
	["SW_BarReportFrame_Title_Text"] = "Report to..",
	["SW_Chk_RepMultiText"] = "Multiline",
	["SW_Chk_RepFrameTxtText"] = "Use frame text",
	["SW_Filter_PCText"] = "PC",
	["SW_Filter_NPCText"] = "NPC",
	["SW_Filter_GroupText"] = "Current Group/Raid",
	["SW_Filter_EverGroupText"] = "Ever Group/Raid",
	["SW_Filter_NoneText"] = "None",
	["SW_GeneralSettings_Title_Text"] = "General Settings",
	["SW_BarSyncFrame_Title_Text"] = "SyncChannel Settings",
	["SW_BarSettingsFrameV2_Title_Text"] = "Settings",
	["SW_CS_Damage"] =  {["s"] = "Damage Color", ["f"] = SW_SetColorSwatchText },
	["SW_CS_Heal"] =  {["s"] = "Heal Color", ["f"] = SW_SetColorSwatchText },
	["SW_CS_BarC"] =  {["s"] = "Bar Color", ["f"] = SW_SetColorSwatchText },
	["SW_CS_FontC"] =  {["s"] = "Font Color", ["f"] = SW_SetColorSwatchText },
	["SW_CS_OptC"] =  {["s"] = "Button Color", ["f"] = SW_SetColorSwatchText },
	["SW_TextureSlider"] =  {["s"] = "Texture:", ["f"] = SW_SetSliderPreText },
	["SW_FontSizeSlider"] =  {["s"] = "Font Size:", ["f"] = SW_SetSliderPreText },
	["SW_BarHeightSlider"] =  {["s"] = "H:", ["f"] = SW_SetSliderPreText },
	--["SW_BarWidthSlider"] =  {["s"] = "Bar Width:", ["f"] = SW_SetSliderPreText },
	["SW_ColCountSlider"] =  {["s"] = "Column Count:", ["f"] = SW_SetSliderPreText },
	["SW_OptChk_NumText"] = "Amount",
	["SW_OptChk_RankText"] = "Rank",
	["SW_OptChk_PercentText"] = "%",
	["SW_VarInfoLbl"] = "This info needs a target. Click Change to type in a name or click FromTarget to use your current target.",
	["SW_NoPetInfoLabel"] = "This info does not have any pet filter settings.",
	["SW_SetInfoVarFromTarget"] = {["s"] = "FromTarget", ["f"] = SetButtonText },
	["SW_ColorsOptUseClassText"] = "Class color",
	["SW_TextWindow_Title_Text"] = "Use Ctrl+c to copy.",
	["SW_BarSyncFrame_SyncARPY"] = {["s"] = "Allow", ["f"] = SetButtonText },
	["SW_BarSyncFrame_SyncARPN"] = {["s"] = "Prohibit", ["f"] = SetButtonText },
	-- 1.5 new pet filter labels 
	["SW_PF_InactiveText"] = "Inactive",
	["SW_PF_ActiveText"] = "Active",
	["SW_PF_MMText"] = "Merge made",
	["SW_PF_MRText"] = "Merge recieved",
	["SW_PF_MBText"] = "Merge both",
	["SW_PF_CurrentText"] = "Current",
	["SW_PF_VPPText"] = "Virtual player pet",
	["SW_PF_VPRText"] = "Virtual raid pet",
	["SW_PF_IgnoreText"] = "Ignore all pet info",
	
	-- 1.5.3 new colors
	["SW_CS_TitleBar"] =  {["s"] = "Title Bar Color", ["f"] = SW_SetColorSwatchText },
	["SW_CS_TitleFont"] =  {["s"] = "Title Bar Font Color", ["f"] = SW_SetColorSwatchText },
	["SW_CS_Backdrops"] =  {["s"] = "Frame and Tab Color", ["f"] = SW_SetColorSwatchText },
	["SW_CS_MainWinBack"] =  {["s"] = "Main Window Back", ["f"] = SW_SetColorSwatchText },
	["SW_CS_ClassCAlpha"] = {["s"] = "Class Transparency", ["f"] = SW_SetColorSwatchText },
	
	-- 2.0 gui strings
	["SW_Chk_TL_SafeModeText"] = "Safe Mode",
	["SW_Chk_TL_SingleSelectText"] = "Single Select",
	["SW_TL_Merge"] = {["s"] = "Merge", ["f"] = SetButtonText },
	["SW_TL_Select"] = {["s"] = "Recalc", ["f"] = SetButtonText },
	["SW_TL_ReloadUI"] = {["s"] = "ReloadUI", ["f"] = SetButtonText },
	["SW_TL_Nuke"] = {["s"] = "Nuke", ["f"] = SetButtonText },
	["SW_HealOpt_EffText"] = "Effective",
	["SW_HealOpt_OHText"] = "Overheal",
	["SW_HealOpt_IFText"] = "In fight",
	
	["SW_TimeLine_Title_Text"] = "Timeline",
	["SW_BarSyncFrame_InfoText"] = "This will seem to be empty unless you are in a group/raid";
	
	--2.0.beta.2
	["SW_Chk_TL_AutoZoneText"] = "AutoZone",
	--2.0.beta.3
	["SW_AutoVoteYesText"] = "Auto vote:Yes",
	["SW_AutoVoteNoText"] = "Auto vote:No",
	
	["SW_Chk_TL_AutoDeleteText"] = "Auto delete",
	--[[ removed in 2.0
	["SW_Chk_MergePetsText"] = "Merge Pet to Master",

	["SW_BarSyncFrame_SyncLeave"] =  {["s"] = "Leave", ["f"] = SetButtonText },
	["SW_BarSyncFrame_OptGroupText"] = "Group",
	["SW_BarSyncFrame_OptRaidText"] = "Raid",
	["SW_BarSyncFrame_OptGuildText"] = "Guild",
	["SW_BarSyncFrame_SyncSend"] =  {["s"] = "Send to", ["f"] = SetButtonText },
	--]]
	-- 2.0.3 
	["SW_TargetSelector_Title_Text"] = "Choose Target...",
	["SW_Chk_NS_AllText"] = "All",
	["SW_Chk_NS_PCText"] = "PC",
	["SW_Chk_NS_NPCText"] = "NPC",
	["SW_Chk_NS_EVERGROUPText"] = "Ever Group",
	
};

--tooltips
SW_GS_Tooltips ={
	["SW_Chk_ShowTLB"] = "Option to show an extra button for the timeline settings in the title bar of the main window.",
	--["SW_Chk_ShowOnlyFriends"] = "This option is only used to filter reports sent to the console via /sws slash commands.",
	["SW_Chk_ShowSyncB"] = "Option to show an extra button for Sync settings in the title bar of the main window.",
	["SW_Chk_ShowConsoleB"] = "Option to show an extra button for the console in the title bar of the main window.",
	["SW_CS_Damage"] = "The bar color for 'damage bars'. E.g. used when looking at details.",
	["SW_CS_Heal"] = "The bar color for 'heal bars'. E.g. used when looking at details.",
	["SW_CS_BarC"] = "The bar color used in this view. This might be overridden depending on the data displayed.",
	["SW_CS_FontC"] = "The font color used in this view.",
	["SW_CS_OptC"] = "Changes the color of the button under the main window.",
	["SW_TextureSlider"] = "Changes the texture of the bars for this view", 
	["SW_FontSizeSlider"] = "Changes the font size used in the bars for this view",
	["SW_BarHeightSlider"] = "Changes the bar height for this view",
	--["SW_BarWidthSlider"] = "Changes the bar width for this view",
	["SW_ColCountSlider"] = "Changes the amount of columns for this view.",
	["SW_SetOptTxtFrame"] = "Changes the text displayed in the button under the main window.",
	["SW_SetFrameTxtFrame"] = "Changes the text displayed in the titel of the main window.",
	["SW_OptChk_Num"] = "Show the 'raw' number counted in points. (E.g. damage, heal, etc.).",
	["SW_OptChk_Rank"] = "Show the rank.",
	["SW_OptChk_Percent"] = "Show the percentage. (Percentage of the total amount of 'raw' numbers in the raid.)",
	["SW_Filter_None"] = "No pc/npc/group filter is used. All gathered data is shown in the bars",
	["SW_Filter_PC"] = "A Player char filter is used. This only works if somebody was in your group or if you had him as target once.",
	["SW_Filter_NPC"] = "A Non player char filter is used, you must have targeted it once , and it may not be player controlled.",
	["SW_Filter_Group"] = "Only people and pets currently in your group or raid are shown.",
	["SW_Filter_EverGroup"] = "Only people that have been in your group or raid are shown.",
	["SW_ClassFilterSlider"] = "Here you can set a class filter. Only data of the specified class is shown. (You must have selected them once or they must have been in your group/raid)",
	["SW_InfoTypeSlider"] = "The 'main' data selector. Select what kind of data you want to display for this tab. A (S) denotes that this setting is synced.",
	["SW_ColorsOptUseClass"] = "Use class colors. If this option is checked then the bars will be colored by the class of the player. (Overrides above bar color if the class of the player or mob is known) ",
	["SW_Chk_ShowDPS"] = "Show your DPS in the main window title?",
	["SW_OptCountSlider"] = "Changes the amount of buttons to show under the main window.",
	["SW_AllowARP"] = "Allow posting of reports in a raid.",
	["SW_DisAllowARP"] = "Prohibit posting of reports in a raid.",
	["SW_OptChk_Running"] = "Uncheck to pause data collection. Check to continue collecting data. You can not pause data collection while being in a sync channel.",
	-- 1.5 new pet filter Tooltips
	["SW_PF_Inactive"] = "The new pet filters are mostly inactive, pets will display like everything else.";
	["SW_PF_Active"] = "Pets are marked with "..SW_STR_PET_PREFIX.." and mindcontrolled / enslaved pets and players show up. Only the stats WHILE being possessd are counted. (Own players when mind controlled by a hostile mob will not show up, only controlled mobs of players in your group/raid)",
	["SW_PF_MM"] = "Pets are hidden and the damage/healing they made is added to the owner.",
	["SW_PF_MR"] = "Pets are hidden and the damage/healing they recieved is added to the owner.",
	["SW_PF_MB"] = "Pets are hidden and the damage/healing they made AND recieved is added to the owner.",
	["SW_PF_Current"] = "Similar to Active, but only currently owned pets are shown.",
	["SW_PF_VPP"] = "All pets a player had are merged to one pet.",
	["SW_PF_VPR"] = "All pets the entire raid / group had are merged to one pet.",
	["SW_PF_Ignore"] = "All pet info is ignored.",
	
	-- 1.5.3 new colors
	["SW_CS_TitleBar"] =  "This changes the color of all title bars and the buttons in them. This MAY (depending on settings) change the color of buttons under the main window.",
	["SW_CS_TitleFont"] =  "This changes the color of all title bar fonts and the button fonts in them.",
	["SW_CS_Backdrops"] =  "This changes the color of the frame around most windows. Tab color will be changed aswell, but alpha channel wil be ignored for tabs.",
	["SW_CS_MainWinBack"] = "This changes the backround of the main window.",
	["SW_CS_ClassCAlpha"] = "Only the alpha channel set here will be used for class coloring.",
	
	-- 2.0 Gui tooltips
	["SW_Chk_TL_SafeMode"] = "If this is checked you will be promted if you really want to delete or merge markers.",
	["SW_Chk_TL_SingleSelect"] = "If this is checked you can merge non consecutive data segements. Using Recalc will still use the entire range.",
	["SW_HealOpt_Eff"] = "If this is checked overheal is subtracted.",
	["SW_HealOpt_OH"] = "If this is checked overheal is displayed instead of healing.",
	["SW_HealOpt_IF"] = "If this is checked only healing/overhealing done in fight is considered",
	
	--2.0.beta.2
	["SW_Chk_TL_AutoZone"] = "If this is checked new segments will be created when zoning.",
	["SW_TL_ReloadUI"] = "To avoid \"duplicate data\" it is highly recommended only to reload if the active segment is empty (or you are not activly syncing)",
	
	["SW_AutoVoteYes"] = "If this is checked you will reply with Yes to all reset votes.",
	["SW_AutoVoteNo"] = "If this is checked you will reply with No to all reset votes.",
	["SW_Chk_TL_AutoDelete"] = "If this is checked all segements older than "..SW_TL_AUTO_THRESH.."h are deleted automatically.",
};

-- edit boxes
SW_GS_EditBoxes = {
	["SW_SetOptTxtFrame"] = {"Change","Button Text: ", "New button text:" },
	["SW_SetFrameTxtFrame"] = {"Change","Frame Text: ", "New frame text:" },
	["SW_SetInfoVarTxtFrame"] = {"Change","Info for: ", "New name of player or mob:" },
	["SW_SetSyncChanTxtFrame"] = {"Change","SyncChannel: ", "New SyncChannel:" },
}

--Popups
-- 2.0 beta.5 added a warning for large data sets
StaticPopupDialogs["SW_Mem_Warning"] = {
	text = "SW Stats is storing a large amount of data. Be sure to nuke your data from time to time.\r\n (There is a button to do this in the timeline)",
	button1 = OKAY,
	
	timeout = 0,
	whileDead = 1,
	hideOnEscape = 1,
};

StaticPopupDialogs["SW_TL_Delete"] = {
	text = "Are you sure you want to delete this segment?\r\n %s",
	button1 = YES,
	button2 = NO,
	OnAccept = function(ID)
		SW_DataCollection:deleteSegment(ID);
	end,
	timeout = 0,
	whileDead = 1,
	hideOnEscape = 1,
};
StaticPopupDialogs["SW_TL_Nuke"] = {
	text = "Are you sure you want nuke all data?",
	button1 = YES,
	button2 = NO,
	OnAccept = function()
		SW_NukeDataCollection();
	end,
	timeout = 0,
	whileDead = 1,
	hideOnEscape = 1,
};
StaticPopupDialogs["SW_TL_Merge"] = {
	text = "Are you sure you want to merge the selected data segments?",
	button1 = YES,
	button2 = NO,
	OnAccept = function()
		SW_DataCollection:mergeSelected();
	end,
	timeout = 0,
	whileDead = 1,
	hideOnEscape = 1,
};
StaticPopupDialogs["SW_Reset"] = {
	text = "Are you sure you want to create a new segment?",
	button1 = YES,
	button2 = NO,
	OnAccept = function(self)
		SW_ResetInfo(StaticPopupDialogs.SW_Reset.SW_SegmentName);
	end,
	timeout = 0,
	whileDead = 1,
	hideOnEscape = 1,
};

StaticPopupDialogs["SW_ResetSync"] = {
	text = "You are in a SyncChannel and will create a new segment for all people syncing! Are you sure you want to reset the data?",
	button1 = YES,
	button2 = NO,
	OnAccept = function()
		SW_SendSyncReset(StaticPopupDialogs.SW_ResetSync.SW_SegmentName);
	end,
	timeout = 0,
	whileDead = 1,
	hideOnEscape = 1,
};

StaticPopupDialogs["SW_ResetSyncVote"] = {
	text = "TMP No need to translate (SW_STR_RV)",
	button1 = YES,
	button2 = NO,
	OnAccept = function()
		SW_ResetVote:issueVote(true);
	end,
	OnCancel = function (_,reason)
      if reason == "clicked" then
          SW_ResetVote:issueVote(false);
      end
	end,
	
	timeout = 0,
	whileDead = 1,
	hideOnEscape = false,
};

StaticPopupDialogs["SW_JoinCheck"] = {
	text = "JoinChk",
	button1 = YES,
	button2 = NO,
	OnAccept = function()
		SW_SyncJoin(StaticPopupDialogs["SW_JoinCheck"].SW_toChan);
	end,
	timeout = 0,
	whileDead = 1,
	hideOnEscape = 1,
};

StaticPopupDialogs["SW_ResetFailInfo"] = {
	text = "You are in a SyncChannel and can not reset the data. Only the raid/group leaders can issue a reset for the SyncChannel. With '"..SW_RootSlashes[1].." rv' you can start a reset vote.",
	button1 = OKAY,
	
	timeout = 0,
	whileDead = 1,
	hideOnEscape = 1,
};

StaticPopupDialogs["SW_PostFail"] = {
	text = "Sorry, you can't report here. The Raid leaders must allow to post stats for you to do this",
	button1 = OKAY,
	
	timeout = 0,
	whileDead = 1,
	hideOnEscape = 1,
};
StaticPopupDialogs["SW_ChangeTxt"] = {
	text = "Tmp",
	button1 = ACCEPT,
	button2 = CANCEL,
	hasEditBox = 1,
	maxLetters = 30,
	OnAccept = function()
		
		local text = getglobal(this:GetParent():GetName().."EditBox"):GetText();
		StaticPopupDialogs["SW_ChangeTxt"]["SWCallingFrame"].CurrentVal=text;
		StaticPopupDialogs["SW_ChangeTxt"]["SWCallingFrame"]:ChangeText();
		StaticPopupDialogs["SW_ChangeTxt"]["SWUpdateFunc"](text, StaticPopupDialogs["SW_ChangeTxt"]["SWUpdateInfo"]);
		StaticPopupDialogs["SW_ChangeTxt"].SW_IsVis = false;
	end,
	EditBoxOnEnterPressed = function()
		local text = getglobal(this:GetParent():GetName().."EditBox"):GetText();
		StaticPopupDialogs["SW_ChangeTxt"]["SWCallingFrame"].CurrentVal=text;
		StaticPopupDialogs["SW_ChangeTxt"]["SWCallingFrame"]:ChangeText();
		StaticPopupDialogs["SW_ChangeTxt"]["SWUpdateFunc"](text, StaticPopupDialogs["SW_ChangeTxt"]["SWUpdateInfo"]);
	end,
	OnShow = function()
		local eb = getglobal(this:GetName().."EditBox");
		eb:SetText(StaticPopupDialogs["SW_ChangeTxt"]["SWCallingFrame"].CurrentVal);
		eb:HighlightText();
		eb:SetFocus();
		StaticPopupDialogs["SW_ChangeTxt"].SW_IsVis = true;
	end,
	OnHide = function()
		if ( ChatFrameEditBox:IsVisible() ) then
			ChatFrameEditBox:SetFocus();
		end
		
		getglobal(this:GetName().."EditBox"):SetText("");
		
		StaticPopupDialogs["SW_ChangeTxt"]["SWUpdateFunc"] = nil;
		StaticPopupDialogs["SW_ChangeTxt"]["SWUpdateInfo"] = nil;
		StaticPopupDialogs["SW_ChangeTxt"]["SWCallingFrame"] = nil;
		StaticPopupDialogs["SW_ChangeTxt"].SW_IsVis = false;
	end,
	timeout = 0,
	exclusive = 1,
	hideOnEscape = 1
};
StaticPopupDialogs["SW_InvalidChan"] = {
	text = "Sorry, this is an invalid channel name.",
	button1 = OKAY,
	
	timeout = 0,
	whileDead = 1,
	hideOnEscape = 1,
};

--icon menu
SW_MiniIconMenu = {
	{ 
		["text"] = "SW Stats",
		["isTitle"] = 1,
		["justifyH"] = "CENTER",
		["notCheckable"] = 1,
	},
	{ 
		["textShow"] = "Show Main Window",
		["textHide"] = "Hide Main Window",
		["checkFrame"] = "SW_BarFrame1",
		["func"] = SW_ToggleBarFrame,
		["notCheckable"] = 1,
	},
	{ 
		["textShow"] = "Show Console",
		["textHide"] = "Hide Console",
		["checkFrame"] = "SW_FrameConsole",
		["func"] = SW_ToggleConsole,
		["notCheckable"] = 1,
	},
	{ 
		["textShow"] = "Show General Settings",
		["textHide"] = "Hide General Settings",
		["checkFrame"] = "SW_GeneralSettings",
		["func"] = SW_ToggleGeneralSettings,
		["notCheckable"] = 1,
	},
	{ 
		["textShow"] = "Show Sync Settings",
		["textHide"] = "Hide Sync Settings",
		["checkFrame"] = "SW_BarSyncFrame",
		["func"] = SW_ToggleSync,
		["notCheckable"] = 1,
	},
	{ 
		["textShow"] = "Show Timeline",
		["textHide"] = "Hide Timeline",
		["checkFrame"] = "SW_TimeLine",
		["func"] = SW_ToggleTL,
		["notCheckable"] = 1,
	},
	{ 
		["text"] = "",
		["notCheckable"] = 1,
		["notClickable"] = 1,
	},
	{ 
		["text"] = "Reset Data",
		["func"] = SW_ResetCheck,
		["notCheckable"] = 1,
	},
}
-- key bindig strings
BINDING_HEADER_SW_BINDINGS = "SW Stats";
BINDING_NAME_SW_BIND_TOGGLEBARS = "Show/Hide the main window.";
BINDING_NAME_SW_BIND_CONSOLE = "Show/Hide the console.";
BINDING_NAME_SW_BIND_PAGE1 = "Show info tab 1";
BINDING_NAME_SW_BIND_PAGE2 = "Show info tab 2";
BINDING_NAME_SW_BIND_PAGE3 = "Show info tab 3";
BINDING_NAME_SW_BIND_PAGE4 = "Show info tab 4";
BINDING_NAME_SW_BIND_PAGE5 = "Show info tab 5";
BINDING_NAME_SW_BIND_PAGE6 = "Show info tab 6";
BINDING_NAME_SW_BIND_PAGE7 = "Show info tab 7";
BINDING_NAME_SW_BIND_PAGE8 = "Show info tab 8";
BINDING_NAME_SW_BIND_PAGE9 = "Show info tab 9";
BINDING_NAME_SW_BIND_PAGE10 = "Show info tab 10";
BINDING_NAME_SW_BIND_PAGENEXT ="Next info tab";
BINDING_NAME_SW_BIND_PAGEPREV ="Previous info tab";
BINDING_NAME_SW_BIND_SELECTTARGET = "Use target for Info";
BINDING_NAME_SW_BIND_COPYBUTTON = "Copies the settings of your current button";
BINDING_NAME_SW_BIND_PASTEBUTTON = "Applies the copied settings to the current button";
local SW_SLASH_ERROR = "WTF!! I TOLD YOU NOT TO TOUCH neutral.lua";  -- not used just another reminder :P

--dont localize this, must be the same through all languages
-- not needed in 2.0
--SW_SYNC_CHAN_ANNOUNCE = "SW Stats SyncChannel (v1.5+):%s"
--SW_SYNC_CHAN_REGEX = "^SW Stats SyncChannel %(v1%.5%+%):(.+)"

-- barframe class filter
-- dont localize
SW_ClassFilters = {
[1] = "NONE",
[2] = "DRUID",
[3] = "HUNTER",
[4] = "MAGE",
[5] = "PALADIN",
[6] = "PRIEST",
[7] = "ROGUE",
[8] = "SHAMAN",
[9] = "WARLOCK",
[10] = "WARRIOR",
};

--default Vals for "BarFrames"
SW_DefaultBar = {
	["IN"] = 1, -- Info type
	--["BW"] = 128, --bar width 1.4.2 removed
	["COLC"] = 1; -- columnCount
	["BH"] = 10,  -- bar height
	["BC"] = {0,0.8,0,1}, -- bar vertex color
	["BT"] = 3, -- bar texture num
	["BFC"] = {1,1,1,1}; -- bar font color
	["BFS"] = 10, -- bar font height
	["OC"] = {1,0,0,1}; -- option button color
};
-- default color vars
SW_Default_Colors = {
	["Damage"] = {1,0,0,1},
	["Heal"] = {0,1,0,1},
	["DRUID"] = {1, 0.49, 0.04, 1},
	["HUNTER"] = {0.66, 0.83, 0.45, 1},
	["MAGE"] = {0.41, 0.8, 0.94, 1},
	["PALADIN"] = {0.96, 0.55, 0.73, 1},
	["PRIEST"] = {0.8, 0.8, 0.8, 1},
	["ROGUE"] = {1, 0.96, 0.41, 1},
	["SHAMAN"] = {0.96, 0.55, 0.73, 1},
	["WARLOCK"] = {0.58, 0.51, 0.79, 1},
	["WARRIOR"] = {0.78, 0.61, 0.43, 1},
};

function SW_GetSpellList()
	local sOut = "";
	for i,v in ipairs(SW_Spellnames) do
		if i < 11 then 
			sOut = sOut..v.."; "
		else
			break;
		end
	end
	return sOut;
end
-- Names and functions for available analysis
-- 2.0  ["displayType"] used for now 1 = unit 2= skill 3= schoolDone 4=schoolRecieved = 5= other
SW_InfoTypes = {
	[1] = {
		["f"] = SW_2_GetDmgInfo,
		["t"] = "Damage Done (S)",
		["synced"] = 1,
		["d"] = "Shows a simple damage list.",
		["cc"] = 1,
		["hasPF"] = true,
		["displayType"] = 1,
	},
	[2] = {
		["f"] = SW_2_GetHealInfo,
		["t"] = "Healing Done(S)",
		["synced"] = 1,
		["d"] = "Shows a simple heal list. Different options for Overheal \"in fight\" etc. can be set below.",
		["cc"] = 1,
		["hasPF"] = true,
		["displayType"] = 1,
		["isHeal"] = true,
	},
	[3] = {
		["f"] = SW_2_GetDmgGotInfo,
		["t"] = "Damage Taken (S)",
		["synced"] = 1,
		["d"] = "Shows a list of the damage recieved. (Who got the most damage?)",
		["hasPF"] = true,
		["displayType"] = 1,
	},
	[4] = {
		["f"] = SW_2_GetHealGotInfo,
		["t"] = "Healing Taken (S)",
		["synced"] = 1,
		["d"] = "Shows a list of healed targets. (Who got the most healing?) Different options for Overheal \"in fight\" etc. can be set below.",
		["hasPF"] = true,
		["displayType"] = 1,
		["isHeal"] = true,
	},
	[5] = {
		["f"] = SW_2_GetHealInfoHealer,
		["t"] = "Healing Breakdown (NotS)",
		["varType"] = "TEXTTARGET",
		["d"] = "Shows detail healing info. (Who did this person heal?)",
		["displayType"] = 1,
		["isHeal"] = true,
	},
	[6] = {
		["f"] = SW_2_GetHealInfoTarget,
		["t"] = "Healing Info (NotS)",
		["varType"] = "TARGETTEXT",
		["d"] = "Shows detail healing info for target. (Who was this person healed by?)",
		["displayType"] = 1,
		["isHeal"] = true,
	},
	[7] = {
		["f"] = SW_2_GetDetails,
		["t"] = "Skill Details (NotS)",
		["varType"] = "TEXT",
		["d"] = "Shows detail skill info. (What skills is this person using?)",
		["displayType"] = 2,
	},
	[8] = {
		["f"] = SW_2_GetDetailsPerTick,
		["t"] = "Average Effects (NotS)",
		["varType"] = "TEXT",
		["d"] = "Shows averaged skill info. (What's that persons average damage with frostbolt?) ",
		["displayType"] = 2,
	},
	[9] = {
		["f"] = SW_2_GetSchoolMade,
		["t"] = "Damage Type (NotS)",
		["varType"] = "TEXT",
		["d"] = "Shows school info. (What's the main part of this players damage? E.g. fire, ice, etc.)",
		["displayType"] = 3,
	},
	[10] = {
		["f"] = SW_2_GetSchoolGot,
		["t"] = "Damage Taken Type (NotS)",
		["varType"] = "TEXT",
		["d"] = "Shows school info recieved. (Whats the main source of damage to this player? E.g. fire, ice, etc.)",
		["displayType"] = 4,
	},
	[11] = {
		["f"] = SW_2_GetSchoolMadeSummary,
		["t"] = "Damage Done Summary (NotS)",
		["d"] = "Shows school info. (What's the main part of the raid damage? E.g. fire, ice, etc.) Note: Make sure to use filters.",
		["displayType"] = 3,
	},
	[12] = {
		["f"] = SW_2_GetSchoolGotSummary,
		["t"] = "Damage Taken Summary (NotS)",
		["d"] = "Shows school info recieved. (What's the main part the raid was damaged by? E.g. fire, ice, etc.) Note: Make sure to use filters.",
		["displayType"] = 4,
	},
	--[[
	[13] = {
		["f"] = SW_GetOverHealInfo,
		["t"] = "Over-Healing (S)",
		["synced"] = 1,
		["d"] = "Shows overheal info. The percentage next to the name is his OH%, If you use the % option above that percentage is his portion of the total raid overheal.",
		["displayType"] = 1,
	},
	[14] = {
		["f"] = SW_GetEffectiveHealInfo,
		["t"] = "Effective Healing (S)",
		["synced"] = 1,
		["d"] = "Shows the heal list. Overheals are SUBTRACTED giving you a 'real' heal list.",
		["displayType"] = 1,
	},
	-]]
	[13] = {
		["f"] = SW_2_GetManaRatio,
		["t"] = "Mana Efficiency",
		["varType"] = "SELF",
		["d"] = "Shows the amount of damage/healing per manapoint. A higher number indicates a higher mana efficiency (This ONLY works for yourself)",
		["displayType"] = 2,
	},
	--[[
	[16] = {
		["f"] = SW_GetEffectiveHealManaInfo,
		["t"] = "Healing Mana Efficiency (S)",
		["synced"] = 1,
		["d"] = "To compare people that aren't in the SyncChannel use other infos to compare healing. A ratio of 2 means: 1 mana used to heal 2 points. (Higher values are better)",
		["displayType"] = 1,
	},
	--]]
	[14] = {
		["f"] = SW_2_GetDeathInfo,
		["t"] = "Death Counter (S)",
		["synced"] = 1,
		["d"] = "How often did somebody or something die? This counts all deaths not just the ones you killed!",
		["displayType"] = 1,
	},
	--[[
	[18] = {
		["f"] = SW_GetDamageManaInfo,
		["t"] = "Damage Mana Efficiency (S)",
		["synced"] = 1,
		["d"] = "To compare people that aren't in the SyncChannel use other infos to compare damage. A ratio of 2 means: 1 mana used to make 2 points of damage. (Higher values are better)",
		["displayType"] = 1,
	},
	--]]
	[15] = {
		["f"] = SW_2_DecurseCountInfo,
		["t"] = "Decurse Count (S)",
		["d"] = "How often did somebody 'decurse'?:"..SW_GetSpellList(),
		["displayType"] = 1,
	},
	[16] = {
		["f"] = SW_2_DecurseGotCountInfo,
		["t"] = "Decurse Count Recieved(S)",
		["d"] = "How often has somebody been 'decursed'?:"..SW_GetSpellList(),
		["displayType"] = 1,
	},
	[17] = {
		["f"] = SW_2_GetDmgInfoDPS,
		["t"] = "Effective DPS(S)",
		["d"] = "This may differ from personal DPS info. The timer used for 'in fight' is the time the RAID has been in fight. (You should be doing something while the raid is, and if people kill rats, blame them not me)",
		["displayType"] = 1,
		["hasPF"] = true,
	},
	[18] = {
		["f"] = SW_2_GetDmgInfoDPSGot,
		["t"] = "Incoming DPS(S)",
		["d"] = "How much damage is done to the target per second. NOTE: This is thought to check DPS your raid does to various mobs (use the NPC filter)",
		["displayType"] = 1,
	},
	[19] = {
		["f"] = SW_2_GetHPS_InfEff,
		["t"] = "Effective HPS(S)",
		["d"] = "Like a DPS list, but for healing. This uses in fight effective healing.",
		["displayType"] = 1,
	},
	
	--[[
	[20] = {
		["f"] = SW_PowerGainInfo,
		["t"] = "Power gain (NotS)",
		["varType"] = "TEXT",
		["d"] = "This is EXPERIMENTAL, it just counts the # of powergains and non damage/heal events (not sure if this will show procs that don't heal or do dmg)",
		["displayType"] = 5,
	},
	[21] = {
		["f"] = SW_GetRaidPS,
		["t"] = "Raid Info per Second (S)",
		["varType"] = "SELF",
		["d"] = "Show various DPS values for the entire raid/group. If you are alone these values are slightly different to the DPS value you can display in the title bar. (In combat time is calculated differently)",
		["displayType"] = 5,
	},
	--]]
	[20] = {
		["f"] = SW_2_GetMaxHit,
		["t"] = "Max Hit List (NotS)",
		["d"] = "Shows the maximum damage made per hit / per person. (Max crit list)",
		["displayType"] = 1,
	},
	[21] = {
		["f"] = SW_2_GetMaxHeal,
		["t"] = "Max Heal List (NotS)",
		["d"] = "Shows the maximum heal done per spell / per person. (This does not factor in OH - It's a max crit list)",
		["displayType"] = 1,
	},
	
	[22] = {
		["f"] = SW_2_GetApproxResit,
		["t"] = "Approximated Resist (NotS)",
		["d"] = "Shows the approximated damge resisted% for the selected school.",
		["displayType"] = 1,
		["hasSchoolDD"] = true,
	},
	[23] = {
		["f"] = SW_2_GetDamageInfoTarget,
		["t"] = "Damage to target (NotS)",
		["d"] = "Damage to target (Who did damage to this target)",
		["varType"] = "TARGETTEXT",
		["displayType"] = 1,
	},
	[24] = {
		["f"] = SW_2_GetDamageBreakdownTarget,
		["t"] = "Damage Breakdown (NotS)",
		["d"] = "Damage Breakdown (Who did this target damage)",
		["varType"] = "TEXTTARGET",
		["displayType"] = 1,
	},
	[25] = {
		["f"] = SW_2_GetDmgScrappedInfo,
		["t"] = "Inner group/raid Damage (S)",
		["d"] = "Shows all damage done from people in the group or raid to other people in the group or raid. ('Bombs', Gruul's Shatter, MC'd people etc.)",
		["hasPF"] = true,
		["displayType"] = 1,
	},
	--[[
	[24] = {
		["f"] = SW_GetTopDmgDelta,
		["t"] = "Top Damage Interval(S)",
		["varType"] = "SELF",
		["d"] = "This only works with people in a SyncChannel. It shows the maximum increase in damage the player reported (for himself) in a 5 second interval.",
		["displayType"] = 1,
	},
	[25] = {
		["f"] = SW_GetTopHealDelta,
		["t"] = "Top Heal Interval (S)",
		["varType"] = "SELF",
		["d"] = "This only works with people in a SyncChannel. It shows the maximum increase in healing the player reported (for himself) in a 5 second interval.",
		["displayType"] = 1,
	},
	--]]
	--[[ added and removed in 1.5.3.beta 1 the behavior is not "natural"
		people joining late will still be measured mit total raid time
	[26] = {
		["f"] = SW_GetDmgInfoDPS,
		["t"] = "DPS Per Player (S)",
		["varType"] = "PETONLY",
		["d"] = "This may differ from personal DPS info. The timer used for 'in fight' is the time the RAID has been in fight. (You should be doing something while the raid is, and if people kill rats, blame them not me)",
		["hasPF"] = true,
	},
	--]]
}

--[[  2.0.beta.1 currently not working at all

SW_checkSIOI
	SW_checkSINeeded
	1.5.3.beta.1
	Added the above two Delta vals as standard info already because they are interesting if you aren't looking for cheaters.
	
	For those reading code - im not ready with this, but I want to add a "sanity check" for numbers
	that come through the sync channel
	Essentially it's a cheat protection measure
	Under normal circumstance:
	-on average only a certain percent (on average) will be needed for SI msgs
	if the percentage is to high this person is most likely using a personal dmg/heal modifier
	- once things "setteled" in the sync channel very few SIOI msgs are needed
	if somebody is spamming these he most likely is using a "global" dmg/heal modifier
	(add dmg to my guildies)
	
	It's not bad to have high numbers here the question is how they compare to others in sync
	
	If you want to use this already - i discuourage it, I havent been able to check myself whats "normal"
	Eg in certain encounters where you HAVE to split up, needed will be higher
	In encounters where all should be cuddeled up in one spot needed should be very low
	on average though, it should level out again
	
	But, if one person shows up very high on both lists this is VERY suspicious
	
	All in all the basic idea is that every client in sync will try to identify unnormal data
	for full msg track info do
	/script SW_DumpTable(SW_Sync_MsgTrack) - that works even with the following funcs disabeled
	
	And BTW it sucks mokey balls i even have to do this, cause people go through lengths to enlarge their epeen

function SW_SYNCCHECK()
	return SW_checkSIOI();
end
function SW_SYNCCHECKNEEDED()
	return SW_checkSINeeded();
end
table.insert(SW_InfoTypes, {["f"] = SW_SYNCCHECK,
		["t"] = "SIOICheck",
		["varType"] = "SELF",
		["d"] = "For now this is just for DEV - Checks how often somebody triggered an SIOI",
});
table.insert(SW_InfoTypes, {["f"] = SW_SYNCCHECKNEEDED,
		["t"] = "SI Needed Check",
		["varType"] = "SELF",
		["d"] = "For now this is just for DEV - Checks how many SI where really needed",
});
--]]
SW_SlashCommands = {
	["help"] = {	["c"] = "?",
					["si"] = "Show console help.",
					["aC"] = 0,
					["f"] = SW_PrintHelp, 
	},
	["console"] = {	["c"] = "con",
					["si"] = "Brings up the SW Stats console",
					["aC"] = 0,
					["f"] = SW_ToggleConsole, 
	},
	["dumpVar"] = {	["c"] = "dump",
					["si"] = "dumps a var",
					["u"] = "Usage:"..SW_RootSlashes[1].." dump nameOfVar",
					["aC"] = 1,
					["f"] = SW_DumpVar, 
	},
	["mmicon"] = {
					["c"] = "icon",
					["si"] = "Shows or hides the minimap icon",
					["aC"] = 0,
					["f"] = SW_ToggleMMIcon,
	},
	["reset"] = {	["c"] = "reset",
					["si"] = "Creates a new data segment. If you don't supply a segment name it will be \""..SW_DS_RESET.."\".",
					["u"] = "Usage:"..SW_RootSlashes[1].." reset [The name of the segment]",
					["aC"] = -1, -- 2.0.beta 2 added negative numbers as an idicator that they are optional
					["f"] = SW_ResetCheck, 
	},
	["toggleBars"]={["c"] = "bars",
					["si"] = "Shows or hides the main window.",
					["aC"] = 0,
					["f"] = SW_ToggleBarFrame, 
	},
	["toggleGS"] = {["c"] = "gs",
					["si"] = "Shows or hides the General Settings.",
					["aC"] = 0,
					["f"] = SW_ToggleGeneralSettings, 
	},
	["resetWindows"] = {["c"] = "resetwin",
					["si"] = "Resets the position of all windows.",
					["aC"] = 0,
					["f"] = SW_ResetAllWindows, 
	},
	["lockFrame"] = {["c"] = "tlock",
					["si"] = "Locks or unlocks the windows.",
					["aC"] = 0,
					["f"] = SW_ToggleLocks, 
	},
	["nukeDS"] = {["c"] = "nuke",
					["si"] = "This REALLY delets all data collected.",
					["aC"] = 0,
					["f"] = SW_ShowNukeDialog, 
	},
	["resetVote"]={ ["c"] = "rv",
					["si"] = "Starts a vote to reset the SyncChannel. If you don't supply a segment name it will be \""..SW_DS_RESET.."\".",
					["u"] = "Usage:"..SW_RootSlashes[1].." rv [The name of the segment]",
					["aC"] = -1,
					["f"]= SW_InitResetVote,
	},
	["hideResize"] = {
					["c"] = "resizer",
					["si"] = "Shows or hides the resizer in the main window",
					["aC"] = 0,
					["f"] = SW_ToggleResizer,
	},
	["loadProfiles"] = {
					["c"] = "profiles",
					["si"] = "Loads the profile addon",
					["aC"] = 0,
					["f"] = SW_LoadProfiles,
	},
	["toggleNarrowData"] = {
					["c"] = "nd",
					["si"] = "Turns NarrowData on/off (On = Stores less data, only relevant to your group. Off = stores more data e.g. mobs healing themselves, other people fighting near you, duels etc.",
					["aC"] = 0,
					["f"] = SW_ToggleNarrowData,
	},
	["optLayout"] = {
					["c"] = "ol",
					["si"] = "Switches the layout mode of the option buttons BOTTOM and RIGHT are valid options atm.",
					["u"] = "Usage:"..SW_RootSlashes[1].." ol RIGHT",
					["aC"] = 1,
					["f"] = SW_SetOptLayoutMode,
	},
	["versionCheck"] = {
					["c"] = "vc",
					["si"] = "Does a version check and reports the results to the console.",
					["aC"] = 0,
					["f"] = SW_DoVersionCheck,
	},
}

-- GFT = Good For Target
-- Y = yes N = no B= both (depends on target)
-- as of 1.5.1 im not using this info yet
SW_SpellTypes = {
	[1] = {
		["GFT"] = "Y",
	},
	[2] = {
		["GFT"] = "Y",
	},
	[3] = {
		["GFT"] = "B",
	},
	[4] = {
		["GFT"] = "Y",
	},
	[5] = {
		["GFT"] = "Y",
	},
	[6] = {
		["GFT"] = "Y",
	},
	[7] = {
		["GFT"] = "Y",
	},
	[8] = {
		["GFT"] = "Y",
	},
	[9] = {
		["GFT"] = "Y",
	},
	[10] = {
		["GFT"] = "N",
	},
	
};

-- 2.0 beta.6 trying to turn FixLogStrings off for zhTW and zhCN
--function SW_CheckFixLogStrings()
	--if not SW_FixLogStrings then
		---- sorry this would inject all sorts of junk into sync for non us versions.. it's acceptable there
		---- 2.0 beta.7 removed the zh clients again, they do have issues without the fix
		--if not (LOCALE_enGB or LOCALE_enUS) then
			--SW_SYNC_DO = false;
		--end
		--function SW_FixLogStrings(str)
			--return str;
		--end
	--end
	--if not SW_FixLogMakeUnique then
		--function SW_FixLogMakeUnique(str)
			--return str;
		--end
	--end
--end

function SW_mergeLocalization()
	
	local locInfo = SW_LocalizedCommands;
	
	if locInfo ~= nil then
		for k,v in pairs(SW_SlashCommands) do
			if locInfo[k] ~= nil then
				if locInfo[k]["c"] ~= nil then
					SW_SlashCommands[k]["c"] = locInfo[k]["c"];
				end
				if locInfo[k]["si"] ~= nil then
					SW_SlashCommands[k]["si"] = locInfo[k]["si"];
				end
				if locInfo[k]["u"] ~= nil then
					SW_SlashCommands[k]["u"] = locInfo[k]["u"];
				end
			end
		end
	end
	if SW_LocalizedGUI ~= nil then
		for k,v in pairs(SW_GUI) do
			if SW_LocalizedGUI[k] ~=nil then
				if type(SW_GUI[k]) == "table" then
					SW_GUI[k]["s"] = SW_LocalizedGUI[k];
				else
					SW_GUI[k] = SW_LocalizedGUI[k];
				end
			end
		end
	end
	
	-- k we are done merging dump the tables
	SW_LocalizedCommands = nil;
	SW_LocalizedGUI = nil;
end