--[[ SLDataText - Copyright (C) 2008 Jeff "Taffu" Fancher | Last Revision: 1.02 | License: GPL v3.0 ]]
--[[ Mail.lua - Revised: 04/01/2008 ]]

local SLDataText = LibStub("AceAddon-3.0"):GetAddon("SLDataText")
local Mail = SLDataText:NewModule("Mail", "AceEvent-3.0", "AceTimer-3.0", "AceConsole-3.0")
local SML = LibStub("LibSharedMedia-3.0")
local TBL = SML:List("font")
local L = LibStub("AceLocale-3.0"):GetLocale("SLDataText")
local MODNAME = "Mail"
local coreDB
local charDB
local soundfile = "Interface\\Addons\\SLDataText\\Sounds\\Mail.wav"

local db
local defaults = {
    profile = {
        hideMMIcon = true,
        showTotal = true,
        fontSize = 16,
        fontFace = "Arial Narrow",
        useCoreFace = true,
        useCoreSize = true,
        pos = { anchorPoint = "RIGHT", anchor = "UIParent", anchorFrom = "RIGHT", x = -100, y = -20 },
        justify = "RIGHT",
        suppTT = false,
        overrideCombatHide = false,
    },
}

local options = {
    mail = {
        name = L["Mail"],
        arg = MODNAME,
        type = "group",
        args = {
            desc = {
                order = 1,
                type = "description",
                name = L["Mail Desc"],
            },
            enabled = {
				order = 2,
				type = "toggle",
				name = L["Enable Mail"],
				get = function() return SLDataText:GetModuleEnabled(MODNAME) end,
				set = function(info, value) SLDataText:SetModuleEnabled(MODNAME, value) end,
			},
            overrideCombatHide = {
                order = 3,
                type = "toggle",
                name = L["Override Combat Hide"],
                get = function() return db.overrideCombatHide end,
                set = function() db.overrideCombatHide = not db.overrideCombatHide Mail:Refresh() end,
            },
            style = {
                order = 2,
                name = L["Style"],
                type = "group",
                args = {
                    showTotalDesc = {
                        order = 0,
                        type = "description",
                        name = L["Show Total Mail Desc"],
                    },
                    showTotal = {
                        order = 1,
                        type = "toggle",
                        name = L["Show Total"],
                        get = function() return db.showTotal end,
                        set = function() db.showTotal = not db.showTotal Mail:Refresh() end,
                    },
                    hideMMIconDesc = {
                        order = 2, 
                        type = "description",
                        name = L["HideMMIconDesc"],
                    },
                    hideMMIcon = {
                        order = 3,
                        type = "toggle",
                        name = L["Hide Minimap Icon"],
                        get = function() return db.hideMMIcon end,
                        set = function() db.hideMMIcon = not db.hideMMIcon Mail:Refresh() end,
                    },
                    suppTTDesc = {
                        order = 6,
                        type = "description",
                        name = L["suppTTDesc"],
                    },
                    suppTT = {
                        order = 7,
                        type = "toggle",
                        name = L["suppTT"],
                        get = function() return db.suppTT end,
                        set = function() db.suppTT = not db.suppTT Mail:Refresh() end,
                    },
                    useCoreDesc = {
                        order = 9,
                        type = "description",
                        name = L["Use Core Desc"],
                    },
                    useCoreFace = {
                        order = 10,
                        type = "toggle",
                        name = L["Use Core Font Face"],
                        get = function() return db.useCoreFace end,
                        set = function() db.useCoreFace = not db.useCoreFace Mail:Refresh() end,
                    },
                    useCoreSize = {
                        order = 11,
                        type = "toggle",
                        name = L["Use Core Font Size"],
                        get = function() return db.useCoreSize end,
                        set = function() db.useCoreSize = not db.useCoreSize Mail:Refresh() end,
                    },
                    useSelfDesc = {
                        order = 12,
                        type = "description",
                        name = L["Use Self Desc"],
                    },
                    fontFace = {
                        order = 13,
                        type = "select",
                        values = SML:List("font"),
                        name = L["Font Face"],
                        get = function()
                            for k, v in pairs(TBL) do
                                if db.fontFace == v then
                                    return k
                                end
                            end
                        end,
                        set = function(_, font)
                            db.fontFace = TBL[font]
                            font = SML:Fetch("font", TBL[font])
                            Mail:Refresh()
                        end,
                        disabled = function()
                            local istrue
                            if ( db.useCoreFace ) then istrue = true else istrue = false end
                            return istrue
                        end,
                    },
                    spacer = { order = 14, type = "description", name = "" },
                    fontSize = {
                        order = 15,
                        type = "range",
                        name = L["Font Size"],
                        min = 4, max = 36, step = 1,
                        get = function() return db.fontSize end,
                        set = function(_, value) db.fontSize = value Mail:Refresh() end,
                        disabled = function()
                            local istrue
                            if ( db.useCoreSize ) then istrue = true else istrue = false end
                            return istrue
                        end,
                    },
                },
            },
            position = {
                order = 3,
                type = "group",
                name = L["Position"],
                args = {
                    justifyDesc = {
                        order = 1,
                        type = "description",
                        name = L["Justify Desc"],
                    },
                    justify = {
                        order = 2,
                        type = "select",
                        values = SLDataText.JustTbl,
                        name = L["Set Justify"],
                        get = function() return db.justify end,
                        set = function(_, value) db.justify = value Mail:Refresh() end,
                    },
                    parentDesc = {
                        order = 3,
                        type = "description",
                        name = L["Parent Desc"],
                    },
                    parent = {
                        order = 4,
                        type = "input",
                        name = L["Parent Anchor"],
                        get = function() return db.pos.anchor end,
                        set = function(_, value) db.pos.anchor = value Mail:Refresh() end,
                    },
                    anchorFromDesc = {
                        order = 5,
                        type = "description",
                        name = L["Anchor From Desc"],
                    },
                    anchorFrom = {
                        order = 6,
                        type = "select",
                        values = SLDataText.PointTbl,
                        name = L["Anchor From"],
                        get = function() return db.pos.anchorFrom end,
                        set = function(_, value) db.pos.anchorFrom = value Mail:Refresh() end,
                    },
                    offsetDesc = { 
                        order = 7, 
                        type = "description", 
                        name = L["Offset Desc"],
                    },
                    posX = {
                        order = 8,
                        type = "input",
                        name = L["X Offset"],
                        get = function() return db.pos.x end,
                        set = function(_, value) db.pos.x = value Mail:Refresh() end,
                    },
                    spacer2 = { order = 9, type = "description", name = "" },
                    posY = {
                        order = 10,
                        type = "input",
                        name = L["Y Offset"],
                        get = function() return db.pos.y end,
                        set = function(_, value) db.pos.y = value Mail:Refresh() end,
                    },
                },
            },
        },
    },
}

function Mail:OnInitialize()
    self.db = SLDataText.db:RegisterNamespace(MODNAME, defaults)
    db = self.db.profile
    coreDB = SLDataText.db.profile
    charDB = self.db.char
    if ( not self.db.char.newmail ) then self.db.char.newmail = 0 end
    if ( not self.db.char.totalmail ) then self.db.char.totalmail = 0 end
    -- Check plugins enabled state & add options
    self:SetEnabledState(SLDataText:GetModuleEnabled(MODNAME))
    SLDataText:InjectOptions(MODNAME, options)
end

function Mail:OnEnable()
    if ( not self.frame ) then 
        self.frame = CreateFrame("Frame", "SLDTMail", UIParent)
        self.text = self.frame:CreateFontString(nil, "OVERLAY")
    end
    if ( not self.frame:IsShown() ) then self.frame:Show() end
    if ( db.hideMMIcon and MiniMapMailFrame:IsShown() ) then MiniMapMailFrame:Hide() end
    
    self:RegisterEvent("PLAYER_ENTERING_WORLD")
    self:RegisterEvent("MAIL_CLOSED")
    self:RegisterEvent("MAIL_SHOW")
    self:RegisterEvent("MAIL_INBOX_UPDATE")
    self:RegisterEvent("UPDATE_PENDING_MAIL")
    self:RegisterEvent("CHAT_MSG_SYSTEM")
end

function Mail:OnDisable()
    if ( self.frame:IsShown() ) then self.frame:Hide() end
end

Mail.Zoned = false
Mail.Checked = false
Mail.IgnoreTrigger = false
Mail.CloseDelay = 5
Mail.AuctionString = {}

function Mail:PLAYER_ENTERING_WORLD()
    self.Zoned = true
    self:Refresh()
end

function Mail:UPDATE_PENDING_MAIL()
    if ( self.Zoned ) then self.Zoned = false self:MailLogIn() return end
    if ( self.LastCheck and ( self.LastCheck + self.CloseDelay ) > GetTime() ) then self.IgnoreTrigger = true end
    
    if ( self.IgnoreTrigger ) then
        self.IgnoreTrigger = false
        return
    else
        if ( not self.MailDup ) then self.MailDup = 1 end
        
        if ( self.MailDup < 2 ) then
            charDB.newmail, charDB.totalmail = charDB.newmail + 1, charDB.totalmail + 1
            if ( self.Checked ) then charDB.totalmail = GetInboxNumItems() + charDB.newmail end
            if ( HasNewMail() and not self.Checked ) then PlaySoundFile(soundfile) end
            self.MailDup = self.MailDup + 1
            self:Refresh()
        else
            self.MailDup = 1
        end
    end
end

function Mail:MailLogIn()
    if ( HasNewMail() and not self.Checked ) then PlaySoundFile(soundfile) end
    self:Refresh()
end

function Mail:MAIL_INBOX_UPDATE()
    charDB.newmail = 0
    charDB.totalmail = GetInboxNumItems()
    self:Refresh()
end

function Mail:MAIL_SHOW()
    self.Checked = true
    charDB.ahalert = nil
    self:Refresh()
end

function Mail:MAIL_CLOSED()
    if ( self.Checked ) then self.Checked = false end
    self.LastCheck = GetTime()
end

Mail.Events = {
    [ERR_AUCTION_WON_S]     = false,
	[ERR_AUCTION_SOLD_S]    = false,
	[ERR_AUCTION_OUTBID_S]  = true,
	[ERR_AUCTION_EXPIRED_S] = false,
	[ERR_AUCTION_REMOVED_S] = false,
}
Mail.EventNames = {
	[ERR_AUCTION_WON_S]     = "WON",
	[ERR_AUCTION_SOLD_S]    = "SOLD",
	[ERR_AUCTION_OUTBID_S]  = "OUTBID",
	[ERR_AUCTION_EXPIRED_S] = "EXPIRED",
	[ERR_AUCTION_REMOVED_S] = "REMOVED",
}

for i in pairs(Mail.Events) do Mail.AuctionString[i] = string.gsub(i, "%%[^%s]+", "(.+)") end

function Mail:CHAT_MSG_SYSTEM(msg)
    if ( not msg ) then return end
    for i, searchstr in pairs(self.AuctionString) do
		local _, _, item = string.find(msg, searchstr)
		if ( item ) then
            if ( not charDB.ahalert or charDB.ahalert == nil ) then charDB.ahalert = {} end
            table.insert(charDB.ahalert, { self.EventNames[i], item })
			if ( self.Events[i] ) then
				self:UPDATE_PENDING_MAIL()
				return
			end
		end
	end
end

function Mail:Refresh()
    if db.showTotal then
        self.mailcount = format("%d/%d", charDB.newmail, charDB.totalmail)
    else
        self.mailcount = charDB.newmail
    end
    
    if ( HasNewMail() and not charDB.ahalert and not self.Checked ) then -- If new mail, not checked, and not AH
        self.mailnote = L["New!"]
    elseif ( HasNewMail() and ( charDB.ahalert and charDB.ahalert ~= nil ) and not self.Checked ) then -- If new mail, not checked, and IS AH
        self.mailnote = L["|cffff0000AH Alert:|r"]
    elseif ( charDB.newmail == 0 and charDB.totalmail > 0 ) then -- If not new mail, regardless of check state
        self.mailnote = L["Mail:"]
    else -- No mail (New or Total)
        self.mailnote = L["No Mail"]
    end
    
    if ( coreDB.isLocked and not db.suppTT ) then
        if ( charDB.ahalert and charDB.ahalert ~= nil ) then
            self.frame:SetScript("OnEnter", function()
                GameTooltip:SetOwner(this, "ANCHOR_CURSOR")
                GameTooltip:AddLine(L["AH Alerts"], 1, 0, 0)
                GameTooltip:AddLine("----------------", 1, 1, 1)
                for _, ahinfo in ipairs(charDB.ahalert) do
                    GameTooltip:AddDoubleLine(ahinfo[1], ahinfo[2], 1, 0, 0, 1, 1, 1)
                end
                GameTooltip:Show()
            end)
            self.frame:SetScript("OnLeave", function()
                if GameTooltip:IsShown() then GameTooltip:Hide() end
            end)
        else
            self.frame:SetScript("OnEnter", nil)
            self.frame:SetScript("OnLeave", nil)
        end
    else
        self.frame:SetScript("OnEnter", nil)
        self.frame:SetScript("OnLeave", nil)
    end
    
    self:RefreshFrame()
end

Mail.isMoving = false

function Mail:RefreshFrame()
    local curFont, curFontSize
    if ( db.useCoreFace ) then curFont = SLDataText.db.profile.coreFontFace else curFont = db.fontFace end
    if ( db.useCoreSize ) then curSize = SLDataText.db.profile.coreFontSize else curSize = db.fontSize end
    self.text:SetFont(SML:Fetch("font", curFont), curSize)
    self.text:SetShadowColor(0, 0, 0, 1)
    self.text:SetShadowOffset(1.5, -1.5)
    self.text:SetJustifyH(db.justify)
    
    local color1, color2 = SLDataText.vColor, SLDataText.btColor
    if ( charDB.totalmail > 0 or ( HasNewMail() and charDB.newmail > 0 ) ) then -- If there is mail of any kind...show note AND count
        self.text:SetFormattedText("%s%s|r %s%s|r", color2, self.mailnote, color1, self.mailcount)
    else -- If there is no mail...just show note
        self.text:SetFormattedText("%s%s|r", color2, self.mailnote)
    end
    
    self.frame:SetWidth(self.text:GetWidth())
    self.frame:SetHeight(self.text:GetHeight())
    
    if not coreDB.isLocked then
        self.frame:SetMovable(true)
        self.frame:RegisterForDrag("LeftButton")
        self.frame:EnableMouse(true)
        self.frame:SetScript("OnMouseDown", function()
            SLDataText:MoveFrame(self, db)
        end)
        self.frame:SetScript("OnMouseUp", function()
            SLDataText:StopFrame(self, db)
        end)
    else
        self.frame:SetMovable(false)
        self.frame:RegisterForDrag(nil)
        self.frame:EnableMouse(true)
        self.frame:SetScript("OnMouseDown", nil)
        self.frame:SetScript("OnMouseUp", nil)
    end
    
    if not self.isMoving then
        self.frame:ClearAllPoints()
        self.frame:SetPoint(db.justify, db.pos.anchor, db.pos.anchorFrom, db.pos.x, db.pos.y)
        self.text:ClearAllPoints()
        self.text:SetPoint(db.justify, self.frame, db.justify, 0, 0)
    end
    
    if ( db.hideMMIcon ) then
        if ( MiniMapMailFrame:IsShown() ) then MiniMapMailFrame:Hide() end
    end
end