--[[ SLDataText - Copyright (C) 2008 Jeff "Taffu" Fancher | Last Revision: 1.02 | License: GPL v3.0 ]]
--[[ Guild.lua - Revised: 04/01/2008 ]]

local SLDataText = LibStub("AceAddon-3.0"):GetAddon("SLDataText")
local Guild = SLDataText:NewModule("Guild", "AceEvent-3.0", "AceTimer-3.0", "AceConsole-3.0")
local SML = LibStub("LibSharedMedia-3.0")
local Tablet = LibStub("Tablet-2.0")
local TBL = SML:List("font")
local L = LibStub("AceLocale-3.0"):GetLocale("SLDataText")
local MODNAME = "Guild"
local coreDB
local charDB

local db
local defaults = {
    profile = {
        basetext = L["Guild:"],
        showSelf = false,
        fontSize = 16,
        fontFace = "Arial Narrow",
        useCoreFace = true,
        useCoreSize = true,
        pos = { anchorPoint = "RIGHT", anchor = "UIParent", anchorFrom = "RIGHT", x = -100, y = -40 },
        justify = "RIGHT",
        suppTT = false,
        overrideCombatHide = false,
        showClass = true,
        showRank = true,
        showNotes = true,
        showOffNotes = false,
        ttPoint = "TOP",
        ttfPoint = "BOTTOM",
    },
}

local options = {
    guild = {
        name = L["Guild"],
        arg = MODNAME,
        type = "group",
        args = {
            desc = {
                order = 1,
                type = "description",
                name = L["Guild Desc"],
            },
            enabled = {
				order = 2,
				type = "toggle",
				name = L["Enable Guild"],
				get = function() return SLDataText:GetModuleEnabled(MODNAME) end,
				set = function(info, value) SLDataText:SetModuleEnabled(MODNAME, value) end,
			},
            overrideCombatHide = {
                order = 3,
                type = "toggle",
                name = L["Override Combat Hide"],
                get = function() return db.overrideCombatHide end,
                set = function() db.overrideCombatHide = not db.overrideCombatHide Guild:Refresh() end,
            },
            style = {
                order = 2,
                name = L["Style"],
                type = "group",
                args = {
                    btDesc = {
                        order = 0,
                        type = "description",
                        name = L["Base Text Desc"],
                    },
                    basetext = {
                        order = 1,
                        type = "input",
                        name = L["Base Text"],
                        get = function() return db.basetext end,
                        set = function(_, value) db.basetext = value Guild:Refresh() end,
                    },
                    showSelfDesc = {
                        order = 2,
                        type = "description",
                        name = L["Show Self Desc"],
                    },
                    showSelf = {
                        order = 3,
                        type = "toggle",
                        name = L["Show Self"],
                        get = function() return db.showSelf end,
                        set = function() db.showSelf = not db.showSelf Guild:Refresh() end,
                    },
                    suppTTDesc = {
                        order = 7,
                        type = "description",
                        name = L["suppTTDesc"],
                    },
                    suppTT = {
                        order = 8,
                        type = "toggle",
                        name = L["suppTT"],
                        get = function() return db.suppTT end,
                        set = function() db.suppTT = not db.suppTT Guild:Refresh() end,
                    },
                    useCoreDesc = {
                        order = 9,
                        type = "description",
                        name = L["Use Core Desc"],
                    },
                    useCoreFace = {
                        order = 10,
                        type = "toggle",
                        name = L["Use Core Font Face"],
                        get = function() return db.useCoreFace end,
                        set = function() db.useCoreFace = not db.useCoreFace Guild:Refresh() end,
                    },
                    useCoreSize = {
                        order = 11,
                        type = "toggle",
                        name = L["Use Core Font Size"],
                        get = function() return db.useCoreSize end,
                        set = function() db.useCoreSize = not db.useCoreSize Guild:Refresh() end,
                    },
                    useSelfDesc = {
                        order = 12,
                        type = "description",
                        name = L["Use Self Desc"],
                    },
                    fontFace = {
                        order = 13,
                        type = "select",
                        values = SML:List("font"),
                        name = L["Font Face"],
                        get = function()
                            for k, v in pairs(TBL) do
                                if db.fontFace == v then
                                    return k
                                end
                            end
                        end,
                        set = function(_, font)
                            db.fontFace = TBL[font]
                            font = SML:Fetch("font", TBL[font])
                            Guild:Refresh()
                        end,
                        disabled = function()
                            local istrue
                            if ( db.useCoreFace ) then istrue = true else istrue = false end
                            return istrue
                        end,
                    },
                    spacer = { order = 14, type = "description", name = "" },
                    fontSize = {
                        order = 15,
                        type = "range",
                        name = L["Font Size"],
                        min = 4, max = 36, step = 1,
                        get = function() return db.fontSize end,
                        set = function(_, value) db.fontSize = value Guild:Refresh() end,
                        disabled = function()
                            local istrue
                            if ( db.useCoreSize ) then istrue = true else istrue = false end
                            return istrue
                        end,
                    },
                },
            },
            position = {
                order = 3,
                type = "group",
                name = L["Position"],
                args = {
                    justifyDesc = {
                        order = 1,
                        type = "description",
                        name = L["Justify Desc"],
                    },
                    justify = {
                        order = 2,
                        type = "select",
                        values = SLDataText.JustTbl,
                        name = L["Set Justify"],
                        get = function() return db.justify end,
                        set = function(_, value) db.justify = value Guild:Refresh() end,
                    },
                    parentDesc = {
                        order = 3,
                        type = "description",
                        name = L["Parent Desc"],
                    },
                    parent = {
                        order = 4,
                        type = "input",
                        name = L["Parent Anchor"],
                        get = function() return db.pos.anchor end,
                        set = function(_, value) db.pos.anchor = value Guild:Refresh() end,
                    },
                    anchorFromDesc = {
                        order = 5,
                        type = "description",
                        name = L["Anchor From Desc"],
                    },
                    anchorFrom = {
                        order = 6,
                        type = "select",
                        values = SLDataText.PointTbl,
                        name = L["Anchor From"],
                        get = function() return db.pos.anchorFrom end,
                        set = function(_, value) db.pos.anchorFrom = value Guild:Refresh() end,
                    },
                    offsetDesc = { 
                        order = 7, 
                        type = "description", 
                        name = L["Offset Desc"],
                    },
                    posX = {
                        order = 8,
                        type = "input",
                        name = L["X Offset"],
                        get = function() return db.pos.x end,
                        set = function(_, value) db.pos.x = value Guild:Refresh() end,
                    },
                    spacer2 = { order = 9, type = "description", name = "" },
                    posY = {
                        order = 10,
                        type = "input",
                        name = L["Y Offset"],
                        get = function() return db.pos.y end,
                        set = function(_, value) db.pos.y = value Guild:Refresh() end,
                    },
                },
            },
            tooltip = {
                order = 4,
                type = "group",
                name = L["Tooltip"],
                args = {
                    ttDesc = {
                        order = 1,
                        type = "description",
                        name = L["Tooltip Desc"],
                    },
                    ttPoint = {
                        order = 2,
                        type = "select",
                        values = SLDataText.PointTbl,
                        name = L["Anchor"],
                        get = function() return db.ttPoint end,
                        set = function(_, value) db.ttPoint = value Guild:Refresh() end,
                    },
                    ttfPoint = {
                        order = 3,
                        type = "select",
                        values = SLDataText.PointTbl,
                        name = L["Anchor From"],
                        get = function() return db.ttfPoint end,
                        set = function(_, value) db.ttfPoint = value Guild:Refresh() end,
                    },
                    showDesc = {
                        order = 4,
                        type = "description",
                        name = L["Show Desc"],
                    },
                    showClass = {
                        order = 5,
                        type = "toggle",
                        name = L["Show Class"],
                        get = function() return db.showClass end,
                        set = function() db.showClass = not db.showClass Guild:Refresh() end,
                    },
                    showRank = {
                        order = 6,
                        type = "toggle",
                        name = L["Show Rank"],
                        get = function() return db.showRank end,
                        set = function() db.showRank = not db.showRank Guild:Refresh() end,
                    },
                    showNotes = {
                        order = 7,
                        type = "toggle",
                        name = L["Show Notes"],
                        get = function() return db.showNotes end,
                        set = function() db.showNotes = not db.showNotes Guild:Refresh() end,
                    },
                },
            },
        },
    },
}

function Guild:OnInitialize()
    -- Register plugins svars
    self.db = SLDataText.db:RegisterNamespace(MODNAME, defaults)
    db = self.db.profile
    coreDB = SLDataText.db.profile
    charDB = SLDataText.db.char
    
    if ( not charDB.Guild ) then charDB.Guild = {} end
    -- Check plugins enabled state
    self:SetEnabledState(SLDataText:GetModuleEnabled(MODNAME))
    -- Add Plugins Options
    SLDataText:InjectOptions(MODNAME, options)
end

function Guild:OnEnable()
    -- Check frame or build frame
    if ( not self.frame ) then 
        self.frame = CreateFrame("Frame", "SLDTGuild", UIParent)
        self.text = self.frame:CreateFontString(nil, "OVERLAY")
    end
    -- Check shown if enabled, show if not already
    if ( not self.frame:IsShown() ) then self.frame:Show() end
    --if ( self.menu:IsShown() ) then self.menu:Hide() end
    -- Register applicable events
    self:RegisterEvent("PLAYER_ENTERING_WORLD", "Refresh")
    self:RegisterEvent("GUILD_ROSTER_UPDATE", "Refresh")
    -- Fire guild update
    GuildRoster()
end

function Guild:OnDisable()
    -- Check shown if disabled, hide if not already
    if ( self.frame:IsShown() ) then self.frame:Hide() end
end

function Guild:Refresh()
    self.List = nil
    -- Total Guild Members
    local guildtotal = GetNumGuildMembers()
    local guildonline = 0
    -- Total Online Guildies
    for i = 0, guildtotal do
        local name, rank, _, lvl, class, zone, note, offnote, online, status = GetGuildRosterInfo(i)
        if ( online ) then
            -- If they're online, we'll add them to our guild table
            if ( not self.List or self.List == nil ) then self.List = {} end
            local client = GetLocale() 
            local classcolor = SLDataText.ColorTable[client][class]
            local coloredname
            if ( status == "" ) then coloredname = format("%s%s|r", classcolor, name)
            else coloredname = format("%s %s%s|r", status, classcolor, name) end
            -- I hate this, it's ugly and fat...gotta find a better way
            self.prelist = nil
            if ( not db.showClass and not db.showRank and not db.showNotes ) then self.prelist = { coloredname, lvl, zone, name }
            elseif ( db.showClass and not db.showRank and not db.showNotes ) then self.prelist = { coloredname, lvl, zone, class, name }
            elseif ( db.showClass and db.showRank and not db.showNotes ) then self.prelist = { coloredname, lvl, zone, class, rank, name }
            elseif ( not db.showClass and db.showRank and db.showNotes ) then self.prelist = { coloredname, lvl, zone, rank, note, name }
            elseif ( not db.showClass and not db.showRank and db.showNotes ) then self.prelist = { coloredname, lvl, zone, note, name }
            elseif ( not db.showClass and db.showRank and not db.showNotes ) then self.prelist = { coloredname, lvl, zone, rank, name } 
            elseif ( db.showClass and not db.showRank and db.showNotes ) then self.prelist = { coloredname, lvl, zone, class, note, name } 
            else self.prelist = { coloredname, lvl, zone, class, rank, note, name } end
            
            if ( not db.showSelf and name == UnitName("player") ) then
                break
            else
                table.insert(self.List, self.prelist)
                guildonline = guildonline + 1
            end
        end
    end
    
    self.basetext = db.basetext
    self.gonline = guildonline
    
    if ( coreDB.isLocked and not db.suppTT and self.gonline > 0 ) then
        self.frame:SetScript("OnEnter", function() Tablet:Open(self.frame) end)
    else
        self.frame:SetScript("OnEnter", nil)
    end
    
    if ( not Tablet:IsRegistered(self.frame) ) then
        Tablet:Register(self.frame,
            "children", function()
                self:UpdateTablet()
            end,
            "point", function()
                return db.ttPoint
            end,
            "relativePoint", function()
                return db.ttfPoint
            end,
            "maxHeight", 500,
            "clickable", true,
            "hideWhenEmpty", true
        )
    end
    
    -- Update Frame
    self:RefreshFrame()
end

function Guild:UpdateTablet()
    if ( IsInGuild() ) then
        GuildRoster()
        local header = Tablet:AddCategory()
        local gname, _, _ = GetGuildInfo("player")
        local gmotd = GetGuildRosterMOTD()
        header:AddLine('text', gname, 'size', 14)
        header:AddLine('text', gmotd, 'wrap', true)
        
        local col = {}
        table.insert(col, L["Name"])
        table.insert(col, L["Level"])
        table.insert(col, L["Location"])
        if ( db.showClass ) then table.insert(col, L["Class"]) end
        if ( db.showRank ) then table.insert(col, L["Rank"]) end
        if ( db.showNotes ) then table.insert(col, L["Notes"]) end
        
        local cat = Tablet:AddCategory("columns", #col)
        local header = {}
        for i = 1, #col do
            if i == 1 then
                header['text'] = col[i]
                header['justify'] = "CENTER"
            else
                header['text'..i] = col[i]
                header['justify'..i] = "CENTER"
            end
        end
        cat:AddLine(header)
        local nameslot = #col+1
        for _, val in ipairs(self.List) do
            local line = {}
            for i = 1, #col do
                if i == 1 then
                    line['text'] = val[i]
                    line['justify'] = "CENTER"
                    line['func'] = function() self:ListSendTell(val[nameslot]) end
                else
                    line['text'..i] = val[i]
                    line['justify'..i] = "CENTER"
                    line['text'..i..'R'] = 1
                    line['text'..i..'G'] = 1
                    line['text'..i..'B'] = 1
                end
            end
            cat:AddLine(line)
        end
        
        Tablet:SetHint(L["Guild Hint"])
    end
end

function Guild:ListSendTell(name)
    if ( not name ) then return end
    if ( IsAltKeyDown() ) then
        InviteUnit(name)
    else
        SetItemRef("player:"..name, "|Hplayer:"..name.."|h["..name.."|h", "LeftButton")
    end
end

function Guild:RefreshFrame()
    local curFont, curFontSize
    if ( db.useCoreFace ) then curFont = SLDataText.db.profile.coreFontFace else curFont = db.fontFace end
    if ( db.useCoreSize ) then curSize = SLDataText.db.profile.coreFontSize else curSize = db.fontSize end
    self.text:SetFont(SML:Fetch("font", curFont), curSize)
    self.text:SetShadowColor(0, 0, 0, 1)
    self.text:SetShadowOffset(1.5, -1.5)
    self.text:SetJustifyH(db.justify)
    
    -- Set Text
    local color1, color2 = SLDataText.vColor, SLDataText.btColor
    self.text:SetFormattedText("%s%s|r %s%s|r", color2, self.basetext, color1, self.gonline) 

    -- Frame Properties
    self.frame:SetWidth(self.text:GetWidth())
    self.frame:SetHeight(self.text:GetHeight())
    
    -- Movement & Position
    if not coreDB.isLocked then
        self.frame:SetMovable(true)
        self.frame:RegisterForDrag("LeftButton")
        self.frame:EnableMouse(true)
        self.frame:SetScript("OnMouseDown", function()
            SLDataText:MoveFrame(self, db)
        end)
        self.frame:SetScript("OnMouseUp", function()
            SLDataText:StopFrame(self, db)
        end)
    else
        self.frame:SetMovable(false)
        self.frame:RegisterForDrag(nil)
        self.frame:EnableMouse(true)
        self.frame:SetScript("OnMouseDown", nil)
        self.frame:SetScript("OnMouseUp", nil)
    end
    
    if not self.isMoving then
        self.frame:ClearAllPoints()
        self.frame:SetPoint(db.justify, db.pos.anchor, db.pos.anchorFrom, db.pos.x, db.pos.y)
        self.text:ClearAllPoints()
        self.text:SetPoint(db.justify, self.frame, db.justify, 0, 0)
    end
end