--[[ SLDataText - Copyright (C) 2008 Jeff "Taffu" Fancher | Version: 1.0 | License: GPL v3.0 ]]
--[[ Gold.lua - Revised: 03/25/2008 ]]

local SLDataText = LibStub("AceAddon-3.0"):GetAddon("SLDataText")
local Gold = SLDataText:NewModule("Gold", "AceEvent-3.0", "AceTimer-3.0", "AceConsole-3.0")
local Abacus = LibStub("Abacus-2.0")
local SML = LibStub("LibSharedMedia-3.0")
local TBL = SML:List("font")
local L = LibStub("AceLocale-3.0"):GetLocale("SLDataText")
local MODNAME = "Gold"
local coreDB
local charDB

local db
local defaults = {
    profile = {
        dispStyle = "Full",
        fontSize = 16,
        fontFace = "Arial Narrow",
        useCoreFace = true,
        useCoreSize = true,
        pos = { anchorPoint = "RIGHT", anchor = "UIParent", anchorFrom = "RIGHT", x = -100, y = 20 },
        justify = "RIGHT",
        suppTT = false,
        overrideCombatHide = false,
    },
}

Gold.DispTbl = {
    ["Extended"] = L["Extended"],
    ["Full"] = L["Full"],
    ["Short"] = L["Short"],
}

local options = {
    gold = {
        name = L["Gold"],
        arg = MODNAME,
        type = "group",
        args = {
            desc = {
                order = 1,
                type = "description",
                name = L["Gold Desc"],
            },
            enabled = {
				order = 2,
				type = "toggle",
				name = L["Enable Gold"],
				get = function() return SLDataText:GetModuleEnabled(MODNAME) end,
				set = function(info, value) SLDataText:SetModuleEnabled(MODNAME, value) end,
			},
            overrideCombatHide = {
                order = 3,
                type = "toggle",
                name = L["Override Combat Hide"],
                get = function() return db.overrideCombatHide end,
                set = function() db.overrideCombatHide = not db.overrideCombatHide Gold:Refresh() end,
            },
            style = {
                order = 2,
                name = L["Style"],
                type = "group",
                args = {
                    dispDesc = {
                        order = 0,
                        type = "description",
                        name = L["Display Desc"]
                    },
                    display = {
                        order = 1,
                        type = "select",
                        values = Gold.DispTbl,
                        name = L["Display"],
                        get = function() return db.dispStyle end,
                        set = function(_, value) db.dispStyle = value Gold:Refresh() end,
                    },
                    --[[suppTTDesc = {
                        order = 6,
                        type = "description",
                        name = L["suppTTDesc"],
                    },
                    suppTT = {
                        order = 7,
                        type = "toggle",
                        name = L["suppTT"],
                        get = function() return db.suppTT end,
                        set = function() db.suppTT = not db.suppTT Gold:Refresh() end,
                    },]]
                    useCoreDesc = {
                        order = 9,
                        type = "description",
                        name = L["Use Core Desc"],
                    },
                    useCoreFace = {
                        order = 10,
                        type = "toggle",
                        name = L["Use Core Font Face"],
                        get = function() return db.useCoreFace end,
                        set = function() db.useCoreFace = not db.useCoreFace Gold:Refresh() end,
                    },
                    useCoreSize = {
                        order = 11,
                        type = "toggle",
                        name = L["Use Core Font Size"],
                        get = function() return db.useCoreSize end,
                        set = function() db.useCoreSize = not db.useCoreSize Gold:Refresh() end,
                    },
                    useSelfDesc = {
                        order = 12,
                        type = "description",
                        name = L["Use Self Desc"],
                    },
                    fontFace = {
                        order = 13,
                        type = "select",
                        values = SML:List("font"),
                        name = L["Font Face"],
                        get = function()
                            for k, v in pairs(TBL) do
                                if db.fontFace == v then
                                    return k
                                end
                            end
                        end,
                        set = function(_, font)
                            db.fontFace = TBL[font]
                            font = SML:Fetch("font", TBL[font])
                            Gold:Refresh()
                        end,
                        disabled = function()
                            local istrue
                            if ( db.useCoreFace ) then istrue = true else istrue = false end
                            return istrue
                        end,
                    },
                    spacer = { order = 14, type = "description", name = "" },
                    fontSize = {
                        order = 15,
                        type = "range",
                        name = L["Font Size"],
                        min = 4, max = 36, step = 1,
                        get = function() return db.fontSize end,
                        set = function(_, value) db.fontSize = value Gold:Refresh() end,
                        disabled = function()
                            local istrue
                            if ( db.useCoreSize ) then istrue = true else istrue = false end
                            return istrue
                        end,
                    },
                },
            },
            position = {
                order = 3,
                type = "group",
                name = L["Position"],
                args = {
                    justifyDesc = {
                        order = 1,
                        type = "description",
                        name = L["Justify Desc"],
                    },
                    justify = {
                        order = 2,
                        type = "select",
                        values = SLDataText.JustTbl,
                        name = L["Set Justify"],
                        get = function() return db.justify end,
                        set = function(_, value) db.justify = value Gold:Refresh() end,
                    },
                    parentDesc = {
                        order = 3,
                        type = "description",
                        name = L["Parent Desc"],
                    },
                    parent = {
                        order = 4,
                        type = "input",
                        name = L["Parent Anchor"],
                        get = function() return db.pos.anchor end,
                        set = function(_, value) db.pos.anchor = value Gold:Refresh() end,
                    },
                    anchorFromDesc = {
                        order = 5,
                        type = "description",
                        name = L["Anchor From Desc"],
                    },
                    anchorFrom = {
                        order = 6,
                        type = "select",
                        values = SLDataText.PointTbl,
                        name = L["Anchor From"],
                        get = function() return db.pos.anchorFrom end,
                        set = function(_, value) db.pos.anchorFrom = value Gold:Refresh() end,
                    },
                    offsetDesc = { 
                        order = 7, 
                        type = "description", 
                        name = L["Offset Desc"],
                    },
                    posX = {
                        order = 8,
                        type = "input",
                        name = L["X Offset"],
                        get = function() return db.pos.x end,
                        set = function(_, value) db.pos.x = value Gold:Refresh() end,
                    },
                    spacer2 = { order = 9, type = "description", name = "" },
                    posY = {
                        order = 10,
                        type = "input",
                        name = L["Y Offset"],
                        get = function() return db.pos.y end,
                        set = function(_, value) db.pos.y = value Gold:Refresh() end,
                    },
                },
            },
        },
    },
}

function Gold:OnInitialize()
    -- Register plugins svars
    self.db = SLDataText.db:RegisterNamespace(MODNAME, defaults)
    db = self.db.profile
    coreDB = SLDataText.db.profile
    charDB = SLDataText.db.char
    
    if ( not charDB.Gold ) then charDB.Gold = {} end
    -- Check plugins enabled state
    self:SetEnabledState(SLDataText:GetModuleEnabled(MODNAME))
    -- Add Plugins Options
    SLDataText:InjectOptions(MODNAME, options)
end

function Gold:OnEnable()
    -- Check frame or build frame
    if ( not self.frame ) then 
        self.frame = CreateFrame("Frame", "SLDTGold", UIParent)
        self.text = self.frame:CreateFontString(nil, "OVERLAY")
    end
    -- Check shown if enabled, show if not already
    if ( not self.frame:IsShown() ) then self.frame:Show() end
    -- Register applicable events
    --self:RegisterEvent("PLAYER_LOGIN")
    self:RegisterEvent("PLAYER_ENTERING_WORLD", "Refresh")
    self:RegisterEvent("PLAYER_MONEY", "Refresh")
	self:RegisterEvent("SEND_MAIL_MONEY_CHANGED", "Refresh")
	self:RegisterEvent("SEND_MAIL_COD_CHANGED", "Refresh")
    self:RegisterEvent("PLAYER_TRADE_MONEY", "Refresh")
	self:RegisterEvent("TRADE_MONEY_CHANGED", "Refresh")
end

function Gold:OnDisable()
    -- Check shown if disabled, hide if not already
    if ( self.frame:IsShown() ) then self.frame:Hide() end
end

function Gold:Refresh()
    -- Gather plugin data
    self.copper = GetMoney()
    
    if ( db.dispStyle == "Extended" ) then
        self.money = Abacus:FormatMoneyExtended(self.copper, true)
    elseif ( db.dispStyle == "Full" ) then
        self.money = Abacus:FormatMoneyFull(self.copper, true)
    elseif ( db.dispStyle == "Short" ) then
        self.money = Abacus:FormatMoneyShort(self.copper, true)
    end
    -------------------------------------
    -- Tooltip 
    -------------------------------------
    --[[
    if guildonline > 0 then
        if coreDB.isLocked then
            self.frame:SetScript("OnEnter", function(this)
                GameTooltip:SetOwner(this, "ANCHOR_CURSOR")
                GameTooltip:AddLine(string.format("%s%s|r", SLDataText.ColorTable["White"], L["Gold Data"]))
                GameTooltip:AddLine("-------------------------", 1, 1, 1)
                for _, val in ipairs(self.List) do
                    local ptext = string.format("%s%s: %s %s", val[8], val[1], val[3], val[4])
                    local dtext = string.format("%sRank:|r %s %sLocation:|r %s (%sNote:|r %s)", SLDataText.ColorTable[coreDB.btColor], val[2], SLDataText.ColorTable[coreDB.btColor], val[5], SLDataText.ColorTable[coreDB.btColor], val[6])
                    GameTooltip:AddDoubleLine(ptext, dtext, 1, 1, 1, 1, 1, 1)
                end
                GameTooltip:SetScale(1)
                GameTooltip:Show()
            end)
            self.frame:SetScript("OnLeave", function()
                if GameTooltip:IsShown() then
                    GameTooltip:Hide()
                end
            end)
        end
    else
        self.frame:SetScript("OnEnter", nil)
        self.frame:SetScript("OnLeave", nil)
    end]]
    -------------------------------------
    -- Update Frame
    self:RefreshFrame()
end

function Gold:RefreshFrame()
    local curFont, curFontSize
    if ( db.useCoreFace ) then curFont = SLDataText.db.profile.coreFontFace else curFont = db.fontFace end
    if ( db.useCoreSize ) then curSize = SLDataText.db.profile.coreFontSize else curSize = db.fontSize end
    self.text:SetFont(SML:Fetch("font", curFont), curSize)
    self.text:SetShadowColor(0, 0, 0, 1)
    self.text:SetShadowOffset(1.5, -1.5)
    self.text:SetJustifyH(db.justify)
    
    -- Set Text
    self.text:SetText(self.money)   

    -- Frame Properties
    self.frame:SetWidth(self.text:GetWidth())
    self.frame:SetHeight(self.text:GetHeight())
    
    -- Movement & Position
    if not coreDB.isLocked then
        self.frame:SetMovable(true)
        self.frame:RegisterForDrag("LeftButton")
        self.frame:EnableMouse(true)
        self.frame:SetScript("OnMouseDown", function()
            SLDataText:MoveFrame(self, db)
        end)
        self.frame:SetScript("OnMouseUp", function()
            SLDataText:StopFrame(self, db)
        end)
    else
        self.frame:SetMovable(false)
        self.frame:RegisterForDrag(nil)
        self.frame:EnableMouse(false)
        self.frame:SetScript("OnMouseDown", nil)
        self.frame:SetScript("OnMouseUp", nil)
    end
    
    if not self.isMoving then
        self.frame:ClearAllPoints()
        self.frame:SetPoint(db.justify, db.pos.anchor, db.pos.anchorFrom, db.pos.x, db.pos.y)
        self.text:ClearAllPoints()
        self.text:SetPoint(db.justify, self.frame, db.justify, 0, 0)
    end
end