--[[ SLDataText - Copyright (C) 2008 Jeff "Taffu" Fancher | Version: 1.0 | License: GPL v3.0 ]]
--[[ Bags.lua - Revised: 03/25/2008 ]]

local SLDataText = LibStub("AceAddon-3.0"):GetAddon("SLDataText")
local Bags = SLDataText:NewModule("Bags", "AceEvent-3.0", "AceTimer-3.0", "AceConsole-3.0")
local SML = LibStub("LibSharedMedia-3.0")
local TBL = SML:List("font")
local L = LibStub("AceLocale-3.0"):GetLocale("SLDataText")
local MODNAME = "Bags"
local coreDB

local db
local defaults = {
    profile = {
        showRem = true,
        showTotal = true,
        hideAmmo = false,
        basetext = "B:",
        fontSize = 16,
        fontFace = "Arial Narrow",
        useCoreFace = true,
        useCoreSize = true,
        pos = { anchorPoint = "RIGHT", anchor = "UIParent", anchorFrom = "RIGHT", x = -100, y = 40 },
        justify = "RIGHT",
        suppTT = false,
        overrideCombatHide = false,
    },
}

local options = {
    bags = {
        name = L["Bags"],
        arg = MODNAME,
        type = "group",
        args = {
            lagDesc = {
                order = 1,
                type = "description",
                name = L["Bags Desc"],
            },
            enabled = {
				order = 2,
				type = "toggle",
				name = L["Enable Bags"],
				get = function() return SLDataText:GetModuleEnabled(MODNAME) end,
				set = function(info, value) SLDataText:SetModuleEnabled(MODNAME, value) end,
			},
            overrideCombatHide = {
                order = 3,
                type = "toggle",
                name = L["Override Combat Hide"],
                get = function() return db.overrideCombatHide end,
                set = function() db.overrideCombatHide = not db.overrideCombatHide Bags:Refresh() end,
            },
            style = {
                order = 2,
                name = L["Style"],
                type = "group",
                args = {
                    btDesc = {
                        order = 0,
                        type = "description",
                        name = L["Base Text Desc"],
                    },
                    basetext = {
                        order = 1,
                        type = "input",
                        name = L["Base Text"],
                        get = function() return db.basetext end,
                        set = function(_, value) db.basetext = value Bags:Refresh() end,
                    },
                    showRemDesc = {
                        order = 2,
                        type = "description",
                        name = L["Show Rem Desc"],
                    },
                    showRem = {
                        order = 3,
                        type = "toggle",
                        name = L["Show Remaining"],
                        get = function() return db.showRem end,
                        set = function() db.showRem = not db.showRem Bags:Refresh() end,
                    },
                    showTotalDesc = {
                        order = 4,
                        type = "description",
                        name = L["Show Total Bags Desc"],
                    },
                    showTotal = {
                        order = 5,
                        type = "toggle",
                        name = L["Show Total"],
                        get = function() return db.showTotal end,
                        set = function() db.showTotal = not db.showTotal Bags:Refresh() end,
                    },
                    hideAmmoDesc = {
                        order = 6,
                        type = "description",
                        name = L["Hide Ammo Desc"],
                    },
                    hideAmmo = {
                        order = 7,
                        type = "toggle",
                        name = L["Hide Ammo"],
                        get = function() return db.hideAmmo end,
                        set = function() db.hideAmmo = not db.hideAmmo Bags:Refresh() end,
                    },
                    suppTTDesc = {
                        order = 8,
                        type = "description",
                        name = L["suppTTDesc"],
                    },
                    suppTT = {
                        order = 9,
                        type = "toggle",
                        name = L["suppTT"],
                        get = function() return db.suppTT end,
                        set = function() db.suppTT = not db.suppTT Bags:Refresh() end,
                    },
                    useCoreDesc = {
                        order = 10,
                        type = "description",
                        name = L["Use Core Desc"],
                    },
                    useCoreFace = {
                        order = 11,
                        type = "toggle",
                        name = L["Use Core Font Face"],
                        get = function() return db.useCoreFace end,
                        set = function() db.useCoreFace = not db.useCoreFace Bags:Refresh() end,
                    },
                    useCoreSize = {
                        order = 12,
                        type = "toggle",
                        name = L["Use Core Font Size"],
                        get = function() return db.useCoreSize end,
                        set = function() db.useCoreSize = not db.useCoreSize Bags:Refresh() end,
                    },
                    useSelfDesc = {
                        order = 13,
                        type = "description",
                        name = L["Use Self Desc"],
                    },
                    fontFace = {
                        order = 14,
                        type = "select",
                        values = SML:List("font"),
                        name = L["Font Face"],
                        get = function()
                            for k, v in pairs(TBL) do
                                if db.fontFace == v then
                                    return k
                                end
                            end
                        end,
                        set = function(_, font)
                            db.fontFace = TBL[font]
                            font = SML:Fetch("font", TBL[font])
                            Bags:Refresh()
                        end,
                        disabled = function()
                            local istrue
                            if ( db.useCoreFace ) then istrue = true else istrue = false end
                            return istrue
                        end,
                    },
                    spacer = { order = 15, type = "description", name = "" },
                    fontSize = {
                        order = 16,
                        type = "range",
                        name = L["Font Size"],
                        min = 4, max = 36, step = 1,
                        get = function() return db.fontSize end,
                        set = function(_, value) db.fontSize = value Bags:Refresh() end,
                        disabled = function()
                            local istrue
                            if ( db.useCoreSize ) then istrue = true else istrue = false end
                            return istrue
                        end,
                    },
                },
            },
            position = {
                order = 3,
                type = "group",
                name = L["Position"],
                args = {
                    justifyDesc = {
                        order = 1,
                        type = "description",
                        name = L["Justify Desc"],
                    },
                    justify = {
                        order = 2,
                        type = "select",
                        values = SLDataText.JustTbl,
                        name = L["Set Justify"],
                        get = function() return db.justify end,
                        set = function(_, value) db.justify = value Bags:Refresh() end,
                    },
                    parentDesc = {
                        order = 3,
                        type = "description",
                        name = L["Parent Desc"],
                    },
                    parent = {
                        order = 4,
                        type = "input",
                        name = L["Parent Anchor"],
                        get = function() return db.pos.anchor end,
                        set = function(_, value) db.pos.anchor = value Bags:Refresh() end,
                    },
                    anchorFromDesc = {
                        order = 5,
                        type = "description",
                        name = L["Anchor From Desc"],
                    },
                    anchorFrom = {
                        order = 6,
                        type = "select",
                        values = SLDataText.PointTbl,
                        name = L["Anchor From"],
                        get = function() return db.pos.anchorFrom end,
                        set = function(_, value) db.pos.anchorFrom = value Bags:Refresh() end,
                    },
                    offsetDesc = { 
                        order = 7, 
                        type = "description", 
                        name = L["Offset Desc"],
                    },
                    posX = {
                        order = 8,
                        type = "input",
                        name = L["X Offset"],
                        get = function() return db.pos.x end,
                        set = function(_, value) db.pos.x = value Bags:Refresh() end,
                    },
                    spacer2 = { order = 9, type = "description", name = "" },
                    posY = {
                        order = 10,
                        type = "input",
                        name = L["Y Offset"],
                        get = function() return db.pos.y end,
                        set = function(_, value) db.pos.y = value Bags:Refresh() end,
                    },
                },
            },
        },
    },
}

function Bags:OnInitialize()
    self.db = SLDataText.db:RegisterNamespace(MODNAME, defaults)
    db = self.db.profile
    coreDB = SLDataText.db.profile
    -- Check plugins enabled state & add options
    self:SetEnabledState(SLDataText:GetModuleEnabled(MODNAME))
    SLDataText:InjectOptions(MODNAME, options)
end

function Bags:OnEnable()
    if ( not self.frame ) then 
        self.frame = CreateFrame("Frame", "SLDTBags", UIParent)
        self.text = self.frame:CreateFontString(nil, "OVERLAY")
    end
    if ( not self.frame:IsShown() ) then self.frame:Show() end
    
    self:RegisterEvent("PLAYER_ENTERING_WORLD", "Refresh")
    self:RegisterEvent("BAG_UPDATE", "Refresh")
end

function Bags:OnDisable()
    if ( self.frame:IsShown() ) then self.frame:Hide() end
end

function Bags:Refresh()
    local InvTotal = 0 -- Normal total
    local InvUsed = 0 -- Normal used
    local AmmoCount = 0 -- Ammo Count
    local ProfInvTotal = 0 -- Profession Total
    local ProfInvUsed = 0 -- Profession Used
    local hasSpecialBag = false
    
    local EQAmmoSlotID = GetInventorySlotInfo("ammoSlot")
    local EqAmmoCount = GetInventoryItemCount("player", EQAmmoSlotID)
    
    for i = 0,4 do
        local bag = true
        local bagtype = nil
        local bagsubtype = nil
        if i >= 1 then
            local bagLink = GetInventoryItemLink("player", ContainerIDToInventoryID(i))
            if bagLink ~= nil then
                local subType = select(7, GetItemInfo(bagLink))
                if subType == L["Ammo Pouch"] or subType == L["Quiver"] or subType == L["Soul Bag"] then
                    bag = false
                    bagtype = "Ammo"
                    if subType == L["Soul Bag"] then bagsubtype = L["Soul Bag"] end
                    hasSpecialBag = true
                elseif subType == L["Enchanting Bag"] or subType == L["Herb Bag"] or subType == L["Engineering Bag"] or subType == L["Mining Bag"] or subType == L["Gem Bag"] then
                    bag = false
                    bagtype = "Profession"
                    hasSpecialBag = true
                end
            end
        end
        if not bag and bagtype == "Ammo" then -- If Ammo Container (Arrows, Bullets, Shards, etc)
            local invSize = GetContainerNumSlots(i)
            if bagsubtype ~= nil and bagsubtype == "Soul Bag" then -- Only for Shards
                AmmoCount = GetItemCount(6265)
            else -- All other Ammo
                local ammoSlotId = GetInventorySlotInfo("ammoSlot")
                AmmoCount = GetInventoryItemCount("player", ammoSlotId)
            end
        elseif not bag and bagtype == "Profession" then -- If Profession Container (treat like normal bag, only special)
            local invSize = GetContainerNumSlots(i)
            if invSize ~= nil and invSize > 0 then
                ProfInvTotal = ProfInvTotal + invSize
                for slot = 1, invSize do
                    if GetContainerItemInfo(i, slot) then
                        ProfInvUsed = ProfInvUsed + 1
                    end
                end
            end
        else -- If Normal Container
            local invSize = GetContainerNumSlots(i)
            if invSize ~= nil and invSize > 0 then
                InvTotal = InvTotal + invSize
                for slot = 1, invSize do
                    if GetContainerItemInfo(i, slot) then
                        InvUsed = InvUsed + 1
                    end
                end
            end
            if EqAmmoCount ~=nil and EqAmmoCount > 0 then
                AmmoCount = EqAmmoCount
            end
        end
        local _, class = UnitClass("player")
        if class == "WARLOCK" then
            AmmoCount = GetItemCount(6265)
        end
    end
    
    local ttInvUsed = InvUsed
    local ttProfInvUsed = ProfInvUsed
    
    local InvRem = InvTotal - InvUsed
    local ProfInvRem = ProfInvTotal - ProfInvUsed    
    if db.showRem then InvUsed, ProfInvUsed = InvRem, ProfInvRem end
    
    if hasSpecialBag then
        if ProfInvTotal == 0 then
            local _, class = UnitClass("player")
            if class == "WARLOCK" then -- If Warlock, and there's a Shard bag
                local Ammo
                if ( db.hideAmmo ) then Ammo = "" else Ammo = format(" (%d)", AmmoCount) end
                if ( db.showTotal ) then
                    self.bagcount = format("%d/%d%s", InvUsed, InvTotal, Ammo)
                else
                    self.bagcount = format("%d%s", InvUsed, Ammo)
                end
            else -- If not a Warlock, has Ammo of some type in a special bag
                local Ammo
                if ( db.hideAmmo ) then Ammo = "" else Ammo = format(" (%d)", AmmoCount) end
                if ( db.showTotal ) then
                    self.bagcount = format("%d/%d%s", InvUsed, InvTotal, Ammo)
                else
                    self.bagcount = format("%d%s", InvUsed, Ammo)
                end
            end
        else -- Positive count on Profession space, with a profession bag
            if ( db.showTotal) then
                self.bagcount = format("%d/%d (%d/%d)", InvUsed, InvTotal, ProfInvUsed, ProfInvTotal)
            else
                self.bagcount = format("%d (%d)", InvUsed, ProfInvUsed)
            end
        end
    elseif not hasSpecialBag and AmmoCount > 0 then -- No special bag but has Shards/Ammo
        local _, class = UnitClass("player")
        if class == "WARLOCK" then
            local Ammo
            if ( db.hideAmmo ) then Ammo = "" else Ammo = format(" (%d)", AmmoCount) end
            if ( db.showTotal ) then
                self.bagcount = format("%d/%d%s", InvUsed, InvTotal, Ammo)
            else
                self.bagcount = format("%d%s", InvUsed, Ammo)
            end
        elseif ( class ~= ( "SHAMAN" or "PRIEST" or "MAGE" or "PALADIN" or "DRUID" ) ) then -- Sidestep classes that can't use ranged weapons and/or ammo-types
            local Ammo
            if ( db.hideAmmo ) then Ammo = "" else Ammo = format(" (%d)", AmmoCount) end
            if ( db.showTotal ) then
                self.bagcount = format("%d/%d%s", InvUsed, InvTotal, Ammo)
            else
                self.bagcount = format("%d%s", InvUsed, Ammo)
            end
        else
            if ( db.showTotal ) then
                self.bagcount = format("%d/%d", InvUsed, InvTotal)
            else
                self.bagcount = format("%d", InvUsed)
            end
        end
    else
        if ( db.showTotal ) then
            self.bagcount = format("%d/%d", InvUsed, InvTotal)
        else
            self.bagcount = format("%d", InvUsed)
        end
    end
    
    self.bagprefix = db.basetext
    
    if ( coreDB.isLocked and not db.suppTT ) then
        self.frame:SetScript("OnEnter", function(this)
            GameTooltip:SetOwner(this, "ANCHOR_CURSOR")
            GameTooltip:AddLine(string.format("%s%s|r", SLDataText.ColorTable["enUS"]["Yellow"], L["Bag Data"]))
            GameTooltip:AddLine("-------------------------", 1, 1, 1)
            GameTooltip:AddDoubleLine(string.format("%s%s|r", SLDataText.ColorTable["enUS"]["Yellow"], L["Total Space:"]), InvTotal, 1, 1, 1, 1, 1, 1)
            GameTooltip:AddDoubleLine(string.format("%s%s|r", SLDataText.ColorTable["enUS"]["Yellow"], L["Used Space:"]), ttInvUsed, 1, 1, 1, 1, 1, 1)
            GameTooltip:AddDoubleLine(string.format("%s%s|r", SLDataText.ColorTable["enUS"]["Yellow"], L["Remaining Space:"]), InvRem, 1, 1, 1, 1, 1, 1)
            if ( AmmoCount > 0 ) then
                GameTooltip:AddDoubleLine(string.format("%s%s|r", SLDataText.ColorTable["enUS"]["Yellow"], L["Ammo:"]), AmmoCount, 1, 1, 1, 1, 1, 1)
            end
            if ( ProfInvTotal > 0 ) then
                GameTooltip:AddLine("-------------------------", 1, 1, 1)
                GameTooltip:AddDoubleLine(string.format("%s%s|r", SLDataText.ColorTable["enUS"]["Yellow"], L["Profession Total:"]), ProfInvTotal, 1, 1, 1, 1, 1, 1)
                GameTooltip:AddDoubleLine(string.format("%s%s|r", SLDataText.ColorTable["enUS"]["Yellow"], L["Profession Used:"]), ttProfInvUsed, 1, 1, 1, 1, 1, 1)
                GameTooltip:AddDoubleLine(string.format("%s%s|r", SLDataText.ColorTable["enUS"]["Yellow"], L["Profession Remaining:"]), ProfInvRem, 1, 1, 1, 1, 1, 1)
            end            
            GameTooltip:SetScale(1)
            GameTooltip:Show()
        end)
        self.frame:SetScript("OnLeave", function()
            if ( GameTooltip:IsShown() ) then
                GameTooltip:Hide()
            end
        end)
    else
        self.frame:SetScript("OnEnter", nil)
        self.frame:SetScript("OnLeave", nil)
    end
    
    self:RefreshFrame()
end

function Bags:RefreshFrame()
    local curFont, curFontSize
    if ( db.useCoreFace ) then curFont = SLDataText.db.profile.coreFontFace else curFont = db.fontFace end
    if ( db.useCoreSize ) then curSize = SLDataText.db.profile.coreFontSize else curSize = db.fontSize end
    self.text:SetFont(SML:Fetch("font", curFont), curSize)
    self.text:SetShadowColor(0, 0, 0, 1)
    self.text:SetShadowOffset(1.5, -1.5)
    self.text:SetJustifyH(db.justify)
    
    local color1, color2 = SLDataText.vColor, SLDataText.btColor
    self.text:SetFormattedText("%s%s|r %s%s|r", color2, self.bagprefix, color1, self.bagcount)

    self.frame:SetWidth(self.text:GetWidth())
    self.frame:SetHeight(self.text:GetHeight())
    self.frame:EnableMouse(true)
    
    if not coreDB.isLocked then
        self.frame:SetMovable(true)
        self.frame:RegisterForDrag("LeftButton")
        self.frame:SetScript("OnMouseDown", function()
            SLDataText:MoveFrame(self, db)
        end)
        self.frame:SetScript("OnMouseUp", function()
            SLDataText:StopFrame(self, db)
        end)
    else
        self.frame:SetMovable(false)
        self.frame:RegisterForDrag(nil)
        self.frame:SetScript("OnMouseDown", nil)
        self.frame:SetScript("OnMouseUp", nil)
    end
    
    if not self.isMoving then
        self.frame:ClearAllPoints()
        self.frame:SetPoint(db.justify, db.pos.anchor, db.pos.anchorFrom, db.pos.x, db.pos.y)
        self.text:ClearAllPoints()
        self.text:SetPoint(db.justify, self.frame, db.justify, 0, 0)
    end
end