--[[ SLDataText - Copyright (C) 2008 Jeff "Taffu" Fancher | Last Revision: 1.02 | License: GPL v3.0 ]]
--[[ Locale\enUS.lua - Revised: 04/10/2008 ]]

local L = LibStub("AceLocale-3.0"):NewLocale("SLDataText", "enUS", true)

-- Base
L["sldt"] = true
L["sldatatext"] = true
L["SLDataText"] = true
L["SLDataText Desc"] = "Welcome to SLDataText, a text-based, lightweight AddOn that supplies a large variety of game data through multiple, independent modules. Use the module list below to configure independent modules, or configure the Core Options for global features."

-- Core
L["Core Options"] = true
L["Core Font Desc"] = "Any settings here are always available for other plugins to inherit the values, and this makes it easier to keep your plugins text uniform and clean."
L["Core Font Face"] = true
L["Core Font Size"] = true
L["Core Colors Desc"] = "Color settings here are available to plugins the same way Font settings are for uniformity. Value is the common numeric display, Base Text is the common suffix."
L["Value Color"] = true
L["Base Text Color"] = true
L["Use Core Desc"] = "Inheriting core font settings allows all plugins to use the same global settings to ensure uniformity."
L["Use Self Desc"] = "Independent font settings. (Note: Only applies to this plugin)"
L["Use Core Font Face"] = true
L["Use Core Font Size"] = true
L["Core Globals"] = true
L["Hide In Combat"] = true
L["Lock Plugins"] = true

-- Clock
L["Clock"] = true
L["Clock Desc"] = "Clock plugin that can display both Local and Server time (or both)."
L["Enable Clock"] = true
L["Show Sec Desc"] = "This option will enable the display of seconds on the clock(s)."
L["Show Seconds"] = true
L["24 Hour Desc"] = "Toggle the clock will display between 12 hour AM/PM and 24 hour formats."
L["24 Hour"] = true
L["Server Time Desc"] = "Server Time will display the actual game time in association with your server instead of the local time of your region."
L["Server Time"] = true
L["Both Desc"] = "Displaying both times will effectively show both local time and server time, instead of one or the other."
L["Show Both"] = true

-- Latency
L["Latency"] = true
L["Latency Desc"] = "Latency plugin that displays current network lag in milliseconds."
L["Enable Latency"] = true

-- Framerate
L["Framerate"] = true
L["Framerate Desc"] = "Framerate plugin that displays current FPS."
L["Enable Framerate"] = true

-- Memory
L["Memory"] = true
L["Mem Desc"] = "Memory plugin that displays current UI Memory usage in MB."
L["Enable Memory"] = true
L["ShowBlizzDesc"] = "When enabled, the memory will count Blizzard UI elements memory contribution to the total. When disabled, the memory will only reflect User added UI elements."
L["Show Blizz Memory"] = true
L["Memory Stats"] = true
L["Shown Addon Count"] = true
L["Shown Addon Count Desc"] = "Set the number of AddOns you want shown in the tooltip. (Note: AddOns are displayed by memory usage)"

-- XP
L["XP"] = true
L["XP Desc"] = "XP plugin that displays current experience points information."
L["Enable XP"] = true
L["Show Rest Desc"] = "When enabled, rest XP will be shown as a percentage in brackets."
L["Show Rest"] = true
L["Show Perc Desc"] = "When enabled, base XP will display as a percentage instead of actual values."
L["Show Percentage"] = true
L["Experience Points"] = true
L["Current XP:"] = true
L["Needed XP:"] = true
L["XP To Go:"] = true
L["Rest XP:"] = true

-- Bags
L["Bags"] = true
L["Bags Desc"] = "Bag space plugin that displays current & max bag space, as well as ammo counts."
L["Enable Bags"] = true
L["Show Rem Desc"] = "When enabled, the count will display bag space left instead of bag space used."
L["Show Remaining"] = true
L["Show Total Bags Desc"] = "When enabled, the count will display total bag space with the current count."
L["Show Total"] = true
L["Hide Ammo Desc"] = "When enabled, ammo counts will be forced hidden."
L["Hide Ammo"] = true
L["Ammo Pouch"] = true
L["Quiver"] = true
L["Soul Bag"] = true
L["Enchanting Bag"] = true
L["Herb Bag"] = true
L["Engineering Bag"] = true
L["Mining Bag"] = true
L["Gem Bag"] = true
L["Bag Data"] = true
L["Total Space:"] = true
L["Used Space:"] = true
L["Remaining Space:"] = true
L["Ammo:"] = true
L["Profession Total:"] = true
L["Profession Used:"] = true
L["Profession Remaining:"] = true

-- Mail
L["Mail"] = true
L["Mail Desc"] = "Mail plugin that displays inbox totals as well as notification on mail events."
L["Enable Mail"] = true
L["Show Total Mail Desc"] = "When enabled, mail count display will show both new mail and total mail."
L["Show Total"] = true
L["HideMMIconDesc"] = "When enabled, the module will hide the Minimap Mail Icon."
L["Hide Minimap Icon"] = true
L["AH Alerts"] = true
-- Default Text Alerts
L["New!"] = true
L["|cffff0000AH Alert:|r"] = true
L["Mail:"] = true
L["No Mail"] = true

-- Gold
L["Gold"] = true
L["Gold Desc"] = "Gold plugin that displays character currency total."
L["Enable Gold"] = true
L["Display Desc"] = "Select the format to display the currency."
L["Display"] = true
L["Extended"] = true
L["Full"] = true
L["Short"] = true
L["Gold Data"] = true

-- Guild
L["Guild"] = true
L["Guild Desc"] = "Guild plugin that displays current number of guild members online, and tooltip list."
L["Enable Guild"] = true
L["Guild Members Online"] = true
L["Show Desc"] = "When options below are enabled, they will show as columns on the tooltip. When disabled, they will not be shown."
L["Show Rank"] = true
L["Show Notes"] = true
L["Show Class"] = true
L["Show Self Desc"] = "When enabled, you will be included in the Guild count. When disabled, you will be omitted from the Guild count."
L["Show Self"] = true
L["Name"] = true
L["Level"] = true
L["Class"] = true
L["Rank"] = true
L["Location"] = true
L["Notes"] = true
L["Guild Hint"] = "Note: <Alt + Click> to invite, <Click> to send whisper."
L["Guild:"] = true -- Default Base Text

-- Friends
L["Friends"] = true
L["Friends Desc"] = "Guild plugin that displays current number of guild members online, and tooltip list."
L["Enable Friends"] = true
L["Friends Online"] = true
L["Show Desc"] = "When options below are enabled, they will show as columns on the tooltip. When disabled, they will not be shown."
L["Show Rank"] = true
L["Show Notes"] = true
L["Name"] = true
L["Level"] = true
L["Class"] = true
L["Area"] = true
L["Friends Hint"] = "Note: <Alt + Click> to invite, <Click> to send whisper."
L["Friend List"] = true
L["Friends:"] = true -- Default Base Text

-- Durability
L["Durability"] = true
L["Durability Desc"] = "Durability plugin that displays armor condition values."
L["Enable Durability"] = true
L["Durability Stats"] = true
L["Head"] = true
L["Shoulder"] = true
L["Chest"] = true
L["Waist"] = true
L["Wrist"] = true
L["Hands"] = true
L["Legs"] = true
L["Feet"] = true
L["Main Hand"] = true
L["Off Hand"] = true
L["Ranged"] = true

-- Tracking
L["Tracking"] = true
L["Tracking Desc"] = "Tracking plugin that replaces the Blizzard tracking button on the Minimap."
L["Enable Tracking"] = true
L["None"] = true
L["Icon Only Desc"] = "When enabled, only the tracking icon will be displayed."
L["Icon Only"] = true
L["Text Only Desc"] = "When enabled, only the tracking text will be displayed."
L["Text Only"] = true
L["Icon Size"] = true
L["Hide Border"] = true

-- Zone Text
L["ZoneText"] = true
L["ZoneText Desc"] = "Indicates current zone and/or subzone to replace the base Blizzard location bar."
L["Enable ZoneText"] = true

-- Coords
L["Coords"] = true
L["Coords Desc"] = "Plugin that tracks the players current X & Y location on the current world map."
L["Enable Coords"] = true

-- Statline

-- Common
L["Font Face"] = true
L["Font Size"] = true
L["Justify Desc"] = "Defines the point from the which the text grows from. (Right, Left, or Center)"
L["Set Justify"] = true
L["Style"] = true
L["Position"] = true
L["Parent Desc"] = "Define the object to which you would like this plugin to anchor to."
L["Parent Anchor"] = true
L["Anchor From Desc"] = "Define the point of the parent frame you would like to anchor to."
L["Anchor From"] = true
L["Offset Desc"] = "Define the Horizontal and Vertical offset values manually to fine tune plugin location."
L["X Offset"] = true
L["Y Offset"] = true
L["Left"] = true
L["Center"] = true
L["Right"] = true
L["Bottom"] = true
L["Bottom Left"] = true
L["Bottom Right"] = true
L["Top"] = true
L["Top Left"] = true
L["Top Right"] = true
L["Base Text Desc"] = "Define custom characters for the displayed suffix for this plugin. (Default: mb)" 
L["Base Text"] = true
L["Precision Desc"] = "Adjusts the decimal accuracy of the MB value shown."
L["Decimal Precision"] = true
L["Override Combat Hide"] = true
L["suppTTDesc"] = "When enabled, Tooltips will not be displayed."
L["suppTT"] = "Suppress Tooltips"
L["Tooltip"] = true
L["Tooltip Desc"] = "These options allow you to customize how the Tooltip positions in relation to the plugin display. Anchor will allow you to select the point on the Tooltip to use as an anchor point. Anchor From will allow you to select the point on the plugin display you want the Tooltip to anchor to."
L["Anchor"] = true
L["Anchor From"] = true

-- Classes
L["Druid"] = true
L["Hunter"] = true
L["Mage"] = true
L["Paladin"] = true
L["Priest"] = true
L["Rogue"] = true
L["Shaman"] = true
L["Warlock"] = true
L["Warrior"] = true