--[[ SLDataText - Copyright (C) 2008 Jeff "Taffu" Fancher | Last Revision: 1.02 | License: GPL v3.0 ]]
--[[ Core.lua - Revised: 04/03/2008 ]]

SLDataText = LibStub("AceAddon-3.0"):NewAddon("SLDataText", "AceEvent-3.0", "AceConsole-3.0")
local SML = LibStub("LibSharedMedia-3.0")
local TBL = SML:List("font")
local L = LibStub("AceLocale-3.0"):GetLocale("SLDataText")
local db

local defaults = {
    profile = {
        hideCombat = false,
        isLocked = true,
        coreFontFace = "Arial Narrow",
        coreFontSize = 16,
        valueColor = "White",
        btColor = "Rogue",
        modules = {
            ['*'] = true,
        },
    },
}

SLDataText.options = {
    type = "group",
    name = L["SLDataText"],
    plugins = {},
    childGroups = "tree",
    args = {
        intro = {
            order = 1,
            type = "description",
            name = L["SLDataText Desc"],
        },
        coreGlobals = {
            order = 2,
            type = "group",
            name = L["Core Globals"],
            guiInline = true,
            args = {
                hideCombat = {
                    order = 1,
                    type = "toggle",
                    name = L["Hide In Combat"],
                    get = function() return db.hideCombat end,
                    set = function() db.hideCombat = not db.hideCombat SLDataText:Refresh() end,
                },
                isLocked = {
                    order = 2,
                    type = "toggle",
                    name = L["Lock Plugins"],
                    get = function() return db.isLocked end,
                    set = function() db.isLocked = not db.isLocked SLDataText:Refresh() end,
                },
            },
        },
        coreOpts = {
            order = 3,
            type = "group",
            name = L["Core Options"],
            args = {
                coreFontIntro = {
                    order = 1,
                    type = "description",
                    name = L["Core Font Desc"],
                },
                coreFontFace = {
                    order = 2,
                    type = "select",
                    values = SML:List("font"),
                    name = L["Core Font Face"],
                    get = function()
                        for k, v in pairs(TBL) do
                            if v == db.coreFontFace then
                                return k
                            end
                        end
                    end,
                    set = function(_, font)
                        db.coreFontFace = TBL[font]
                        SLDataText:Refresh()
                    end,
                },
                spacer1 = { order = 3, type = "description", name = "" },
                coreFontSize = {
                    order = 4,
                    type = "range",
                    name = L["Core Font Size"],
                    min = 4, max = 36, step = 1,
                    get = function() return db.coreFontSize end,
                    set = function(_, value) db.coreFontSize = value SLDataText:Refresh() end,
                },
                coreColorIntro = {
                    order = 5,
                    type = "description",
                    name = L["Core Colors Desc"],
                },
                coreValueColor = {
                    order = 6,
                    type = "select",
                    values = function()
                        local client = GetLocale()
                        local colorlist = {}
                        for k in pairs(SLDataText.ColorTable[client]) do
                            rawset(colorlist, #colorlist + 1, k)
                        end
                        table.sort(colorlist)
                        return colorlist
                    end,
                    name = L["Value Color"],
                    get = function()
                        local client = GetLocale()
                        local colorlist = {}
                        for k in pairs(SLDataText.ColorTable[client]) do
                            rawset(colorlist, #colorlist + 1, k)
                        end
                        table.sort(colorlist)
                        for k, v in pairs(colorlist) do
                            if db.valueColor == v then
                                return k
                            end
                        end
                    end,
                    set = function(_, value)
                        local client = GetLocale()
                        local colorlist = {}
                        for k in pairs(SLDataText.ColorTable[client]) do
                            rawset(colorlist, #colorlist + 1, k)
                        end
                        table.sort(colorlist)
                        db.valueColor = colorlist[value]
                        SLDataText:Refresh()
                    end,
                },
                spacer2 = { order = 7, type = "description", name = "" },
                coreBaseTextColor = {
                    order = 8,
                    type = "select",
                    values = function()
                        local client = GetLocale()
                        local colorlist = {}
                        for k in pairs(SLDataText.ColorTable[client]) do
                            rawset(colorlist, #colorlist + 1, k)
                        end
                        table.sort(colorlist)
                        return colorlist
                    end,
                    name = L["Base Text Color"],
                    get = function()
                        local client = GetLocale()
                        local colorlist = {}
                        for k in pairs(SLDataText.ColorTable[client]) do
                            rawset(colorlist, #colorlist + 1, k)
                        end
                        table.sort(colorlist)
                        for k, v in pairs(colorlist) do
                            if db.btColor == v then
                                return k
                            end
                        end
                    end,
                    set = function(_, value)
                        local client = GetLocale()
                        local colorlist = {}
                        for k in pairs(SLDataText.ColorTable[client]) do
                            rawset(colorlist, #colorlist + 1, k)
                        end
                        table.sort(colorlist)
                        db.btColor = colorlist[value]
                        SLDataText:Refresh()
                    end,
                },
            },
        },
    },
}

SLDataText.JustTbl = { 
    ["LEFT"] = L["Left"],
    ["CENTER"] = L["Center"],
    ["RIGHT"] = L["Right"]
}

SLDataText.PointTbl = {
    ["LEFT"] = L["Left"],
    ["CENTER"] = L["Center"],
    ["RIGHT"] = L["Right"],
    ["BOTTOM"] = L["Bottom"],
    ["BOTTOMLEFT"] = L["Bottom Left"],
    ["BOTTOMRIGHT"] = L["Bottom Right"],
    ["TOP"] = L["Top"],
    ["TOPLEFT"] = L["Top Left"],
    ["TOPRIGHT"] = L["Top Right"],
}

function SLDataText:OnInitialize()
    self.db = LibStub("AceDB-3.0"):New("SLDataTextDB", defaults, "Default")
    db = self.db.profile
    self.options.args.profile = LibStub("AceDBOptions-3.0"):GetOptionsTable(self.db)
    
    local client = GetLocale()
    self.vColor = SLDataText.ColorTable[client][db.valueColor]
    self.btColor = SLDataText.ColorTable[client][db.btColor]
end

function SLDataText:OnEnable()
    LibStub("AceConfig-3.0"):RegisterOptionsTable("SLDataText", self.options)
    self:RegisterChatCommand(L["sldt"], function() LibStub("AceConfigDialog-3.0"):Open("SLDataText") end)
    self:RegisterChatCommand(L["sldatatext"], function() LibStub("AceConfigDialog-3.0"):Open("SLDataText") end)
    -- Events for global combat hide
    self:RegisterEvent("PLAYER_ENTERING_WORLD", "Refresh")
    self:RegisterEvent("PLAYER_REGEN_ENABLED")
    self:RegisterEvent("PLAYER_REGEN_DISABLED")
end

function SLDataText:PLAYER_REGEN_DISABLED() -- In Combat
    if ( db.hideCombat ) then
        for k, v in self:IterateModules() do
            if ( v:IsEnabled() and not v.db.profile.overrideCombatHide ) then
                v.frame:Hide()
            end
        end
    end
end

function SLDataText:PLAYER_REGEN_ENABLED() -- Out of Combat
    if ( db.hideCombat ) then
        for k, v in self:IterateModules() do
            if ( v:IsEnabled() ) then
                v.frame:Show()
            end
        end
    end
end

function SLDataText:Refresh()
    -- Refresh enabled plugins
	for k, v in self:IterateModules() do
		if self:GetModuleEnabled(k) and not v:IsEnabled() then
			self:EnableModule(k)
		elseif not self:GetModuleEnabled(k) and v:IsEnabled() then
			self:DisableModule(k)
		end
		if v.Refresh and v:IsEnabled() then
			v:Refresh()
		end
	end
end

function SLDataText:OnDisable()
    -- Reserved
end

function SLDataText:InjectOptions(name, opts)
	self.options.plugins[name] = opts
end

function SLDataText:GetModuleEnabled(module)
	return db.modules[module]
end

function SLDataText:SetModuleEnabled(module, value)
	local prev = db.modules[module]
	db.modules[module] = value
	if prev ~= value then
		if value then self:EnableModule(module)
		else self:DisableModule(module) end
	end
end

--[[ Movement Functions ]]

function SLDataText:MoveFrame(plugin, pdb)
    plugin.frame:SetPoint(pdb.justify, pdb.pos.anchor, pdb.pos.anchorFrom, pdb.pos.x, pdb.pos.y)
    plugin.isMoving = true
    if ( not db.isLocked ) then plugin.frame:StartMoving() else end
end

function SLDataText:StopFrame(plugin, pdb)
    plugin.frame:StopMovingOrSizing()
    plugin.isMoving = false
    local aP, _, aF, x, y = plugin.frame:GetPoint()
    local anchor = plugin.frame:GetParent():GetName()
    local offX, offY = TranslateCoords(plugin, pdb.justify, aF, x, y)
    
    pdb.pos.anchorPoint, pdb.pos.anchor, pdb.pos.anchorFrom, pdb.pos.x, pdb.pos.y = pdb.justify, anchor, aF, floor(offX), floor(offY)
end

function TranslateCoords(plugin, just, aF, x, y)
    local y1, x1
    
    if      ( aF == "TOP" or aF == "TOPLEFT" or aF == "TOPRIGHT" ) then                               y1 = plugin.frame:GetHeight()/2; y = y - y1
    elseif  ( aF == "BOTTOM" or aF == "BOTTOMLEFT" or aF == "BOTTOMRIGHT" ) then                      y1 = plugin.frame:GetHeight()/2; y = y + y1 end
    
    if      ( just == "RIGHT" and (aF == "TOPRIGHT" or aF == "RIGHT" or aF == "BOTTOMRIGHT") ) then   x = x
    elseif  ( just == "RIGHT" and (aF == "TOPLEFT" or aF == "LEFT" or aF == "BOTTOMLEFT") ) then      x1 = plugin.frame:GetWidth(); x = x + x1
    elseif  ( just == "RIGHT" and (aF == "CENTER" or aF == "TOP" or aF == "BOTTOM") ) then            x1 = plugin.frame:GetWidth()/2; x = x + x1
    elseif  ( just == "LEFT" and (aF == "TOPRIGHT" or aF == "RIGHT" or aF == "BOTTOMRIGHT") ) then    x1 = plugin.frame:GetWidth(); x = x - x1
    elseif  ( just == "LEFT" and (aF == "TOPLEFT" or aF == "LEFT" or aF == "BOTTOMLEFT") ) then       x = x
    elseif  ( just == "LEFT" and (aF == "CENTER" or aF == "TOP" or aF == "BOTTOM") ) then             x1 = plugin.frame:GetWidth()/2; x = x - x1
    elseif  ( just == "CENTER" and (aF == "TOPLEFT" or aF == "LEFT" or aF == "BOTTOMLEFT") ) then     x1 = plugin.frame:GetWidth()/2; x = x + x1
    elseif  ( just == "CENTER" and (aF == "TOPRIGHT" or aF == "RIGHT" or aF == "BOTTOMRIGHT") ) then  x1 = plugin.frame:GetWidth()/2; x = x - x1
    elseif  ( just == "CENTER" and (aF == "CENTER" or aF == "TOP" or aF == "BOTTOM") ) then           x = x end
    
    return x, y
end