
local db;


local L = AceLibrary("AceLocale-2.2"):new("SEasyRot")
local sm = AceLibrary("SharedMedia-1.0");
local wf = AceLibrary("Waterfall-1.0");
L:RegisterTranslations("enUS", function() return {
  ["Auto Shot"] = true,
  ["Multi-Shot"] = true,
  ["Arcane Shot"] = true,
  ["Steady Shot"] = true,
  ["Quick Shots"] = true,
  ["Rapid Fire"] = true,
  ["Auto Shot Clip Range"] = true,
  ["Menu"] = true,
  ["Height"] = true,
  ["Open the options menu"] = true,
  ["Width"] = true,
  ["Auto Shot Clip"] = true,
  ["Locked"] = true,
  ["Lock the frame in place"] = true,
  ["GCD"] = true,
  ["Track Beasts"] = true,
} end );

L:RegisterTranslations("deDE", function() return {
  ["Auto Shot"] = "Automatischer Schuss",
  ["Multi-Shot"] = "Mehrfachschuss",
  ["Arcane Shot"] = "Arkaner Schuss",
  ["Steady Shot"] = "Zuverl\195\164ssiger Schuss",
  ["Quick Shots"] = "Schnelle Sch\195\188sse",
  ["Rapid Fire"] = "Schnellfeuer",
  ["Auto Shot Clip Range"] = "Auto-Schussverz\195\182gerung \"range\"",
  ["Menu"] = "Men\195\188",
  ["Height"] = "H\195\182he",
  ["Open the options menu"] = "Das Optionsmen\195\188 \195\182ffnen",
  ["Width"] = "Breite",
  ["Auto Shot Clip"] = "Auto-Schussverz\195\182gerung",
  ["Locked"] = "Gesperrt",
  ["Lock the frame in place"] = "Das Frame an dieser Stelle fixieren",
--  ["GCD"] = true, --global cooldown
  ["Track Beasts"] = "Wildtiere aufsp\195\188ren",
} end );

L:RegisterTranslations("koKR", function() return {
  ["Auto Shot"] = "자동 사격",
  ["Multi-Shot"] = "일제 사격",
  ["Arcane Shot"] = "신비한 사격",
  ["Steady Shot"] = "고정 사격",
  ["Quick Shots"] = "신속 사격",
  ["Rapid Fire"] = "속사",
  ["Auto Shot Clip Range"] = "자동 사격 클립 거리",
  ["Menu"] = "메뉴",
  ["Height"] = "높이",
  ["Open the options menu"] = "설정 메뉴를 엽니다.",
  ["Width"] = "길이",
  ["Auto Shot Clip"] = "자동 사격 클립",
  ["Locked"] = "고정",
  ["Lock the frame in place"] = "현재 위치에 바를 고정합니다.",
  ["GCD"] = "글로발 쿨다운",
  ["Track Beasts"] = "야수 추적",
} end );

local options = {
  type = 'group',
  args = {
    menu = {
      type = 'execute',
      name = L["Menu"],
      desc = L["Open the options menu"],
      func = function()
        SEasyRot:OnClick();
      end,
    },
  },
};


SEasyRot = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceEvent-2.0", "AceDB-2.0", "FuBarPlugin-2.0");
SEasyRot:RegisterChatCommand({"/SEasyRot", "/ser"}, options);
SEasyRot:RegisterDB( "SEasyRotDB", "SEasyRotDBPC" );
SEasyRot:RegisterDefaults( "profile", {
	targetonly = true,
  combatonly = false,
	future = 6;
  past = 1;
  width = 576;
  scale = 0.75;
  height = 168;
  showclip = true,
  locked = false,
  pos = {
    x = 0,
    y = 0,
    point = "CENTER",
    relpoint = "CENTER",
  },
  colors = {
    [L["Auto Shot"] ] = { 0.25, 0.57, 0.24 },
    [L["Multi-Shot"] ] = { 0.49, 0, 0.94},
    [L["Arcane Shot"] ] = { 0.19, 0.64, 0.72 },
    [L["Steady Shot"] ] = { 0.6, 0.72, 0.24},
    [L["Auto Shot Clip"] ] = { 0.5, 0, 0},
    [L["GCD"] ] = { 0, 0, 0 },  
  },
  rows = {
    [L["Auto Shot"] ] = 3,
    [L["Multi-Shot"] ] = 1,
    [L["Arcane Shot"] ] = 2,
    [L["Steady Shot"] ] = 4,
  },
  alphas = {
    [L["Auto Shot"] ] = 1,
    [L["Multi-Shot"] ] = 1,
    [L["Arcane Shot"] ] = 1,
    [L["Steady Shot"] ] = 1,
    [L["Auto Shot Clip"] ] = 1,
    [L["GCD"] ] = 1,
    line = 0.7,
  },
  bartex = {
  },
  defaulttex = "Smoothish",
} );
SEasyRot.barops = {};
local wfoptions = {
	type = 'group',
	args = {
    appearance = {
      type = 'group',
      name = "Appearance",
      args = {
        locked = {
          type = 'toggle',
          name = L["Locked"],
          desc = L["Lock the frame in place"],
          get = function()
            return db.locked;
          end,
          set = function(v)
            if v then
              SRotFrame:EnableMouse(false);
            else
              SRotFrame:EnableMouse(true);
            end
            db.locked = v;
          end,
        },
        height = {
          type = 'range',
          name = L["Height"],
          desc = 'How tall the frame is',
          min = 64,
          max = 256,
          step = 8,
          get = function()
            return db.height;
          end,
          set = function(v)
            db.height = v;
            SRotFrame:SetHeight(v);
            SRotFrameLine:SetHeight(v);
            for i=1, 4 do
              getglobal("SRotFrameBG"..i):SetHeight(v/8);
            end
            SRotFrameBG1:ClearAllPoints();
            SRotFrameBG1:SetPoint("BOTTOMLEFT", SRotFrame, "LEFT", 0, v/8);
            SRotFrameBG1:SetPoint("BOTTOMRIGHT", SRotFrame, "RIGHT", 0, v/8);
          end,
        },
        width = {
          type = 'range',
          name = L["Width"],
          desc = "How wide the frame is",
          min = 256,
          max = 1024,
          step = 8,
          get = function()
            return db.width;
          end,
          set = function(v)
            db.width = v;
            SRotFrame:SetWidth(v);
            SRotFrameLine:ClearAllPoints();
            SRotFrameLine:SetPoint( "CENTER", SRotFrame, "LEFT", (db.past / (db.past + db.future)) * v, 0);
          end
        },
        past = {
          type = 'range',
          desc = 'How much of the past to show',
          name = 'Past',
          min = 0,
          max = 20,
          step = 1,
          get = function()
            return db.past;
          end,
          set = function(v)
            db.past = v;
            SRotFrameLine:ClearAllPoints();
            SRotFrameLine:SetPoint( "CENTER", SRotFrame, "LEFT", (db.past / (db.past + db.future)) * db.width, 0);
          end,
        },
        future = {
          type = 'range',
          desc = 'How much of the future to show',
          name = 'Future',
          min = 5,
          max = 20,
          step = 1,
          get = function()
            return db.future;
          end,
          set = function(v)
            db.future = v;
            SRotFrameLine:ClearAllPoints();
            SRotFrameLine:SetPoint( "CENTER", SRotFrame, "LEFT", (db.past / (db.past + db.future)) * db.width, 0);
          end,
        },
        combatonly = {
          type = 'toggle',
          name = "Show Only in Combat",
          desc = "Hide/Show depending on current combat status",
          get = function()
            return db.combatonly;
          end,
          set = function(v)
            db.combatonly = v;
            if not v then SRotFrame:Show();
            else SRotFrame:Hide();
            end
          end,
        },
        scale = {
          type = 'range',
          name = 'Scale',
          desc = 'Scale of the whole mod',
          min = 0.25,
          max = 2,
          isPercent = true,
          step = 0.05,
          get = function()
            return db.scale;
          end,
          set = function(v)
            SRotFrame:SetScale(v);
            db.scale = v;
          end,
        },
      },
    },
	},
};
local names = {
  as = L["Auto Shot"],
  ars = L["Arcane Shot"],
  ss = L["Steady Shot"],
  ms = L["Multi-Shot"],
  asd = L["Auto Shot Clip"],
  gcd = L["GCD"],
};
SEasyRot.title = "Sorren's Easy Rotations";
SEasyRot.hasNoColor = true;
SEasyRot.defaultMinimapPosition = 300;
SEasyRot.independantProfile = true;
SEasyRot.cannotDetachTooltip = true;
SEasyRot.hideWithoutStandby = true;
SEasyRot.hasIcon = "Interface\\Icons\\Ability_Hunter_KillCommand";

function SEasyRot:OnInitialize()
	self.last = 0;
  self.bars = setmetatable({}, {__mode='k'});
  self.numBars = 0;
  self.cooldowns = {};
  self.basehaste = 1.15;
  self.auto = {};
	sm:Register("statusbar", "Smoothish", "Interface\\AddOns\\SEasyRotation\\Textures\\smoothish.tga");
end

function SEasyRot:OnEnable()
  db = self.db.profile; --saves a lot of typing
  if select(2,UnitClass("player")) ~= "HUNTER" then return; end
  self:RegisterEvent("SPELL_UPDATE_COOLDOWN", "UpdateCooldowns");
  self:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED", "SpellcastSucceeded");
  self:RegisterEvent("PLAYER_ALIVE", "CheckTalents", 1 );
  self:RegisterEvent("PLAYER_ENTERING_WORLD", "CheckTalents", 1);
  self:RegisterEvent("UNIT_SPELLCAST_START", "SpellcastStart");
  self:RegisterEvent("UNIT_AURA", "CheckAuras");
  self:RegisterEvent("UNIT_SPELLCAST_FAILED", "SpellcastFailed");
  self:RegisterEvent("PLAYER_REGEN_DISABLED", "CombatStart");
  self:RegisterEvent("PLAYER_REGEN_ENABLED", "CombatStop");
  
  self:CreateFrames();
  if db.combatonly then self.mframe:Hide(); end
  wf:Register('SEasyRot',
		'aceOptions', wfoptions,
		'title',"Sorren's Easy Rotations", 
		'colorR', 0.3, 
		'colorG', 0.7, 
		'colorB', 0.5
	);
end

function SEasyRot:CheckTalents()
  if not GetTalentInfo(1,20) then return; end
  self.basehaste = 1.15 * (1 + (0.04 * select(5, GetTalentInfo(1,20))));
  self.hawk = select(5,GetTalentInfo(1,1));
  self.haste = self.basehaste;
  if not self.steady then self:NewSteady(); end
end

function SEasyRot:NewSteady()
  if self.steady and self.steady.paused then
    return;
  end
  self.steady = self:AddBar( GetTime(), 1.5/self.haste, db.colors[L["Steady Shot"] ], db.rows[L["Steady Shot"] ], db.bartex[L["Steady Shot"] ], db.alphas[L["Steady Shot"] ] );
  self.steady.delay = 0;
end

function SEasyRot:SpellcastFailed(unit)
  if unit ~= "player" or not self.steady then return; end
  if not self.steady.paused and not self.steady:IsShown() then self:NewSteady() end
end

function SEasyRot:CombatStart()
  if db.combatonly then
    self.mframe:Show();
  end
end

function SEasyRot:CombatStop()
  if db.combatonly then
    self.mframe:Hide();
  end
end

function SEasyRot:CheckAuras(unit)
  if unit ~= "player" then return; end
  local i = 1;
  local haste = self.basehaste;
  local name;
  while(GetPlayerBuffName(i)) do
    name = GetPlayerBuffName(i);
    if name == L["Quick Shots"] then
      haste = haste * (1 + 0.03 * self.hawk);
    elseif name == L["Rapid Fire"] then
      haste = haste * 1.4;
    end
    i = i + 1;
  end
  self.haste = haste;
end

function SEasyRot:SpellcastStart(unit)
  if unit ~= "player" then return; end
  local spell, _, _, _, start, finish = UnitCastingInfo("player");
  if spell ~= L["Steady Shot"] then return; end
  start, finish = start/1000, finish/1000;
  if (self.steady == nil) then return; end
  self.steady.start = start;
  self.steady.duration = finish - start;
  self.steady.paused = nil;
  self.steady.delay = nil;
end

function SEasyRot:CreateFrames()
  local f = CreateFrame("Frame", "SRotFrame", UIParent);
  local _;
	f:EnableMouse(true);
  f:SetHeight(db.height);
  f:SetWidth(db.width);
  f:ClearAllPoints();
  f:SetPoint(db.pos.point, UIParent, db.pos.relpoint, db.pos.x, db.pos.y);
  f:SetScale(db.scale);
  f:SetMovable(true);
  f:RegisterForDrag("LeftButton");
  f:SetScript("OnDragStart", function() f:StartMoving(); end);
  f:SetScript("OnDragStop", function() f:StopMovingOrSizing(); db.pos.point, _, db.pos.relpoint, db.pos.x, db.pos.y = f:GetPoint() end); 
  f:SetScript("OnMouseUp", function() 
    if arg1 == "RightButton" then 
      self:OnClick();
    else
      if IsShiftKeyDown() then
        db.locked  = true;
        f:EnableMouse(false);
      end
    end 
  end); 
  f:Show();
  local offset = (db.past / (db.past + db.future)) * db.width;
  local t = f:CreateTexture("$parentLine", "ARTWORK");
  t:SetHeight(db.height);
  t:SetWidth(8);
  t:ClearAllPoints();
  t:SetPoint("CENTER", f, "LEFT", offset, 0);
  t:SetTexture("Interface\\AddOns\\SEasyRotation\\Textures\\line");
  t:Show(); 
  t = f:CreateTexture("$parentBG1", "BACKGROUND");
  t:ClearAllPoints();
  t:SetHeight(db.height/8);
  t:SetAlpha(0.2);
  t:SetTexture("Interface\\AddOns\\SEasyRotation\\Textures\\smoothish");
  t:Show();
  t:SetPoint("BOTTOMLEFT", f, "LEFT", 0, db.height/8);
  t:SetPoint("BOTTOMRIGHT", f, "RIGHT", 0, db.height/8);
  local i;
  for i=2,4 do
    t = f:CreateTexture("$parentBG"..i, "BACKGROUND");
    t:ClearAllPoints();
    t:SetHeight(db.height/8);
    t:SetAlpha(0.2);
    t:SetTexture("Interface\\AddOns\\SEasyRotation\\Textures\\smoothish");
    t:SetPoint("TOPRIGHT", "$parentBG"..(i-1), "BOTTOMRIGHT", 0, 0);
    t:SetPoint("TOPLEFT", "$parentBG"..(i-1), "BOTTOMLEFT", 0, 0);
    t:Show();
  end
  if db.locked then f:EnableMouse(false) end
  self.mframe = f;
end

function SEasyRot:GetTimePoint(t) --get the offset from the now line
  local ct = GetTime();
  local tl = t - ct;
  if t < ct - db.past then return 0; end
  if t > ct + db.future then return db.width; end
  return ((tl + db.past) / (db.past + db.future)) * db.width;
end

function SEasyRot:SpellcastSucceeded(unit, name)
  if unit ~= "player" then return; end
  if name == L["Auto Shot"] then
    local t = UnitRangedDamage("player");
    local ct = GetTime();
    if not self.auto.cur then
      self:NewAutoShot(ct);
    else
      self.auto.cur.start = ct;
      self.auto.cur.duration = t;
      self.auto.cur.delay = nil; --delays have to be cleared here in case a shot fires early
      self.auto.cur.paused = nil;
      if db.showclip then
        self.auto.curd.start = ct + t - 0.5;
        self.auto.curd.duration = 0.5;
        self.auto.curd.delay = nil; 
        self.auto.curd.paused = nil;
      end
    end
    self.auto.cur, self.auto.curd = self:NewAutoShot(ct + t);
    self.auto.cur.delay = 0;
    if db.showclip then
      self.auto.curd.delay = t - 0.5;
    end
  elseif name == L["Steady Shot"] then
    self:NewSteady();
  elseif name == L["Arcane Shot"] or name == L["Multi-Shot"]then
    self.cooldowns[name] = true;
  end
end

function SEasyRot:UpdateCooldowns(name)
  for c in pairs(self.cooldowns) do 
    local start, duration = GetSpellCooldown(c); --should only be called for spells we care about, so don't need enabled
    self:AddBar(start, duration, db.colors[c], db.rows[c], db.bartex[c], db.alphas[c]);
    self.cooldowns[c] = nil;
    start, duration = GetSpellCooldown(L["Track Beasts"]);
    self:AddBar(start, duration, db.colors[L["GCD"] ], db.rows[c], db.bartex[L["GCD"] ], db.alphas[L["GCD"] ], 3);
  end
end

function SEasyRot:NewAutoShot(ct)
  local t = UnitRangedDamage("player");
  local d;
  if db.showclip then
    d = self:AddBar(ct + t - 0.5, 0.5, db.colors[L["Auto Shot Clip"] ], db.rows[L["Auto Shot"] ], db.bartex[L["Auto Shot Clip"] ], db.alphas[L["Auto Shot Clip"] ], 3);
  end
  return self:AddBar(ct, t, db.colors[L["Auto Shot"] ], db.rows[L["Auto Shot"] ], db.bartex[L["Auto Shot"] ], db.alphas[L["Auto Shot"] ]), d; 
end

function SEasyRot:AddBar(start, duration, color, row, tex, alpha, level)
  local b = self:GetBar();
  b.start = start;
  b.duration = duration;
  b.y = -(db.height/8) * (row - 2);
  b.t:SetVertexColor(unpack(color));
  b.t:SetTexture(sm:Fetch("statusbar", tex or db.defaulttex));
  b:SetFrameLevel(level or 2);
  b:SetAlpha(alpha or 1);
  b.l:SetVertexColor(unpack(color));
  b.l:SetPoint("CENTER", b, "BOTTOMRIGHT", 0, -b.y);
  b:Show();
  return b;
end

local function barUpdate()
  if this.paused then return; end
  local t = GetTime();
  this:ClearAllPoints();
  if this.delay and this.start <= t + this.delay then
    this.start = t + this.delay;
    this.delay = nil;
    this.paused = true;
  end
  if t - db.past > this.start + this.duration then --check if it's finished, offset function takes care of the rest
    SEasyRot.bars[this] = true;
    this:Hide();
    if this == SEasyRot.steady then SEasyRot.steady = nil; end
    return;
  else
    this:SetPoint("BOTTOMRIGHT", SEasyRot.mframe, "LEFT", SEasyRot:GetTimePoint(this.start + this.duration), this.y);
  end
  this:SetPoint("BOTTOMLEFT", SEasyRot.mframe, "LEFT", SEasyRot:GetTimePoint(this.start), this.y);
end

function SEasyRot:GetBar()
  local b = next(self.bars);
  if not b then
    self.numBars = self.numBars + 1;
    b = CreateFrame("Frame", "SEasyRotBar"..self.numBars, self.mframe);
    b:SetHeight(db.height/8);
    b:SetWidth(10);
    b:ClearAllPoints();
    b:SetPoint("CENTER", UIParent, "CENTER", 0, 0);
    local l = b:CreateTexture("$parentLine", "ARTWORK");
    l:ClearAllPoints();
    l:SetHeight(db.height);
    l:SetWidth(4);
    l:SetAlpha(0.7);
    l:SetTexture("Interface\\AddOns\\SEasyRotation\\Textures\\line");
    b.l = l;
    local t = b:CreateTexture("$parentBar", "BACKGROUND");
    t:ClearAllPoints();
    t:SetAllPoints(b);
    t:SetTexture("Interface\\AddOns\\SEasyRotation\\Textures\\smoothish");
    b.OnUpdate = barUpdate;
    b:SetScript("OnUpdate", function() b.OnUpdate(self) end);
    b.t = t;
  else
    self.bars[b] = nil;
  end
  b:ClearAllPoints();
  return b;
end

function SEasyRot:SetOptions()
  for i,v in pairs(names) do
    wfoptions.args[i] = {
      type = 'group',
      name = v,
      args = self:GetOptions(v),
    };
  end
end

function SEasyRot:GetOptions(k)
  local o = {
    dtex = {
      name = "Use Default Texture",
      desc = "Use the default texture",
      type = 'toggle',
      get = function()
        return not db.bartex[k];
      end,
      set = function(v)
        if v then
          db.bartex[k] = nil;
        else
          db.bartex[k] = db.defaulttex;
        end
      end,
    },
    tex = {
      name = "Texture",
      type = 'text',
      desc = "Texture for this bar",
      disabled = function() return not db.bartex[k] end,
      get = function()
        return db.bartex[k] or db.defaulttex;
      end,
      set = function(v)
        db.bartex[k] = v;
      end,
      validate = sm:List("statusbar"),
    },
    color = {
      name = "Color",
      type = 'color',
      desc = "Bar Color",
      get = function()
        return unpack(db.colors[k]);
      end,
      set = function(r,g,b)
        db.colors[k] = {r,g,b};
      end,
    },
    alpha = {
      name = "Alpha",
      type = 'range',
      desc = "Bar Transparency",
      get = function()
        return db.alphas[k];
      end,
      set = function(v)
        db.alphas[k] = v;
      end,
      min = 0.1,
      max = 1,
      step = 0.05,
      isPercent = true,
    },
    row = {
      name = "Row",
      type = 'range',
      desc = "Row the bar appears on. Will shift other bars accordingly",
      get = function()
        return db.rows[k] or db.rows[L["Auto Shot"] ];
      end,
      set = function(v)
        for x,y in pairs(db.rows) do
          if y > db.rows[k] and y <= v then
            db.rows[x] = y - 1;
          elseif y < db.rows[k] and y >= v then
            db.rows[x] = y + 1;
          end
        end
        db.rows[k] = v;
      end,
      min = 1,
      max = 4,
      step = 1,
    },
  };
  if k == L["Auto Shot Clip"] then
    o.row = nil;
    o.enable = {
      name = "Enabled",
      type = 'toggle',
      desc = "Enable showing the potential clip range in Auto Shot",
      get = function()
        return db.showclip;
      end,
      set = function(v)
        db.showclip = v;
      end,
    };
  end
  if k == L["GCD"] then
    o.row = nil;
  end
  return o;
end

function SEasyRot:OnClick()
  self:SetOptions();
  wf:Open("SEasyRot");
end



