---------------------------------------------
-- SCT_SpellReady - SCT法术冷却提示
-- Author: lostcup @ NGACN
---------------------------------------------

SCT_SpellReady = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceDB-2.0", "AceConsole-2.0")

local Dewdrop = AceLibrary("Dewdrop-2.0")
local L = AceLibrary("AceLocale-2.2"):new("SCT_SpellReady")

-- 初始化

function SCT_SpellReady:OnInitialize()

	-- 设置选项菜单
	local options = {
		type = "group",
		args ={
			-- 框架选项
			frame = {
				order = 5,
				type = "text",
				name = L["SCT Frame"],
				desc = L["Select SCT frame to output spell ready messages."],
				get = function() return self.db.profile.frame end,
				set = function(v) self.db.profile.frame = v end,
				validate = {L["SCT Frame1"], L["SCT Frame2"], L["SCT Message"]},
			},
			-- 颜色选项
			color  = {
				order = 6,
				type = "color",
			name = L["Color"],
				desc = L["Select the spell ready message color."],
				get = function() return self.db.profile.color.r, SCT_SpellReady.db.profile.color.g, SCT_SpellReady.db.profile.color.b end,
				set =  function(r, g, b) self.db.profile.color.r, SCT_SpellReady.db.profile.color.g, SCT_SpellReady.db.profile.color.b = r, g, b end,
			},
			-- 添加法术
			add = {
				order = 1,
				type = "text",
				name = L["Add"],
				desc = L["Add a spell for checking if it is ready for cast."],
				usage = "<add>",
				get = false,
				set = function(v) 
					local i = 1
					local j = 1
					local found = false
					local name
					-- 检查是否在技能列表中有这个法术
					while true do
						local spellName, _ = GetSpellName(i, BOOKTYPE_SPELL)
						if v == spellName then
							found = true
							do break end
						end
						if not spellName then
							do break end
						end
						i = i + 1
					end
					if found then
						-- 检查法术列表中该技能是否已经存在
						while true do
							if self.db.profile.spells[j] == nil then
								table.insert(self.db.profile.spells, {v,i}) 
								self:Print(string.format(L["The spell %s is successfully added to the list."], v))
								do break end
							else
								name = self.db.profile.spells[j][1]
								if name == v then
									self:Print(L["The spell is already in the list."])
									do break end
								end
							end
							j = j + 1
						end					
					else
						self:Print(L["The spell cannot be found in your spellbook."])
					end
				end,
			},
			-- 列出所有关注的法术
			list = {
				order = 4,
				type = "execute",
				name = L["List"],
				desc = L["List all spells for checking if it is ready for cast."],
				func = function()
					local i =1
					local name
					while true do
						if self.db.profile.spells[i] == nil then
							if i == 1 then 
								self:Print(L["There is no spell in the list."])
							end
							do break end
						end
						name = self.db.profile.spells[i][1]
						self:Print(name)
						i = i+1
					end
				end,
			},
			-- 从列表里删除一个法术
			delete = {
				order = 2,
				type = "text",
				name = L["Remove"],
				desc = L["Remove a spell from the list."],
				usage = "<remove>",
				get = false,
				set = function(v)
					local i =1
					local found = false
					while self.db.profile.spells[i] do
						if self.db.profile.spells[i][1] == v then
							found = true
							table.remove(self.db.profile.spells, i)
							self:Print(string.format(L["The spell %s is successfully removed from the list."], v))
							do break end
						end
						i = i + 1
					end
					if not found then
						self:Print(string.format(L["The spell %s does not exist in the list."], v))
					end
				end,
			},
			-- 清除整个列表
			clear = {
				order = 3,
				type = "execute",
				name = L["Clear"],
				desc = L["Clear all spells from the list."],
				func = function ()
					self.db.profile.spells  = {}
					self:Print(L["All spells in the list were removed. The list is empty now."])
				end
			},
		}
	}

	local defaults = {
		-- 默认信息显示在静态信息框架
		frame = L["SCT Message"],
		color = {r = 255.0, g = 255.0, b = 255.0},
		spells = {},

	}

	self:RegisterChatCommand("/sctsr", {type = "execute", func = "ShowOptions"})
	self:RegisterDB("SCT_SpellReadyDB")
	self:RegisterDefaults('profile', defaults)
	Dewdrop:Register("SCT_SpellReady", "children", options, "cursorX", true, "cursorY", true)

	self.OnMenuRequest = options;
end

function SCT_SpellReady:ShowOptions()
	Dewdrop:Open("SCT_SpellReady")
end

function SCT_SpellReady:OnEnable()
	self.cooldowns ={}
	self.spells = {}
	self.minDur = 2

	self:ScheduleEvent(self.OnUpdate, 0.1, self)
	self:RegisterEvent("PLAYER_ENTERING_WORLD")
	self:RegisterEvent("SPELL_UPDATE_COOLDOWN")
	self:RegisterEvent("SPELLS_CHANGED")
end

function SCT_SpellReady:UpdateCooldown()
	local i = 1
	local name
	-- 检查关注列表中是否有法术触发了冷却时间
	while self.db.profile.spells[i] do
		name = self.db.profile.spells[i][1]
		index = self.db.profile.spells[i][2]
		local startTime, dur, _ = GetSpellCooldown(index, BOOKTYPE_SPELL)
		if dur == nil then
			dur = -1
		end
		-- 若冷却时间大于公共CD，且不在冷却列表，则添加至冷却列表
		if dur > self.minDur then
			local j = 1
			local found = false
			-- 若在冷却列表中，且冷却触发时间不同，更新冷却触发时间
			while self.cooldowns[j] do
				if self.cooldowns[j][1] == name then
					found = true
					if startTime ~= self.cooldowns[j][2] then
						self.cooldowns[j][2] = startTime
						do break end
					end
				end
				j = j + 1
			end
			if not found then
				table.insert(self.cooldowns, {name, startTime, index})
			end
		end
		i = i + 1
	end
end

function SCT_SpellReady:PLAYER_ENTERING_WORLD()
	self:UpdateCooldown()
end

function SCT_SpellReady:SPELL_UPDATE_COOLDOWN()
	self:UpdateCooldown()
end

function SCT_SpellReady:SPELLS_CHANGED()
	self:UpdateCooldown()
end

function SCT_SpellReady:OnUpdate()
	self:ScheduleEvent(self.OnUpdate, 0.1, self);

	local i =1
	while self.cooldowns[i] do
		if self.cooldowns[i][2] then
			local startTime, dur, _ = GetSpellCooldown(self.cooldowns[i][3], BOOKTYPE_SPELL)
			-- 当冷却列表中技能的冷却持续时间为零，则输出冷却完毕提示
			if dur == 0 then
				if self.db.profile.frame == L["SCT Frame1"] then
					SCT:DisplayText(string.format(L["%s is ready!"],self.cooldowns[i][1]), self.db.profile.color, nil, SCT.Frame1, 1);
				elseif self.db.profile.frame == L["SCT Frame2"] then
					SCT:DisplayText(string.format(L["%s is ready!"],self.cooldowns[i][1]), self.db.profile.color, nil, SCT.Frame2, 1);
				else
					SCT:DisplayMessage(string.format(L["%s is ready!"],self.cooldowns[i][1]), self.db.profile.color)
				end
				table.remove(self.cooldowns, i)
			end
		end
		i = i + 1
	end
end