SCT_Cooldowns = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceDB-2.0", "AceConsole-2.0");
local L = AceLibrary("AceLocale-2.2"):new("SCT_Cooldowns");

sctcVars = {};
minDuration = 2;

SCTC_NAME			= "SCT Cooldowns";
SCTC_VERSION		= "7";

SCTC_DebugPrint		= false;

SCT_Cooldowns:RegisterDB("SCT_Cooldowns_Options")
	SCT_Cooldowns:RegisterDefaults("profile", {
		crit		= false,
		color		= {r = 1.0, g = 1.0, b = 1.0},
		disabled	= {"Do Not Remove This One KK THX BAI"},
		frame		= 1,
		format		= L["[%s Ready]"],
		icon		= false;
		warning		= 0,
		wformat		= L["[%s Ready in %d]"]
	}
)

SCTC_GROUPS = {
	[L["Traps"]] = {
		[1] = L["Freezing Trap"],
		[2] = L["Immolation Trap"],
		[3] = L["Explosive Trap"],
		[4] = L["Frost Trap"],
		[5] = L["Snake Trap"]
	},
	[L["Reta/SW/Reck"]] = {
		[1] = L["Retaliation"],
		[2] = L["Shield Wall"],
		[3] = L["Recklessness"]
	},
	[L["Shocks"]] = {
		[1] = L["Earth Shock"],
		[2] = L["Flame Shock"],
		[3] = L["Frost Shock"]
	},
	[L["Wards"]] = {
		[1] = L["Frost Ward"],
		[2] = L["Fire Ward"]
	},
	[L["Ranged"]] = {
		[1] = L["Shoot"],
		[2] = L["Throw"]
	},
	[L["Bubble"]] = {
		[1] = L["Divine Shield"],
		[2] = L["Divine Protection"]
	}
};

options = {
    type='group',
    args = {
        format = {
            type = 'text',
            name = L["format"],
            desc = L["Change the format string, or reset (%s is replaced by the spell name)."],
            usage = L["[string/reset]"],
            get = "GetFormat",
            set = "SetFormat"
        },
        warning = {
            type = 'text',
            name = L["warning"],
            desc = L["Show a warning x seconds before cooldown finishes (0 to disable)."],
            usage = L["[seconds]"],
            get = "GetWarning",
            set = "SetWarning"
        },
        wformat = {
            type = 'text',
            name = L["wformat"],
            desc = L["Change the format string of the warning message, or reset (%s is replaced by the spell name)."],
            usage = L["[seconds]"],
            get = "GetWFormat",
            set = "SetWFormat"
        },
        disable = {
            type = 'text',
            name = L["disable"],
            desc = L["Disable the message for that spell. Run it again to enable."],
            usage = L["[spell name]"],
            get = "GetDisable",
            set = "SetDisable"
        },
        color = {
            type = 'color',
            name = L["color"],
            desc = L["Change the color of the cooldown messages."],
            get = "GetColor",
            set = "SetColor"
        },
        crit = {
            type = 'toggle',
            name = L["crit"],
            desc = L["Show message like a crit."],
            get = "GetCrit",
            set = "SetCrit"
        },
        frame = {
            type = 'text',
            name = L["frame"],
            desc = L["Change the frame cooldowns are displayed in."],
            usage = L["[1/2/msg]"],
            get = "GetFrame",
            set = "SetFrame"
        },
        icon = {
            type = 'toggle',
            name = L["icon"],
            desc = L["Display cooldown Icon in SCT."],
            get = "GetIcon",
            set = "SetIcon"
        }
    }
};

SCT_Cooldowns:RegisterChatCommand(L["/sctcooldowns"], L["/sctc"], options);

function SCT_Cooldowns:OnInitialize()

	self:ScheduleEvent(self.OnUpdate, 0.1, self);
	self:RegisterEvent("SPELLS_CHANGED");
	self:RegisterEvent("PLAYER_ENTERING_WORLD");
	self:RegisterEvent("SPELL_UPDATE_COOLDOWN");
	self:DebugPrint("Loaded")
end


function SCT_Cooldowns:PLAYER_ENTERING_WORLD()
    self:DebugPrint("Entering World")
	self:UpdateSpells()
end

function SCT_Cooldowns:SPELLS_CHANGED()
    self:DebugPrint("Spells Changed")
	self:UpdateSpells()
end

function SCT_Cooldowns:SPELL_UPDATE_COOLDOWN()
    self:DebugPrint("Update Cooldowns")
	
	sctcVars.numCds = 0;
	for key, val in pairs(sctcVars.spells) do
		local startTime, duration, flag = GetSpellCooldown(val, BOOKTYPE_SPELL);
		local name = GetSpellName(val, BOOKTYPE_SPELL);

		if (duration > minDuration) then
			if (startTime ~= sctcVars["cooldowns"][name]) then
				if (not self.db.profile.disabled[name]) then
					sctcVars["cooldowns"][name] = startTime;
					if (self.db.profile.warning >= 0 and duration > self.db.profile.warning) then
						sctcVars["warnings"][name] = startTime;
					end
					sctcVars.numCds = sctcVars.numCds + 1;
				end
			end
		end
	end	
end

function SCT_Cooldowns:UpdateSpells()
	sctcVars.numSpells = 1;
	sctcVars.spells = {};
	sctcVars.cooldowns = {};
	sctcVars.warnings = {};
	sctcVars.numCds = 0;
	sctcVars.numTabs = 1;
	sctcVars.tabs = {};

	while (GetSpellTabInfo(sctcVars.numTabs)) do
		sctcVars.tabs[sctcVars.numTabs] = {};
		local name, _, offset, numSpells = GetSpellTabInfo(sctcVars.numTabs);
		
		sctcVars.tabs[sctcVars.numTabs].name = name;
		sctcVars.tabs[sctcVars.numTabs].offset_start = offset + 1;
		sctcVars.tabs[sctcVars.numTabs].offset_end = offset + numSpells;
		
		sctcVars.numTabs = sctcVars.numTabs + 1;
	end
	
	local currTab = 1;
	while (GetSpellName(sctcVars.numSpells, BOOKTYPE_SPELL)) do
		local name = GetSpellName(sctcVars.numSpells, BOOKTYPE_SPELL);
		local nextName = GetSpellName(sctcVars.numSpells+1, BOOKTYPE_SPELL);
		if (name ~= nextName) then
			table.insert(sctcVars.spells, sctcVars.numSpells);
			
			while (sctcVars.numSpells > sctcVars.tabs[currTab].offset_end) do
				currTab = currTab + 1;
			end
			
			if not sctcVars.tabs[currTab].spells then
				sctcVars.tabs[currTab].spells = {};
			end
			
			table.insert(sctcVars.tabs[currTab].spells, sctcVars.numSpells);
			
		end
		
		sctcVars.numSpells = sctcVars.numSpells + 1;
	end
end

function SCT_Cooldowns:OnUpdate()
	local icon
	self:DebugPrint("Update");
	self:ScheduleEvent(self.OnUpdate, 0.1, self);
	
	for key, val in pairs(sctcVars.spells) do

		local name = GetSpellName(val, BOOKTYPE_SPELL);
		if (sctcVars["cooldowns"][name] and not self.db.profile.disabled[name]) then
			local startTime, duration, flag = GetSpellCooldown(val, BOOKTYPE_SPELL);
			local found = false;
			local group;
			for key in pairs(SCTC_GROUPS) do
				for val in pairs(SCTC_GROUPS[key]) do
					if (name == SCTC_GROUPS[key][val]) then
						found = true;
						group = key;
					end
				end
			end
						
			icon = self.db.profile.icon and name or nil;
			
			if (self.db.profile.warning > 0) then
				local timeleft;
				timeleft = floor(sctcVars["cooldowns"][name] + duration - GetTime());
				if (timeleft == self.db.profile.warning and sctcVars["warnings"][name]) then
					if (found) then
						if (self.db.profile.frame == "msg") then
							SCT:DisplayMessage(string.format(self.db.profile.wformat, group, timeleft), self.db.profile.color);
						else
							SCT:DisplayText(string.format(self.db.profile.wformat, group, timeleft), self.db.profile.color, self.db.profile.crit, "event", self.db.profile.frame, nil, nil, icon);
						end
						
						for key, val in pairs(SCTC_GROUPS[group]) do
							sctcVars["warnings"][val] = nil;
						end
					else
						if (self.db.profile.frame == "msg") then
							SCT:DisplayMessage(string.format(self.db.profile.wformat, name, timeleft), self.db.profile.color);
						else
							SCT:DisplayText(string.format(self.db.profile.wformat, name, timeleft), self.db.profile.color, self.db.profile.crit, "event", self.db.profile.frame, nil, nil, icon);
						end
						
						sctcVars["warnings"][name] = nil;
					end
				end
			end
			
			if (duration == 0) then
				if (found) then
					if (self.db.profile.frame == "msg") then
						SCT:DisplayMessage(string.format(self.db.profile.format, group), self.db.profile.color);
					else
						SCT:DisplayText(string.format(self.db.profile.format, group), self.db.profile.color, self.db.profile.crit, "event", self.db.profile.frame, nil, nil, icon);
					end
					
					for key, val in pairs(SCTC_GROUPS[group]) do
						sctcVars["cooldowns"][val] = nil;
					end
				else
					if (self.db.profile.frame == "msg") then
						SCT:DisplayMessage(string.format(self.db.profile.format, name), self.db.profile.color);
					else	
						SCT:DisplayText(string.format(self.db.profile.format, name), self.db.profile.color, self.db.profile.crit, "event", self.db.profile.frame, nil, nil, icon);
					end
					
					sctcVars["cooldowns"][name] = nil;
				end
				sctcVars.numCds = sctcVars.numCds - 1;
			end
		end
	end
end

function SCT_Cooldowns:GetFormat()
	return self.db.profile.format;
end

function SCT_Cooldowns:SetFormat(newValue)
	if newValue == "reset" then
		self.db.profile.format = L["[%s Ready]"];
	else
		self.db.profile.format = newValue;
	end
end

function SCT_Cooldowns:GetWFormat()
	return self.db.profile.wformat;
end

function SCT_Cooldowns:SetWFormat(newValue)
	if newValue == "reset" then
		self.db.profile.wformat = L"[%s Ready in %d]";
	else
		self.db.profile.wformat = newValue;
	end
end

function SCT_Cooldowns:GetWarning()
	return self.db.profile.warning;
end

function SCT_Cooldowns:SetWarning(newValue)
	self.db.profile.warning = tonumber(newValue);
end

function SCT_Cooldowns:GetDisable()
	DISABLED = "";
	i = 0;
	for key, val in pairs(self.db.profile.disabled) do
		if i == 1 then
			DISABLED = DISABLED.." - "..key;
		else
			DISABLED = key;
			i = 1;
		end
	end
	return DISABLED;
end

function SCT_Cooldowns:SetDisable(newValue)
	if (not self.db.profile.disabled[newValue]) then
		self.db.profile.disabled[newValue] = true;
	else
		self.db.profile.disabled[newValue] = nil;
	end
end

function SCT_Cooldowns:GetColor()
	return self.db.profile.color.r, self.db.profile.color.g, self.db.profile.color.b;
end

function SCT_Cooldowns:SetColor(newR, newG, newB)
	self.db.profile.color = {r = newR, g = newG, b = newB};
end

function SCT_Cooldowns:GetCrit()
	return self.db.profile.crit;
end

function SCT_Cooldowns:SetCrit(newValue)
	self.db.profile.crit = newValue;
end

function SCT_Cooldowns:GetFrame()
	return self.db.profile.frame;
end

function SCT_Cooldowns:SetFrame(newValue)
	if newValue == "1" then
		self.db.profile.frame = 1;
	elseif newValue == "2" then
		self.db.profile.frame = 2;
	elseif newValue == "msg" then
		self.db.profile.frame = "msg";
	end
end

function SCT_Cooldowns:GetIcon()
	return self.db.profile.icon;
end

function SCT_Cooldowns:SetIcon(newValue)
	self.db.profile.icon = newValue;
end

function SCT_Cooldowns:GetMessage()
	return self.message;
end

function SCT_Cooldowns:SetMessage(newValue)
	self.message = newValue;
end

function SCT_Cooldowns:DebugPrint(text)
	if SCTC_DebugPrint == true then
		ChatFrame2:AddMessage("SCTC Debug: "..text);
	end
end