------------------------------------------------------------------------------
-- Configuration
------------------------------------------------------------------------------




local useSound    =     true;

local bsnotify    =     6;
local bscolor     =     {["r"]=0.9,["g"]=0.9,["b"]=0};
local bstext      =     "Battle Shout fading";

local csnotify    =     12;
local cscolor     =     {["r"]=0.9,["g"]=0.9,["b"]=0};
local cstext      =     "Commanding Shout fading";




------------------------------------------------------------------------------
-- Do not edit below if you are unexperienced
------------------------------------------------------------------------------























































































































------------------------------------------------------------------
-- Initialize
------------------------------------------------------------------
function sctb_Init()
	--DEFAULT_CHAT_FRAME:AddMessage("SCT BattleShout loaded");
end




------------------------------------------------------------------
-- Register the event
------------------------------------------------------------------
function sctb_OnLoad()
	this:RegisterEvent("PLAYER_AURAS_CHANGED");
end




------------------------------------------------------------------
-- Set the variables
------------------------------------------------------------------
local bsindex = 0;
local bsfading = false;
local bstime;
local csindex = 0;
local csfading = false;
local cstime;
local down = "Interface\\AddOns\\SCTBattleShout\\down.wav";
local up = "Interface\\AddOns\\SCTBattleShout\\up.wav";




------------------------------------------------------------------
-- What indexnumber is my buff
------------------------------------------------------------------
function sctb_OnEvent(event)
	bsindex = 0;
	csindex = 0;
	for i = 1, 16, 1 do
		local n = GetPlayerBuffName(i);
		if (n == "Battle Shout") then
			bsindex = i;
		end
		if (n == "Commanding Shout") then
			csindex = i;
		end
	end

end




--------------------------------------------------------------------
-- Display the message with SCT
--------------------------------------------------------------------
function sctb_OnUpdate(arg1)
	if (bsindex > 0) then
		bstime = GetPlayerBuffTimeLeft(bsindex);
		if (bstime < bsnotify and not bsfading) then
			SCT:DisplayMessage(bstext, bscolor);
			if (useSound) then
				PlaySoundFile(down);
			end
			bsfading = true;
		elseif (bstime > 118) then
			if (useSound and bsfading) then
				PlaySoundFile(up);
			end
			bsfading = false;
		end
	end
	if (csindex > 0) then
		cstime = GetPlayerBuffTimeLeft(csindex);
		if (cstime < csnotify and not csfading) then
			SCT:DisplayMessage(cstext, cscolor);
			if (useSound) then
				PlaySoundFile(down);
			end
			csfading = true;
		elseif (cstime > 118) then
			if (useSound and csfading) then
				PlaySoundFile(up);
			end
			csfading = false;
		end
	end
end




--------------------------------------------------------------------
-- End Of File
--------------------------------------------------------------------