-- Rouge addon,  by Dezyne 2008 -----------------------------------------------------------------------------------------------------------------------------------------------
			-- Version: 2.0 ----------------------------------------------------------------------------------------------------------------------------------------------
--
--
---------- FUNCTIONS -------------------------------------------------------------------------------------------------------------------------------------------------------------

-- round with dec decimals
function Round(num, dec)
	if(not num) then return 0; end;
    local mult = 10 ^ (dec or 0);
    return math.floor(num * mult + 0.5) / mult;
end;

-- get slice and dice remaining time
function SndDuration(sndTime)
	local ret = 0; if(sndTime < 0) then -- refresh forced?
		local i, name, rank, iconTexture, count, duration, timeLeft = 1, UnitBuff("player", 1);
		while((name ~= "Slice and Dice") and (i < 16) and (duration)) do
			i = i + 1; name, rank, iconTexture, count, duration, timeLeft = UnitBuff("player", i);
		end;
		if((name ~= "Slice and Dice") or (not timeLeft)) then ret, sndTime = 0, -1; else ret, sndTime = Round(timeLeft, 2), GetTime()+timeLeft; end;
	else -- normal countdown
		if(sndTime < GetTime()) then sndTime, ret = 0, 0;
		else ret = Round(sndTime-GetTime(), 2); end;
	end;
	return ret, sndTime;
end;

-- get spell cooldown remaining
function CooldownOn(spell)
	local start, duration, enabled = GetSpellCooldown(spell);
	if(not duration) then return 0; else return duration; end;
end;

-- set a button's properties
function SetButton(frame, button, num, spell, icon)
	button:SetWidth(32); button:SetHeight(32); button:SetPoint("LEFT", frame, "LEFT", 34*num, 0);
	button:RegisterForClicks("LeftButtonDown"); button:SetAttribute("type1", "spell");
	button:SetAttribute("spell1", spell); button:SetNormalTexture("Interface\\Icons\\"..icon);
	button:SetHighlightTexture("Interface\\Buttons\\ButtonHilight-Square.blp");
end;


---------- INITIALISE -------------------------------------------------------------------------------------------------------------------------------------------------------------

-- declare and initialise
if((select(2, UnitClass("player"))) ~= "ROGUE") then return; end;
local sndTime, n, init, movable, moving, f = 0, 0, nil, false, false, CreateFrame("FRAME", "Rouge_Frame", UIParent);
local BtnBF, BtnSS, BtnAR, BtnPM, BtnCB = CreateFrame("BUTTON", "BtnBF", f, "SecureActionButtonTemplate"), CreateFrame("BUTTON", "BtnSS", f, "SecureActionButtonTemplate"), CreateFrame("BUTTON", "BtnAR", f, "SecureActionButtonTemplate"), CreateFrame("BUTTON", "BtnPM", f, "SecureActionButtonTemplate"), CreateFrame("BUTTON", "BtnCB", f, "SecureActionButtonTemplate");
local BtnPP, BtnV, BtnCS, BtnS, BtnE = CreateFrame("BUTTON", "BtnPP", f, "SecureActionButtonTemplate"), CreateFrame("BUTTON", "BtnV", f, "SecureActionButtonTemplate"), CreateFrame("BUTTON", "BtnCS", f, "SecureActionButtonTemplate"), CreateFrame("BUTTON", "BtnS", f, "SecureActionButtonTemplate"), CreateFrame("BUTTON", "BtnE", f, "SecureActionButtonTemplate");
local abilities = {
	["Blade Flurry"] = {
		Btn = BtnBF;
		Slot = 0;
		Icon = "Ability_Warrior_PunishingBlow.blp";
		Exists = false;
	};
	["Shadowstep"] = {
		Btn = BtnSS;
		Slot = 0; -- can savely overlap with Blade Flurry; can't both be talented
		Icon = "Ability_Rogue_Shadowstep.blp";
		Exists = false;
	};
	["Adrenaline Rush"] = {
		Btn = BtnAR;
		Slot = 1;
		Icon = "Spell_Shadow_ShadowWordDominate.blp";
		Exists = false;
	};
	["Premeditation"] = {
		Btn = BtnPM;
		Slot = 1; -- can savely overlap with Adrenaline Rush; can't both be talented
		Icon = "Spell_Shadow_Possession.blp";
		Exists = false;
	};
	["Cold Blood"] = {
		Btn = BtnCB;
		Slot = 2;
		Icon = "Ability_Creature_Cursed_05.blp";
		Exists = false;
	};
	["Preparation"] = {
		Btn = BtnPP;
		Slot = 3;
		Icon = "Spell_Shadow_AntiShadow.blp";
		Exists = false;
	};
	["Vanish"] = {
		Btn = BtnV;
		Slot = 4; -- stationary, most rogues have this
		Icon = "Ability_Vanish.blp";
		Exists = false;
	};
	["Cloak of Shadows"] = {
		Btn = BtnCS;
		Slot = 5; -- stationary, most rogues have this
		Icon = "Spell_Shadow_NetherCloak.blp";
		Exists = false;
	};
	["Sprint"] = {
		Btn = BtnS;
		Slot = 6; -- stationary, most rogues have this
		Icon = "Ability_Rogue_Sprint.blp";
		Exists = false;
	};
	["Evasion"] = {
		Btn = BtnE;
		Slot = 7; -- stationary, most rogues have this
		Icon = "Spell_Shadow_ShadowWard.blp";
		Exists = false;
	};
};


---------- PROGRAM -----------------------------------------------------------------------------------------------------------------------------------------------------------------

-- create the outline frame
f:SetWidth(310); f:SetHeight(36);
f:SetPoint("TOPLEFT", UIParent, "TOPLEFT"); -- WoW will remember positioning
f:EnableMouse(true); f:SetMovable(true);
f:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
f:SetScript("OnMouseDown", function() if(movable) then f:StartMoving(); moving = true; end; end);
f:SetScript("OnMouseUp", function() if(moving) then f:StopMovingOrSizing(); moving = false; end; end);
f:SetScript("OnEvent", function(timestamp, event, ...) -- to catch a slice and dice activate/refresh
	if(arg2 == "SPELL_CAST_SUCCESS") then if((arg3 == UnitGUID("player")) and (arg10 == "Slice and Dice")) then
		sndTime = -1;
	end; end;
end);
f:SetBackdrop({
	bgFile = nil,
	edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border",
	tile = 1, tileSize = 10, edgeSize = 10,
	insets = { left = 3, right = 3, top = 3, bottom = 3 }
});

-- build checkbutton
local BtnMove = CreateFrame("CHECKBUTTON", "BtnMove", f, "OptionsCheckButtonTemplate");
BtnMove:SetPoint("RIGHT", f, "RIGHT", 0, 0); BtnMove:SetChecked(movable);

-- put in a status bar
local b = CreateFrame("STATUSBAR", "$parentHealthBar", f, "TextStatusBar");
b:SetWidth(310); b:SetHeight(14); b:SetPoint("TOP", f, "BOTTOM");
b:SetStatusBarTexture("Interface\\TargetingFrame\\UI-StatusBar");
b:SetStatusBarColor(0.0, 0.0, 0.6, 0.9); b:SetMinMaxValues(0, 34);
b:SetScript("OnMouseDown", function() if(movable) then f:StartMoving(); moving = true; end; end);
b:SetScript("OnMouseUp", function() if(moving) then f:StopMovingOrSizing(); moving = false; end; end);
b:SetBackdrop({
	bgFile = "Interface\\Tooltips\\UI-Tooltip-Background",
	edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border",
	tile = 1, tileSize = 10, edgeSize = 10,
	insets = { left = 1, right = 1, top = 1, bottom = 1 }
});

-- put text in status bar
local bs = b:CreateFontString("$parentText", "ARTWORK", "GameFontHighlightSmall");
bs:SetPoint("RIGHT", b); bs:SetAllPoints(); bs:SetText("Initialising...");

-- have the statusbar simulate slice and dice timeleft
f:SetScript("OnUpdate", function()
	-- initialise abilities
	if(not (init or UnitAffectingCombat("player"))) then
		init = 1; local start, duration, enabled;
		for ability,ar in pairs(abilities) do
			start, duration, enabled = GetSpellCooldown(ability);
			if(duration ~= nil) then
				abilities[ability]["Exists"] = true;
				SetButton(f, ar["Btn"], ar["Slot"], ability, ar["Icon"]);
			else ar["Btn"]:Hide(); end;
		end;
	end;
	-- slice and dice bar update
	if(sndTime ~= 0) then
		n, sndTime = SndDuration(sndTime);
		b:SetValue(n); bs:SetText("Slice and Dice: "..n.."s");
	else b:SetValue(0); bs:SetText("\"Rouge\" addon by Dezyne, 2008"); end;
	-- ability buttons update
	movable = BtnMove:GetChecked();
	for ability,ar in pairs(abilities) do
		if(ar["Exists"]) then
			if(CooldownOn(ability) < 1) then if(ar["Btn"]:GetAlpha() ~= 1) then ar["Btn"]:SetAlpha(1); end;
			else if(ar["Btn"]:GetAlpha() ~= 0.2) then ar["Btn"]:SetAlpha(0.2); end; end;
		end;
	end;
end);