-- Roleplaying Helper

-- initialize the RPWORDLIST table
RPWORDLIST = {}

-- Register with myAddOns
MyAddon_UpdateInterval = 250;
RPHELPER_TITLE =       "Roleplaying Helper";
RPHELPER_VERSION =     "3.0.0a"
RPHELPER_RELEASEDATE = "March 27, 2008";
RPHELPER_AUTHOR =      "Rogrom";
RPHELPER_EMAIL =       ""
RPHELPER_WEBSITE =     "http://ui.worldofwar.net/ui.php?id=2914";

RoleplayingHelperDetails	= {	
			name =         RPHELPER_TITLE,
			version =      RPHELPER_VERSION,
			releaseDate =  RPHELPER_RELEASEDATE,
			author =       RPHELPER_AUTHOR,
			email =        RPHELPER_EMAIL,
			website =      RPHELPER_WEBSITE,
			category =     MYADDONS_CATEGORY_CHAT,
			optionsframe = "RPConfigFrame",
		};

RoleplayingHelperHelp	= {};
RoleplayingHelperHelp[1] = "Roleplaying Helper lets your character automatically roleplay when certain events occur.\n\nCommands:\n\n/rp\n/rp on\n/rp off";

-- Keybindings
BINDING_HEADER_RPH = "Roleplaying Helper";
BINDING_NAME_RPH_TOGGLE = "Toggle RPH On/Off";
BINDING_NAME_RPH_CONFIG = "Show RPH Options"

--Add spell tables to RPWORDLIST  (localization.lua must load before this)
for k,v in pairs(SPELLS) do
	for k2, v2 in pairs(SPELLS[k]) do
		for k3, v3 in pairs(SPELLS[k][k2]) do
			RPWORDLIST[ k3 ]  = {}
		end
	end	
end

--Add RPEvents table to RPWORDLIST
for k, v in pairs(RPEvents) do
	RPWORDLIST[ k ]  = {}
end

RPWORDLIST.randominsult = {}
RPWORDLIST.randomemote = {}

RPHelper_Debug_Events = {
	"COMBAT_LOG_EVENT_UNFILTERED",
	"UPDATE_SELECTED_CHARACTER",
	"CHAT_MSG_COMBAT_FRIENDLYPLAYER_HITS",
	"CHAT_MSG_COMBAT_FRIENDLY_DEATH",              
	"PLAYER_QUITING",
	--"PLAYER_CONTROL_GAINED",
	--"PLAYER_CONTROL_LOST",	     
	--"PLAYER_DAMAGE_DONE_MODS",	
	"PLAYER_PET_CHANGED",	  	  
	--"UPDATE_SHAPESHIFT_FORMS", 
	"UNIT_SPELLMISS",         
	"CHAT_MSG_COMBAT_PARTY_HITS", 
	"CHAT_MSG_COMBAT_PARTY_MISSES",
	"CHAT_MSG_BG_SYSTEM_ALLIANCE",
	"CHAT_MSG_BG_SYSTEM_HORDE",
	"CHAT_MSG_BG_SYSTEM_NEUTRAL",
	"PLAYER_PVP_KILLS_CHANGED",
	--"PLAYER_PVP_RANK_CHANGED",
	"PLAYER_PVPLEVEL_CHANGED",
	"PLAYER_FLAGS_CHANGED",
	--"UPDATE_PENDING_MAIL",
	--"UPDATE_WORLD_STATES",
	"CHAT_MSG_MONSTER_EMOTE",
	"CHAT_MSG_RAID_BOSS_EMOTE",
	"CHAT_MSG_MONSTER_SAY",
	"CHAT_MSG_MONSTER_YELL",
	"CHAT_MSG_MONSTER_WHISPER",
	"CHAT_MSG_EMOTE",
	"CHAT_MSG_TEXT_EMOTE",
	--"UI_INFO_MSG",
	--"CHAT_MSG_CHANNEL",
	"CHAT_MSG_COMBAT_SELF_HITS",
	
	"DUEL_REQUESTED",
	"DUEL_FINISHED",
	"DUEL_OUTOFBOUNDS",
	"CHAT_MSG_COMBAT_FACTION_CHANGED",
	"SPELLCAST_START",
	"SPELLCAST_CHANNEL_START",
	"SPELLCAST_CHANNEL_UPDATE",
	--"SPELLCAST_STOP",
	"SPELLCAST_INTERRUPTED",
	"CHAT_MSG_SPELL_SELF_BUFF",
	"CHAT_MSG_SPELL_PERIODIC_HOSTILEPLAYER_BUFFS",
	"CHAT_MSG_SKILL",
	--"PLAYER_GUILD_UPDATE",
	--"UNIT_FACTION",
	--"CHAT_MSG_SYSTEM",
    "CHAT_MSG_SPELL_ITEM_ENCHANTMENTS",
    "CHAT_MSG_SPELL_HOSTILEPLAYER_BUFF",
    "AUCTION_HOUSE_SHOW",
    "AUCTION_HOUSE_CLOSED",
    "BANKFRAME_OPENED",
    "BANKFRAME_CLOSED",
    "BATTLEFIELDS_SHOW",
    "BATTLEFIELDS_CLOSED",
    "CRAFT_SHOW",
    "CRAFT_CLOSE",
    "MAIL_SHOW",
    "MAIL_CLOSED",
    "PET_STABLE_SHOW",
    "PET_STABLE_CLOSED",
    "TAXIMAP_OPENED",
    "TAXIMAP_CLOSED",
    "TRADE_SKILL_SHOW",
    "TRADE_SKILL_CLOSED",
    "TRAINER_SHOW",
    "TRAINER_CLOSED",
    "MINIMAP_PING",
--    "ZONE_CHANGED",
--    "ZONE_CHANGED_INDOORS",
    "ZONE_UNDER_ATTACK",
    "PLAYER_ENTERING_WORLD",
    "PARTY_LEADER_CHANGED",
    "QUEST_GREETING",
    "QUEST_DETAIL",
    "QUEST_ACCEPT_CONFIRM",
    "QUEST_COMPLETE",
    "QUEST_FINISHED",
    "PLAYER_TRADE_MONEY",
    "PLAYER_ALIVE",
    "RESURRECT_REQUEST",
    "LOCALPLAYER_PET_RENAMED",
	"ADDON_ACTION_FORBIDDEN",
--    "UNIT_HAPPINESS",
    
    
	
}

--////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////--
-- FUNCTION FOR INITIALIZATION
--////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////--
function RP_OnLoad()

--=====================================================================--
-- Events Registered
--=====================================================================--

-- Non-combat events
	this:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
--	These events have all been replaced by COMBAT_LOG_EVENT_UNFILTERED
--   	this:RegisterEvent("CHAT_MSG_CHANNEL")
--   	this:RegisterEvent("CHAT_MSG_COMBAT_CREATURE_VS_SELF_HITS") -- Creature hits you
--   	this:RegisterEvent("CHAT_MSG_SPELL_CREATURE_VS_SELF_DAMAGE") -- Creature hits you with spell
--	this:RegisterEvent("CHAT_MSG_COMBAT_HOSTILEPLAYER_HITS") -- Hostile player hits you
--   	this:RegisterEvent("CHAT_MSG_SPELL_HOSTILEPLAYER_DAMAGE") -- Hostile player hits you with spell
--	this:RegisterEvent("CHAT_MSG_COMBAT_CREATURE_VS_SELF_MISSES") -- Creature misses you
--      this:RegisterEvent("CHAT_MSG_COMBAT_HOSTILEPLAYER_MISSES")
--   	this:RegisterEvent("CHAT_MSG_COMBAT_SELF_HITS") -- You hit something.
--   	this:RegisterEvent("CHAT_MSG_SPELL_SELF_DAMAGE") -- You hit something with spell.
--	this:RegisterEvent("CHAT_MSG_SPELL_SELF_BUFF")  -- Used when healing
--	this:RegisterEvent("CHAT_MSG_COMBAT_FRIENDLY_DEATH")
--	These events may or may not work. TODO: Test them.
   	this:RegisterEvent("CHAT_MSG_SYSTEM")
   	this:RegisterEvent("CHAT_MSG_MONSTER_SAY")
   	this:RegisterEvent("CHAT_MSG_MONSTER_EMOTE")
   	this:RegisterEvent("VARIABLES_LOADED")
	this:RegisterEvent("PLAYER_UNGHOST")
	this:RegisterEvent("GOSSIP_SHOW")
	this:RegisterEvent("GOSSIP_CLOSED")
   	this:RegisterEvent("MERCHANT_SHOW")
	this:RegisterEvent("MERCHANT_CLOSED")
	this:RegisterEvent("QUEST_FINISHED")
   	this:RegisterEvent("QUEST_COMPLETE")
   	this:RegisterEvent("QUEST_GREETING")
   	this:RegisterEvent("QUEST_PROGRESS") 
	this:RegisterEvent("QUEST_DETAIL")
   	this:RegisterEvent("PLAYER_DEAD")
   	this:RegisterEvent("TRADE_SHOW")
   	this:RegisterEvent("TRADE_CLOSED")
-- Combat events
   	this:RegisterEvent("PLAYER_REGEN_DISABLED") -- Enter Combat
   	this:RegisterEvent("PLAYER_REGEN_ENABLED") -- Leave Combat
	this:RegisterEvent("UNIT_SPELLCAST_SENT")
   	this:RegisterEvent("PET_ATTACK_START")
   	this:RegisterEvent("PET_ATTACK_STOP")
	this:RegisterEvent("PLAYER_CAMPING")  -- When you logout
	this:RegisterEvent("PLAYER_LEVEL_UP")
	this:RegisterEvent("ZONE_CHANGED_NEW_AREA") -- change zones
	for k,v in pairs(RPHelper_Debug_Events) do
		this:RegisterEvent(v)	
	end

--=====================================================================--
-- Variables Initialized
--=====================================================================--
   	this.hp = -1
   	this.lasthp = -1
   	this.lastmana = -1
   	this.lastpethp = -1

	TalkToNPCBoxClosed = GetTime()
   	LastRP = GetTime()
   	IsDead = false
   	IsChanneling = false

	RPedAtLeastOnce = false
   	JustRPed = false
	
  -- For statistics
	RPStats = {}
	RPStats.GETHURT = {}
	RPStats.GETHURT.rp = 0
	RPStats.CREATURE_VS_SELF_MISSES = {}
	RPStats.CREATURE_VS_SELF_MISSES.rp = 0
   	RPStats.PET_ATTACK_START = {}
   	RPStats.PET_ATTACK_START.rp = 0
   	RPStats.MONSTER_SAY = {}
   	RPStats.MONSTER_SAY.rp = 0
   	RPStats.EVENT = {}
    RPStats.EVENT.rp = 0
    RPStats.SPELL = {}
    RPStats.SPELL.rp = 0 
    RPHelper_UpdateInterval = 250

  -- Gossip Box Variables
	TalkingToNPC = false
   	INTRODUCED = {} -- A list of all of the people your character speaks to.

  -- Used by RPEventsFrame & RPSpellsFrame to keep track of the Events & Spell page you were on.
   	RP_EventsPage = 1
   	RP_SpellPage = 1

--=====================================================================--
-- Slash Command /rp Initialized
--=====================================================================--
	SLASH_RP1 = "/rp"
	SlashCmdList["RP"] = RP_SlashCommands

-- Cast Spell and Use Action are now protected functions, so we hook into them to make it work.
-- This just seems to cause errors now.
-- hooksecurefunc("UseAction",RPHelper_newUseAction);
end  -- function RP_OnLoad()

--////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////--
-- FUNCTION TO RESET DEFAULT CONFIG
--////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////--
function RPDefaults(x)

	-- setup tables
	if (not RPCONFIG) then RPCONFIG = {} end	

	-- On/Off	    
	if (RPCONFIG.on == nil) or (x == "all") or (x == "on") then RPCONFIG.on = true				end
	
	for k,v in pairs(RPEvents) do
	    if (RPCONFIG[k] == nil) then
	        RPCONFIG[k] = {}
	    end
	    if (RPCONFIG[k]["Delay"] == nil) or (x == "all") or (x == "events") then
	        if k == "petdies" then              -- petdies
	        	RPCONFIG[k]["Delay"] = 0
			elseif k == "resurrect" then       	-- resurrect
	        	RPCONFIG[k]["Delay"] = 0              
			elseif k == "player_level_up" then  -- player_level_up
	        	RPCONFIG[k]["Delay"] = 0                          
			elseif k == "player_camping" then   -- player_camping
	        	RPCONFIG[k]["Delay"] = 0
			elseif k == "chatter" then   -- Random chatter
	        	RPCONFIG[k]["Delay"] = 30
			else                                -- everything else
		    	RPCONFIG[k]["Delay"] = 8
			end
		end
	    if (RPCONFIG[k]["Chance"] == nil) or (x == "all") or (x == "events") then
	        if k == "youcrit" then          	-- youcrit
	        	RPCONFIG[k]["Chance"] = .08
	        elseif k == "youcritspell" then     -- youcritspell
	        	RPCONFIG[k]["Chance"] = .08
	        elseif k == "petdies" then          -- petdies
	        	RPCONFIG[k]["Chance"] = 1
	        elseif k == "resurrect" then       	-- resurrect
	        	RPCONFIG[k]["Chance"] = 1
	        elseif k == "talktonpc_firsttime" then   -- talktonpc_firsttime
	        	RPCONFIG[k]["Chance"] = 1
	        elseif k == "talktonpc_beginning" then   -- talktonpc_beginning
	        	RPCONFIG[k]["Chance"] = .25
	        elseif k == "talktonpc_middle" then -- talktonpc_middle
	        	RPCONFIG[k]["Chance"] = .1
	        elseif k == "talktonpc_end" then   	-- talktonpc_end
	        	RPCONFIG[k]["Chance"] = .25
	        elseif k == "npctalksfriend" then   -- npctalksfriend
	        	RPCONFIG[k]["Chance"] = .2
	        elseif k == "npctalksenemy" then   	-- npctalksenemy
	        	RPCONFIG[k]["Chance"] = .2                    
	        elseif k == "player_level_up" then  -- player_level_up
	        	RPCONFIG[k]["Chance"] = 1                        
	        elseif k == "player_camping" then   -- player_camping
	        	RPCONFIG[k]["Chance"] = 1
	        elseif k == "trade_show" then       -- trade window open
	            RPCONFIG[k]["Chance"] = .25
	        elseif k == "trade_closed" then      --- trade window closed
	            RPCONFIG[k]["Chance"] = .25
	        elseif k == "mount" then            -- mounting
	            RPCONFIG[k]["Chance"] = .2
	        elseif k == "learn" then
                RPCONFIG[k]["Chance"] = .1
              elseif k == "new_home" then
                RPCONFIG[k]["Chance"] = .2
              elseif k == "hurtbad" then
                RPCONFIG[k]["Chance"] = .5
              elseif k == "chatter" then
                RPCONFIG[k]["Chance"] = .05
	        else                                -- everything else
	        	RPCONFIG[k]["Chance"] = .03
			end
	    end
	end

	-- Spells
	local spelltypes = { "casttime", "channeled", "instant", "next_melee"  }
	-- Trainable Spells
 	for k, spelltype in ipairs(spelltypes) do
	 	for formatted_spellname, v2 in pairs(SPELLS[spelltype][englishClass]) do

			if (not RPCONFIG[formatted_spellname]) or (x == "all") or (x == "spells") then
				RPCONFIG[formatted_spellname] = {}
				RPCONFIG[formatted_spellname]["Chance"] = .03 
				RPCONFIG[formatted_spellname]["Delay"] = 8
			end
						
	    end
	end
	-- Racial abilities
	for k, spelltype in ipairs(spelltypes) do
	 	for formatted_spellname, v2 in pairs(SPELLS[spelltype][englishClass]) do

			if (not RPCONFIG[formatted_spellname]) or (x == "all") or (x == "spells") then
				RPCONFIG[formatted_spellname] = {}
				RPCONFIG[formatted_spellname]["Chance"] = .03 
				RPCONFIG[formatted_spellname]["Delay"] = 8
			end
						
	    end
	end
	
	-- Events to Show (RPEventsFrame)
	if (not RPCONFIG.Events_to_Show) or (x == "all") or (x == "events") then
		local x = "All \(" .. playerClass .. "\)"
        RPCONFIG.Events_to_Show = x
	end
	
	-- Spells to Show (RPSpellsFrame)
	if (not RPCONFIG.Spells_to_Show) or (x == "all") or (x == "spells") then
        RPCONFIG.Spells_to_Show = "Known with RPs"
	end

	-- Traits
	if (not RPCONFIG.traits) or (x == "all") or (x == "trait") or (x == "traits") then
		RPCONFIG.traits = {"ANY"}
		if englishRace == "Scourge" then
			table.insert(RPCONFIG.traits, "UNDEAD")
		else
			table.insert(RPCONFIG.traits, string.upper(englishRace))
		end
		table.insert(RPCONFIG.traits, englishClass)
	end

	-- if you take your class out of RPCONFIG.traits, you might still want to RP spells
	if (RPCONFIG.UseSpellRPs == nil) or (x == "all") or (x == "trait") or (x == "traits") then
		RPCONFIG.UseSpellRPs = true		
	end	 

	-- Language to RP in
    if (not RPCONFIG.RPLang) or (x == "all") or (x == "lang") then 				RPCONFIG.RPLang = "Use Current"		end
	
	-- Debug to false unless it's already on
    if (RPCONFIG.Debug == nil) or (x == "all") or (x == "debug") then 			RPCONFIG.Debug = false				end
end


--////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////--
-- FUNCTION FOR LOCALIZATION (Uses strings found in GlobalStrings.lua to compare words in a chat message)
--////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////--
function SameEventStrings(GlobalString, x)
	-- To fix the "unfinished capture" error on French Clients
	GlobalString = string.gsub(GlobalString, "%(", "")
	GlobalString = string.gsub(GlobalString, "%)", "")
	x = string.gsub(x, "%(", "")
	x = string.gsub(x, "%)", "")

	local PartsToCompare = {}
	local a = 1
	local b = string.find(GlobalString, "%%")
	while b do
		table.insert(PartsToCompare, string.sub(GlobalString, a, b-1))
		a = b+2
		b = string.find(GlobalString, "%%", a)
	end
	table.insert(PartsToCompare, string.sub(GlobalString, a))

	local ItsTheSame = true
	for k, v in pairs(PartsToCompare) do
			if string.find(x, v) == nil then
				ItsTheSame = false
				return ItsTheSame
			end
		end

	return ItsTheSame
end


--=====================================================================--
-- RPTimerFrame
-- Waits 2 frame to see if you've finished talking to an NPC
--=====================================================================--
function RPTimerFrameOnUpdate()
	if RPNumFrames <= 2 then -- count up to 2 frames
    	RPNumFrames = RPNumFrames + 1
	else
	    RPTimerIsRunning = false
	    RPTimerFrame:Hide()
	    EndOfConversationWithNPC()
	end

end

--////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////--
-- FUNCTION TO SET RP LANGUAGE
--////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////--
function RPHelper_SetLanguage()
	local Language_Choices = { "Use Current" }
	for i = 1, GetNumLanguages() do
		table.insert(Language_Choices, GetLanguageByIndex(i))
	end
	table.insert(Language_Choices, "Random")
	
	local x = PlaceInArray(Language_Choices, RPCONFIG.RPLang)

	if x + 1 > table.getn(Language_Choices) then
		RPCONFIG.RPLang = Language_Choices[1]
	else
		RPCONFIG.RPLang = Language_Choices[x+1]
	end

end

--////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////--
-- FUNCTION TO SET EVENTS SHOWN IN RPSpellsFrame
--////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////--
function RPHelper_SetEventsShown()
	local y = "All \(" .. playerClass .. "\)"
	local EventsShown_Choices = { y, "All with RPs" }
	local x = PlaceInArray(EventsShown_Choices, RPCONFIG.Events_to_Show)

	if x + 1 > table.getn(EventsShown_Choices) then
		RPCONFIG.Events_to_Show = EventsShown_Choices[1]
	else
		RPCONFIG.Events_to_Show = EventsShown_Choices[x+1]
	end
end

--////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////--
-- FUNCTION TO SET SPELLS SHOWN IN RPSpellsFrame
--////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////--
function RPHelper_SetSpellsShown()
	local SpellsShown_Choices = { "All", "All Known", "All with RPs", "Known with RPs" }
	local x = PlaceInArray(SpellsShown_Choices, RPCONFIG.Spells_to_Show)

	if x + 1 > table.getn(SpellsShown_Choices) then
		RPCONFIG.Spells_to_Show = SpellsShown_Choices[1]
	else
		RPCONFIG.Spells_to_Show = SpellsShown_Choices[x+1]
	end
end


--////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////--
-- FUNCTION FOR CHOOSING WHICH PHRASES TO SAY
--////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////--
function GetPhrase(EventType)
	local s = {}	-- table of sayings
	local e = {}	-- table of emotes
	local c = {}	-- table of custom emotes
	local r = {}	-- table of random phrase tables
	if RPWORDLIST[EventType] then
		for k,v in pairs(RPCONFIG.traits) do
		    if RPWORDLIST[EventType][v] then
				-- sayings
				JoinArrays(s, RPWORDLIST[EventType][v])
		    
				for k2, v2 in pairs(RPWORDLIST[EventType][v]) do
	                -- custom emotes
					if string.find(k2, "customemote") then
						JoinArrays(c, RPWORDLIST[EventType][v][k2])

					-- emotes
					elseif string.find(k2, "emote") then
						JoinArrays(e, RPWORDLIST[EventType][v][k2])

					-- random phrases
					elseif string.find(k2, "random") then
						if (table.getn(RPWORDLIST[EventType][v][k2]) > 0) then
							if RandPhraseCheck(EventType, v, k2) then
								table.insert(r, RPWORDLIST[EventType][v][k2])
							end
					    end
					end
			    end

			end
		end

		-- if you take your class out of RPCONFIG.traits, but still want to RP spells	
		if RPCONFIG.UseSpellRPs and (PlaceInArray(RPCONFIG.traits, englishClass) == false) then
			local Its_a_spell = true
			for k, vi in pairs(RPEvents) do
				if k == EventType then
					Its_a_spell = false
				end	
			end
			if Its_a_spell then
			    if RPWORDLIST[EventType][englishClass] then
	
					-- sayings
					JoinArrays(s, RPWORDLIST[EventType][englishClass])
			    
					for k2, v2 in pairs(RPWORDLIST[EventType][englishClass]) do
		                -- custom emotes
						if string.find(k2, "customemote") then
							JoinArrays(c, RPWORDLIST[EventType][englishClass][k2])
	
						-- emotes
						elseif string.find(k2, "emote") then
							JoinArrays(e, RPWORDLIST[EventType][englishClass][k2])
	
						-- random phrases
						elseif string.find(k2, "random") then
							if (table.getn(RPWORDLIST[EventType][englishClass][k2]) > 0) then
								if RandPhraseCheck(EventType, englishClass, k2) then
									table.insert(r, RPWORDLIST[EventType][englishClass][k2])
								end
						    end
						end
				    end
				end
			end 
		end
		
	else
        dcf("RPWORDLIST."..EventType.." doesn't seem to exist.")
	end

	r = RPHelper_RandomPhraseChooser(r)

	-- The RANDOM PHRASE table is now setup exactly like the SAYINGS table, so it's okay to combine them.
 	s = JoinArrays(s, r)

	-- There are 37 emotes that have 1-3 clones each
	-- Example: /lol (clone) = /laugh (main)
	-- If you type these clones in the game using /emote, Blizzard will change them into the "main" emote
	-- Unfortunately, DoEmote() won't do ANYTHING if you feed it one of the clones
	-- so the following is used to replace them with the "main" emotes
 	for k, v in ipairs(e) do
 		if string.find(v, " SELF") then
	 		e[k] = string.gsub(v, " SELF", "")
	 	    if RP_Emote_List[ string.lower(e[k]) ][ "clone_of" ] then
	 	        e[k] = RP_Emote_List[ string.lower(e[k]) ][ "clone_of" ]
	 	    end
	 	    e[k] = e[k] .. " SELF"
		elseif RP_Emote_List[ string.lower(e[k]) ] then
			if RP_Emote_List[ string.lower(e[k]) ][ "clone_of" ] then
	 	    	e[k] = RP_Emote_List[ string.lower(e[k]) ][ "clone_of" ]
	 	    end
		end
 	end

	return s, e, c
end



--////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////--
-- FUNCTION for:
-- 1. getting info about random phrases available (ex: Number of possible phrases)
-- 2. using that info to decide how many random phrases should be given a chance to be said
-- 3. making a table of completed phrases
--////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////--
function RPHelper_RandomPhraseChooser(r)
	local RandomPhraseTable = {}
	if r then
		local NumOfPhrases = table.getn(r)

		for k,v in pairs(r) do
				local PhraseWithBlanks, NumOfBlanks = string.gsub(r[k]["phrase"], "BLANK", "BLANKx")
				local NumOfPossibilities = 1
				for i = 1,NumOfBlanks do
     				NumOfPossibilities = NumOfPossibilities * table.getn(r[k][i])
				end
				r[k]["NumOfPhrases"] = Round (NumOfPossibilities / 40)  -- 40 is an arbitrary number I picked
				if r[k]["NumOfPhrases"] < 1 then
					r[k]["NumOfPhrases"] = 1
				end

				-- We know how many phrases we're going to add to our phrase list.  Now let's do it.
				for i = 1, r[k]["NumOfPhrases"] do
				    local CompletedPhrase = PhraseWithBlanks
				
					for j = 1,NumOfBlanks do
						local x = math.random(table.getn(r[k][j]))
						CompletedPhrase = string.gsub(CompletedPhrase, "BLANKx", r[k][j][x], 1)
					end
					
					table.insert(RandomPhraseTable, CompletedPhrase)
				end
			end
	end

	return RandomPhraseTable

end



--////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////--
-- FUNCTION FOR SAYING or EMOTING; takes tables: sayings, emotes; randomly picks & does one or the other
--////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////--
function Roleplay(sayings, emotes, customemotes)

	-- KEYWORDS
	sayings = RPHelper_ReplaceKeywords(sayings, "saying")
	customemotes = RPHelper_ReplaceKeywords(customemotes, "customemote")

	local sSize = table.getn(sayings) 		-- Size of SAYINGS table
	local eSize = 0 							-- Size of EMOTES table (0 until we make sure we're not channeling)
	local cSize = table.getn(customemotes) 	-- Size of CUSTOM EMOTES table
	if (IsChanneling == false) and (emotes) then	-- 'and (emotes)' was added so we can call this function with only 1 table of sayings sent to this function
	    eSize = table.getn(emotes)
	end

	-- Get language to RP in
    local RPLanguage    
    if RPCONFIG.RPLang == "Use Current" then
        RPLanguage = DEFAULT_CHAT_FRAME.editBox.language		-- DEFAULT_CHAT_FRAME.editBox.language = the language you are speaking now
    elseif RPCONFIG.RPLang == "Random" then
    	RPLanguage = GetLanguageByIndex(math.random(GetNumLaguages()))
    else
		RPLanguage = RPCONFIG.RPLang	
    end

	if (sSize + eSize + cSize) > 0 then
		local x = math.random(sSize + eSize + cSize)
		if x > (sSize + eSize) then
        	SendChatMessage(customemotes[x - sSize - eSize], "EMOTE")  -- CUSTOM EMOTE
		elseif x > sSize then
			
			-- Just for you mithyk (^_^)  A way to self target emotes
			if string.find(emotes[x - sSize], " SELF") then
				emotes[x - sSize] = string.gsub(emotes[x - sSize], " SELF", "")
				DoEmote(emotes[x - sSize], "player")		  -- SELF EMOTE
			else
				DoEmote(emotes[x - sSize])                  -- EMOTE	
			end
			 	
		else
-- Lore Custom Language Support
			if string.find(sayings[x], "LANGUAGE") then
				oldLanguage=Lore_Language
				startPos, endPos, RPLanguage, Phrase = string.find(sayings[x], "%w%s(%w+)%s(.*)")
				Lore_Language=RPLanguage
				SendChatMessage(Phrase, "SAY")
				Lore_Language=oldLanguage
			else
				SendChatMessage(sayings[x], "SAY", RPLanguage)
			end
		  	
		end

		JustRPed = true
	end

end


--////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////--
-- FUNCTIONS FOR RANDOM GENERATORS
	-- EventType:   Example: entercombat
	-- v:           Example: WARRIOR
	-- random:      Any phrase that has the word "random" in it.  This is so customizable files can have random1, random2, pukingrandompoop, etc.
--////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////--
function RandPhraseCheck(EventType, v, random)   -- Takes table with the random phrase parts inside; Returns boolean if the random phrase table is setup correctly
	local ErrorMessage = {}
	local EverythingOK = true
	local TempPhrase
	local num
	if not random then 	random = "random"; 		end

	if type(RPWORDLIST[EventType][v][random]["phrase"]) ~= "string" then
		EverythingOK = false
		table.insert(ErrorMessage, 'RPWORDLIST.' .. EventType .. '.' .. v .. '.'..random..'["phrase"] seems to not exist or not be a valid string.')
	else
		TempPhrase, num = string.gsub(RPWORDLIST[EventType][v][random]["phrase"], "BLANK", "BLANKp") -- TempPhrase is not important, we just need the number of "BLANK"s in the phrase

		if num < 1 then -- CHECK: there is at least 1 BLANK
			EverythingOK = false
			table.insert(ErrorMessage, 'There are no "BLANK"s in RPWORDLIST.' .. EventType .. '.' .. v .. '.'..random..'["phrase"]')
		else
			for i = 1,num do
				if type(RPWORDLIST[EventType][v][random][i]) == "table" then  -- CHECK: [i] is a table
				
					if table.getn(RPWORDLIST[EventType][v][random][i]) < 1 then  -- CHECK: [i] table has at least 1 phrase to go with BLANK.
						EverythingOK = false
						table.insert(ErrorMessage, "There are no phrases in RPWORDLIST." .. EventType .. "." .. v .. "."..random.."[" .. i .. "]")
					end -- if table.getn(RPWORDLIST[EventType][v]["random"][i]) < 1
					
				else
					EverythingOK = false
					table.insert(ErrorMessage, "You have " .. num .. " BLANKs but RPWORDLIST." .. EventType .. "." .. v .. "."..random.."[" .. i .. "] seems to not exist or not be a valid table.")
				end
				
			end -- for i = 1,num do
		end -- if num < 1
	end -- if type(RPWORDLIST[EventType][v]["random"]["phrase"] ~= "string") then

	if (EverythingOK == false) then
            dcf("You made an error when customizing your random phrase:")
        
		for k,v in pairs(ErrorMessage) do
		    	dcf(v)
			end
	end

	return EverythingOK
end

function RandInsult() -- returns "string" insult; if 1 of the parts is missing, returns false
	local Part1 = {}
	local Part2 = {}
	local Part3 = {}
	local insult

	for k,v in pairs(RPCONFIG.traits) do

	    	if RPWORDLIST.randominsult[v][1] then
	        	Part1 = JoinArrays( Part1, RPWORDLIST.randominsult[v][1] )
	        end
			if RPWORDLIST.randominsult[v][2] then
	        	Part2 = JoinArrays( Part2, RPWORDLIST.randominsult[v][2] )
	        end
			if RPWORDLIST.randominsult[v][3] then
	        	Part3 = JoinArrays( Part3, RPWORDLIST.randominsult[v][3] )
	    	end
		end
	    
	if ( table.getn( Part1 ) > 0 ) and ( table.getn( Part2 ) > 0 ) and ( table.getn( Part3 ) > 0 ) then
	    local p1 = math.random( table.getn( Part1 ) )
	    local p2 = math.random( table.getn( Part2 ) )
	    local p3 = math.random( table.getn( Part3 ) )
	    
	    -- YOU is a localized variable from Blizzard's GlobalStrings.lua
		insult = RPWORDLIST.randominsult.YOU .. " " .. Part1[p1] .. " " .. Part2[p2] .. " " .. Part3[p3] .. "."
		return insult
	else
	    return false
	end
end

function RandInsultEmote() -- returns "string" insult; if 1 of the parts is missing, returns false
    -- yes, this is a copy of RandInsult()
	local Part1 = {}
	local Part2 = {}
	local Part3 = {}
	local insult

	for k, v in pairs(RPCONFIG.traits) do
	    	if RPWORDLIST.randomemote[v][1] then
	        	Part1 = JoinArrays(Part1, RPWORDLIST.randomemote[v][1])
	        end
	        
			if RPWORDLIST.randomemote[v][2] then
	        	Part2 = JoinArrays(Part2, RPWORDLIST.randomemote[v][2])
	        end
	        
			if RPWORDLIST.randomemote[v][3] then
	        	Part3 = JoinArrays(Part3, RPWORDLIST.randomemote[v][3])
	    	end
		end
	    
	if (table.getn(Part1) > 0) and (table.getn(Part2) > 0) and (table.getn(Part3) > 0) then
	    local p1 = math.random(table.getn(Part1))
	    local p2 = math.random(table.getn(Part2))
	    local p3 = math.random(table.getn(Part3))
	    
		insult = Part1[p1] .. " " .. Part2[p2] .. " " .. Part3[p3] .. "."
		return insult
	else
	    return false
	end
end

--////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////--
-- FUNCTION FOR EVENTS
--////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////--
function RP_OnEvent(event, ...)
--=====================================================================--
-- VARIABLES_LOADED
--=====================================================================--
	if (event == "VARIABLES_LOADED") then
		if(myAddOnsFrame_Register) then
			myAddOnsFrame_Register(RoleplayingHelperDetails,RoleplayingHelperHelp);
		end
		playerRace, englishRace = UnitRace("player");
		playerClass, englishClass = UnitClass("player");
		RPDefaults()
		local status = "(Disabled)";
		if RPCONFIG.on then 
			status = "(Enabled)"
		end
		DEFAULT_CHAT_FRAME:AddMessage("Roleplaying Helper "..RPHELPER_VERSION.." loaded. "..status.." Type:  /rp", 0.0, 1.0, 1.0)
		DEFAULT_CHAT_FRAME:AddMessage("Your RP traits are: ".. table.concat(RPCONFIG.traits, ", "), 0.0, 1.0, 1.0)
		Chronos.scheduleRepeating("RPH_BASIC_TIMER", 5, RPHTimedEvent)
	end

	if (RPCONFIG.on == false) then
		return
	end

--=====================================================================--
-- 'a' is the random number we will use for the chance that nothing will happen
--=====================================================================--
	local a = math.random();
	local playerGUID = UnitGUID("player")
--=====================================================================--
-- When you enter combat.
--=====================================================================--
   	if (event == "PLAYER_REGEN_DISABLED") then
		if RPCONFIG.Debug then
			dcf("Entered combat! Chance="..RPCONFIG.entercombat["Chance"].." Roll="..a)
		end
	    	if (a <= RPCONFIG.entercombat["Chance"]) and (GetTime() - LastRP >= RPCONFIG.entercombat["Delay"]) then
			local s, e, c = GetPhrase("entercombat")
			Roleplay(s, e, c)
		end -- Delay & Chance
--=====================================================================--
-- When you leave combat.
--=====================================================================--
   	elseif (event == "PLAYER_REGEN_ENABLED") then
		if RPCONFIG.Debug then
			dcf("Left combat! Chance="..RPCONFIG.leavecombat["Chance"].." Roll="..a)
		end
	    	if (a <= RPCONFIG.leavecombat["Chance"]) and (GetTime() - LastRP >= RPCONFIG.leavecombat["Delay"]) then
 			local s, e, c = GetPhrase("leavecombat")
			Roleplay(s, e, c)
		end -- Delay & Chance

--=====================================================================--
-- New 2.4 Chat message handling.
--=====================================================================--
	elseif (event == "COMBAT_LOG_EVENT_UNFILTERED") then
		local s = {}
		local e = {}
		local c = {}
		local r = {}
		--=====================================================================--
		-- If you're getting hurt.
		--=====================================================================--
		if  ((arg2 == "SWING_DAMAGE") or (arg2 == "SPELL_DAMAGE") or (arg2 == "RANGED_DAMAGE")) and (arg6 == playerGUID) then
			if (a <= RPCONFIG.hurt["Chance"]) and (GetTime() - LastRP >= RPCONFIG.hurt["Delay"]) then
				if RPCONFIG.Debug then dcf("You are hurt") end
				local s, e, c = GetPhrase("hurt")
				Roleplay(s, e, c)
			elseif (a <= RPCONFIG.hurtbad["Chance"]) and (GetTime() - LastRP >= RPCONFIG.hurtbad["Delay"]) then
				this.maxhp = UnitHealthMax("player")
				this.hp = UnitHealth("player")
				this.hppercent = this.hp / this.maxhp
				if (this.hppercent <= 0.10) then
					local s, e, c = GetPhrase("hurtbad")
					Roleplay(s, e, c)
				end
			end
		--=====================================================================--
		-- When you're missed, dodge, block, parry, or absorb.
		--=====================================================================--
		elseif  (arg2 == "SWING_MISSED") and (arg6 == playerGUID) then
			if (arg9 == "BLOCK") and (a <= RPCONFIG.block["Chance"]) and (GetTime() - LastRP >= RPCONFIG.block["Delay"]) then	
				if RPCONFIG.Debug then dcf("You block an attack") end
				local s, e, c = GetPhrase("block")
				Roleplay(s, e, c, r)
			elseif (arg9 == "DODGE") and (a <= RPCONFIG.dodge["Chance"]) and (GetTime() - LastRP >= RPCONFIG.dodge["Delay"]) then	
				if RPCONFIG.Debug then dcf("You dodge an attack") end
				local s, e, c = GetPhrase("dodge")
				Roleplay(s, e, c, r)
			elseif (arg9 == "MISS") and (a <= RPCONFIG.miss["Chance"]) and (GetTime() - LastRP >= RPCONFIG.miss["Delay"]) then	
				if RPCONFIG.Debug then dcf("An attack misses you") end
				local s, e, c = GetPhrase("miss")
				Roleplay(s, e, c, r)
			elseif (arg9 == "PARRY") and (a <= RPCONFIG.parry["Chance"]) and (GetTime() - LastRP >= RPCONFIG.parry["Delay"]) then	
				if RPCONFIG.Debug then dcf("You parry an attack") end
				local s, e, c = GetPhrase("parry")
				Roleplay(s, e, c, r)
		--=====================================================================--
		-- This absorb will ONLY show when all the damage is absorbed. That should be fine.
		--=====================================================================--
			elseif (arg9 == "ABSORB") and (a <= RPCONFIG.absorb["Chance"]) and (GetTime() - LastRP >= RPCONFIG.absorb["Delay"]) then	
				if RPCONFIG.Debug then dcf("You absorb an attack") end
				local s, e, c = GetPhrase("absorb")
				Roleplay(s, e, c, r)
			end

		--=====================================================================--
		-- Partial block.
		--=====================================================================--
		elseif (arg2 == "SWING_DAMAGE") and (not (arg12 == nil)) and (arg6 == playerGUID) and (a <= RPCONFIG.block["Chance"]) and (GetTime() - LastRP >= RPCONFIG.block["Delay"]) then
			if RPCONFIG.Debug then dcf("You block an attack") end
			local s, e, c = GetPhrase("block")
			Roleplay(s, e, c, r)
		--=====================================================================--
		-- You take falling damage.
		--=====================================================================--
		elseif (arg2 == "ENVIRONMENTAL_DAMAGE") and (arg6 == playerGUID) and (arg9 == FALLING) and (a <= RPCONFIG.fall["Chance"]) and (GetTime() - LastRP >= RPCONFIG.fall["Delay"]) then
			if RPCONFIG.Debug then dcf("You fall") end
			local s, e, c = GetPhrase("fall")
			Roleplay( s, e, c )
		--=====================================================================--
		-- You take drowning damage.
		--=====================================================================--
		elseif (arg2 == "ENVIRONMENTAL_DAMAGE") and (arg6 == playerGUID) and (arg9 == DROWNING) and (a <= RPCONFIG.drowning["Chance"]) and (GetTime() - LastRP >= RPCONFIG.drowning["Delay"]) then
			if RPCONFIG.Debug then dcf("You are drowning") end
			local s, e, c = GetPhrase("drowning")
			Roleplay( s, e, c )
		--=====================================================================--
		-- You get a melee crit
		--=====================================================================--
		elseif (arg2 == "SWING_DAMAGE") and (not (arg17 == nil)) and (arg3 == playerGUID) and (a <= RPCONFIG.youcrit["Chance"]) and (GetTime() - LastRP >= RPCONFIG.youcrit["Delay"]) then
			if RPCONFIG.Debug then dcf("You crit") end
			local s, e, c = GetPhrase("youcrit")
			Roleplay(s, e, c)
		--=====================================================================--
		-- You get a ranged crit. TODO: Add separate RPs for ranged/melee crits
		--=====================================================================--
		elseif (arg2 == "RANGE_DAMAGE") and (not (arg17 == nil)) and (arg3 == playerGUID) and (a <= RPCONFIG.youcrit["Chance"]) and (GetTime() - LastRP >= RPCONFIG.youcrit["Delay"]) then
			if RPCONFIG.Debug then dcf("You crit") end
			local s, e, c = GetPhrase("youcrit")
			Roleplay(s, e, c)
		--=====================================================================--
		-- You get a spell crit. Counts any yellow damage as spell crit (ie, Heroic Strike for warriors)
		--=====================================================================--
		elseif (arg2 == "SPELL_DAMAGE") and (not (arg17 == nil)) and (arg3 == playerGUID) and (a <= RPCONFIG.youcritspell["Chance"]) and (GetTime() - LastRP >= RPCONFIG.youcritspell["Delay"]) then
			if RPCONFIG.Debug then dcf("You crit with a spell") end
			local s, e, c = GetPhrase("youcritspell")
			Roleplay(s, e, c)
		--=====================================================================--
		-- You heal somebody besides yourself (doesn't count HoTs)
		--=====================================================================--
		-- Critical Heal
		elseif (arg2 == "SPELL_HEAL") and (arg3 == playerGUID) and (not (arg6 == playerGUID)) then
			if (not (arg13 == nil)) and (a <= RPCONFIG.youcritheal["Chance"]) and (GetTime() - LastRP >= RPCONFIG.youcritheal["Delay"]) then
				if RPCONFIG.Debug then dcf("You critical heal") end
				local s, e, c = GetPhrase("youcritheal")
				Roleplay(s, e, c)
			elseif (a <= RPCONFIG.youheal["Chance"]) and (GetTime() - LastRP >= RPCONFIG.youheal["Delay"]) then
				local s, e, c = GetPhrase("youheal")
				Roleplay(s, e, c)
			end
		--=====================================================================--
		-- You cast a spell with a cast time (not instant or channeled)
		--=====================================================================--
		elseif (arg2 == "SPELL_CAST_START") and (arg3 == playerGUID) then
			for k,v in pairs(SPELLS.casttime[string.upper(englishClass)]) do
				-- TODO: This doesn't actually seem to work. ie, Lesser Healing Wave actually shares the RP of Healing Wave. Figure out why.
				if arg10 == v then
					if (a <= RPCONFIG[ k ]["Chance"]) and (GetTime() - LastRP >= RPCONFIG[ k ]["Delay"]) then
						local s, e, c = GetPhrase(k)
						Roleplay(s, e, c)
						if RPCONFIG.Debug then dcf("[arg10==v] k="..k.." v="..v.." arg10="..arg10) end
						RPStats.SPELL.rp = RPStats.SPELL.rp + 1  -- for statistics
						return
					end
				elseif string.find(arg10, v) then
					if (a <= RPCONFIG[ k ]["Chance"]) and (GetTime() - LastRP >= RPCONFIG[ k ]["Delay"]) then
						local s, e, c = GetPhrase(k)
						Roleplay(s, e, c)
						if RPCONFIG.Debug then dcf("[string.find] arg10="..arg10.." k="..k.." v="..v) end
						RPStats.SPELL.rp = RPStats.SPELL.rp + 1  -- for statistics
						return
					end
				end											
			end
		--=====================================================================--
		-- You cast an instant or channeled spell
		--=====================================================================--
		elseif (arg2 == "SPELL_CAST_SUCCESS") and (arg3 == playerGUID) then
			if PlaceInArray(RPCONFIG.traits, englishClass) then -- Check if we're using the wordlist for your class
				Non_Casttime_Spells = {}
				RPHelper_Join_Entire_Tables(Non_Casttime_Spells, SPELLS.instant[ string.upper(englishClass) ])
				RPHelper_Join_Entire_Tables(Non_Casttime_Spells, SPELLS.next_melee[ string.upper(englishClass) ])
				RPHelper_Join_Entire_Tables(Non_Casttime_Spells, SPELLS.channeled[ string.upper(englishClass) ])
				for k,v in pairs(Non_Casttime_Spells) do
					if string.find(arg10, v) then
    						if (a <= RPCONFIG[ k ]["Chance"]) and (GetTime() - LastRP >= RPCONFIG[ k ]["Delay"]) then	
							local s, e, c = GetPhrase(k)
							Roleplay(s, e, c)
							RPStats.SPELL.rp = RPStats.SPELL.rp + 1  -- for statistics
						end
						return
					end
				end
   			end
		end
--=====================================================================--
-- End of 2.4 Chat message handling.
--=====================================================================--

	elseif (event == "UNIT_SPELLCAST_SENT") then
	---------------------------------------------------------------------------
	-- Check to see if we're mounting (considered a spellcast)
	-- Only checks for normal mounts, not summoned mounts (paladins and warlocks)
	-- (not included in statistics for now) 
	-- I'd prefer to get rid of this event altogether, but mounts appear to have
	-- no message in the combat log.
	---------------------------------------------------------------------------
		local i = 1
		while RPMOUNTS[i] do
			if (RPMOUNTS[i] == arg2) then
				RPH_MyMount = arg2
				if RPCONFIG.Debug then dcf("Mounting: "..arg2) end
				if (a <= RPCONFIG.mount["Chance"]) and (GetTime() - LastRP >= RPCONFIG.mount["Delay"]) then
					local s, e, c = GetPhrase("mount")
					Roleplay(s, e, c)
				end
			end
                	i = i + 1
		end
            
            ---------------------------------------------------------------------------
			-- Hearthstone
            ---------------------------------------------------------------------------            
		if (arg2 == "Hearthstone") then
			if RPCONFIG.Debug then dcf("Hearthstone activated") end
			if (a <= RPCONFIG.hearthstone["Chance"]) and (GetTime() - LastRP >= RPCONFIG.hearthstone["Delay"]) then
				local s, e, c = GetPhrase("hearthstone")
				Roleplay(s,e,c)
			end
		end
            
            ---------------------------------------------------------------------------
			-- Stormpike Insignia trinket for Alterac Valley
            ---------------------------------------------------------------------------
		if (arg2 == "Recall") and (GetRealZoneText() == "Alterac Valley") then
			if RPCONFIG.Debug then dcf("Alterac Valley trinket (Recall)") end
			if (a <= RPCONFIG.av_recall["Chance"]) and (GetTime() - LastRP >= RPCONFIG.av_recall["Delay"]) then
				local s, e, c = GetPhrase("av_recall")
				Roleplay(s, e, c)
			end
		end

--=====================================================================--
-- When your pet starts attacking.
-- No args
-- UnitSex("pettarget") seems to go back to 0 right after the pet starts attacking or UnitSex("pettarget") is called
--=====================================================================--
    elseif (event == "PET_ATTACK_START") then
        if RPCONFIG.Debug then dcf(event) end
    	if (a <= RPCONFIG.petattackstart["Chance"]) and (GetTime() - LastRP >= RPCONFIG.petattackstart["Delay"]) then	
	
			RPStats.PET_ATTACK_START.rp = RPStats.PET_ATTACK_START.rp + 1
	
			local s, e, c = GetPhrase("petattackstart")
			Roleplay(s, e, c)			
		end -- Delay & Chance

--=====================================================================--
-- When your pet stops attacking.
-- No args
--=====================================================================--
    elseif (event == "PET_ATTACK_STOP") then
        if RPCONFIG.Debug then dcf(event) end
    	if (a <= RPCONFIG.petattackstop["Chance"]) and (GetTime() - LastRP >= RPCONFIG.petattackstop["Delay"]) then		   
			local s, e, c = GetPhrase("petattackstop")
			Roleplay(s, e, c)			
		end -- Delay & Chance
		
--=====================================================================--
-- When your pet dies
-- This happens before "PET_ATTACK_STOP"
-- so if there's a delay before "PET_ATTACK_STOP" everything should be alright
--=====================================================================--
   	elseif (event == "CHAT_MSG_COMBAT_FRIENDLY_DEATH") then
   	    if arg1 and (UnitName("pet")) then
	   	    if string.find(arg1, (UnitName("pet"))) then
	   	       if RPCONFIG.Debug then dcf("Pet died") end
    			if (a <= RPCONFIG.petdies["Chance"]) and (GetTime() - LastRP >= RPCONFIG.petdies["Delay"]) then	
					local s, e, c = GetPhrase("petdies")
					Roleplay(s, e, c)
				end -- Delay & Chance
			end
		end

--=====================================================================--
-- When you Resurrect,
-- Note: PLAYER_UNGHOST is fired when you Resurrect, Enter the Game, or Enter an Instance / Battlefield
--=====================================================================--
   	elseif (event == "PLAYER_UNGHOST") then
   		if IsDead == true then
   		   if RPCONFIG.Debug then dcf(event.." from death") end
    		if (a <= RPCONFIG.resurrect["Chance"]) and (GetTime() - LastRP >= RPCONFIG.resurrect["Delay"]) then	
				local s, e, c = GetPhrase("resurrect")
				Roleplay(s, e, c)				
			end -- Delay & Chance
		end
		IsDead = false


--=====================================================================--
-- PLAYER_CAMPING
--=====================================================================--		
	elseif (event == "PLAYER_CAMPING") then
	   if RPCONFIG.Debug then dcf(event) end
    	if (a <= RPCONFIG.player_camping["Chance"]) and (GetTime() - LastRP >= RPCONFIG.player_camping["Delay"]) then
			local s, e, c = GetPhrase("player_camping")
			Roleplay(s, e, c)	
		end

--=====================================================================--
-- PLAYER_LEVEL_UP
	-- arg1 = new level
--=====================================================================--		
	elseif (event == "PLAYER_LEVEL_UP") then  
        if RPCONFIG.Debug then dcf(event) end
    	if (a <= RPCONFIG.player_level_up["Chance"]) and (GetTime() - LastRP >= RPCONFIG.player_level_up["Delay"]) then
			local s, e, c = GetPhrase("player_level_up")
			
			for k,v in pairs(s) do
				v = string.gsub(v, "LEVEL", arg1)
				s[k] = v
			end
			
			for k,v in pairs(c) do
				v = string.gsub(v, "LEVEL", arg1)
				c[k] = v
			end
			
			Roleplay(s, e, c)	
		end

--=====================================================================--
-- When you die
--=====================================================================--
   	elseif (event == "PLAYER_DEAD") then
		IsDead = true
		
		RPHelper_EndCast = nil
		RPHelper_Target = nil
	    RPHelper_Spell = nil


--=====================================================================--
-- BEGINNING or MIDDLE of a CONVERSATION with an NPC

-- "GOSSIP_SHOW"	Example: Talking to a guard or the beginning of talking to an innkeeper.
-- "MERCHANT_SHOW"	When you first see a vendor's goods
-- "QUEST_GREETING"	When there is more than one quest available listed in a dialogue box (Current Quests / Available Quests)
-- "QUEST_PROGRESS"	When an NPC asks if you've finished your quest.
-- "QUEST_DETAIL" 	When Quest's Detail OPENS
-- "QUEST_COMPLETE"	When the window with the "Complete Quest" button OPENS
--=====================================================================--
	elseif  ((event == "GOSSIP_SHOW") or 
			(event == "MERCHANT_SHOW") or
			(event == "QUEST_GREETING") or
			(event == "QUEST_DETAIL") or 
			(event == "QUEST_COMPLETE") or  
			(event == "QUEST_PROGRESS")) and 
			UnitExists("target") then

		if not RPTimerIsRunning and (not RPHelper_TalkingToNPC) then
			RPHelper_TalkingToNPC = true
	----------------------------------------------------------------------------------------------------------
	--  If your character hasn't met this NPC before, 1) you'll introduce yourself & 2) the NPC name will be saved to INTRODUCED
	----------------------------------------------------------------------------------------------------------
			local found = false
			local i = 1
			while INTRODUCED[i] do
				if (UnitName("target")) == INTRODUCED[i] then
					found = true
					if RPCONFIG.Debug then dcf("NPC met before, #"..i) end
				end
				i = i + 1
			end

			if found == false then 
				table.insert(INTRODUCED, (UnitName("target")))
				if RPCONFIG.Debug then dcf("New NPC, let's introduce ourself") end
    			if (a <= RPCONFIG.talktonpc_firsttime["Chance"]) and (GetTime() - LastRP >= RPCONFIG.talktonpc_firsttime["Delay"]) then	
					local s, e, c = GetPhrase("talktonpc_firsttime")
					Roleplay(s, e, c)
				end
			else
	----------------------------------------------------------------------------------------------------------
	--  Beginning of Conversation
	----------------------------------------------------------------------------------------------------------						
    			if (a <= RPCONFIG.talktonpc_beginning["Chance"]) and (GetTime() - LastRP >= RPCONFIG.talktonpc_beginning["Delay"]) then	
					local s, e, c = GetPhrase("talktonpc_beginning")
					
					if UnitSex("player") == 1 then 		-- if the player is female
						table.insert(e,"CURTSEY")
					end

					if UnitLevel("target") >= UnitLevel("player") + 5 then   -- if the NPC is 5 levels higher than you
				   		table.insert(e,"KNEEL")
					end

					Roleplay(s, e, c)
				end
			end
	----------------------------------------------------------------------------------------------------------
	--  Middle of Conversation
	----------------------------------------------------------------------------------------------------------
		else -- if you are still talking to the same person (but different dialogue)
		if RPCONFIG.Debug then dcf("Still talking to NPC") end
    		if (a <= RPCONFIG.talktonpc_middle["Chance"]) and (GetTime() - LastRP >= RPCONFIG.talktonpc_middle["Delay"]) then				
				local s, e, c = GetPhrase("talktonpc_middle")
				Roleplay(s, e, c)
			end
			
			RPTimerIsRunning = false
			RPTimerFrame:Hide() -- Stop the Timer
		end -- if not RPTimerIsRunning and (not RPHelper_TalkingToNPC) then


--=====================================================================--
-- Either the END or a CONTINUATION of a CONVERSATION with an NPC

-- "GOSSIP_CLOSED" is called twice when closing a "gossip" box
-- QUEST_FINISHED when QUEST_DETAIL CLOSES & when QUEST_COMPLETE CLOSES
-- arg1 = mouse button pressed to close the window -or- nil if no button was used
	
-- Other windows such as "Merchant" or "Quest" windows can open immediately after this event,
-- but you're still talking to the same person so Emotes like "BYE" are not appropriate
--=====================================================================--
	elseif  (event == "GOSSIP_CLOSED") or
			(event == "MERCHANT_CLOSED") or
			(event == "QUEST_FINISHED") then
		RPHelper_TalkingToNPC = false
		RPNumFrames = 0
		RPTimerIsRunning = true
		RPTimerFrame:Show()
		if RPCONFIG.Debug then dcf(event) end
		
--=====================================================================--
-- Trading with other Players
-- "TRADE_SHOW" is called when a trade window opens after agreeing to a trade
-- "TRADE_CLOSED" is called when the trade window closes after a trade or a cancel
--=====================================================================--
-- TRADE_SHOW
    elseif (event == "TRADE_SHOW") and (UnitExists("target")) and (UnitIsPlayer("target")) then
        if RPCONFIG.Debug then dcf(event) end
        if (a <= RPCONFIG.trade_show["Chance"]) and (GetTime() - LastRP >= RPCONFIG.trade_show["Delay"]) then
            local s, e, c = GetPhrase("trade_show")
            if UnitSex("player") == 1 then 		-- if the player is female
		      table.insert(e,"CURTSEY")
		  end

            Roleplay(s, e, c)
        end
    
-- TRADE_CLOSED
    elseif (event == "TRADE_CLOSED") and (UnitExists("target")) and (UnitIsPlayer("target")) then
        if RPCONFIG.Debug then dcf(event) end
        if (a <= RPCONFIG.trade_closed["Chance"]) and (GetTime() - LastRP >= RPCONFIG.trade_closed["Delay"]) then
            local s, e, c = GetPhrase("trade_closed")
            Roleplay(s, e, c)
        end

--=====================================================================--
-- Check for instance / battleground
--=====================================================================--
    elseif (event == "PLAYER_ENTERING_WORLD") then
        local x,y = GetPlayerMapPosition("player")
        if (x == 0) and (y == 0) then
            if RPCONFIG.Debug then dcf("Entered Instance") end
        end
        local status, mapName, instanceID, minlevel, maxlevel;
        for i=1, MAX_BATTLEFIELD_QUEUES do
            status, mapName, instanceID, minlevel, maxlevel = GetBattlefieldStatus(i);
            if RPCONFIG.Debug then dcf(mapName.."(".. status..")"..instanceID) end
        end
--======================================================================--
-- Zone Change
--======================================================================--
    elseif (event == "ZONE_CHANGED_NEW_AREA") then
        if (GetRealZoneText() == GetBindLocation()) then
            if RPCONFIG.Debug then dcf("Zoned into hearthstone location") end
            if (a <= RPCONFIG.welcome_home["Chance"]) and (GetTime() - LastRP >= RPCONFIG.welcome_home["Delay"]) then
                local s, e, c = GetPhrase("welcome_home")
                Roleplay(s, e, c)
                RPStats.EVENT.rp = RPStats.EVENT.rp + 1  -- for statistics
            end
        end

--======================================================================--
-- Miscellaneous (CHAT_MSG_SYSTEM)
--======================================================================--
    elseif (event == "CHAT_MSG_SYSTEM") then
        if (SameEventStrings(ERR_LEARN_ABILITY_S, arg1)) or (SameEventStrings(ERR_LEARN_RECIPE_S, arg1)) or (SameEventStrings(ERR_LEARN_SPELL_S, arg1)) then
            if RPCONFIG.Debug then dcf("Learned New") end
            if (a <= RPCONFIG.learn["Chance"]) and (GetTime() - LastRP >= RPCONFIG.learn["Delay"]) then
                local s, e, c = GetPhrase("learn")
                Roleplay(s, e, c)
                RPStats.EVENT.rp = RPStats.EVENT.rp + 1  -- for statistics
            end
        elseif (SameEventStrings(DRUNK_MESSAGE_SELF2, arg1)) or (SameEventStrings(DRUNK_MESSAGE_SELF3, arg1)) or (SameEventStrings(DRUNK_MESSAGE_SELF4, arg1)) then
            if RPCONFIG.Debug then dcf("Drinking") end
            if (a <= RPCONFIG.drunk["Chance"]) and (GetTime() - LastRP >= RPCONFIG.drunk["Delay"]) then
                local s, e, c = GetPhrase("drunk")
                Roleplay(s, e, c)
                RPStats.EVENT.rp = RPStats.EVENT.rp + 1  -- for statistics
            end
        elseif (SameEventStrings(DRUNK_MESSAGE_SELF1, arg1)) then
            if RPCONFIG.Debug then dcf("Getting Sober") end
            if (a <= RPCONFIG.sober["Chance"]) and (GetTime() - LastRP >= RPCONFIG.sober["Delay"]) then
                local s, e, c = GetPhrase("sober")
                Roleplay(s, e, c)
                RPStats.EVENT.rp = RPStats.EVENT.rp + 1  -- for statistics
            end
        elseif (SameEventStrings(ERR_DEATHBIND_SUCCESS_S, arg1)) then
            if RPCONFIG.Debug then dcf("Set new home for hearthstone") end
            if (a <= RPCONFIG.new_home["Chance"]) and (GetTime() - LastRP >= RPCONFIG.new_home["Delay"]) then
                local s, e, c = GetPhrase("new_home")
                Roleplay(s, e, c)
                RPStats.EVENT.rp = RPStats.EVENT.rp + 1  -- for statistics
            end
        elseif (SameEventStrings(ERR_EXHAUSTION_NORMAL,arg1)) then
            if RPCONFIG.Debug then dcf("Rest bonus expired") end
            if (a <= RPCONFIG.exhausted["Chance"]) and (GetTime() - LastRP >= RPCONFIG.exhausted["Delay"]) then
                local s, e, c = GetPhrase("exhausted")
                Roleplay(s, e, c)
                RPStats.EVENT.rp = RPStats.EVENT.rp + 1  -- for statistics
            end
        

        
        end

--=====================================================================--
-- Monster Emotes
--=====================================================================--
    elseif (event == "CHAT_MSG_MONSTER_EMOTE") then
        -- general emotes, let's make sure we're targetting them first
        if (arg2 == (UnitName("target"))) then -- are we targetting the unit(name) emoting?
        -- calls for help
            if (arg1 == "%s calls for help!") then
                if RPCONFIG.Debug then dcf("MobEmote: Calls for Help") end
                if (a <= RPCONFIG.monster_emote_help["Chance"]) and (GetTime() - LastRP >= RPCONFIG.monster_emote_help["Delay"]) then
                    local s, e, c = GetPhrase("monster_emote_help")
                    Roleplay(s, e, c)
                end
        -- runs in fear
            elseif (arg1 == "%s attempts to run away in fear!") then
                if RPCONFIG.Debug then dcf("MobEmote: Runs in Fear") end
                if (a <= RPCONFIG.monster_emote_fear["Chance"]) and (GetTime() - LastRP >= RPCONFIG.monster_emote_fear["Delay"]) then
                    local s, e, c = GetPhrase("monster_emote_fear")
                    Roleplay(s, e, c)
                end
        -- becomes enraged
            elseif (arg1 == "%s becomes enraged!") then
                if RPCONFIG.Debug then dcf("MobEmote: Becomes Enraged") end
                if (a <= RPCONFIG.monster_emote_enrage["Chance"]) and (GetTime() - LastRP >= RPCONFIG.monster_emote_enrage["Delay"]) then
                    local s, e, c = GetPhrase("monster_emote_enrage")
                    Roleplay(s, e, c)
                end
            end
        -- special/rare emotes, we'll target for the RP then switch back
        -- BRD Slaves
        elseif (arg2 == "Slave") or (arg2 == "Tortured Slave") then
            if RPCONFIG.Debug then dcf("BRD Slave emote") end
            if (a <= RPCONFIG.brd_emote_slave["Chance"]) and (GetTime() - LastRP >= RPCONFIG.brd_emote_slave["Delay"]) then
                local s, e, c = GetPhrase("brd_emote_slave")
                ---TargetByName(arg2)
                Roleplay(s, e, c)
                ---TargetLastTarget()
            end
        -- WPL Scourge Cauldrons (can't target these)
        elseif (arg2 == "The Scourge Cauldron") then
            if RPCONFIG.Debug then dcf("Scourge Cauldron! Chance="..RPCONFIG.scourge_cauldron["Chance"].." Roll="..a) end
            if (a <= RPCONFIG.scourge_cauldron["Chance"]) and (GetTime() - LastRP >= RPCONFIG.scourge_cauldron["Delay"]) then
                local s, e, c = GetPhrase("scourge_cauldron")
                Roleplay(s,e,c)
            end
        end -- end of chat_msg_monster_emote
-- EPL Tower capture
    elseif (event == "CHAT_MSG_CHANNEL" and string.find(arg1,"has been taken by the") and arg9 == "LocalDefense - Eastern Plaguelands") then
        local englishFaction, playerFaction = UnitFactionGroup("player");
        if RPCONFIG.Debug then dcf("EPL: Tower Capture") end
        if (string.find(arg1, englishFaction)) then
        if RPCONFIG.Debug then dcf("EPL: Capture by Own Faction ("..englishFaction..")") end
            if (a <= RPCONFIG.epl_pvp_tower_capture["Chance"]) and (GetTime() - LastRP >= RPCONFIG.epl_pvp_tower_capture["Delay"]) then
                local s, e, c = GetPhrase("epl_pvp_tower_cap")
                Roleplay(s, e, c)
                RPStats.EVENT.rp = RPStats.EVENT.rp + 1  -- for statistics
            end
        elseif (a <= RPCONFIG.epl_pvp_tower_lose["Chance"]) and (GetTime() - LastRP >= RPCONFIG.epl_pvp_tower_lose["Delay"]) then
                local s, e, c = GetPhrase("epl_pvp_tower_lose")
                Roleplay(s, e, c)
                RPStats.EVENT.rp = RPStats.EVENT.rp + 1  -- for statistics
        end

-- Battlegrounds    
	elseif (event == "CHAT_MSG_BG_SYSTEM_NEUTRAL") then
		local bg = GetRealZoneText()
			if (arg1 == "The battle for Arathi Basin has begun!") or (arg1 == "The battle for Alterac Valley has begun!") or (arg1 == "Let the battle for Warsong Gulch begin!") then
				if RPCONFIG.Debug then dcf("Battleground started: "..bg) end
				if (a <= RPCONFIG.bg_begin["Chance"]) and (GetTime() - LastRP >= RPCONFIG.bg_begin["Delay"]) then
					local s, e, c = GetPhrase("bg_begin")
					Roleplay(s, e, c)
					RPStats.EVENT.rp = RPStats.EVENT.rp + 1  -- for statistics
				end
			end
		if string.find(arg1, "and is near victory!") then
			local englishFaction, playerFaction = UnitFactionGroup("player");
			if string.find(arg1, englishFaction) then
				if RPCONFIG.Debug then dcf("Arathi Basin: 1800 Resources") end
			end
		end
	end

----------------------------------------------------------------------------------------------------------------------------
--  Getting Time of the RP
----------------------------------------------------------------------------------------------------------------------------

	if JustRPed == true then
		LastRP = GetTime()
		JustRPed = false
        RPedAtLeastOnce = true
	end

--=====================================================================--
-- debug
--=====================================================================--
	if RPCONFIG.Debug and RPHelper_Debug_Events then
		for k,v in pairs(RPHelper_Debug_Events) do
			if  (event == v) then
				local x = event
		 		if arg1 then		x = x .. " arg1=" .. arg1;			end
		 		if arg2 then		x = x .. " arg2=" .. arg2;			end
		 		if arg3 then		x = x .. " arg3=" .. arg3;			end
		 		if arg4 then		x = x .. " arg4=" .. arg4;			end
		 		if arg5 then		x = x .. " arg5=" .. arg5;			end
		 		if arg6 then		x = x .. " arg6=" .. arg6;			end
		 		if arg7 then		x = x .. " arg7=" .. arg7;			end
		 		if arg8 then		x = x .. " arg8=" .. arg8;			end
		 		if arg9 then		x = x .. " arg9=" .. arg9;			end
				--DEFAULT_CHAT_FRAME:AddMessage(x, 0.4, 1.0, 0.6)
				dcf(x)
			end
		end
	end

end -- function RP_OnEvent(event)

function EndOfConversationWithNPC()
    if RPCONFIG.Debug then dcf("End of Conversation with NPC") end
	----------------------------------------------------------------------------------------------------------
	--  End of Conversation
	----------------------------------------------------------------------------------------------------------
	if not UnitOnTaxi("player") then
        DoEmote("STAND")
        if RPCONFIG.Debug then dcf("DoEmote(STAND)") end
    end
	if UnitExists("target") then
		local a = math.random()
    	if (a <= RPCONFIG.talktonpc_end["Chance"]) and (GetTime() - LastRP >= RPCONFIG.talktonpc_end["Delay"]) then	
			
			local s, e, c = GetPhrase("talktonpc_end")
			if not UnitOnTaxi("player") then
                if UnitSex("player") == 1 then 		-- if the player is female
				    table.insert(e,"CURTSEY")
                end
			end
            -- TODO: if UnitOnTaxi remove BOW,CURTSEY, etc. unable to do mounted
			Roleplay(s, e, c)

        	LastRP = GetTime()
			JustRPed = false
        	RPedAtLeastOnce = true
		end			
	end -- if UnitExists("target")
end

----------------------------------------------------------------------------------------------------------
--  Function to handle the new "chatter" RP
--  This function is called every 5 seconds (to save on CPU use and for inherent spam prevention), so
--  events processed here are actually processed in multiples of 5 seconds. A delay of, say, 3 seconds will
--  be treated as 5 seconds. A delay of 6 will be treated as 10, and so on.
----------------------------------------------------------------------------------------------------------
function RPHTimedEvent()
	local a = math.random()
	local s = {}
	local e = {}
	local c = {}
	local r = {}
	--=====================================================================--
	-- Random chatter
	--=====================================================================--
	if (a <= RPCONFIG.chatter["Chance"]) and (GetTime() - LastRP >= RPCONFIG.chatter["Delay"]) then
		if RPCONFIG.Debug then dcf("Random chatter.") end
		local s, e, c, r = GetPhrase("chatter")
		Roleplay(s, e, c, r)
	end
	if (JustRPed == true) then
		LastRP = GetTime()
		JustRPed = false
		RPedAtLeastOnce = true
	end
end