-- ResurrectionWho by jascha@ja-s.de

RW_CONF = { globaltimeout = 5, timeout = 180, deathnotice = true }
RW_DISABLED = {}
RW_ORG_CONF = RW_CONF;
RW_Cache = {}
RW_WhoWhat = nil;
RW_LastWho = 0;
RW_FriendsOpen = nil;
RW_ORG_WhoList_Update = nil;
RW_ORG_Census_WhoList = nil;
RW_VERSION = "1.00";
RW_ME = UnitName("player") .. "." .. GetRealmName();

ResurrectionWhoDetails = {
    name = "ResurrectionWho",
    version = RW_VERSION,
    releaseDate = "October 14, 2005",
    author = "Possible",
    email = "jascha@ja-s.de",
    website = "http://ja-s.de/",
    category = MYADDONS_CATEGORY_OTHERS
     -- optionsframe = "ResurrectionWhoOptionsFrame"
};
ResurrectionWhoHelp = {};
ResurrectionWhoHelp[1] = RW_LANG_MYADDON_HELP_1;

function ResurrectionWho_OnLoad()
    this:RegisterEvent("WHO_LIST_UPDATE");
    this:RegisterEvent("ADDON_LOADED");
    --this:RegisterEvent("CHAT_MSG_COMBAT_FRIENDLY_DEATH");
    this:RegisterEvent("VARIABLES_LOADED");
    SLASH_RESURRECTIONWHO1 = "/ResurrectionWho";
    SLASH_RESURRECTIONWHO2 = "/resurrectionwho";
    SLASH_RESURRECTIONWHO3 = "/reswho";
    SlashCmdList["RESURRECTIONWHO"] = function(msg)
        ResurrectionWho_Slash(msg);
    end
end

function ResurrectionWho_OnEvent(event)
    if (event == "WHO_LIST_UPDATE") then
        ResurrectionWhoUpdate();
    elseif (event == "VARIABLES_LOADED") then
        if(not myAddOnsFrame_Register) then
            skrim("ResurrectionWho "..RW_VERSION.." by Possible (jascha@ja-s.de) loaded. Help: /reswho");
        end
    elseif (event == "ADDON_LOADED") then
        if(myAddOnsFrame_Register) then
            myAddOnsFrame_Register(ResurrectionWhoDetails, ResurrectionWhoHelp);
        end
    elseif (event == "CLEAR_TOOLTIP") then
        GameTooltip:ClearLines();
        if (GameTooltipTextRight1) then
            GameTooltipTextRight1:SetText("");
        end
    --[[
    elseif (event == "CHAT_MSG_COMBAT_FRIENDLY_DEATH") then
        if (RW_CONF.deathnotice and (not RW_DISABLED[RW_ME])) then
            ResurrectionWho_SomeDead(arg1);
        end]]--
    end
end

function skrim(msg)
    DEFAULT_CHAT_FRAME:AddMessage(msg);
end


function ResurrectionWho_Slash(command)
    local i,j, cmd, param = string.find(command, "^([^ ]+) (.+)$");
    if (not cmd) then cmd = command; end
    if (not cmd) then cmd = ""; end
    if (not param) then param = ""; end
    
    local RW_TEMP = "";
    
    if (cmd == "") then
        skrim(RW_LANG_HELP .. " ResurrectionWho:");
        if (RW_DISABLED[RW_ME]) then RW_TEMP = "disabled"; else RW_TEMP = "enabled"; end
        skrim(" |cffffffff/reswho enable/disable - "..RW_LANG_HELP_4.." "..RW_LANG_HELP_PERCHAR.." |cff2040ff["..RW_TEMP.."]|cffffffff "..RW_LANG_DEFAULT..": enabled");
        RW_TEMP = RW_CONF.timeout;
        skrim(" |cffffffff/reswho updatetime <n> - "..RW_LANG_HELP_1.." |cff2040ff["..RW_TEMP.."]|cffffffff "..RW_LANG_DEFAULT..": 180");
        RW_TEMP = RW_CONF.globaltimeout;
        skrim(" |cffffffff/reswho timeout <n> - "..RW_LANG_HELP_2.." |cff2040ff["..RW_TEMP.."]|cffffffff "..RW_LANG_DEFAULT..": 5 ("..RW_LANG_RECOMMENDED..")");
        skrim(" |cffffffff/reswho help - "..RW_LANG_HELP_5);
        skrim(" |cffffffff/reswho reset - "..RW_LANG_HELP_3);
    elseif (cmd == "help") then
        message(RW_LANG_MYADDON_HELP_1);
    elseif (cmd == "updatetime" ) then
        RW_CONF.timeout = param
        RW_TEMP = RW_CONF.timeout;
        skrim("Updatetime "..RW_LANG_HELP_CHANGED.." |cff2040ff["..RW_TEMP.."]|cffffffff");
    elseif (cmd == "timeout" ) then
        RW_CONF.globaltimeout = param
        RW_TEMP = RW_CONF.globaltimeout;
        skrim("Timeout "..RW_LANG_HELP_CHANGED.." |cff2040ff["..RW_TEMP.."]|cffffffff");
    elseif (cmd == "enable") then
        RW_DISABLED[RW_ME] = nil;
        if (RW_DISABLED[RW_ME]) then RW_TEMP = "disabled"; else RW_TEMP = "enabled"; end
        skrim("Status "..RW_LANG_HELP_CHANGED.." |cff2040ff["..RW_TEMP.."]|cffffffff");
    elseif (cmd == "disable") then
        RW_DISABLED[RW_ME] = true;
        if (RW_DISABLED[RW_ME]) then RW_TEMP = "disabled"; else RW_TEMP = "enabled"; end
        skrim("Status "..RW_LANG_HELP_CHANGED.." |cff2040ff["..RW_TEMP.."]|cffffffff");
    elseif (cmd == "reset" ) then
        RW_CONF = RW_ORG_CONF;
        RW_DISABLED[RW_ME] = nil;
        skrim(RW_LANG_HELP_RESETTED);
    else
        skrim(RW_LANG_HELP_UNKNOWN .. cmd);
    end
    return;
end

function ResurrectionWho(refresh)
    if (RW_DISABLED[RW_ME]) then
        return;
    end
    if (refresh) then
        SetWhoToUI(0);
        WhoList_Update = RW_ORG_WhoList_Update;
        FriendsFrame_Update = RW_ORG_FriendsFrame_Update;
        if (RW_ORG_Census_WhoList) then
            CensusPlus_ProcessWhoResults = RW_ORG_Census_WhoList;
        end
    end
    local RW_NAME = "";
    if ((GameTooltip:IsVisible()) and (GameTooltipTextLeft1:GetText())) then
        local RW_START, RW_END = string.find(GameTooltipTextLeft1:GetText(), RW_LANG_TOOLTIP);
        if (RW_START == nil) then
            if (refresh and (GameTooltipTextRight1:GetText() == RW_LANG_CORPSE)) then
                RW_NAME = GameTooltipTextLeft1:GetText();
            else
                return; -- it is no corpse
            end
        else
            RW_NAME = string.sub(GameTooltipTextLeft1:GetText(), RW_END + 1);
        end
        
        local rerequest = false;
        local linesAdded = 0;
        GameTooltip:ClearLines();
        
        if (not RW_Cache[RW_NAME]) then -- Unknown
            GameTooltip:AddDoubleLine(RW_NAME, RW_LANG_CORPSE, 1.0,1.0,1.0, 0.7,0.7,0.7);
            if (time() > RW_LastWho + RW_CONF.globaltimeout) then
                GameTooltip:AddLine(RW_LANG_REQUESTING, 0.7, 0.7, 0.7);
                rerequest = true;
            else
                GameTooltip:AddLine(RW_LANG_TOFAST, 0.7, 0, 0);
            end
        else -- Known
            local info = RW_Cache[RW_NAME];
            if (not info.name) then -- Offline
                GameTooltip:AddDoubleLine(RW_NAME, RW_LANG_CORPSE, 1.0,1.0,1.0, 0.7,0.7,0.7);
                GameTooltip:AddLine(RW_LANG_OFFLINE, 1.0, 0, 0);
            elseif (info.name) then -- Online
                -- Colored Name if Self/InParty/InGuild/else
                if (info.name == UnitName("player")) then
                    GameTooltip:AddDoubleLine(RW_NAME, RW_LANG_CORPSE, 0,1.0,0, 0.7,0.7,0.7);
                elseif (UnitInPartyByName(RW_NAME)) then
                    GameTooltip:AddDoubleLine(RW_NAME, RW_LANG_CORPSE, 0,1.0,1.0, 0.7,0.7,0.7);
                elseif (IsInGuild() and info.guild and string.len(info.guild) > 0 and (GetGuildInfo("player") == info.guild)) then
                    GameTooltip:AddDoubleLine(RW_NAME, RW_LANG_CORPSE, 1.0,1.0,0, 0.7,0.7,0.7);
                else
                    GameTooltip:AddDoubleLine(RW_NAME, RW_LANG_CORPSE, 1.0,1.0,1.0, 0.7,0.7,0.7);
                end
                
                -- Infos
                local color = RAID_CLASS_COLORS[info.group]; -- group -> english class name
                color.string = string.format("|cff%02x%02x%02x", 255 * color.r, 255 * color.g, 255 * color.b);
                color.reset = "|r";
                GameTooltip:AddLine(RW_LANG_LEVEL.." "..info.level.." "..info.race.." "..color.string..info.class..color.reset.." "..RW_LANG_PLAYER, 1.0, 1.0, 1.0);
                if (info.guild and string.len(info.guild) > 0) then
                    GameTooltip:AddLine("<"..info.guild..">", 1.0, 1.0, 0);
                end
                
                -- "Wiederbelebar" :)
                GameTooltip:AddLine(RW_LANG_RESURRECTABLE, 0, 1.0, 0);
            else -- This cant be, but i am paranoid :P
                GameTooltip:AddDoubleLine(RW_NAME, RW_LANG_CORPSE, 1.0,1.0,1.0, 0.7,0.7,0.7);
                GameTooltip:AddLine("Unknown / Error", 1.0, 0, 0);
            end
            
            -- check for outdated
            if ((time() > RW_LastWho + RW_CONF.globaltimeout) and (info.ftime) and (time() > info.ftime + RW_CONF.timeout)) then
                rerequest = true;
            end
        end
        GameTooltip:Show();
        
        -- data are old, or not available, so request.
        if (rerequest) then
            RW_LastWho = time();
            RW_WhoInPro = true;
            RW_WhoWhat = RW_NAME
            SetWhoToUI(1);
            
            -- Saving original function
            if (WhoList_Update ~= nilFunction) then
                RW_ORG_WhoList_Update = WhoList_Update;
                RW_ORG_FriendsFrame_Update = FriendsFrame_Update;
            end
            -- Thats the overriding
            WhoList_Update = nilFunction;
            FriendsFrame_Update = nilFunction;
            
            if (CensusPlus_ProcessWhoResults and (CensusPlus_ProcessWhoResults ~= nilFunction)) then
                RW_ORG_Census_WhoList = CensusPlus_ProcessWhoResults;
                CensusPlus_ProcessWhoResults = nilFunction;
            end
            
            SendWho("n-\""..RW_NAME.."\"");
        end
    end
end

function ResurrectionWhoUpdate()
    if (not RW_WhoInPro) then
        return;
    end
    local found = false;
    local numWhoResults = GetNumWhoResults();
    for i = 1, numWhoResults, 1 do
        local name, guild, level, race, class, zone, group = GetWhoInfo(i);
        if (name == RW_WhoWhat) then
            local now = time();
            RW_Cache[name] = { name = name, guild = guild, level = level, race = race, class = class, zone = zone, group = group, ftime = now }
            found = true;
            break;
        end
    end
    RW_WhoInPro = false;
    if (not found) then
        RW_Cache[RW_WhoWhat] = { name = nil, guild = nil, level = nil, race = nil, class = nil, zone = nil, group = nil, ftime = nil }
    end
    RW_WhoWhat = "";
    ResurrectionWho(true);
end

function nilFunction()
end

function ResurrectionWho_OnHide()
    GameTooltip:ClearLines();
end

function UnitInPartyByName(name)
    for i=1, MAX_PARTY_DEBUFFS do
        if (name == UnitName("party"..i)) then
            return true
        end
    end
    return nil
end
