-- Reputation addon for World of Warcraft
-- By: Krytharn, Al'Akir, EU
-- Desc: automatically shows the reputation bar for the faction you just gained reputation with
--
-- for a comprehensive list of available World of Warcraft functions, see: http://www.wowwiki.com/World_of_Warcraft_API


-- register with the localisation module
local L = AceLibrary("AceLocale-2.2"):new("Reputation")

-- define slash commands
local options = { 
	type='group',
	args = {
		test = {
		    type = "execute",
		    name = L["test"],
		    desc = L["Test factions"],
		    func = "GatherInformation",
		},
	},
}

-- create addon instance
Reputation = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceEvent-2.0")

-- register slash commands
Reputation:RegisterChatCommand(L["Slash-Commands"], options)

-- event functions
function Reputation:OnInitialize()
    -- Called when the addon is loaded

    -- enable or disable debugging information (should be false for release version)
    Reputation.isDebug = false;
end

function Reputation:OnEnable()
	-- Called when the addon is enabled

	-- gather faction information
	Reputation:GatherInformation();
	-- register for World of Warcraft events (see: http://www.wowwiki.com/Events_%28API%29)
	self:RegisterEvent("UPDATE_FACTION");
	--
	if (Reputation.isDebug) then 
		self:Print("loaded."); 
		self:Print(L["language pack loaded: %q"], L["language"]);
	end;
end

function Reputation:OnDisable()
    -- Called when the addon is disabled
end

function Reputation:UPDATE_FACTION()
	-- Called when faction information is updated

	-- get the number of factions
	numFactions = GetNumFactions();

	-- check if a faction was added and update the information
	if (numFactions ~= Reputation.numFactions) then
		Reputation:GatherInformation();
		--
		if (Reputation.isDebug) then self:Print("new faction added."); end;
		--
		return;
	end
	
	-- get the name of the currently watched faction (nil if no faction is being watched)
	watchedName, _, _, _, _ = GetWatchedFactionInfo();
	
	-- check which faction was changed by comparing to known list
	for i=1, numFactions, 1 do
		name, _, _, _, _, earnedValue, _, _, isHeader, isCollapsed, _ = GetFactionInfo(i);		
		
		-- determine the factionIndex (nil if the faction is not in the list, see: GatherInformation() )
		factionIndex = Reputation.indexByName[name];

		-- if the faction is found in our list,
		if (factionIndex ~= nil and not (isHeader or isCollapsed)) then
			-- compare the earnedValue to see if it has been changed
			if (Reputation.earnedByName[name] < earnedValue) then
				-- check if we are currently watching this faction
				if (name ~= watchedName) then
					-- player gained reputation with another faction, watch that faction
					-- (use "i" instead of "factionIndex" to make sure the correct faction is watched)
					SetWatchedFactionIndex(i);
					-- tell the player this faction is automatically watched from now
					self:Print(L["watching %q now."], name);
				end
				-- only process the first changed faction found 
				break;
			end 
		elseif (Reputation.isDebug) then
			self:Print("faction not found in list: "..name);
		end
	end
	
	-- update the faction info
	Reputation:GatherInformation();
end


function Reputation:GatherInformation()
	-- store the current number of faction, so we can see if a faction has been added
	Reputation.numFactions = GetNumFactions();

	-- store faction information in a few look-up-tables
	Reputation.earnedByName = {};
	Reputation.indexByName = {};
	--Reputation.nameByIndex = {};

	for factionIndex=1, Reputation.numFactions, 1 do
		-- get faction info
		name, description, standingId, bottomValue, topValue, earnedValue, atWarWith, canToggleAtWar, isHeader, isCollapsed, isWatched = GetFactionInfo(factionIndex);

		-- self:Print("name: %q  isHeader: %q", name, isHeader);

		-- add faction to list if it is not a group of factions, like the Steemwheedle Cartel
		if (isHeader == nil) then
			Reputation.earnedByName[name] = earnedValue;
			Reputation.indexByName[name] = factionIndex;
			--Reputation.nameByIndex[factionIndex] = name;
		end
	end
end