
local string_byte = string.byte
local string_char = string.char

local A = string_byte("a")

local function Rot13(str)
	return (str:gsub("%a", function (chr)
		return string_char((string_byte(chr) - A + 13) % 26 + A)
	end))
end

Relegation.MessageList = {
	[Rot13 "1000t27rhvafgnagqryvirel"] = true,
	[Rot13 "2499haqrgrpgnoyrpbzrfjvgu30qnlzbarlonpxthnenagrr"] = true,
	[Rot13 "27191000tbyq2719gubhtujrnerabggurybjrfgohgjrnergurfnsrfgnaqsnfgqryvirelabobgjrunirgubhfnaqfbsfhccyvref127yvirfhccbegjrypbzrgbjjjtbyqpynffzngrfpbz"] = true,
	[Rot13 "29801000tgubhtujrnerabggurybjrfgohgjrnergurfnsrfgnaqsnfgqryvirelabobgnaqjrunirgrnzchepunfrvgvf100ybjrfgjrunirgubhfnaqfbsfhccyvref247yvirfhccbegjrypbzrgbjjj2jbjtbyqbzjjj2jbjtbyqbz"] = true,
	[Rot13 "abjjrypbzrgbjjjjbj4fargjrbssrepurncrfgjbjtbyqnaqcbjreyriryvatfreivprertvfgreabjbabhejrofvgr200tbaylgnxr6001000tbaylgnxr2799jrpnaqryvireva124ubhefcbjreyrirysebz160baylgnxrf16918thnenagrr400tnaqnyi40zbh"] = true,
	[Rot13 "bayl130cbhaqf"] = true,
	[Rot13 "bayl135cbhaqfcre1000tbyqjrnerlbheorfgpubvpr"] = true,
	[Rot13 "bayl155rhebf"] = true,
	[Rot13 "bayl155rhebfcre1100tbyq10rkgentbyq"] = true,
	[Rot13 "bayl16cbhaqfcre1000tbyqjrnerlbheorfgpubvpr"] = true,
	[Rot13 "bayl170rhebf"] = true,
	[Rot13 "bayl17cbhaqfcre1000tbyqjrnerlbheorfgpubvpr"] = true,
	[Rot13 "bayl190rhebf"] = true,
	[Rot13 "bayl22cbhaqfcre1000tbyqjrnerlbheorfgpubvpr"] = true,
	[Rot13 "bayl24cbhaqfcre1100tbyq10rkgentbyq"] = true,
	[Rot13 "bayl3399cre1000tbyqjrypbzrgbtbyqcntrepbz"] = true,
	[Rot13 "bayl3399cre1100tbyq100rkgentbyqsbeserrjrypbzrgbovtzbhguarfgpbz"] = true,
	[Rot13 "bayl3399cre1100tbyqjrnerlbheorfgpubvprjjjovtzbhguarfgpbz"] = true,
	[Rot13 "bayl35rhebfcre1100tbyq10rkgentbyq"] = true,
	[Rot13 "bjalbpbz12991000tbyqsnfgfrpherernygvzrqryvirelgubhfnaqfbsfhccyvrefterngcevprfrevbhfpbzcnalpurncguranyybgurefpubbfvathfjulabg"] = true,
	[Rot13 "bjalpbz11991000tbyqsnfgfrpherernygvzrqryvirelgubhfnaqfbsfhccyvrefterngcevprfrevbhfpbzcnalpurncgunanyybgurefpubbfvathfjulabgjjjbjalpbz"] = true,
	[Rot13 "cbjreyriryvatbsyriryfubabecbvagfcebsrffvbafnaqerchgngvbatrggurebpxrgvagurjbjcbjreyriryvat160173rhe6070whfgarrq120rhecyrnfrivfvgrjjjsnfgttpbaapbaapbz"] = true,
	[Rot13 "cbjreyriryvatbsyriryfubabecbvagfcebsrffvbafnaqerchgngvbatrggurebpxrgvagurjbjcbjreyriryvat160173rhe6070whfgarrq120rhecyrnfrivfvgrjjjsnfgttpbz"] = true,
	[Rot13 "cevprqbjantnvajrypbzrgbjjjtzjbexvatrhurernergurpurncrfgtbyq1000t137rhe10000t136rhegursnfgrfgfcrrqbsqryvirelgurorfgfreivprjjjtzjbexvatrh"] = true,
	[Rot13 "chgfonaarqnppfbaronlgbznxrpnfu"] = true,
	[Rot13 "eg2hxjbjtbyqpbzgbcrhjbjtbyqfryyre1198toc1000tzberguna150000beqrefpbzcyrgrqohlvgabjnaqtrgvgva15ubhefunir10qvfpbhagjvgugurqvfpbhagpbqrhxjbjtbyqeg6hxjbjtbyqpbzorgurbarlbhjnag"] = true,
	[Rot13 "eg2hxjbjtbyqpbzgbcrhjbjtbyqfryyre1398toc1000t1299810000tzberguna150000beqrefpbzcyrgrqohlvgabjnaqtrgvgva30zvahgrfunir10qvfpbhagjvgugurqvfpbhagpbqrhxjbjtbyqeg1hxjbjtbyqpbzjbjxvatabj"] = true,
	[Rot13 "fbeelsbeobgurevatvslbharrqjbjtbyqnaqcbjreyriryvatcyrnfrsrryserrgbivfvgjjjurltgpbzgunaxf1000t2799rhe2000t5499rhe5000t13299rhe"] = true,
	[Rot13 "fbeelsbeobgurevatvslbharrqjbjtbyqnaqcbjreyriryvatcyrnfrsrryserrgbivfvgjjjurltgpbzgunaxf1000t3799rhe2000t7399rhe5000t17999rhe"] = true,
	[Rot13 "fbeelsbeobgurevatvslbharrqjbjtbyqnaqcbjreyriryvatcyrnfrsrryserrgbivfvgjjjvtsnqpbzgunaxf1000t4299rhevtsnqpbz160cbjreyriryvat23935rhe10zvaffgnegnsgrebeqre"] = true,
	[Rot13 "fbzrfreire1137rhe1000t"] = true,
	[Rot13 "fcrpvnybssrefsbe0012trggur10obhaftbyqsbehfvatarjgenqrzrgubqfzberzrzorefguvfvfjjjjbjrhebcrpadhvpxylnfjryynfgurfnsrthnenagrrjjjjbjrhebcrpa"] = true,
	[Rot13 "fcrpvnybssrefsbe0020trggur10obhaftbyqsbehfvatarjgenqrzrgubqfzberybjrecevpr0020sbeorpbzvatbheivczrzorefguvfvfjjjjbjrhebcrpadhvpxylnfjryynfgurfnsrthnenagrr"] = true,
	[Rot13 "fcrpvnybssrefsbe0020trggur10obhaftbyqsbehfvatarjgenqrzrgubqfzberybjrecevpr0020sbeorpbzvatbheivczrzorefguvfvfjjjjbjrhebcrpadhvpxylnfjryynfgurfnsrthnenagrrjjjjbjrhebcrpa"] = true,
	[Rot13 "fcrpvnybssrefsbe0026trggur10obhaftbyqsbehfvatarjgenqrzrgubqfzberybjrecevpr0023sbeorpbzvatbheivczrzorefguvfvfjjjjbjrhebcrpadhvpxylnfjryynfgurfnsrthnenagrr"] = true,
	[Rot13 "fcrpvnybssrefsbe0029trggur10obhaftbyqsbehfvatarjgenqrzrgubqfzberybjrecevpr0023sbeorpbzvatbheivczrzorefguvfvfjjjjbjrhebcrpadhvpxylnfjryynfgurfnsrthnenagrr"] = true,
	[Rot13 "fcrpvnybssrefsbe1000t12trggur10obhaftbyqsbehfvatarjgenqrzrgubqfzberzrzorefguvfvfjjjjbjrhebcrpadhvpxylnfjryynfgurfnsrthnenagrrjjjjbjrhebcrpa"] = true,
	[Rot13 "fcrpvnybssrefsbe1000t12trggur10obhaftbyqsbehfvatarjgenqrzrgubqfzberzrzorefguvfvfjjjjbjrhebcrpadhvpxylnfjryynfgurfnsrthnenagrrpvepyrjjjjbjrhebcrpapvepyr"] = true,
	[Rot13 "fcrpvnybssrefsbeunyybjznf0023cretbyqsbepregnvafreirefgurybjcevprfreirepunatrfgvzrgbgvzrjjjjbjrhebcrpatrggurtbyqnfnc"] = true,
	[Rot13 "fcrpvnybssresebzjjjjbjrhebcrpatrggurpurncrfgtbyqsbebayl0020gurybjcevprfreirepunatrfgvzrgbgvzrerzrzoregbivfvgjjjjbjrhebcrpagbtrggurpurncrfgtbyq"] = true,
	[Rot13 "fcrpvnybssresebzjjjjbjrhebcrpatrggurpurncrfgtbyqsbebayl0023gurybjcevprfreirepunatrfgvzrgbgvzrerzrzoregbivfvgjjjjbjrhebcrpagbtrggurpurncrfgtbyq"] = true,
	[Rot13 "ffrtnzrfpbzpuevfgznffnyrfznxrnabeqrebstbyqbecylbhjvyytrgnpunaprgbjva10000inyhrgevcgbpuvanserrcynargvpxrgfserrubgryserrgbhenaqfrirenyybtvgrpujveryrffcnpxntrtvirnjnlpbhagyrffpbhcbafrirelqnlpbzrba"] = true,
	[Rot13 "fgnejjjunccltbyqfpbzfgnefryyfgurzbfgrkcrafvirtbyqehpenmljul20000yblnyphfgbzrefjvyynafjregungpnhfrbheqryvirelfnsglnaqcbjreyriyvatfreivprnergurorfgbsorfg1000t3099rhezngrfpbzrbawhfggelvg"] = true,
	[Rot13 "fnvqtengmgbbgureflbhpnatrgvggbb1000tbyqsebz11rhebaylivfvgjjjxrzvfvpbznaqtrglbhejvfu"] = true,
	[Rot13 "fnvqtengmgbbgureflbhpnatrgvggbbivfvgjjjxrzvfvpbznaqtrglbhejvfu"] = true,
	[Rot13 "frrxvatsbenfbheprjurerfnsrjbjtbyqvffbyqjjjtbyqfnyrepbzvflbheorfgpubvprnfybjnf002rhetbyqfragjvguva30zvaf24uefrawbl"] = true,
	[Rot13 "frrxvatsbenfbheprjurerfnsrjbjtbyqvffbyqjjjtbyqfnyrepbzvflbheorfgpubvprnfybjnf002rhetbyqfragjvguva30zvaf24uefrawbl1frrxvatsbenfbheprjurerfnsrjbjtbyqvffbyqjjjtbyqfnyrepbzvflbheorfgpubvprnfybjnf002rhetbyq"] = true,
	[Rot13 "frrxvatsbenfbheprjurerfnsrjbjtbyqvffbyqjjjtbyqfnyrepbzvflbheorfgpubvprnfybjnf002rhetbyqfragjvguva30zvaf24uefrawbl2frrxvatsbenfbheprjurerfnsrjbjtbyqvffbyqjjjtbyqfnyrepbzvflbheorfgpubvprnfybjnf002rhetb"] = true,
	[Rot13 "gbrawblgursvsnnaqgurtnzrnggurfnzrgvzrjjjjbjrhebcrpavfgurbargburyclbhfnirlbhetnzrgvzr"] = true,
	[Rot13 "gbtrg10serrtbyqvslbhhfvatarjgenqrzrgubqfgbohltbyqjrjvyycerfragrkgen10tbyqserrgblbhpbzrgbbhejrofvgrjjjjbjrhebcrpavslbhunirnalceboyrzcyrnfrpbagnpghfolgurbayvarfreivprdhvpxylnfjryynfgurfnsrthnenagrr"] = true,
	[Rot13 "gotbyqpbzgbcrhjbjtbyqfryyre1198toc1000t1199810000tzberguna250000beqrefpbzcyrgrqohlvgabjnaqtrgvgva60zvahgrfunir10qvfpbhagjvgugurqvfpbhagpbqrgotbyqgotbyqpbzjbjtbyqxvyyreabj"] = true,
	[Rot13 "gotbyqpbzgbcrhjbjtbyqfryyrepenmlcevpr998toc1000t959810000tzberguna250000beqrefpbzcyrgrqohlvgabjnaqtrgvgva60zvahgrfunir5qvfpbhagjvgugurqvfpbhagpbqrgotbyqgotbyqpbzjbjtbyqxvyyreabj"] = true,
	[Rot13 "gurorfgfreivprjjjtzj0jfkp0zrhe00281t"] = true,
	[Rot13 "gurorfgfreivpruggcjjjtzj0jfkp0zrhe00281t"] = true,
	[Rot13 "gurznffrfunirfunecrlrf1000tbyqsebz11rhebaylgurpurncrfgtbyqvfvajjjxrzvfvpbzpbzcnervg"] = true,
	[Rot13 "gurznffrfunirfunecrlrfgurpurncrfgtbyqvfvajjjxrzvfvpbzpbzcnervg"] = true,
	[Rot13 "hxjbjtbyqpbzqverpgfryyvatsebzhxgrnz1298toc1000tqryvirejvguva16ubhef3lrnefnaqunirzberguna100000phfgbzref100snfgpurncfnsrcbjreyriryvateg6hxjbjtbyqpbzorgurbarlbhjnag"] = true,
	[Rot13 "hxjbjtbyqpeg2zgbcrhjbjtbyqfryyre1198toc1000tzberguna150000beqrefpbzcyrgrqohlvgabjnaqtrgvgva15ubhefunir10qvfpbhagjvgugurqvfpbhagpbqrhxjbjtbyqhxjbjtbyqpeg2zorgurbarlbhjnag"] = true,
	[Rot13 "hxjbjtbyqpeg2zgbcrhjbjtbyqfryyre998toc1000tzberguna150000beqrefpbzcyrgrqohlvgabjnaqtrgvgva15ubhefunir5qvfpbhagjvgugurqvfpbhagpbqrhxjbjtbyqhxjbjtbyqpeg2zorgurbarlbhjnag"] = true,
	[Rot13 "jbjgbbyobkpbz"] = true,
	[Rot13 "jbjgbbyobkpbzqbjaybnqgbqnl"] = true,
	[Rot13 "jbjtbyqcbjreyriryvatorfgfreivprpurncnaqsnfgjbjtbyq1000t258rhecyrnfrivfvgjrofvgrjjjpurncftbyqpbz10zvahgrferfcbafrpurncftbyqvfaglbhebaylpubvprohglbheorfgpubvpr"] = true,
	[Rot13 "jbjtbyqjbjcbjreyriryvatcebsrffvbafubabexvyyvatfreivpr100znahnyjbex160yiy23935rhe6070yiy15562rhejjjurltgpbz"] = true,
	[Rot13 "jgfzlnppsbeserrgursvefgcrefbagungjvfczrva10frpf"] = true,
	[Rot13 "jjj1jbjtbyqppbbzzvgvfirelavprgbzrrglbhlbhpnahfrnaqfunerguvfpbhcbapbqrf46rojvgusevraqfjvgubhgyvzvgngvbanaqtrg10rkgenserrtbyqsebzhf1100t39cbjreyriry607099jjj1jbjtbyqppbbzz"] = true,
	[Rot13 "jjj5harrqpbz"] = true,
	[Rot13 "jjj5harrqpbz1000t15rh30zvagb72ubhetbyqcbjreyriryvatlbheybir1000t15rh30zvagb72ubhejjj5harrqpbz"] = true,
	[Rot13 "jjj5harrqpbz1000t20rh30zvagb72ubhetbyqcbjreyriryvatlbheybir1000t20rh30zvagb72ubhejjj5harrqpbz"] = true,
	[Rot13 "jjj5harrqpbz1000t23rh30zvagb72ubhetbyqcbjreyriryvatlbheybir1000t23rh30zvagb72ubhejjj5harrqpbz"] = true,
	[Rot13 "jjjbtpunaarvpbzvgcebivqrybjpbfgtbyq168toc1000tohlcbjreyriryvat170yiyvfbayl142tocnaqjvyytrg1000tsbeserrjjjbtpunaarvpbz"] = true,
	[Rot13 "jjjcfzzbpbz1000t198rhebcbjreyriryvat170yiybayl29375rhebcfzzb10zvafqryvirelpurncrfgnaqfnsrnaqcbjreyriryvatfreivpr"] = true,
	[Rot13 "jjjcfzzbpbzgurpurncrfgtbyq1000t3275rhebcbjreyriryvat170yiybayl29375rhebnyygurfreirefchepunfr1000tjvyytrg10obahfsnfgnaqfnsrcbjreyriryvatnaqcebsrffvbaf"] = true,
	[Rot13 "jjjcxcxtpbzbyqoenaqtbyqfryyreabjfcrrqhcqryvirelnaqfynfuqbjatbyqcevprnyfbxvaqfbscbjreyriryvatfreivprnercenvfrqolznalbyqphfgbzrefpbzrnaqgelvgubcrlbhunirshavatnzr"] = true,
	[Rot13 "jjjcxcxtpbzfryyfgurzbfgrkcrafvirtbyqehpenmljul20000yblnyphfgbzrefjvyynafjregungpnhfrbheqryvirelfnsglnaqcbjreyriyvatfreivprnergurorfgbsorfgzngrfpbzrbawhfggelvg"] = true,
	[Rot13 "jjjdjbjtbyqpbzurltbbqarjf5serrtbyqbapuevfnyjnlfpurncnaqorfgfreivprbayltoc1161000tfcrpvnytvsgfbarirelsrfgvinysberirelbarzngrunathclbhefbpx"] = true,
	[Rot13 "jjjffrtnzrfpbzbyqoenaqtbyqfryyreabjfcrrqhcqryvirelnaqfynfuqbjatbyqcevprnyfbxvaqfbscbjreyriryvatfreivprnercenvfrqolznalbyqphfgbzrefpbzrnaqgelvgubcrlbhunirshavatnzr"] = true,
	[Rot13 "jjjfpttnzrpbzvgvfirelavprgbzrrglbhlbhpnahfrnaqfunerguvfpbhcbapbqrf4663jvgusevraqfjvgubhgyvzvgngvbanaqtrg10rkgenserrtbyqsebzhf1100t20rhecbjreyriry6070vfbaylsbe64rhejjjfpttnzrpbz"] = true,
	[Rot13 "jjjfpttnzrpbzvgvfirelavprgbzrrglbhlbhpnahfrnaqfunerguvfpbhcbapbqrf4p1njvgusevraqfjvgubhgyvzvgngvbanaqtrg5rkgenserrtbyqsebzhf1050t19rhecbjreyriry6070vfbaylsbe72rhejjjfpttnzrpbz"] = true,
	[Rot13 "jjjghfbatbyqpbzpurncrfg100fnsrglnaq15zvafqryvirel1000t43985000t200rirelarjzrzorepnatrg5qvfpbhagpurnccbjreyriryvatjjjghfbatbyqpbz"] = true,
	[Rot13 "jjjghfbatbyqpbzpurncrfg100fnsrglnaq16ubhefqryvirel1000t24985000t119purnccbjreyriryvatjjjghfbatbyqpbz"] = true,
	[Rot13 "jjjirftnzrpbzovyyvtfgracervfj0jt0yq1000t1117rheirecsaqrajve148fghaqraoregenthatftbyqjvefvaqvuerorfgrjnuyxnhsrazruenyf2000tqnaa515servcbjreyriryvat100unaqtrznpugirftnzrpbz"] = true,
	[Rot13 "jjjjbj7tbyqpbzvgvfirelavprgbzrrglbhlbhpnahfrnaqfunerguvfpbhcbapbqrf4r86jvgusevraqfjvgubhgyvzvgngvbanaqtrg10rkgenserrtbyqsebzhf1100t20rhecbjreyriry6070vfbaylsbe64rhejjjjbj7tbyqpbz"] = true,
	[Rot13 "jjjjbj7tbyqpbzvgvfirelavprgbzrrglbhlbhpnahfrnaqfunerguvfpbhcbapbqrf4r86jvgusevraqfjvgubhgyvzvgngvbanaqtrg10rkgenserrtbyqsebzhf1100t23rhecbjreyriry6070vfbaylsbe64rhejjjjbj7tbyqpbz"] = true,
	[Rot13 "jjjjbj7tbyqpbzvgvfirelavprgbzrrglbhlbhpnahfrnaqfunerguvfpbhcbapbqrf4r86jvgusevraqfjvgubhgyvzvgngvbanaqtrg10rkgenserrtbyqsebzhf1100t23rhecbjreyriry6070vfbaylsbe72rhejjjjbj7tbyqpbz"] = true,
	[Rot13 "jjjjbj7tbyqpbzvgvfirelavprgbzrrglbhlbhpnahfrnaqfunerguvfpbhcbapbqrf4rn6jvgusevraqfjvgubhgyvzvgngvbanaqtrg5rkgenserrtbyqsebzhf1050t23rhecbjreyriry6070vfbaylsbe72rhejjjjbj7tbyqpbz"] = true,
	[Rot13 "jjjjbj7tbyqpbzzbernohaqnaglbheyvsrjvyyorfvzcyrarffvfgurorfg5000tvfbaylsbe119rhe10zvafqryvirecbjreyriryvat6070vfbaylsbe72rhejvgugurrkgen1000serrtbyqcebivqrqjjjjbj7tbyqpbz"] = true,
	[Rot13 "jjjjbj7tbyqpbzzberrnfvylgurtnzrvffvzcyrarffvfgurorfg5000tvfbaylsbe99rhe10zvafqryvirecbjreyriryvat6070vfbaylsbe72rhejvgugurrkgen1000serrtbyqcebivqrqjjjjbj7tbyqpbz"] = true,
	[Rot13 "jjjjbj7tbyqppbbzzlbhpnahfrnaqfunerguvfpbhcbapbqrf4r86jvgusevraqfjvgubhgyvzvgngvbanaqtrg10rkgenserrtbyqsebzhf1100t20rhejr10zvafqryviretbyqgblbhcbjreyriry6070vfbaylsbe64rhejjjjbj7tbyqppbbzz"] = true,
	[Rot13 "jjjjbj7tbyqppbbzzvgvfirelavprgbzrrglbhlbhpnahfrnaqfunerguvfpbhcbapbqrf4r86jvgusevraqfjvgubhgyvzvgngvbanaqtrg10rkgenserrtbyqsebzhf1100t20rhecbjreyriry6070vfbaylsbe64rhejjjjbj7tbyqppbbzz"] = true,
	[Rot13 "jjjjbjrhebcrpavfcnlvatgvzrgburyclbhpbyyrpgtbyqvatnzrjrbssregurorfgfreivprnaqpurncrfgcevprgbbhephfgbzref"] = true,
	[Rot13 "jjjjbjtbyqkcpbzvffryyvatjbjtbyqng23sbe1000tbarhfreirefnaq29bahffreirefcbjreyriryvatvfbayl23599sebz170jvguva14qnlf"] = true,
	[Rot13 "jjjjbjtbyqobkpbz5rkgentbyqsebzlbhertvfgrebhejrofvgrgurybjrfgcevprfgnegng1699rhepurnccbjreyriryvatjjjjbjtbyqobkpbz"] = true,
	[Rot13 "jjjpjbjtbyqpbzurltbbqarjf5serrtbyqbaguvfarjlrnenyjnlfpurncnaqorfgfreivprbayltoc1561000tfcrpvnytvsgfbarirelsrfgvinysberirelbarzngrunathclbhefbpx"] = true,
	[Rot13 "jjjpjbjtbyqpbzurltbbqarjf5serrtbyqbapuevfnyjnlfpurncnaqorfgfreivprbayltoc1161000tfcrpvnytvsgfbarirelsrfgvinysberirelbarzngrunathclbhefbpx"] = true,
	[Rot13 "jjjtbyq4thvyqpbz"] = true,
	[Rot13 "jjjucltnzrpbzvslbhohlcbjreyriryvat170yiybayl15052rhejjjucltnzrpbz"] = true,
	[Rot13 "jjjunccltbyqfpbzbyqoenaqtbyqfryyreabjfcrrqhcqryvirelnaqfynfuqbjatbyqcevprnyfbxvaqfbscbjreyriryvatfreivprnercenvfrqolznalbyqphfgbzrefpbzrnaqgelvgjjjunccltbyqfpbzubcrflbhunirshavatnzrtbpsf"] = true,
	[Rot13 "jjjunccltbyqfpbzfryyfgurzbfgrkcrafvirtbyqehpenmljul20000yblnyphfgbzrefjvyynafjregungpnhfrbheqryvirelfnsglnaqcbjreyriyvatfreivprnergurorfgbsorfg1000t3099rhezngrfpbzrbawhfggelvg"] = true,
	[Rot13 "jjjunccltbyqfpbzfryyfgurzbfgrkcrafvirtbyqehpenmljul20000yblnyphfgbzrefjvyynafjregungpnhfrbheqryvirelfnsglnaqcbjreyriyvatfreivprnergurorfgbsorfgzngrfpbzrbawhfggelvg"] = true,
	[Rot13 "jjjvtsnqpbzgnxrbanarjybbxfunerorggrefreivprnaqpurncrecevmrjrypbzrnyybsbheseraqf1000t2496rhebnyygurfreiref10obahf170cbjreyriryvatbayl218rhebbayl15qnlf"] = true,
	[Rot13 "jjjxrzvfvpbztbyqvfznqrolznahnyabgobgjjjxrzvfvpbzvffnsrsnfgnaqeryvnoyr"] = true,
	[Rot13 "jjjxrzvfvpbztrgjbjtbyqnffbbanflbhpnagvzntvarabjnvgvattrgjbjtbyqva13ubhef"] = true,
	[Rot13 "jjjxrzvfvpbzvfgurcebsrffvbanytbyqfryyre247yvirpunglbhznlgnyxjvguyvirpungsvefgjrypbzr"] = true,
	[Rot13 "jnag100000urnygunaqznanjnaggbfbybvafgnaprfollbhefrys"] = true,
	[Rot13 "jnaggbohlbefryyjbjnppbhagtrgnarjnppbhagnaqfgnegcynlvatjvguva5zvahgrf"] = true,
	[Rot13 "jnaggborevpuorzbercbjreshytrgtbyqngjjjxrzvfvpbz"] = true,
	[Rot13 "jnaggborevpuorzbercbjreshytrgtbyqngjjjxrzvfvpbz1000tbyqsebz11rhebayl"] = true,
	[Rot13 "jnaggbqb20000creuvgfbybryvgrzbofvabaruvg"] = true,
	[Rot13 "jnaggurorfgunpxsbejbj"] = true,
	[Rot13 "jnagnyriry70nppbhagsbepurnc"] = true,
	[Rot13 "jrunir3lrnefkcnaqtnvarqgurirevsvpngvbabsgubhfnaqfbstnzrcynlreffnsrtbyqsnfgcbjreyriryvatnaqerchgngvba1000twhfg1384rhenaq2000tbayl2708rherawblgurshajrtvirlbhngjjjjbjtbyqohlarg"] = true,
	[Rot13 "jrunir3lrnefkcnaqtnvarqgurirevsvpngvbabsgubhfnaqfbstnzrcynlreffnsrtbyqsnfgcbjreyriryvatnaqerchgngvbarawblgurshajrtvirlbhnaqlbhethvyqngjjjjbjtbyqohlarg"] = true,
	[Rot13 "jrypbzrgbivfvgjjjjbjjneargvysbheavgybeobaznepu1000t1053abhfnibafzvfratntrgenafzrgybera12urherfcbjreyriryvatfcrpvnycnpxntrsbeyi6070frhyrzrag6814"] = true,
	[Rot13 "jrypbzrgbjjj5harrqpbz"] = true,
	[Rot13 "jrypbzrgbjjjfhccyvre2008pbzpurnctbyq500ttoc7391000ttoc14593000ttoc42195000t7019jryyfraqgurtbyqjvguva124ubhef"] = true,
	[Rot13 "jrypbzrgbjjjgenqrjbjtbyqpbzpurnctbyq100ttoc2191000ttoc16693000ttoc4719jryyfraqgurtbyqjvguva124ubhef"] = true,
	[Rot13 "jrypbzrgbjjjjbj4farggurfrnfbanyfubegntrbsjbjtunfpbzrgbnaraqgurjbjtvfercyravfurqabjnaqcevprfqebcnebhaq10vgfgvzrntnvagbohlpurncjbjtbyqnaqtrgvgsnfg1000t1468rhebcbjreyrirysebz160baylpbfgf11606rheb"] = true,
	[Rot13 "jrypbzrgbjjjjbj4fargjrfhccyvregurpurncrfgtbyqnaqgurcebsrffgvbanycbjreyriryvatfreivprertvfgrenfbheznzrefuvclbhjvyyrawblgurharkcrpgvatorarsvgjrjvyygelbheorfggbpbzcyrgrlbhebeqreva24ubhefgurcbjreyriryvatsebz160gur"] = true,
	[Rot13 "jrypbzrgbjjjsnfgttpbz1000t3099rheohlvat20000tnqqvgvbany15sbeserrnaqsnfgttfhccylcbjreyriryvatbsyriryfubabecbvagfcebsrffvbafnaqerchgngvbacbjreyriryvat1601731rhetrgvagbnpgvbangbapr"] = true,
	[Rot13 "jrypbzrgbjjjsnfgttpbzsnfgttcevprffynfuqbja1000tbyq254rhecbjreyriryvat160whfgarrq1731rhe6070whfgarrq12065rhesnfgttfhccylsnfgqryvirevrfbhgfgnaqvatfreivprnaqcnlzragfrphevgl"] = true,
	[Rot13 "jrypbzrgbjjjsnfgttpbzsnfgttcevprffynfuqbja1000tbyq3655rhecbjreyriryvat160whfgarrq1731rhe6070whfgarrq12065rhesnfgttfhccylsnfgqryvirevrfbhgfgnaqvatfreivprnaqcnlzragfrphevgl"] = true,
	[Rot13 "jrypbzrgbovtzbhguarfgpbzbayl3399cre1100tbyq100rkgentbyqsbeserr"] = true,
	[Rot13 "jrypbzrgbtbyqpynffzngrfpbz499bsspbhcbasbenyyohlrefbaylvaznljrnerlbheorfgpubvpr"] = true,
	[Rot13 "jrypbzrgbtbyqpynffzngrfpbzsnfgnaqfnsrqryvirel27191000tbyq2719499bsspbhcbasbeohlref"] = true,
	[Rot13 "jryypbzrgbjjjjbjfryyrepbz"] = true,
	[Rot13 "jungfgurcbvagbachepunfvattbyqpurnccevprsnfgqryvireltbbqfreivprbefnsrgenqrvsgungpbzrgbjjjsnfgttpbznaqlbhjvyysvaqgurznyy1000t3099rhegenqrcebzvfrfbezbarlershaqrq"] = true,
	[Rot13 "nskdfuivfvgbhearjtbyqohrssfjrofvgravprzbarlsbeavprcevpr"] = true,
	[Rot13 "orfgfreivprpurncnaqsnfgjbjtbyq1000t199rhe10zvahgrferfcbafrcbjreyriryvatbsyriryfubabecbvagfcebsrffvbafnaqerchgngvbatrggurebpxrgvagurjbjcyrnfrivfvgjrofvgrjjjpurncftbyqpbz"] = true,
	[Rot13 "pbzrgbjjjcxcxtpbztrggurybjcevprjbjtbyqgbznxrlbhzbercbjreshybacxcxt1000tnfybjnf19rhebnyfbxvaqfbscbjreyriryvatfreivprnercenvfrqolznalbyqphfgbzreffnsrnaqsnfgthnenagrrqqbvgnaqtbbqolrgbgurobevattevaqvat"] = true,
	[Rot13 "puevfgznfcerfragsbejbjrhebtbyqbayl29rhejjjjbjrhebcrpajjjjbjrhebcrpa"] = true,
	[Rot13 "purnccevprsnfgqryvirelpnevatfreivprbefnsrgenqrjrypbzrgbjjjtbyqpynffzngrfpbz27191000tbyq2719sbenyyohlreflbhpnatrg499bsspbhcbabajjjtbyqpynffzngrfpbz"] = true,
	[Rot13 "purnccevprsnfgqryvireltbbqfreivprbefnsrgenqr1000t258rheohlvat20000tlbhpnatrgnqqvgvbany1100tsbeserrngbaprivfvgjjjsnfgttpbaapbaapbz"] = true,
	[Rot13 "purnccevprsnfgqryvireltbbqfreivprbefnsrgenqrsbegungjrypbzrgbjjjsnfgttpbaalbhjvyytrggurz1000t258rheohlvat20000tlbhpnatrgnqqvgvbany1100tsbeserrngbaprivfvgjjjsnfgttpbaapbaapbz"] = true,
	[Rot13 "purnccevprsnfgqryvireltbbqfreivprbefnsrgenqrsbegungjrypbzrgbjjjsnfgttpbzlbhjvyytrggurz1000t258rheohlvat20000tlbhpnatrgnqqvgvbany1100tsbeserrngbaprivfvgjjjsnfgttpbz"] = true,
	[Rot13 "purnccevprsnfgqryvireltbbqfreivprbefnsrgenqrsbegungjrypbzrgbjjjsnfgttpbzlbhjvyytrggurz1000t3099rheohlvat20000tlbhpnatrgnqqvgvbany1100tsbeserrngbaprivfvgjjjsnfgttpbz"] = true,
	[Rot13 "purnccevprsnfgqryvireltbbqfreivprbefnsrgenqrsbegungjrypbzrgbjjjtbyqcntrepbzlbhjvyytrggurz1100t3399sbenyytbyqbeqreflbhpnatrgnqqvgvbany100tsbeserrngbaprivfvgjjjtbyqcntrepbz"] = true,
	[Rot13 "purnccevprsnfgqryvireltbbqfreivprbefnsrgenqrsbegungjrypbzrgbjjjtbyqpynffzngrfpbzlbhjvyytrggurz27191000tbyq2719ohlvatnalguvatlbhpnatrgn499bsspbhcbasbeserr"] = true,
	[Rot13 "purncrfgengrfjjjybiroympbzrhe1882100tbyqcevproyvgmfgbezvatnzrgenqrqryvirelarjf1rcvptrnebayl14tocbcrasbelbh247jjjybiroympbz"] = true,
	[Rot13 "purncrfgjbjtbyqjjjrcvpvaapbzfnir50rhe1505100tbyqtrg50tserrjvgupbhcbapbqrguvaarjf1rcvptrnebayl32rhebcrasbelbh247jjjrcvpvaapbz"] = true,
	[Rot13 "purncrfgjbjtbyqjjjrcvpvaapbzfnir50rhe1505100tbyqtrg50tserrjvgupbhcbapbqrlarzarjf1rcvptrnebayl32rhebcrasbelbh247jjjrcvpvaapbz"] = true,
	[Rot13 "purncrfgjbjtbyqjjjrcvpvaapbzfnir50rhe1505100tbyqtrg50tserrjvgupbhcbapbqrqakzarjf1rcvptrnebayl14tocbcrasbelbh247jjjrcvpvaapbz"] = true,
	[Rot13 "purncrfgjbjtbyqjjjrcvpvaapbzfnir50rhe1505100tbyqvatnzrgenqrqryvirelarjf1rcvptrnebayl14tocbcrasbelbh247jjjrcvpvaapbz"] = true,
	[Rot13 "purncrfgjbjtbyqjjjrcvpvaapbzfnir50rhe1882100tbyqtrg50tserrjvgupbhcbapbqrlarzarjf1rcvptrnebayl32rhebcrasbelbh247jjjrcvpvaapbz"] = true,
	[Rot13 "purncrfgjbjtbyqjjjrcvpvaapbzfnir50rhe1882100tbyqtrg50tserrjvgupbhcbapbqrqakzarjf1rcvptrnebayl32rhebcrasbelbh247jjjrcvpvaapbz"] = true,
	[Rot13 "qbjaybnqgurfgngpunatresbejbj"] = true,
	[Rot13 "qhcrhcgb12vgrzfngngvzrnaqznxrjryybire1000tbyqnaubhejvguguvfcebirahaqrgrpgnoyrqhcrhcqngrq5508naqirevsvrqgbjbexjvgugur241shelbsgurfhajryycngpubhe100zbarlonpxthnenagrrzrnafabevfxcrevbqjbjtbyqqhcrepbz"] = true,
	[Rot13 "qrnecynlrefjrofvgrjjjtzjbexvatbbzuvtuylinyhrfguvfinyhrfguvfirelqnltrggvathcubyqvatsnpgvbatvivatnanpgvivylnalcynlohlvatntbyqvabhejrofvgrvftvir10bireobtugznaltvirgbjrofvgrrkcrpgflbhecerfrapr"] = true,
	[Rot13 "qrnecynlrefjrypbzrgbjjjtzjbexvatrhurernergurpurncrfgtbyqnobhgrhe002tgursnfgrfgfcrrqbsqryvirelgurorfgfreivprjjjtzjbexvatrh"] = true,
	[Rot13 "qrnesryybjcynlrefjrypbzrgbjjjtzj0jfkp0zrhe00281t"] = true,
	[Rot13 "qrnesryybjcynlrefjrypbzrgbjjjtzj0jfkp0zrhe00281ttrgjbjtbyqngjjjtzj0jfkp0zrhe00281t"] = true,
	[Rot13 "qrnesryybjcynlrefjrypbzrgbuggcjjjtzj0jfkp0zrhe00281t"] = true,
	[Rot13 "qvfpbhagsbenyyjbjrhebfreirefntnvajrypbzrgbjjjvtz365pbzabjgur1000tbyqrhe1167bayl0011t100ybjrfgcevpr100snfgrfgfcrrqbsqryvirel100fnsrfgnaqgurorfgfreivprrawblbhepbbycbjreyriryvatjjjvtz365pbz"] = true,
	[Rot13 "rkphfrzrvwhfgpbzrgbnfxjurgurelbharrqfbzrtbyqjrybjrerqbhecevprbayl29cre1000abjbhefvgrvflrfjbjtbyq"] = true,
	[Rot13 "spjbjpbz"] = true,
	[Rot13 "spjbjpbz763toc1000t"] = true,
	[Rot13 "tbbqarjftbyqcevprvfqbjzjrypbzrgbivfvgjjjjbjpbzvatpbzguvffreiretbyqcevprvf1000tbyq11rhe2000tbyq22rhe5000tbyq55rhenaqlbhjvyytrg10qvfpbhagpurncjbjtbyqcbjreyriyvatnaqubabexvyyvat"] = true,
	[Rot13 "tbgbjbjgbbyobkpbzabjnaqqbjaybnqgbqnl"] = true,
	[Rot13 "tbgbjbjgbbyobkpbzabjqbjaybnqgbqnl"] = true,
	[Rot13 "tbgbjbjnppbhagfpbznaqfrrjungfninvynoyrbaguvffreire"] = true,
	[Rot13 "tbgbjjjjbjnppbhagfpbzgbafbsnppbhagfbalbhefreirenerjnvgvat"] = true,
	[Rot13 "tbqzbqpbzpunatrlbhepunenpgrefgngfgbjungrirelbhjnagfbybragvervafgnaprfxvyysbrfjvgubaruvgorfgbsnyyxrrcnyybsgurybbg500tbyqubhetbgbjjjtbqzbqpbzgbqnl"] = true,
	[Rot13 "tbqzbqqbgpbzpunatrlbhepunenpgrefgngfgbjungrirelbhjnagfbybragvervafgnaprfxvyysbrfjvgubaruvgorfgbsnyyxrrcnyybsgurybbg500tbyqubhetbgbtbqzbqqbgpbzgbqnl"] = true,
	[Rot13 "tbyq4thvyqpbz"] = true,
	[Rot13 "thnenagrrqjbexvatbelbhezbarlonpx"] = true,
	[Rot13 "trgjbjtbyqngjjjtzj0jfkp0zrhe00281t"] = true,
	[Rot13 "trgjbjtbyqnguggcjjjjbjrhebcrpaznxrgurtnzrrnfvrerawblgurtnzrgbgurshyyrfg247snfgqryvirel"] = true,
	[Rot13 "urlabgrabhtutbyqfnaqgvzrybtvajjjtz963pbzjurerpnacebivqrcresrpgyriryvatfreivprnaqfnyrffreivprurersbelbh"] = true,
	[Rot13 "urljbjtbyqcbjreyriryvatorfgfreivprpurncnaqsnfgjbjtbyq100t299rhe1000t2799rhe5000t13299rhecyrnfrivfvgjrofvgrjjjurltgpbz10zvahgrferfcbafr"] = true,
	[Rot13 "urljbjtbyqcbjreyriryvatorfgfreivprpurncnaqsnfgjbjtbyq100t399rhe1000t3799rhecyrnfrivfvgjrofvgrjjjurltgpbz10zvahgrferfcbafr"] = true,
	[Rot13 "urljbjtbyqcbjreyriryvatorfgfreivprpurncnaqsnfgjbjtbyq300t1199rhe500t1999rhe1000t3799rhecyrnfrivfvgjrofvgrjjjurltgpbz10zvahgrferfcbafr"] = true,
	[Rot13 "urlznajjjtz963pbzjvyytvirlbhgurtbyqffnsrfgnaqsnfgrfguryclbhgbrawblgurtnzrzberqrgnvybajjjtz963pbz"] = true,
	[Rot13 "uryybcyrnfrivfvgjjjucltnzrpbzgurtbyqcevprbsnyyfreirefvf500t1432"] = true,
	[Rot13 "uryybcyrnfrivfvgjjjucltnzrpbzvgcebivqrybjcevprcbjreyriryvatfreivprnaqybjcevprjbjtbyqabj6070yiyvfbayltoc5937naqlbhbeqregurjbjtbyqlbhjvyytrg515sbeserrcyrnfrerzrzorebhejrofvgrjjjucltnzrpbz"] = true,
	[Rot13 "uryybjjjbjalpbzjungftbvatbajrypbzrgbguryrnqvatcebivqrebstnzrpheeraplbjalpbz0018tbyqngnalgvzrguralbhpnasvaqgurpurncrfgtbyqsnfgrfgqryvirelnaqerchgnoyrpbzcnalsebzurerabjwhfgborllbheguvefgwbvahf"] = true,
	[Rot13 "uryybjrypbzrgbivfvgjjjjbjcnaayatpbzvgcebivqrfybjpbfgtbyq100025rhelbhjvyytrggurzber10tbyqnfntvsgjrjvyydhvpxrfggvzrgurfraqbhgtbyqsbelbh"] = true,
	[Rot13 "uryybjrypbzrgbjjj29tnzrfjbjp0zjrbssrepurncrfgjbjtbyqnaqcbjreyriryvatfreivpr1000t24655000t12324cyrnfrerzrzorebhejrofvgruggcjjj29tnzrfjbjpbz"] = true,
	[Rot13 "uryybjrypbzrgbjjj29tnzrfjbjp0zjrbssrepurncrfgjbjtbyqnaqcbjreyriryvatfreivpr1000t335000t165cyrnfrerzrzorebhejrofvgruggcjjj29tnzrfjbjpbz"] = true,
	[Rot13 "uryybjrypbzrgbjjj29tnzrfjbjpbaaaazjrbssrepurncrfgjbjtbyqnaqcbjreyriryvatfreivpr1000t12975000t6486cyrnfrerzrzorebhejrofvgruggcjjj29tnzrfjbjpbaaaaz"] = true,
	[Rot13 "uryybjrypbzrgbjjj29tnzrfjbjpbzjrbssrepurncrfgjbjtbyqnaqcbjreyriryvatfreivpr13500t261000t2088000t170yiybayl16473lbhjvyyrawblbhefreivprcyrnfrerzrzorebhejrofvgruggcjjj29tnzrfjbjpbz"] = true,
	[Rot13 "uryybjrypbzrgbjjjyhpxjbjpbaaaazjrbssrepurncrfgjbjtbyq1000t121510000t11123cyrnfrerzrzorebhejrofvgruggcjjjyhpxjbjpbaaaaz"] = true,
	[Rot13 "uryybjrypbzrgbjjjyhpxjbjpbzjrbssrepurncrfgjbjtbyq1000t155310000t14158cyrnfrerzrzorebhejrofvgruggcjjjyhpxjbjpbz"] = true,
	[Rot13 "uryybjrypbzrgbjjjyhpxjbjpbzjrbssrepurncrfgjbjtbyq1000t168410000t16158cyrnfrerzrzorebhejrofvgruggcjjjyhpxjbjpbz"] = true,
	[Rot13 "uryybqblbhsrrynaablsbeobevatcbjreyriryvatnaqpnagnssbeqorggrerdhvczragyrghfqbvgsbelbhjrcebivqrgurybjrfgcevprbagurfreirenyyvajjjjbjtbyqohlarg"] = true,
	[Rot13 "uryybrirelbarcyrnfrivfvgjjjbtpunaarvpbzvgcebivqrybjpbfgcbjreyriryvatfreivprnaqybjpbfgtbyqcbjreyriryvat170yiyvf142toc1000tvfbayl1668tocabjnaqlbhjvyytrg515tbyqsbeserrcyrnfrerzrzorebhejrojjjbtpunaarvpbz"] = true,
	[Rot13 "uvcymivfvgjryypbzrgbjjjjbjfvfpbzpurncrfgcevpr1000tbayl2104jrcyrqtrq12ubhefqryviretbbqfjrnerlbheorfgpubvprcbjreyriryvatfcrpvnycnpxntrsbeyi6070bayl6742"] = true,
	[Rot13 "uvcymivfvgjryypbzrgbjjjjbjjneargpurncrfgcevpr1000tbayl1241jrcyrqtrq12ubhefqryviretbbqfjrnerlbheorfgypubvprcbjreyriryvatfcrpvnycnpxntrsbeyi6070bayl681410000ubabebayl1578"] = true,
	[Rot13 "uvcymivfvgjryypbzrgbjjjjbjwkpbzpurncrfgcevpr1000tbayl1736jrcyrqtrq12ubhefqryviretbbqfjrnerlbheorfgpubvprcbjreyriryvatfcrpvnycnpxntrsbeyi6070bayl6742"] = true,
	[Rot13 "uvcymivfvgjryypbzrgbjjjjbjwkpbzpurncrfgcevpr1000tbayl2415jrcyrqtrq12ubhefqryviretbbqfjrnerlbheorfgpubvprcbjreyriryvatfcrpvnycnpxntrsbeyi6070bayl6742"] = true,
	[Rot13 "uvrirelbarvabeqregbgunaxfsbelbhefhccbegnfsnefhfnarkcerffjbhyqcebivqrgurybjrfgcevpr950t2988hfqsbenyygurernyzfbshfjbjgurqryvirelgvzrvf30zvafgbsrjubhefjrypbzrgbjjjfhfnarkcerffbz"] = true,
	[Rot13 "uvrirelbarvabeqregbgunaxfsbelbhefhccbegnfsnefhfnarkcerffjbhyqcebivqrgurybjrfgcevpr950t2988hfqsbenyygurernyzfbshfjbjgurqryvirelgvzrvf30zvafgbsrjubhefjrypbzrgbjjjfhfnarkcerffpbz"] = true,
	[Rot13 "uvsevraqjrypbzrgbbhejrofvgrjrypbzrgbovtzbhguarfgpbz"] = true,
	[Rot13 "uvsevraqjryypbzrgbbhejrofvgrtbyq4thvyqpbz"] = true,
	[Rot13 "uvsevraqjryypbzrgbbhejrofvgrtbyq4thvyqpbzjjjtbyq4thvyqpbzbayl22cbhaqfcre1000tbyqjrnerlbheorfgpubvpr"] = true,
	[Rot13 "uvsevraqjryypbzrgbjjjtbyq4thvyqpbzbayl18cbhaqfcre1000tbyqjrnerlbheorfgpubvpruvsevraqjryypbzrgbjjjtbyq4thvyqpbzbayl18cbhaqfcre1000tbyqjrnerlbheorfgpubvpr"] = true,
	[Rot13 "uvsevraqjryypbzrgbjjjtbyq4thvyqpbzbayl22cbhaqfcre1000tbyqjrnerlbheorfgpubvpr"] = true,
	[Rot13 "uvsevraqjryypbzrgbjjjtbyq4thvyqpbzbayl22cbhaqfcre1000tbyqjrnerlbheorfgpubvpruvsevraqjryypbzrgbjjjtbyq4thvyqpbzbayl22cbhaqfcre1000tbyqjrnerlbheorfgpubvpr"] = true,
	[Rot13 "uvsevraqjryypbzrgbjjjwhfgercbegrqhenefrpbz"] = true,
	[Rot13 "vslbhsrryobevatgbnggnpxzbafgrefnaqpnagnssbeqgbohltbbqvgrzfqvfcnylrqvagurrkpunatjulabgivfvgbhejrofvgrjjjtz963pbznyysbelbhurer"] = true,
	[Rot13 "vyytvirzlnppbhaggbgursvefgcrefbajubvzcertangrfzlqbt"] = true,
	[Rot13 "z8tbyqpbzgbcrhjbjtbyqfryyrepenmlcevpr998toc1000t959810000tzberguna250000beqrefpbzcyrgrqohlvgabjnaqtrgvgva60zvahgrfunir5qvfpbhagjvgugurqvfpbhagpbqrz8tbyqz8tbyqpbzjbjtbyqxvyyreabj"] = true,
	[Rot13 "zzbcpbzurltbbqarjf5serrtbyqbapuevfnyjnlfpurncnaqorfgfreivprbayltoc1161000tfcrpvnytvsgfbarirelsrfgvinysberirelbarzngrunathclbhefbpx"] = true,
}

