
local CanComplainChat = CanComplainChat
local ComplainChat    = ComplainChat
-------------------------------------------------------------------------------
local MessageList     = Relegation.MessageList

local reported = { }

--[[
	Arguments:
		<string> author
		<string> message
	Return:
		<boolean> evil
		<boolean> complained
]]
function Relegation.CheckMessage(author, message)
	if reported[author] then
		return true, false
	elseif CanComplainChat(author, message) then
		local checksum = message:gsub("[^a-zA-Z0-9]", ""):lower()
		
		if MessageList[checksum] then
			reported[author] = true
			
			ComplainChat(author, message)
			
			return true, true
		end
	end
	
	return false, false
end

