function RedRange_ActionButton_OnUpdate(elapsed)
    local self = this;
    local t = self.rangeTimer;
    if (not t) then
        return;
    end
    if ((t == TOOLTIP_UPDATE_TIME) or (t <= 0)) then
        local newRange = false;
        local id = ActionButton_GetPagedID(self);
        if ( ActionHasRange(id) and (IsActionInRange( id ) == 0)) then
            newRange = true;
        end
        if ( self.redRangeFlag ~= newRange ) then
            self.redRangeFlag = newRange;
            ActionButton_UpdateUsable();
        end
    end
end

function RedRange_ActionButton_UpdateUsable()
    local self = this;
    local id = ActionButton_GetPagedID(self);
    local isUsable, notEnoughMana = IsUsableAction(id)
    if (isUsable) then
        if (ActionHasRange(id) and IsActionInRange(id) == 0) then
            local name = self:GetName();
            local icon = getglobal(name.."Icon");
            local normalTexture = getglobal(name.."NormalTexture");

            icon:SetVertexColor(0.8, 0.1, 0.1);
            normalTexture:SetVertexColor(0.8, 0.1, 0.1);
            return;
        end
    elseif (notEnoughMana) then
        local name = self:GetName();
        local icon = getglobal(name.."Icon");
        local normalTexture = getglobal(name.."NormalTexture");

        icon:SetVertexColor(0.1, 0.3, 1.0);
        normalTexture:SetVertexColor(0.1, 0.3, 1.0);
        return;
    end
end

hooksecurefunc("ActionButton_OnUpdate",
               RedRange_ActionButton_OnUpdate);
hooksecurefunc("ActionButton_UpdateUsable",
               RedRange_ActionButton_UpdateUsable);
