--[[
  Name: Recount Threat Module
  Heavily based on: Artiarc's SingleTarget.lua of Omen2
  Author: Antiarc (original), Elsia (modified plagirism)
  License: Don't use unless you asked Antiarc and bribed him with 1-2 headless chickens, or in other words the same license as Omen2/Threat-2.0
]]

if not Recount then return end --  Forget about this if no Recount is present

local Recount = Recount

local RecountThreat = LibStub("AceAddon-3.0"):NewAddon("RecountThreat", "AceEvent-3.0", "AceTimer-3.0","AceConsole-3.0")

local Threat = LibStub("Threat-2.0")
local timers = {}
local math_abs = _G.math.abs
local RL = LibStub("AceLocale-3.0"):GetLocale("Recount")
--local L = LibStub("AceLocale-3.0"):GetLocale("RecountThreat")
local GetTime = _G.GetTime
local UnitExists = _G.UnitExists
local UnitIsPlayer = _G.UnitIsPlayer
local UnitPlayerControlled = _G.UnitPlayerControlled
local math_floor = _G.math.floor
local lastTargetSwitchTime = 0

RecountThreat.Version = tonumber(string.sub("$Revision: 19 $", 12, -3))

-- threat and GUID upvalues
local aggroThreat, aggroUnit, aggroGUID = 0, nil, "targettarget", nil
local hostileGUID, hostileUnit = nil, "target"
local threatUpdatedAt = 0

-- global OnInit function, only called once during addon loading
function RecountThreat:OnInitialize()
end

-- global OnEnable, called everytime the user switches to the Threat Module
function RecountThreat:OnEnable()

	if not Recount then return end -- No recount found

	-- register callbacks and events
	Threat.RegisterCallback(self, "ThreatUpdated")
	self:RegisterEvent("PLAYER_TARGET_CHANGED")
	self:RegisterEvent("UNIT_TARGET")
	
	-- fill upvalues with meaningful data
	threatUpdatedAt = 0

	Recount.ThreatTargetName = "GLOBAL"

	self:PLAYER_TARGET_CHANGED()
end

-- global OnDisable
-- unregisters all events and timers in the embeds automatically
function RecountThreat:OnDisable()
	-- unregister Threat callbacks
	Threat.UnregisterCallback(self, "ThreatUpdated")
	
	-- clear timer references so we end up in a clean state
	for k in pairs(timers) do
		timers[k] = nil
	end
end

function RecountThreat:ThreatUpdated(event, srcGUID, dstGUID, threat)

	if not hostileUnit then return end

	-- we only care about valid data for our current hostile target
	if (hostileGUID and dstGUID == hostileGUID) then
		-- grab aggroThreat
		Recount.NewData = true

		aggroThreat = aggroGUID and ((srcGUID == aggroGUID) and threat or Threat:GetThreat(aggroGUID, dstGUID)) or Threat:GetMaxThreatOnTarget(dstGUID) or 1
		
		--pet,owner = Recount:DetectPet(Threat.GUIDNameLookup[srcGUID], srcGUID, nFlags)
		-- This doesn't currently support pets due to the combatant name structure for pets (i.e. need owner)
		if Recount.db2.combatants and Recount.db2.combatants[Threat.GUIDNameLookup[srcGUID] ] then
			Recount.db2.combatants[Threat.GUIDNameLookup[srcGUID] ].Threat = threat
--[[			if threat~= 0 then
				Recount.db2.combatants[ThreatLib.GUIDNameLookup[srcGUID] ].ThreatNonZero = threat
			end]]
		end
	end
end

local function isValidThreatTarget(unit)
	if not UnitExists(unit) or UnitIsPlayer(unit) or UnitPlayerControlled(unit) then
		return false 
	end
	return true
end

function RecountThreat:TargetTargetCheck()
	if not timers.TargetSwitch and UnitGUID(aggroUnit) ~= aggroGUID then
		self:UNIT_TARGET(nil, "target")
	end
end

function RecountThreat:PLAYER_TARGET_CHANGED()
	-- clear upvalues
	hostileGUID = nil
	hostileUnit = nil
	aggroGUID = nil
	aggroThreat = nil

	Recount.NewData = true
	
	-- stop our whacky unit timer
	if timers.TargetTargetCheck then
		self:CancelTimer(timers.TargetTargetCheck, true)
		timers.TargetTargetCheck = nil
	end
	
	-- now check which target to track - first directly "target" 
	if isValidThreatTarget("target") then
		hostileUnit = "target"
		aggroUnit = "targettarget"
	-- or for healers "targettarget"
	elseif isValidThreatTarget("targettarget") then
		hostileUnit = "targettarget"
		aggroUnit = "targettargettarget"
		-- this is a whacky update because we dont get events when our mob changes its target
		timers.TargetTargetCheck = self:ScheduleRepeatingTimer("TargetTargetCheck", 0.5)
	end
	
	-- if we didnt find a valid threat target, then just skip everything
	if not hostileUnit then
		return
	end
	
	-- get the GUIDs of our stuff
	hostileGUID = UnitGUID(hostileUnit) 
	aggroGUID = UnitGUID(aggroUnit)
	
	-- get the threat of our new target
	aggroThreat = Threat:GetThreat(aggroGUID, hostileGUID) or 1

	-- SetTitle here if needed
	Recount.ThreatTargetName= UnitName(hostileUnit)
	
	self:UNIT_TARGET(nil, "target")
end

function RecountThreat:SwitchAggroTarget()
	local n = UnitName(aggroUnit)
	if n then
		aggroGUID = UnitGUID(aggroUnit)
		lastTargetSwitchTime = GetTime()
	end
	timers.TargetSwitch = nil
end

function RecountThreat:UNIT_TARGET(event, unit)
	-- we only care for data about our current target
	if unit ~= "target" then return end

	Recount.NewData = true
	
	-- logic for targettarget mode
	-- we target another player that didnt have a valid target before, now he switches target 
	if (not hostileUnit and isValidThreatTarget("targettarget")) or (hostileUnit == "targettarget" and hostileGUID ~= UnitGUID(hostileUnit)) then
		self:PLAYER_TARGET_CHANGED()
		return
	end
	if not hostileUnit then return end
	
	-- stop targetswitch timer
	if timers.TargetSwitch then
		self:CancelTimer(timers.TargetSwitch, true)
		timers.TargetSwitch = nil
	end
	-- and start a new timer (only if the target is not casting some spell)
	if not UnitCastingInfo(hostileUnit) or not aggroGUID then
		timers.TargetSwitch = self:ScheduleTimer("SwitchAggroTarget", 0.5)
	end
end

-- Threat Mode stuff

function RecountThreat:DataModesThreat(data)
	
	local tps = data.GUID and hostileGUID and Threat:GetTPS(data.GUID, hostileGUID) or 0
--	local threat = data.GUID and hostileGUID and Threat:GetThreat(data.GUID, hostileGUID) or 0
	local threat = data and data.Threat or 0

	return threat, tps

--	if Recount.InCombat then
--		return (data.Fights[Recount.CurDataSet].Threat or 0), tps
--	end

--	return (data.Fights[Recount.CurDataSet].ThreatNonZero or 0), tps
end

function RecountThreat:SpecialTotalsThreat()
--	if Recount.ThreatActive then
	return aggroThreat or 0 -- threat:GetMaxThreatOnTarget(Recount.ThreatTargetGUID)
--	end
--	return 1
end

function RecountThreat:TooltipFuncsThreat(name,data)
	GameTooltip:ClearLines()
	GameTooltip:AddLine(name)
end

Recount:AddModeTooltip(RL["Threat"],RecountThreat.DataModesThreat,RecountThreat.TooltipFuncsThreat,RecountThreat.SpecialTotalsThreat,{"THREAT",RL["'s TPS"]}, function() return RL["Threat on"].." "..Recount.ThreatTargetName end, "Threat")
--tinsert(MainWindowModes,{RL["Threat"],DataMode.Threat,TooltipFuncs.Threat,SpecialTotals.Threat,{"THREAT",RL["'s TPS"]}, function() return RL["Threat on"].." "..Recount.ThreatTargetName end, "Threat"})
