﻿
-- Localization.lua: localization strings and code
-- Auto generated on 4/7/2008 11:41:52 PM

RecipeRadar_Strings = { }

-- String translation function.  Looks up the given string in the string
-- table and returns the result, or the original string if no result is
-- found.  This means that localizations needn't account for every string -
-- the missing strings will just match the hardcoded defaults.
function RRS(s)

   if (RecipeRadar_Strings[s] and RecipeRadar_Strings[s] ~= "") then
      return RecipeRadar_Strings[s]
   end
   return s

end

-- This is a sample locale that includes null translations of all strings
-- used by the addon.  Real translations will contain a subset of these
-- with, of course, mappings to actual strings in other languages.  This
-- section is purely for the benefit of translators and doesn't affect the
-- operation of the addon in any way (note the behavior of RRS(), above).
if (GetLocale() == "sample") then

   -- the name of the addon!
   RecipeRadar_Strings["Recipe Radar"] = ""

   -- these show up in the game's Key Bindings screen
   RecipeRadar_Strings["Recipe Radar Bindings"] = ""
   RecipeRadar_Strings["Toggle Recipe Radar"] = ""

   -- options button and corresponding options frame
   RecipeRadar_Strings["Options"] = ""
   RecipeRadar_Strings["Auto-map Contributive Vendors"] = ""
   RecipeRadar_Strings["Auto-select Current Region"] = ""
   RecipeRadar_Strings["Check Availability for Alts"] = ""
   RecipeRadar_Strings["Minimap Button Position"] = ""
   RecipeRadar_Strings["Show Minimap Button"] = ""

   -- format strings used in the map tooltips
   RecipeRadar_Strings["1 recipe"] = ""
   RecipeRadar_Strings["%d learnable"] = ""
   RecipeRadar_Strings["%d recipes"] = ""

   -- this appears when the recipe is not in your local database
   RecipeRadar_Strings["Uncached Recipe"] = ""

   -- uncached recipe tooltip - see RecipeRadar_Availability_CreateTooltip()
   RecipeRadar_Strings["You may mouse over the [?]"] = ""
   RecipeRadar_Strings["icon to lookup this recipe."] = ""
   RecipeRadar_Strings["Warning: if your server has"] = ""
   RecipeRadar_Strings["not yet seen this item, you"] = ""
   RecipeRadar_Strings["will be disconnected!"] = ""

   -- some regions don't have any recipes for sale
   RecipeRadar_Strings["No recipes for sale in this region."] = ""

   -- radio button (and tooltip) that indicates a mapped vendor
   RecipeRadar_Strings["Locate Vendor on Map"] = ""
   RecipeRadar_Strings["Shift-click a vendor to add or remove her location on the world map."] = ""

   -- strings in the faction filtering dropdown; we don't need 'Horde' or 'Alliance' because Blizzard provides them for us
   RecipeRadar_Strings["Factions"] = ""
   RecipeRadar_Strings["Neutral"] = ""

   -- profession filtering dropdown - these strings must match those returned by GetTradeSkillLine() and GetCraftDisplaySkillLine()
   RecipeRadar_Strings["Professions"] = ""
   RecipeRadar_Strings["Alchemy"] = ""
   RecipeRadar_Strings["Blacksmithing"] = ""
   RecipeRadar_Strings["Cooking"] = ""
   RecipeRadar_Strings["Enchanting"] = ""
   RecipeRadar_Strings["Engineering"] = ""
   RecipeRadar_Strings["First Aid"] = ""
   RecipeRadar_Strings["Fishing"] = ""
   RecipeRadar_Strings["Jewelcrafting"] = ""
   RecipeRadar_Strings["Leatherworking"] = ""
   RecipeRadar_Strings["Tailoring"] = ""

   -- strings in the availability filtering dropdown
   RecipeRadar_Strings["Availability"] = ""
   RecipeRadar_Strings["Already Known (Alts)"] = ""
   RecipeRadar_Strings["Already Known (Player)"] = ""
   RecipeRadar_Strings["Available Now (Alts)"] = ""
   RecipeRadar_Strings["Available Now (Player)"] = ""
   RecipeRadar_Strings["Future Prospect (Alts)"] = ""
   RecipeRadar_Strings["Future Prospect (Player)"] = ""
   RecipeRadar_Strings["Inapplicable"] = ""

   -- headings for the availability tooltip
   RecipeRadar_Strings["Available For:"] = ""
   RecipeRadar_Strings["Already Known By:"] = ""
   RecipeRadar_Strings["Future Prospect For:"] = ""

   -- format string for rank indicator for future prospects; that is, it tells you how soon you can learn the recipe - eg. "163 of 175"
   RecipeRadar_Strings["%d of %d"] = ""

   -- special notes for vendor requirements follow vendor names (eg. "Seasonal Vendor")
   RecipeRadar_Strings["%s Vendor"] = ""
   RecipeRadar_Strings["Intermittent"] = ""
   RecipeRadar_Strings["Quest"] = ""
   RecipeRadar_Strings["Roving"] = ""
   RecipeRadar_Strings["Seasonal"] = ""

   -- faction names for recipe reputation requirements
   RecipeRadar_Strings["Argent Dawn"] = ""
   RecipeRadar_Strings["Ashtongue Deathsworn"] = ""
   RecipeRadar_Strings["Cenarion Circle"] = ""
   RecipeRadar_Strings["Cenarion Expedition"] = ""
   RecipeRadar_Strings["Honor Hold"] = ""
   RecipeRadar_Strings["Keepers of Time"] = ""
   RecipeRadar_Strings["Kurenai"] = ""
   RecipeRadar_Strings["Lower City"] = ""
   RecipeRadar_Strings["Netherwing"] = ""
   RecipeRadar_Strings["Sporeggar"] = ""
   RecipeRadar_Strings["The Aldor"] = ""
   RecipeRadar_Strings["The Consortium"] = ""
   RecipeRadar_Strings["The Mag'har"] = ""
   RecipeRadar_Strings["The Scale of the Sands"] = ""
   RecipeRadar_Strings["The Scryers"] = ""
   RecipeRadar_Strings["The Sha'tar"] = ""
   RecipeRadar_Strings["The Violet Eye"] = ""
   RecipeRadar_Strings["Thorium Brotherhood"] = ""
   RecipeRadar_Strings["Thrallmar"] = ""
   RecipeRadar_Strings["Timbermaw Hold"] = ""
   RecipeRadar_Strings["Zandalar Tribe"] = ""
   RecipeRadar_Strings["Shattered Sun Offensive"] = ""

   -- other recipe requirements
   RecipeRadar_Strings["%s Only"] = ""
   RecipeRadar_Strings["Rogue"] = ""
   RecipeRadar_Strings["Special"] = ""

   -- menu item in the right-click context menu for mapped vendor buttons
   RecipeRadar_Strings["Unmap Vendor"] = ""
   RecipeRadar_Strings["Collapse"] = ""
   RecipeRadar_Strings["Collapse All"] = ""
   RecipeRadar_Strings["Expand"] = ""
   RecipeRadar_Strings["Expand All"] = ""
   RecipeRadar_Strings["Map Vendor"] = ""

   -- trade skill specialties
   RecipeRadar_Strings["Gnomish Engineer"] = ""
   RecipeRadar_Strings["Armorsmith"] = ""
   RecipeRadar_Strings["Dragonscale Leatherworking"] = ""
   RecipeRadar_Strings["Elemental Leatherworking"] = ""
   RecipeRadar_Strings["Goblin Engineer"] = ""
   RecipeRadar_Strings["Master Axesmith"] = ""
   RecipeRadar_Strings["Master Hammersmith"] = ""
   RecipeRadar_Strings["Master Swordsmith"] = ""
   RecipeRadar_Strings["Mooncloth Tailoring"] = ""
   RecipeRadar_Strings["Shadoweave Tailoring"] = ""
   RecipeRadar_Strings["Spellfire Tailoring"] = ""
   RecipeRadar_Strings["Tribal Leatherworking"] = ""
   RecipeRadar_Strings["Weaponsmith"] = ""

   -- continent names for alternate region selection
   RecipeRadar_Strings["Kalimdor"] = ""
   RecipeRadar_Strings["Eastern Kingdoms"] = ""
   RecipeRadar_Strings["Instances"] = ""

   -- these are the location names returned by GetRealZoneText()
   -- feel free to add regions not present in this list, too, of course
   RecipeRadar_Strings["Alterac Mountains"] = ""
   RecipeRadar_Strings["Arathi Highlands"] = ""
   RecipeRadar_Strings["Ashenvale"] = ""
   RecipeRadar_Strings["Azshara"] = ""
   RecipeRadar_Strings["Azuremyst Isle"] = ""
   RecipeRadar_Strings["Badlands"] = ""
   RecipeRadar_Strings["Black Temple"] = ""
   RecipeRadar_Strings["Blackrock Depths"] = ""
   RecipeRadar_Strings["Blade's Edge Mountains"] = ""
   RecipeRadar_Strings["Blasted Lands"] = ""
   RecipeRadar_Strings["Bloodmyst Isle"] = ""
   RecipeRadar_Strings["Burning Steppes"] = ""
   RecipeRadar_Strings["Darkshore"] = ""
   RecipeRadar_Strings["Darnassus"] = ""
   RecipeRadar_Strings["Deadwind Pass"] = ""
   RecipeRadar_Strings["Desolace"] = ""
   RecipeRadar_Strings["Dire Maul"] = ""
   RecipeRadar_Strings["Dun Morogh"] = ""
   RecipeRadar_Strings["Durotar"] = ""
   RecipeRadar_Strings["Duskwood"] = ""
   RecipeRadar_Strings["Dustwallow Marsh"] = ""
   RecipeRadar_Strings["Eastern Plaguelands"] = ""
   RecipeRadar_Strings["Elwynn Forest"] = ""
   RecipeRadar_Strings["Eversong Woods"] = ""
   RecipeRadar_Strings["Felwood"] = ""
   RecipeRadar_Strings["Feralas"] = ""
   RecipeRadar_Strings["Ghostlands"] = ""
   RecipeRadar_Strings["Gnomeregan"] = ""
   RecipeRadar_Strings["Hellfire Peninsula"] = ""
   RecipeRadar_Strings["Hillsbrad Foothills"] = ""
   RecipeRadar_Strings["Hyjal Summit"] = ""
   RecipeRadar_Strings["Ironforge"] = ""
   RecipeRadar_Strings["Isle of Quel'Danas"] = ""
   RecipeRadar_Strings["Karazhan"] = ""
   RecipeRadar_Strings["Loch Modan"] = ""
   RecipeRadar_Strings["Moonglade"] = ""
   RecipeRadar_Strings["Mulgore"] = ""
   RecipeRadar_Strings["Nagrand"] = ""
   RecipeRadar_Strings["Naxxramas"] = ""
   RecipeRadar_Strings["Netherstorm"] = ""
   RecipeRadar_Strings["Old Hillsbrad Foothills"] = ""
   RecipeRadar_Strings["Orgrimmar"] = ""
   RecipeRadar_Strings["Redridge Mountains"] = ""
   RecipeRadar_Strings["Ruins of Ahn'Qiraj"] = ""
   RecipeRadar_Strings["Searing Gorge"] = ""
   RecipeRadar_Strings["Shadowmoon Valley"] = ""
   RecipeRadar_Strings["Shattrath City"] = ""
   RecipeRadar_Strings["Silithus"] = ""
   RecipeRadar_Strings["Silvermoon City"] = ""
   RecipeRadar_Strings["Silverpine Forest"] = ""
   RecipeRadar_Strings["Stonetalon Mountains"] = ""
   RecipeRadar_Strings["Stormwind City"] = ""
   RecipeRadar_Strings["Stranglethorn Vale"] = ""
   RecipeRadar_Strings["Swamp of Sorrows"] = ""
   RecipeRadar_Strings["Tanaris"] = ""
   RecipeRadar_Strings["Teldrassil"] = ""
   RecipeRadar_Strings["Terokkar Forest"] = ""
   RecipeRadar_Strings["The Barrens"] = ""
   RecipeRadar_Strings["The Exodar"] = ""
   RecipeRadar_Strings["The Hinterlands"] = ""
   RecipeRadar_Strings["Thousand Needles"] = ""
   RecipeRadar_Strings["Thunder Bluff"] = ""
   RecipeRadar_Strings["Tirisfal Glades"] = ""
   RecipeRadar_Strings["Undercity"] = ""
   RecipeRadar_Strings["Un'Goro Crater"] = ""
   RecipeRadar_Strings["Wailing Caverns"] = ""
   RecipeRadar_Strings["Western Plaguelands"] = ""
   RecipeRadar_Strings["Westfall"] = ""
   RecipeRadar_Strings["Wetlands"] = ""
   RecipeRadar_Strings["Winterspring"] = ""
   RecipeRadar_Strings["Zangarmarsh"] = ""

   -- some vendor names may need translating
   RecipeRadar_Strings["\"Cookie\" McWeaksauce"] = ""
   RecipeRadar_Strings["Aaron Hollman"] = ""
   RecipeRadar_Strings["Abigail Shiel"] = ""
   RecipeRadar_Strings["Aendel Windspear"] = ""
   RecipeRadar_Strings["Aged Dalaran Wizard"] = ""
   RecipeRadar_Strings["Alchemist Gribble"] = ""
   RecipeRadar_Strings["Alchemist Pestlezugg"] = ""
   RecipeRadar_Strings["Aldraan"] = ""
   RecipeRadar_Strings["Alexandra Bolero"] = ""
   RecipeRadar_Strings["Algernon"] = ""
   RecipeRadar_Strings["Almaador"] = ""
   RecipeRadar_Strings["Altaa"] = ""
   RecipeRadar_Strings["Alurmi"] = ""
   RecipeRadar_Strings["Amy Davenport"] = ""
   RecipeRadar_Strings["Andormu"] = ""
   RecipeRadar_Strings["Andrew Hilbert"] = ""
   RecipeRadar_Strings["Andrion Darkspinner"] = ""
   RecipeRadar_Strings["Androd Fadran"] = ""
   RecipeRadar_Strings["Apothecary Antonivich"] = ""
   RecipeRadar_Strings["Apprentice Darius"] = ""
   RecipeRadar_Strings["Aresella"] = ""
   RecipeRadar_Strings["Argent Quartermaster Hasana"] = ""
   RecipeRadar_Strings["Argent Quartermaster Lightspark"] = ""
   RecipeRadar_Strings["Arras"] = ""
   RecipeRadar_Strings["Arred"] = ""
   RecipeRadar_Strings["Arrond"] = ""
   RecipeRadar_Strings["Asarnan"] = ""
   RecipeRadar_Strings["Balai Lok'Wein"] = ""
   RecipeRadar_Strings["Bale"] = ""
   RecipeRadar_Strings["Banalash"] = ""
   RecipeRadar_Strings["Baxter"] = ""
   RecipeRadar_Strings["Blackwing"] = ""
   RecipeRadar_Strings["Blimo Gadgetspring"] = ""
   RecipeRadar_Strings["Blixrez Goodstitch"] = ""
   RecipeRadar_Strings["Blizrik Buckshot"] = ""
   RecipeRadar_Strings["Bliztik"] = ""
   RecipeRadar_Strings["Bombus Finespindle"] = ""
   RecipeRadar_Strings["Borto"] = ""
   RecipeRadar_Strings["Borya"] = ""
   RecipeRadar_Strings["Brienna Starglow"] = ""
   RecipeRadar_Strings["Bro'kin"] = ""
   RecipeRadar_Strings["Bronk"] = ""
   RecipeRadar_Strings["Burbik Gearspanner"] = ""
   RecipeRadar_Strings["Burko"] = ""
   RecipeRadar_Strings["Captured Gnome"] = ""
   RecipeRadar_Strings["Catherine Leland"] = ""
   RecipeRadar_Strings["Christoph Jeffcoat"] = ""
   RecipeRadar_Strings["Clyde Ranthal"] = ""
   RecipeRadar_Strings["Constance Brisboise"] = ""
   RecipeRadar_Strings["Cookie One-Eye"] = ""
   RecipeRadar_Strings["Coreiel"] = ""
   RecipeRadar_Strings["Corporal Bluth"] = ""
   RecipeRadar_Strings["Cowardly Crosby"] = ""
   RecipeRadar_Strings["Crazk Sparks"] = ""
   RecipeRadar_Strings["Cro Threadstrong"] = ""
   RecipeRadar_Strings["Daga Ramba"] = ""
   RecipeRadar_Strings["Daggle Ironshaper"] = ""
   RecipeRadar_Strings["Dalria"] = ""
   RecipeRadar_Strings["Daniel Bartlett"] = ""
   RecipeRadar_Strings["Danielle Zipstitch"] = ""
   RecipeRadar_Strings["Darian Singh"] = ""
   RecipeRadar_Strings["Darnall"] = ""
   RecipeRadar_Strings["Dealer Malij"] = ""
   RecipeRadar_Strings["Defias Profiteer"] = ""
   RecipeRadar_Strings["Deneb Walker"] = ""
   RecipeRadar_Strings["Derak Nightfall"] = ""
   RecipeRadar_Strings["Deynna"] = ""
   RecipeRadar_Strings["Dirge Quikcleave"] = ""
   RecipeRadar_Strings["Doba"] = ""
   RecipeRadar_Strings["Drac Roughcut"] = ""
   RecipeRadar_Strings["Drake Lindgren"] = ""
   RecipeRadar_Strings["Drovnar Strongbrew"] = ""
   RecipeRadar_Strings["Edna Mullby"] = ""
   RecipeRadar_Strings["Eebee Jinglepocket"] = ""
   RecipeRadar_Strings["Egomis"] = ""
   RecipeRadar_Strings["Eiin"] = ""
   RecipeRadar_Strings["Eldara Dawnrunner"] = ""
   RecipeRadar_Strings["Elynna"] = ""
   RecipeRadar_Strings["Emrul Riknussun"] = ""
   RecipeRadar_Strings["Eriden"] = ""
   RecipeRadar_Strings["Erika Tate"] = ""
   RecipeRadar_Strings["Erilia"] = ""
   RecipeRadar_Strings["Evie Whirlbrew"] = ""
   RecipeRadar_Strings["Fazu"] = ""
   RecipeRadar_Strings["Fedryen Swiftspear"] = ""
   RecipeRadar_Strings["Feera"] = ""
   RecipeRadar_Strings["Felannia"] = ""
   RecipeRadar_Strings["Felicia Doan"] = ""
   RecipeRadar_Strings["Felika"] = ""
   RecipeRadar_Strings["Fradd Swiftgear"] = ""
   RecipeRadar_Strings["Fyldan"] = ""
   RecipeRadar_Strings["Gagsprocket"] = ""
   RecipeRadar_Strings["Galley Chief Alunwea"] = ""
   RecipeRadar_Strings["Galley Chief Gathers"] = ""
   RecipeRadar_Strings["Galley Chief Grace"] = ""
   RecipeRadar_Strings["Galley Chief Halumvorea"] = ""
   RecipeRadar_Strings["Galley Chief Mariss"] = ""
   RecipeRadar_Strings["Galley Chief Steelbelly"] = ""
   RecipeRadar_Strings["Gambarinka"] = ""
   RecipeRadar_Strings["Gaston"] = ""
   RecipeRadar_Strings["Gearcutter Cogspinner"] = ""
   RecipeRadar_Strings["Gelanthis"] = ""
   RecipeRadar_Strings["George Candarte"] = ""
   RecipeRadar_Strings["Gharash"] = ""
   RecipeRadar_Strings["Ghok'kah"] = ""
   RecipeRadar_Strings["Gidge Spellweaver"] = ""
   RecipeRadar_Strings["Gigget Zipcoil"] = ""
   RecipeRadar_Strings["Gikkix"] = ""
   RecipeRadar_Strings["Gina MacGregor"] = ""
   RecipeRadar_Strings["Gloria Femmel"] = ""
   RecipeRadar_Strings["Glyx Brewright"] = ""
   RecipeRadar_Strings["Gnaz Blunderflame"] = ""
   RecipeRadar_Strings["Gretta Ganter"] = ""
   RecipeRadar_Strings["Grimtak"] = ""
   RecipeRadar_Strings["Haalrun"] = ""
   RecipeRadar_Strings["Haferet"] = ""
   RecipeRadar_Strings["Hagrus"] = ""
   RecipeRadar_Strings["Hammon Karwn"] = ""
   RecipeRadar_Strings["Harggan"] = ""
   RecipeRadar_Strings["Harklan Moongrove"] = ""
   RecipeRadar_Strings["Harlon Thornguard"] = ""
   RecipeRadar_Strings["Harlown Darkweave"] = ""
   RecipeRadar_Strings["Harn Longcast"] = ""
   RecipeRadar_Strings["Heldan Galesong"] = ""
   RecipeRadar_Strings["Helenia Olden"] = ""
   RecipeRadar_Strings["Himmik"] = ""
   RecipeRadar_Strings["Hotoppik Copperpinch"] = ""
   RecipeRadar_Strings["Hula'mahi"] = ""
   RecipeRadar_Strings["Indormi"] = ""
   RecipeRadar_Strings["Innkeeper Biribi"] = ""
   RecipeRadar_Strings["Innkeeper Fizzgrimble"] = ""
   RecipeRadar_Strings["Innkeeper Grilka"] = ""
   RecipeRadar_Strings["Jabbey"] = ""
   RecipeRadar_Strings["Jandia"] = ""
   RecipeRadar_Strings["Janet Hommers"] = ""
   RecipeRadar_Strings["Jangdor Swiftstrider"] = ""
   RecipeRadar_Strings["Jannos Ironwill"] = ""
   RecipeRadar_Strings["Jaquilina Dramet"] = ""
   RecipeRadar_Strings["Jase Farlane"] = ""
   RecipeRadar_Strings["Jazzrik"] = ""
   RecipeRadar_Strings["Jeeda"] = ""
   RecipeRadar_Strings["Jennabink Powerseam"] = ""
   RecipeRadar_Strings["Jessara Cordell"] = ""
   RecipeRadar_Strings["Jim Saltit"] = ""
   RecipeRadar_Strings["Jinky Twizzlefixxit"] = ""
   RecipeRadar_Strings["Johan Barnes"] = ""
   RecipeRadar_Strings["Joseph Moore"] = ""
   RecipeRadar_Strings["Jubie Gadgetspring"] = ""
   RecipeRadar_Strings["Jun'ha"] = ""
   RecipeRadar_Strings["Juno Dufrain"] = ""
   RecipeRadar_Strings["Jutak"] = ""
   RecipeRadar_Strings["Kaita Deepforge"] = ""
   RecipeRadar_Strings["Kalaen"] = ""
   RecipeRadar_Strings["Kalldan Felmoon"] = ""
   RecipeRadar_Strings["Kania"] = ""
   RecipeRadar_Strings["Karaaz"] = ""
   RecipeRadar_Strings["Keena"] = ""
   RecipeRadar_Strings["Kelsey Yance"] = ""
   RecipeRadar_Strings["Kendor Kabonka"] = ""
   RecipeRadar_Strings["Khara Deepwater"] = ""
   RecipeRadar_Strings["Khole Jinglepocket"] = ""
   RecipeRadar_Strings["Kiknikle"] = ""
   RecipeRadar_Strings["Killian Sanatha"] = ""
   RecipeRadar_Strings["Kilxx"] = ""
   RecipeRadar_Strings["Kireena"] = ""
   RecipeRadar_Strings["Kithas"] = ""
   RecipeRadar_Strings["Knaz Blunderflame"] = ""
   RecipeRadar_Strings["Koren"] = ""
   RecipeRadar_Strings["Kor'geld"] = ""
   RecipeRadar_Strings["Krek Cragcrush"] = ""
   RecipeRadar_Strings["Kriggon Talsone"] = ""
   RecipeRadar_Strings["Krinkle Goodsteel"] = ""
   RecipeRadar_Strings["Kulwia"] = ""
   RecipeRadar_Strings["Kzixx"] = ""
   RecipeRadar_Strings["Laird"] = ""
   RecipeRadar_Strings["Landraelanis"] = ""
   RecipeRadar_Strings["Lardan"] = ""
   RecipeRadar_Strings["Lebowski"] = ""
   RecipeRadar_Strings["Leeli Longhaggle"] = ""
   RecipeRadar_Strings["Leo Sarn"] = ""
   RecipeRadar_Strings["Leonard Porter"] = ""
   RecipeRadar_Strings["Lieutenant General Andorov"] = ""
   RecipeRadar_Strings["Lilly"] = ""
   RecipeRadar_Strings["Lindea Rabonne"] = ""
   RecipeRadar_Strings["Lizbeth Cromwell"] = ""
   RecipeRadar_Strings["Logannas"] = ""
   RecipeRadar_Strings["Logistics Officer Ulrike"] = ""
   RecipeRadar_Strings["Lokhtos Darkbargainer"] = ""
   RecipeRadar_Strings["Loolruna"] = ""
   RecipeRadar_Strings["Lorelae Wintersong"] = ""
   RecipeRadar_Strings["Lucan Cordell"] = ""
   RecipeRadar_Strings["Lyna"] = ""
   RecipeRadar_Strings["Madame Ruby"] = ""
   RecipeRadar_Strings["Magnus Frostwake"] = ""
   RecipeRadar_Strings["Mahu"] = ""
   RecipeRadar_Strings["Mallen Swain"] = ""
   RecipeRadar_Strings["Malygen"] = ""
   RecipeRadar_Strings["Mari Stonehand"] = ""
   RecipeRadar_Strings["Maria Lumere"] = ""
   RecipeRadar_Strings["Martine Tramblay"] = ""
   RecipeRadar_Strings["Masat T'andr"] = ""
   RecipeRadar_Strings["Master Chef Mouldier"] = ""
   RecipeRadar_Strings["Master Craftsman Omarion"] = ""
   RecipeRadar_Strings["Mathar G'ochar"] = ""
   RecipeRadar_Strings["Mavralyn"] = ""
   RecipeRadar_Strings["Mazk Snipeshot"] = ""
   RecipeRadar_Strings["Meilosh"] = ""
   RecipeRadar_Strings["Melaris"] = ""
   RecipeRadar_Strings["Micha Yance"] = ""
   RecipeRadar_Strings["Millie Gregorian"] = ""
   RecipeRadar_Strings["Mishta"] = ""
   RecipeRadar_Strings["Mixie Farshot"] = ""
   RecipeRadar_Strings["Montarr"] = ""
   RecipeRadar_Strings["Muheru the Weaver"] = ""
   RecipeRadar_Strings["Muuran"] = ""
   RecipeRadar_Strings["Mycah"] = ""
   RecipeRadar_Strings["Mythrin'dir"] = ""
   RecipeRadar_Strings["Naal Mistrunner"] = ""
   RecipeRadar_Strings["Naka"] = ""
   RecipeRadar_Strings["Nakodu"] = ""
   RecipeRadar_Strings["Namdo Bizzfizzle"] = ""
   RecipeRadar_Strings["Nandar Branson"] = ""
   RecipeRadar_Strings["Nardstrum Copperpinch"] = ""
   RecipeRadar_Strings["Narj Deepslice"] = ""
   RecipeRadar_Strings["Narkk"] = ""
   RecipeRadar_Strings["Nasmara Moonsong"] = ""
   RecipeRadar_Strings["Nata Dawnstrider"] = ""
   RecipeRadar_Strings["Neal Allen"] = ""
   RecipeRadar_Strings["Neii"] = ""
   RecipeRadar_Strings["Nergal"] = ""
   RecipeRadar_Strings["Nerrist"] = ""
   RecipeRadar_Strings["Nessa Shadowsong"] = ""
   RecipeRadar_Strings["Nina Lightbrew"] = ""
   RecipeRadar_Strings["Nioma"] = ""
   RecipeRadar_Strings["Nula the Butcher"] = ""
   RecipeRadar_Strings["Nyoma"] = ""
   RecipeRadar_Strings["Ogg'marr"] = ""
   RecipeRadar_Strings["Okuno"] = ""
   RecipeRadar_Strings["Old Man Heming"] = ""
   RecipeRadar_Strings["Otho Moji'ko"] = ""
   RecipeRadar_Strings["Outfitter Eric"] = ""
   RecipeRadar_Strings["Paulsta'ats"] = ""
   RecipeRadar_Strings["Penney Copperpinch"] = ""
   RecipeRadar_Strings["Phea"] = ""
   RecipeRadar_Strings["Plugger Spazzring"] = ""
   RecipeRadar_Strings["Pratt McGrubben"] = ""
   RecipeRadar_Strings["Provisioner Nasela"] = ""
   RecipeRadar_Strings["Qia"] = ""
   RecipeRadar_Strings["Quartermaster Davian Vaclav"] = ""
   RecipeRadar_Strings["Quartermaster Endarin"] = ""
   RecipeRadar_Strings["Quartermaster Enuril"] = ""
   RecipeRadar_Strings["Quartermaster Jaffrey Noreliqe"] = ""
   RecipeRadar_Strings["Quartermaster Miranda Breechlock"] = ""
   RecipeRadar_Strings["Quartermaster Urgronn"] = ""
   RecipeRadar_Strings["Quelis"] = ""
   RecipeRadar_Strings["Ranik"] = ""
   RecipeRadar_Strings["Rann Flamespinner"] = ""
   RecipeRadar_Strings["Rartar"] = ""
   RecipeRadar_Strings["Rathis Tomber"] = ""
   RecipeRadar_Strings["Rikqiz"] = ""
   RecipeRadar_Strings["Rin'wosho the Trader"] = ""
   RecipeRadar_Strings["Rizz Loosebolt"] = ""
   RecipeRadar_Strings["Rohok"] = ""
   RecipeRadar_Strings["Ronald Burch"] = ""
   RecipeRadar_Strings["Rungor"] = ""
   RecipeRadar_Strings["Ruppo Zipcoil"] = ""
   RecipeRadar_Strings["Saenorion"] = ""
   RecipeRadar_Strings["Sassa Weldwell"] = ""
   RecipeRadar_Strings["Seer Janidi"] = ""
   RecipeRadar_Strings["Seersa Copperpinch"] = ""
   RecipeRadar_Strings["Sewa Mistrunner"] = ""
   RecipeRadar_Strings["Shaani"] = ""
   RecipeRadar_Strings["Shadi Mistrunner"] = ""
   RecipeRadar_Strings["Shandrina"] = ""
   RecipeRadar_Strings["Shankys"] = ""
   RecipeRadar_Strings["Sheendra Tallgrass"] = ""
   RecipeRadar_Strings["Shen'dralar Provisioner"] = ""
   RecipeRadar_Strings["Sheri Zipstitch"] = ""
   RecipeRadar_Strings["Sid Limbardi"] = ""
   RecipeRadar_Strings["Skreah"] = ""
   RecipeRadar_Strings["Smudge Thunderwood"] = ""
   RecipeRadar_Strings["Soolie Berryfizz"] = ""
   RecipeRadar_Strings["Sovik"] = ""
   RecipeRadar_Strings["Stuart Fleming"] = ""
   RecipeRadar_Strings["Sumi"] = ""
   RecipeRadar_Strings["Super-Seller 680"] = ""
   RecipeRadar_Strings["Supply Officer Mills"] = ""
   RecipeRadar_Strings["Tamar"] = ""
   RecipeRadar_Strings["Tansy Puddlefizz"] = ""
   RecipeRadar_Strings["Tarban Hearthgrain"] = ""
   RecipeRadar_Strings["Tari'qa"] = ""
   RecipeRadar_Strings["Tatiana"] = ""
   RecipeRadar_Strings["Thaddeus Webb"] = ""
   RecipeRadar_Strings["Tharynn Bouden"] = ""
   RecipeRadar_Strings["Thomas Yance"] = ""
   RecipeRadar_Strings["Tilli Thistlefuzz"] = ""
   RecipeRadar_Strings["Trader Narasu"] = ""
   RecipeRadar_Strings["Truk Wildbeard"] = ""
   RecipeRadar_Strings["Tunkk"] = ""
   RecipeRadar_Strings["Ulthaan"] = ""
   RecipeRadar_Strings["Ulthir"] = ""
   RecipeRadar_Strings["Uriku"] = ""
   RecipeRadar_Strings["Uthok"] = ""
   RecipeRadar_Strings["Vaean"] = ""
   RecipeRadar_Strings["Valdaron"] = ""
   RecipeRadar_Strings["Vargus"] = ""
   RecipeRadar_Strings["Veenix"] = ""
   RecipeRadar_Strings["Vendor-Tron 1000"] = ""
   RecipeRadar_Strings["Vharr"] = ""
   RecipeRadar_Strings["Viggz Shinesparked"] = ""
   RecipeRadar_Strings["Vivianna"] = ""
   RecipeRadar_Strings["Vizzklick"] = ""
   RecipeRadar_Strings["Vodesiin"] = ""
   RecipeRadar_Strings["Wenna Silkbeard"] = ""
   RecipeRadar_Strings["Werg Thickblade"] = ""
   RecipeRadar_Strings["Wik'Tar"] = ""
   RecipeRadar_Strings["Wind Trader Lathrai"] = ""
   RecipeRadar_Strings["Wolgren Jinglepocket"] = ""
   RecipeRadar_Strings["Worb Strongstitch"] = ""
   RecipeRadar_Strings["Wrahk"] = ""
   RecipeRadar_Strings["Wulan"] = ""
   RecipeRadar_Strings["Wulmort Jinglepocket"] = ""
   RecipeRadar_Strings["Wunna Darkmane"] = ""
   RecipeRadar_Strings["Xandar Goodbeard"] = ""
   RecipeRadar_Strings["Xen'to"] = ""
   RecipeRadar_Strings["Xerintha Ravenoak"] = ""
   RecipeRadar_Strings["Xizk Goodstitch"] = ""
   RecipeRadar_Strings["Xizzer Fizzbolt"] = ""
   RecipeRadar_Strings["Yatheon"] = ""
   RecipeRadar_Strings["Yonada"] = ""
   RecipeRadar_Strings["Ythyar"] = ""
   RecipeRadar_Strings["Yuka Screwspigot"] = ""
   RecipeRadar_Strings["Yurial Soulwater"] = ""
   RecipeRadar_Strings["Zan Shivsproket"] = ""
   RecipeRadar_Strings["Zannok Hidepiercer"] = ""
   RecipeRadar_Strings["Zansoa"] = ""
   RecipeRadar_Strings["Zaralda"] = ""
   RecipeRadar_Strings["Zarena Cromwind"] = ""
   RecipeRadar_Strings["Zargh"] = ""
   RecipeRadar_Strings["Zixil"] = ""
   RecipeRadar_Strings["Zorbin Fandazzle"] = ""
   RecipeRadar_Strings["Zurai"] = ""

end

-- actual locales and the relevant string tables follow

if (GetLocale() == "deDE") then

   RecipeRadar_Strings["Toggle Recipe Radar"] = "Recipe Radar umschalten"
   RecipeRadar_Strings["Recipe Radar Bindings"] = "Recipe Radar Tastenbelegung"
   RecipeRadar_Strings["Auto-map Contributive Vendors"] = "Erlernbare Rezepte Automatisch Markieren"
   RecipeRadar_Strings["Auto-select Current Region"] = "Automatisch aktuelle Zone wählen"
   RecipeRadar_Strings["Check Availability for Alts"] = "Verwendbarkeit für Alts prüfen"
   RecipeRadar_Strings["Minimap Button Position"] = "Position des Minimap-Button"
   RecipeRadar_Strings["Show Minimap Button"] = "Minimap-Button anzeigen"
   RecipeRadar_Strings["Options"] = "Optionen"
   RecipeRadar_Strings["%d learnable"] = "%d lernbar"
   RecipeRadar_Strings["%d recipes"] = "%d Rezepte"
   RecipeRadar_Strings["1 recipe"] = "1 Rezept"
   RecipeRadar_Strings["Uncached Recipe"] = "Rezept nicht im Cache"
   RecipeRadar_Strings["You may mouse over the [?]"] = "Bewege die Maus über das [?]-Symbol"
   RecipeRadar_Strings["icon to lookup this recipe."] = "um dieses Rezept nachzuschlagen."
   RecipeRadar_Strings["Warning: if your server has"] = "Warnung: wenn der Server dieses"
   RecipeRadar_Strings["not yet seen this item, you"] = "Rezept noch nicht gesehen hat"
   RecipeRadar_Strings["will be disconnected!"] = "wird die Verbindung getrennt!"
   RecipeRadar_Strings["No recipes for sale in this region."] = "Keine Rezepte zum Verkauf in dieser Region."
   RecipeRadar_Strings["Shift-click a vendor to add or remove her location on the world map."] = "Shift-Klicke einen Händler, um seine Position auf der Weltkarte und Minikarte hinzuzufügen oder zu entfernen."
   RecipeRadar_Strings["Locate Vendor on Map"] = "Händler auf Karte zeigen"
   RecipeRadar_Strings["Factions"] = "Parteien"
   RecipeRadar_Strings["Alchemy"] = "Alchimie"
   RecipeRadar_Strings["Blacksmithing"] = "Schmiedekunst"
   RecipeRadar_Strings["Cooking"] = "Kochkunst"
   RecipeRadar_Strings["Enchanting"] = "Verzauberkunst"
   RecipeRadar_Strings["Engineering"] = "Ingenieurskunst"
   RecipeRadar_Strings["First Aid"] = "Erste Hilfe"
   RecipeRadar_Strings["Fishing"] = "Angeln"
   RecipeRadar_Strings["Jewelcrafting"] = "Juwelenschleifen"
   RecipeRadar_Strings["Leatherworking"] = "Lederverarbeitung"
   RecipeRadar_Strings["Tailoring"] = "Schneiderei"
   RecipeRadar_Strings["Professions"] = "Berufe"
   RecipeRadar_Strings["Already Known (Alts)"] = "Bereits bekannt (Alts)"
   RecipeRadar_Strings["Already Known (Player)"] = "Bereits bekannt (Spieler)"
   RecipeRadar_Strings["Available Now (Alts)"] = "Vorhanden jetzt (Alts)"
   RecipeRadar_Strings["Available Now (Player)"] = "Vorhanden jetzt (Spieler)"
   RecipeRadar_Strings["Future Prospect (Alts)"] = "Zukünftige Aussicht (Alts)"
   RecipeRadar_Strings["Future Prospect (Player)"] = "Zukünftige Aussicht (Spieler)"
   RecipeRadar_Strings["Inapplicable"] = "Nicht anwendbar"
   RecipeRadar_Strings["Availability"] = "Verwendbarkeit"
   RecipeRadar_Strings["Already Known By:"] = "Bereits bekannt für:"
   RecipeRadar_Strings["Future Prospect For:"] = "Zukünftige Aussicht für:"
   RecipeRadar_Strings["Available For:"] = "Vorhanden für:"
   RecipeRadar_Strings["%d of %d"] = "%d von %d"
   RecipeRadar_Strings["Intermittent"] = "Zeitweiliger"
   RecipeRadar_Strings["Quest"] = "Quest"
   RecipeRadar_Strings["Roving"] = "Wandernder"
   RecipeRadar_Strings["Seasonal"] = "Saisonaler"
   RecipeRadar_Strings["%s Vendor"] = "%s Händler"
   RecipeRadar_Strings["Shattered Sun Offensive"] = "Zerschmetterte Sonne"
   RecipeRadar_Strings["Ashtongue Deathsworn"] = "Die Todeshörigen"
   RecipeRadar_Strings["Cenarion Circle"] = "Zirkel des Cenarius"
   RecipeRadar_Strings["Cenarion Expedition"] = "Expedition des Cenarius"
   RecipeRadar_Strings["Honor Hold"] = "Ehrenfeste"
   RecipeRadar_Strings["Keepers of Time"] = "Hüter der Zeit"
   RecipeRadar_Strings["Lower City"] = "Unteres Viertel"
   RecipeRadar_Strings["Netherwing"] = "Netherschwingen"
   RecipeRadar_Strings["The Aldor"] = "Die Aldor"
   RecipeRadar_Strings["The Consortium"] = "Das Consortium"
   RecipeRadar_Strings["The Mag'har"] = "Die Mag'har"
   RecipeRadar_Strings["The Scale of the Sands"] = "Die Wächter der Sande"
   RecipeRadar_Strings["The Scryers"] = "Die Seher"
   RecipeRadar_Strings["The Sha'tar"] = "Die Sha'tar"
   RecipeRadar_Strings["The Violet Eye"] = "Das Violette Auge"
   RecipeRadar_Strings["Thorium Brotherhood"] = "Thorium-Bruderschaft"
   RecipeRadar_Strings["Timbermaw Hold"] = "Holzschlundfeste"
   RecipeRadar_Strings["Zandalar Tribe"] = "Zandalar"
   RecipeRadar_Strings["Argent Dawn"] = "Argentumdämmerung"
   RecipeRadar_Strings["Rogue"] = "Schurke"
   RecipeRadar_Strings["Special"] = "Speziell"
   RecipeRadar_Strings["%s Only"] = "Nur %s"
   RecipeRadar_Strings["Collapse"] = "Einklappen"
   RecipeRadar_Strings["Collapse All"] = "Alle einklappen"
   RecipeRadar_Strings["Expand"] = "Ausklappen"
   RecipeRadar_Strings["Expand All"] = "Alle ausklappen"
   RecipeRadar_Strings["Map Vendor"] = "Händler auf Karte anzeigen"
   RecipeRadar_Strings["Unmap Vendor"] = "Händler von Karte entfernen"
   RecipeRadar_Strings["Armorsmith"] = "Rüstungsschmied"
   RecipeRadar_Strings["Dragonscale Leatherworking"] = "Drachenschuppenlederverarbeitung"
   RecipeRadar_Strings["Elemental Leatherworking"] = "Elementarlederverarbeitung"
   RecipeRadar_Strings["Goblin Engineer"] = "Goblin-Ingenieur"
   RecipeRadar_Strings["Master Axesmith"] = "Axtschmiedemeister"
   RecipeRadar_Strings["Master Hammersmith"] = "Hammerschmiedemeister"
   RecipeRadar_Strings["Master Swordsmith"] = "Schwertschmiedemeister"
   RecipeRadar_Strings["Tribal Leatherworking"] = "Stammeslederverarbeitung"
   RecipeRadar_Strings["Weaponsmith"] = "Waffenschmied"
   RecipeRadar_Strings["Gnomish Engineer"] = "Gnomen-Ingenieur"
   RecipeRadar_Strings["Eastern Kingdoms"] = "Östliche Königreiche"
   RecipeRadar_Strings["Instances"] = "Instanzen"

   RecipeRadar_Strings["Alterac Mountains"] = "Alteracgebirge"
   RecipeRadar_Strings["Arathi Highlands"] = "Arathihochland"
   RecipeRadar_Strings["Ashenvale"] = "Eschental"
   RecipeRadar_Strings["Azuremyst Isle"] = "Azurmythosinsel"
   RecipeRadar_Strings["Badlands"] = "Ödland"
   RecipeRadar_Strings["Black Temple"] = "Der Schwarze Tempel"
   RecipeRadar_Strings["Blackrock Depths"] = "Schwarzfelstiefen"
   RecipeRadar_Strings["Blade's Edge Mountains"] = "Schergrat"
   RecipeRadar_Strings["Blasted Lands"] = "Verwüstete Lande"
   RecipeRadar_Strings["Bloodmyst Isle"] = "Blutmythosinsel"
   RecipeRadar_Strings["Burning Steppes"] = "Brennende Steppe"
   RecipeRadar_Strings["Darkshore"] = "Dunkelküste"
   RecipeRadar_Strings["Dire Maul"] = "Düsterbruch"
   RecipeRadar_Strings["Duskwood"] = "Dämmerwald"
   RecipeRadar_Strings["Dustwallow Marsh"] = "Düstermarschen"
   RecipeRadar_Strings["Eastern Plaguelands"] = "Östliche Pestländer"
   RecipeRadar_Strings["Elwynn Forest"] = "Wald von Elwynn"
   RecipeRadar_Strings["Eversong Woods"] = "Immersangwald"
   RecipeRadar_Strings["Felwood"] = "Teufelswald"
   RecipeRadar_Strings["Ghostlands"] = "Geisterlande"
   RecipeRadar_Strings["Hellfire Peninsula"] = "Höllenfeuerhalbinsel"
   RecipeRadar_Strings["Hillsbrad Foothills"] = "Vorgebirge des Hügellands"
   RecipeRadar_Strings["Ironforge"] = "Eisenschmiede"
   RecipeRadar_Strings["Moonglade"] = "Mondlichtung"
   RecipeRadar_Strings["Netherstorm"] = "Nethersturm"
   RecipeRadar_Strings["Old Hillsbrad Foothills"] = "Vorgebirge des Alten Hügellands"
   RecipeRadar_Strings["Redridge Mountains"] = "Rotkammgebirge"
   RecipeRadar_Strings["Shadowmoon Valley"] = "Schattenmondtal"
   RecipeRadar_Strings["Shattrath City"] = "Shattrath"
   RecipeRadar_Strings["Silvermoon City"] = "Silbermond"
   RecipeRadar_Strings["Silverpine Forest"] = "Silberwald"
   RecipeRadar_Strings["Stonetalon Mountains"] = "Steinkrallengebirge"
   RecipeRadar_Strings["Stormwind City"] = "Sturmwind"
   RecipeRadar_Strings["Stranglethorn Vale"] = "Schlingendorntal"
   RecipeRadar_Strings["Swamp of Sorrows"] = "Sümpfe des Elends"
   RecipeRadar_Strings["Terokkar Forest"] = "Wälder von Terokkar"
   RecipeRadar_Strings["The Barrens"] = "Brachland"
   RecipeRadar_Strings["The Exodar"] = "Die Exodar"
   RecipeRadar_Strings["The Hinterlands"] = "Hinterland"
   RecipeRadar_Strings["Thousand Needles"] = "Tausend Nadeln"
   RecipeRadar_Strings["Thunder Bluff"] = "Donnerfels"
   RecipeRadar_Strings["Tirisfal Glades"] = "Tirisfal"
   RecipeRadar_Strings["Undercity"] = "Unterstadt"
   RecipeRadar_Strings["Un'Goro Crater"] = "Krater von Un'Goro"
   RecipeRadar_Strings["Wailing Caverns"] = "Höhlen des Wehklagens"
   RecipeRadar_Strings["Western Plaguelands"] = "Westliche Pestländer"
   RecipeRadar_Strings["Wetlands"] = "Sumpfland"
   RecipeRadar_Strings["Winterspring"] = "Winterquell"
   RecipeRadar_Strings["Zangarmarsh"] = "Zangarmarschen"

   RecipeRadar_Strings["\"Cookie\" McWeaksauce"] = "\"Kräcka\" Aschebäscha"
   RecipeRadar_Strings["Aaron Hollman"] = "Aaron Hollmann"
   RecipeRadar_Strings["Aendel Windspear"] = "Aendel Windspeer"
   RecipeRadar_Strings["Aged Dalaran Wizard"] = "Gealterter Hexer von Dalaran"
   RecipeRadar_Strings["Alchemist Gribble"] = "Alchimist Grabbel"
   RecipeRadar_Strings["Alchemist Pestlezugg"] = "Alchimist Stößelbruch"
   RecipeRadar_Strings["Andrion Darkspinner"] = "Andrion Dunkelweber"
   RecipeRadar_Strings["Apothecary Antonivich"] = "Apotheker Antonivich"
   RecipeRadar_Strings["Apprentice Darius"] = "Lehrling Darius"
   RecipeRadar_Strings["Argent Quartermaster Hasana"] = "Argentumrüstmeister Hasana"
   RecipeRadar_Strings["Argent Quartermaster Lightspark"] = "Argentumrüstmeister Funkellicht"
   RecipeRadar_Strings["Blimo Gadgetspring"] = "Blimo Federdings"
   RecipeRadar_Strings["Blixrez Goodstitch"] = "Blixrez Gutstich"
   RecipeRadar_Strings["Blizrik Buckshot"] = "Blizrik Bockschuss"
   RecipeRadar_Strings["Bombus Finespindle"] = "Bombus Feinspindel"
   RecipeRadar_Strings["Brienna Starglow"] = "Brienna Sternenglanz"
   RecipeRadar_Strings["Burbik Gearspanner"] = "Burbik Ritzelspann"
   RecipeRadar_Strings["Captured Gnome"] = "Gefangener Gnom"
   RecipeRadar_Strings["Christoph Jeffcoat"] = "Christoph Jeffkott"
   RecipeRadar_Strings["Cookie One-Eye"] = "Kräcka Einauge"
   RecipeRadar_Strings["Corporal Bluth"] = "Korporal Bluth"
   RecipeRadar_Strings["Cowardly Crosby"] = "Feiger Crosby"
   RecipeRadar_Strings["Crazk Sparks"] = "Crazk Funks"
   RecipeRadar_Strings["Cro Threadstrong"] = "Cro Starkfaden"
   RecipeRadar_Strings["Daggle Ironshaper"] = "Daggle Eisenformer"
   RecipeRadar_Strings["Danielle Zipstitch"] = "Danielle Stichelnaht"
   RecipeRadar_Strings["Dealer Malij"] = "Händler Malij"
   RecipeRadar_Strings["Defias Profiteer"] = "Schieber der Defias"
   RecipeRadar_Strings["Deneb Walker"] = "Deneb Wandler"
   RecipeRadar_Strings["Derak Nightfall"] = "Derak Nachtlauer"
   RecipeRadar_Strings["Dirge Quikcleave"] = "Dirge Schnetzelhack"
   RecipeRadar_Strings["Drac Roughcut"] = "Drac Grobschnitt"
   RecipeRadar_Strings["Drovnar Strongbrew"] = "Drovnar Starkbräu"
   RecipeRadar_Strings["Evie Whirlbrew"] = "Evie Wirbelbräu"
   RecipeRadar_Strings["Fedryen Swiftspear"] = "Fedryen Flinkspeer"
   RecipeRadar_Strings["Fradd Swiftgear"] = "Fradd Schnellschalt"
   RecipeRadar_Strings["Gagsprocket"] = "Quietschspross"
   RecipeRadar_Strings["Gearcutter Cogspinner"] = "Ritzelschnitt Zahnrad"
   RecipeRadar_Strings["Gidge Spellweaver"] = "Gidge Spruchwirker"
   RecipeRadar_Strings["Gigget Zipcoil"] = "Gigget Reißspule"
   RecipeRadar_Strings["Glyx Brewright"] = "Glyx Gutbräu"
   RecipeRadar_Strings["Gnaz Blunderflame"] = "Gnaz Dusselflamm"
   RecipeRadar_Strings["Harklan Moongrove"] = "Harklan Mondhain"
   RecipeRadar_Strings["Harlon Thornguard"] = "Harlon Dornenwacht"
   RecipeRadar_Strings["Harlown Darkweave"] = "Harlown Dunkelwirker"
   RecipeRadar_Strings["Harn Longcast"] = "Harn Rutenwurf"
   RecipeRadar_Strings["Heldan Galesong"] = "Heldan Sturmgesang"
   RecipeRadar_Strings["Innkeeper Biribi"] = "Gastwirtin Biribi"
   RecipeRadar_Strings["Innkeeper Fizzgrimble"] = "Gastwirt Zischgrimbel"
   RecipeRadar_Strings["Innkeeper Grilka"] = "Gastwirtin Grilka"
   RecipeRadar_Strings["Jabbey"] = "Stupser"
   RecipeRadar_Strings["Jangdor Swiftstrider"] = "Jangdor Flinkschreiter"
   RecipeRadar_Strings["Jannos Ironwill"] = "Jannos Eisenwill"
   RecipeRadar_Strings["Jase Farlane"] = "Jase Langweg"
   RecipeRadar_Strings["Jennabink Powerseam"] = "Jennabink Starksaum"
   RecipeRadar_Strings["Jim Saltit"] = "Jim Salzit"
   RecipeRadar_Strings["Jinky Twizzlefixxit"] = "Jinky Pfuschelfix"
   RecipeRadar_Strings["Joseph Moore"] = "Joseph Moor"
   RecipeRadar_Strings["Jubie Gadgetspring"] = "Jubie Federdings"
   RecipeRadar_Strings["Kaita Deepforge"] = "Kaita Tiefenschmied"
   RecipeRadar_Strings["Kalldan Felmoon"] = "Kalldan Teufelsmond"
   RecipeRadar_Strings["Khara Deepwater"] = "Khara Tiefenwasser"
   RecipeRadar_Strings["Knaz Blunderflame"] = "Knaz Dusselflamm"
   RecipeRadar_Strings["Krek Cragcrush"] = "Krek Schmetterfels"
   RecipeRadar_Strings["Krinkle Goodsteel"] = "Krinkle Goldstahl"
   RecipeRadar_Strings["Leeli Longhaggle"] = "Leeli Langfeilsch"
   RecipeRadar_Strings["Lieutenant General Andorov"] = "Generalleutnant Andorov"
   RecipeRadar_Strings["Lizbeth Cromwell"] = "Lizbeth Kromwell"
   RecipeRadar_Strings["Logistics Officer Ulrike"] = "Nachschuboffizier Ulrike"
   RecipeRadar_Strings["Lokhtos Darkbargainer"] = "Lokhtos Düsterfeilsch"
   RecipeRadar_Strings["Lorelae Wintersong"] = "Lorelae Winterklang"
   RecipeRadar_Strings["Madame Ruby"] = "Madame Rubin"
   RecipeRadar_Strings["Magnus Frostwake"] = "Magnus Frostrufer"
   RecipeRadar_Strings["Mallen Swain"] = "Mallen Knab"
   RecipeRadar_Strings["Mari Stonehand"] = "Mari Steinhand"
   RecipeRadar_Strings["Martine Tramblay"] = "Martine Tramblei"
   RecipeRadar_Strings["Master Chef Mouldier"] = "Meisterkoch Mouldier"
   RecipeRadar_Strings["Master Craftsman Omarion"] = "Meisterhandwerker Omarion"
   RecipeRadar_Strings["Mazk Snipeshot"] = "Mazk Zielschuss"
   RecipeRadar_Strings["Mixie Farshot"] = "Mixie Weitschuss"
   RecipeRadar_Strings["Muheru the Weaver"] = "Muheru der Weber"
   RecipeRadar_Strings["Naal Mistrunner"] = "Naal Nebelläufer"
   RecipeRadar_Strings["Namdo Bizzfizzle"] = "Namdo Blitzzischel"
   RecipeRadar_Strings["Narj Deepslice"] = "Narj Schnitzelschnitt"
   RecipeRadar_Strings["Nasmara Moonsong"] = "Nasmara Mondweise"
   RecipeRadar_Strings["Nata Dawnstrider"] = "Nata Morgenwandler"
   RecipeRadar_Strings["Nessa Shadowsong"] = "Nessa Schattensang"
   RecipeRadar_Strings["Nina Lightbrew"] = "Nina Brauleicht"
   RecipeRadar_Strings["Nula the Butcher"] = "Nula der Metzger"
   RecipeRadar_Strings["Old Man Heming"] = "Der alte Mann Heming"
   RecipeRadar_Strings["Outfitter Eric"] = "Ausstatter Eric"
   RecipeRadar_Strings["Plugger Spazzring"] = "Stöpsel Zapfring"
   RecipeRadar_Strings["Provisioner Nasela"] = "Versorgerin Nasela"
   RecipeRadar_Strings["Quartermaster Endarin"] = "Rüstmeister Endarin"
   RecipeRadar_Strings["Quartermaster Enuril"] = "Rüstmeister Enuril"
   RecipeRadar_Strings["Quartermaster Miranda Breechlock"] = "Rüstmeisterin Miranda Knackschloss"
   RecipeRadar_Strings["Quartermaster Urgronn"] = "Rüstmeister Urgronn"
   RecipeRadar_Strings["Rann Flamespinner"] = "Rann Flammenweber"
   RecipeRadar_Strings["Rin'wosho the Trader"] = "Rin'wosho der Händler"
   RecipeRadar_Strings["Rizz Loosebolt"] = "Rizz Wackelbolz"
   RecipeRadar_Strings["Ruppo Zipcoil"] = "Ruppo Reißspule"
   RecipeRadar_Strings["Seer Janidi"] = "Seherin Janidi"
   RecipeRadar_Strings["Sewa Mistrunner"] = "Sewa Nebelläufer"
   RecipeRadar_Strings["Shadi Mistrunner"] = "Shadi Nebelläufer"
   RecipeRadar_Strings["Sheendra Tallgrass"] = "Sheendra Hochschilf"
   RecipeRadar_Strings["Shen'dralar Provisioner"] = "Versorger der Shen'dralar"
   RecipeRadar_Strings["Sheri Zipstitch"] = "Sheri Stichelnaht"
   RecipeRadar_Strings["Smudge Thunderwood"] = "Smudge Donnerholz"
   RecipeRadar_Strings["Soolie Berryfizz"] = "Soolie Brausefitz"
   RecipeRadar_Strings["Super-Seller 680"] = "Superverkaufomat 680"
   RecipeRadar_Strings["Supply Officer Mills"] = "Versorgungsoffizier Mühlens"
   RecipeRadar_Strings["Tansy Puddlefizz"] = "Tansy Pfützplatsch"
   RecipeRadar_Strings["Tarban Hearthgrain"] = "Tarban Kornbäcker"
   RecipeRadar_Strings["Thaddeus Webb"] = "Thaddeus Webner"
   RecipeRadar_Strings["Tilli Thistlefuzz"] = "Tilli Distelflaum"
   RecipeRadar_Strings["Trader Narasu"] = "Händler Narasu"
   RecipeRadar_Strings["Truk Wildbeard"] = "Truk Wildbart"
   RecipeRadar_Strings["Vendor-Tron 1000"] = "Kaufotron 1000"
   RecipeRadar_Strings["Viggz Shinesparked"] = "Viggz Funkenschimmer"
   RecipeRadar_Strings["Wenna Silkbeard"] = "Wenna Seidenbart"
   RecipeRadar_Strings["Werg Thickblade"] = "Werg Breitklinge"
   RecipeRadar_Strings["Wind Trader Lathrai"] = "Windhändler Lathrai"
   RecipeRadar_Strings["Worb Strongstitch"] = "Worb Starkahle"
   RecipeRadar_Strings["Wulmort Jinglepocket"] = "Wulmort Klingeltaschen"
   RecipeRadar_Strings["Wunna Darkmane"] = "Wunna Dunkelmähne"
   RecipeRadar_Strings["Xandar Goodbeard"] = "Xandar Gutbart"
   RecipeRadar_Strings["Xizk Goodstitch"] = "Xizk Gutstich"
   RecipeRadar_Strings["Xizzer Fizzbolt"] = "Xizzer Zischbolz"
   RecipeRadar_Strings["Yuka Screwspigot"] = "Yuka Schraubstutz"
   RecipeRadar_Strings["Yurial Soulwater"] = "Yurial Seelenwasser"
   RecipeRadar_Strings["Zan Shivsproket"] = "Zan Messerritzel"
   RecipeRadar_Strings["Zannok Hidepiercer"] = "Zannok Ledernaht"
   RecipeRadar_Strings["Zarena Cromwind"] = "Zarena Stahlwind"
   RecipeRadar_Strings["Zorbin Fandazzle"] = "Zorbin von Schiller"

end

if (GetLocale() == "frFR") then

   RecipeRadar_Strings["Toggle Recipe Radar"] = "Recipe Radar À bascule"
   RecipeRadar_Strings["Recipe Radar Bindings"] = "Attaches De Recipe Radar"
   RecipeRadar_Strings["Auto-map Contributive Vendors"] = "Recettes Disponibles d'affichage"
   RecipeRadar_Strings["Auto-select Current Region"] = "Sélection automatique de la région courante"
   RecipeRadar_Strings["Check Availability for Alts"] = "Examinez la disponibilité pour les alts"
   RecipeRadar_Strings["Minimap Button Position"] = "Position du bouton sur la Minimap"
   RecipeRadar_Strings["Show Minimap Button"] = "Montrez le Bouton sur la Minimap"
   RecipeRadar_Strings["%d learnable"] = "%d utilisables"
   RecipeRadar_Strings["%d recipes"] = "%d recettes"
   RecipeRadar_Strings["1 recipe"] = "1 recette"
   RecipeRadar_Strings["Uncached Recipe"] = "Recette Non présente"
   RecipeRadar_Strings["You may mouse over the [?]"] = "Vous devez passer la souris sur l'icône [?] pour"
   RecipeRadar_Strings["icon to lookup this recipe."] = "ajouter cette recette à votre base de donnèe."
   RecipeRadar_Strings["Warning: if your server has"] = "Avertissement: si votre serveur n'a"
   RecipeRadar_Strings["not yet seen this item, you"] = "pas encore vu cet article, vous serez"
   RecipeRadar_Strings["will be disconnected!"] = "déconnecté!"
   RecipeRadar_Strings["No recipes for sale in this region."] = "Aucune recette à vendre dans cette région."
   RecipeRadar_Strings["Shift-click a vendor to add or remove her location on the world map."] = "Shift-clic sur un marchand pour  ajouter ou enlever sa position sur la carte du monde."
   RecipeRadar_Strings["Locate Vendor on Map"] = "Localiser le marchand"
   RecipeRadar_Strings["Neutral"] = "Neutre"
   RecipeRadar_Strings["Alchemy"] = "Alchimie"
   RecipeRadar_Strings["Blacksmithing"] = "Forge"
   RecipeRadar_Strings["Cooking"] = "Cuisine"
   RecipeRadar_Strings["Enchanting"] = "Enchantement"
   RecipeRadar_Strings["Engineering"] = "Ingénierie"
   RecipeRadar_Strings["First Aid"] = "Secourisme"
   RecipeRadar_Strings["Fishing"] = "Pêche"
   RecipeRadar_Strings["Jewelcrafting"] = "Joaillerie"
   RecipeRadar_Strings["Leatherworking"] = "Travail du cuir"
   RecipeRadar_Strings["Tailoring"] = "Couture"
   RecipeRadar_Strings["Professions"] = "Métiers"
   RecipeRadar_Strings["Already Known (Alts)"] = "Déjà Connu (Alts)"
   RecipeRadar_Strings["Already Known (Player)"] = "Déjà Connu (Joueur)"
   RecipeRadar_Strings["Available Now (Alts)"] = "Disponible Maintenant (Alts)"
   RecipeRadar_Strings["Available Now (Player)"] = "Disponible Maintenant (Joueur) "
   RecipeRadar_Strings["Future Prospect (Alts)"] = "Bientôt disponible (Alts)"
   RecipeRadar_Strings["Future Prospect (Player)"] = "Bientôt disponible (Joueur)"
   RecipeRadar_Strings["Inapplicable"] = "Innaplicable"
   RecipeRadar_Strings["Availability"] = "Disponibilité"
   RecipeRadar_Strings["Already Known By:"] = "Déjà Connu Par:"
   RecipeRadar_Strings["Future Prospect For:"] = "Bientôt disponible pour:"
   RecipeRadar_Strings["Available For:"] = "Disponible Pour:"
   RecipeRadar_Strings["%d of %d"] = "%d de %d"
   RecipeRadar_Strings["Quest"] = "Quête"
   RecipeRadar_Strings["Roving"] = "Boudinage"
   RecipeRadar_Strings["Seasonal"] = "Saisonnier"
   RecipeRadar_Strings["%s Vendor"] = "%s Marchand"
   RecipeRadar_Strings["Shattered Sun Offensive"] = "Opération Soleil brisé"
   RecipeRadar_Strings["Ashtongue Deathsworn"] = "Ligemort cendrelangue"
   RecipeRadar_Strings["Cenarion Circle"] = "Le Cercle de Cenarius"
   RecipeRadar_Strings["Cenarion Expedition"] = "Expédition cénarienne"
   RecipeRadar_Strings["Honor Hold"] = "Bastion de l'Honneur"
   RecipeRadar_Strings["Keepers of Time"] = "Gardiens du Temps"
   RecipeRadar_Strings["Lower City"] = "Ville basse"
   RecipeRadar_Strings["The Aldor"] = "L'Aldor"
   RecipeRadar_Strings["The Consortium"] = "Le Consortium"
   RecipeRadar_Strings["The Mag'har"] = "Mag'har"
   RecipeRadar_Strings["The Scale of the Sands"] = "L'écaille des sables"
   RecipeRadar_Strings["The Scryers"] = "Les Clairvoyants"
   RecipeRadar_Strings["The Sha'tar"] = "Les Sha'tar"
   RecipeRadar_Strings["The Violet Eye"] = "L'Œil pourpre"
   RecipeRadar_Strings["Thorium Brotherhood"] = "La Confrérie du thorium"
   RecipeRadar_Strings["Timbermaw Hold"] = "Furbolgs Timbermaw"
   RecipeRadar_Strings["Zandalar Tribe"] = "Fournitures et réparations Zandalar"
   RecipeRadar_Strings["Argent Dawn"] = "L'Aube d'argent"
   RecipeRadar_Strings["Rogue"] = "Voleur"
   RecipeRadar_Strings["Special"] = "Spécial"
   RecipeRadar_Strings["%s Only"] = "%s Seulement"
   RecipeRadar_Strings["Collapse"] = "Réduire"
   RecipeRadar_Strings["Collapse All"] = "Réduire Tout"
   RecipeRadar_Strings["Expand"] = "Etendre"
   RecipeRadar_Strings["Expand All"] = "Etendre Tout"
   RecipeRadar_Strings["Map Vendor"] = "Indique la position du marchand sur la carte"
   RecipeRadar_Strings["Unmap Vendor"] = "Enlevez Marchand"
   RecipeRadar_Strings["Armorsmith"] = "Fabricant d'armures"
   RecipeRadar_Strings["Dragonscale Leatherworking"] = "Travail du cuir d'écailles de dragon"
   RecipeRadar_Strings["Elemental Leatherworking"] = "Travail du cuir élémentaire"
   RecipeRadar_Strings["Goblin Engineer"] = "Ingénieur gobelin"
   RecipeRadar_Strings["Master Axesmith"] = "Maître fabricant de haches"
   RecipeRadar_Strings["Master Hammersmith"] = "Maître Fabricant de marteaux"
   RecipeRadar_Strings["Master Swordsmith"] = "Maître Fabricant d'épées"
   RecipeRadar_Strings["Tribal Leatherworking"] = "Travail du cuir tribal"
   RecipeRadar_Strings["Weaponsmith"] = "Fabricant d'armes"
   RecipeRadar_Strings["Gnomish Engineer"] = "Ingénieur gnome"
   RecipeRadar_Strings["Eastern Kingdoms"] = "Royaumes de l'est"

   RecipeRadar_Strings["Alterac Mountains"] = "Montagnes d'Alterac"
   RecipeRadar_Strings["Arathi Highlands"] = "Hautes-terres d'Arathi"
   RecipeRadar_Strings["Ashenvale"] = "Orneval"
   RecipeRadar_Strings["Azuremyst Isle"] = "Ile de Brume-azur"
   RecipeRadar_Strings["Badlands"] = "Terres ingrates"
   RecipeRadar_Strings["Blackrock Depths"] = "Profondeurs de Rochenoire"
   RecipeRadar_Strings["Blade's Edge Mountains"] = "Les Tranchantes"
   RecipeRadar_Strings["Blasted Lands"] = "Terres foudroyées"
   RecipeRadar_Strings["Bloodmyst Isle"] = "Ile de Brume-sang"
   RecipeRadar_Strings["Burning Steppes"] = "Steppes ardentes"
   RecipeRadar_Strings["Darkshore"] = "Sombrivage"
   RecipeRadar_Strings["Deadwind Pass"] = "Défilé de Deuillevent"
   RecipeRadar_Strings["Desolace"] = "Désolace"
   RecipeRadar_Strings["Dire Maul"] = "Hache-Tripes"
   RecipeRadar_Strings["Duskwood"] = "Bois de la Pénombre"
   RecipeRadar_Strings["Dustwallow Marsh"] = "Marécage d'Âprefange"
   RecipeRadar_Strings["Eastern Plaguelands"] = "Maleterres de l'est"
   RecipeRadar_Strings["Elwynn Forest"] = "Forêt d'Elwynn"
   RecipeRadar_Strings["Eversong Woods"] = "Bois des Chants éternels"
   RecipeRadar_Strings["Felwood"] = "Gangrebois"
   RecipeRadar_Strings["Feralas"] = "Féralas"
   RecipeRadar_Strings["Ghostlands"] = "Les Terres fantômes"
   RecipeRadar_Strings["Hellfire Peninsula"] = "Péninsule des Flammes infernales"
   RecipeRadar_Strings["Hillsbrad Foothills"] = "Contreforts de Hautebrande"
   RecipeRadar_Strings["Ironforge"] = "Forgefer"
   RecipeRadar_Strings["Moonglade"] = "Reflet-de-Lune"
   RecipeRadar_Strings["Netherstorm"] = "Raz-de-Néant"
   RecipeRadar_Strings["Redridge Mountains"] = "Les Carmines"
   RecipeRadar_Strings["Ruins of Ahn'Qiraj"] = "Ruines d'Ahn'Qiraj"
   RecipeRadar_Strings["Shadowmoon Valley"] = "Vallée d'Ombrelune"
   RecipeRadar_Strings["Shattrath City"] = "Shattrath"
   RecipeRadar_Strings["Silvermoon City"] = "Lune-d'argent"
   RecipeRadar_Strings["Silverpine Forest"] = "Forêt des Pins argentés"
   RecipeRadar_Strings["Stonetalon Mountains"] = "Les Serres-Rocheuses"
   RecipeRadar_Strings["Stormwind City"] = "Hurlevent"
   RecipeRadar_Strings["Stranglethorn Vale"] = "Vallée de Strangleronce"
   RecipeRadar_Strings["Swamp of Sorrows"] = "Marais des Chagrins"
   RecipeRadar_Strings["Terokkar Forest"] = "Forêt de Terokkar"
   RecipeRadar_Strings["The Barrens"] = "Les Tarides"
   RecipeRadar_Strings["The Exodar"] = "L'Exodar"
   RecipeRadar_Strings["The Hinterlands"] = "Les Hinterlands"
   RecipeRadar_Strings["Thousand Needles"] = "Mille pointes"
   RecipeRadar_Strings["Thunder Bluff"] = "Les Pitons du Tonnerre"
   RecipeRadar_Strings["Tirisfal Glades"] = "Clairières de Tirisfal"
   RecipeRadar_Strings["Undercity"] = "Fossoyeuse"
   RecipeRadar_Strings["Un'Goro Crater"] = "Cratère d'Un'Goro"
   RecipeRadar_Strings["Wailing Caverns"] = "Cavernes des lamentations"
   RecipeRadar_Strings["Western Plaguelands"] = "Maleterres de l'ouest"
   RecipeRadar_Strings["Westfall"] = "Marche de l'Ouest"
   RecipeRadar_Strings["Wetlands"] = "Les Paluns"
   RecipeRadar_Strings["Winterspring"] = "Berceau-de-l'Hiver"
   RecipeRadar_Strings["Zangarmarsh"] = "Marécage de Zangar"

   RecipeRadar_Strings["\"Cookie\" McWeaksauce"] = "\"Cuistot\" McFadesauce"
   RecipeRadar_Strings["Aendel Windspear"] = "Aendel Lancevent"
   RecipeRadar_Strings["Aged Dalaran Wizard"] = "Sorcier de Dalaran âgé"
   RecipeRadar_Strings["Alchemist Gribble"] = "Alchimiste Limnorie"
   RecipeRadar_Strings["Alchemist Pestlezugg"] = "Alchimiste Pilonzugg"
   RecipeRadar_Strings["Andrion Darkspinner"] = "Andrion Sombrefileur"
   RecipeRadar_Strings["Apothecary Antonivich"] = "Apothicaire Antonivitch"
   RecipeRadar_Strings["Apprentice Darius"] = "Apprenti Darius"
   RecipeRadar_Strings["Argent Quartermaster Hasana"] = "Intendante de l'Aube d'argent Hasana"
   RecipeRadar_Strings["Argent Quartermaster Lightspark"] = "Intendant de l'Aube d'argent Feuzopoudre"
   RecipeRadar_Strings["Blimo Gadgetspring"] = "Blimo Gadgettaressort"
   RecipeRadar_Strings["Blixrez Goodstitch"] = "Blixrez Beaupiqué"
   RecipeRadar_Strings["Blizrik Buckshot"] = "Blizrik Chevrotine"
   RecipeRadar_Strings["Bombus Finespindle"] = "Bombus Finfuseau"
   RecipeRadar_Strings["Brienna Starglow"] = "Brienna Luisétoile"
   RecipeRadar_Strings["Bro'kin"] = "Fra'kas"
   RecipeRadar_Strings["Burbik Gearspanner"] = "Burbik Clépharnaüm"
   RecipeRadar_Strings["Captured Gnome"] = "Gnome capturé"
   RecipeRadar_Strings["Cookie One-Eye"] = "Qu'un-œil le cuistot"
   RecipeRadar_Strings["Corporal Bluth"] = "Caporal Bluth"
   RecipeRadar_Strings["Cowardly Crosby"] = "Crosby la Trouille"
   RecipeRadar_Strings["Cro Threadstrong"] = "Cro Fermefil"
   RecipeRadar_Strings["Daggle Ironshaper"] = "Détrempe Sculptefer"
   RecipeRadar_Strings["Danielle Zipstitch"] = "Danielle Vivaiguille"
   RecipeRadar_Strings["Dealer Malij"] = "Camelot Malij"
   RecipeRadar_Strings["Defias Profiteer"] = "Profiteur défias"
   RecipeRadar_Strings["Derak Nightfall"] = "Derak Crépuscule"
   RecipeRadar_Strings["Dirge Quikcleave"] = "Dirge Hachillico"
   RecipeRadar_Strings["Drac Roughcut"] = "Drac Taillebrute"
   RecipeRadar_Strings["Drovnar Strongbrew"] = "Drovnar Fortebière"
   RecipeRadar_Strings["Fedryen Swiftspear"] = "Fedryen Vivelance"
   RecipeRadar_Strings["Fradd Swiftgear"] = "Fradd Vifembraye"
   RecipeRadar_Strings["Gagsprocket"] = "Muserouage"
   RecipeRadar_Strings["Gearcutter Cogspinner"] = "Coupebraquet Tournepignon"
   RecipeRadar_Strings["Gidge Spellweaver"] = "Gidge Tisse-sort"
   RecipeRadar_Strings["Gigget Zipcoil"] = "Giguette Filebobine"
   RecipeRadar_Strings["Glyx Brewright"] = "Glyx Bonbouilleur"
   RecipeRadar_Strings["Gnaz Blunderflame"] = "Gnaz Bourdeflamme"
   RecipeRadar_Strings["Harklan Moongrove"] = "Harklan Bosquelune"
   RecipeRadar_Strings["Harlon Thornguard"] = "Harlon Garderonce"
   RecipeRadar_Strings["Harlown Darkweave"] = "Harlown Tisselombre"
   RecipeRadar_Strings["Harn Longcast"] = "Harn Jette-loin"
   RecipeRadar_Strings["Heldan Galesong"] = "Heldan Chantetrombe"
   RecipeRadar_Strings["Innkeeper Biribi"] = "Aubergiste Biribi"
   RecipeRadar_Strings["Innkeeper Fizzgrimble"] = "Aubergiste Rouspétille"
   RecipeRadar_Strings["Innkeeper Grilka"] = "Aubergiste Grilka"
   RecipeRadar_Strings["Jangdor Swiftstrider"] = "Jangdor Rôdeur-agile"
   RecipeRadar_Strings["Jannos Ironwill"] = "Jannos Volonté-de-fer"
   RecipeRadar_Strings["Jennabink Powerseam"] = "Jennabink Doublepiqûre"
   RecipeRadar_Strings["Jim Saltit"] = "Jim Poivressel"
   RecipeRadar_Strings["Jinky Twizzlefixxit"] = "Jinky Rafistépingle"
   RecipeRadar_Strings["Jubie Gadgetspring"] = "Jubie Gadgettaressort"
   RecipeRadar_Strings["Kaita Deepforge"] = "Kaita Forge-profonde"
   RecipeRadar_Strings["Kalldan Felmoon"] = "Kalldan Gangrelune"
   RecipeRadar_Strings["Khara Deepwater"] = "Khara Eau-profonde"
   RecipeRadar_Strings["Kiknikle"] = "Piéniklé"
   RecipeRadar_Strings["Knaz Blunderflame"] = "Knaz Bourdeflamme"
   RecipeRadar_Strings["Krek Cragcrush"] = "Krek Cassecombe"
   RecipeRadar_Strings["Krinkle Goodsteel"] = "Froisse Bonnacier"
   RecipeRadar_Strings["Leeli Longhaggle"] = "Leeli Longnégoce"
   RecipeRadar_Strings["Lieutenant General Andorov"] = "Général de division Andorov"
   RecipeRadar_Strings["Logistics Officer Ulrike"] = "Officier de logistique Ulrike"
   RecipeRadar_Strings["Lokhtos Darkbargainer"] = "Lokhtos Sombrescompte"
   RecipeRadar_Strings["Lorelae Wintersong"] = "Lorelae Chante-hiver"
   RecipeRadar_Strings["Mallen Swain"] = "Mallen Legallant"
   RecipeRadar_Strings["Mari Stonehand"] = "Mari Main-de-pierre"
   RecipeRadar_Strings["Master Chef Mouldier"] = "Maître cuisinier Mouldier"
   RecipeRadar_Strings["Master Craftsman Omarion"] = "Maître-artisan Omarion"
   RecipeRadar_Strings["Mazk Snipeshot"] = "Mazk Tiraubut"
   RecipeRadar_Strings["Mixie Farshot"] = "Mixie Vise-loin"
   RecipeRadar_Strings["Muheru the Weaver"] = "Muheru le Tisserand"
   RecipeRadar_Strings["Naal Mistrunner"] = "Naal Cours-la-brume"
   RecipeRadar_Strings["Namdo Bizzfizzle"] = "Namdo Ventaperte"
   RecipeRadar_Strings["Narj Deepslice"] = "Narj Tranchefond"
   RecipeRadar_Strings["Nasmara Moonsong"] = "Nasmara Lunechant"
   RecipeRadar_Strings["Nata Dawnstrider"] = "Nata Aube-glorieuse"
   RecipeRadar_Strings["Nessa Shadowsong"] = "Nessa Chantelombre"
   RecipeRadar_Strings["Nina Lightbrew"] = "Nina Bouillelume"
   RecipeRadar_Strings["Nula the Butcher"] = "Nula le Boucher"
   RecipeRadar_Strings["Old Man Heming"] = "Vieil Heming"
   RecipeRadar_Strings["Outfitter Eric"] = "Eric le tailleur"
   RecipeRadar_Strings["Plugger Spazzring"] = "Lanfiche Brouillecircuit"
   RecipeRadar_Strings["Provisioner Nasela"] = "Approvisionneur Nasela"
   RecipeRadar_Strings["Quartermaster Endarin"] = "Intendant Endarin"
   RecipeRadar_Strings["Quartermaster Enuril"] = "Intendant Enuril"
   RecipeRadar_Strings["Quartermaster Miranda Breechlock"] = "Intendante Miranda Coinceculasse"
   RecipeRadar_Strings["Quartermaster Urgronn"] = "Intendant Urgronn"
   RecipeRadar_Strings["Rann Flamespinner"] = "Rann Tisseflamme"
   RecipeRadar_Strings["Rin'wosho the Trader"] = "Rin'wosho le marchand"
   RecipeRadar_Strings["Rizz Loosebolt"] = "Rizz Court-boulon"
   RecipeRadar_Strings["Ruppo Zipcoil"] = "Ruppo Filebobine"
   RecipeRadar_Strings["Seer Janidi"] = "Prophète Janidi"
   RecipeRadar_Strings["Sewa Mistrunner"] = "Sewa Cours-la-brume"
   RecipeRadar_Strings["Shadi Mistrunner"] = "Shadi Cours-la-brume"
   RecipeRadar_Strings["Sheendra Tallgrass"] = "Sheendra Hautes-herbes"
   RecipeRadar_Strings["Shen'dralar Provisioner"] = "Approvisionneur Shen'dralar"
   RecipeRadar_Strings["Sheri Zipstitch"] = "Sheri Vivaiguille"
   RecipeRadar_Strings["Smudge Thunderwood"] = "Smudge Tonnebois"
   RecipeRadar_Strings["Soolie Berryfizz"] = "Soolie Baiedesbulles"
   RecipeRadar_Strings["Super-Seller 680"] = "Super-Vendeur 680"
   RecipeRadar_Strings["Supply Officer Mills"] = "Officier de ravitaillement Mills"
   RecipeRadar_Strings["Tansy Puddlefizz"] = "Tansy Flaquabulle"
   RecipeRadar_Strings["Tarban Hearthgrain"] = "Tarban Blé-du-foyer"
   RecipeRadar_Strings["Tilli Thistlefuzz"] = "Tilli Duvechardon"
   RecipeRadar_Strings["Trader Narasu"] = "Marchand Nasaru"
   RecipeRadar_Strings["Truk Wildbeard"] = "Truk Barbe-hirsute"
   RecipeRadar_Strings["Vendor-Tron 1000"] = "Vendeur-o-tron 1000"
   RecipeRadar_Strings["Viggz Shinesparked"] = "Viggz Fibriller"
   RecipeRadar_Strings["Wenna Silkbeard"] = "Wenna Barbe-de-soie"
   RecipeRadar_Strings["Werg Thickblade"] = "Werg Largelame"
   RecipeRadar_Strings["Wind Trader Lathrai"] = "Marchand des vents Lathrai"
   RecipeRadar_Strings["Worb Strongstitch"] = "Worb Point-solide"
   RecipeRadar_Strings["Wunna Darkmane"] = "Wunna Sombre-crin"
   RecipeRadar_Strings["Xandar Goodbeard"] = "Xandar Bonnebarbe"
   RecipeRadar_Strings["Xizk Goodstitch"] = "Xizk Beaupiqué"
   RecipeRadar_Strings["Xizzer Fizzbolt"] = "Xizzer Klaqueboulon"
   RecipeRadar_Strings["Yurial Soulwater"] = "Yurial Âmeflot"
   RecipeRadar_Strings["Zan Shivsproket"] = "Zan Tympeustache"
   RecipeRadar_Strings["Zannok Hidepiercer"] = "Zannok Percecuir"

end

if (GetLocale() == "esES") then

   RecipeRadar_Strings["Toggle Recipe Radar"] = "Barra de Recipe Radar"
   RecipeRadar_Strings["Auto-map Contributive Vendors"] = "Recetas Disponibles de la Exhibición"
   RecipeRadar_Strings["Auto-select Current Region"] = "Auto-seleccionar la región actual"
   RecipeRadar_Strings["Check Availability for Alts"] = "Comprobar la disponibilidad en Alts"
   RecipeRadar_Strings["Minimap Button Position"] = "Posición del Icono"
   RecipeRadar_Strings["Show Minimap Button"] = "Mostrar botón en el Minimapa"
   RecipeRadar_Strings["Options"] = "Opciones"
   RecipeRadar_Strings["%d learnable"] = "%d disponible"
   RecipeRadar_Strings["%d recipes"] = "%d recetas"
   RecipeRadar_Strings["1 recipe"] = "1 receta"
   RecipeRadar_Strings["Uncached Recipe"] = "Receta no descargada"
   RecipeRadar_Strings["You may mouse over the [?]"] = "Puede colocar el ratón sobre la [?]"
   RecipeRadar_Strings["icon to lookup this recipe."] = "para buscar la receta en el servidor."
   RecipeRadar_Strings["Warning: if your server has"] = "Advertencia: ¡si tu servidor"
   RecipeRadar_Strings["not yet seen this item, you"] = "todavía no dispone de este"
   RecipeRadar_Strings["will be disconnected!"] = "artículo, te desconectarán!"
   RecipeRadar_Strings["No recipes for sale in this region."] = "No hay recetas para la venta en esta región."
   RecipeRadar_Strings["Shift-click a vendor to add or remove her location on the world map."] = "Haz Shift+Click en un vendedor para agregar o quitar su localización en el mapa del mundo."
   RecipeRadar_Strings["Locate Vendor on Map"] = "Localizar a Vendedor en Mapa"
   RecipeRadar_Strings["Factions"] = "Bandos"
   RecipeRadar_Strings["Alchemy"] = "Alquimia"
   RecipeRadar_Strings["Blacksmithing"] = "Herrería"
   RecipeRadar_Strings["Cooking"] = "Cocina"
   RecipeRadar_Strings["Enchanting"] = "Encantamiento"
   RecipeRadar_Strings["Engineering"] = "Ingeniería"
   RecipeRadar_Strings["First Aid"] = "Primeros auxilios"
   RecipeRadar_Strings["Fishing"] = "Pesca"
   RecipeRadar_Strings["Jewelcrafting"] = "Joyería"
   RecipeRadar_Strings["Leatherworking"] = "Peletería"
   RecipeRadar_Strings["Tailoring"] = "Sastrería"
   RecipeRadar_Strings["Professions"] = "Profesiones"
   RecipeRadar_Strings["Already Known (Alts)"] = "Ya conocido (Alts)"
   RecipeRadar_Strings["Already Known (Player)"] = "Ya conocido (Jugador)"
   RecipeRadar_Strings["Available Now (Alts)"] = "Disponible (Alts)"
   RecipeRadar_Strings["Available Now (Player)"] = "Disponible (Jugador)"
   RecipeRadar_Strings["Future Prospect (Alts)"] = "Perspectiva Futura (Alts)"
   RecipeRadar_Strings["Future Prospect (Player)"] = "Perspectiva Futura (Jugador)"
   RecipeRadar_Strings["Inapplicable"] = "Inaplicable"
   RecipeRadar_Strings["Availability"] = "Disponibilidad"
   RecipeRadar_Strings["Already Known By:"] = "Ya conocido por:"
   RecipeRadar_Strings["Future Prospect For:"] = "Perspectiva futura para:"
   RecipeRadar_Strings["Available For:"] = "Disponible para:"
   RecipeRadar_Strings["%d of %d"] = "%d de %d"
   RecipeRadar_Strings["Intermittent"] = "Intermitente"
   RecipeRadar_Strings["Quest"] = "Misión"
   RecipeRadar_Strings["Roving"] = "Ambulante"
   RecipeRadar_Strings["Seasonal"] = "Estacional"
   RecipeRadar_Strings["%s Vendor"] = "%s Vendedor"
   RecipeRadar_Strings["Shattered Sun Offensive"] = "Ofensiva Sol Devastado"
   RecipeRadar_Strings["Ashtongue Deathsworn"] = "Juramorte Lengua de ceniza"
   RecipeRadar_Strings["Cenarion Circle"] = "El Círculo Cenarion"
   RecipeRadar_Strings["Cenarion Expedition"] = "Expedición Cenarion"
   RecipeRadar_Strings["Honor Hold"] = "Bastión del Honor"
   RecipeRadar_Strings["Keepers of Time"] = "Guardianes del Tiempo"
   RecipeRadar_Strings["The Consortium"] = "El consorcio"
   RecipeRadar_Strings["The Mag'har"] = "El Mag’har"
   RecipeRadar_Strings["The Scale of the Sands"] = "Escama de las Arenas"
   RecipeRadar_Strings["The Scryers"] = "Los Arúspices"
   RecipeRadar_Strings["The Sha'tar"] = "El Sha’tar"
   RecipeRadar_Strings["The Violet Eye"] = "El Ojo Violeta"
   RecipeRadar_Strings["Thorium Brotherhood"] = "La Hermandad del Torio"
   RecipeRadar_Strings["Zandalar Tribe"] = "Tribu de Zandalar"
   RecipeRadar_Strings["Argent Dawn"] = "El Alba Argenta"
   RecipeRadar_Strings["Rogue"] = "Pícaro"
   RecipeRadar_Strings["Special"] = "Especial"
   RecipeRadar_Strings["%s Only"] = "%s Sólamente"
   RecipeRadar_Strings["Collapse"] = "Contraer"
   RecipeRadar_Strings["Collapse All"] = "Contraer Todos"
   RecipeRadar_Strings["Expand"] = "Ampliar"
   RecipeRadar_Strings["Expand All"] = "Ampliar Todos"
   RecipeRadar_Strings["Map Vendor"] = "Marcar a Vendedor"
   RecipeRadar_Strings["Unmap Vendor"] = "Quitar a vendedor"
   RecipeRadar_Strings["Goblin Engineer"] = "Ingeniero goblin"
   RecipeRadar_Strings["Gnomish Engineer"] = "Ingeniero gnomo"
   RecipeRadar_Strings["Eastern Kingdoms"] = "Reinos del Este"
   RecipeRadar_Strings["Instances"] = "Instancias"

   RecipeRadar_Strings["Alterac Mountains"] = "Montañas de Alterac"
   RecipeRadar_Strings["Arathi Highlands"] = "Tierras Altas de Arathi"
   RecipeRadar_Strings["Ashenvale"] = "Vallefresno"
   RecipeRadar_Strings["Azuremyst Isle"] = "Isla Bruma Azur"
   RecipeRadar_Strings["Badlands"] = "Tierras Inhóspitas"
   RecipeRadar_Strings["Blackrock Depths"] = "Profundidades de Roca Negra"
   RecipeRadar_Strings["Blade's Edge Mountains"] = "Montañas Filospada"
   RecipeRadar_Strings["Blasted Lands"] = "Las Tierras Devastadas"
   RecipeRadar_Strings["Bloodmyst Isle"] = "Isla Bruma de Sangre"
   RecipeRadar_Strings["Burning Steppes"] = "Las Estepas Ardientes"
   RecipeRadar_Strings["Darkshore"] = "Costa Oscura"
   RecipeRadar_Strings["Deadwind Pass"] = "Paso de la Muerte"
   RecipeRadar_Strings["Dire Maul"] = "La Masacre"
   RecipeRadar_Strings["Duskwood"] = "Bosque del Ocaso"
   RecipeRadar_Strings["Dustwallow Marsh"] = "Marjal Revolcafango"
   RecipeRadar_Strings["Eastern Plaguelands"] = "Tierras de la Peste del Este"
   RecipeRadar_Strings["Elwynn Forest"] = "Bosque de Elwynn"
   RecipeRadar_Strings["Eversong Woods"] = "Bosque Canción Eterna"
   RecipeRadar_Strings["Felwood"] = "Frondavil"
   RecipeRadar_Strings["Ghostlands"] = "Tierras Fantasma"
   RecipeRadar_Strings["Hellfire Peninsula"] = "Península del Fuego Infernal"
   RecipeRadar_Strings["Hillsbrad Foothills"] = "Laderas de Trabalomas"
   RecipeRadar_Strings["Ironforge"] = "Forjaz"
   RecipeRadar_Strings["Moonglade"] = "Claro de la Luna"
   RecipeRadar_Strings["Netherstorm"] = "Tormenta Abisal"
   RecipeRadar_Strings["Redridge Mountains"] = "Montañas Crestagrana"
   RecipeRadar_Strings["Ruins of Ahn'Qiraj"] = "Ruinas de Ahn'Qiraj"
   RecipeRadar_Strings["Shadowmoon Valley"] = "Valle de Sombraluna"
   RecipeRadar_Strings["Shattrath City"] = "Ciudad de Shattrath"
   RecipeRadar_Strings["Silvermoon City"] = "Lunargenta"
   RecipeRadar_Strings["Silverpine Forest"] = "Bosque de Argénteos"
   RecipeRadar_Strings["Stonetalon Mountains"] = "Sierra Espolón"
   RecipeRadar_Strings["Stormwind City"] = "Ciudad de Ventormenta"
   RecipeRadar_Strings["Stranglethorn Vale"] = "Vega de Tuercespina"
   RecipeRadar_Strings["Swamp of Sorrows"] = "Pantano de las Penas"
   RecipeRadar_Strings["Terokkar Forest"] = "Bosque de Terokkar"
   RecipeRadar_Strings["The Barrens"] = "Los Baldíos"
   RecipeRadar_Strings["The Exodar"] = "El Exodar"
   RecipeRadar_Strings["The Hinterlands"] = "Tierras del Interior"
   RecipeRadar_Strings["Thousand Needles"] = "Las Mil Agujas"
   RecipeRadar_Strings["Thunder Bluff"] = "Cima del Trueno"
   RecipeRadar_Strings["Tirisfal Glades"] = "Claros de Tirisfal"
   RecipeRadar_Strings["Undercity"] = "Entrañas"
   RecipeRadar_Strings["Un'Goro Crater"] = "Cráter de Un'Goro"
   RecipeRadar_Strings["Wailing Caverns"] = "Cuevas de los Lamentos"
   RecipeRadar_Strings["Western Plaguelands"] = "Tierras de la Peste del Oeste"
   RecipeRadar_Strings["Westfall"] = "Páramos de Poniente"
   RecipeRadar_Strings["Wetlands"] = "Los Humedales"
   RecipeRadar_Strings["Winterspring"] = "Cuna del Invierno"
   RecipeRadar_Strings["Zangarmarsh"] = "Marisma de Zangar"

   RecipeRadar_Strings["\"Cookie\" McWeaksauce"] = "\"Cocinitas\" McSalsafloja"
   RecipeRadar_Strings["Aendel Windspear"] = "Aendel Lanzavento"
   RecipeRadar_Strings["Alchemist Gribble"] = "Alquimista Gribble"
   RecipeRadar_Strings["Alchemist Pestlezugg"] = "Alquimista Morterozugg"
   RecipeRadar_Strings["Andrion Darkspinner"] = "Andrion Giroscuro"
   RecipeRadar_Strings["Argent Quartermaster Hasana"] = "Intendente Argenta Hasana"
   RecipeRadar_Strings["Argent Quartermaster Lightspark"] = "Intendente Argenta Destelllo de Luz"
   RecipeRadar_Strings["Bale"] = "Fardo"
   RecipeRadar_Strings["Banalash"] = "Banatralla"
   RecipeRadar_Strings["Blixrez Goodstitch"] = "Blixrez Cortefino"
   RecipeRadar_Strings["Blizrik Buckshot"] = "Blizrik Machobala"
   RecipeRadar_Strings["Bombus Finespindle"] = "Bombus Bueneje"
   RecipeRadar_Strings["Brienna Starglow"] = "Brienna Brillastrella"
   RecipeRadar_Strings["Burbik Gearspanner"] = "Burbik Trazagranaje"
   RecipeRadar_Strings["Christoph Jeffcoat"] = "Christoph Yabrigo"
   RecipeRadar_Strings["Constance Brisboise"] = "Constanza Brisboise"
   RecipeRadar_Strings["Cookie One-Eye"] = "Listillo el Tuerto"
   RecipeRadar_Strings["Corporal Bluth"] = "Cabo Bluth"
   RecipeRadar_Strings["Cowardly Crosby"] = "Blandengue Crosby"
   RecipeRadar_Strings["Crazk Sparks"] = "Craz Chispaz"
   RecipeRadar_Strings["Cro Threadstrong"] = "Cro Hilofuerte"
   RecipeRadar_Strings["Daggle Ironshaper"] = "Afilador Daggle"
   RecipeRadar_Strings["Danielle Zipstitch"] = "Danielle Puntillas"
   RecipeRadar_Strings["Dealer Malij"] = "Tratante Malij"
   RecipeRadar_Strings["Defias Profiteer"] = "Especulador Defias"
   RecipeRadar_Strings["Deneb Walker"] = "Deneb Camino"
   RecipeRadar_Strings["Derak Nightfall"] = "Derak Ocaso"
   RecipeRadar_Strings["Dirge Quikcleave"] = "Dirge Hojágil"
   RecipeRadar_Strings["Drake Lindgren"] = "Draco Lindgren"
   RecipeRadar_Strings["Drovnar Strongbrew"] = "Drovanar Brevaforte"
   RecipeRadar_Strings["Evie Whirlbrew"] = "Evie Brebegira"
   RecipeRadar_Strings["Fedryen Swiftspear"] = "Fedryen Lanzapresta"
   RecipeRadar_Strings["Fradd Swiftgear"] = "Fradd Cambioveloz"
   RecipeRadar_Strings["Gagsprocket"] = "Dentolio"
   RecipeRadar_Strings["Gearcutter Cogspinner"] = "Cortallave Volopiñón"
   RecipeRadar_Strings["Glyx Brewright"] = "Glyx Bonatrama"
   RecipeRadar_Strings["Gnaz Blunderflame"] = "Gnaz Flamerrada"
   RecipeRadar_Strings["Harklan Moongrove"] = "Harklan Arboluna"
   RecipeRadar_Strings["Harlon Thornguard"] = "Harlon Guardaspina"
   RecipeRadar_Strings["Harn Longcast"] = "Harn Tiralejo"
   RecipeRadar_Strings["Heldan Galesong"] = "Heldan Vendasón"
   RecipeRadar_Strings["Innkeeper Biribi"] = "Tabernero Biribi"
   RecipeRadar_Strings["Innkeeper Fizzgrimble"] = "Tabernero Fizzgrimble"
   RecipeRadar_Strings["Jangdor Swiftstrider"] = "Jangdor Zancoveloz"
   RecipeRadar_Strings["Jannos Ironwill"] = "Jannos Dolocerado"
   RecipeRadar_Strings["Jennabink Powerseam"] = "Jennabink Costura Potente"
   RecipeRadar_Strings["Jinky Twizzlefixxit"] = "Jinky Arreglatodo"
   RecipeRadar_Strings["Kaita Deepforge"] = "Kaita Forjahonda"
   RecipeRadar_Strings["Kalldan Felmoon"] = "Kalldan Lunavil"
   RecipeRadar_Strings["Khara Deepwater"] = "Khara Aguahonda"
   RecipeRadar_Strings["Khole Jinglepocket"] = "Khole Calderilla"
   RecipeRadar_Strings["Krek Cragcrush"] = "Krek Peñazo"
   RecipeRadar_Strings["Krinkle Goodsteel"] = "Krinkle Buenacero"
   RecipeRadar_Strings["Leeli Longhaggle"] = "Leeli Regateo"
   RecipeRadar_Strings["Lieutenant General Andorov"] = "Teniente General Andorov"
   RecipeRadar_Strings["Lizbeth Cromwell"] = "Lizbeth Cromaljibe"
   RecipeRadar_Strings["Logistics Officer Ulrike"] = "Oficial de logística Ulrike"
   RecipeRadar_Strings["Lokhtos Darkbargainer"] = "Lokhtos Tratoscuro"
   RecipeRadar_Strings["Lorelae Wintersong"] = "Lorelae Cantinvernal"
   RecipeRadar_Strings["Mari Stonehand"] = "Mari Petramano"
   RecipeRadar_Strings["Master Chef Mouldier"] = "Maestro cocinero Mouldier"
   RecipeRadar_Strings["Master Craftsman Omarion"] = "Maestro artesano Omarion"
   RecipeRadar_Strings["Mazk Snipeshot"] = "Mazk Tirocertero"
   RecipeRadar_Strings["Muheru the Weaver"] = "Muheru el Tejedor"
   RecipeRadar_Strings["Naal Mistrunner"] = "Naal Correbruma"
   RecipeRadar_Strings["Namdo Bizzfizzle"] = "Namdo Silvabín"
   RecipeRadar_Strings["Nardstrum Copperpinch"] = "Nardstrum Cobrellizco"
   RecipeRadar_Strings["Narj Deepslice"] = "Narj Tajofondo"
   RecipeRadar_Strings["Nata Dawnstrider"] = "Nata Caminalba"
   RecipeRadar_Strings["Nessa Shadowsong"] = "Nessa Cantosombrío"
   RecipeRadar_Strings["Nina Lightbrew"] = "Nina Burbuluz"
   RecipeRadar_Strings["Old Man Heming"] = "Viejo Heming"
   RecipeRadar_Strings["Outfitter Eric"] = "Proveedor Eric"
   RecipeRadar_Strings["Penney Copperpinch"] = "Penney Cobrellizco"
   RecipeRadar_Strings["Plugger Spazzring"] = "Plugger Aropatoso"
   RecipeRadar_Strings["Quartermaster Endarin"] = "Intendente Endarin"
   RecipeRadar_Strings["Quartermaster Enuril"] = "Intendente Enuril"
   RecipeRadar_Strings["Quartermaster Miranda Breechlock"] = "Intendente Cerrobrecha"
   RecipeRadar_Strings["Quartermaster Urgronn"] = "Intendente Urgronn"
   RecipeRadar_Strings["Rann Flamespinner"] = "Rann Flamejes"
   RecipeRadar_Strings["Rathis Tomber"] = "Rathis Tumbero"
   RecipeRadar_Strings["Rin'wosho the Trader"] = "Rin'wosho el Mercader"
   RecipeRadar_Strings["Rizz Loosebolt"] = "Rizz Tornillosuelto"
   RecipeRadar_Strings["Seersa Copperpinch"] = "Seersa Cobrellizco"
   RecipeRadar_Strings["Sewa Mistrunner"] = "Seua Correbruma"
   RecipeRadar_Strings["Shadi Mistrunner"] = "Shadi Correbruma"
   RecipeRadar_Strings["Sheendra Tallgrass"] = "Sheendra Pastoalto"
   RecipeRadar_Strings["Shen'dralar Provisioner"] = "Proveedor Shen'dralar"
   RecipeRadar_Strings["Sheri Zipstitch"] = "Sheri Puntagueta"
   RecipeRadar_Strings["Smudge Thunderwood"] = "Smudge Truenedera"
   RecipeRadar_Strings["Soolie Berryfizz"] = "Soolie Burbubaya"
   RecipeRadar_Strings["Super-Seller 680"] = "Supervendedor 680"
   RecipeRadar_Strings["Supply Officer Mills"] = "Oficial Avituallador Mills"
   RecipeRadar_Strings["Tansy Puddlefizz"] = "Tansy Burbajea"
   RecipeRadar_Strings["Tarban Hearthgrain"] = "Tarban Granogar"
   RecipeRadar_Strings["Tilli Thistlefuzz"] = "Tilli Cardopelusa"
   RecipeRadar_Strings["Truk Wildbeard"] = "Truk Barbaje"
   RecipeRadar_Strings["Vendor-Tron 1000"] = "Vende-Tron 1000"
   RecipeRadar_Strings["Wenna Silkbeard"] = "Wenna Barbasedosa"
   RecipeRadar_Strings["Werg Thickblade"] = "Werg Filospeso"
   RecipeRadar_Strings["Wind Trader Lathrai"] = "Mercader de viento Lathrai"
   RecipeRadar_Strings["Worb Strongstitch"] = "Worb Puntofuerte"
   RecipeRadar_Strings["Wulmort Jinglepocket"] = "Wulmort Calderilla"
   RecipeRadar_Strings["Wunna Darkmane"] = "Wunna Crinoscuro"
   RecipeRadar_Strings["Xandar Goodbeard"] = "Xandar Bonbarba"
   RecipeRadar_Strings["Xizk Goodstitch"] = "Xizk Cortefino"
   RecipeRadar_Strings["Xizzer Fizzbolt"] = "Xizzer Raybuja"
   RecipeRadar_Strings["Yuka Screwspigot"] = "Yuka Llavenrosca"
   RecipeRadar_Strings["Zan Shivsproket"] = "Zan Sivadento"
   RecipeRadar_Strings["Zannok Hidepiercer"] = "Zannok Perforapieles"
   RecipeRadar_Strings["Zarena Cromwind"] = "Zarena Cromvento"
   RecipeRadar_Strings["Zorbin Fandazzle"] = "Zorbin Ventipnotizador"

end

if (GetLocale() == "zhTW") then

   RecipeRadar_Strings["Recipe Radar"] = "配方雷達"
   RecipeRadar_Strings["Toggle Recipe Radar"] = "顯示配方雷達"
   RecipeRadar_Strings["Recipe Radar Bindings"] = "配方雷達熱鍵"
   RecipeRadar_Strings["Auto-map Contributive Vendors"] = "顯示屏食譜"
   RecipeRadar_Strings["Auto-select Current Region"] = "自動選擇地區"
   RecipeRadar_Strings["Check Availability for Alts"] = "判斷分身是否可用"
   RecipeRadar_Strings["Minimap Button Position"] = "小地圖按鈕位置"
   RecipeRadar_Strings["Show Minimap Button"] = "顯示小地圖按鈕"
   RecipeRadar_Strings["Options"] = "選項"
   RecipeRadar_Strings["%d learnable"] = "%d 可學"
   RecipeRadar_Strings["%d recipes"] = "%d 配方"
   RecipeRadar_Strings["1 recipe"] = "1 配方"
   RecipeRadar_Strings["Uncached Recipe"] = "未快取的配方"
   RecipeRadar_Strings["You may mouse over the [?]"] = "可把滑鼠移到 [?]"
   RecipeRadar_Strings["icon to lookup this recipe."] = "圖示來看這個配方."
   RecipeRadar_Strings["Warning: if your server has"] = "警告: 如果妳的伺服器"
   RecipeRadar_Strings["not yet seen this item, you"] = "還沒出現過這個物品"
   RecipeRadar_Strings["will be disconnected!"] = "妳將有可能斷線!"
   RecipeRadar_Strings["No recipes for sale in this region."] = "這地區沒有配方可買"
   RecipeRadar_Strings["Shift-click a vendor to add or remove her location on the world map."] = "Shift-click 一個商人來加入或移除在世界地圖的標示."
   RecipeRadar_Strings["Locate Vendor on Map"] = "在地圖上標示商人"
   RecipeRadar_Strings["Neutral"] = "中立"
   RecipeRadar_Strings["Factions"] = "聲望"
   RecipeRadar_Strings["Alchemy"] = "煉金術"
   RecipeRadar_Strings["Blacksmithing"] = "鍛造"
   RecipeRadar_Strings["Cooking"] = "烹飪"
   RecipeRadar_Strings["Enchanting"] = "附魔"
   RecipeRadar_Strings["Engineering"] = "工程學"
   RecipeRadar_Strings["First Aid"] = "急救"
   RecipeRadar_Strings["Fishing"] = "釣魚"
   RecipeRadar_Strings["Jewelcrafting"] = "珠寶設計"
   RecipeRadar_Strings["Leatherworking"] = "製皮"
   RecipeRadar_Strings["Tailoring"] = "裁縫"
   RecipeRadar_Strings["Professions"] = "專業技能"
   RecipeRadar_Strings["Already Known (Alts)"] = "已學會 (分身)"
   RecipeRadar_Strings["Already Known (Player)"] = "已學會 (玩家)"
   RecipeRadar_Strings["Available Now (Alts)"] = "現在可學 (分身)"
   RecipeRadar_Strings["Available Now (Player)"] = "現在可學 (玩家)"
   RecipeRadar_Strings["Future Prospect (Alts)"] = "以後可學 (分身)"
   RecipeRadar_Strings["Future Prospect (Player)"] = "以後可學 (玩家)"
   RecipeRadar_Strings["Inapplicable"] = "無法學習"
   RecipeRadar_Strings["Availability"] = "可獲得性"
   RecipeRadar_Strings["Already Known By:"] = "已知:"
   RecipeRadar_Strings["Future Prospect For:"] = "以後可學會:"
   RecipeRadar_Strings["Available For:"] = "可學:"
   RecipeRadar_Strings["Quest"] = "任務"
   RecipeRadar_Strings["Roving"] = "漫遊"
   RecipeRadar_Strings["Seasonal"] = "季節性"
   RecipeRadar_Strings["%s Vendor"] = "%s 商人"
   RecipeRadar_Strings["Shattered Sun Offensive"] = "破碎之日進攻部隊"
   RecipeRadar_Strings["Ashtongue Deathsworn"] = "灰舌死亡誓言者"
   RecipeRadar_Strings["Cenarion Circle"] = "塞納里奧議會"
   RecipeRadar_Strings["Cenarion Expedition"] = "塞納里奧遠征隊"
   RecipeRadar_Strings["Honor Hold"] = "榮譽堡"
   RecipeRadar_Strings["Keepers of Time"] = "時光守衛者"
   RecipeRadar_Strings["Kurenai"] = "卡爾奈"
   RecipeRadar_Strings["Lower City"] = "陰鬱城"
   RecipeRadar_Strings["Netherwing"] = "虛空之翼"
   RecipeRadar_Strings["Sporeggar"] = "斯博格爾"
   RecipeRadar_Strings["The Aldor"] = "奧多爾"
   RecipeRadar_Strings["The Consortium"] = "聯合團"
   RecipeRadar_Strings["The Mag'har"] = "瑪格哈"
   RecipeRadar_Strings["The Scale of the Sands"] = "流沙之鱗"
   RecipeRadar_Strings["The Scryers"] = "占卜者"
   RecipeRadar_Strings["The Sha'tar"] = "薩塔"
   RecipeRadar_Strings["The Violet Eye"] = "紫羅蘭之眼"
   RecipeRadar_Strings["Thorium Brotherhood"] = "瑟銀兄弟會"
   RecipeRadar_Strings["Thrallmar"] = "索爾瑪"
   RecipeRadar_Strings["Timbermaw Hold"] = "木喉要塞"
   RecipeRadar_Strings["Zandalar Tribe"] = "贊達拉部族"
   RecipeRadar_Strings["Argent Dawn"] = "銀色黎明"
   RecipeRadar_Strings["Rogue"] = "盜賊"
   RecipeRadar_Strings["Special"] = "特殊"
   RecipeRadar_Strings["Collapse"] = "折疊"
   RecipeRadar_Strings["Collapse All"] = "折疊全部"
   RecipeRadar_Strings["Expand"] = "展開"
   RecipeRadar_Strings["Expand All"] = "展開全部"
   RecipeRadar_Strings["Armorsmith"] = "護甲鍛造師"
   RecipeRadar_Strings["Dragonscale Leatherworking"] = "龍鱗製皮"
   RecipeRadar_Strings["Elemental Leatherworking"] = "元素製皮"
   RecipeRadar_Strings["Goblin Engineer"] = "哥布林工程師"
   RecipeRadar_Strings["Master Axesmith"] = "鑄斧大師"
   RecipeRadar_Strings["Master Hammersmith"] = "鑄鎚大師"
   RecipeRadar_Strings["Master Swordsmith"] = "鑄劍大師"
   RecipeRadar_Strings["Mooncloth Tailoring"] = "月系裁縫"
   RecipeRadar_Strings["Shadoweave Tailoring"] = "暗紋裁縫"
   RecipeRadar_Strings["Spellfire Tailoring"] = "魔焰裁縫"
   RecipeRadar_Strings["Tribal Leatherworking"] = "部族製皮"
   RecipeRadar_Strings["Weaponsmith"] = "武器鑄造"
   RecipeRadar_Strings["Gnomish Engineer"] = "地精工程"
   RecipeRadar_Strings["Kalimdor"] = "卡林多"
   RecipeRadar_Strings["Eastern Kingdoms"] = "東部王國"
   RecipeRadar_Strings["Instances"] = "副本"

   RecipeRadar_Strings["Alterac Mountains"] = "奧特蘭克山脈"
   RecipeRadar_Strings["Arathi Highlands"] = "阿拉希高地"
   RecipeRadar_Strings["Ashenvale"] = "梣谷"
   RecipeRadar_Strings["Azshara"] = "艾薩拉"
   RecipeRadar_Strings["Azuremyst Isle"] = "藍謎島"
   RecipeRadar_Strings["Badlands"] = "荒蕪之地"
   RecipeRadar_Strings["Blackrock Depths"] = "黑石深淵"
   RecipeRadar_Strings["Blade's Edge Mountains"] = "劍刃山脈"
   RecipeRadar_Strings["Blasted Lands"] = "詛咒之地"
   RecipeRadar_Strings["Bloodmyst Isle"] = "血謎島"
   RecipeRadar_Strings["Burning Steppes"] = "燃燒平原"
   RecipeRadar_Strings["Darkshore"] = "黑海岸"
   RecipeRadar_Strings["Darnassus"] = "達納蘇斯"
   RecipeRadar_Strings["Deadwind Pass"] = "逆風小徑"
   RecipeRadar_Strings["Desolace"] = "淒涼之地"
   RecipeRadar_Strings["Dire Maul"] = "厄運之槌"
   RecipeRadar_Strings["Dun Morogh"] = "丹莫洛"
   RecipeRadar_Strings["Durotar"] = "杜洛塔"
   RecipeRadar_Strings["Duskwood"] = "暮色森林"
   RecipeRadar_Strings["Dustwallow Marsh"] = "塵泥沼澤"
   RecipeRadar_Strings["Eastern Plaguelands"] = "東瘟疫之地"
   RecipeRadar_Strings["Elwynn Forest"] = "艾爾文森林"
   RecipeRadar_Strings["Eversong Woods"] = "永歌森林"
   RecipeRadar_Strings["Felwood"] = "費伍德森林"
   RecipeRadar_Strings["Feralas"] = "菲拉斯"
   RecipeRadar_Strings["Ghostlands"] = "鬼魂之地"
   RecipeRadar_Strings["Gnomeregan"] = "諾姆瑞根"
   RecipeRadar_Strings["Hellfire Peninsula"] = "地獄火半島"
   RecipeRadar_Strings["Hillsbrad Foothills"] = "希爾斯布萊德丘陵"
   RecipeRadar_Strings["Ironforge"] = "鐵爐堡"
   RecipeRadar_Strings["Karazhan"] = "卡拉贊"
   RecipeRadar_Strings["Loch Modan"] = "洛克莫丹"
   RecipeRadar_Strings["Moonglade"] = "月光林地"
   RecipeRadar_Strings["Mulgore"] = "莫高雷"
   RecipeRadar_Strings["Nagrand"] = "納葛蘭"
   RecipeRadar_Strings["Naxxramas"] = "納克薩瑪斯"
   RecipeRadar_Strings["Netherstorm"] = "虛空風暴"
   RecipeRadar_Strings["Old Hillsbrad Foothills"] = "希爾斯布萊德丘陵舊址"
   RecipeRadar_Strings["Orgrimmar"] = "奧格瑪"
   RecipeRadar_Strings["Redridge Mountains"] = "赤脊山"
   RecipeRadar_Strings["Ruins of Ahn'Qiraj"] = "安其拉廢墟"
   RecipeRadar_Strings["Searing Gorge"] = "灼熱峽谷"
   RecipeRadar_Strings["Shadowmoon Valley"] = "影月谷"
   RecipeRadar_Strings["Shattrath City"] = "撒塔斯城"
   RecipeRadar_Strings["Silithus"] = "希利蘇斯"
   RecipeRadar_Strings["Silvermoon City"] = "銀月城"
   RecipeRadar_Strings["Silverpine Forest"] = "銀松森林"
   RecipeRadar_Strings["Stonetalon Mountains"] = "石爪山脈"
   RecipeRadar_Strings["Stormwind City"] = "暴風城"
   RecipeRadar_Strings["Stranglethorn Vale"] = "荊棘谷"
   RecipeRadar_Strings["Swamp of Sorrows"] = "悲傷沼澤"
   RecipeRadar_Strings["Tanaris"] = "塔納利斯"
   RecipeRadar_Strings["Teldrassil"] = "泰達希爾"
   RecipeRadar_Strings["Terokkar Forest"] = "泰洛卡森林"
   RecipeRadar_Strings["The Barrens"] = "貧瘠之地"
   RecipeRadar_Strings["The Exodar"] = "艾克索達"
   RecipeRadar_Strings["The Hinterlands"] = "辛特蘭"
   RecipeRadar_Strings["Thousand Needles"] = "千針石林"
   RecipeRadar_Strings["Thunder Bluff"] = "雷霆崖"
   RecipeRadar_Strings["Tirisfal Glades"] = "提裡斯法林地"
   RecipeRadar_Strings["Undercity"] = "幽暗城"
   RecipeRadar_Strings["Un'Goro Crater"] = "安戈洛環形山"
   RecipeRadar_Strings["Wailing Caverns"] = "哀嚎洞穴"
   RecipeRadar_Strings["Western Plaguelands"] = "西瘟疫之地"
   RecipeRadar_Strings["Westfall"] = "西部荒野"
   RecipeRadar_Strings["Wetlands"] = "濕地"
   RecipeRadar_Strings["Winterspring"] = "冬泉谷"
   RecipeRadar_Strings["Zangarmarsh"] = "贊格沼澤"

   RecipeRadar_Strings["Abigail Shiel"] = "阿比蓋爾·沙伊爾"
   RecipeRadar_Strings["Aendel Windspear"] = "安迪爾·風矛"
   RecipeRadar_Strings["Alchemist Pestlezugg"] = "煉金師匹斯特蘇格"
   RecipeRadar_Strings["Alexandra Bolero"] = "亞歷山卓·波利羅"
   RecipeRadar_Strings["Algernon"] = "奧格諾恩"
   RecipeRadar_Strings["Amy Davenport"] = "艾米·達文波特"
   RecipeRadar_Strings["Andrew Hilbert"] = "安德魯·希爾伯特"
   RecipeRadar_Strings["Androd Fadran"] = "安多德·法德蘭"
   RecipeRadar_Strings["Argent Quartermaster Hasana"] = "銀色黎明軍需官哈薩娜"
   RecipeRadar_Strings["Argent Quartermaster Lightspark"] = "銀色黎明軍需官萊斯巴克"
   RecipeRadar_Strings["Balai Lok'Wein"] = "巴萊·洛克維"
   RecipeRadar_Strings["Bale"] = "拜爾"
   RecipeRadar_Strings["Banalash"] = "巴納拉許"
   RecipeRadar_Strings["Blimo Gadgetspring"] = "布里莫"
   RecipeRadar_Strings["Blixrez Goodstitch"] = "布里克雷茲·古斯提"
   RecipeRadar_Strings["Blizrik Buckshot"] = "布雷茲里克·巴克舒特"
   RecipeRadar_Strings["Bliztik"] = "布里茲提克"
   RecipeRadar_Strings["Bombus Finespindle"] = "伯布斯·鋼軸"
   RecipeRadar_Strings["Borya"] = "博亞"
   RecipeRadar_Strings["Brienna Starglow"] = "布琳娜·星光"
   RecipeRadar_Strings["Bro'kin"] = "布洛金"
   RecipeRadar_Strings["Bronk"] = "布隆克"
   RecipeRadar_Strings["Burbik Gearspanner"] = "巴比克·齒輪"
   RecipeRadar_Strings["Catherine Leland"] = "凱薩琳·利蘭"
   RecipeRadar_Strings["Christoph Jeffcoat"] = "克里斯多夫·傑弗寇特"
   RecipeRadar_Strings["Clyde Ranthal"] = "克萊德·蘭薩爾"
   RecipeRadar_Strings["Constance Brisboise"] = "康斯坦茨·布里斯博埃斯"
   RecipeRadar_Strings["Corporal Bluth"] = "布魯斯下士"
   RecipeRadar_Strings["Cowardly Crosby"] = "怯懦的克羅斯比"
   RecipeRadar_Strings["Crazk Sparks"] = "克拉賽·斯巴克斯"
   RecipeRadar_Strings["Dalria"] = "達利亞"
   RecipeRadar_Strings["Daniel Bartlett"] = "丹尼爾·巴特萊特"
   RecipeRadar_Strings["Danielle Zipstitch"] = "丹尼勒·希普斯迪"
   RecipeRadar_Strings["Darian Singh"] = "達利安·辛格"
   RecipeRadar_Strings["Darnall"] = "旅店老闆達納爾"
   RecipeRadar_Strings["Defias Profiteer"] = "迪菲亞奸商"
   RecipeRadar_Strings["Deneb Walker"] = "德尼布·沃克"
   RecipeRadar_Strings["Derak Nightfall"] = "德拉克·奈特弗"
   RecipeRadar_Strings["Dirge Quikcleave"] = "迪爾格·奎克里弗"
   RecipeRadar_Strings["Drac Roughcut"] = "德拉克·卷刃"
   RecipeRadar_Strings["Drake Lindgren"] = "德拉克·林格雷"
   RecipeRadar_Strings["Drovnar Strongbrew"] = "德魯納·烈酒"
   RecipeRadar_Strings["Edna Mullby"] = "艾德娜·穆比"
   RecipeRadar_Strings["Elynna"] = "愛琳娜"
   RecipeRadar_Strings["Emrul Riknussun"] = "埃姆盧爾·里克努斯"
   RecipeRadar_Strings["Erika Tate"] = "艾瑞卡·塔特"
   RecipeRadar_Strings["Evie Whirlbrew"] = "埃文·維布魯"
   RecipeRadar_Strings["Felicia Doan"] = "菲利希亞·杜安"
   RecipeRadar_Strings["Felika"] = "菲利卡"
   RecipeRadar_Strings["Fradd Swiftgear"] = "弗拉德"
   RecipeRadar_Strings["Fyldan"] = "菲爾丹"
   RecipeRadar_Strings["Gagsprocket"] = "加格斯普吉特"
   RecipeRadar_Strings["Gearcutter Cogspinner"] = "考格斯賓"
   RecipeRadar_Strings["George Candarte"] = "喬治·坎達特"
   RecipeRadar_Strings["Gharash"] = "卡爾拉什"
   RecipeRadar_Strings["Ghok'kah"] = "格魯克卡恩"
   RecipeRadar_Strings["Gikkix"] = "吉科希斯"
   RecipeRadar_Strings["Gina MacGregor"] = "吉娜·馬克葛瑞格"
   RecipeRadar_Strings["Gloria Femmel"] = "格勞瑞亞·菲米爾"
   RecipeRadar_Strings["Glyx Brewright"] = "格里克斯·布魯維特"
   RecipeRadar_Strings["Gnaz Blunderflame"] = "格納茲·槍焰"
   RecipeRadar_Strings["Gretta Ganter"] = "格雷塔·甘特"
   RecipeRadar_Strings["Grimtak"] = "格瑞姆塔克"
   RecipeRadar_Strings["Hagrus"] = "哈格魯斯"
   RecipeRadar_Strings["Hammon Karwn"] = "哈蒙·卡文"
   RecipeRadar_Strings["Harggan"] = "哈爾甘"
   RecipeRadar_Strings["Harklan Moongrove"] = "哈克蘭·月林"
   RecipeRadar_Strings["Harlon Thornguard"] = "哈隆·棘甲"
   RecipeRadar_Strings["Harn Longcast"] = "哈恩·長線"
   RecipeRadar_Strings["Heldan Galesong"] = "海爾丹·風歌"
   RecipeRadar_Strings["Helenia Olden"] = "海倫妮亞·奧德恩"
   RecipeRadar_Strings["Himmik"] = "西米克"
   RecipeRadar_Strings["Hula'mahi"] = "哈拉瑪"
   RecipeRadar_Strings["Innkeeper Fizzgrimble"] = "旅店老闆菲茲格瑞博"
   RecipeRadar_Strings["Jabbey"] = "加貝"
   RecipeRadar_Strings["Jandia"] = "詹迪亞"
   RecipeRadar_Strings["Janet Hommers"] = "詹奈特·霍莫斯"
   RecipeRadar_Strings["Jangdor Swiftstrider"] = "杉多爾·迅蹄"
   RecipeRadar_Strings["Jannos Ironwill"] = "加諾斯·鐵心"
   RecipeRadar_Strings["Jaquilina Dramet"] = "加奎琳娜·德拉米特"
   RecipeRadar_Strings["Jase Farlane"] = "賈斯·法拉恩"
   RecipeRadar_Strings["Jazzrik"] = "加茲里克"
   RecipeRadar_Strings["Jeeda"] = "基達"
   RecipeRadar_Strings["Jennabink Powerseam"] = "吉娜比克·鐵線"
   RecipeRadar_Strings["Jessara Cordell"] = "傑薩拉·考迪爾"
   RecipeRadar_Strings["Jinky Twizzlefixxit"] = "金克·鐵鉤"
   RecipeRadar_Strings["Joseph Moore"] = "約瑟夫·摩爾"
   RecipeRadar_Strings["Jubie Gadgetspring"] = "朱比"
   RecipeRadar_Strings["Jun'ha"] = "祖恩哈"
   RecipeRadar_Strings["Jutak"] = "祖塔克"
   RecipeRadar_Strings["Kaita Deepforge"] = "凱塔·深爐"
   RecipeRadar_Strings["Kalldan Felmoon"] = "卡爾丹·暗月"
   RecipeRadar_Strings["Kania"] = "卡妮亞"
   RecipeRadar_Strings["Keena"] = "基納"
   RecipeRadar_Strings["Kelsey Yance"] = "凱爾希·楊斯"
   RecipeRadar_Strings["Kendor Kabonka"] = "肯多爾·卡邦卡"
   RecipeRadar_Strings["Khara Deepwater"] = "卡拉·深水"
   RecipeRadar_Strings["Kiknikle"] = "吉克尼庫"
   RecipeRadar_Strings["Killian Sanatha"] = "基利恩·薩納森"
   RecipeRadar_Strings["Kilxx"] = "基爾克斯"
   RecipeRadar_Strings["Kireena"] = "基瑞娜"
   RecipeRadar_Strings["Kithas"] = "基薩斯"
   RecipeRadar_Strings["Knaz Blunderflame"] = "克納茲·槍焰"
   RecipeRadar_Strings["Kor'geld"] = "考吉爾德"
   RecipeRadar_Strings["Kriggon Talsone"] = "克雷貢·塔爾松"
   RecipeRadar_Strings["Krinkle Goodsteel"] = "克林科·古德斯迪爾"
   RecipeRadar_Strings["Kulwia"] = "庫爾維亞"
   RecipeRadar_Strings["Kzixx"] = "卡茲克斯"
   RecipeRadar_Strings["Laird"] = "賴爾德"
   RecipeRadar_Strings["Lardan"] = "拉爾丹"
   RecipeRadar_Strings["Leonard Porter"] = "萊納德·波特"
   RecipeRadar_Strings["Lieutenant General Andorov"] = "安多洛夫中將"
   RecipeRadar_Strings["Lilly"] = "莉蕾"
   RecipeRadar_Strings["Lindea Rabonne"] = "林迪·拉波尼"
   RecipeRadar_Strings["Lizbeth Cromwell"] = "莉茲白·克倫威爾"
   RecipeRadar_Strings["Logannas"] = "洛加納斯"
   RecipeRadar_Strings["Lokhtos Darkbargainer"] = "羅克圖斯·暗契"
   RecipeRadar_Strings["Lorelae Wintersong"] = "羅賴爾·冬歌"
   RecipeRadar_Strings["Lucan Cordell"] = "魯坎·考迪爾"
   RecipeRadar_Strings["Magnus Frostwake"] = "瑪格努斯·霜鳴"
   RecipeRadar_Strings["Mahu"] = "曼胡"
   RecipeRadar_Strings["Mallen Swain"] = "瑪林·斯萬"
   RecipeRadar_Strings["Malygen"] = "瑪里甘"
   RecipeRadar_Strings["Maria Lumere"] = "瑪麗亞·盧米爾"
   RecipeRadar_Strings["Martine Tramblay"] = "馬丁·塔布雷"
   RecipeRadar_Strings["Masat T'andr"] = "馬薩特·坦德"
   RecipeRadar_Strings["Master Craftsman Omarion"] = "工匠大師歐瑪利安"
   RecipeRadar_Strings["Mavralyn"] = "馬弗拉林"
   RecipeRadar_Strings["Mazk Snipeshot"] = "瑪茲克·斯奈普沙特"
   RecipeRadar_Strings["Meilosh"] = "梅羅什"
   RecipeRadar_Strings["Micha Yance"] = "米莎·楊斯"
   RecipeRadar_Strings["Millie Gregorian"] = "米利爾·格里高利"
   RecipeRadar_Strings["Mishta"] = "米希塔"
   RecipeRadar_Strings["Montarr"] = "莫塔爾"
   RecipeRadar_Strings["Muuran"] = "莫爾蘭"
   RecipeRadar_Strings["Mythrin'dir"] = "邁斯林迪爾"
   RecipeRadar_Strings["Naal Mistrunner"] = "納爾·迷霧行者"
   RecipeRadar_Strings["Namdo Bizzfizzle"] = "納姆杜"
   RecipeRadar_Strings["Nandar Branson"] = "南達·布拉森"
   RecipeRadar_Strings["Narj Deepslice"] = "納爾基·長刀"
   RecipeRadar_Strings["Narkk"] = "納爾克"
   RecipeRadar_Strings["Nata Dawnstrider"] = "納塔·黎明行者"
   RecipeRadar_Strings["Neal Allen"] = "尼爾·奧雷"
   RecipeRadar_Strings["Nergal"] = "奈爾加"
   RecipeRadar_Strings["Nerrist"] = "耐里斯特"
   RecipeRadar_Strings["Nessa Shadowsong"] = "尼莎·影歌"
   RecipeRadar_Strings["Nina Lightbrew"] = "妮娜·萊特布魯"
   RecipeRadar_Strings["Nioma"] = "尼奧瑪"
   RecipeRadar_Strings["Nyoma"] = "奈歐瑪"
   RecipeRadar_Strings["Ogg'marr"] = "奧克瑪爾"
   RecipeRadar_Strings["Old Man Heming"] = "老人海明威"
   RecipeRadar_Strings["Otho Moji'ko"] = "奧索·莫吉克"
   RecipeRadar_Strings["Outfitter Eric"] = "埃瑞克"
   RecipeRadar_Strings["Plugger Spazzring"] = "普拉格"
   RecipeRadar_Strings["Pratt McGrubben"] = "普拉特·馬克格魯比"
   RecipeRadar_Strings["Qia"] = "琦亞"
   RecipeRadar_Strings["Quartermaster Miranda Breechlock"] = "軍需官米蘭達·布利洛克"
   RecipeRadar_Strings["Ranik"] = "拉尼克"
   RecipeRadar_Strings["Rann Flamespinner"] = "拉恩·火翼"
   RecipeRadar_Strings["Rartar"] = "拉爾塔"
   RecipeRadar_Strings["Rikqiz"] = "雷克奇茲"
   RecipeRadar_Strings["Rin'wosho the Trader"] = "商人林沃斯"
   RecipeRadar_Strings["Rizz Loosebolt"] = "里茲·飛矢"
   RecipeRadar_Strings["Ronald Burch"] = "羅奈爾得·伯奇"
   RecipeRadar_Strings["Saenorion"] = "塞諾里奧"
   RecipeRadar_Strings["Sewa Mistrunner"] = "蘇瓦·迷霧行者"
   RecipeRadar_Strings["Shadi Mistrunner"] = "沙迪·迷霧行者"
   RecipeRadar_Strings["Shandrina"] = "珊蒂瑞亞"
   RecipeRadar_Strings["Shankys"] = "山吉斯"
   RecipeRadar_Strings["Sheendra Tallgrass"] = "希恩德拉·深草"
   RecipeRadar_Strings["Shen'dralar Provisioner"] = "辛德拉聖職者"
   RecipeRadar_Strings["Sheri Zipstitch"] = "舍瑞·希普斯迪"
   RecipeRadar_Strings["Smudge Thunderwood"] = "斯穆德·雷木"
   RecipeRadar_Strings["Soolie Berryfizz"] = "蘇雷·漿泡"
   RecipeRadar_Strings["Sovik"] = "索維克"
   RecipeRadar_Strings["Stuart Fleming"] = "斯圖亞特·弗雷明"
   RecipeRadar_Strings["Sumi"] = "蘇米"
   RecipeRadar_Strings["Super-Seller 680"] = "超級商人680型"
   RecipeRadar_Strings["Tamar"] = "達瑪爾"
   RecipeRadar_Strings["Tansy Puddlefizz"] = "坦斯·泥泡"
   RecipeRadar_Strings["Tarban Hearthgrain"] = "塔班·熟麥"
   RecipeRadar_Strings["Tari'qa"] = "塔里查"
   RecipeRadar_Strings["Thaddeus Webb"] = "薩德烏斯·韋伯"
   RecipeRadar_Strings["Tharynn Bouden"] = "薩瑞恩·博丁"
   RecipeRadar_Strings["Tilli Thistlefuzz"] = "提爾利·草鬚"
   RecipeRadar_Strings["Truk Wildbeard"] = "特魯克·蠻鬃"
   RecipeRadar_Strings["Tunkk"] = "吞克"
   RecipeRadar_Strings["Ulthaan"] = "尤薩恩"
   RecipeRadar_Strings["Ulthir"] = "尤希爾"
   RecipeRadar_Strings["Uthok"] = "尤索克"
   RecipeRadar_Strings["Vaean"] = "維安"
   RecipeRadar_Strings["Valdaron"] = "瓦爾達隆"
   RecipeRadar_Strings["Vargus"] = "瓦古斯"
   RecipeRadar_Strings["Veenix"] = "維尼克斯"
   RecipeRadar_Strings["Vendor-Tron 1000"] = "貿易機器人1000型"
   RecipeRadar_Strings["Vharr"] = "維哈爾"
   RecipeRadar_Strings["Vivianna"] = "薇薇安娜"
   RecipeRadar_Strings["Vizzklick"] = "維茲格里克"
   RecipeRadar_Strings["Wenna Silkbeard"] = "溫納·銀鬚"
   RecipeRadar_Strings["Werg Thickblade"] = "維爾格·厚刃"
   RecipeRadar_Strings["Wik'Tar"] = "維克塔"
   RecipeRadar_Strings["Worb Strongstitch"] = "沃爾布"
   RecipeRadar_Strings["Wrahk"] = "瓦爾克"
   RecipeRadar_Strings["Wulan"] = "烏蘭"
   RecipeRadar_Strings["Wunna Darkmane"] = "溫納·黑鬃"
   RecipeRadar_Strings["Xandar Goodbeard"] = "山達·細鬚"
   RecipeRadar_Strings["Xen'to"] = "克森圖"
   RecipeRadar_Strings["Xizk Goodstitch"] = "希茲克·古斯提"
   RecipeRadar_Strings["Xizzer Fizzbolt"] = "希茲爾·菲茲波特"
   RecipeRadar_Strings["Yonada"] = "猶納達"
   RecipeRadar_Strings["Yuka Screwspigot"] = "尤卡·斯庫比格特"
   RecipeRadar_Strings["Zan Shivsproket"] = "薩恩·刀鏈"
   RecipeRadar_Strings["Zannok Hidepiercer"] = "札諾克"
   RecipeRadar_Strings["Zansoa"] = "詹蘇爾"
   RecipeRadar_Strings["Zarena Cromwind"] = "薩瑞娜·克羅姆溫德"
   RecipeRadar_Strings["Zargh"] = "札爾夫"
   RecipeRadar_Strings["Zixil"] = "吉克希爾"
   RecipeRadar_Strings["Zorbin Fandazzle"] = "索爾賓·范達瑟"

end

