--[[
	ReceipeKnown v0.113b.20400 Localization File
	Localization File
	English Edition
]]

--== Core Functions ==--

-- What seperates the "Recipe" title from the actual name
RecipeKnown_Recipe_Seperator = ": ";
RECIPEKNOWN_GRIM_SEPERATOR = " of ";
RECIPEKNOWN_GRIM_RANK = "Rank";

-- Recipe Types
RECIPEKNOWN_PLANS = "Plans";
RECIPEKNOWN_PATTERN = "Pattern";
RECIPEKNOWN_RECIPE = "Recipe";
RECIPEKNOWN_FORMULA = "Formula";
RECIPEKNOWN_MANUAL = "Manual";
RECIPEKNOWN_SCHEMATIC = "Schematic";
RECIPEKNOWN_DESIGN = "Design";
RECIPEKNOWN_GRIMOIRE = "Grimoire";

-- Profession names
RECIPEKNOWN_ALCHEMY = "Alchemy";
RECIPEKNOWN_BEASTTRAINING = "Beast Training";
RECIPEKNOWN_BLACKSMITHING = "Blacksmithing";
RECIPEKNOWN_COOKING = "Cooking";
RECIPEKNOWN_ENCHANTING = "Enchanting";
RECIPEKNOWN_ENGINEERING = "Engineering";
RECIPEKNOWN_FIRSTAID = "First Aid";
RECIPEKNOWN_FISHING = "Fishing";
RECIPEKNOWN_HERBALISM = "Herbalism";
RECIPEKNOWN_JEWELCRAFTING = "Jewelcrafting";
RECIPEKNOWN_LEATHERWORKING = "Leatherworking";
RECIPEKNOWN_MINING = "Mining";
RECIPEKNOWN_SKINNING = "Skinning";
RECIPEKNOWN_TAILORING = "Tailoring";

-- Error Corrector
-- This is used in case a profession could not be identified.
RECIPEKNOWN_UNKNOWN = "UNKNOWN";
RECIPEKNOWN_NIL = "nil";


-- It seems that some items are listed in the skill lists as one thing, but the recipe is something else. (Capitalization counts!)
-- This array is put here in case items in English and German match, but they don't match in Chinese or Spanish.
-- ["Tradeskill Name"] = "Recipe Name"

RecipeKnown_Translate = {
	["Alarm-O-Bot"] = "Gnomish Alarm-O-Bot",
	["Enchant Weapon - Unholy Weapon"] = "Enchant Weapon - Unholy",
	["Festive Red Dress"] = "Festival Dress",
	["Festive Red Pant Suit"] = "Festival Suit",
	["Heavy Scorpid Gauntlet"] = "Heavy Scorpid Gauntlets",
	["Mechanical Squirrel Box"] = "Mechanical Squirrel",
	["Mithril Headed Trout"] = "Mithril Head Trout",
	["SnowMaster 9000"] = "Snowmaster 9000",
	["Enchant Bracer - Healing Power"] = "Enchant Bracer - Healing",

	-- Transmutes
	["Transmute: Air to Fire"] = "Transmute Air to Fire";
	["Transmute: Arcanite"] = "Transmute Arcanite";
	["Transmute: Earth to Life"] = "Transmute Earth to Life";
	["Transmute: Earth to Water"] = "Transmute Earth to Water";
	["Transmute: Earthstorm Diamond"] = "Transmute Earthstorm Diamond";
	["Transmute: Elemental Fire"] = "Transmute Elemental Fire";
	["Transmute: Fire to Earth"] = "Transmute Fire to Earth";
	["Transmute: Iron to Gold"] = "Transmute Iron to Gold";
	["Transmute: Life to Earth"] = "Transmute Life to Earth";
	["Transmute: Mithril to Truesilver"] = "Transmute Mithril to Truesilver";
	["Transmute: Primal Air to Fire"] = "Transmute Primal Air to Fire";
	["Transmute: Primal Earth to Water"] = "Transmute Primal Earth to Water";
	["Transmute: Primal Fire to Earth"] = "Transmute Primal Fire to Earth";
	["Transmute: Primal Might"] = "Transmute Primal Might";
	["Transmute: Primal Water to Air"] = "Transmute Primal Water to Air";
	["Transmute: Skyfire Diamond"] = "Transmute Skyfire Diamond";
	["Transmute: Undeath to Water"] = "Transmute Undeath to Water";
	["Transmute: Water to Air"] = "Transmute Water to Air";
	["Transmute: Water to Undeath"] = "Transmute Water to Undeath";

	-- Figurines
	["Figurine - Black Diamond Crab"] = "Black Diamond Crab";
	["Figurine - Black Pearl Panther"] = "Black Pearl Panther";
	["Figurine - Dark Iron Scorpid"] = "Dark Iron Scorpid";
	["Figurine - Dawnstone Crab"] = "Dawnstone Crab";
	["Figurine - Emerald Owl"] = "Emerald Owl";
	["Figurine - Felsteel Boar"] = "Felsteel Boar";
	["Figurine - Golden Hare"] = "Golden Hare";
	["Figurine - Jade Owl"] = "Jade Owl";
	["Figurine - Living Ruby Serpent"] = "Living Ruby Serpent";
	["Figurine - Nightseye Panther"] = "Nightseye Panther";
	["Figurine - Ruby Serpent"] = "Ruby Serpent";
	["Figurine - Talasite Owl"] = "Talasite Owl";
	["Figurine - Truesilver Boar"] = "Truesilver Boar";
	["Figurine - Truesilver Crab"] = "Truesilver Crab";

}

RecipeKnown_Grimoire_Translate = {
}

-- Class Books
-- Not Yet Implemented
RECIPEKNOWN_BOOK_DRUID = "Book: ";
RECIPEKNOWN_BOOK_MAGE = "Tome of ";
RECIPEKNOWN_BOOK_PRIEST = "Codex: ";
RECIPEKNOWN_BOOK_ROGUE = "Manual of ";
RECIPEKNOWN_BOOK_WARLOCK = "Grimoire of ";

--== End Core Functions ==--


--== Configuration and Command-lines ==--

-- Modes --
-- Simple Mode
RECIPEKNOWN_SIMPLE = "Simple";
RECIPEKNOWN_SIMPLE_MODE = "Simple Mode";
RECIPEKNOWN_SIMPLE_CMD = "simple";
RECIPEKNOWN_SIMPLE_CMD_HELP = "Puts RecipeKnown into Simple Mode. Colors your recipes and any your alts know.";
RECIPEKNOWN_SIMPLE_CMD_MSG = "RecipeKnown is now operating in Simple Mode.";
RECIPEKNOWN_SIMPLE_TOOLTIP = "This mode colors recipes you know, and recipes any of your alts know, but you don't.";

-- Advanced Mode
RECIPEKNOWN_ADVANCED = "Advanced";
RECIPEKNOWN_ADVANCED_MODE = "Advanced Mode";
RECIPEKNOWN_ADVANCED_MODE_ONLY = "Advanced Mode Only!"
RECIPEKNOWN_ADVANCED_CMD = "advanced";
RECIPEKNOWN_ADVANCED_CMD_HELP = "Runs RecipeKnown in Advanced Mode, allowing for many colors, which means many things.";
RECIPEKNOWN_ADVANCED_CMD_MSG = "RecipeKnown is now operating in Advanced mode.";
RECIPEKNOWN_ADVANCED_TOOLTIP = "This mode allows for many colors to mean many different things!";

-- Selfish Mode
RECIPEKNOWN_SELFISH = "Selfish";
RECIPEKNOWN_SELFISH_MODE = "Selfish Mode";
RECIPEKNOWN_SELFISH_CMD = "selfish";
RECIPEKNOWN_SELFISH_CMD_HELP = "Puts RecipeKnown into Selfish Mode, so only your current character's recipes are colored.";
RECIPEKNOWN_SELFISH_CMD_MSG = "RecipeKnown is now operating in Selfish mode, you greedy pig.";
RECIPEKNOWN_SELFISH_TOOLTIP = "This mode ONLY colors recipes you know.";


-- Colors --
-- Defaults
RECIPEKNOWN_COLOR_DEFAULT = "Default Colors";
RECIPEKNOWN_COLOR_DEFAULT_CMD1 = "color default";
RECIPEKNOWN_COLOR_DEFAULT_CMD2 = "color defaults";
RECIPEKNOWN_COLOR_DEFAULT_CMD_HELP = "Resets the current character's colors to the default settings.";
RECIPEKNOWN_COLOR_DEFAULT_CMD_MSG = "Your colors have been reset to the default colors.";

-- Current Character
RECIPEKNOWN_COLOR_PLAYER = "Current Character's Known Color";
RECIPEKNOWN_COLOR_PLAYER_CMD = "color";
RECIPEKNOWN_COLOR_PLAYER_CMD_HELP = "Provide a HEX color for the Gnomes to color the current character's known recipes with. Example: \"/rk color FF0044\"";
RECIPEKNOWN_COLOR_PLAYER_CMD_MSG = "The known recipe color has been successfully changed to "; -- HEX Color added to the end of this string!
RECIPEKNOWN_COLOR_PLAYER_TOOLTIP = "The color used for Recipes the current character knows.";

-- Alternate Characters
RECIPEKNOWN_COLOR_ALT = "Other Character's Known Color";
RECIPEKNOWN_COLOR_ALT_CMD = "color alt";
RECIPEKNOWN_COLOR_ALT_CMD_HELP = "Provide a HEX color for the Gnomes to color recipes your other characters know, but you don't. Example: \"/rk color alt FF0044\"";
RECIPEKNOWN_COLOR_ALT_CMD_MSG = "The color for your alternate characters has been successfully changed to "; -- HEX Color added to the end of this string!
RECIPEKNOWN_COLOR_ALT_TOOLTIP = "The color used for Recipes your other characters know, but your current character does not.";

-- Recipes known by all with this Trade Skill!
RECIPEKNOWN_COLOR_SHARED = "Shared Known Color";
RECIPEKNOWN_COLOR_SHARED_CMD = "color alt shared";
RECIPEKNOWN_COLOR_SHARED_CMD_HELP = "Provide a HEX color for the Gnomes to color recipes both you and your alts know. Example: \"/rk color alt shared FF0044\"";
RECIPEKNOWN_COLOR_SHARED_CMD_MSG = "The color for a recipe you and an alt both know has been successfully changed to "; -- HEX Color added to the end of this string!
RECIPEKNOWN_COLOR_SHARED_TOOLTIP = "The Known Color used if everyone with this trade skill has this recipe.";


-- Misc
RECIPEKNOWN_GUI_OPEN_HELP = "Simply type \"/rk\" to open the Graphic User Interface!";
RECIPEKNOWN_OVERRIDE_TRUE_CMD = "override on";
RECIPEKNOWN_OVERRIDE_FALSE_CMD = "override off";
RECIPEKNOWN_OVERRIDE_HELP = "\"override\" = Overrides other addons, so they won't take away RecipeKnown's functionality. Values: \"on\" & \"off\". Example: \"/rk override on\"";
RECIPEKNOWN_OVERRIDE_TRUE_CMD_MSG = "RecipeKnown will now override all detected addons.";
RECIPEKNOWN_OVERRIDE_FALSE_CMD_MSG = "RecipeKnown will no longer take control from other addons. Functionality may become impaired while this is set."


--== End Configuation and Command-lines ==--


--== GUI Text ==--
RECIPEKNOWN_PLAYER = "Known by Current Character";
RECIPEKNOWN_ALTS = "Known Only by Other Characters";
RECIPEKNOWN_SHARED = "Known by Everyone";
RECIPEKNOWN_PARTIAL_SHARED = "Known by Player and Some Alts";


--== Errors ==--

RECIPEKNOWN_COLOR_HEXLEN_ERROR = "The color you provided is not the proper length for a Hex Color. Did you add your color to the end of the command?"

--== End Errors ==--