--[[

ReceipeKnown v0.113b.20400
Derived Values File

Translates items from the localization files into arrays used by RecipeKnown.

]]


RecipeKnown_LookFor = {
	RECIPEKNOWN_PLANS,
	RECIPEKNOWN_PATTERN,
	RECIPEKNOWN_RECIPE,
	RECIPEKNOWN_FORMULA,
	RECIPEKNOWN_MANUAL,
	RECIPEKNOWN_SCHEMATIC,
	RECIPEKNOWN_DESIGN,
}

RecipeKnown_Skills = {
	RECIPEKNOWN_ALCHEMY,
	RECIPEKNOWN_BLACKSMITHING,
	RECIPEKNOWN_COOKING,
	RECIPEKNOWN_ENCHANTING,
	RECIPEKNOWN_ENGINEERING,
	RECIPEKNOWN_FIRSTAID,
	RECIPEKNOWN_FISHING,
	RECIPEKNOWN_JEWELCRAFTING,
	RECIPEKNOWN_LEATHERWORKING,
	RECIPEKNOWN_TAILORING,
}

RecipeKnown_JobsAvoid = {
	"UNKNOWN",
	"nil",
	RECIPEKNOWN_UNKNOWN,
	RECIPEKNOWN_NIL,
	RECIPEKNOWN_MINING,
	RECIPEKNOWN_FISHING,
	RECIPEKNOWN_SKINNING,
	RECIPEKNOWN_HERBALISM,
	RECIPEKNOWN_BEASTTRAINING,
}


RecipeKnown_Recipe_Titles = {
	[RECIPEKNOWN_ALCHEMY] = RECIPEKNOWN_FORMULA,
	[RECIPEKNOWN_BLACKSMITHING] = RECIPEKNOWN_PLANS,
	[RECIPEKNOWN_COOKING] = RECIPEKNOWN_RECIPE,
	[RECIPEKNOWN_ENCHANTING] = RECIPEKNOWN_FORMULA,
	[RECIPEKNOWN_ENGINEERING] = RECIPEKNOWN_SCHEMATIC,
	[RECIPEKNOWN_FIRSTAID] = RECIPEKNOWN_MANUAL,
	[RECIPEKNOWN_JEWELCRAFTING] = RECIPEKNOWN_DESIGN,
	[RECIPEKNOWN_LEATHERWORKING] = RECIPEKNOWN_PATTERN,
	[RECIPEKNOWN_TAILORING] = RECIPEKNOWN_PATTERN,
}

RecipeKnown_LookFor_ByLevel = {
	[RECIPEKNOWN_COOKING] = {
		[16072] = "150", 			-- Expert Cookbook
		[27736] = "300", 			-- Master Cookbook
	},
	[RECIPEKNOWN_FIRSTAID] = {
		[16084] = "150",			-- Expert First Aid - Under Wraps
		[22012] = "300",			-- Master First Aid - Doctor in the House
	},
	[RECIPEKNOWN_FISHING] = {
		[16083] = "150",			-- Expert Fishing - The Bass and You
		[27532] = "300",			-- Master Fishing - The Art of Angling
	},
}

RecipeKnown_Class_Books = {
	-- Druid Books (Book of)
	17682,			-- Gift of the Wild
	17683,			-- Gift of the Wild 2
	22146,			-- Gift of the Wild 3
	21294,			-- Healing Touch 11
	21295,			-- Starfire 7
	21296,			-- Rejuvenation 11
	24345,			-- Cower 4
	-- Mage Books (Tome of)
	18600,			-- Arcane Brilliance
	22153,			-- Arcane Brilliance 2
	21214,			-- Frostbolt 11
	21279,			-- Fireball 12
	21280,			-- Arcane Missles 8
	22739,			-- Polymorph: Turtle
	22890, 			-- Frost Ward 5
	22897,			-- Conjure Food 7
	31501,			-- Conjure Food 8
	29550, 			-- Conjure Water 9
	-- Priest Books (Codex:)
	17413,			-- Prayer of Fortitude
	17414, 			-- Prayer of Fortitude 2
	29549,			-- Prayer of Fortitude 3
	21284,			-- Greater Heal 5
	21285,			-- Renew 10
	21287,			-- Prayer of Healing 5
	22393,			-- Prayer of Shadow Protection
	31837,			-- Prayer of Shadow Protection 2
	-- Rogue Books (Handbook of)
	21300,			-- Backstab 9
	21302, 			-- Deadly Poison 5
	21303,			-- Feint 5
	-- Shawman (Tablet of)
	23320,			-- Flame Shock 6
	21291,			-- Healing Wave 10
	21292, 			-- Strength of Earth Totem 5
	21293,			-- Grace of Air Totem 3
	-- Warlock Books (Grimoire of)
	4213,			-- Doom (BoP) Added for later Loot support
	9214,			-- Inferno (BoP) Added for later Loot support
	21281,			-- Shadow Bolt 10
	21282,			-- Immolate 8
	21283,			-- Corruption 7
	22891, 			-- Shadow Ward 4
}



RecipeKnown_Heroic_Key_List = {
	30622,		-- Flamewrought Key (Hellfire Citadel)
	30623,		-- Reservoir Key (Coilfang Reservoir)
	30633,		-- Auchenai Key (Auchindoun)
	30634,		-- Warpforged Key (Tempest Keep)
	30635,		-- Key of Time (Caverns of Time)
}

RecipeKnown_Rank_Conversion = {
	["2"] = " II",
	["3"] = " III",
	["4"] = " IV",
	["5"] = " V",
	["6"] = " VI",
	["7"] = " VII",
	["8"] = " VIII",
	["9"] = " IX",
	["10"] = " X",
	["11"] = " XI",
	["12"] = " XII",
	["13"] = " XIII",
	["14"] = " XIV",
	["15"] = " XV",
}
