--[[
	ReceipeKnown v0.113b.20400
	Author: Kjasi (Steamwheedle Cartel -> Kjasi (Alliance))
	This Version Finished On: 2008-06-06
	Website: http://wowui.incgamers.com/?p=mod&m=3674
	Contact:
		E-mail: alex@aberlefilms.com
]]

-- Globals
RecipeKnown_Title = "RecipeKnown";
local WoW_Version = "20400";
RecipeKnown_Version = "0.113b"
local RecipeKnown_Date = "June 6th, 2008"; -- Release Date
local RecipeKnown_Color1 = "|CFF5555FF";
local RecipeKnown_Color2 = "|CFF55FF55";
local RecipeKnown_debug = 10; -- 10 = Nothing, 0 = Everything.
local RealmName, PlayerName, cTSkill, cTSkillLevel, cTSkillMLevel, classname, AHListGen, currentlink, IFIsMoving = nil;
kred, kblue, kgreen, kared, kablue, kagreen, kasred, kasblue, kasgreen, nred, nblue, ngreen = nil;
hasskill, needskill = {}, {};
local charskill = {};
local RK_SkillData = {};
local RK_ColorData = {};
local RK_Keys = {
	["List"] = {},
	["Index"] = {},
};
RecipeKnown_isLoaded = nil;

local RecipeKnown_Defaults = {
	["Options"] = {
		["Version"] = RecipeKnown_Version;
		["Mode"] = RECIPEKNOWN_SIMPLE;
		["Addon Override"] = True;
	},
	["Colors"] = {
		["Known"] = "00FF00",
		["Alt Known"] = "95FF00",
		["Alt Share Known"] = "65FFFF",
		["Alt Need"] = "00AAAA",
	},
};

local RecipeKnown_Events = {
	"TRADE_SKILL_SHOW",
	"TRADE_SKILL_UPDATE",
	"CRAFT_SHOW",
	"CRAFT_UPDATE",

	-- 4 prev, next is 5.
	-- Onshows

	"AUCTION_HOUSE_SHOW",

	-- 5 Prev, next is 6.
	-- After here, it's events that call the Gnomes to color!

	"AUCTION_ITEM_LIST_UPDATE",
	"AUCTION_BIDDER_LIST_UPDATE",
	"AUCTION_OWNED_LIST_UPDATE",

	"MERCHANT_SHOW",
	"MERCHANT_UPDATE",

	"MAIL_SHOW",
	"MAIL_INBOX_UPDATE",

	"LOOT_OPENED",

	"TRADE_SHOW",
	"TRADE_UPDATE",
	"TRADE_TARGET_ITEM_CHANGED",
	"TRADE_PLAYER_ITEM_CHANGED",

	"BANKFRAME_OPENED",
	"PLAYERBANKSLOTS_CHANGED",
	"PLAYERBANKBAGSLOTS_CHANGED",

	"BAG_OPEN",
	"BAG_UPDATE",

	-- 23 is next
	"PLAYER_LEVEL_UP",

	"CHAT_MSG_SKILL",

	-- 25, For Warlocks.
	"PET_BAR_UPDATE",
};

-- Debug Output
function RecipeKnown_Debug_Msg(msg,level)
	if tonumber(RecipeKnown_debug) <= level then
		DEFAULT_CHAT_FRAME:AddMessage(RecipeKnown_Color1..RecipeKnown_Title.." Debug: |r"..tostring(msg));
	end
end

-- Message Output
function RecipeKnown_Msg(msg)
	DEFAULT_CHAT_FRAME:AddMessage(RecipeKnown_Color1..RecipeKnown_Title.." |r"..tostring(msg));
end

-- Details data goes here (Used for addons like myAddon...)
local RecipeKnown_Details = {
	["myAddon"] = {
		name = RecipeKnown_Title,
		version = RecipeKnown_Version,
		releaseDate = RecipeKnown_Date,
		author = "Kjasi",
		email = "alex@aberlefilms.com",
		website = "http://ui.worldofwar.net/ui.php?id=3674",
		notes = "Colors recipes that you and your alts already know.",
		optionsframe = "RecipeKnownConfigFrame",
		category = MYADDONS_CATEGORY_PROFESSIONS,
	},
};

-- Loading Data
function RecipeKnown_Load()
	-- Single Registers
	this:RegisterEvent("VARIABLES_LOADED");
	-- Event Registers
	for x=1, getn(RecipeKnown_Events),1 do
		this:RegisterEvent(RecipeKnown_Events[x]);
	end

	-- Slash Commands
	SLASH_RecipeKnown1 = "/recipeknown";
	SLASH_RecipeKnown2 = "/rk";
	SlashCmdList["RecipeKnown"] = RecipeKnown_commandline;

	-- myAddOns support
	if (myAddOnsFrame_Register) then
		myAddOnsFrame_Register(RecipeKnown_Details["myAddon"]);
	end

	RealmName = GetCVar("realmName");
	PlayerName = UnitName("player");
	Faction = UnitFactionGroup("player");
	_, classname = UnitClass("player");
end

function RecipeKnown_BuildDatabase()
		if (not RecipeKnown) then
			RecipeKnown = {};
		end
		if (not RecipeKnown_Options) then
			RecipeKnown_Options = RecipeKnown_Defaults["Options"];
			RecipeKnown_Msg("Options Database not found. Generating...");
		end
		if (not RecipeKnown_Colors) then
			RecipeKnown_Colors = RecipeKnown_Defaults["Colors"];
			RecipeKnown_Msg("Colors Database not found. Generating...");
		end
		if (not RecipeKnown_Char) then
			RecipeKnown_Char = {};
			RecipeKnown_Msg("Building Database...");
		end
		if (not RecipeKnown_Char[RealmName]) then
			RecipeKnown_Char[RealmName] = {};
			RecipeKnown_Msg("Adding Realms...");
		end
		if (not RecipeKnown_Char[RealmName][Faction]) then
			RecipeKnown_Char[RealmName][Faction] = {};
			RecipeKnown_Msg("Adding Factions...");
		end
		if (not RecipeKnown_Char[RealmName][Faction][PlayerName]) then
			RecipeKnown_Char[RealmName][Faction][PlayerName] = {};
			RecipeKnown_Msg("Adding Characters...");
		end
		-- This info is for debugging
		if (not RecipeKnown_Char[RealmName][Faction][PlayerName]["~data"]) then
			RecipeKnown_Char[RealmName][Faction][PlayerName]["~data"] = {
				["race"] = UnitRace("player");
				["class"] = UnitClass("player");
				["level"] = tostring(UnitLevel("player"));
			};
		end

		if (not RecipeKnown_ClassSkills) then
			RecipeKnown_ClassSkills = {};
		end
		if (not RecipeKnown_ClassSkills[RealmName]) then
			RecipeKnown_ClassSkills[RealmName] = {};
		end
		if (not RecipeKnown_ClassSkills[RealmName][Faction]) then
			RecipeKnown_ClassSkills[RealmName][Faction] = {};
		end
		if (not RecipeKnown_ClassSkills[RealmName][Faction][classname]) then
			RecipeKnown_ClassSkills[RealmName][Faction][classname] = {};
		end
		if (not RecipeKnown_ClassSkills[RealmName][Faction][classname][PlayerName]) then
			RecipeKnown_ClassSkills[RealmName][Faction][classname][PlayerName] = {};
		end
end

function RecipeKnown_Loaded()
	RecipeKnown_Debug_Msg("Realm Name: "..RealmName,4);
	RecipeKnown_Debug_Msg("Player Name: "..PlayerName,4);

	-- Build Databases if not found.
	RecipeKnown_BuildDatabase();

	RK_SkillData[classname] = {};

	if (RecipeKnown_Options["Version"] < RecipeKnown_Version) then
		RecipeKnown_Update();
	end
	RecipeKnown_CharUpdate();
	RecipeKnown_GetSKills();
	RecipeKnown_GetClassSpells();

	-- Function Copying
 	-- Merchants
		RecipeKnown_MerchantFrame_UpdateMerchantInfo = MerchantFrame_UpdateMerchantInfo;
		MerchantFrame_UpdateMerchantInfo = RecipeKnown_ColorGnomes_Merch;
	-- Auctions
		orig_AuctionFrameBrowse_Update = AuctionFrameBrowse_Update;
		AuctionFrameBrowse_Update = RecipeKnown_ColorGnomes_Auction;
	-- Trading
		RecipeKnown_UpdatePlayerItem = TradeFrame_UpdatePlayerItem;
		RecipeKnown_UpdateTargetItem = TradeFrame_UpdateTargetItem;
		TradeFrame_UpdatePlayerItem = RecipeKnown_ColorGnomes_Trade_Player;
		TradeFrame_UpdateTargetItem = RecipeKnown_ColorGnomes_Trade_Target;
	-- Mailbox
		RecipeKnown_InboxFrame_Update = InboxFrame_Update;
		InboxFrame_Update = RecipeKnown_ColorGnomes_Mail;

	-- Tooltip
		hooksecurefunc(ItemRefTooltip, "SetHyperlink", RecipeKnown_ItemTooltip);		
		hooksecurefunc(ItemRefTooltip, "Hide", RecipeKnown_ItemTooltip_Hide);
		hooksecurefunc(ItemRefTooltip, "StartMoving", RecipeKnown_ItemTooltip_Move);
		hooksecurefunc(ItemRefTooltip, "StopMovingOrSizing", RecipeKnown_ItemTooltip_NoMove);
		hooksecurefunc(GameTooltip, "Show", RecipeKnown_Tooltip);
		hooksecurefunc("GameTooltip_OnHide", RecipeKnown_Tooltip_Hide);

	-- Addon Compatibility
	RecipeKnown_ScanForAddons();

	RecipeKnown_isLoaded = true;
	RecipeKnown_Msg(RecipeKnown_Color2.."v"..RecipeKnown_Version.."."..WoW_Version.." |rLoaded!");
end

function RecipeKnown_Update()
	local RecipeKnown_Options_temp = RecipeKnown_Defaults["Options"];
	for k,v in pairs(RecipeKnown_Options) do
		if (RecipeKnown_Defaults["Options"][k]) then
			RecipeKnown_Options_temp[k] = v;
		end
	end
	RecipeKnown_Options_temp["Version"] = RecipeKnown_Version;
	RecipeKnown_Options = RecipeKnown_Options_temp;
end

function RecipeKnown_CharUpdate()
	local RecipeKnown_Colors_temp = RecipeKnown_Defaults["Colors"];
	for k,v in pairs(RecipeKnown_Colors) do
		if (RecipeKnown_Defaults["Options"][k]) then
			RecipeKnown_Colors_temp[k] = v;
		end
	end
	RecipeKnown_Colors = RecipeKnown_Colors_temp;
	RecipeKnown_Char[RealmName][Faction][PlayerName]["~data"]["level"] = tostring(UnitLevel("player"));
end

function RecipeKnown_ScanForAddons()
	if (RecipeKnown_Options["Addon Override"] == True) then

	--Auction Filter Plus Emerald
		if (afp_OriginalAuctionFrameBrowse_Update) then
			RecipeKnown_Debug_Msg("Detected: AuctionFilterPlus |cff3fcf26[Emerald]|r",9)
			afp_OriginalAuctionFrameBrowse_Update = AuctionFrameBrowse_Update;
			AuctionFrameBrowse_Update = RecipeKnown_ColorGnomes_Auction;
		end
	--RecipeBook
		if (RBAuction_AuctionFrameBrowse_Update) then
			RecipeKnown_Debug_Msg("Detected: RecipeBook",9)
			RBAuction_AuctionFrameBrowse_Update = AuctionFrameBrowse_Update;
			AuctionFrameBrowse_Update = RecipeKnown_ColorGnomes_Auction;
		end

	end
end


function RecipeKnown_EventScan(event,arg1)
	if event == "VARIABLES_LOADED" then
		RecipeKnown_Loaded();
	else
		-- Update the Skillist.
		for x=1,4 do -- getn(RecipeKnown_Events)
			if (event == RecipeKnown_Events[x]) then
				RecipeKnown_GetSKills();
			end
		end
		-- Update Tradeskills
		for x=1,2 do
			if (event == RecipeKnown_Events[x]) then
				RecipeKnown_Debug_Msg("Updating Trade Skills...",3);
				RecipeKnown_update_skill();
			end
		end
		-- Update Crafting Skills
		for x=3,4 do
			if (event == RecipeKnown_Events[x]) then
				RecipeKnown_Debug_Msg("Updating Craft Skills...",3);
				RecipeKnown_update_Cskill();
			end
		end
		-- Scan Auction Items
		for x=6,6 do
			if (event == RecipeKnown_Events[x]) then
				AHListGen = true;
				RecipeKnown_ScanForAddons();
				RecipeKnown_GetNum_Auction();
			end
		end
		if (event == "AUCTION_HOUSE_CLOSED") then
			AHListGen = nil;
		end
		-- Scan Merchant Items
		for x=9,10 do
			if (event == RecipeKnown_Events[x]) then
				RecipeKnown_GetNum_Merch();
			end
		end

		-- Scan Mailbox Items
		for x=11,12 do
			if (event == RecipeKnown_Events[x]) then
			--	RecipeKnown_GetNum_Mail();
			end
		end

		-- Scan Trade Items
		for x=16,16 do
			if (event == RecipeKnown_Events[x]) then
				hasskill = {};
				needskill = {};
				thesecolors = {};
			--	TradeFrame_UpdateTargetItem(arg1);
			--	RecipeKnown_GetNum_Trade();
			end
		end
		for x=17,17 do
			if (event == RecipeKnown_Events[x]) then
				hasskill = {};
				needskill = {};
				thesecolors = {};
			--	TradeFrame_UpdatePlayerItem(arg1);
			--	RecipeKnown_GetNum_Trade();
			end
		end

		-- Bag Update
		if (event == RecipeKnown_Events[22]) then
		end

		-- Character Level Up Info
		for x=23,23 do
			if (event == RecipeKnown_Events[x]) then
				RecipeKnown_Char[RealmName][Faction][PlayerName]["~data"]["level"] = tostring(arg1);
			end
		end

		for x=25,25 do
			if (event == RecipeKnown_Events[x]) then
				RecipeKnown_WarlockPetSkills();
			end
		end

		RecipeKnown_IfShowMerch();
		RecipeKnown_IfShowAuct();
	end

end

function RecipeKnown_IfShowMerch()
	if (MerchantFrame:IsVisible()) then
		RecipeKnown_ColorGnomes_Merch();
	end
end

function RecipeKnown_IfShowAuct()
	if (AuctionFrame:IsVisible()) and (AHListGen == true) then
		-- Scan for Auctioneer Advanced
		if ((AucAdvanced) and (AucAdvanced.Scan)) then
			-- If Not Scanning
			if (AucAdvanced.Scan.IsScanning() == false or nil) then
				RecipeKnown_ColorGnomes_Auction();
			end
		-- Scan for Auctioneer Classic
		elseif ((Auctioneer) and (Auctioneer.API)) then
			if (Auctioneer.API.RequestAuctionScan() ~= false) then
				RecipeKnown_ColorGnomes_Auction();
			end
		else
			RecipeKnown_ColorGnomes_Auction();
		end
	end
end

function RecipeKnown_Tooltip_Hide()
	RecipeKnownTooltip:ClearLines();
	RecipeKnownTooltip:Hide();
end
function RecipeKnown_ItemTooltip_Hide()
	currentlink = nil;
	RecipeKnownItemTooltip:ClearLines();
	RecipeKnownItemTooltip:Hide();
end
function RecipeKnown_ItemTooltip_Move()
	IFIsMoving = 1;
	RecipeKnown_ItemTooltip(nil,currentlink)
end
function RecipeKnown_ItemTooltip_NoMove()
	RecipeKnown_ItemTooltip(nil,currentlink)
	IFIsMoving = nil;
end

function RecipeKnown_GetTooltipInfo(itemName)
	-- Gather data & Generate message
	local Msg1 = "RecipeKnown Report\n";

	local knowncount, canknow, willknow = 0,0,0;
	for player,v in pairs(RecipeKnown_Char[RealmName][Faction]) do
		for ts,v in pairs(RecipeKnown_Char[RealmName][Faction][player]) do
			if (ts ~= "~data") then
				for recipe,v in pairs(RecipeKnown_Char[RealmName][Faction][player][ts]) do
					if (RecipeKnown_Recipe_Titles[ts] ~= nil) then
						if (RecipeKnown_Translate[recipe]) then recipe = RecipeKnown_Translate[recipe]; end
						local thisr = RecipeKnown_Recipe_Titles[ts]..RecipeKnown_Recipe_Seperator..recipe;
						if (itemName == thisr) then
							if (knowncount == 0) then
								Msg1 = Msg1.."\nThis "..strlower(RecipeKnown_Recipe_Titles[ts]).." is already known by:\n";
							end
							Msg1 = Msg1.."    "..player.." ("..RecipeKnown_Char[RealmName][Faction][player][ts]["~data"]["current"].."/"..RecipeKnown_Char[RealmName][Faction][player][ts]["~data"]["max"]..")\n";
							knowncount = knowncount + 1;							
						end
					end
				end
			end

		end
	end
	return Msg1, knowncount, canknow, willknow;
end

function RecipeKnown_Tooltip()
	-- Get the current item information
	local ttip, rttip = GameTooltip, RecipeKnownTooltip;
	local itemName, ItemLink = GameTooltip:GetItem();
	if (not itemName) then
		return;
	end

	local Msg1, knowncount = RecipeKnown_GetTooltipInfo(itemName);

	-- Create, attach and show!
	if (knowncount > 0) then
		local Anch, AnchP;

		rttip:SetOwner(ttip,"ANCHOR_NONE");
		rttip:SetScale(UIParent:GetEffectiveScale()-0.10)
		rttip:AddLine(Msg1, 1,1,1);

		-- MUST come after full generation of the tooltip, else GetWidth won't return the proper size.
		if (ttip:GetRight()+rttip:GetWidth() > UIParent:GetRight()) then
			Anch = "TOPRIGHT";
			AnchP = "TOPLEFT";
		else
			Anch = "TOPLEFT";
			AnchP = "TOPRIGHT";
		end
		
		rttip:SetPoint(Anch, ttip, AnchP);
		rttip:Show()
	end
end

function RecipeKnown_ItemTooltip(table, link)
	if (not link) then
		RecipeKnown_ItemTooltip_Hide();
	elseif (link == currentlink and IFIsMoving ~= 1) then
		RecipeKnown_ItemTooltip_Hide();
	else
		-- Get the current item information
		local ttip, rttip = ItemRefTooltip, RecipeKnownItemTooltip;
		local itemName, ItemLink = GetItemInfo(link);
		if (not itemName) then
			return;
		end

		local Msg1, knowncount = RecipeKnown_GetTooltipInfo(itemName);

		-- Create, attach and show!
		if (knowncount > 0) then
			currentlink = link;
			local Anch, AnchP;

			rttip:SetOwner(ttip,"ANCHOR_NONE");
			rttip:SetScale(UIParent:GetEffectiveScale()-0.10)
			rttip:AddLine(Msg1, 1,1,1);

			-- MUST come after full generation of the tooltip, else GetWidth won't return the proper size.
			if (ttip:GetRight()+rttip:GetWidth() > UIParent:GetRight()) then
				Anch = "TOPRIGHT";
				AnchP = "TOPLEFT";
			else
				Anch = "TOPLEFT";
				AnchP = "TOPRIGHT";
			end
		
			rttip:SetPoint(Anch, ttip, AnchP);
			rttip:Show()
		end
	end
end


function RecipeKnown_ScanFor(itemid)
	if not itemid then
		return;
	end

	local name, scan_type, item;
	item = GetItemInfo(itemid);

	-- Scan for recipes
	for r=1,getn(RecipeKnown_LookFor) do
		local looking = RecipeKnown_LookFor[r]..RecipeKnown_Recipe_Seperator;
		if string.find(item, looking) then
			RecipeKnown_Debug_Msg(RecipeKnown_LookFor[r].." item found!",2);
			_,_,name = string.find(item, looking.."(.+)");
			RecipeKnown_Debug_Msg("Item: \""..name.."\"",3);
			scan_type = RecipeKnown_LookFor[r];
			return name, scan_type;
		end
	end

	-- Scan for Profession Books
	RecipeKnown_Debug_Msg("Scanning through books that up your level...",4);
	for ts,v in pairs(RecipeKnown_LookFor_ByLevel) do
		RecipeKnown_Debug_Msg("Transversing though "..ts..", starting with "..item..".",3);
		for book,lvl in pairs(RecipeKnown_LookFor_ByLevel[ts]) do
			local looking = book;
			if (tonumber(itemid) == tonumber(book)) then
				RecipeKnown_Debug_Msg("Match found for itemid: "..itemid,3);
				_,_,name = string.find(item, "(.+)");
				scan_type = "book";
				return name, scan_type;
			end
		end
	end

	return
end

function RecipeKnown_Scan4Keys()
	RecipeKnown_Debug_Msg("Registering Heroic Keys...",9);
	RK_Keys["List"] = {};
	local plvl = UnitLevel("player");
	if (plvl > 60) then
		-- RK_Keys
		for slot=1,GetContainerNumSlots(-2) do
			if (GetContainerItemLink(-2,slot)) then
				local itemid = RecipeKnown_GetItemID(GetContainerItemLink(-2,slot));
				for x=1,#(RecipeKnown_Heroic_Key_List) do
					RecipeKnown_Debug_Msg("ItemID: "..itemid.." VS Heroic KeyID: "..RecipeKnown_Heroic_Key_List[x],4)
					if (tonumber(itemid) == tonumber(RecipeKnown_Heroic_Key_List[x])) then
						RK_Keys["List"][tostring(itemid)] = 1;
						RecipeKnown_Debug_Msg("Heroic Key Found: "..GetItemInfo(itemid)..", Recorded: "..tostring(RK_Keys["List"][itemid]),8);
					end
				end
			end
		end
	end
	local num = 0;
	for k,v in pairs(RK_Keys["List"]) do
		num = num + 1;
	end
	RecipeKnown_Debug_Msg("Heroic Keys found: "..num,9);
end

function RecipeKnown_update_skill()
	cTSkill, cTSkillLevel, cTSkillMLevel = GetTradeSkillLine();
	cTSkill = tostring(cTSkill);
	RecipeKnown_Debug_Msg("Found tradeskill "..cTSkill.." at level "..cTSkillLevel.." with a max of "..cTSkillMLevel,3);
	local avoid = false;
	for nj=0, getn(RecipeKnown_JobsAvoid) do
		if (cTSkill == RecipeKnown_JobsAvoid[nj]) then
			avoid = true;
			RecipeKnown_Debug_Msg("Avoiding Job: "..RecipeKnown_JobsAvoid[nj],4);
		end
	end
	if (avoid == false) then
		if (not RecipeKnown_Char[RealmName][Faction][PlayerName][cTSkill]) then
			RecipeKnown_Char[RealmName][Faction][PlayerName][cTSkill] = {}
		end
		if (not RecipeKnown_Char[RealmName][Faction][PlayerName][cTSkill]["~data"]) then
			RecipeKnown_Char[RealmName][Faction][PlayerName][cTSkill]["~data"] = {
				["current"] = cTSkillLevel,
				["max"] = cTSkillMLevel,
			};
		end
		RecipeKnown_Char[RealmName][Faction][PlayerName][cTSkill]["~data"]["current"] = cTSkillLevel;
		RecipeKnown_Char[RealmName][Faction][PlayerName][cTSkill]["~data"]["max"] = cTSkillMLevel;
		RecipeKnown_GetSKills();

		RecipeKnown_builditemlist(cTSkill);
	end
end

function RecipeKnown_update_Cskill()
	cTSkill, cTSkillLevel, cTSkillMLevel = GetCraftDisplaySkillLine();
	cTSkill = tostring(cTSkill);
	RecipeKnown_Debug_Msg("Found craftskill "..tostring(cTSkill).." at level "..cTSkillLevel.." with a max of "..cTSkillMLevel,3);
	local avoid = false;
	for nj=0, getn(RecipeKnown_JobsAvoid) do
		if (cTSkill == RecipeKnown_JobsAvoid[nj]) then
			avoid = true;
			RecipeKnown_Debug_Msg("Avoiding Job: "..RecipeKnown_JobsAvoid[nj],4);
		end
	end
	if (avoid == false) then
		if (not RecipeKnown_Char[RealmName][Faction][PlayerName][cTSkill]) then
			RecipeKnown_Char[RealmName][Faction][PlayerName][cTSkill] = {}
		end
		if (not RecipeKnown_Char[RealmName][Faction][PlayerName][cTSkill]["~data"]) then
			RecipeKnown_Char[RealmName][Faction][PlayerName][cTSkill]["~data"] = {
				["current"] = cTSkillLevel,
				["max"] = cTSkillMLevel,
			};
		end
		RecipeKnown_Char[RealmName][Faction][PlayerName][cTSkill]["~data"]["current"] = cTSkillLevel;
		RecipeKnown_Char[RealmName][Faction][PlayerName][cTSkill]["~data"]["max"] = cTSkillMLevel;
		RecipeKnown_GetSKills();

		RecipeKnown_buildcraftlist(cTSkill);
	end
end

function RecipeKnown_builditemlist(TSkill)
	for i=GetFirstTradeSkill(),GetNumTradeSkills() do
		local tsname, tstype, _, _ = GetTradeSkillInfo(i);
		if (tstype ~= "header") then
			if (tsname ~= nil) then
				RecipeKnown_Char[RealmName][Faction][PlayerName][TSkill][tsname] = 1;
				RecipeKnown_Debug_Msg("Adding "..tsname.." to the list of known skills for "..TSkill..".",6);
			end
		end
	end
end

function RecipeKnown_buildcraftlist(TSkill)
	for i=1,GetNumCrafts() do
		local tsname, _, tstype, _, _ = GetCraftInfo(i);
		if (tstype ~= "header") then
			if (tsname ~= nil) then
				RecipeKnown_Char[RealmName][Faction][PlayerName][TSkill][tsname] = 1;
				RecipeKnown_Debug_Msg("Adding "..tsname.." to the list of known skills for "..TSkill..".",6);
			end
		end
	end
end

function RecipeKnown_GetSKills()
	RecipeKnown_Debug_Msg("Running GetSkills...",9);
	local n = GetNumSkillLines();
	for i=1,n do
		local name, _, _, rank, _, modifier, skillmax = GetSkillLineInfo(i);
		for s=1, getn(RecipeKnown_Skills) do
			RecipeKnown_Debug_Msg("Compairing \""..name.."\" with \""..RecipeKnown_Skills[s].."\".",1);
			if (name == RecipeKnown_Skills[s]) then
				RecipeKnown_Debug_Msg("Match found! Adding the following skill: "..name,7);
				RecipeKnown_BuildDatabase();
				if (not RecipeKnown_Char[RealmName][Faction][PlayerName][name]) then
					RecipeKnown_Char[RealmName][Faction][PlayerName][name] = {}
				end
				if (not RecipeKnown_Char[RealmName][Faction][PlayerName][name]["~data"]) then
					RecipeKnown_Char[RealmName][Faction][PlayerName][name]["~data"] = {
						["current"] = rank,
						["max"] = skillmax,
					};
				end
			end
		end
	end
end

-- Seperate so that changes to the colors will appear instantly.
function RecipeKnown_ColorBox()
	kred = tonumber(strsub(RecipeKnown_Colors["Known"],1,2), 16)/255;
	kblue = tonumber(strsub(RecipeKnown_Colors["Known"],3,4), 16)/255;
	kgreen = tonumber(strsub(RecipeKnown_Colors["Known"],5,6), 16)/255;
	kared = tonumber(strsub(RecipeKnown_Colors["Alt Known"],1,2), 16)/255;
	kablue = tonumber(strsub(RecipeKnown_Colors["Alt Known"],3,4), 16)/255;
	kagreen = tonumber(strsub(RecipeKnown_Colors["Alt Known"],5,6), 16)/255;
	kasred = tonumber(strsub(RecipeKnown_Colors["Alt Share Known"],1,2), 16)/255;
	kasblue = tonumber(strsub(RecipeKnown_Colors["Alt Share Known"],3,4), 16)/255;
	kasgreen = tonumber(strsub(RecipeKnown_Colors["Alt Share Known"],5,6), 16)/255;
	nred = tonumber(strsub(RecipeKnown_Colors["Alt Need"],1,2), 16)/255;
	nblue = tonumber(strsub(RecipeKnown_Colors["Alt Need"],3,4), 16)/255;
	ngreen = tonumber(strsub(RecipeKnown_Colors["Alt Need"],5,6), 16)/255;
end

function RecipeKnown_GetItemID(itemlink)
	if (itemlink == nil) then
		return;
	end
	local Item_Name, Item_Link, _, _, _, _, _, _, _, _ = GetItemInfo(itemlink);

	if (Item_Link == nil) then
		RecipeKnown_Msg("The link provided was either invalid, or referenced an item your system has not yet seen.");
	else
		local justItemId = string.gsub(Item_Link,".-\124H([^\124]*)\124h.*", "%1");
		Item_Link = strsub(justItemId, string.find(justItemId,":")+1, string.find(justItemId,":",string.find(justItemId,":")+3)-1)
		Item_Link2 = gsub(Item_Link, "\124", "\124\124");
		RecipeKnown_Debug_Msg("GetItemID is Returning a value of \""..Item_Link2.."\".",1);
		return Item_Link2;
	end
end

function RecipeKnown_WarlockPetSkills()
	RecipeKnown_Debug_Msg("Scanning Warlock Pet Skills...",5);
	local hasPetSpells, petToken = HasPetSpells();
	if (hasPetSpells ~= nil) and (petToken == "DEMON") then
		local i = 1;
		local name, rank = GetSpellName(i, BOOKTYPE_PET)
		while name ~= nil do
			RecipeKnown_Debug_Msg("Pre: Name = "..tostring(name)..", Rank = "..tostring(rank),8);
			_,_,rank = string.find(rank, "(%d)")
			if rank == nil then rank = "0" end;
			if GetLocale() ~= "enUS" then 
				-- strip all spaces and non-alphanumeric chars --
				name = string.gsub( name, "[^%w]", "" );
				name = string.upper(name);
				-- translate to grimoire name --
				if (RecipeKnown_Grimoire_Translate[name]) then
					name = RecipeKnown_Grimoire_Translate[name];
				end
				-- strip all spaces and non-alphanumeric chars --
				name = string.gsub( name, "[^%w]", "" );
				name = string.upper(name);
				-- insert into DB --
			end
			if not RK_SkillData["WarlockPet"] then
				RK_SkillData["WarlockPet"] = {};
			end
			RK_SkillData["WarlockPet"][tostring(name)] = tonumber(rank);
			RecipeKnown_Debug_Msg("Post: Name = "..name..", Rank = "..tostring(RK_SkillData["WarlockPet"][name]),8);

			i = i + 1;
			name, rank = GetSpellName(i, BOOKTYPE_PET);
		end
		RecipeKnown_Debug_Msg("Number of Warlock Skills Found: "..getn(RK_SkillData["WarlockPet"]),5);
	else
		return;
	end
end

function RecipeKnown_GetClassSpells()
	UpdateSpells();
	RecipeKnown_BuildDatabase();

	-- Start at 2 to avoid the "General" tab.
	for i=2, MAX_SKILLLINE_TABS do
		local name, _, offset, numSpells = GetSpellTabInfo(i);
		if not name then
			break;
		end
		for s=offset+1, offset+numSpells do
			local spell, rank = GetSpellName(s, BOOKTYPE_SPELL);
			if (not spell) or (rank == nil) then
				break;
			end

			if (not RecipeKnown_ClassSkills[RealmName][Faction][classname][PlayerName][spell]) then
				RecipeKnown_ClassSkills[RealmName][Faction][classname][PlayerName][spell] = {}
			end

			RecipeKnown_ClassSkills[RealmName][Faction][classname][PlayerName][spell][rank] = 1;
		end

	end
end

function RecipeKnown_ScanItems(total, getinfo, getlink, type, start)
	hasskill = {};
	needskill = {};
	RK_Keys["Index"] = {};
	RK_ColorData[classname] = {};
	RecipeKnown_Debug_Msg("Total: "..tostring(total),4);

	if start == nil then
		start = 1;
	end

	if (classname == "WARLOCK") then
		RecipeKnown_WarlockPetSkills();
		if not RK_ColorData["WarlockPet"] then
			RK_ColorData["WarlockPet"] = {}
		end
	end

	RecipeKnown_GetClassSpells();
	RecipeKnown_Scan4Keys();

	-- First Pass
	-- Goes through everything to see what needs to be colored.
	for i=start, total do
		RecipeKnown_Debug_Msg("Beginning Scanning Working on slot "..i.."...",3);
		local i2 = tostring(i);
		local itemid = nil;
		if type == "auction" then
			RecipeKnown_Debug_Msg("Scan type set to Auction.", 7);
			item = getinfo("list", i);
			local link = getlink("list", i);
			itemid = RecipeKnown_GetItemID(link);
			
		else
			RecipeKnown_Debug_Msg("Scan type set to Other.", 7);
			item = getinfo(i);
			itemid = RecipeKnown_GetItemID(getlink(i));
		end

		if (item == nil) then
			RecipeKnown_Debug_Msg("Item in slot "..i2.." was detected as nil. Stopping Script.", 9);
			return;
		end
		if (itemid == nil) then
			RecipeKnown_Debug_Msg("ItemID for "..tostring(item).." detected as Nil. Stopping Script.", 9);
			return;
		end
		RecipeKnown_Debug_Msg("Detected ItemID: "..itemid,5)

		local name, scan_type = RecipeKnown_ScanFor(itemid);

		-- Warlock Grimoire List
		if (classname == "WARLOCK") then
			RecipeKnown_Debug_Msg("Character is a Warlock. Scanning for Grimoires...",3);
			if string.find(item, RECIPEKNOWN_GRIMOIRE) then
				local gname, rank;
				if GetLocale() ~= "enUS" then 
					-- strip all non-alphanumeric chars except space, ( and ) --
					item = string.gsub( item, "[^%w%s%d%(%)]", "" );
					-- parse parts --
				end
				text = RECIPEKNOWN_GRIMOIRE..RECIPEKNOWN_GRIM_SEPERATOR;
				_,_,gname, rank = string.find(item, text.."([%w%s]+) %("..RECIPEKNOWN_GRIM_RANK.." (%d+)%)");
				if (gname == nil) then
					_,_,gname = string.find(item, text.."([%w%s]+)") end;
				if (GetLocale() ~= "enUS") then 
					-- strip all spaces and non-alphanumeric chars --
					gname = string.gsub( gname, "[^%w]", "" );
					gname = string.upper(gname);
				end
				if (gname ~= nil) and (RK_SkillData["WarlockPet"][gname] ~= nil) then
					RecipeKnown_Debug_Msg("Grimoire Name = "..tostring(gname)..", Rank = "..tostring(rank),4);
					if rank ~= nil then
						rank = tonumber(rank)
					end;
					if (rank == nil) or (rank <= RK_SkillData["WarlockPet"][gname]) then
						RecipeKnown_Debug_Msg("Found match for \""..gname.." (Rank "..tostring(rank)..")\"!", 6);
						scan_type = "grimoire";
						RK_ColorData["WarlockPet"][i2] = {
							["c_red"] = kred,
							["c_blue"] = kblue,
							["c_green"] = kgreen,
						}
					end
				end
			end
		end
		-- Class Spells
		for id=1, getn(RecipeKnown_Class_Books) do
			if (tonumber(RecipeKnown_Class_Books[id]) == tonumber(itemid)) then
				for spell,v in pairs(RecipeKnown_ClassSkills[RealmName][Faction][classname][PlayerName]) do
					for r,v in pairs(RecipeKnown_ClassSkills[RealmName][Faction][classname][PlayerName][spell]) do
						if (getglobal("RECIPEKNOWN_BOOK_"..classname)) then
							local CH = getglobal("RECIPEKNOWN_BOOK_"..classname);
							local vminus = gsub(r, RECIPEKNOWN_GRIM_RANK, "");
							local rank = RecipeKnown_Rank_Conversion[strtrim(vminus)];
							if (rank == nil) then
								rank = "";
							end
							if (CH..spell..rank == item) then
								RK_ColorData[classname][i2] = {
									["c_red"] = kred,
									["c_blue"] = kblue,
									["c_green"] = kgreen,
								}
							end
						end
					end
				end
			end
		end
		-- Keys
		local num = 0;
		for k,v in pairs(RK_Keys["List"]) do
			num = num + 1;
		end
		if (num > 0) then
			for key=1, #(RecipeKnown_Heroic_Key_List) do
				if (tonumber(RecipeKnown_Heroic_Key_List[key]) == tonumber(itemid)) then
					for mykey,v in pairs(RK_Keys["List"]) do
						if (tonumber(mykey) == tonumber(itemid)) then
							RecipeKnown_Debug_Msg("Vendor Selling Key: "..GetItemInfo(itemid),9)
							RK_Keys["Index"][i2] = {
								["c_red"] = kred,
								["c_blue"] = kblue,
								["c_green"] = kgreen,
							}
						end
					end
				end
			end
		end

		-- Second Pass
		-- Determine if we have this item.
		if name ~= nil then
			for p, v in pairs(RecipeKnown_Char[RealmName][Faction]) do
				if (RecipeKnown_Options["Mode"] == RECIPEKNOWN_SELFISH) then
					p = PlayerName;
				end
				RecipeKnown_Debug_Msg("Scanning "..p.."'s professions...",3);
				for t, v in pairs(RecipeKnown_Char[RealmName][Faction][p]) do
					RecipeKnown_Debug_Msg("Scanning Profession "..t.."...",1);
					if not charskill[t] then
						charskill[t] = {};
					end
					charskill[t][p] = 1;
					if (scan_type == "book") then
						for ts,v in pairs(RecipeKnown_LookFor_ByLevel) do
							if (ts == t) then
								for bookid,lvl in pairs(RecipeKnown_LookFor_ByLevel[ts]) do
									if tonumber(lvl) < tonumber(RecipeKnown_Char[RealmName][Faction][p][t]["~data"]["max"]) then
										if (not hasskill[name]) then
											hasskill[name] = {
												["type"] = "Book",
												["skill"] = t,
												["slots"] = {},
												["players"] = {},
											};
										end
										hasskill[name]["players"][p] = 1;
										hasskill[name]["slots"][i2] = 1;
										RecipeKnown_Debug_Msg("Book \""..name.."\" discovered for "..p.."!",4);
--[[									elseif tonumber(lvl) <= tonumber(RecipeKnown_Char[RealmName][Faction][p][t]["~data"]["current"] then
										if (not needskill[name]) then
											needskill[name] = {
												["type"] = "Book",
												["skill"] = t,
												["slots"] = {},
												["players"] = {},
											};
										end
										needskill[name]["players"][p] = 1;
										needskill[name]["slots"][i2] = 1;
]]
									end
								end
							end
						end
					else
						for d, v in pairs(RecipeKnown_Char[RealmName][Faction][p][t]) do
							RecipeKnown_Debug_Msg("Checking to see if "..d.." is the same as "..name.."...",0);
							if (RecipeKnown_Translate[d]) then
								d = RecipeKnown_Translate[d];
							end
							if (d == name) then
								if (not hasskill[d]) then
									RecipeKnown_Debug_Msg("hasskill["..d.."] does not exist!.",4);
									hasskill[d] = {
										["type"] = scan_type,
										["skill"] = t,
										["slots"] = {},
										["players"] = {},
									};
								end
								hasskill[d]["players"][p] = 1;
								hasskill[d]["slots"][i2] = 1;
								RecipeKnown_Debug_Msg(scan_type.." \""..d.."\" discovered for "..p.."!",4);
							end
						end
					end
				end
			end
		end
	end
	RecipeKnown_Debug_Msg("Number of skill items found to color: "..#(hasskill),5);
	RecipeKnown_Debug_Msg("Number of class items found to color: "..#(RK_ColorData[classname]),5);
	if (classname == "WARLOCK") then
		RecipeKnown_Debug_Msg("Number of warlock pet items found to color: "..#(RK_ColorData["WarlockPet"]),5);
	end
end

function RecipeKnown_ColorGnomes(total, itemsperpage, thisframepage, itemname, colorlist, offset, type)
	RecipeKnown_ColorBox();

	RecipeKnown_Debug_Msg("Items per Page: "..tostring(itemsperpage),4);

	local name;
	local has_alt = false;
	local thesecolors = {};

	-- Third Pass
	-- Determine the Colors
	for i=1, itemsperpage do
		local i2 = tostring(i);
		local index = offset + i;
		local index2 = tostring(index);
		if (index <= total) then
			RecipeKnown_Debug_Msg("Offset = "..offset..", Index = "..index,4);
			for name, v in pairs(hasskill) do
				name = tostring(name);
				if (hasskill[name]["slots"][index2]) then
					for p, v in pairs(hasskill[name]["players"]) do
						RecipeKnown_Debug_Msg("P = "..p..", PlayerName = "..PlayerName,3);
						if (p ~= PlayerName) then
							has_alt = true;
							thesecolors[index2] = {
								["c_red"] = kared,
								["c_blue"] = kablue,
								["c_green"] = kagreen,
							};
							RecipeKnown_Debug_Msg(p.." knows the "..hasskill[name]["type"].." for "..name..".",4);
						end
					end
					if (hasskill[name]["players"][PlayerName]) then
						RecipeKnown_Debug_Msg("PlayerName = "..PlayerName,3);
						if (RecipeKnown_Options["Mode"] == RECIPEKNOWN_ADVANCED) then
							if (has_alt == true) then
								thesecolors[index2] = {
									["c_red"] = kasred,
									["c_blue"] = kasblue,
									["c_green"] = kasgreen,
								};
							else
								thesecolors[index2] = {
									["c_red"] = kred,
									["c_blue"] = kblue,
									["c_green"] = kgreen,
								};
							end
						else
							thesecolors[index2] = {
								["c_red"] = kred,
								["c_blue"] = kblue,
								["c_green"] = kgreen,
							};
						end
						RecipeKnown_Debug_Msg("You already know the "..hasskill[name]["type"].." for "..name..".",4);
					end
				end
			end
		end
	end

	-- Fourth Pass
	-- Colors what needs to be colored.
	for i=1, itemsperpage do
		local index = offset + i;
		local index2 = tostring(index);
		RecipeKnown_Debug_Msg("Offset = "..offset..", Index = "..index,1);
		if (index <= total) then
			for name, v in pairs(hasskill) do
				if (hasskill[name]["slots"][index2]) then
					for itm=1, getn(itemname) do
						local itemButton = itemname[itm]..i;
						RecipeKnown_Debug_Msg("Colorlist Count: "..getn(colorlist),2);
						for btn=1, getn(colorlist) do
							local thisitem = getglobal(itemButton..colorlist[btn]);
							if (thisitem ~= nil) then
								RecipeKnown_Debug_Msg("Colorlist: Coloring item "..btn.." of "..getn(colorlist)..", "..itemButton..colorlist[btn]..".",1);
								thisitem:SetVertexColor(thesecolors[index2]["c_red"],thesecolors[index2]["c_blue"],thesecolors[index2]["c_green"]);
							end
						end
					end
				end
			end
			for class,v in pairs(RK_ColorData) do
				if (RK_ColorData[class][index2]) then
					for itm=1, getn(itemname) do
						local itemButton = itemname[itm]..i;
						RecipeKnown_Debug_Msg("Colorlist Count: "..getn(colorlist),2);
						for btn=1, getn(colorlist) do
							local thisitem = getglobal(itemButton..colorlist[btn]);
							if (thisitem ~= nil) then
								RecipeKnown_Debug_Msg("Colorlist: Coloring item "..btn.." of "..getn(colorlist)..", "..itemButton..colorlist[btn]..".",1);
								thisitem:SetVertexColor(RK_ColorData[class][index2]["c_red"],RK_ColorData[class][index2]["c_blue"],RK_ColorData[class][index2]["c_green"]);
							end
						end
					end
				end
			end
			for key,v in pairs(RK_Keys) do
				if (RK_Keys["Index"][index2]) then
					for itm=1, getn(itemname) do
						local itemButton = itemname[itm]..i;
						RecipeKnown_Debug_Msg("Colorlist Count: "..getn(colorlist),2);
						for btn=1, getn(colorlist) do
							local thisitem = getglobal(itemButton..colorlist[btn]);
							if (thisitem ~= nil) then
								RecipeKnown_Debug_Msg("Colorlist: Coloring item "..btn.." of "..getn(colorlist)..", "..itemButton..colorlist[btn]..".",1);
								thisitem:SetVertexColor(RK_Keys["Index"][index2]["c_red"],RK_Keys["Index"][index2]["c_blue"],RK_Keys["Index"][index2]["c_green"]);
							end
						end
					end
				end
			end
		end
	end
end


--==Color Gnome Jobs==--
-- For doing Specific things for each pathway

-- For Merchants

function RecipeKnown_GetNum_Merch()
	RecipeKnown_Debug_Msg("Getting the number of Merchant Items to color...",5);

	local total = GetMerchantNumItems();
	local getinfo = GetMerchantItemInfo;
	local getlink = GetMerchantItemLink;
	RecipeKnown_ScanItems(total, getinfo, getlink, "merchant");
end

function RecipeKnown_ColorGnomes_Merch()
	local total, itemsperpage, thisframepage, itemname, colorlist, offset;

	-- Update function
	RecipeKnown_MerchantFrame_UpdateMerchantInfo();
	RecipeKnown_GetNum_Merch();

	total = GetMerchantNumItems();
	itemsperpage = MERCHANT_ITEMS_PER_PAGE;
	thisframepage = MerchantFrame.page;
	itemname = {
		"MerchantItem",
	}
	colorlist = {
		"NameFrame",
		"SlotTexture",
		"ItemButtonIconTexture",
		"ItemButtonNormalTexture",
	}

	offset = (thisframepage - 1) * itemsperpage;

	RecipeKnown_ColorGnomes(total, itemsperpage, thisframepage, itemname, colorlist, offset, "merchant");
end

-- For Auctions
function RecipeKnown_GetNum_Auction()
	RecipeKnown_Debug_Msg("Getting the number of Auction Items to color...",5);

	local numBatchAuctions, totalAuctions = GetNumAuctionItems("list");

	local total = totalAuctions;
	local getinfo = GetAuctionItemInfo;
	local getlink = GetAuctionItemLink;
	RecipeKnown_ScanItems(total, getinfo, getlink, "auction");
end

function RecipeKnown_ColorGnomes_Auction()
	RecipeKnown_Debug_Msg("Starting Coloring Sequence for the Auction House...",5);

	-- Original code from here on out!
	local total, itemsperpage, thisframepage, itemname, colorlist, offset;

	offset = FauxScrollFrame_GetOffset(BrowseScrollFrame);

	-- Call original Auctionhouse Update
	if (afp_OriginalAuctionFrameBrowse_Update) then
		afp_AuctionFrameBrowse_Update();
	else
		orig_AuctionFrameBrowse_Update();
	end

	local numBatchAuctions, totalAuctions = GetNumAuctionItems("list");

	total = totalAuctions;
	itemsperpage = NUM_BROWSE_TO_DISPLAY;
	thisframepage = AuctionFrameBrowse.page;
	itemname = {
		"BrowseButton",
	--	"BidButton",
	--	"AuctionsButton",
	}	
	colorlist = {
		"ItemIconTexture",
	--	"ItemNormalTexture",
	--	"Highlight",
	}

	RecipeKnown_Debug_Msg("Offset: "..offset,2)

	RecipeKnown_ColorGnomes(total, itemsperpage, thisframepage, itemname, colorlist, offset, "auction");
end


-- For Trade Window
function RecipeKnown_GetNum_Trade()
	RecipeKnown_Debug_Msg("Getting the number of Trade Items to color...",5);

	local total = MAX_TRADABLE_ITEMS;
	local getinfo = GetTradePlayerItemInfo;
	local getlink = GetTradeTargetItemLink;
	RecipeKnown_ScanItems(total, getinfo, getlink, "trade", arg1);
end

function RecipeKnown_ColorGnomes_Trade_Target(i)
	RecipeKnown_Debug_Msg("Running Trade Target...",5);
	-- Call original Auctionhouse Update
	RecipeKnown_UpdateTargetItem(i);

--[[	-- Original code from here on out!
	local total, itemsperpage, thisframepage, itemname, colorlist, offset;

	total = MAX_TRADABLE_ITEMS;
	itemsperpage = MAX_TRADABLE_ITEMS;
	thisframepage = 0;
	itemname = {
		"TradeRecipientItem",
	}	
	colorlist = {
		"IconTexture",
		"NormalTexture",
		"NameFrame",
		"SlotTexture",
	}

	offset = 0;
	RecipeKnown_Debug_Msg("Offset: "..offset,2)

	RecipeKnown_ColorGnomes(total, itemsperpage, thisframepage, itemname, colorlist, offset, "trade");
]]
end

function RecipeKnown_ColorGnomes_Trade_Player(i)
	RecipeKnown_Debug_Msg("Running Trade Player...",5);
	-- Call original Auctionhouse Update
	RecipeKnown_UpdatePlayerItem(i);

--[[
	-- Original code from here on out!
	local total, itemsperpage, thisframepage, itemname, colorlist, offset;

	total = MAX_TRADABLE_ITEMS;
	itemsperpage = MAX_TRADABLE_ITEMS;
	thisframepage = 0;
	itemname = {
		"TradePlayerItem",
	}	
	colorlist = {
		"IconTexture",
		"NormalTexture",
		"NameFrame",
		"SlotTexture",
	}

	offset = 0;
	RecipeKnown_Debug_Msg("Offset: "..offset,2)

	RecipeKnown_ColorGnomes(total, itemsperpage, thisframepage, itemname, colorlist, offset, "trade");
]]
end

-- For Mail Window
function RecipeKnown_GetNum_Mail()
	RecipeKnown_Debug_Msg("Getting the number of Mail Items to color...",5);
	
	local total, getinfo;

	total = GetInboxNumItems();
	getinfo = GetInboxHeaderInfo;
	getlink = GetInboxItemLink;
	RecipeKnown_ScanItems(total, getinfo, getlink, "mail");
end

function RecipeKnown_ColorGnomes_Mail()
	-- Call original Auctionhouse Update
	RecipeKnown_InboxFrame_Update();

--[[	-- Original code from here on out!
	local total, itemsperpage, thisframepage, itemname, colorlist, offset;

	total = GetInboxNumItems();
	itemsperpage = INBOXITEMS_TO_DISPLAY;
	thisframepage = InboxFrame.pageNum;
	itemname = {
		"MailItem",
	}	
	colorlist = {
		"ButtonSlot",
		"ButtonIcon",
	}

	offset = itemsperpage * (thisframepage - 1);
	RecipeKnown_Debug_Msg("Offset: "..offset,2)

	RecipeKnown_ColorGnomes(total, itemsperpage, thisframepage, itemname, colorlist, offset, "mail");
]]
end


-- Command Line handler
function RecipeKnown_commandline(cmd)
	if (cmd == "help") then
		RecipeKnown_Msg("\"\" = "..RECIPEKNOWN_GUI_OPEN_HELP);
		RecipeKnown_Msg("\""..RECIPEKNOWN_SIMPLE_CMD.."\" = "..RECIPEKNOWN_SIMPLE_CMD_HELP);
		RecipeKnown_Msg("\""..RECIPEKNOWN_ADVANCED_CMD.."\" = "..RECIPEKNOWN_ADVANCED_CMD_HELP);
		RecipeKnown_Msg("\""..RECIPEKNOWN_SELFISH_CMD.."\" = "..RECIPEKNOWN_SELFISH_CMD_HELP);
		RecipeKnown_Msg("\""..RECIPEKNOWN_COLOR_DEFAULT_CMD1.."\" = "..RECIPEKNOWN_COLOR_DEFAULT_CMD_HELP);
		RecipeKnown_Msg("\""..RECIPEKNOWN_COLOR_PLAYER_CMD.."\" = "..RECIPEKNOWN_COLOR_PLAYER_CMD_HELP);
		RecipeKnown_Msg("\""..RECIPEKNOWN_COLOR_ALT_CMD.."\" = "..RECIPEKNOWN_COLOR_ALT_CMD_HELP);
		RecipeKnown_Msg("\""..RECIPEKNOWN_COLOR_SHARED_CMD.."\" = "..RECIPEKNOWN_COLOR_SHARED_CMD_HELP.." "..RecipeKnown_Color2..RECIPEKNOWN_ADVANCED_MODE_ONLY);
		RecipeKnown_Msg(RECIPEKNOWN_OVERRIDE_HELP);
	elseif (cmd == RECIPEKNOWN_COLOR_DEFAULT_CMD1) then
		RecipeKnown_Colors = RecipeKnown_Defaults["Colors"];
		RecipeKnown_Msg(RECIPEKNOWN_COLOR_DEFAULT_CMD_MSG);
	elseif (cmd == RECIPEKNOWN_COLOR_DEFAULT_CMD2) then
		RecipeKnown_Colors = RecipeKnown_Defaults["Colors"];
		RecipeKnown_Msg(RECIPEKNOWN_COLOR_DEFAULT_CMD_MSG);
	elseif (cmd == RECIPEKNOWN_SIMPLE_CMD) then
		RecipeKnown_Options["Mode"] = RECIPEKNOWN_SIMPLE;
		RecipeKnown_Msg(RECIPEKNOWN_SIMPLE_CMD_MSG);
	elseif (cmd == RECIPEKNOWN_SELFISH_CMD) then
		RecipeKnown_Options["Mode"] = RECIPEKNOWN_SELFISH;
		RecipeKnown_Msg(RECIPEKNOWN_SELFISH_CMD_MSG);
	elseif (cmd == RECIPEKNOWN_ADVANCED_CMD) then
		RecipeKnown_Options["Mode"] = RECIPEKNOWN_ADVANCED;
		RecipeKnown_Msg(RECIPEKNOWN_ADVANCED_CMD_MSG);
	elseif (cmd == RECIPEKNOWN_OVERRIDE_TRUE_CMD) then
		RecipeKnown_Options["Override"] = True;
		RecipeKnown_Msg(RECIPEKNOWN_OVERRIDE_TRUE_CMD_MSG);
	elseif (cmd == RECIPEKNOWN_OVERRIDE_FALSE_CMD) then
		RecipeKnown_Options["Override"] = False;
		RecipeKnown_Msg(RECIPEKNOWN_OVERRIDE_FALSE_CMD_MSG);
	elseif (strsub(cmd,1,strlen(RECIPEKNOWN_COLOR_SHARED_CMD)) == RECIPEKNOWN_COLOR_SHARED_CMD) then
		newcolor = strsub(cmd,strlen(RECIPEKNOWN_COLOR_SHARED_CMD)+2);
		RecipeKnown_Debug_Msg("\""..newcolor.."\" length = "..strlen(newcolor),2);
		if (strlen(newcolor) == 6) then
			RecipeKnown_Colors["Alt Share Known"] = newcolor;
			RecipeKnown_Msg(RECIPEKNOWN_COLOR_SHARED_CMD_MSG..newcolor);
		else
			RecipeKnown_Msg(RECIPEKNOWN_COLOR_HEXLEN_ERROR);
		end
	elseif (strsub(cmd,1,strlen(RECIPEKNOWN_COLOR_ALT_CMD)) == RECIPEKNOWN_COLOR_ALT_CMD) then
		newcolor = strsub(cmd,strlen(RECIPEKNOWN_COLOR_ALT_CMD)+2);
		RecipeKnown_Debug_Msg("\""..newcolor.."\" length = "..strlen(newcolor),2);
		if (strlen(newcolor) == 6) then
			RecipeKnown_Colors["Alt Known"] = newcolor;
			RecipeKnown_Msg(RECIPEKNOWN_COLOR_ALT_CMD_MSG..newcolor);
		else
			RecipeKnown_Msg(RECIPEKNOWN_COLOR_HEXLEN_ERROR);
		end
	elseif (strsub(cmd,1,strlen(RECIPEKNOWN_COLOR_PLAYER_CMD)) == RECIPEKNOWN_COLOR_PLAYER_CMD) then
		newcolor = strsub(cmd,strlen(RECIPEKNOWN_COLOR_PLAYER_CMD)+2);
		RecipeKnown_Debug_Msg("\""..newcolor.."\" length = "..strlen(newcolor),2);
		if (strlen(newcolor) == 6) then
			RecipeKnown_Colors["Known"] = newcolor;
			RecipeKnown_Msg(RECIPEKNOWN_COLOR_PLAYER_CMD_MSG..newcolor);
		else
			RecipeKnown_Msg(RECIPEKNOWN_COLOR_HEXLEN_ERROR);
		end
	elseif (cmd == "debug off") then
		RecipeKnown_debug = 10;
		RecipeKnown_Msg("Debug Messages will no longer be displayed.")
	elseif (strsub(cmd,1,5) == "debug") then
		RecipeKnown_debug = tonumber(strsub(cmd,7));
		RecipeKnown_Msg("Debug messages level "..tostring(RecipeKnown_debug).." and over will now be displayed.");
	else
		if (RecipeKnownConfigFrame:IsVisible()) then
			RecipeKnownConfigFrame:Hide();
		else
			RecipeKnownConfigFrame:Show();
		end
	end
end