--[[
	ReceipeKnown v0.113b.20400
	Config Commands file
]]

local Parent = RecipeKnownConfigFrame;

function RecipeKnown_Config_Open()
	tinsert(UISpecialFrames, "RecipeKnownConfigFrame")
	UIPanelWindows["RecipeKnownConfigFrame"] = nil

	-- Set Config Text

	-- Unchanging
	-- This text stays the same, no matter what localization it's running on.
	RecipeKnownConfigFrameTitle:SetText(RecipeKnown_Title.." v"..RecipeKnown_Version);

	-- Localized
	RecipeKnownConfigFrameModeNameSimple:SetText(RECIPEKNOWN_SIMPLE_MODE);
	RecipeKnownConfigFrameModeNameAdvanced:SetText(RECIPEKNOWN_ADVANCED_MODE);
	RecipeKnownConfigFrameModeNameSelfish:SetText(RECIPEKNOWN_SELFISH_MODE);
end

function RecipeKnown_Config_Show()
	if (RecipeKnown_Options["Mode"] == RECIPEKNOWN_ADVANCED) then
		RecipeKnown_SetMode_OnClick(2);
	elseif (RecipeKnown_Options["Mode"] == RECIPEKNOWN_SELFISH) then
		RecipeKnown_SetMode_OnClick(3);
	else
		RecipeKnown_SetMode_OnClick(1);
		RecipeKnown_ColorSimple();
	end
end


function RecipeKnown_SetMode_OnClick(id)
	if (id == 1) then
		RecipeKnownConfigFrameModeSimple:SetChecked(1);
		RecipeKnownConfigFrameModeAdvanced:SetChecked(nil);
		RecipeKnownConfigFrameModeSelfish:SetChecked(nil);
		RecipeKnown_Options["Mode"] = RECIPEKNOWN_SIMPLE;
		RecipeKnownConfigFrameSimple:Hide();
		RecipeKnown_Debug_Msg("Now in Simple Mode.",9)
	elseif (id == 2) then
		RecipeKnownConfigFrameModeSimple:SetChecked(nil);
		RecipeKnownConfigFrameModeAdvanced:SetChecked(1);
		RecipeKnownConfigFrameModeSelfish:SetChecked(nil);
		RecipeKnownConfigFrameSimple:Hide();
		RecipeKnown_Options["Mode"] = RECIPEKNOWN_ADVANCED;
		RecipeKnown_Debug_Msg("Now in Advanced Mode.",9)
	else
		RecipeKnownConfigFrameModeSimple:SetChecked(nil);
		RecipeKnownConfigFrameModeAdvanced:SetChecked(nil);
		RecipeKnownConfigFrameModeSelfish:SetChecked(1);
		RecipeKnownConfigFrameSimple:Hide();
		RecipeKnown_Options["Mode"] = RECIPEKNOWN_SELFISH;
		RecipeKnown_Debug_Msg("Now in Selfish Mode.",9)
	end
end

function RecipeKnown_ColorSimple()
	RecipeKnown_ColorBox();
	-- RecipeKnownConfigFrameSimplePlayerTestButton1:SetVertexColor(kred,kgreen,kblue);
end

function RecipeKnown_ChangeColor_OnClick(id)

end